% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag-parser.R
\name{tag_parsers}
\alias{tag_parsers}
\alias{tag_value}
\alias{tag_inherit}
\alias{tag_name}
\alias{tag_two_part}
\alias{tag_name_description}
\alias{tag_words}
\alias{tag_words_line}
\alias{tag_toggle}
\alias{tag_code}
\alias{tag_examples}
\alias{tag_markdown}
\alias{tag_markdown_with_sections}
\title{Parse tags}
\usage{
tag_value(x)

tag_inherit(x)

tag_name(x)

tag_two_part(x, first, second, required = TRUE, markdown = TRUE)

tag_name_description(x)

tag_words(x, min = 0, max = Inf)

tag_words_line(x)

tag_toggle(x)

tag_code(x)

tag_examples(x)

tag_markdown(x)

tag_markdown_with_sections(x)
}
\arguments{
\item{x}{A \link{roxy_tag} object to parse}

\item{first, second}{Name of first and second parts of two part tags}

\item{required}{Is the second part required (TRUE) or can it be blank
(FALSE)?}

\item{markdown}{Should the second part be parsed as markdown?}

\item{min, max}{Minimum and maximum number of words}
}
\value{
A \link{roxy_tag} object with the \code{val} field set to the parsed value.
}
\description{
These functions parse the \code{raw} tag value, convert a string into a richer R
object and storing it in \code{val}, or provide an informative warning and
returning \code{NULL}.
}
\section{New tag}{

To create a new \verb{@mytag} define \code{roxy_tag_parse.roxy_tag_mytag()}. It should
either call one of the functions here, or directly set \code{x$val}.
}

\keyword{internal}
