% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_group_by.R
\name{tidy_group_by}
\alias{tidy_group_by}
\alias{auto_group_by}
\title{Group results by selected columns}
\usage{
tidy_group_by(
  x,
  group_by = auto_group_by(),
  group_labels = NULL,
  model = tidy_get_model(x)
)

auto_group_by()
}
\arguments{
\item{x}{(\code{data.frame})\cr
A tidy tibble as produced by \verb{tidy_*()} functions.}

\item{group_by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
One or several variables to group by. Default is \code{auto_group_by()}.
Use \code{NULL} to force ungrouping.}

\item{group_labels}{(\code{string})\cr
An optional named vector of custom term labels.}

\item{model}{(a model object, e.g. \code{glm})\cr
The corresponding model, if not attached to \code{x}.}
}
\value{
The \code{x} tibble with, if relevant, an additional \code{group_by} column.
}
\description{
Indicates that results should be grouped. By default
(\code{group_by = auto_group_by()}), results will be grouped according to the
\code{y.level} column (for multinomial models) or the \code{component} column
(multi-components models) if any.
}
\examples{
\dontshow{if (require("nnet")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mod <- multinom(Species ~ Petal.Width + Petal.Length, data = iris)
mod |> tidy_and_attach() |> tidy_group_by()

mod |>
  tidy_and_attach() |>
  tidy_group_by(group_labels = c(versicolor = "harlequin blueflag"))

mod |> tidy_and_attach() |> tidy_group_by(group_by = NULL)

mod |>
  tidy_and_attach() |>
  tidy_identify_variables() |>
  tidy_group_by(group_by = variable)
\dontshow{\}) # examplesIf}
}
\seealso{
Other tidy_helpers: 
\code{\link{tidy_add_coefficients_type}()},
\code{\link{tidy_add_contrasts}()},
\code{\link{tidy_add_estimate_to_reference_rows}()},
\code{\link{tidy_add_header_rows}()},
\code{\link{tidy_add_n}()},
\code{\link{tidy_add_pairwise_contrasts}()},
\code{\link{tidy_add_reference_rows}()},
\code{\link{tidy_add_term_labels}()},
\code{\link{tidy_add_variable_labels}()},
\code{\link{tidy_attach_model}()},
\code{\link{tidy_disambiguate_terms}()},
\code{\link{tidy_identify_variables}()},
\code{\link{tidy_plus_plus}()},
\code{\link{tidy_remove_intercept}()},
\code{\link{tidy_select_variables}()}
}
\concept{tidy_helpers}
