 /*
 * Copyright (c) 2021_2025 Symas Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above
 *   copyright notice, this list of conditions and the following disclaimer
 *   in the documentation and/or other materials provided with the
 *   distribution.
 * * Neither the name of the Symas Corporation nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ENCODINGS_H_
#define _ENCODINGS_H_

enum cbl_encoding_t {
  no_encoding_e,
  custom_encoding_e,
  iconv_1026_e,
  iconv_1046_e,
  iconv_1047_e,
  iconv_10646_1_1993_e,
  iconv_437_e,
  iconv_500V1_e,
  iconv_500_e,
  iconv_850_e,
  iconv_851_e,
  iconv_852_e,
  iconv_855_e,
  iconv_856_e,
  iconv_857_e,
  iconv_858_e,
  iconv_860_e,
  iconv_861_e,
  iconv_862_e,
  iconv_863_e,
  iconv_864_e,
  iconv_865_e,
  iconv_866NAV_e,
  iconv_866_e,
  iconv_869_e,
  iconv_874_e,
  iconv_8859_1_e,
  iconv_8859_2_e,
  iconv_8859_3_e,
  iconv_8859_4_e,
  iconv_8859_5_e,
  iconv_8859_6_e,
  iconv_8859_7_e,
  iconv_8859_8_e,
  iconv_8859_9_e,
  iconv_904_e,
  iconv_ANSI_X3_110_1983_e,
  iconv_ANSI_X3_110_e,
  iconv_ANSI_X3_4_1968_e,
  iconv_ANSI_X3_4_1986_e,
  iconv_ANSI_X3_4_e,
  iconv_ARABIC7_e,
  iconv_ARABIC_e,
  iconv_ARMSCII8_e,
  iconv_ARMSCII_8_e,
  iconv_ASCII_e, // STANDARD_1 (beware of ascii_e in libgcobol.cc)
  iconv_ASMO_449_e,
  iconv_ASMO_708_e,
  iconv_BALTIC_e,
  iconv_BIG5HKSCS_e,
  iconv_BIG5_HKSCS_e,
  iconv_BIG5_e,
  iconv_BIGFIVE_e,
  iconv_BIG_5_e,
  iconv_BIG_FIVE_e,
  iconv_BRF_e,
  iconv_BS_4730_e,
  iconv_CA_e,
  iconv_CN_BIG5_e,
  iconv_CN_GB_e,
  iconv_CN_e,
  iconv_CP037_e,
  iconv_CP038_e,
  iconv_CP10007_e,
  iconv_CP1004_e,
  iconv_CP1008_e,
  iconv_CP1025_e,
  iconv_CP1026_e,
  iconv_CP1046_e,
  iconv_CP1047_e,
  iconv_CP1070_e,
  iconv_CP1079_e,
  iconv_CP1081_e,
  iconv_CP1084_e,
  iconv_CP1089_e,
  iconv_CP1097_e,
  iconv_CP1112_e,
  iconv_CP1122_e,
  iconv_CP1123_e,
  iconv_CP1124_e,
  iconv_CP1125_e,
  iconv_CP1129_e,
  iconv_CP1130_e,
  iconv_CP1132_e,
  iconv_CP1133_e,
  iconv_CP1137_e,
  iconv_CP1140_e,
  iconv_CP1141_e,
  iconv_CP1142_e,
  iconv_CP1143_e,
  iconv_CP1144_e,
  iconv_CP1145_e,
  iconv_CP1146_e,
  iconv_CP1147_e,
  iconv_CP1148_e,
  iconv_CP1149_e,
  iconv_CP1153_e,
  iconv_CP1154_e,
  iconv_CP1155_e,
  iconv_CP1156_e,
  iconv_CP1157_e,
  iconv_CP1158_e,
  iconv_CP1160_e,
  iconv_CP1161_e,
  iconv_CP1162_e,
  iconv_CP1163_e,
  iconv_CP1164_e,
  iconv_CP1166_e,
  iconv_CP1167_e,
  iconv_CP1250_e,
  iconv_CP1251_e,
  iconv_CP1252_e,
  iconv_CP1253_e,
  iconv_CP1254_e,
  iconv_CP1255_e,
  iconv_CP1256_e,
  iconv_CP1257_e,
  iconv_CP1258_e,
  iconv_CP12712_e,
  iconv_CP1282_e,
  iconv_CP1361_e,
  iconv_CP1364_e,
  iconv_CP1371_e,
  iconv_CP1388_e,
  iconv_CP1390_e,
  iconv_CP1399_e,
  iconv_CP16804_e,
  iconv_CP273_e,
  iconv_CP274_e,
  iconv_CP275_e,
  iconv_CP278_e,
  iconv_CP280_e,
  iconv_CP281_e,
  iconv_CP282_e,
  iconv_CP284_e,
  iconv_CP285_e,
  iconv_CP290_e,
  iconv_CP297_e,
  iconv_CP367_e,
  iconv_CP420_e,
  iconv_CP423_e,
  iconv_CP424_e,
  iconv_CP437_e,
  iconv_CP4517_e,
  iconv_CP4899_e,
  iconv_CP4909_e,
  iconv_CP4971_e,
  iconv_CP500_e,
  iconv_CP5347_e,
  iconv_CP737_e,
  iconv_CP770_e,
  iconv_CP771_e,
  iconv_CP772_e,
  iconv_CP773_e,
  iconv_CP774_e,
  iconv_CP775_e,
  iconv_CP803_e,
  iconv_CP813_e,
  iconv_CP819_e,
  iconv_CP850_e,
  iconv_CP851_e,
  iconv_CP852_e,
  iconv_CP855_e,
  iconv_CP856_e,
  iconv_CP857_e,
  iconv_CP858_e,
  iconv_CP860_e,
  iconv_CP861_e,
  iconv_CP862_e,
  iconv_CP863_e,
  iconv_CP864_e,
  iconv_CP865_e,
  iconv_CP866NAV_e,
  iconv_CP866_e,
  iconv_CP868_e,
  iconv_CP869_e,
  iconv_CP870_e,
  iconv_CP871_e,
  iconv_CP874_e,
  iconv_CP875_e,
  iconv_CP880_e,
  iconv_CP891_e,
  iconv_CP901_e,
  iconv_CP902_e,
  iconv_CP9030_e,
  iconv_CP903_e,
  iconv_CP904_e,
  iconv_CP905_e,
  iconv_CP9066_e,
  iconv_CP912_e,
  iconv_CP915_e,
  iconv_CP916_e,
  iconv_CP918_e,
  iconv_CP920_e,
  iconv_CP921_e,
  iconv_CP922_e,
  iconv_CP930_e,
  iconv_CP932_e,
  iconv_CP933_e,
  iconv_CP935_e,
  iconv_CP936_e,
  iconv_CP937_e,
  iconv_CP939_e,
  iconv_CP9448_e,
  iconv_CP949_e,
  iconv_CP950_e,
  iconv_CPIBM861_e,
  iconv_CP_AR_e,
  iconv_CP_GR_e,
  iconv_CP_HU_e,
  iconv_CSA7_1_e,
  iconv_CSA7_2_e,
  iconv_CSASCII_e,
  iconv_CSA_T500_1983_e,
  iconv_CSA_T500_e,
  iconv_CSA_Z243_419851_e,
  iconv_CSA_Z243_419852_e,
  iconv_CSA_Z243_4_1985_1_e,
  iconv_CSA_Z243_4_1985_2_e,
  iconv_CSDECMCS_e,
  iconv_CSEBCDICATDEA_e,
  iconv_CSEBCDICATDE_e,
  iconv_CSEBCDICCAFR_e,
  iconv_CSEBCDICDKNOA_e,
  iconv_CSEBCDICDKNO_e,
  iconv_CSEBCDICESA_e,
  iconv_CSEBCDICESS_e,
  iconv_CSEBCDICES_e,
  iconv_CSEBCDICFISEA_e,
  iconv_CSEBCDICFISE_e,
  iconv_CSEBCDICFR_e,
  iconv_CSEBCDICIT_e,
  iconv_CSEBCDICPT_e,
  iconv_CSEBCDICUK_e,
  iconv_CSEBCDICUS_e,
  iconv_CSEUCKR_e,
  iconv_CSEUCPKDFMTJAPANESE_e,
  iconv_CSGB2312_e,
  iconv_CSHPROMAN8_e,
  iconv_CSIBM037_e,
  iconv_CSIBM038_e,
  iconv_CSIBM1008_e,
  iconv_CSIBM1025_e,
  iconv_CSIBM1026_e,
  iconv_CSIBM1097_e,
  iconv_CSIBM1112_e,
  iconv_CSIBM1122_e,
  iconv_CSIBM1123_e,
  iconv_CSIBM1124_e,
  iconv_CSIBM1129_e,
  iconv_CSIBM1130_e,
  iconv_CSIBM1132_e,
  iconv_CSIBM1133_e,
  iconv_CSIBM1137_e,
  iconv_CSIBM1140_e,
  iconv_CSIBM1141_e,
  iconv_CSIBM1142_e,
  iconv_CSIBM1143_e,
  iconv_CSIBM1144_e,
  iconv_CSIBM1145_e,
  iconv_CSIBM1146_e,
  iconv_CSIBM1147_e,
  iconv_CSIBM1148_e,
  iconv_CSIBM1149_e,
  iconv_CSIBM1153_e,
  iconv_CSIBM1154_e,
  iconv_CSIBM1155_e,
  iconv_CSIBM1156_e,
  iconv_CSIBM1157_e,
  iconv_CSIBM1158_e,
  iconv_CSIBM1160_e,
  iconv_CSIBM1161_e,
  iconv_CSIBM11621162_e,
  iconv_CSIBM1163_e,
  iconv_CSIBM1164_e,
  iconv_CSIBM1166_e,
  iconv_CSIBM1167_e,
  iconv_CSIBM12712_e,
  iconv_CSIBM1364_e,
  iconv_CSIBM1371_e,
  iconv_CSIBM1388_e,
  iconv_CSIBM1390_e,
  iconv_CSIBM1399_e,
  iconv_CSIBM16804_e,
  iconv_CSIBM273_e,
  iconv_CSIBM274_e,
  iconv_CSIBM275_e,
  iconv_CSIBM277_e,
  iconv_CSIBM278_e,
  iconv_CSIBM280_e,
  iconv_CSIBM281_e,
  iconv_CSIBM284_e,
  iconv_CSIBM285_e,
  iconv_CSIBM290_e,
  iconv_CSIBM297_e,
  iconv_CSIBM420_e,
  iconv_CSIBM423_e,
  iconv_CSIBM424_e,
  iconv_CSIBM4517_e,
  iconv_CSIBM4899_e,
  iconv_CSIBM4909_e,
  iconv_CSIBM4971_e,
  iconv_CSIBM500_e,
  iconv_CSIBM5347_e,
  iconv_CSIBM803_e,
  iconv_CSIBM851_e,
  iconv_CSIBM855_e,
  iconv_CSIBM856_e,
  iconv_CSIBM857_e,
  iconv_CSIBM860_e,
  iconv_CSIBM863_e,
  iconv_CSIBM864_e,
  iconv_CSIBM865_e,
  iconv_CSIBM866_e,
  iconv_CSIBM868_e,
  iconv_CSIBM869_e,
  iconv_CSIBM870_e,
  iconv_CSIBM871_e,
  iconv_CSIBM880_e,
  iconv_CSIBM891_e,
  iconv_CSIBM901_e,
  iconv_CSIBM902_e,
  iconv_CSIBM9030_e,
  iconv_CSIBM903_e,
  iconv_CSIBM904_e,
  iconv_CSIBM905_e,
  iconv_CSIBM9066_e,
  iconv_CSIBM918_e,
  iconv_CSIBM921_e,
  iconv_CSIBM922_e,
  iconv_CSIBM930_e,
  iconv_CSIBM932_e,
  iconv_CSIBM933_e,
  iconv_CSIBM935_e,
  iconv_CSIBM937_e,
  iconv_CSIBM939_e,
  iconv_CSIBM943_e,
  iconv_CSIBM9448_e,
  iconv_CSISO10367BOX_e,
  iconv_CSISO103T618BIT_e,
  iconv_CSISO10SWEDISH_e,
  iconv_CSISO111ECMACYRILLIC_e,
  iconv_CSISO11SWEDISHFORNAMES_e,
  iconv_CSISO121CANADIAN1_e,
  iconv_CSISO122CANADIAN2_e,
  iconv_CSISO139CSN369103_e,
  iconv_CSISO141JUSIB1002_e,
  iconv_CSISO143IECP271_e,
  iconv_CSISO14JISC6220RO_e,
  iconv_CSISO150GREEKCCITT_e,
  iconv_CSISO150_e,
  iconv_CSISO151CUBA_e,
  iconv_CSISO153GOST1976874_e,
  iconv_CSISO15ITALIAN_e,
  iconv_CSISO16PORTUGESE_e,
  iconv_CSISO17SPANISH_e,
  iconv_CSISO18GREEK7OLD_e,
  iconv_CSISO19LATINGREEK_e,
  iconv_CSISO2022CN_e,
  iconv_CSISO2022JP2_e,
  iconv_CSISO2022JP_e,
  iconv_CSISO2022KR_e,
  iconv_CSISO2033_e,
  iconv_CSISO21GERMAN_e,
  iconv_CSISO25FRENCH_e,
  iconv_CSISO27LATINGREEK1_e,
  iconv_CSISO49INIS_e,
  iconv_CSISO4UNITEDKINGDOM_e,
  iconv_CSISO50INIS8_e,
  iconv_CSISO51INISCYRILLIC_e,
  iconv_CSISO5427CYRILLIC1981_e,
  iconv_CSISO5427CYRILLIC_e,
  iconv_CSISO5428GREEK_e,
  iconv_CSISO58GB1988_e,
  iconv_CSISO60DANISHNORWEGIAN_e,
  iconv_CSISO60NORWEGIAN1_e,
  iconv_CSISO61NORWEGIAN2_e,
  iconv_CSISO646DANISH_e,
  iconv_CSISO69FRENCH_e,
  iconv_CSISO84PORTUGUESE2_e,
  iconv_CSISO85SPANISH2_e,
  iconv_CSISO86HUNGARIAN_e,
  iconv_CSISO88GREEK7_e,
  iconv_CSISO89ASMO449_e,
  iconv_CSISO90_e,
  iconv_CSISO92JISC62991984B_e,
  iconv_CSISO99NAPLPS_e,
  iconv_CSISOLATIN1_e,
  iconv_CSISOLATIN2_e,
  iconv_CSISOLATIN3_e,
  iconv_CSISOLATIN4_e,
  iconv_CSISOLATIN5_e,
  iconv_CSISOLATIN6_e,
  iconv_CSISOLATINARABIC_e,
  iconv_CSISOLATINCYRILLIC_e,
  iconv_CSISOLATINGREEK_e,
  iconv_CSISOLATINHEBREW_e,
  iconv_CSKOI8R_e,
  iconv_CSKSC5636_e,
  iconv_CSMACINTOSH_e,
  iconv_CSNATSDANO_e,
  iconv_CSNATSSEFI_e,
  iconv_CSN_369103_e,
  iconv_CSPC775BALTIC_e,
  iconv_CSPC850MULTILINGUAL_e,
  iconv_CSPC858MULTILINGUAL_e,
  iconv_CSPC862LATINHEBREW_e,
  iconv_CSPC8CODEPAGE437_e,
  iconv_CSPCP852_e,
  iconv_CSSHIFTJIS_e,
  iconv_CSUCS4_e,
  iconv_CSUNICODE_e,
  iconv_CSWINDOWS31J_e,
  iconv_CUBA_e,
  iconv_CWI_2_e,
  iconv_CWI_e,
  iconv_CYRILLIC_e,
  iconv_DECMCS_e,
  iconv_DEC_MCS_e,
  iconv_DEC_e,
  iconv_DE_e,
  iconv_DIN_66003_e,
  iconv_DK_e,
  iconv_DS2089_e,
  iconv_DS_2089_e,
  iconv_E13B_e,
  iconv_EBCDICATDEA_e,
  iconv_EBCDICATDE_e,
  iconv_EBCDICCAFR_e,
  iconv_EBCDICDKNOA_e,
  iconv_EBCDICDKNO_e,
  iconv_EBCDICESA_e,
  iconv_EBCDICESS_e,
  iconv_EBCDICES_e,
  iconv_EBCDICFISEA_e,
  iconv_EBCDICFISE_e,
  iconv_EBCDICFR_e,
  iconv_EBCDICISFRISS_e,
  iconv_EBCDICIT_e,
  iconv_EBCDICPT_e,
  iconv_EBCDICUK_e,
  iconv_EBCDICUS_e,   // NATIVE or EBCDIC
  iconv_EBCDIC_AT_DE_A_e,
  iconv_EBCDIC_AT_DE_e,
  iconv_EBCDIC_BE_e,
  iconv_EBCDIC_BR_e,
  iconv_EBCDIC_CA_FR_e,
  iconv_EBCDIC_CP_AR1_e,
  iconv_EBCDIC_CP_AR2_e,
  iconv_EBCDIC_CP_BE_e,
  iconv_EBCDIC_CP_CA_e,
  iconv_EBCDIC_CP_CH_e,
  iconv_EBCDIC_CP_DK_e,
  iconv_EBCDIC_CP_ES_e,
  iconv_EBCDIC_CP_FI_e,
  iconv_EBCDIC_CP_FR_e,
  iconv_EBCDIC_CP_GB_e,
  iconv_EBCDIC_CP_GR_e,
  iconv_EBCDIC_CP_HE_e,
  iconv_EBCDIC_CP_IS_e,
  iconv_EBCDIC_CP_IT_e,
  iconv_EBCDIC_CP_NL_e,
  iconv_EBCDIC_CP_NO_e,
  iconv_EBCDIC_CP_ROECE_e,
  iconv_EBCDIC_CP_SE_e,
  iconv_EBCDIC_CP_TR_e,
  iconv_EBCDIC_CP_US_e,
  iconv_EBCDIC_CP_WT_e,
  iconv_EBCDIC_CP_YU_e,
  iconv_EBCDIC_CYRILLIC_e,
  iconv_EBCDIC_DK_NO_A_e,
  iconv_EBCDIC_DK_NO_e,
  iconv_EBCDIC_ES_A_e,
  iconv_EBCDIC_ES_S_e,
  iconv_EBCDIC_ES_e,
  iconv_EBCDIC_FI_SE_A_e,
  iconv_EBCDIC_FI_SE_e,
  iconv_EBCDIC_FR_e,
  iconv_EBCDIC_GREEK_e,
  iconv_EBCDIC_INT1_e,
  iconv_EBCDIC_INT_e,
  iconv_EBCDIC_IS_FRISS_e,
  iconv_EBCDIC_IT_e,
  iconv_EBCDIC_JP_E_e,
  iconv_EBCDIC_JP_KANA_e,
  iconv_EBCDIC_PT_e,
  iconv_EBCDIC_UK_e,
  iconv_EBCDIC_US_e,
  iconv_ECMACYRILLIC_e,
  iconv_ECMA_114_e,
  iconv_ECMA_118_e,
  iconv_ECMA_128_e,
  iconv_ECMA_CYRILLIC_e,
  iconv_ELOT_928_e,
  iconv_ES2_e,
  iconv_ES_e,
  iconv_EUCCN_e,
  iconv_EUCJP_MS_e,
  iconv_EUCJP_OPEN_e,
  iconv_EUCJP_WIN_e,
  iconv_EUCJP_e,
  iconv_EUCKR_e,
  iconv_EUCTW_e,
  iconv_EUC_CN_e,
  iconv_EUC_JISX0213_e,
  iconv_EUC_JP_MS_e,
  iconv_EUC_JP_e,
  iconv_EUC_KR_e,
  iconv_EUC_TW_e,
  iconv_FI_e,
  iconv_FR_e,
  iconv_GB13000_e,
  iconv_GB18030_e,
  iconv_GB2312_e,
  iconv_GBK_e,
  iconv_GB_198880_e,
  iconv_GB_1988_80_e,
  iconv_GB_e,
  iconv_GEORGIAN_ACADEMY_e,
  iconv_GEORGIAN_PS_e,
  iconv_GOST_1976874_e,
  iconv_GOST_19768_74_e,
  iconv_GOST_19768_e,
  iconv_GREEK7OLD_e,
  iconv_GREEK7_OLD_e,
  iconv_GREEK7_e,
  iconv_GREEK8_e,
  iconv_GREEKCCITT_e,
  iconv_GREEK_CCITT_e,
  iconv_GREEK_e,
  iconv_HEBREW_e,
  iconv_HPGREEK8_e,
  iconv_HPROMAN8_e,
  iconv_HPROMAN9_e,
  iconv_HPTHAI8_e,
  iconv_HPTURKISH8_e,
  iconv_HP_GREEK8_e,
  iconv_HP_ROMAN8_e,
  iconv_HP_ROMAN9_e,
  iconv_HP_THAI8_e,
  iconv_HP_TURKISH8_e,
  iconv_HU_e,
  iconv_IBM037_e,
  iconv_IBM038_e,
  iconv_IBM1004_e,
  iconv_IBM1008_e,
  iconv_IBM1025_e,
  iconv_IBM1026_e,
  iconv_IBM1046_e,
  iconv_IBM1047_e,
  iconv_IBM1089_e,
  iconv_IBM1097_e,
  iconv_IBM1112_e,
  iconv_IBM1122_e,
  iconv_IBM1123_e,
  iconv_IBM1124_e,
  iconv_IBM1129_e,
  iconv_IBM1130_e,
  iconv_IBM1132_e,
  iconv_IBM1133_e,
  iconv_IBM1137_e,
  iconv_IBM1140_e,
  iconv_IBM1141_e,
  iconv_IBM1142_e,
  iconv_IBM1143_e,
  iconv_IBM1144_e,
  iconv_IBM1145_e,
  iconv_IBM1146_e,
  iconv_IBM1147_e,
  iconv_IBM1148_e,
  iconv_IBM1149_e,
  iconv_IBM1153_e,
  iconv_IBM1154_e,
  iconv_IBM1155_e,
  iconv_IBM1156_e,
  iconv_IBM1157_e,
  iconv_IBM1158_e,
  iconv_IBM1160_e,
  iconv_IBM1161_e,
  iconv_IBM1162_e,
  iconv_IBM1163_e,
  iconv_IBM1164_e,
  iconv_IBM1166_e,
  iconv_IBM1167_e,
  iconv_IBM12712_e,
  iconv_IBM1364_e,
  iconv_IBM1371_e,
  iconv_IBM1388_e,
  iconv_IBM1390_e,
  iconv_IBM1399_e,
  iconv_IBM16804_e,
  iconv_IBM256_e,
  iconv_IBM273_e,
  iconv_IBM274_e,
  iconv_IBM275_e,
  iconv_IBM277_e,
  iconv_IBM278_e,
  iconv_IBM280_e,
  iconv_IBM281_e,
  iconv_IBM284_e,
  iconv_IBM285_e,
  iconv_IBM290_e,
  iconv_IBM297_e,
  iconv_IBM367_e,
  iconv_IBM420_e,
  iconv_IBM423_e,
  iconv_IBM424_e,
  iconv_IBM437_e,
  iconv_IBM4517_e,
  iconv_IBM4899_e,
  iconv_IBM4909_e,
  iconv_IBM4971_e,
  iconv_IBM500_e,
  iconv_IBM5347_e,
  iconv_IBM775_e,
  iconv_IBM803_e,
  iconv_IBM813_e,
  iconv_IBM819_e,
  iconv_IBM848_e,
  iconv_IBM850_e,
  iconv_IBM851_e,
  iconv_IBM852_e,
  iconv_IBM855_e,
  iconv_IBM856_e,
  iconv_IBM857_e,
  iconv_IBM858_e,
  iconv_IBM860_e,
  iconv_IBM861_e,
  iconv_IBM862_e,
  iconv_IBM863_e,
  iconv_IBM864_e,
  iconv_IBM865_e,
  iconv_IBM866NAV_e,
  iconv_IBM866_e,
  iconv_IBM868_e,
  iconv_IBM869_e,
  iconv_IBM870_e,
  iconv_IBM871_e,
  iconv_IBM874_e,
  iconv_IBM875_e,
  iconv_IBM880_e,
  iconv_IBM891_e,
  iconv_IBM901_e,
  iconv_IBM902_e,
  iconv_IBM9030_e,
  iconv_IBM903_e,
  iconv_IBM904_e,
  iconv_IBM905_e,
  iconv_IBM9066_e,
  iconv_IBM912_e,
  iconv_IBM915_e,
  iconv_IBM916_e,
  iconv_IBM918_e,
  iconv_IBM920_e,
  iconv_IBM921_e,
  iconv_IBM922_e,
  iconv_IBM930_e,
  iconv_IBM932_e,
  iconv_IBM933_e,
  iconv_IBM935_e,
  iconv_IBM937_e,
  iconv_IBM939_e,
  iconv_IBM943_e,
  iconv_IBM9448_e,
  iconv_IBM_1008_e,
  iconv_IBM_1025_e,
  iconv_IBM_1046_e,
  iconv_IBM_1047_e,
  iconv_IBM_1097_e,
  iconv_IBM_1112_e,
  iconv_IBM_1122_e,
  iconv_IBM_1123_e,
  iconv_IBM_1124_e,
  iconv_IBM_1129_e,
  iconv_IBM_1130_e,
  iconv_IBM_1132_e,
  iconv_IBM_1133_e,
  iconv_IBM_1137_e,
  iconv_IBM_1140_e,
  iconv_IBM_1141_e,
  iconv_IBM_1142_e,
  iconv_IBM_1143_e,
  iconv_IBM_1144_e,
  iconv_IBM_1145_e,
  iconv_IBM_1146_e,
  iconv_IBM_1147_e,
  iconv_IBM_1148_e,
  iconv_IBM_1149_e,
  iconv_IBM_1153_e,
  iconv_IBM_1154_e,
  iconv_IBM_1155_e,
  iconv_IBM_1156_e,
  iconv_IBM_1157_e,
  iconv_IBM_1158_e,
  iconv_IBM_1160_e,
  iconv_IBM_1161_e,
  iconv_IBM_1162_e,
  iconv_IBM_1163_e,
  iconv_IBM_1164_e,
  iconv_IBM_1166_e,
  iconv_IBM_1167_e,
  iconv_IBM_12712_e,
  iconv_IBM_1364_e,
  iconv_IBM_1371_e,
  iconv_IBM_1388_e,
  iconv_IBM_1390_e,
  iconv_IBM_1399_e,
  iconv_IBM_16804_e,
  iconv_IBM_4517_e,
  iconv_IBM_4899_e,
  iconv_IBM_4909_e,
  iconv_IBM_4971_e,
  iconv_IBM_5347_e,
  iconv_IBM_803_e,
  iconv_IBM_856_e,
  iconv_IBM_901_e,
  iconv_IBM_902_e,
  iconv_IBM_9030_e,
  iconv_IBM_9066_e,
  iconv_IBM_921_e,
  iconv_IBM_922_e,
  iconv_IBM_930_e,
  iconv_IBM_932_e,
  iconv_IBM_933_e,
  iconv_IBM_935_e,
  iconv_IBM_937_e,
  iconv_IBM_939_e,
  iconv_IBM_943_e,
  iconv_IBM_9448_e,
  iconv_IEC_P271_e,
  iconv_IEC_P27_1_e,
  iconv_INIS8_e,
  iconv_INISCYRILLIC_e,
  iconv_INIS_8_e,
  iconv_INIS_CYRILLIC_e,
  iconv_INIS_e,
  iconv_ISIRI3342_e,
  iconv_ISIRI_3342_e,
  iconv_ISO11548_1_e,
  iconv_ISO2022CNEXT_e,
  iconv_ISO2022CN_e,
  iconv_ISO2022JP2_e,
  iconv_ISO2022JP_e,
  iconv_ISO2022KR_e,
  iconv_ISO646_CA2_e,
  iconv_ISO646_CA_e,
  iconv_ISO646_CN_e,
  iconv_ISO646_CU_e,
  iconv_ISO646_DE_e,
  iconv_ISO646_DK_e,
  iconv_ISO646_ES2_e,
  iconv_ISO646_ES_e,
  iconv_ISO646_FI_e,
  iconv_ISO646_FR1_e,
  iconv_ISO646_FR_e,
  iconv_ISO646_GB_e,
  iconv_ISO646_HU_e,
  iconv_ISO646_IT_e,
  iconv_ISO646_JP_OCR_B_e,
  iconv_ISO646_JP_e,
  iconv_ISO646_KR_e,
  iconv_ISO646_NO2_e,
  iconv_ISO646_NO_e,
  iconv_ISO646_PT2_e,
  iconv_ISO646_PT_e,
  iconv_ISO646_SE2_e,
  iconv_ISO646_SE_e,
  iconv_ISO646_US_e,
  iconv_ISO646_YU_e,
  iconv_ISO6937_e,
  iconv_ISO885910_e,
  iconv_ISO885911_e,
  iconv_ISO885913_e,
  iconv_ISO885914_e,
  iconv_ISO885915_e,
  iconv_ISO885916_e,
  iconv_ISO88591_e,
  iconv_ISO88592_e,
  iconv_ISO88593_e,
  iconv_ISO88594_e,
  iconv_ISO88595_e,
  iconv_ISO88596_e,
  iconv_ISO88597_e,
  iconv_ISO88598_e,
  iconv_ISO88599E_e,
  iconv_ISO88599_e,
  iconv_ISO8859_10_e,
  iconv_ISO8859_11_e,
  iconv_ISO8859_13_e,
  iconv_ISO8859_14_e,
  iconv_ISO8859_15_e,
  iconv_ISO8859_16_e,
  iconv_ISO8859_1_e,
  iconv_ISO8859_2_e,
  iconv_ISO8859_3_e,
  iconv_ISO8859_4_e,
  iconv_ISO8859_5_e,
  iconv_ISO8859_6_e,
  iconv_ISO8859_7_e,
  iconv_ISO8859_8_e,
  iconv_ISO8859_9E_e,
  iconv_ISO8859_9_e,
  iconv_ISO_10367BOX_e,
  iconv_ISO_10367_BOX_e,
  iconv_ISO_10646_e,  // STANDARD_2
  iconv_ISO_11548_1_e,
  iconv_ISO_2022_CN_EXT_e,
  iconv_ISO_2022_CN_e,
  iconv_ISO_2022_JP_2_e,
  iconv_ISO_2022_JP_3_e,
  iconv_ISO_2022_JP_e,
  iconv_ISO_2022_KR_e,
  iconv_ISO_2033_1983_e,
  iconv_ISO_2033_e,
  iconv_ISO_5427EXT_e,
  iconv_ISO_5427_1981_e,
  iconv_ISO_5427_EXT_e,
  iconv_ISO_5427_e,
  iconv_ISO_5428_1980_e,
  iconv_ISO_5428_e,
  iconv_ISO_646_IRV_1991_e,
  iconv_ISO_69372_e,
  iconv_ISO_6937_1992_e,
  iconv_ISO_6937_2_1983_e,
  iconv_ISO_6937_2_e,
  iconv_ISO_6937_e,
  iconv_ISO_8859_10_1992_e,
  iconv_ISO_8859_10_e,
  iconv_ISO_8859_11_e,
  iconv_ISO_8859_13_e,
  iconv_ISO_8859_14_1998_e,
  iconv_ISO_8859_14_e,
  iconv_ISO_8859_15_1998_e,
  iconv_ISO_8859_15_e,
  iconv_ISO_8859_16_2001_e,
  iconv_ISO_8859_16_e,
  iconv_ISO_8859_1_1987_e,
  iconv_ISO_8859_1_e,
  iconv_ISO_8859_2_1987_e,
  iconv_ISO_8859_2_e,
  iconv_ISO_8859_3_1988_e,
  iconv_ISO_8859_3_e,
  iconv_ISO_8859_4_1988_e,
  iconv_ISO_8859_4_e,
  iconv_ISO_8859_5_1988_e,
  iconv_ISO_8859_5_e,
  iconv_ISO_8859_6_1987_e,
  iconv_ISO_8859_6_e,
  iconv_ISO_8859_7_1987_e,
  iconv_ISO_8859_7_2003_e,
  iconv_ISO_8859_7_e,
  iconv_ISO_8859_8_1988_e,
  iconv_ISO_8859_8_e,
  iconv_ISO_8859_9E_e,
  iconv_ISO_8859_9_1989_e,
  iconv_ISO_8859_9_e,
  iconv_ISO_9036_e,
  iconv_ISO_CELTIC_e,
  iconv_ISO_IR_100_e,
  iconv_ISO_IR_101_e,
  iconv_ISO_IR_103_e,
  iconv_ISO_IR_109_e,
  iconv_ISO_IR_10_e,
  iconv_ISO_IR_110_e,
  iconv_ISO_IR_111_e,
  iconv_ISO_IR_11_e,
  iconv_ISO_IR_121_e,
  iconv_ISO_IR_122_e,
  iconv_ISO_IR_126_e,
  iconv_ISO_IR_127_e,
  iconv_ISO_IR_138_e,
  iconv_ISO_IR_139_e,
  iconv_ISO_IR_141_e,
  iconv_ISO_IR_143_e,
  iconv_ISO_IR_144_e,
  iconv_ISO_IR_148_e,
  iconv_ISO_IR_14_e,
  iconv_ISO_IR_150_e,
  iconv_ISO_IR_151_e,
  iconv_ISO_IR_153_e,
  iconv_ISO_IR_155_e,
  iconv_ISO_IR_156_e,
  iconv_ISO_IR_157_e,
  iconv_ISO_IR_15_e,
  iconv_ISO_IR_166_e,
  iconv_ISO_IR_16_e,
  iconv_ISO_IR_179_e,
  iconv_ISO_IR_17_e,
  iconv_ISO_IR_18_e,
  iconv_ISO_IR_193_e,
  iconv_ISO_IR_197_e,
  iconv_ISO_IR_199_e,
  iconv_ISO_IR_19_e,
  iconv_ISO_IR_203_e,
  iconv_ISO_IR_209_e,
  iconv_ISO_IR_21_e,
  iconv_ISO_IR_226_e,
  iconv_ISO_IR_25_e,
  iconv_ISO_IR_27_e,
  iconv_ISO_IR_37_e,
  iconv_ISO_IR_49_e,
  iconv_ISO_IR_4_e,
  iconv_ISO_IR_50_e,
  iconv_ISO_IR_51_e,
  iconv_ISO_IR_54_e,
  iconv_ISO_IR_55_e,
  iconv_ISO_IR_57_e,
  iconv_ISO_IR_60_e,
  iconv_ISO_IR_61_e,
  iconv_ISO_IR_69_e,
  iconv_ISO_IR_6_e,
  iconv_ISO_IR_84_e,
  iconv_ISO_IR_85_e,
  iconv_ISO_IR_86_e,
  iconv_ISO_IR_88_e,
  iconv_ISO_IR_89_e,
  iconv_ISO_IR_8_1_e,
  iconv_ISO_IR_90_e,
  iconv_ISO_IR_92_e,
  iconv_ISO_IR_98_e,
  iconv_ISO_IR_99_e,
  iconv_ISO_IR_9_1_e,
  iconv_ISO_e,
  iconv_IT_e,
  iconv_JIS_C62201969RO_e,
  iconv_JIS_C6220_1969_RO_e,
  iconv_JIS_C62291984B_e,
  iconv_JIS_C6229_1984_B_e,
  iconv_JOHAB_e,
  iconv_JP_OCR_B_e,
  iconv_JP_e,
  iconv_JS_e,
  iconv_JUS_I_B1_002_e,
  iconv_KOI8R_e,
  iconv_KOI8U_e,
  iconv_KOI8_RU_e,
  iconv_KOI8_R_e,
  iconv_KOI8_T_e,
  iconv_KOI8_U_e,
  iconv_KOI8_e,
  iconv_KOI_7_e,
  iconv_KOI_8_e,
  iconv_KSC5636_e,
  iconv_L10_e,
  iconv_L1_e,
  iconv_L2_e,
  iconv_L3_e,
  iconv_L4_e,
  iconv_L5_e,
  iconv_L6_e,
  iconv_L7_e,
  iconv_L8_e,
  iconv_LATIN10_e,
  iconv_LATIN1_e,
  iconv_LATIN2_e,
  iconv_LATIN3_e,
  iconv_LATIN4_e,
  iconv_LATIN5_e,
  iconv_LATIN6_e,
  iconv_LATIN7_e,
  iconv_LATIN8_e,
  iconv_LATIN9_e,
  iconv_LATINGREEK1_e,
  iconv_LATINGREEK_e,
  iconv_LATIN_9_e,
  iconv_LATIN_GREEK_1_e,
  iconv_LATIN_GREEK_e,
  iconv_MACCYRILLIC_e,
  iconv_MACINTOSH_e,
  iconv_MACIS_e,
  iconv_MACUKRAINIAN_e,
  iconv_MACUK_e,
  iconv_MAC_CENTRALEUROPE_e,
  iconv_MAC_CYRILLIC_e,
  iconv_MAC_IS_e,
  iconv_MAC_SAMI_e,
  iconv_MAC_UK_e,
  iconv_MAC_e,
  iconv_MIK_e,
  iconv_MS932_e,
  iconv_MS936_e,
  iconv_MSCP1361_e,
  iconv_MSCP949_e,
  iconv_MSMACCYRILLIC_e,
  iconv_MSZ_7795_3_e,
  iconv_MS_ANSI_e,
  iconv_MS_ARAB_e,
  iconv_MS_CYRL_e,
  iconv_MS_EE_e,
  iconv_MS_GREEK_e,
  iconv_MS_HEBR_e,
  iconv_MS_KANJI_e,
  iconv_MS_MAC_CYRILLIC_e,
  iconv_MS_TURK_e,
  iconv_NAPLPS_e,
  iconv_NATSDANO_e,
  iconv_NATSSEFI_e,
  iconv_NATS_DANO_e,
  iconv_NATS_SEFI_e,
  iconv_NC_NC0010_e,
  iconv_NC_NC00_10_81_e,
  iconv_NC_NC00_10_e,
  iconv_NF_Z_62010_1973_e,
  iconv_NF_Z_62010_e,
  iconv_NF_Z_62_010__1973__e,
  iconv_NF_Z_62_010_1973_e,
  iconv_NF_Z_62_010_e,
  iconv_NO2_e,
  iconv_NO_e,
  iconv_NS_45511_e,
  iconv_NS_45512_e,
  iconv_NS_4551_1_e,
  iconv_NS_4551_2_e,
  iconv_OS2LATIN1_e,
  iconv_OSF00010001_e,
  iconv_OSF00010002_e,
  iconv_OSF00010003_e,
  iconv_OSF00010004_e,
  iconv_OSF00010005_e,
  iconv_OSF00010006_e,
  iconv_OSF00010007_e,
  iconv_OSF00010008_e,
  iconv_OSF00010009_e,
  iconv_OSF0001000A_e,
  iconv_OSF00010020_e,
  iconv_OSF00010100_e,
  iconv_OSF00010101_e,
  iconv_OSF00010102_e,
  iconv_OSF00010104_e,
  iconv_OSF00010105_e,
  iconv_OSF00010106_e,
  iconv_OSF00030010_e,
  iconv_OSF0004000A_e,
  iconv_OSF0005000A_e,
  iconv_OSF05010001_e,
  iconv_OSF10010001_e,
  iconv_OSF10010004_e,
  iconv_OSF10010006_e,
  iconv_OSF10020025_e,
  iconv_OSF10020111_e,
  iconv_OSF10020115_e,
  iconv_OSF10020116_e,
  iconv_OSF10020118_e,
  iconv_OSF1002011C_e,
  iconv_OSF1002011D_e,
  iconv_OSF10020122_e,
  iconv_OSF10020129_e,
  iconv_OSF100201A4_e,
  iconv_OSF100201A8_e,
  iconv_OSF100201B5_e,
  iconv_OSF100201F4_e,
  iconv_OSF10020352_e,
  iconv_OSF10020354_e,
  iconv_OSF10020357_e,
  iconv_OSF10020359_e,
  iconv_OSF1002035D_e,
  iconv_OSF1002035E_e,
  iconv_OSF1002035F_e,
  iconv_OSF10020360_e,
  iconv_OSF10020364_e,
  iconv_OSF10020365_e,
  iconv_OSF10020366_e,
  iconv_OSF10020367_e,
  iconv_OSF1002036B_e,
  iconv_OSF10020370_e,
  iconv_OSF1002037B_e,
  iconv_OSF10020387_e,
  iconv_OSF10020388_e,
  iconv_OSF10020396_e,
  iconv_OSF100203B5_e,
  iconv_OSF10020402_e,
  iconv_OSF10020417_e,
  iconv_PT154_e,
  iconv_PT2_e,
  iconv_PT_e,
  iconv_R8_e,
  iconv_R9_e,
  iconv_RK1048_e,
  iconv_ROMAN8_e,
  iconv_ROMAN9_e,
  iconv_RUSCII_e,
  iconv_SE2_e,
  iconv_SEN_850200_B_e,
  iconv_SEN_850200_C_e,
  iconv_SE_e,
  iconv_SHIFTJISX0213_e,
  iconv_SHIFT_JISX0213_e,
  iconv_SHIFT_JIS_e,
  iconv_SJIS_OPEN_e,
  iconv_SJIS_WIN_e,
  iconv_SJIS_e,
  iconv_SS636127_e,
  iconv_STRK1048_2002_e,
  iconv_ST_SEV_358_88_e,
  iconv_TCVN5712_1_1993_e,
  iconv_TCVN5712_1_e,
  iconv_TCVN_5712_e,
  iconv_TCVN_e,
  iconv_THAI8_e,
  iconv_TIS620_0_e,
  iconv_TIS620_2529_1_e,
  iconv_TIS620_2533_0_e,
  iconv_TIS620_e,
  iconv_TIS_620_e,
  iconv_TSCII_e,
  iconv_TS_5881_e,
  iconv_TURKISH8_e,
  iconv_T_618BIT_e,
  iconv_T_61_8BIT_e,
  iconv_T_61_e,
  iconv_UCS2_e,
  iconv_UCS4_e,
  iconv_UCS_2BE_e,
  iconv_UCS_2LE_e,
  iconv_UCS_2_e,
  iconv_UCS_4BE_e,
  iconv_UCS_4LE_e,
  iconv_UCS_4_e,
  iconv_UHC_e,
  iconv_UJIS_e,
  iconv_UK_e,
  iconv_UNICODEBIG_e,
  iconv_UNICODELITTLE_e,
  iconv_UNICODE_e,
  iconv_US_ASCII_e,
  iconv_US_e,
  iconv_UTF16BE_e,
  iconv_UTF16LE_e,
  iconv_UTF16_e,
  iconv_UTF32BE_e,
  iconv_UTF32LE_e,
  iconv_UTF32_e,
  iconv_UTF7_e,
  iconv_UTF8_e,
  iconv_UTF_16BE_e,
  iconv_UTF_16LE_e,
  iconv_UTF_16_e,
  iconv_UTF_32BE_e,
  iconv_UTF_32LE_e,
  iconv_UTF_32_e,
  iconv_UTF_7_e,
  iconv_UTF_8_e,    // UTF_8 specifically
  iconv_VISCII_e,
  iconv_WCHAR_T_e,
  iconv_WINBALTRIM_e,
  iconv_WINDOWS_1250_e,
  iconv_WINDOWS_1251_e,
  iconv_WINDOWS_1252_e,
  iconv_WINDOWS_1253_e,
  iconv_WINDOWS_1254_e,
  iconv_WINDOWS_1255_e,
  iconv_WINDOWS_1256_e,
  iconv_WINDOWS_1257_e,
  iconv_WINDOWS_1258_e,
  iconv_WINDOWS_31J_e,
  iconv_WINDOWS_874_e,
  iconv_WINDOWS_936_e,
  iconv_WINSAMI2_e,
  iconv_WIN_SAMI_2_e,
  iconv_WS2_e,
  iconv_YU_e,
};

#define ASCII_e  iconv_ASCII_e   
#define CP1252_e iconv_CP1252_e
#define EBCDIC_e iconv_CP1140_e
#define UTF8_e   iconv_UTF_8_e
#define iso646_e iconv_ISO_10646_e

struct encodings_t {
  cbl_encoding_t type;
  const char name[32];
};

#endif
