# Copyright (C) 2018 NTT DATA
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.


from oslo_policy import policy

from masakari.policies import base


VERSIONS = 'os_masakari_api:versions:%s'

rules = [
    policy.DocumentedRuleDefault(
        name=VERSIONS % 'index',
        check_str=base.RULE_ANY,
        description="List all versions.",
        operations=[
            {
                'method': 'GET',
                'path': '/'
            }
        ]),
    policy.RuleDefault(
        name=VERSIONS % 'discoverable',
        check_str=base.RULE_ANY,
        description="Version API extensions to change the API.",
        ),
]


def list_rules():
    return rules
