""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from xml.sax import saxlib, saxexts
from stack import *

class CommonHandler(saxlib.HandlerBase):
	
	def __init__(self, name):
		self.name = name
		self.met_name = '' # ????????
		self.parentTag = None
		self.stack = Stack()
		self.stack.push(self.parentTag)
		
	def __getattr__(self, name): # en cas d'attribut inconnu ??
	    self.met_name = name # UGLY! :)
	    return self.trace
	
	def startDocument(self):
		return

	def endDocument(self):
		return
	
	def startElement(self, name, attrs):
		self.parentTag = self.stack.top()		
		self.stack.push(name)

	def endElement(self, name):
		self.stack.pop()
		self.parentTag = self.stack.top()
		return
	
	def error(self,exception):
		print '%s.error(%s)' % (self.name,str(exception))
		raise exception

	def fatalError(self,exception):
		print '%s.fatalError(%s)' % (self.name,str(exception))
		raise exception

	def warning(self,exception):
		print '%s.warning(%s)' % (self.name,str(exception))
	   
	def characters(self,data,start,length):
		return

	def trace(self,*rest):
		str="%s.%s(" % (self.name,self.met_name)
		for param in rest[:-1]:
			str=str+`param`+", "
			if len(rest)>0:
				print str+`rest[-1]`+")"
			else:
				print str+")"
