/*
 *   Copyright 2012 Marco Martin <mart@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 1.1
import org.kde.plasma.components 0.1 as PlasmaComponents
import org.kde.plasma.core 0.1 as PlasmaCore
import org.kde.plasma.mobilecomponents 0.1 as PlasmaComponents
import org.kde.plasma.extras 0.1 as PlasmaExtras
import org.kde.locale 0.1 as KLocale
import org.kde.qtextracomponents 0.1


Item {
    id: root

    //BEGIN properties
    property int minimumWidth: 200
    property int minimumHeight: 350
    property bool alarmsPresent: alarmsSource.sources.length > 0

    property Item appBackground
    //END properties

    //BEGIN functions
    function removeAlarm(id) {
        var service = alarmsSource.serviceForSource("");
        var operation = service.operationDescription("delete");

        operation["Id"] = id;

        service.startOperationCall(operation);
    }

    function editAlarm(id) {
        if (pageRow.currentPage.alarmId != id) {
            pageRow.pop(alarmList);
            pageRow.push(Qt.createComponent("AlarmEdit.qml"));
            pageRow.currentPage.alarmId = id;
        }
    }

    onAlarmsPresentChanged: {
        if (alarmsPresent) {
            plasmoid.status = "ActiveStatus";
        } else {
            plasmoid.status = "PassiveStatus";
        }
    }
    //END functions

    //BEGIN non-UI items
    Component {
        id: appBackgroundComponent
        AppBackground {}
    }

    Component {
        id: panelBackgroundComponent
        PanelBackground {}
    }

    KLocale.Locale {
        id: locale
    }

    Connections {
        target: plasmoid
        onFormFactorChanged: {
            if (plasmoid.formFactor == plasmoid.Application) {
                root.appBackground = appBackgroundComponent.createObject(root)
            } else {
                appBackground.destroy()
            }
        }
    }

    PlasmaCore.DataSource {
        id: alarmsSource
        engine: "org.kde.alarms"
        interval: 0
        connectedSources: sources
    }
    //END non-UI items

    //BEGIN UI
    PlasmaExtras.PageRow {
        id: pageRow
        anchors.fill: parent

        columnWidth: (width/2 > theme.defaultFont.mSize.width*30) ? width/2 : width

        initialPage: AlarmList {
            id: alarmList
        }
    }
    //END UI
}
