#!/bin/sh

echo -n "Compositing active: "
qdbus org.kde.kwin /KWin compositingActive

echo -n "System can suspend (sleep): "
qdbus org.kde.Solid.PowerManagement /org/freedesktop/PowerManagement org.freedesktop.PowerManagement.CanSuspend

if [ -d /sys/bus/acpi/drivers/battery/ ]
then
        echo -n "Battery remaining time: "
        qdbus org.kde.Solid.PowerManagement /org/kde/Solid/PowerManagement org.kde.Solid.PowerManagement.batteryRemainingTime
else
        echo "WARNING: Battery not detected"
fi

if ! qdbus org.kde.kmix | grep -q /Mixers/
then
        echo "WARNING: Sound mixers not detected"
fi

# there is not way to check if the keyboard is currently visible ot not.
echo -n "Virtual keyboard is "
if qdbus org.kde.plasma.VirtualKeyboard &> /dev/null
then
        echo "running"
else
        echo "not running"
fi

echo -n "Solid (KDE) networking status: "
status=$(qdbus org.kde.kded /modules/networkstatus org.kde.Solid.Networking.status)
case $status in
        0)
                echo "Unknown"
        ;;

        1)
                echo "Unconnected"
        ;;

        2)
                echo "Disconnecting"
        ;;

        3)
                echo "Connecting"
        ;;

        4)
                echo "Connected"
        ;;

        *)
                echo "status not supported"
        ;;
esac

echo -n "Is screen locked? "
qdbus org.kde.screensaver /ScreenSaver org.freedesktop.ScreenSaver.GetActive

