#!/bin/bash

TMPDIR=$(mktemp -d)
export PATH="/sbin:/usr/sbin:$PATH"

echo "Output is generated by $0"
echo  -------------------------------------------------------------------------
echo

echo "Output of uname -a"
uname -a
echo  -------------------------------------------------------------------------
echo

echo "Get image identifier and initial package list:"
if [ -f "/etc/image-release" ]; then
    cat /etc/image-release
    echo ----------------------------------------------------------------------
    echo
    # get image identifier
    IMAGE_IDENTIFIER=$(head -n 1 /etc/image-release)
    # Remove the first four lines from initial package list and compare the
    # result with the current package list
    tail -n +4 /etc/image-release | sort > ${TMPDIR}/${IMAGE_IDENTIFIER}
    rpm -qa | sort > ${TMPDIR}/current-packages

    echo "Updated Packages:"
    package-list-compare.sh ${TMPDIR}/${IMAGE_IDENTIFIER} ${TMPDIR}/current-packages
    echo  ---------------------------------------------------------------------
    echo
fi

SYSTEM_TOOLS="
lsmod
lspci
lsusb
dmesg
ifconfig
df
qdbus
ck-list-sessions
"
for tool in ${SYSTEM_TOOLS}; do
echo "Output of tool ${tool}:"
which ${tool} &> /dev/null
ret=$?
if [ "0" != "${ret}" ]; then
echo "Skipping, tool ${tool} do not exist"
else
${tool}
fi
echo  ---------------------------------------------------------------------
echo
done

SIMPLE_TESTS="
qdbus-tests.sh
console-kit-tests.sh
systemd-tests.sh
"
for tests in ${SIMPLE_TESTS}; do
echo "Output of test ${tests}:"
which ${tests} &> /dev/null
ret=$?
if [ "0" != "${ret}" ]; then
echo "Skipping, test ${tests} do not exist"
else
${tests}
fi
echo  ---------------------------------------------------------------------
echo
done


SYSTEM_LOGS="
/proc/cpuinfo
/proc/meminfo
/proc/partitions
/proc/devices
${HOME}/.xsession-errors
/var/log/Xorg.0.log
/tmp/startactive-*.log
/tmp/active-firstrun.log
"

for log in ${SYSTEM_LOGS}; do
    echo "Content of log ${log}:"
    if [ -f ${log} ]; then
        cat ${log}
    else
        echo "Skipping, log ${log} do not exist"
    fi
    echo ----------------------------------------------------------------------
    echo
done

rm -rf ${TMPDIR}
