#!/bin/bash

echo -n "Testing console-kit by 'ck-list-sessions' tool: "

NEEDED_TOOLS="
ck-list-sessions
grep
"

for tool in ${NEEDED_TOOLS}; do
which ${tool} &> /dev/null
ret=$?
if [ "0" != "${ret}" ]; then
    echo -n "SKIPPING"
    echo
    echo "     Needed tool do not exist: ${tool}"
    exit 1
fi
done

if [ -n "$(ck-list-sessions | grep 'active = TRUE')" ]; then
	echo -n "SUCCESS"
    echo
else
    echo -n "FAIL"
    echo
    echo "    Please note, 'ck-list-sessions' contain no 'active = TRUE' entry."
    echo "    This indicate that 'console-kit' is not working, please check if"
    echo "    the kernel is configured with 'CONFIG_AUDITSYSCALL=y' support."

    # Addititional test for the 'CONFIG_AUDITSYSCALL=y' kernel support
    echo
    echo -n "Testing 'CONFIG_AUDITSYSCALL=y' kernel support: "

    NEEDED_TOOLS="
    cat
    gunzip
    mktemp
    "

    for tool in ${NEEDED_TOOLS}; do
    which ${tool} &> /dev/null
    ret=$?
    if [ "0" != "${ret}" ]; then
        echo -n "SKIPPING"
        echo
        echo "     Needed tool do not exist: ${tool}"
        exit 1
    fi
    done

    if [ -f "/proc/config.gz" ]; then
        TMPDIR=$(mktemp -d)
        cp /proc/config.gz ${TMPDIR}/config.gz
        gunzip ${TMPDIR}/config.gz
    	if [ -n "$(cat ${TMPDIR}/config | grep 'CONFIG_AUDITSYSCALL=y')" ]; then
            echo -n "SUCCESS (/proc/config.gz)"
            echo
        else
            echo -n "FAIL (/proc/config.gz)"
            echo
        fi
        rm -rf ${TMPDIR}

    elif [ -n "$(ls /boot/config* 2>/dev/null)" ]; then
        KERNEL_CONFIGS=$(ls /boot/config*)
        for config in ${KERNEL_CONFIGS}; do
    	    if [ -n "$(cat ${config} | grep 'CONFIG_AUDITSYSCALL=y')" ]; then
                echo -n "SUCCESS (${config})"
                echo
            else
                echo -n "FAIL (${config})"
                echo
            fi
        done
    else
        echo -n "SKIPPING"
        echo

        echo "    Could not find kernel config at '/boot/config*' or '/proc/config.gz'"
    fi
    exit 1
fi
