/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_PORT_BASE_H
#define _WF_PORT_BASE_H

#include <iostream>

enum metaport_elem_type {
  WF_METAPORT_NONE, WF_METAPORT_METAPORT, WF_METAPORT_PORT,
  WF_METAPORT_PORT_RANGE
};

/**
 * port_base: generic port object. Can be a metaport, a port, or a
 * port range.
 */
class wf_port_base {
 public:
  wf_port_base() {}
  virtual ~wf_port_base() {}
  virtual wf_port_base* VClone() const = 0;

  /**
   * Gets type of the object.
   * @return	enum metaport_elem_type
   */
  virtual enum metaport_elem_type gettype() const = 0;

  virtual ostream& print(ostream& os) const { return os << "(method not implemented)"; }
  virtual ostream& output_xml(ostream& os, unsigned int indent_level = 0) const = 0;

  friend ostream& operator<<(ostream& os, const wf_port_base* port_base) {
    return (port_base != NULL) ? port_base->print(os) : os << "(undefined)";
  }
};

#endif
