<?php
/*
 * $Horde: turba/display.php,v 1.9.2.12 2005/01/03 11:26:04 jan Exp $
 *
 * Turba: Copyright 2000-2005 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (ASL).  If you
 * did not receive this file, see http://www.horde.org/licenses/asl.php.
 */

define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once TURBA_BASE . '/lib/Source.php';
require_once TURBA_BASE . '/lib/ObjectView.php';

$source = Horde::getFormData('source');
if (empty($source)) {
    header('Location: ' . Horde::applicationUrl($prefs->getValue('initial_page'), true));
    exit;
}

$driver = &Turba_Source::singleton($source, $cfgSources[$source]);

$object = $driver->getObject(Horde::getFormData('key'));

if (is_object($object)) {
    $view = new Turba_ObjectView($object, TURBA_TEMPLATES . '/display/display.inc');
    $title = $object->getValue('name');
}

$js_onLoad = null;
require TURBA_TEMPLATES . '/common-header.inc';
require TURBA_BASE . '/menu.php';
require TURBA_BASE . '/status.php';

if (isset($view) && is_object($view)) {
    $view->display();
}

require TURBA_TEMPLATES . '/common-footer.inc';
$registry->shutdown();
