% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Impute.R
\name{reimpute}
\alias{reimpute}
\title{Re-impute a data set}
\usage{
reimpute(obj, desc)
}
\arguments{
\item{obj}{(\link{data.frame} | \link{Task})\cr
Input data.}

\item{desc}{(\code{ImputationDesc})\cr
Imputation description as returned by \link{impute}.}
}
\value{
Imputated \code{data.frame} or task with imputed data.
}
\description{
This function accepts a data frame or a task and an imputation description
as returned by \link{impute} to perform the following actions:
\enumerate{
\item Restore dropped columns, setting them to \code{NA}
\item Add dummy variables for columns as specified in \code{impute}
\item Optionally check factors for new levels to treat them as \code{NA}s
\item Reorder factor levels to ensure identical integer representation as
before
\item Impute missing values using previously collected data
}
}
\seealso{
Other impute: \code{\link{imputations}},
  \code{\link{impute}}, \code{\link{makeImputeMethod}},
  \code{\link{makeImputeWrapper}}
}
\concept{impute}
