/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
#include <glib.h>
#include <string>
#include <fstream>
#include "CosNaming.hh"
#include "simple-cpp-stubs.hh"
#include "simple-cpp-skels.hh"

class Simple_impl : public POA_test::Simple {
	
	int m_val;
public:
	Simple_impl(int val)
		: m_val(val) {
	}
	
	CORBA::Long op() throw(CORBA::SystemException){
		return m_val;
	}
};

int
main(int argc, char *argv[]) {
	// Initialize the CORBA orb
	CORBA::ORB_var orb = CORBA::ORB_init (argc, argv);
  
	// Get the root POA
	CORBA::Object_var pfobj = orb->resolve_initial_references("RootPOA");
	PortableServer::POA_var rootPOA =
        PortableServer::POA::_narrow(pfobj);

	// Activate the root POA's manager
	PortableServer::POAManager_var mgr = rootPOA->the_POAManager();
	mgr->activate();

	Simple_impl impl(3);

	test::Simple_ptr ptr = impl._this();

	// get the initial context
	CORBA::Object_var nameobj = orb->resolve_initial_references("NameService");
	CosNaming::NamingContext_var inc; // initial naming context
	inc = CosNaming::NamingContext::_narrow(nameobj);
	g_assert(!CORBA::is_nil(inc));

	CosNaming::NamingContext_var app2 = inc->new_context();

	// bind the object to the name
	CosNaming::Name name;
	name.length(1);
	name[0].id = CORBA::string_dup("myobject");
	inc->bind(name,ptr);

	CORBA::Object_ptr objptr = inc->resolve(name);
	test::Simple_ptr simpleptr = test::Simple::_narrow(objptr);
	g_assert(simpleptr->op() == 3);
	return 0;  // pass
}
