/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t;c-basic-offset: 4 -*- */
#ifndef _ORBIT_CPP_IDL_BOOLEAN_IMPL_HH
#define _ORBIT_CPP_IDL_BOOLEAN_IMPL_HH

#include "everything-cpp-skels.hh"


namespace test_impl {

	class BasicServer_impl : public POA_test::BasicServer {
	public:
		char* foo() throw (CORBA::SystemException);
		void foo(const char *val) throw (CORBA::SystemException);

		CORBA::Long bah() throw (CORBA::SystemException);
		
		char* opString(const char* inArg,
					   char*& inoutArg,
					   CORBA::String_out outArg) throw (CORBA::SystemException);
	
		CORBA::Long opLong(CORBA::Long inArg,
						   CORBA::Long& inoutArg,
						   CORBA::Long& outArg) throw (CORBA::SystemException);

		void opException() throw (CORBA::SystemException,
								  test::TestException);

		test::AnEnum opEnum(test::AnEnum inArg,
							test::AnEnum& inoutArg,
							test::AnEnum& outArg) throw (CORBA::SystemException);

		test::LongArray_slice *opLongArray(const test::LongArray inArg,
										 test::LongArray inoutArg,
										 test::LongArray_out outArg) throw (CORBA::SystemException);
		
		test::StrArray_slice *opStrArray(const test::StrArray inArg,
										 test::StrArray inoutArg,
										 test::StrArray_out outArg) throw (CORBA::SystemException); 
	};

	// because this object inherits RefCountServantBase, it must be 
	// allocated on the heap (i.e. with 'new') 
	class TransientObj_impl : public virtual POA_test::TransientObj,
							  public virtual PortableServer::RefCountServantBase {
		typedef PortableServer::RefCountServantBase Super;

	private:
		int mRef;
	public:
		// CORBA interface
		void remove() throw (CORBA::SystemException);
	public:
		// internal interface
		TransientObj_impl() : mRef(0) {}
		// keep a record of how many times this is called for testing purposes
		void _add_ref() {mRef++; Super::_add_ref();}
		void _remove_ref() {mRef--; Super::_remove_ref();}

		int get_ref() {return mRef;}
	};

	class StructServer_impl : public POA_test::StructServer {
	public:
		::test::FixedLengthStruct opFixed(const ::test::FixedLengthStruct &inArg,
										  ::test::FixedLengthStruct &inoutArg,
										  ::test::FixedLengthStruct_out outArg) throw (CORBA::SystemException);
		::test::VariableLengthStruct *opVariable(const ::test::VariableLengthStruct &inArg,
												 ::test::VariableLengthStruct &inoutArg,
												 ::test::VariableLengthStruct_out outArg) throw (CORBA::SystemException);
		::test::CompoundStruct *opCompound(const ::test::CompoundStruct &inArg,
												   ::test::CompoundStruct &inoutArg,
												   ::test::CompoundStruct_out outArg) throw (CORBA::SystemException);
	};

	class SequenceServer_impl : public POA_test::SequenceServer {
	public:
		test::StrSeq *opStrSeq(const test::StrSeq &inArg,
							   test::StrSeq &inoutArg,
							   test::StrSeq_out outArg) throw (CORBA::SystemException);
		test::BoundedStructSeq *opBoundedStructSeq(const test::BoundedStructSeq &inArg,
							   test::BoundedStructSeq &inoutArg,
							   test::BoundedStructSeq_out outArg) throw (CORBA::SystemException);
	};


	class BaseServer_impl : public POA_test::BaseServer {
	public:
		CORBA::Long opPolymorphic() throw (CORBA::SystemException);
		char *attribPolymorphic() throw (CORBA::SystemException);
		void attribPolymorphic(const char *val) throw (CORBA::SystemException);
	};

	class DerivedServer_impl : public POA_test::DerivedServer {
	private:
		CORBA::Long m_state;
	public:
		DerivedServer_impl();
		CORBA::Long opPolymorphic() throw (CORBA::SystemException);
		char *attribPolymorphic() throw (CORBA::SystemException);
		void attribPolymorphic(const char *val) throw (CORBA::SystemException);
	};
	

	class UnionServer_impl : public POA_test::UnionServer {
	public:
		::test::FixedLengthUnion opFixed(const ::test::FixedLengthUnion &inArg,
										 ::test::FixedLengthUnion &inoutArg,
										 ::test::FixedLengthUnion_out outArg) throw (CORBA::SystemException);
		::test::VariableLengthUnion *opVariable(const ::test::VariableLengthUnion &inArg,
										 ::test::VariableLengthUnion &inoutArg,
										 ::test::VariableLengthUnion_out outArg) throw (CORBA::SystemException);
	};

	class AnyServer_impl : public POA_test::AnyServer {
	public:
		CORBA::Any *opAnyLong(const CORBA::Any &inArg,
							  CORBA::Any &inoutArg,
							  CORBA::Any_out outArg) throw (CORBA::SystemException);
		CORBA::Any *opAnyString(const CORBA::Any &inArg,
								CORBA::Any &inoutArg,
								CORBA::Any_out outArg) throw (CORBA::SystemException);
		CORBA::Any *opAnyStruct(const CORBA::Any &inArg,
								CORBA::Any &inoutArg,
								CORBA::Any_out outArg) throw (CORBA::SystemException);
		CORBA::TypeCode_ptr opTypeCode(CORBA::TypeCode_ptr inArg,
									   CORBA::TypeCode_ptr &inoutArg,
									   CORBA::TypeCode_out outArg) throw (CORBA::SystemException);
		
	};

	
	class TestFactory_impl : public POA_test::TestFactory {		
		// the servants
		static TestFactory_impl *m_instance;
		BasicServer_impl m_basicServer;
		StructServer_impl m_structServer;
		SequenceServer_impl m_sequenceServer;
		BaseServer_impl m_baseServer;
		DerivedServer_impl m_derivedServer;
		UnionServer_impl m_unionServer;
		AnyServer_impl m_anyServer;

		// and the references
		static test::TestFactory_ptr m_instancePtr;
		test::BasicServer_var m_basicServerRef;
		test::StructServer_var m_structServerRef;
		test::SequenceServer_var m_sequenceServerRef;
		test::BaseServer_var m_baseServerRef;
		test::DerivedServer_var m_derivedServerRef;
		test::UnionServer_var m_unionServerRef;
		test::AnyServer_var m_anyServerRef;
		
	public:
		TestFactory_impl();
		test::BasicServer_ptr getBasicServer() throw (CORBA::SystemException);
		test::StructServer_ptr getStructServer() throw (CORBA::SystemException);
		test::SequenceServer_ptr getSequenceServer() throw (CORBA::SystemException);
		test::BaseServer_ptr getBaseServer() throw (CORBA::SystemException);
		test::DerivedServer_ptr getDerivedServer() throw (CORBA::SystemException);
		test::BaseServer_ptr getDerivedServerAsBaseServer() throw (CORBA::SystemException);
		test::B2_ptr getDerivedServerAsB2() throw (CORBA::SystemException);
		test::TransientObj_ptr createTransientObj() throw (CORBA::SystemException);
		test::UnionServer_ptr getUnionServer() throw (CORBA::SystemException);
		test::AnyServer_ptr getAnyServer() throw (CORBA::SystemException);

		static test::TestFactory_ptr instance();
	};


}

#endif //_ORBIT_CPP_IDL_EVERYTHING_IMPL_HH
