#!/bin/bash
gtk1=no
gtk2=no
debian=no
geckosdk=yes
MOZ=`which mozilla`
MOZHOME=`grep MOZILLA_FIVE_HOME= ${MOZ} | awk  -F \" '{ print $2 }'`
if [ -z ${MOZHOME} ]; then MOZHOME=`grep moz_libdir= ${MOZ} | awk  -F \" '{ print $2 }'`; fi
if [ -z ${MOZHOME} ]; then MOZHOME=`grep moz_libdir= ${MOZ} | nawk  -F \= '{ print $2 }'`; fi
if [ -z ${MOZHOME} ]; then
    if [ -d /usr/lib/firefox ]; then
	debian=yes;
	MOZHOME=/usr/lib/firefox;
    elif [ -d /usr/lib/mozilla ]; then
	debian=yes;
	MOZHOME=/usr/lib/mozilla;
    else
	echo "Can't find MOZILLA HOME. Please install manually";
	exit 1;
    fi
fi
if [ ${MOZHOME} != "/usr/lib/firefox" ]; then
    if [ `ldd ${MOZHOME}/mozilla-bin | grep gtk-x11 | wc -l` != 0 ]; then gtk2=yes; fi
    if [ `ldd ${MOZHOME}/mozilla-bin | grep gtk-1 | wc -l` != 0 ]; then gtk1=yes; fi
else
    if [ `ldd ${MOZHOME}/firefox-bin | grep gtk-x11 | wc -l` != 0 ]; then gtk2=yes; fi;
fi
pkg-config --exists mozilla-plugin
if [ $? == 0 ]; then geckosdk=no; fi

echo "Run configure with the following options"
echo ""
echo -n "./configure"
if [ $gtk1 == yes ]; then echo -n " --enable-gtk1"; fi
if [ $gtk2 == no -a $gtk1 == no ]; then echo -n " --enable-x"; fi
if [ $debian == yes ]; then echo -n " --with-mozilla-home={/usr/lib/mozilla or /usr/lib/firefox}"; fi
if [ $geckosdk == yes ]; then echo " --with-gecko-sdk={path to gecko sdk}"; echo ; echo "You need to install the gecko-sdk"; fi
echo 



