#!/usr/bin/python

import pygtk
pygtk.require('2.0')

import gobject
import gconf
import gtk

import copy
import os.path

class configmbox(gtk.Dialog):

    # On row change in indicators list
    # Update name and type on the bottom of the list
    def select_row_indicators(self, data):
        model, iter = data.get_selected()
        if(iter):
            self.entry_name.set_text(model.get_value(iter, 1))            
            type=model.get_value(iter, 2)
            if(type=="text"):
                self.choice_type.set_history(0)
            elif(type=="pixmap"):
                self.choice_type.set_history(1)
            else:
                print "Type error!"           

    # Add an entry in indicators list 
    def add_clicked_indicators(self, data):
        # get the infos
        name = self.entry_name.get_text().replace(" ","_")
        type = self.choice_type.get_children()[0].get_label()
        if(name):
            # check if the entry already exist
            if(self.indicators_names.count(name)==0):
                self.indicators[name]=[gtk.TRUE, type, []]
                self.indicators_names.append(name)

                self.gconf_client.set_bool("/apps/mbox-check-applet/"+name+"/activate", gtk.TRUE)
                self.gconf_client.set_string("/apps/mbox-check-applet/"+name+"/type", type)
                self.gconf_client.set_list("/apps/mbox-check-applet/"+name+"/list_of_mbox", gconf.VALUE_STRING, [])

                self.gconf_client.set_list("/apps/mbox-check-applet/indicators_names", gconf.VALUE_STRING, self.indicators_names)
                self.list_view_indicators.get_model().append((gtk.TRUE, name, type))
                self.entry_name.set_text("")
                self.choice_type.set_history(0)
            else:
                print "this name already exist"
        else:
            print "Error : no name"

    # Remove an entry in indicators list
    def delete_clicked_indicators(self, data):
        model,iter = self.list_view_indicators.get_selection().get_selected()
        if(iter):
            name=model.get_value(iter, 1)
            del self.indicators[name]
            self.gconf_client.unset("/apps/mbox-check-applet/"+name+"/activate")
            self.gconf_client.unset("/apps/mbox-check-applet/"+name+"/type")
            self.gconf_client.unset("/apps/mbox-check-applet/"+name+"/list_of_mbox")                
            
            self.indicators_names.remove(name)
            self.gconf_client.set_list("/apps/mbox-check-applet/indicators_names", gconf.VALUE_STRING, self.indicators_names)
            model.remove(iter)
            self.entry_name.set_text("")
            self.choice_type.set_history(0)

    # Modify an entry in indicators list
    def modify_clicked_indicators(self, data):
        name=self.entry_name.get_text().replace(" ","_")
        type = self.choice_type.get_children()[0].get_label()
        model,iter = self.list_view_indicators.get_selection().get_selected()
        if(iter):
            oldname=model.get_value(iter, 1)
            if(name):
                if(name==oldname or self.indicators_names.count(name)==0):
                    num = self.indicators_names.index(oldname)
                    self.indicators_names.remove(oldname)
                    self.indicators_names.insert(num, name)
                    self.gconf_client.set_list("/apps/mbox-check-applet/indicators_names", gconf.VALUE_STRING, self.indicators_names)

                    list = self.indicators[oldname][2]
                    del self.indicators[oldname]

                    self.indicators[name] = [model.get_value(iter, 0), type, list]

                    self.gconf_client.unset("/apps/mbox-check-applet/"+oldname+"/activate")
                    self.gconf_client.unset("/apps/mbox-check-applet/"+oldname+"/type")
                    self.gconf_client.unset("/apps/mbox-check-applet/"+oldname+"/list_of_mbox")                

                    self.gconf_client.set_bool("/apps/mbox-check-applet/"+name+"/activate", model.get_value(iter, 0))
                    self.gconf_client.set_string("/apps/mbox-check-applet/"+name+"/type", type)
                    self.gconf_client.set_list("/apps/mbox-check-applet/"+name+"/list_of_mbox", gconf.VALUE_STRING, list)
                    
                    model.set_value(iter, 1, name)
                    model.set_value(iter, 2, type)
                else:
                    print "this name already exist"

    # Switch check box status on the first column of the indicators list
    def toggle_activate_indicators(self, widget, data):        
        model,iter = self.list_view_indicators.get_selection().get_selected()
        activate = model[data][0]
        model[data][0] = not activate
        self.indicators[model[data][1]][0]=not activate
        self.gconf_client.set_bool("/apps/mbox-check-applet/"+model[data][1]+"/activate", not activate)      

    # Browse files
    def filename_browse(self, data):
        filesel = gtk.FileSelection("Choose some mboxes files")
        filesel.set_select_multiple(gtk.TRUE)
        filesel.connect("destroy", self.filesel_destroy, filesel)

        filesel.ok_button.connect("clicked", self.filename_ok, filesel)
        filesel.cancel_button.connect("clicked", self.filesel_destroy, filesel)

        name = self.entry_filename.get_text()
        if(name):
            filesel.set_filename(name)
        else:
            filesel.set_filename("/var/mail/")
                
        filesel.show()

    # Function to fix problem with self argument passed to destroy() method
    def filesel_destroy(self, widget, filesel):
        filesel.destroy()

    # Validate a file
    def filename_ok(self, widget, data):
        list_files =  data.get_selections()

        for files in list_files:
            if(os.path.isfile(files)==1):
                self.list_view_mbox.get_model().append((files,"black"))
                self.mbox2check.append(files)
        self.gconf_client.set_list("/apps/mbox-check-applet/mbox2check", gconf.VALUE_STRING, self.mbox2check)
        data.destroy()

    # On row selection in the mbox list
    # Update filename entry
    def select_mbox_row(self, data):
        i=0
        model = data.get_tree_view().get_model()
        while(i < len(model)):
            if(data.path_is_selected(i)):
                self.entry_filename.set_text(model[i][0])
                break
            i=i+1

    # Add file in the list
    def add_mbox_clicked(self, data):
        name = self.entry_filename.get_text()
        if(name):
            if(self.mbox2check.count(name)==0):
                self.mbox2check.append(name)
                self.gconf_client.set_list("/apps/mbox-check-applet/mbox2check", gconf.VALUE_STRING, self.mbox2check)
                if(os.path.exists(name)==False):
                    self.list_view_mbox.get_model().append((name,"red"))
                else:
                    self.list_view_mbox.get_model().append((name,"black"))
                self.entry_filename.set_text("")
            else:
                print "mbox already in list"
        else:
            print "Error : no name"

    # Modify an mbox entry in the list
    def modify_mbox_clicked(self, data):
        name=self.entry_filename.get_text()
        select =  self.list_view_mbox.get_selection()
        model = select.get_tree_view().get_model()
        i=0
        while(i < len(model)):
            if(select.path_is_selected(i)):
                break
            i=i+1              
        oldname = model[i][0]
        if(name):
            self.mbox2check.remove(oldname)
            self.mbox2check.append(name)
            for iname in self.indicators_names:
                list_mbox = self.indicators[iname][2]
                if(list_mbox.count(oldname)!=0):
                    list_mbox.remove(oldname)
                    list_mbox.append(name)
                    self.gconf_client.set_list("/apps/mbox-check-applet/"+iname+"/list_of_mbox", gconf.VALUE_STRING, list_mbox)
            self.gconf_client.set_list("/apps/mbox-check-applet/mbox2check", gconf.VALUE_STRING, self.mbox2check)
            model[i][0] = name
            if(os.path.exists(name)==False):
                model[i][1] = "red"
            else:
                model[i][1] = "black"

    # Remove an mbox file from the list
    def delete_mbox_clicked(self, data):
        select =  self.list_view_mbox.get_selection()
        model = select.get_tree_view().get_model()
        i = len(model)-1
        while(i >= 0):
            if(select.path_is_selected(i)):
                name=model[i][0]
                self.mbox2check.remove(name)
                del model[i]
                for iname in self.indicators_names:
                    list_mbox = self.indicators[iname][2]
                    if(list_mbox.count(name)!=0):
                        list_mbox.remove(name)
                        self.gconf_client.set_list("/apps/mbox-check-applet/"+iname+"/list_of_mbox", gconf.VALUE_STRING, list_mbox)
            i=i-1
        self.gconf_client.set_list("/apps/mbox-check-applet/mbox2check", gconf.VALUE_STRING, self.mbox2check)
        self.entry_filename.set_text("")

    # Signals from buttons of the main dialog
    def config_response(self, widget, data):
        self.run_list=[]
        self.run_list.append(self.entry_runrecv.get_text())
        self.run_list.append(self.entry_runclick.get_text())
        
        if(data == gtk.RESPONSE_ACCEPT):
            self.config_ok(copy.deepcopy(self.mbox2check), copy.deepcopy(self.indicators), copy.deepcopy(self.indicators_names), copy.deepcopy(self.time), copy.deepcopy(self.tooltips_infos), copy.deepcopy(self.run_infos), copy.deepcopy(self.run_list), gtk.TRUE)
            self.destroy()
        if(data == gtk.RESPONSE_APPLY):
            self.config_ok(copy.deepcopy(self.mbox2check), copy.deepcopy(self.indicators), copy.deepcopy(self.indicators_names), copy.deepcopy(self.time), copy.deepcopy(self.tooltips_infos), copy.deepcopy(self.run_infos), copy.deepcopy(self.run_list), gtk.TRUE)

    # Dialog window
    # To choice which mbox add to an indicator
    def indicator_choice_mbox(self, data):
        window = gtk.Dialog("Config")
        window.set_title("mbox choice")
        window.set_modal(gtk.FALSE)

        # List with 1 sting (the second entry is a fix ... append 1 element
        # seems to doesn't work ... need to look on that)
        list_model = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING)        

        vbox=gtk.VBox(gtk.FALSE, 2)
       
        # View
        list_view = gtk.TreeView(list_model)
        list_view.set_reorderable(gtk.FALSE)

        # Selection 
        selection = list_view.get_selection()
        selection.set_mode(gtk.SELECTION_MULTIPLE)

        # One text column
        renderer = gtk.CellRendererText()
        column = gtk.TreeViewColumn("Names", renderer, text=0)
        list_view.append_column(column)

        # The list is in a ScrolledWindow
        scrolled = gtk.ScrolledWindow()
        scrolled.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        scrolled.add(list_view)

        # And in a frame
        frame = gtk.Frame(label=None)
        frame.add(scrolled)
        
        vbox.pack_start(frame, gtk.TRUE, gtk.TRUE, 0)

        button=gtk.Button("OK", gtk.STOCK_OK)
        #vbox.pack_start(button, gtk.FALSE, gtk.FALSE, 10)
        window.action_area.pack_start(button, gtk.TRUE, gtk.TRUE, 10)
        button.connect('clicked', self.validate_mbox_list, list_view)
        button.connect_after('clicked', lambda w: window.destroy())

        i = 0

        # Add all the mbox to the list
        for mbox in self.mbox2check:
            list_model.append((mbox, ''))

            model,iter = self.list_view_indicators.get_selection().get_selected()
            if(iter):
                name=model.get_value(iter, 1)
                # And select the right entries
                if(self.indicators[name][2].count(mbox)==1):
                    list_view.get_selection().select_path(i)
                i = i +1 

        #window.add(vbox)
        window.vbox.pack_start(vbox, gtk.TRUE, gtk.TRUE, 10)
        window.set_default_size(200, 300)
        window.set_modal(gtk.TRUE)
        window.show_all()

    # On mbox list for an indicator validation
    def validate_mbox_list(self, widget, data):
        list=[]
        # Add all the selected mboxs
        data.get_selection().selected_foreach(self.get_selected_mbox, list)
        model,iter = self.list_view_indicators.get_selection().get_selected()
        if(iter):
            name=model.get_value(iter, 1)
            self.indicators[name][2]=list
            self.gconf_client.set_list("/apps/mbox-check-applet/"+name+"/list_of_mbox", gconf.VALUE_STRING, list)

    # Add to data list the mbox name
    def get_selected_mbox(self, list, n_row, iter, data):
        data.append(list[n_row][0])

    def time_change(self, widget, data):
        min = data[0].get_value()
        sec = data[1].get_value()
        if(sec==0):
            if(min==0):
                data[0].set_value(1)
                min = 1
        self.time = 60*min+sec

    def tooltip_onoff(self, widget, data):
        self.tooltips_infos[data] = widget.get_active()
        if(data==0):
            if(self.tooltips_infos[0]==False):
                self.check_tt_name.set_sensitive(False)
                self.check_tt_num.set_sensitive(False)
                self.check_tt_list.set_sensitive(False)
            else:
                self.check_tt_name.set_sensitive(True)
                self.check_tt_num.set_sensitive(True)
                self.check_tt_list.set_sensitive(True)

        self.gconf_client.set_list("/apps/mbox-check-applet/tooltips_infos", gconf.VALUE_BOOL, self.tooltips_infos)

    def test(self, data1, data2, data3):
        print "\n*****"
        for row in data1:
            print row[1]

    def indicator_up(self, widget, data):
        model,iter = self.list_view_indicators.get_selection().get_selected()
        if(iter):
            row_num = model.get_path(iter)[0]
            if(row_num==0):
                return
            iter_new = model.get_iter(row_num-1)
            if(iter_new):
                activate = model.get_value(iter, 0)
                name = model.get_value(iter, 1)
                type = model.get_value(iter, 2)

                model.remove(iter)
                iter_data = model.insert_before(iter_new)
                
                model.set_value(iter_data, 0, activate)
                model.set_value(iter_data, 1, name)
                model.set_value(iter_data, 2, type)
                self.list_view_indicators.get_selection().select_iter(iter_data)

                pos = self.indicators_names.index(name)
                self.indicators_names.remove(name)
                self.indicators_names.insert(pos-1, name)
                self.gconf_client.set_list("/apps/mbox-check-applet/indicators_names", gconf.VALUE_STRING, self.indicators_names)

    def indicator_down(self, widget, data):
        model,iter = self.list_view_indicators.get_selection().get_selected()
        if(iter):
            row_num = model.get_path(iter)[0]
            if(row_num == len(model)-1):
                return
            iter_new = model.get_iter(row_num+1)
            if(iter_new):
                activate = model.get_value(iter, 0)
                name = model.get_value(iter, 1)
                type = model.get_value(iter, 2)

                model.remove(iter)
                iter_data = model.insert_after(iter_new)
                
                model.set_value(iter_data, 0, activate)
                model.set_value(iter_data, 1, name)
                model.set_value(iter_data, 2, type)
                self.list_view_indicators.get_selection().select_iter(iter_data)

                pos = self.indicators_names.index(name)
                self.indicators_names.remove(name)
                self.indicators_names.insert(pos+1, name)
                self.gconf_client.set_list("/apps/mbox-check-applet/indicators_names", gconf.VALUE_STRING, self.indicators_names)

    def run_onoff(self, widget, data):
        self.run_infos[data] = widget.get_active()
        if(data==0):
           if(self.run_infos[0]==False):
                self.entry_runrecv.set_sensitive(False)
           else:
               self.entry_runrecv.set_sensitive(True)
        if(data==1):
           if(self.run_infos[1]==False):
                self.entry_runclick.set_sensitive(False)
           else:
               self.entry_runclick.set_sensitive(True)

    def close_config(self, widget, data):
            self.config_ok(copy.deepcopy(self.mbox2check), copy.deepcopy(self.indicators), copy.deepcopy(self.indicators_names), copy.deepcopy(self.time), copy.deepcopy(self.tooltips_infos), copy.deepcopy(self.run_infos), copy.deepcopy(self.run_list), gtk.FALSE)        
               
    # Init of the class
    def __init__(self, config_ok, gconf_client, mbox2check, indicators_names, indicators, time, tooltips_infos, run_infos, run_list):

        gtk.Dialog.__init__(self, "Config", buttons=(gtk.STOCK_OK, gtk.RESPONSE_ACCEPT, gtk.STOCK_APPLY, gtk.RESPONSE_APPLY))
        self.set_default_size(500, 400)
        self.config_ok = config_ok
        self.gconf_client = gconf_client
        self.mbox2check = mbox2check
        self.indicators_names = indicators_names
        self.indicators = indicators
        self.time = time
        self.tooltips_infos = tooltips_infos
        self.run_infos = run_infos
        self.run_list = run_list
               
        notebook = gtk.Notebook()

        vbox=gtk.VBox(gtk.FALSE, 2)
        label=gtk.Label("")
        label.set_markup("<b>List of the indicators</b>")
        vbox.pack_start(label, gtk.FALSE, gtk.FALSE, 5)

        hbox=gtk.HBox(gtk.FALSE, 2)

        label=gtk.Label()
        hbox.pack_start(label, gtk.FALSE, gtk.FALSE, 2)

        # List for indicators 
        list_model_indicators = gtk.ListStore(gobject.TYPE_BOOLEAN, gobject.TYPE_STRING, gobject.TYPE_STRING)

        # View
        self.list_view_indicators = gtk.TreeView(list_model_indicators)
        self.list_view_indicators.set_reorderable(gtk.FALSE)

        #list_model_indicators.connect_after("row-changed", self.test)
        
        # Selection
        selection = self.list_view_indicators.get_selection()
        selection.connect("changed", self.select_row_indicators)

        # Columns
        renderer = gtk.CellRendererToggle()
        column = gtk.TreeViewColumn("Activate", renderer, active=0)
        self.list_view_indicators.append_column(column)
        renderer.connect_after("toggled", self.toggle_activate_indicators)
        
        renderer = gtk.CellRendererText()
        column = gtk.TreeViewColumn("Name", renderer, text=1)
        column.set_min_width(200)
        self.list_view_indicators.append_column(column)

        renderer = gtk.CellRendererText()
        column = gtk.TreeViewColumn("Type", renderer, text=2)
        self.list_view_indicators.append_column(column)

        # The list is on a ScrolledWindow
        scrolled = gtk.ScrolledWindow()
        scrolled.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        scrolled.add(self.list_view_indicators)

        # And in a Frame
        frame = gtk.Frame(label=None)
        frame.add(scrolled)

        hbox.pack_start(frame, gtk.TRUE, gtk.TRUE, 0)

        vbox_up=gtk.VBox(gtk.FALSE, 2)
        
        button = gtk.Button()
        image = gtk.Image()
        image.set_from_stock(gtk.STOCK_GO_UP, gtk.ICON_SIZE_MENU)
        button.add(image)
        button.connect("clicked", self.indicator_up, 0)
        vbox_up.pack_start(button, gtk.TRUE, gtk.TRUE, 0)

        button = gtk.Button()
        image = gtk.Image()
        image.set_from_stock(gtk.STOCK_GO_DOWN, gtk.ICON_SIZE_MENU)
        button.add(image)
        button.connect("clicked", self.indicator_down, 0)
        vbox_up.pack_start(button, gtk.TRUE, gtk.TRUE, 0)

        hbox.pack_start(vbox_up, gtk.FALSE, gtk.FALSE, 0)

        label=gtk.Label()
        hbox.pack_start(label, gtk.FALSE, gtk.FALSE, 2)
        
        vbox.pack_start(hbox, gtk.TRUE, gtk.TRUE, 5)

        table = gtk.Table(2, 2, gtk.FALSE)

        label = gtk.Label("Name :")
        table.attach(label, 0, 1, 0, 1, ypadding=5)

        label = gtk.Label("Type :")
        table.attach(label, 0, 1, 1, 2, ypadding=5)

        self.entry_name = gtk.Entry(max=0)
        table.attach(self.entry_name, 1, 2, 0, 1, xpadding=10)

        menu_type = gtk.Menu()

        menu_item = gtk.MenuItem("text")
        menu_type.append(menu_item)
        menu_item = gtk.MenuItem("pixmap")
        menu_type.append(menu_item)

        self.choice_type = gtk.OptionMenu()        
        self.choice_type.set_menu(menu_type)
        table.attach(self.choice_type, 1, 2, 1, 2, xpadding=10)

        vbox.pack_start(table, gtk.FALSE, gtk.FALSE, 0)

        hbox=gtk.HBox(gtk.FALSE, 2)

        button=gtk.Button("Add", gtk.STOCK_ADD)
        hbox.pack_start(button, gtk.TRUE, gtk.TRUE, 10)
        button.connect('clicked', self.add_clicked_indicators)

        button=gtk.Button("Modify", gtk.STOCK_APPLY)
        hbox.pack_start(button, gtk.TRUE, gtk.TRUE, 10)
        button.connect('clicked', self.modify_clicked_indicators)
        
        button=gtk.Button("Delete", gtk.STOCK_DELETE)
        hbox.pack_start(button, gtk.TRUE, gtk.TRUE, 10)
        button.connect('clicked', self.delete_clicked_indicators)
        
        vbox.pack_start(hbox, gtk.FALSE, gtk.FALSE, 5)

        hbox=gtk.HBox(gtk.FALSE, 2)
        button=gtk.Button("Config mbox")
        hbox.pack_start(button, gtk.TRUE, gtk.TRUE, 10)
        button.connect('clicked', self.indicator_choice_mbox)
        
        vbox.pack_start(hbox, gtk.FALSE, gtk.FALSE, 5)

        nb_label1=gtk.Label('Indicators config')
        notebook.append_page(vbox, nb_label1)



        vbox=gtk.VBox(gtk.FALSE, 2)
        label=gtk.Label("")
        label.set_markup("<b>List of the mboxes</b>")
        vbox.pack_start(label, gtk.FALSE, gtk.FALSE, 5)

        # List for mboxs
        list_model_mbox = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING)        
       
        # View
        self.list_view_mbox = gtk.TreeView(list_model_mbox)
        self.list_view_mbox.set_reorderable(gtk.FALSE)

        # Selection
        selection = self.list_view_mbox.get_selection()
        selection.set_mode(gtk.SELECTION_MULTIPLE)                
        selection.connect("changed", self.select_mbox_row)

        # Columns
        renderer = gtk.CellRendererText()
        column = gtk.TreeViewColumn("Names", renderer, text=0, foreground=1)
        self.list_view_mbox.append_column(column)

        # The list is on a ScrolledWindow
        scrolled = gtk.ScrolledWindow()
        scrolled.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        scrolled.add(self.list_view_mbox)

        # And in a Frame
        frame = gtk.Frame(label=None)
        frame.add(scrolled)
        
        vbox.pack_start(frame, gtk.TRUE, gtk.TRUE, 0)

        hbox=gtk.HBox(gtk.FALSE, 2)
               
        label = gtk.Label("Name :")
        hbox.pack_start(label, gtk.FALSE, gtk.FALSE, 10)

        self.entry_filename = gtk.Entry(max=0)
        hbox.pack_start(self.entry_filename, gtk.TRUE, gtk.TRUE, 10)

        vbox.pack_start(hbox, gtk.FALSE, gtk.FALSE, 5)

        button=gtk.Button("Add files")
        hbox=gtk.HBox(gtk.FALSE, 0)
        hbox.pack_start(button, gtk.TRUE, gtk.TRUE, 10)
        vbox.pack_start(hbox, gtk.FALSE, gtk.FALSE, 0)
        button.connect('clicked', self.filename_browse)
        
        hbox=gtk.HBox(gtk.FALSE, 2)

        button=gtk.Button("Add", gtk.STOCK_ADD)
        hbox.pack_start(button, gtk.TRUE, gtk.TRUE, 10)
        button.connect('clicked', self.add_mbox_clicked)

        button=gtk.Button("Modify", gtk.STOCK_APPLY)
        hbox.pack_start(button, gtk.TRUE, gtk.TRUE, 10)
        button.connect('clicked', self.modify_mbox_clicked)
        
        button=gtk.Button("Delete", gtk.STOCK_DELETE)
        hbox.pack_start(button, gtk.TRUE, gtk.TRUE, 10)
        button.connect('clicked', self.delete_mbox_clicked)
        
        vbox.pack_start(hbox, gtk.FALSE, gtk.FALSE, 5)

        label=gtk.Label('Mboxes config')
        notebook.append_page(vbox, label)

        vbox=gtk.VBox(gtk.FALSE, 5)

        hbox=gtk.HBox(gtk.FALSE, 5)
        label=gtk.Label("Check the mboxes all the : ")
        hbox.pack_start(label, gtk.FALSE, gtk.FALSE, 10)

        adj = gtk.Adjustment(0.0, 0.0, 1440.0, 1.0, 5.0, 0.0)
        spin_button_min = gtk.SpinButton(adj, 0, 0)
        hbox.pack_start(spin_button_min, gtk.FALSE, gtk.FALSE, 2)

        label=gtk.Label("minutes")
        hbox.pack_start(label, gtk.FALSE, gtk.FALSE, 0)

        adj = gtk.Adjustment(30.0, 0.0, 59.0, 1.0, 5.0, 0.0)
        spin_button_sec = gtk.SpinButton(adj, 0, 0)
        hbox.pack_start(spin_button_sec, gtk.FALSE, gtk.FALSE, 2)

        label=gtk.Label("seconds")
        hbox.pack_start(label, gtk.FALSE, gtk.FALSE, 0)

        spin_button_min.set_value(time / 60)
        spin_button_sec.set_value(time % 60)

        spin_button_min.connect("value-changed", self.time_change, (spin_button_min, spin_button_sec))
        spin_button_sec.connect("value-changed", self.time_change, (spin_button_min, spin_button_sec))       

        vbox.pack_start(hbox, gtk.FALSE, gtk.FALSE, 15)
        
        vbox_tooltip=gtk.VBox(gtk.FALSE, 5)

        hbox=gtk.HBox(gtk.FALSE, 5)
        check_tooltip = gtk.CheckButton("Tooltips are enable")
        check_tooltip.connect("toggled", self.tooltip_onoff, 0)
        hbox.pack_start(check_tooltip, gtk.FALSE, gtk.FALSE, 10)
        vbox_tooltip.pack_start(hbox, gtk.FALSE, gtk.FALSE, 0)

        hbox=gtk.HBox(gtk.FALSE, 5)
        self.check_tt_name = gtk.CheckButton("Show name of the indicator")
        self.check_tt_name.connect("toggled", self.tooltip_onoff, 1)
        hbox.pack_start(self.check_tt_name, gtk.FALSE, gtk.FALSE, 40)
        vbox_tooltip.pack_start(hbox, gtk.FALSE, gtk.FALSE, 0)

        if(self.tooltips_infos[1]==True):
            self.check_tt_name.set_active(True)
        else:
            self.check_tt_name.set_active(False)

        hbox=gtk.HBox(gtk.FALSE, 5)
        self.check_tt_num = gtk.CheckButton("Show number of mails")
        self.check_tt_num.connect("toggled", self.tooltip_onoff, 2)
        hbox.pack_start(self.check_tt_num, gtk.FALSE, gtk.FALSE, 40)
        vbox_tooltip.pack_start(hbox, gtk.FALSE, gtk.FALSE, 0)

        if(self.tooltips_infos[2]==True):
            self.check_tt_num.set_active(True)
        else:
            self.check_tt_num.set_active(False)

        hbox=gtk.HBox(gtk.FALSE, 5)
        self.check_tt_list = gtk.CheckButton("Show a list with the boxes")
        self.check_tt_list.connect("toggled", self.tooltip_onoff, 3)
        hbox.pack_start(self.check_tt_list, gtk.FALSE, gtk.FALSE, 40)
        vbox_tooltip.pack_start(hbox, gtk.FALSE, gtk.FALSE, 0)

        if(self.tooltips_infos[3]==True):
            self.check_tt_list.set_active(True)
        else:
            self.check_tt_list.set_active(False)

        if(self.tooltips_infos[0]==True):
            check_tooltip.set_active(True)
        else:
            check_tooltip.set_active(False)
            self.check_tt_name.set_sensitive(False)
            self.check_tt_num.set_sensitive(False)
            self.check_tt_list.set_sensitive(False)


        frame = gtk.Frame("Tooltips")
        frame.add(vbox_tooltip)

        vbox.pack_start(frame, gtk.FALSE, gtk.FALSE, 5)


        vbox_run=gtk.VBox(gtk.FALSE, 5)

        hbox=gtk.HBox(gtk.FALSE, 5)
        check_run_on_receive = gtk.CheckButton("Run on receive")
        check_run_on_receive.connect("toggled", self.run_onoff, 0)
        hbox.pack_start(check_run_on_receive, gtk.FALSE, gtk.FALSE, 10)

        self.entry_runrecv = gtk.Entry(max=0)
        self.entry_runrecv.set_text(self.run_list[0])
        hbox.pack_start(self.entry_runrecv, gtk.TRUE, gtk.TRUE, 10)
        
        if(self.run_infos[0]==True):
            check_run_on_receive.set_active(True)
            self.entry_runrecv.set_sensitive(True)
        else:
            check_run_on_receive.set_active(False)
            self.entry_runrecv.set_sensitive(False)

        vbox_run.pack_start(hbox, gtk.FALSE, gtk.FALSE, 0)


        hbox=gtk.HBox(gtk.FALSE, 5)
        check_run_on_click = gtk.CheckButton("Run on click    ")
        check_run_on_click.connect("toggled", self.run_onoff, 1)
        hbox.pack_start(check_run_on_click, gtk.FALSE, gtk.FALSE, 11)

        self.entry_runclick = gtk.Entry(max=0)
        self.entry_runclick.set_text(self.run_list[1])
        hbox.pack_start(self.entry_runclick, gtk.TRUE, gtk.TRUE, 10)

        if(self.run_infos[1]==True):
            check_run_on_click.set_active(True)
            self.entry_runclick.set_sensitive(True)
        else:
            check_run_on_click.set_active(False)
            self.entry_runclick.set_sensitive(False)

        vbox_run.pack_start(hbox, gtk.FALSE, gtk.FALSE, 0)

        frame = gtk.Frame("Run")
        frame.add(vbox_run)

        vbox.pack_start(frame, gtk.FALSE, gtk.FALSE, 5)


        label=gtk.Label('Options')
        notebook.append_page(vbox, label)


        self.set_border_width(5)
        self.vbox.pack_start(notebook, gtk.TRUE, gtk.TRUE, 10)
        self.connect('response', self.config_response)


        # Init mboxs list
        for mbox in self.mbox2check:
            if(os.path.exists(mbox)==False):
                list_model_mbox.append((mbox, 'red'))
            else:
                list_model_mbox.append((mbox, 'black'))

        # Init indicators list
        for key in self.indicators_names:
            list_model_indicators.append((self.indicators[key][0], key, self.indicators[key][1]))
            
        self.set_modal(gtk.FALSE)
        self.connect("destroy", self.close_config, 0)
        
        self.show_all()

def main():
    gtk.main()
    return 0

if __name__ == "__main__":

    # Get the default client
    gconf_client = gconf.client_get_default ();

    gconf_client.add_dir ("/apps/mbox-check-applet", gconf.CLIENT_PRELOAD_NONE)        


    tooltips_infos = gconf_client.get_list("/apps/mbox-check-applet/tooltips_infos", gconf.VALUE_BOOL)
    if(len(tooltips_infos) != 4):
       tooltips_infos = [True, True, True, True]    

    run_infos = gconf_client.get_list("/apps/mbox-check-applet/run_infos", gconf.VALUE_BOOL)
    if(len(run_infos) != 2):
       run_infos = [False, False]

    run_list = gconf_client.get_list("/apps/mbox-check-applet/run_list", gconf.VALUE_STRING)
    if(len(run_infos) != 2):
       run_infos = ["", ""]

    # List of mboxes to check
    mbox2check = gconf_client.get_list("/apps/mbox-check-applet/mbox2check", gconf.VALUE_STRING)
    
    # List of indicators
    indicators_names = gconf_client.get_list("/apps/mbox-check-applet/indicators_names", gconf.VALUE_STRING)

    # Datas for indicators
    indicators={}
    for data in indicators_names:
        activate = gconf_client.get_bool("/apps/mbox-check-applet/"+data+"/activate")
        type = gconf_client.get_string("/apps/mbox-check-applet/"+data+"/type")
        list = gconf_client.get_list("/apps/mbox-check-applet/"+data+"/list_of_mbox", gconf.VALUE_STRING)
        indicators[data] = [activate, type, list]

    time = gconf_client.get_int("/apps/mbox-check-applet/time2check")

    configmbox(None, gconf_client, mbox2check, indicators_names, indicators, time, tooltips_infos, run_infos, run_list)
    main()
