/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file GraphSymbolAttributes.cc
    \brief Implemtation of GraphSymbol Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Mar  5 17:12:42 2012
*/    

#include "GraphSymbolAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


GraphSymbolAttributes::GraphSymbolAttributes():
	marker_(ParameterManager::getInt("graph_symbol_marker_index")),
	height_(ParameterManager::getDouble("graph_symbol_height")),
	colour_(MagTranslator<string, Colour>().magics("graph_symbol_colour"))
{
} 



GraphSymbolAttributes::~GraphSymbolAttributes()
{
}

    
void GraphSymbolAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(0);

	setAttribute(prefix, "graph_symbol_marker_index", marker_, params);
	setAttribute(prefix, "graph_symbol_height", height_, params);
	setAttribute(prefix, "graph_symbol_colour", colour_, params);
}

void GraphSymbolAttributes::copy(const GraphSymbolAttributes& other)
{
	marker_ = other.marker_;
	height_ = other.height_;
	setColour(other.colour_->clone());
} 


bool GraphSymbolAttributes::accept(const string& node)
{	
	if ( magCompare(node, "")  )
		return true;
	return false;
}

void GraphSymbolAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	set(node.attributes());
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void GraphSymbolAttributes::print(ostream& out)  const
{
	out << "GraphSymbolAttributes[";
	out << "marker = " << marker_;
	out << ", height = " << height_;
	out << ", colour = " << *colour_;
	out << "]" << "\n";
}


void GraphSymbolAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"\"";
	 out << ", \"graph_symbol_marker_index\":";
	 niceprint(out,marker_);
	 out << ", \"graph_symbol_height\":";
	 niceprint(out,height_);
	 out << ", \"graph_symbol_colour\":";
	 niceprint(out, *colour_);
}
static MagicsParameter<int> graph_symbol_marker_index("graph_symbol_marker_index", 3, "");
static MagicsParameter<double> graph_symbol_height("graph_symbol_height", 0.2, "");
static MagicsParameter<string> graph_symbol_colour("graph_symbol_colour", "red", "");
