/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file XmlSceneNodeAttributes.h
    \brief Definition of XmlSceneNode Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:44 2012
*/
   

#ifndef XmlSceneNodeAttributes_H
#define XmlSceneNodeAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "PageID.h"
#include "Colour.h"

namespace magics {

class XmlNode;



class XmlSceneNodeAttributes 
{
public:
//  --  constructor
    XmlSceneNodeAttributes();
    
//  --  destructor
    virtual ~XmlSceneNodeAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const XmlSceneNodeAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Y-Coordinate of bottom of View.
    \param display Setting view_display - default=inline
*/
	void setDisplay(DisplayType display) 
		{ display_ =  display; } 
	DisplayType getDisplay() const 
		{ return display_; } 
        
/*!
    Magics Information:
    \brief  Y-Coordinate of bottom of View.
    \param bottom Setting scene_node_bottom - default=0%
*/
	void setBottom(const string& bottom) 
		{ bottom_ =  bottom; } 
	const string& getBottom() const 
		{ return bottom_; } 
        
/*!
    Magics Information:
    \brief  X-Coordinate of bottom of View.
    \param left Setting scene_node_left - default=0%
*/
	void setLeft(const string& left) 
		{ left_ =  left; } 
	const string& getLeft() const 
		{ return left_; } 
        
/*!
    Magics Information:
    \brief  width of the View .
    \param width Setting scene_node_width - default=100%
*/
	void setWidth(const string& width) 
		{ width_ =  width; } 
	const string& getWidth() const 
		{ return width_; } 
        
/*!
    Magics Information:
    \brief  Height of View.
    \param height Setting scene_node_height - default=100%
*/
	void setHeight(const string& height) 
		{ height_ =  height; } 
	const string& getHeight() const 
		{ return height_; } 
        
/*!
    Magics Information:
    \brief  Y-Coordinate of bottom of View.
    \param margin_bottom Setting scene_node_margin_bottom - default=0%
*/
	void setMargin_bottom(const string& margin_bottom) 
		{ margin_bottom_ =  margin_bottom; } 
	const string& getMargin_bottom() const 
		{ return margin_bottom_; } 
        
/*!
    Magics Information:
    \brief  X-Coordinate of bottom of View.
    \param margin_left Setting scene_node_margin_left - default=0%
*/
	void setMargin_left(const string& margin_left) 
		{ margin_left_ =  margin_left; } 
	const string& getMargin_left() const 
		{ return margin_left_; } 
        
/*!
    Magics Information:
    \brief  width of the View .
    \param margin_right Setting scene_node_margin_right - default=0%
*/
	void setMargin_right(const string& margin_right) 
		{ margin_right_ =  margin_right; } 
	const string& getMargin_right() const 
		{ return margin_right_; } 
        
/*!
    Magics Information:
    \brief  Height of View.
    \param margin_top Setting scene_node_margin_top - default=0%
*/
	void setMargin_top(const string& margin_top) 
		{ margin_top_ =  margin_top; } 
	const string& getMargin_top() const 
		{ return margin_top_; } 
        
/*!
    Magics Information:
    \brief  Colour of the subpage background 
    \param background Setting scene_node_background_colour - default=white
*/
	void setBackground(Colour* background) 
		{ auto_ptr<Colour> tmp(background); background_ = tmp; } 
	const Colour&  getBackground() const 
		{ return *background_; }
/*!
    Magics Information:
    \brief  Y-Coordinate of bottom of View.
    \param border_bottom Setting scene_node_border_bottom - default=1px
*/
	void setBorder_bottom(const string& border_bottom) 
		{ border_bottom_ =  border_bottom; } 
	const string& getBorder_bottom() const 
		{ return border_bottom_; } 
        
/*!
    Magics Information:
    \brief  X-Coordinate of bottom of View.
    \param border_left Setting scene_node_border_left - default=1px
*/
	void setBorder_left(const string& border_left) 
		{ border_left_ =  border_left; } 
	const string& getBorder_left() const 
		{ return border_left_; } 
        
/*!
    Magics Information:
    \brief  width of the View .
    \param border_right Setting scene_node_border_right - default=1px
*/
	void setBorder_right(const string& border_right) 
		{ border_right_ =  border_right; } 
	const string& getBorder_right() const 
		{ return border_right_; } 
        
/*!
    Magics Information:
    \brief  Frame on/off 
    \param border Setting scene_node_border - default=off
*/
	void setBorder(bool border) 
		{ border_ =  border; } 
	bool getBorder() const 
		{ return border_; } 
        
/*!
    Magics Information:
    \brief  Height of View.
    \param border_top Setting scene_node_border_top - default=1px
*/
	void setBorder_top(const string& border_top) 
		{ border_top_ =  border_top; } 
	const string& getBorder_top() const 
		{ return border_top_; } 
        
/*!
    Magics Information:
    \brief  Colour of the subpage background 
    \param border_colour Setting scene_node_border_colour - default=blue
*/
	void setBorder_colour(Colour* border_colour) 
		{ auto_ptr<Colour> tmp(border_colour); border_colour_ = tmp; } 
	const Colour&  getBorder_colour() const 
		{ return *border_colour_; }
/*!
    Magics Information:
    \brief  Colour of the subpage background 
    \param border_style Setting scene_node_border_style - default=solid
*/
	void setBorder_style(LineStyle border_style) 
		{ border_style_ =  border_style; } 
	LineStyle getBorder_style() const 
		{ return border_style_; } 
        
/*!
    Magics Information:
    \brief  Colour of the subpage background 
    \param border_thickness Setting scene_node_border_thickness - default=1
*/
	void setBorder_thickness(int border_thickness) 
		{ border_thickness_ =  border_thickness; } 
	int getBorder_thickness() const 
		{ return border_thickness_; } 
        
/*!
    Magics Information:
    \brief  Y-Coordinate of bottom of View.
    \param padding_bottom Setting scene_node_padding_bottom - default=0%
*/
	void setPadding_bottom(const string& padding_bottom) 
		{ padding_bottom_ =  padding_bottom; } 
	const string& getPadding_bottom() const 
		{ return padding_bottom_; } 
        
/*!
    Magics Information:
    \brief  X-Coordinate of bottom of View.
    \param padding_left Setting scene_node_padding_left - default=0%
*/
	void setPadding_left(const string& padding_left) 
		{ padding_left_ =  padding_left; } 
	const string& getPadding_left() const 
		{ return padding_left_; } 
        
/*!
    Magics Information:
    \brief  width of the View .
    \param padding_right Setting scene_node_padding_right - default=0%
*/
	void setPadding_right(const string& padding_right) 
		{ padding_right_ =  padding_right; } 
	const string& getPadding_right() const 
		{ return padding_right_; } 
        
/*!
    Magics Information:
    \brief  Height of View.
    \param padding_top Setting scene_node_padding_top - default=0%
*/
	void setPadding_top(const string& padding_top) 
		{ padding_top_ =  padding_top; } 
	const string& getPadding_top() const 
		{ return padding_top_; } 
        
/*!
    Magics Information:
    \brief  Colour of the subpage background 
    \param padding_colour Setting scene_node_padding_colour - default=none
*/
	void setPadding_colour(Colour* padding_colour) 
		{ auto_ptr<Colour> tmp(padding_colour); padding_colour_ = tmp; } 
	const Colour&  getPadding_colour() const 
		{ return *padding_colour_; }
/*!
    Magics Information:
    \brief  Plot identification line and ECMWF logo (ON/OFF) 
    \param page_id Setting scene_node_id_line - default=on
*/
	void setPage_id(NoPageID* page_id) 
		{ auto_ptr<NoPageID> tmp(page_id); page_id_ = tmp; } 
	const NoPageID&  getPage_id() const 
		{ return *page_id_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	DisplayType display_;
	string bottom_;
	string left_;
	string width_;
	string height_;
	string margin_bottom_;
	string margin_left_;
	string margin_right_;
	string margin_top_;
	auto_ptr<Colour> background_;
	string border_bottom_;
	string border_left_;
	string border_right_;
	bool border_;
	string border_top_;
	auto_ptr<Colour> border_colour_;
	LineStyle border_style_;
	int border_thickness_;
	string padding_bottom_;
	string padding_left_;
	string padding_right_;
	string padding_top_;
	auto_ptr<Colour> padding_colour_;
	auto_ptr<NoPageID> page_id_;

private:
  
	friend ostream& operator<<(ostream& s,const XmlSceneNodeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
