/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file MgQAnimation.h
    \brief Definition of MgQAnimation 
    \author Graphics Section, ECMWF

    Started: Feb 2010
*/

#ifndef MgQAnimation_H
#define MgQAnimation_H

#include "AnimationRules.h"
#include "QtDriver.h"

using magics::AnimationRules;
using magics::AnimationStep;
using magics::QtDriver;

//namespace magics
//{

class AnimationRules;
class AnimationStep;
class QtDriver;
class MgQStepNode;


class MgQAnimationStep
{
friend class MgQAnimation;

public:
	MgQAnimationStep(int id,AnimationStep* stepObject,const QtDriver& driver) :
		id_(id), stepObject_(stepObject), driver_(driver) {};
	~MgQAnimationStep() {};

	int id() const {return id_;};
	bool cached();
	const vector<string>& label() const {return stepObject_->label();}
	AnimationStep* stepObject() const {return stepObject_;}
	void addNode(MgQStepNode*);
	void setVisible(bool);
	int nodeNum() {return nodes_.count();}
	int cachedNodeNum();

protected:
	void execute() const;
	
	int id_;
	//bool cached_;
	AnimationStep* stepObject_;
	mutable QList<MgQStepNode*> nodes_;
	const QtDriver& driver_;
};


class MgQAnimation : public QList<MgQAnimationStep*>
{

public:	
	MgQAnimation(AnimationRules*,const QtDriver&);
	~MgQAnimation();
	MgQAnimationStep* step(int i) {return (i>=0 && i < count())?at(i):0;}
	void setCurrentStep(int);
	int currentStep() {return currentStep_;}
	int stepNum() {return count();}
	AnimationStep* currentStepObject();
	const QtDriver& driver() const {return driver_;}

protected:
	AnimationRules *rule_;	
	int currentStep_;
	const QtDriver& driver_;
};

//}

#endif
