/*! \file FrameLoop.h
    \brief Definition of the Template class FrameLoop.
    
    Magics Team - ECMWF 2008
    
    Started: Fri 29-Aug-2008
    
    Changes:
    
*/

#ifndef FrameLoop_H
#define FrameLoop_H

#include "magics.h"

#include "BasicGraphicsObject.h"
#include "BasicSceneObject.h"
#include "TagHandler.h"

namespace magics {

class AnimationRules;
class AsIsAnimationRules;

class TopAxisVisitor;
class BottomAxisVisitor;
class LeftAxisVisitor;
class RightAxisVisitor;


class StepRenderer : public BasicGraphicsObject
{
public:
	StepRenderer() {}
	~StepRenderer() {}
	void redisplay(const BaseDriver& driver) const  { driver.redisplay(*this); }
	void print(ostream& out) const { out << "StepRenderer[]"; }
};




class AnimationStep : public vector<BasicSceneObject*>, public TagHandler
{
public:
	AnimationStep(AnimationRules&);
	virtual ~AnimationStep();
	
	template <class V> 
	void visit(V& visitor) {
		for (vector<BasicSceneObject*>::iterator object = begin(); object != end(); ++object) 
			(*object)->visit(visitor);
	}
	
	void rules(vector<string>&);
	AnimationRules& rules_;
   const vector<string>& label(); 
   void addToSlide(BasicGraphicsObject* object) {
	   assert(slide_);
	   slide_->push_back(object);
   }
   void execute(Layout&); 
   void execute(const BaseDriver&,  Layout*); 
   void execute(const BaseDriver& driver,  const Layout& layout)
   {
	   execute(driver, const_cast<Layout*>(&layout));
   }
   void xResolution(double xres) { xResolution_ = std::min(xResolution_, xres); }
   void yResolution(double yres) { yResolution_ = std::min(yResolution_, yres); }
  	double xResolution() const { return xResolution_; }
  	 double yResolution() const { return yResolution_; }
  	
   
		
protected:
	     //! Method to print string about this class on to a stream of type ostream (virtual).
		virtual void print(ostream&) const; 
		vector<string>    label_;
		Layout* slide_;
		 double       xResolution_;
		 double       yResolution_;
		  	 
private:
	    //! Copy constructor - No copy allowed
	AnimationStep(const AnimationStep&);
	    //! Overloaded << operator to copy - No copy allowed
	AnimationStep& operator=(const AnimationStep&);

	// -- Friends
	    //! Overloaded << operator to call print().
		friend ostream& operator<<(ostream& s,const AnimationStep& p)
			{ p.print(s); return s; }
};



class AnimationRules : public vector<AnimationStep*>
{
public:
	AnimationRules(BasicSceneObject&);
	virtual ~AnimationRules();
	
	Layout* execute(AnimationStep& step, Layout& layout) { 
		return owner_.execute(step, layout);
	}
	
	virtual void rules(vector<string>&) const;
	
	virtual void add(vector<BasicSceneObject*>&) {}
	
protected:
	     //! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream&) const; 
	string labelFormat_;
	BasicSceneObject& owner_;
	
private:
	    //! Copy constructor - No copy allowed
	AnimationRules(const AnimationRules&);
	    //! Overloaded << operator to copy - No copy allowed
	AnimationRules& operator=(const AnimationRules&);

	// -- Friends
	    //! Overloaded << operator to call print().
		friend ostream& operator<<(ostream& s,const AnimationRules& p)
			{ p.print(s); return s; }
};



class AsIsAnimationRules : public AnimationRules
{
public:
	AsIsAnimationRules(BasicSceneObject&);
	virtual ~AsIsAnimationRules();
	
	void add(vector<BasicSceneObject*>&);
	void rules(vector<string>&) const;
		
protected:
	     //! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream&) const; 
	
	
};
class  DateAnimationRules : public AnimationRules
{
public:
	DateAnimationRules(BasicSceneObject&);
	virtual ~DateAnimationRules();

	
		
protected:
	     //! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream&) const; 
 
};

} // namespace magics
#endif
