/*
 * Copyright 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *     Ted Gould <ted.gould@canonical.com>
 */

#include "liblomiri-app-launch/registry.h"
#include <iostream>

int main(int argc, char* argv[])
{
    if (argc != 1)
    {
        std::cerr << "Usage: " << argv[0] << std::endl;
        exit(EXIT_FAILURE);
    }

    auto registry = std::make_shared<lomiri::app_launch::Registry>();

    for (auto app : lomiri::app_launch::Registry::installedApps(registry))
    {
        std::cout << std::string(app->appId()) << std::endl;
    }

    return EXIT_SUCCESS;
}
