//
// The contents of this file are subject to the Mozilla Public License
// Version 1.0 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License
// at http://www.mozilla.org/MPL/
// 
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
// the License for the specific language governing rights and
// limitations under the License.
//
// This software was developed as part of the legOS project.
//
// Contributor: Pat Welch (legOS@mousebrains.com)

#ifndef _LightSensor_H_
#define _LightSensor_H_

#include <c++/Sensor.H>

// This is class deals with light sensors
// The methods include:
// LightSensor(sensor port)
// get() returns the value of the active light sensor
// sample(int samples, int delay_milliseconds) returns the average light
//        reading for n samples spaced delay_milliseconds apart
// It also includes all methods in Sensor

class LightSensor : public Sensor {
public:
  LightSensor(const Sensor::Port port) : Sensor(port, true) {}
  unsigned int get() const {return LIGHT(sensor);}
  unsigned int sample(unsigned int size = 10, int wait = 2) const {
    if (size == 0) size = 1;
    unsigned int sum(get());
    for (unsigned int i = 1; i < size; ++i) {
      sum += get();
      delay(wait);
    }
    return sum / size;
  }
};

#endif // _LightSensor_H_
