// GTK_RCPVIEW_WND.CPP

// Copyright (C) 2005 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "gtk_rcpview_wnd.h"

#include "rcpview_wcl.h"
#include "gtk_app.h"

/*################################################################################################*/

GtkActionEntry gtk_rcpview_wnd::entries[] =
{
	{ "AttachDetachRCP", NULL, "Attach/Detach This View", NULL, "Select whether this view is attached or in an independent window", (GCallback) gtk_rcpview_wnd::popup_AttachDetach },
	{ "DeleteViewRCP", NULL, "Delete View", NULL, "Delete this view", (GCallback) gtk_rcpview_wnd::popup_DeleteView }
};

const char * gtk_rcpview_wnd::ui_description =
"<ui>"
"  <popup name='grcpvMenu'>"
"    <menuitem action='AttachDetachRCP'/>"
"    <separator/>"
"    <menuitem action='DeleteViewRCP'/>"
"  </popup>"
"</ui>";

gtk_rcpview_wnd::gtk_rcpview_wnd(bool det_flag) :
	gtk_wnd(det_flag)
{
	GtkActionGroup * action_group = gtk_action_group_new("grcpvActions");
	gtk_action_group_add_actions(action_group, entries, G_N_ELEMENTS(entries), GTK_WIDGET(view_widget));
	
	gtk_ui_manager_insert_action_group(gtk_app::GetUIManager(), action_group, 0);
	
	GError * error = NULL;
	if (!gtk_ui_manager_add_ui_from_string(gtk_app::GetUIManager(), ui_description, -1, & error))
	{
		g_message("Building grcpv menu failed : %s", error->message);
		g_error_free(error); exit(EXIT_FAILURE);
	}
	
	// set gtk_view::popupmenu so that gtk_ogl_view::ButtonHandler() will display it...
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	popupmenu = gtk_ui_manager_get_widget(gtk_app::GetUIManager(), "/grcpvMenu");
}

gtk_rcpview_wnd::~gtk_rcpview_wnd(void)
{
}

// here are the popup menu callbacks:
// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

void gtk_rcpview_wnd::popup_AttachDetach(GtkWidget *, gpointer data)
{
	gtk_wnd * wnd = iv_Find((GtkWidget *) data);
	rcpview_wcl * wcl = dynamic_cast<rcpview_wcl *>(wnd->GetClient());
	
	gtk_app::GetAppX()->AttachDetachView(wcl);
}

void gtk_rcpview_wnd::popup_DeleteView(GtkWidget *, gpointer data)
{
	gtk_wnd * wnd = iv_Find((GtkWidget *) data);
	rcpview_wcl * wcl = dynamic_cast<rcpview_wcl *>(wnd->GetClient());
	
	gtk_app::GetPrjX()->RemovePlottingClient(wcl);
}

/*################################################################################################*/

// eof
