// GAMESS.CPP

// Copyright (C) 2006 Donald Curtis, Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "gamess.h"

EFPGroup::EFPGroup()
{
}

EFPGroup::EFPGroup(string l)
{
	label = l;
}

EFPGroup::EFPGroup(const char *l)
{
	label = l;
}

char * EFPGroup::GetAtomListString(const char *sep)
{
	char *s1, *s2;
	char i[100];
	iter_alp it1 = GetAtomsBegin();
	if(it1 == GetAtomsEnd())
	{
		s1 = g_strconcat("", NULL);
	}
	else
	{
		sprintf(i, "%d", (*it1)->index);
		s1 = g_strconcat(i, "(",(*it1)->el.GetSymbol(),")", NULL);
		it1++;
		while(it1 != GetAtomsEnd())
		{
			sprintf(i, "%d", (*it1)->index);
			s2 = g_strconcat(s1, sep, i, "(",(*it1)->el.GetSymbol(),")", NULL);
			free(s1);
			s1=s2;
			it1++;
		}
	}

	return s1;
}

char * EFPGroup::GetTypeString()
{
	switch(t){
		case EFP:
			return "EFP";
			break;
		case QM:
			return "QM";
			break;
	}
	return "NULL";
}

bool EFPGroup::AddAtom(atom * a)
{
	for(iter_alp i = GetAtomsBegin(); i != GetAtomsEnd(); i++)
	{
		if((*i) == a)
			return false;
	}

	atom_list.push_back(a);
	// printf("adding atom: %d\n", a.index);
}

string EFPGroup::GetLabel()
{
	return label;
}

void EFPGroup::SetLabel(string l)
{
	label = l;
}

bool EFPGroup::Contains(atom * a)
{
	for(iter_alp i = GetAtomsBegin(); i != GetAtomsEnd(); i++)
	{
		if((*i) == a)
			return true;
	}

	return false;
}

bool EFPGroup::operator==(EFPGroup &g1)
{
	/*
	if((g1.type != type) || (g1.atom_list.size() != atom_list.size()))
		return false;

	iter_alp i=atom_list.begin();
	iter_alp j=g1.atom_list.begin();

	while(((*i) == (*j)) && (i != atom_list.end()))
	{
		i++;
		j++;
	}

	cout << "out of the loop" << endl;
	cout << (i == atom_list.end()) << endl;

	return (i == atom_list.end());
	*/
	return (g1.t == t && g1.atom_list == atom_list);

}

fGL * EFPGroup::GetCenterOfMass()
{
	fGL *com = new fGL[3];
	fGL sum[3];
	fGL m;
	fGL mass;
	const fGL *crd;

	mass = 0.0;
	sum[0] = 0.0;
	sum[1] = 0.0;
	sum[2] = 0.0;

	for(iter_alp i = GetAtomsBegin(); i != GetAtomsEnd(); i++)
	{
		m = (*i)->el.GetAtomicMass();
		crd = (*i)->GetCRD(0);

		mass += m;
		sum[0] += m * crd[0];
		sum[1] += m * crd[1];
		sum[2] += m * crd[2];
	}

	com[0] = sum[0] / mass;
	com[1] = sum[1] / mass;
	com[2] = sum[2] / mass;

	return com;

}


/* ####################################################### */

EFPData::EFPData()
{
}

bool EFPData::AddGroup(EFPGroup & g)
{
	for(iter_efpgl it1 = GetGroupBegin() ; it1 != GetGroupEnd(); it1++)
	{
		for(iter_alp it2 = g.GetAtomsBegin() ; it2 != g.GetAtomsEnd() ; it2++)
		{
			for(iter_alp it3 = (*it1).GetAtomsBegin() ; it3 != (*it1).GetAtomsEnd() ; it3++)
			{
				if((*it2)->index == (*it3)->index)
				{
					printf("WARNING: Cannot Add EFP Group (duplicated atom %d)\n", (*it3)->index);
					return false;
				}
			}
		}
	}

	group_list.push_back(g);
	return true;
}

bool EFPData::RemoveGroup(iter_efpgl it1)
{
	group_list.erase(it1);
	return true;
}

int EFPData::GetGroupCount(EFPGroup::type type)
{
	int count = 0;

	for(iter_efpgl it1 = GetGroupBegin() ; it1 != GetGroupEnd(); it1++)
	{
		if( (*it1).GetType() == type )
			count++;
	}

	return count;
}

/* ####################################################### */
GamessData::GamessData()
{
}

EFPData * GamessData::GetEFPData()
{
	return &efp_data;
}
