// T3MM2DOCV.H : a graphical user interface for mm2-models.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef T3MM2DOCV_H
#define T3MM2DOCV_H

class gnome_mm2_docv;

/*################################################################################################*/

#include "t3docv.h"
#include "mm2docv.h"

#include "t3dialog.h"

#include <gnome.h>

/*################################################################################################*/

#define MM2_FILTER	"*.mm2gp"

/*################################################################################################*/

class mm2_file_open_dialog : public file_dialog
{
	private:
	
	static const char title[];
	static gnome_mm2_docv * docv;
	
	public:
	
	mm2_file_open_dialog(gnome_mm2_docv *);
	~mm2_file_open_dialog(void);
	
	bool OkEvent(const char *);	// virtual
	void CancelEvent(void);		// virtual
};

/*################################################################################################*/

class mm2_file_save_dialog : public file_dialog
{
	private:
	
	static const char title[];
	static gnome_mm2_docv * docv;
	
	public:
	
	mm2_file_save_dialog(gnome_mm2_docv *);
	~mm2_file_save_dialog(void);
	
	bool OkEvent(const char *);	// virtual
	void CancelEvent(void);		// virtual
};

/*################################################################################################*/

class mm2_trajfile_dialog : public file_dialog
{
	private:
	
	static const char title[];
	static mm2_docv * docv;
	
	public:
	
	mm2_trajfile_dialog(mm2_docv *);
	~mm2_trajfile_dialog(void);
	
	bool OkEvent(const char *);	// virtual
	void CancelEvent(void);		// virtual
};

/*################################################################################################*/

class gnome_mm2_docv : public gnome_docv, public mm2_docv
{
	protected:
	
	static GnomeUIInfo fileimport_submenu[];	// file
	static GnomeUIInfo file_submenu[];
	
	static GnomeUIInfo select_submenu[];
	
	static GnomeUIInfo viewscreate_submenu[];	// render/views
	static GnomeUIInfo views_submenu[];		// render
	static GnomeUIInfo lights_submenu[];		// render
	static GnomeUIInfo rendermode_style_radio[];
	static GnomeUIInfo rendermode_submenu[];	// render
	static GnomeUIInfo projection_radio[];
	static GnomeUIInfo projection_submenu[];	// render
	static GnomeUIInfo render_submenu[];
	
	static GnomeUIInfo objects_submenu[];
	
	static GnomeUIInfo compute_submenu[];
	
	static GnomeUIInfo popupmenu_info[];
	static GnomeUIInfo popupmenu_dummy[];		// for tearoff
	
	public:
	
	static mm2_geomopt_param * goparam;
	static mm2_moldyn_param * mdparam;
	
	public:
	
	gnome_mm2_docv(ostream *, gnome_class_factory &, mm2_eng_param *);
	~gnome_mm2_docv(void);
	
	// the mm2-dependent popup-menu callbacks are here...
	// the mm2-dependent popup-menu callbacks are here...
	// the mm2-dependent popup-menu callbacks are here...
	
	static void popup_FileOpen(GtkWidget *, gpointer);
	static void popup_FileImport(GtkWidget *, gpointer);
	static void popup_FileSaveAs(GtkWidget *, gpointer);
	
	static void popup_RModeWireFrame(GtkWidget *, gpointer);
	static void popup_RModeBallAndStick(GtkWidget *, gpointer);
	static void popup_RModeVanDerWaals(GtkWidget *, gpointer);
	static void popup_RModeAccessible(GtkWidget *, gpointer);
	static void popup_RModeCylinders(GtkWidget *, gpointer);
	static void popup_RModeNothing(GtkWidget *, gpointer);
	
	static void popup_ObjRibbon(GtkWidget *, gpointer);
	static void popup_ObjEPlane(GtkWidget *, gpointer);
	static void popup_ObjEVolume(GtkWidget *, gpointer);
	static void popup_ObjESurface(GtkWidget *, gpointer);
	static void popup_ObjVDWSurface(GtkWidget *, gpointer);
	
	static void popup_CompEnergy(GtkWidget *, gpointer);
	static void popup_CompGeomOpt(GtkWidget *, gpointer);
	static void popup_CompMolDyn(GtkWidget *, gpointer);
	static void popup_TrajView(GtkWidget *, gpointer);
	
	void GeomOptGetParam(mm2_geomopt_param &);	// virtual
	void MolDynGetParam(mm2_moldyn_param &);	// virtual
};

/*################################################################################################*/

#endif	// T3MM2DOCV_H

// eof
