// MM2DOCV.H : a graphical user interface for mm2-models.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MM2DOCV_H
#define MM2DOCV_H

#ifdef ENABLE_GRAPHICS

class mm2_docv;

struct mm2_cdata;
class mm2_cm_state;		// mm2_cdata *
class mm2_cm_residue;		// mm2_cdata *
class mm2_cm_sasa;		// mm2_cdata *

/*################################################################################################*/

#include "docview.h"
#include "mm2mdl.h"

#include <vector>

/*################################################################################################*/

class mm2_docv : virtual public docview, public mm2_mdl
{
	public:
	
	static mm2_cm_state cm_state;
	static mm2_cm_residue cm_residue;
	static mm2_cm_sasa cm_sasa;
	
	public:
	
	mm2_docv(ostream *, graphics_class_factory &, mm2_eng_param *);
	virtual ~mm2_docv(void);

	fGL GetDefaultFocus(void);		// virtual
	
	const char * GetType(void);			// virtual
	color_mode * GetDefaultColorMode(void);		// virtual
	
	void SelectAll(void);				// virtual
	void InvertSelection(void);			// virtual
//	void SelectNone(void);				// virtual	// see the base class...
	
	void DrawCylinder1(graphics_view *, mm2_res **, i32s *, i32s);
	
	void Render(graphics_view *, rmode);		// virtual
	
	void Center(transformer *);			// virtual
	void Transform(transformer *);			// virtual
	
	void DrawEvent(graphics_view *, vector<iGLu> &);	// virtual
	void EraseEvent(graphics_view *, vector<iGLu> &);	// virtual
	void SelectEvent(graphics_view *, vector<iGLu> &);	// virtual
	void MeasureEvent(graphics_view *, vector<iGLu> &);	// virtual
};

/*################################################################################################*/

struct mm2_cdata
{
	mm2_res * res;
	i32s index;
};

class mm2_cm_state : public color_mode
{
	protected:
	
	public:
	
	mm2_cm_state(void) : color_mode() { }
	~mm2_cm_state(void) { }
	
	void GetColor(const void *, fGL_a4 &, prefs *p = 0);
};

class mm2_cm_residue : public color_mode
{
	protected:
	
	public:
	
	mm2_cm_residue(void) : color_mode() { }
	~mm2_cm_residue(void) { }
	
	void GetColor(const void *, fGL_a4 &, prefs *p = 0);
};

class mm2_cm_sasa : public color_mode
{
	protected:
	
	public:
	
	mm2_cm_sasa(void) : color_mode() { }
	~mm2_cm_sasa(void) { }
	
	void GetColor(const void *, fGL_a4 &, prefs *p = 0);
};

/*################################################################################################*/

#endif	// ENABLE_GRAPHICS
#endif	// MM2DOCV_H

// eof
