// QM2ENG.CPP

// Copyright (C) 2000 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "qm2eng.h"

/*################################################################################################*/

qm2_eng_exact::qm2_eng_exact(qm2_mdl & p1) : engine(), mdl(p1)
{
}

qm2_eng_exact::~qm2_eng_exact(void)
{
}

fGL qm2_eng_exact::GetESP(fGL *, fGL *)
{
	return 0.0;
}

fGL qm2_eng_exact::GetOrbital(fGL * crd, fGL * grad)
{
	fGL pol[3];
	crt2pol(crd, pol);
	
	fGL value = 1.0 / pol[0];
	
	// switch for different orbitals?!??!? not quite ready yet...
	// switch for different orbitals?!??!? not quite ready yet...
	// switch for different orbitals?!??!? not quite ready yet...
	
	if (grad != NULL)	// numerical gradient...
	{
		fGL old;
		const fGL delta = 0.0001;
		
		old = crd[0]; crd[0] += delta;
		grad[0] = (GetOrbital(crd, NULL) - value) / delta;
		crd[0] = old;
		
		old = crd[1]; crd[1] += delta;
		grad[1] = (GetOrbital(crd, NULL) - value) / delta;
		crd[1] = old;
		
		old = crd[2]; crd[2] += delta;
		grad[2] = (GetOrbital(crd, NULL) - value) / delta;
		crd[2] = old;
	}
	
	return value;
}

/*################################################################################################*/

// eof
