// QM1ENG.H : a base class for qm1-engine classes.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef QM1ENG_H
#define QM1ENG_H

class qm1_eng;

/*################################################################################################*/

#include "engine.h"
#include "qm1mdl.h"

/*################################################################################################*/

/**	A base class for molecular QM calculations.

	The qm1-models can have different basis functions and other such different details, 
	so it is not as straightforward to draw planes/surfaces for those than for molecular 
	mechanics models. Therefore qm1-engine classes must provide us the values we need 
	for planes/surfaces.
*/

void CopyCRD(qm1_mdl *, qm1_eng *, i32u);
void CopyCRD(qm1_eng *, qm1_mdl *, i32u);

class qm1_eng : public engine
{
	private:
	
	qm1_mdl & mdl;
	
	protected:
	
	i32s natm;
	i32s * atnum;
	
	f64 * crd;
	f64 * d1;

	friend class qm1_geomopt;
	friend class qm1_simple_ts_search;
	
	friend void CopyCRD(qm1_mdl *, qm1_eng *, i32u);
	friend void CopyCRD(qm1_eng *, qm1_mdl *, i32u);
	
	public:		// why public!??!?!?
	
	f64 energy;
	
	public:
	
	qm1_eng(qm1_mdl &);
	virtual ~qm1_eng(void);
	
	qm1_mdl * GetModel(void) { return & mdl; }
	
	void Check(i32s);	// virtual
	
	f64 GetGradientVectorLength(void);	// virtual
	
	// these are mainly for drawing energy level diagrams.
	
	virtual i32s GetOrbitalCount(void) = 0;
	virtual f64 GetOrbitalEnergy(i32s) = 0;
	
	virtual i32s GetElectronCount(void) = 0;
	
	// these are for plotting purposes...
	
	virtual void SetupPlotting(void) = 0;
	
	virtual fGL GetESP(fGL *, fGL *) = 0;
	virtual fGL GetElDens(fGL *, fGL *) = 0;
	
	virtual fGL GetOrbital(fGL *, fGL *) = 0;
	virtual fGL GetOrbDens(fGL *, fGL *) = 0;
	
	// these will call the above functions...
	
	static fGL getESP(fGL * pp, qm1_eng * ref, fGL * dd) { return ref->GetESP(pp, dd); }
	static fGL getElDens(fGL * pp, qm1_eng * ref, fGL * dd) { return ref->GetElDens(pp, dd); }
	
	static fGL getOrbital(fGL * pp, qm1_eng * ref, fGL * dd) { return ref->GetOrbital(pp, dd); }
	static fGL getOrbDens(fGL * pp, qm1_eng * ref, fGL * dd) { return ref->GetOrbDens(pp, dd); }
	
	static fGL getVDWSurface(fGL * pp, qm1_eng * ref, fGL * dd);
};

/*################################################################################################*/

#endif	// QM1ENG_H

// eof
