// MM1ENG9.H : molecular mechanics force field and computation engine (experimental).

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MM1ENG9_H
#define MM1ENG9_H

struct mm1_exp9_bt1;		// bond stretching
struct mm1_exp9_bt2;		// angle bending
struct mm1_exp9_bt3;		// torsion
// out of plane...

struct mm1_exp9_nbt1;		// nonbonded

class mm1_eng_exp9;

/*################################################################################################*/

class exp9_tables;		// mm1tab9.h

#include "mm1eng.h"

#include <vector>
using namespace std;

/*################################################################################################*/

struct mm1_exp9_bt1
{
	i32s atmi[2];
	
	f64 opt;
	f64 fc;
	
	i32s get_atmi(i32s index, bool dir)
	{
		return atmi[dir ? index : !index];
	}
};

struct mm1_exp9_bt2
{
	i32s atmi[3];
	
	i32s index1[2];
	bool dir1[2];
	
	f64 opt;
	f64 fc;
	
	i32s get_index(i32s index, bool dir)
	{
		return index1[dir ? index : !index];
	}
	
	bool get_dir(i32s index, bool dir)
	{
		return dir1[dir ? index : !index];
	}
};

struct mm1_exp9_bt3
{
	i32s atmi[4];
	
	i32s index2[2];
	i32s index1[4];
	bool dir1[4];
	
	f64 k; f64 s;
	
	bool constraint;
};

struct mm1_exp9_nbt1
{
	i32s atmi[2];
	
	float k1; float k2;
	float qq;
};

/*################################################################################################*/

/**	molecular mechanics (experimental); bonded + nonbonded parts.
	
	something about parameters???
*/

class mm1_eng_exp9 : public mm1_eng
{
	protected:
	
	mm1_bt1_data * bt1data;
	mm1_bt2_data * bt2data;
	
	vector<mm1_exp9_bt1> bt1_vector;
	vector<mm1_exp9_bt2> bt2_vector;
	vector<mm1_exp9_bt3> bt3_vector;
	
	vector<mm1_exp9_nbt1> nbt1_vector;
	
	public:
	
	mm1_eng_exp9(mm1_mdl &);
	virtual ~mm1_eng_exp9(void);
	
	i32s FindTorsion(mm1_atom *, mm1_atom *, mm1_atom *, mm1_atom *);	// virtual
	bool SetTorsionConstraint(i32s, f64, f64, bool);			// virtual
	
	protected:
	
	void ComputeBT1(i32s);		// virtual
	void ComputeBT2(i32s);		// virtual
	void ComputeBT3(i32s);		// virtual
	void ComputeBT4(i32s);		// virtual
	
	void ComputeNBT1(i32s);		// virtual
};

/*################################################################################################*/

#endif	// MM1ENG9_H

// eof
