// INTERFACE.CPP

// Copyright (C) 2001 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

////////////////////////////////////////////////////////////////////////////////////////////////////

#include "interface.h"

#include "define.h"

#include <vector>
using namespace std;

////////////////////////////////////////////////////////////////////////////////////////////////////

all_atoms_interface::all_atoms_interface(void)
{
}

all_atoms_interface::~all_atoms_interface(void)
{
}

void all_atoms_interface::aai_MakeCopy(const all_atoms_interface * c_other)
{
// the argument "c_other" must be handled as const, and practically it is const, but it seems to be very difficult
// to convince g++ about the fact. the inlined functions GetAtomsBegin() and the rest seem to be the problem...
all_atoms_interface * other = (all_atoms_interface *) c_other;		// shamelessly un-const it...

	vector<i32s> i_original;	// store the indices here...
	vector<i32s> i_local;		// ...to replicate the bonds!
	
	for (i32u n1 = 0;n1 < other->aai_GetAtomCount();n1++)
	{
		i_original.push_back(n1);
		
		element el; other->aai_AtomGetElement(n1, el);
		fGL xyz[3]; other->aai_AtomGetXYZ(n1, xyz);
		
		void * atmr = aai_AddAtom(el, xyz);
		i32s atmi = aai_FindAtomByPtr(atmr);
		
		i_local.push_back(atmi);
	}
	
	for (i32u n1 = 0;n1 < other->aai_GetBondCount();n1++)
	{
		i32s atmi[2]; other->aai_BondGetAtomIndices(n1, atmi);
		bondtype bt; other->aai_BondGetBondType(n1, bt);
		
		i32u index1 = 0; while (index1 < i_original.size()) if (atmi[0] == i_original[index1]) break; else index1++;
		if (index1 == i_original.size()) { cout << "FATAL ERROR : could not find atom #1." << endl; exit(EXIT_FAILURE); }
		
		i32u index2 = 0; while (index2 < i_original.size()) if (atmi[1] == i_original[index2]) break; else index2++;
		if (index2 == i_original.size()) { cout << "FATAL ERROR : could not find atom #2." << endl; exit(EXIT_FAILURE); }
		
		aai_AddBond(i_local[index1], i_local[index2], bt);
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////

trajectory_interface::trajectory_interface(void)
{
	trajfile = NULL;
	
	total_traj_frames = NOT_DEFINED;
	current_traj_frame = NOT_DEFINED;
}

trajectory_interface::~trajectory_interface(void)
{
	if (trajfile != NULL) cout << "WARNING - trajectory file was not closed?!?!?!" << endl;
}

i32s trajectory_interface::GetTotalFrames(void)
{
	return total_traj_frames;
}

ifstream * trajectory_interface::GetTrajectoryFile(void)
{
	return trajfile;
}

i32s trajectory_interface::GetCurrentFrame(void)
{
	return current_traj_frame;
}

void trajectory_interface::SetCurrentFrame(i32s p1)
{
	current_traj_frame = p1;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

// eof
