#ifndef USER_H
#define USER_H

#include <vector.h>
#include <qfile.h>

#include "icq-defines.h"
#include "socket.h"
#include "file.h"
#include "message.h"
//#include "icqfunctions.h"
//#include "chatdlg.h"

//+++++STRUCTURES++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//-----UserStatusline------------------------------------------------------------------------------
struct UserStatusline
{
     char alias[32];
     char uin[16];
     char name[64];
     char firstname[32];
     char lastname[32];
     char email[64];
     char status[16];
     char ip[16];
     char port[6];
     char ip_port[24];
     char history[MAX_FILENAME_LEN];
     char awayMessage[MAX_MESSAGE_SIZE];
};


//+++++OBJECTS+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


class ICQFunctions;


//=====ICQUser=====================================================================================
class ICQUser
{
public:
   ICQUser(unsigned long id, char *filename, bool isNewUser);   
   virtual ~ICQUser(void);
   void setDefaults(unsigned long id);
   virtual void getStatusInfo(struct UserStatusline &us);
   char *iptoa(unsigned long ipAddr);   
   TCPSocket tcpSocket;
   QFile *history;
   ICQFunctions *fcnDlg;

   // get user info functions
   unsigned short status(void);
   unsigned long uin(void);
   char *alias(void);
   char *email(void);
   bool newUser(void);
   void setNewUser(bool);
   bool onlineNotify(void);
   void setOnlineNotify(bool);
   bool sendServer(void);
   void setSendServer(bool);
   unsigned long sequence(void);
   char *historyFile(void);
   void saveInfo(void);
   
   // message functions
   unsigned short numMessages(void);
   Message *getMessage(unsigned short);
   void clearMessage(unsigned short);
   void addMessage(char *m, unsigned short theCmd, unsigned short theSubCmd, unsigned long theSequence, time_t t = 0, bool isLicq = false, unsigned short theVer = 0);
   void addMessage(char *m, time_t t = 0, bool isLicq = false, unsigned short theVer = 0);
   void addToHistory(Message *newMsg);

   void setAwayMessage(char *m);
   char *awayMessage(void);
   
protected:
   ICQUser(void) { /* ICQOwner inherited constructor - does nothing */ };
   ICQUser(unsigned long id, TCPSocket &sock, bool isNewUser);
   unsigned long uinVal;
   unsigned short statusVal, newMessages;
   char aliasVal[32];
   char firstNameVal[32];
   char lastNameVal[32];
   char emailVal[64];
   bool newUserVal, onlineNotifyVal;
   bool sendServerVal;
   char *awayMessageVal;
   vector <class Message *> message;
   unsigned long sequenceVal;
   char historyFileVal[MAX_FILENAME_LEN];
   void openHistory(void);

friend class ICQ;
friend class ICQFunctions;
};


//=====ICQOwner====================================================================================
class ICQOwner : public ICQUser
{
public:
   ICQOwner(void);
   char *passwd(void);
   unsigned short searchSequence(void);
   virtual void getStatusInfo(struct UserStatusline &us);
protected:
   char passwdVal[20];
   unsigned short searchSequenceVal;
};

#endif
