#ifndef socket_h
#define socket_h

#include <arpa/inet.h>
#include <netinet/in.h>
#include <qsocknot.h>

#include "packet.h"


//=====Socket======================================================================================
class Socket
{
public:
   Socket(void)  {sn = NULL; };
   QSocketNotifier *sn;
   bool connected(void)                     { return(descriptorVal > 0); };
   int  descriptor(void)                    { return(descriptorVal);     };
   int  error(void)                         { return(errorVal);          };
protected:
   int descriptorVal, errorVal;
   void openSocket(void);
   void closeSocket(void);
};


//=====StdinSocket=================================================================================
class StdinSocket : public Socket
{
   public:
      StdinSocket(void);
};


//=====INetSocket==================================================================================
class INetSocket : public Socket
{
public:
   INetSocket(void);
   unsigned long  localIP(void)    { return(localIPVal);    };
   unsigned long  remoteIP(void)   { return(remoteIPVal);   };
   unsigned short localPort(void)  { return(localPortVal);  };
   unsigned short remotePort(void) { return(remotePortVal); };
   bool setDestination(unsigned long rIp, unsigned short rPort);
   bool setDestination(char *rHost, unsigned short rPort) { return(setDestination(lookup(rHost), rPort)); };
   bool destinationSet(void)  { return (remoteIPVal != 0); };
   void resetSocket(void);
   unsigned long lookup(char *h);
   virtual void closeConnection(void);
   virtual bool openConnection(void) = 0;
   virtual bool startServer(unsigned int p) = 0;
   virtual bool sendPacket(Packet &p) = 0;
   virtual bool receivePacket(Packet &p) = 0;
protected:
   struct sockaddr_in remote;
   unsigned long remoteIPVal, localIPVal;
   unsigned int remotePortVal, localPortVal;      
};


//=====TCPSocket===================================================================================
class TCPSocket : public INetSocket
{
public:      
   TCPSocket(void);
   virtual ~TCPSocket(void) { closeConnection(); }
   virtual bool openConnection(void);
   virtual void closeConnection(void);
   virtual bool startServer(unsigned int p = 0);
   virtual bool sendPacket(Packet &p);
   virtual bool receivePacket(Packet &p);
   bool sendPacket(Packet &p, bool sendSize);
   bool receivePacket(Packet &p, bool recvSize);
   void receiveConnection(TCPSocket &newSocket);
   void transferConnectionFrom(TCPSocket &from);
};


//=====UDPSocket===================================================================================
class UDPSocket : public INetSocket
{
public:      
   UDPSocket(void);
   virtual ~UDPSocket(void);
   virtual bool openConnection(void);
   virtual void receiveConnection(void);
   virtual void closeConnection(void);
   virtual bool startServer(unsigned int p);
   virtual bool sendPacket(Packet &p);
   virtual bool receivePacket(Packet &p);
};



#endif
