#ifndef ICQFUNCTIONS_H
#define ICQFUNCTIONS_H

#include <qobject.h>
#include <qlabel.h>
#include <qtabbar.h>
#include <qtabdlg.h>
#include <qlined.h>
#include <qmlined.h> 
#include <qchkbox.h>
#include <qpushbt.h>
#include <qgrpbox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h> 
#include <qvalidator.h>

#include "user.h"
#include "mledit.h"
#include "requestdlg.h"
#include "messagebox.h"
#include "chatdlg.h"
#include "icqevent.h"
#include "icq.h"


//=====InfoField===================================================================================
class InfoField : public QObject
{
public:
   InfoField(int x, int y, int len, char *title, bool isReadOnly, QWidget *parent);
   void setData(char *data);
protected:
   bool readOnly;
   QLabel *lblTitle, *lblInfo;
   QLineEdit *edtInfo;
friend class ICQFunctions;
};


//=====ICQFunctions================================================================================
class ICQFunctions : public QTabDialog
{
   Q_OBJECT
public:
   ICQFunctions(ICQ *s, QWidget *parent = 0, const char *name = 0);
   virtual ~ICQFunctions(void);
   void setup(ICQUser *s, int index, bool isAutoClose);
   char *tabLabel[4];
   static const int TAB_READ = 0, TAB_SEND = 1, TAB_USERINFO = 2, TAB_HISTORY = 3;
   int currentTab;
   ICQUser *theUser;
   ICQ *server;
   const char *msg(void);

protected:
   char *msgVal;
   ICQEvent *icqEvent;
   bool autoClose;
   QLabel *lblProgress;
   QPushButton *btnApply;
   
   QWidget *fcnTab[4];

   MLEditWrap *mleRead;
   MsgView *msgView;
   RequestDlg *requestDlg;
   ChatDlg *chatDlg;
   
   MLEditWrap *mleSend;
   QCheckBox *chkSendServer, *chkSpoof;
   QLineEdit *edtSpoof, *edtItem;
   QLabel *lblItem, *lblDescription;
   QButtonGroup *grpCmd;
   QRadioButton *rdbUrl, *rdbChat, *rdbFile, *rdbMsg, *rdbAway;
    
   InfoField *nfoFirstName, *nfoLastName, *nfoEMail, *nfoAlias, *nfoStatus, *nfoIp, *nfoUin, *nfoHistory;
   MLEditWrap *mleAwayMsg;
   QGroupBox *boxAwayMsg;
   QPushButton *btnSave;

   MLEditWrap *mleHistory;
   QCheckBox *chkEditHistory;
   QPushButton *btnSaveHistory;

   void clear(void);
   void setInfo(void);

public slots:
   virtual void hide();
   
protected slots:
   void callFcn();
   void doneFcn(bool, ICQEvent *);
   void doneUserInfo(bool, unsigned long);
   void tabSelected(const char *);
   void showHistory();
   void saveHistory();
   void printMessage(QListViewItem *);
   void saveUserInfo();
   void setSpoofed();
   void specialFcn(int);
   
signals:
   void updatedUsers();
   void finished(ICQUser *);
};


#endif
