#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "file.h"

File::File(char *fname, bool allowCreate = false)
{
     errorVal = false;
     filename = new char[strlen(fname) + 1];
     strcpy(filename, fname);
     if((file = fopen(filename, "r")) == NULL)
     {
	if (allowCreate) 
        {
           file = fopen(filename, "w");
	   fclose(file);
	   if((file = fopen(filename, "r")) == NULL) errorVal = true;
        }
        else errorVal = true;
     }
     currentEntry.sect[0] = '\0';
     currentEntry.key[0] = '\0';
     currentEntry.line[0] = '\0';
     currentEntry.keyVal[0] = '\0';
     eof = false;
}

File::~File(void)
{
     delete filename;
     if (file != NULL) fclose(file);
}

bool File::error(void)
{
   return(errorVal);
}

void File::reset(void)
{
   rewind(file);
   eof = false;
   currentEntry.sect[0] = '\0';
   currentEntry.key[0] = '\0';
   currentEntry.line[0] = '\0';
   currentEntry.keyVal[0] = '\0';
}

bool File::read(char *val, bool fatal = false, bool noisy = true)
{
   char *buffStart, *buffPos;
   bool found = false;
   buffStart = new char[4096];
   buffPos = buffStart;
   reset();
   buffPos[0] = '\0';
   do
   {
      processLine();
      if(((strcmp(currentEntry.key, targetKey) == 0) || (targetKey[0] == '\0'))
	  && (strcmp(currentEntry.sect, targetSect) == 0))
      {
	 strcpy(buffPos, currentEntry.keyVal);
	 buffPos += sizeof(char) * (strlen(currentEntry.keyVal));
    found = true;
      }
   } while(!eof);

   *buffPos = '\0';
   strcpy(val, buffStart);
   delete buffStart;
   if (!found) 
   {
      if (noisy) 
      {
         printf("Warning (%s): Unable to read [%s] | %s.\n", filename, targetSect, targetKey);
         fflush(stdout);
      }
      if (fatal) 
      {
         printf("Fatal error, exiting.");
         exit(1);
      }
   }
   targetKey[0] = '\0';
   targetSect[0] = '\0';   
   return(found);
}

bool File::read(unsigned short &val, bool fatal = false, bool noisy = true)
{
   char s[80];
   bool found = read(s, fatal, noisy);
   val = atoi(s);
   return(found);
}

bool File::read(unsigned long &val, bool fatal = false, bool noisy = true)
{
   char s[80];
   bool found = read(s, fatal, noisy);
   val = atoi(s);
   return(found);
}


bool File::read(bool &val, bool fatal = false, bool noisy = true)
{
   char s[80];
   bool found = read(s, fatal, noisy);
   val = (atoi(s) == 0 ? false : true);
   return(found);
}



void File::write(char *val)
{
    char *buffStart, *buffPos;
    buffStart = new char[4096];
    reset();
    buffPos = buffStart;
    if(!fillToTarget(buffPos)) // The key doesn't exist in the section
    {
       // Go to the section start or eof
       char firstChar = targetKey[0];
       targetKey[0] = '\0'; // Condition for a section search.
       reset();
       buffPos = buffStart;
       fillToTarget(buffPos);
       sprintf(buffPos, "[%s]\n", targetSect);
       buffPos += sizeof(char) * (strlen(targetSect) + 3);
       targetKey[0] = firstChar;
    }
    if(targetKey[0] == '\0')
    {
       int i;
       *buffPos++ = ':';
       for(i = 0; val[i] != '\0'; i++)
       {
	   *buffPos++ = val[i];
	   if(val[i] == '\n') *buffPos++ = ':';
       }
       *buffPos++ = '\n';
    }
    else
    {
       sprintf(buffPos, "%s = %s\n", targetKey, val);
       buffPos += sizeof(char) * (strlen(val) + strlen(targetKey) + 4);
    }
    fillToEof(buffPos);
    buffToFile(buffStart, buffPos); //Look here.
    delete buffStart;
    targetKey[0] = '\0';
    targetSect[0] = '\0';
}

void File::buffToFile(char *from, char *to)
{
    fclose(file);
    file = fopen(filename, "w");
    for(; from <= to; from++)
	fputc(*from, file);
    fclose(file);
    file = fopen(filename, "r");
}

bool File::fillToTarget(char *&buff) // returns true if the target was found.
{
    while(!eof)
    {
       processLine();
       if(strcmp(currentEntry.sect, targetSect) == 0)
	  if((strcmp(currentEntry.key, targetKey) == 0) || (targetKey[0] == '\0'))
	     return(true);
       sprintf(buff, "%s", currentEntry.line);
       buff += sizeof(char) * strlen(currentEntry.line);
       if(!(eof && (currentEntry.line[0] == '\0'))) *buff++ = '\n';
    }
    return(false);
}

void File::fillToEof(char *&buff)
{
   char c = fgetc(file);
   while(!feof(file))
   {
      *buff++ = c;
      c = fgetc(file);
   }
   buff--;
}

void File::write(unsigned short val)
{
   char s[80];
   sprintf(s, "%u", val);
   write(s);
}

void File::write(unsigned long val)
{
   char s[80];
   sprintf(s, "%lu", val);
   write(s);
}


void File::write(bool val)
{
   char s[80];
   sprintf(s, "%d", (val == true ? 1 : 0));
   write(s);
}


void File::clear(void)
{
   fclose(file);
   fopen(filename, "w");
   fclose(file);
   file = fopen(filename, "r");
}

void File::delSect(char *name)
{
    char *buffStart, *buffPos;
    buffStart = new char[4096];
    buffPos = buffStart;
    strcpy(targetSect, name);
    targetKey[0] = '\0';
    reset();
    if(!fillToTarget(buffPos)) return;
    do
       processLine();
    while((strcmp(currentEntry.sect, name) == 0) && (!eof));
    sprintf(buffPos, "%s\n", currentEntry.line);
    buffPos += sizeof(char) * (strlen(currentEntry.line) + 1);
    fillToEof(buffPos);
    buffToFile(buffStart, buffPos);
}

void File::delKey(char *name)
{
    char *buffStart, *buffPos;
    buffStart = new char[4096];
    buffPos = buffStart;
    reset();
    strcpy(targetKey, name);
    if(!fillToTarget(buffPos)) return;
    fillToEof(buffPos);
    buffToFile(buffStart, buffPos);
}

void File::processLine(void)
{
    int lineLen, i, j;
    currentEntry.key[0] = '\0';
    currentEntry.keyVal[0] = '\0';
    lineLen = readLine();
    if((currentEntry.line[0] == '[') && (currentEntry.line[lineLen - 1] == ']'))
    {
       memcpy(currentEntry.sect, currentEntry.line + sizeof(char), lineLen - 2 * sizeof(char));
       currentEntry.sect[lineLen - 2 * sizeof(char)] = '\0';
       return;
    }

    if(currentEntry.line[0] == ':')
    {
       memcpy(currentEntry.keyVal, currentEntry.line + sizeof(':'), lineLen - sizeof(':'));
       currentEntry.keyVal[lineLen - sizeof(char)] = '\0';
       return;
    }

    for(i = 0; i < lineLen; i++)
       if(currentEntry.line[i] == '=') break;
    if(currentEntry.line[i] == '=' && currentEntry.line[0] != '#')
    {
       i--;
       while(currentEntry.line[i] == ' ') i--;
       for(currentEntry.key[i + 1] = '\0'; i >= 0; i--)
	  currentEntry.key[i] = currentEntry.line[i];
       for(i = 0; i < lineLen; i++) if(currentEntry.line[i] == '=') break;
       for(i++;   i < lineLen; i++) if(currentEntry.line[i] != ' ') break;
       for(j = 0; i < lineLen;    ) currentEntry.keyVal[j++] = currentEntry.line[i++];
       currentEntry.keyVal[j] = '\0';
       return;
    }

    // Else it's a comment
}

int File::readLine(void)
{
    int i = 0;
    char c = '\0';
    while(c != '\n')
    {
      c = fgetc(file);
      if(feof(file))
      {
	 currentEntry.line[i] = '\0';
	 if(i == 0)
	 {
	    eof = true;
	 }
	 return(i);
      }
      currentEntry.line[i++] = c;
    }
    currentEntry.line[--i] = '\0';
    return(i);
}

File& File::key(char *s)
{
   strcpy(targetKey, s);
   return *this;
}

File& File::section(char *s)
{
   strcpy(targetSect, s);
   return *this;
}

