/******************************************************************************/
/*                                                                            */
/* Title       : mir.h                                                        */
/* Author      : Manfred Bester                                               */
/* Date        : 28Nov94                                                      */
/* Last change : 04Jan97                                                      */
/*                                                                            */
/* Synopsis    : This include file contains the point arrays for the          */
/*               Mir space station icon.                                      */
/*                                                                            */
/*                                                                            */
/* SatTrack V3.1                                                              */
/*                                                                            */
/* Copyright (c) 1992-1997 Bester Tracking Systems. All Rights Reserved.      */
/*                                                                            */
/* Permission to use, copy, and distribute SatTrack V3.1 and its              */
/* documentation in its entirety for educational, research and non-profit     */
/* purposes, without fee, and without a written agreement is hereby granted,  */
/* provided that the above copyright notice and the following three           */
/* paragraphs appear in all copies. SatTrack may be modified for personal     */
/* purposes, but modified versions may NOT be distributed without prior       */
/* consent of Bester Tracking Systems.                                        */
/*                                                                            */
/* Permission to incorporate this software into commercial products may be    */
/* obtained Bester Tracking Systems at the address below.                     */
/*                                                                            */
/*                                                                            */
/*     Bester Tracking Systems                                                */
/*     P.O. Box 8899                                                          */
/*     Emeryville, CA 94662, USA                                              */
/*                                                                            */
/*     Phone: (510) 654-7824                                                  */
/*     Email: license@bester.com                                              */
/*     WWW:   www.bester.com                                                  */
/*                                                                            */
/*                                                                            */
/* Note that distributing SatTrack 'bundled' in with ANY product is           */
/* considered to be a 'commercial purpose'.                                   */
/*                                                                            */
/* IN NO EVENT SHALL BESTER TRACKING SYSTEMS, ITS OWNER OR ITS EMPLOYEES BE   */
/* LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR          */
/* CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS      */
/* DOCUMENTATION, EVEN IF BESTER TRACKING SYSTEMS HAS BEEN ADVISED OF THE     */
/* POSSIBILITY OF SUCH DAMAGE.                                                */
/*                                                                            */
/* BESTER TRACKING SYSTEMS SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,  */
/* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS  */
/* FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" */
/* BASIS, AND BESTER TRACKING SYSTEMS, ITS OWNER OR ITS EMPLOYEES HAVE NO     */
/* OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR     */
/* MODIFICATIONS FREE OF CHARGE.                                              */
/*                                                                            */
/* Federal and international laws provide severe civil and criminal           */
/* penalties for the unauthorized reproduction and distribution of            */
/* copyrighted software. Criminal copyright infringement is investigated      */
/* by the FBI and may constitute a felony with severe penalties.              */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* Mir icon                                                                   */
/*                                                                            */
/******************************************************************************/

XPoint mirPointsWhite[] = {

{27,10}, {27, 9},                                       /* front disk */

{26, 7},                                                /* progress */
{25, 8}, {25, 7}, 
{24,10}, {24, 9}, {24, 8}, {24, 7}, {24, 6}, 
{23,10}, {23, 9}, {23, 8}, {23, 7}, {23, 6}, 
{22,10}, {22, 9}, {22, 8}, {22, 7}, {22, 6}, 
{21, 9}, {21, 8}, {21, 7}, {21, 6}, {21, 5}, 
{20, 9}, {20, 8}, {20, 7}, {20, 6}, 
{19, 8}, 

{16, 7}, {16, 4}, {16, 3},                              /* disk */
{15, 7}, {15, 6}, {15, 5}, {15, 4}, {15, 3}, 
{14, 7}, {14, 6}, {14, 5}, {14, 4}, {14, 3}, 

{14, 1},                                                /* main body */
{13, 2}, {13, 1}, 
{12, 8}, {12, 7}, {12, 6}, {12, 4}, {12, 3}, {12, 2}, {12, 1}, 
{11, 8}, {11, 7}, {11, 5}, {11, 4}, {11, 3}, {11, 2}, {11, 1}, 
{10, 7}, {10, 5}, {10, 4}, {10, 3}, {10, 2}, {10, 1}, 
{ 9, 5}, { 9, 4}, { 9, 3}, { 9, 2}, { 9, 0}, { 9,-1}, 
{ 8, 6}, { 8, 1}, { 8, 0}, { 8,-1}, 
{ 7, 6}, { 7, 5}, { 7, 4}, { 7, 3}, { 7, 2}, { 7, 1}, { 7, 0}, { 7,-1}, 
{ 6, 6}, { 6, 5}, { 6, 4}, { 6, 3}, { 6, 2}, { 6, 1}, { 6, 0}, { 6,-1}, 
{ 5, 5}, { 5, 4}, { 5, 3}, { 5, 2}, { 5, 1}, { 5, 0}, { 5,-1}, 
{ 4, 5}, { 4, 4}, { 4, 3}, { 4, 2}, { 4, 1}, { 4, 0}, { 4,-1}, 
{ 3, 3}, { 3, 2}, { 3, 1}, { 3, 0}, { 3,-2}, { 3,-3}, 
{ 2, 4}, { 2,-1}, { 2,-2}, { 2,-3}, 
{ 1, 4}, { 1, 3}, { 1, 2}, { 1, 1}, { 1, 0}, { 1,-1}, { 1,-2}, { 1,-3}, 
{ 0, 4}, { 0, 3}, { 0, 2}, { 0, 1}, { 0, 0}, { 0,-1}, { 0,-2}, { 0,-3}, 
{-1, 3}, {-1, 2}, {-1, 1}, {-1, 0}, {-1,-1}, {-1,-2}, {-1,-3}, 
{-2, 3}, {-2, 2}, {-2, 1}, {-2, 0}, {-2,-1}, {-2,-2}, {-2,-3}, 
{-3, 2}, {-3, 1}, {-3, 0}, {-3,-1}, {-3,-2}, {-3,-3}, 
{-4, 1}, {-4, 0}, {-4,-1}, {-4,-2}, 

{-6, 0}, {-6,-1}, {-6,-2}, {-6,-3}, {-6,-4},            /* cross coupler */
{-7,-1}, {-7,-2}, {-7,-3}, {-7,-4}, 
{-8, 0}, {-8,-1}, {-8,-2}, {-8,-3}, {-8,-4}, 
{-9, 0}, {-9,-1}, {-9,-2}, {-9,-3}, {-9,-4}, 
{-9,-5}, {-9,-6}, {-9,-7}, 
{-10, 0}, {-10,-1}, {-10,-2}, {-10,-3}, {-10,-4}, 
{-10,-5}, {-10,-6}, 
{-11,-2}, {-11,-3}, {-11,-4}, {-11,-5}, {-11,-6}, 
{-12,-3}, {-12,-4}, 

{-7,-5}, {-6,-5}, {-5,-3}, {-5,-4}, {-5,-5}, {-5,-6},   /* module A */
{-4,-4}, {-4,-5}, {-4,-6}, {-3,-7}, 
{-2,-5}, {-2,-6}, {-2,-7}, 
{-1,-5}, {-1,-6}, {-1,-7}, {-1,-8}, 
{ 0,-5}, { 0,-6}, { 0,-7}, { 0,-8}, 
{ 1,-4}, { 1,-5}, { 1,-6}, { 1,-7}, { 1,-8}, 
{ 2,-4}, { 2,-5}, { 2,-6}, { 2,-7}, { 2,-8}, { 2,-9}, 
{ 3,-5}, { 3,-6}, { 3,-7}, { 3,-8}, { 3,-9}, 
{ 4,-5}, { 4,-6}, { 4,-7}, { 4,-8}, { 4,-9}, 
{ 5,-5}, { 5,-6}, { 5,-7}, { 5,-8}, { 5,-9}, 

{-12, -8}, {-12, -9}, {-11, -7}, {-11, -8}, {-11, -9},  /* module B */
{-10, -7}, {-10, -8}, {-10, -9}, { -9, -8}, { -9, -9}, 
{-13,-11}, {-13,-12}, {-13,-13}, {-13,-16}, 
{-12,-11}, {-12,-12}, {-12,-13}, {-12,-14}, {-12,-16}, 
{-11,-11}, {-11,-12}, {-11,-13}, {-11,-14}, {-11,-15}, {-11,-16}, 
{-10,-11}, {-10,-12}, {-10,-13}, {-10,-14}, {-10,-15}, {-10,-16}, 
{ -9,-11}, { -9,-12}, { -9,-13}, { -9,-14}, { -9,-15}, { -9,-16}, 
{ -8,-12}, { -8,-13}, { -8,-14}, { -8,-15}, { -8,-16}, { -8,-17},
{-13,-18}, {-13,-19}, {-12,-18}, {-12,-19}, 
{-11,-18}, {-11,-19}, {-10,-18}, {-10,-19}, 
{ -9,-18}, { -9,-19}, { -8,-19}, 

{-23, 1}, {-23, 0}, {-23,-1},                           /* module C */
{-22, 2}, {-22, 1}, {-22, 0}, 
{-21,-2}, 
{-20, 2}, {-20, 1}, {-20, 0}, {-20,-1}, {-20,-2}, 
{-19, 1}, {-19, 0}, {-19,-1}, {-19,-2}, {-19,-3}, 
{-18, 1}, {-18, 0}, {-18,-1}, {-18,-2}, {-18,-3}, 
{-17, 1}, {-17, 0}, {-17,-1}, {-17,-2}, {-17,-3}, 
{-16, 1}, {-16, 0}, {-16,-1}, {-16,-2}, {-16,-3}, 
{-15, 0}, {-15,-1}, {-15,-2}, 
{-14,-3}, 
{-13,-1}, {-13,-2}, {-13,-3}, 
{-12,-2}, {-12,-3}, 

{-11,10}, {-11, 7}, {-11, 6},                           /* module D */
{-11, 5}, {-11, 3}, {-11, 2}, {-11, 1}, 
{-10,11}, {-10,10}, {-10, 9}, {-10, 7}, 
{-10, 6}, {-10, 4}, {-10, 3}, {-10, 2}, {-10, 1}, 
{ -9,11}, { -9,10}, { -9, 9}, { -9, 8}, { -9, 7}, 
{ -9, 6}, { -9, 4}, { -9, 3}, { -9, 2}, { -9, 1}, 
{ -8,11}, { -8,10}, { -8, 9}, { -8, 8}, { -8, 7}, 
{ -8, 6}, { -8, 4}, { -8, 3}, { -8, 2}, { -8, 1}, 
{ -7,11}, { -7,10}, { -7, 9}, { -7, 8}, { -7, 7}, 
{ -7, 6}, { -7, 4}, { -7, 3}, 
{ -6,10}, { -6, 9}, { -6, 8}, { -6, 7}, 
{ -6, 6}, { -6,-5}, 

{-14,-4}, {-14,-6}, {-14,-7},                           /* transfer module */
{-15,-4}, {-15,-5}, {-15,-6}, {-15,-7},
{-16,-4}, {-16,-5}, {-16,-6}, {-16,-7},
{-17,-4}, {-17,-5}, {-17,-6}, {-17,-7}, {-17,-8}, 
{-18,-5}, {-18,-6}, {-18,-7}, {-18,-8}, 
{-19,-5}, {-19,-6}, {-19,-7}, {-19,-8}, 
{-20,-6}, {-20,-7}, {-20,-8}
};


XPoint mirPointsBlack[] = {

{29,10}, {29, 9}, {29, 8},                              /* front disk */
{28,11}, {28,10}, {28, 9}, {28, 8}, {28, 7},
{27,12}, {27,11}, {27, 8}, {27, 7},
{26,12}, {26,11}, {26,10}, {26, 9}, {26, 8},
{25,11}, {25,10}, {25, 9}, 

{19, 7}, {19, 6}, {19, 5},                              /* sphere */
{18, 7}, {18, 6}, {18, 5}, {18, 4},
{17, 7}, {17, 6}, {17, 5}, {17, 4},
{16, 6}, {16, 5}, 

{16, 8}, {16, 2},                                       /* disk */
{15, 8}, {15, 2},
{14, 8}, {14, 2},
{13, 7}, {13, 6}, {13, 5}, {13, 4}, {13, 3}, 

{-3,10}, {-2,10}, {-1,10},                              /* solar panels */
{-1, 9}, { 0, 9}, { 1, 9}, { 2, 9}, 
{ 2, 8}, { 3, 8}, { 4, 8}, { 5, 8}, 
{ 5, 7}, { 6, 7}, { 7, 7}, { 8, 7}, 
{ 9, 6}, {10, 6}, {11, 6}, {12, 5}, 
{18, 3}, {19, 3}, {20, 3}, 
{20, 2}, {21, 2}, {22, 2}, {23, 2}, 
{23, 1}, {24, 1}, {25, 1}, {26, 1}, 

{-22,-12}, {-21,-12}, {-20,-12}, {-19,-12}, 
{-18,-13}, {-17,-13}, {-16,-13}, {-15,-13}, 
{-16,-14}, {-15,-14}, {-14,-14}, {-13,-14}, 
{-13,-15}, {-12,-15}, 
{ -7,-14}, { -7.-15}, { -6,-15}, 
{ -6,-16}, { -5,-16}, { -4,-16}, { -3,-16}, 
{ -2,-17}, { -1,-17}, {  0,-17}, {  1,-17}, 

{-20, 11}, {-19, 11}, {-18, 11}, {-17, 11}, 
{-16, 10}, {-15, 10}, {-14, 10}, {-13, 10}, 
{-14,  9}, {-13,  9}, {-12,  9}, {-11,  9}, 
{-11,  8}, {-10,  8}, 
{ -5,  7}, { -4,  7}, 
{ -5,  6}, { -4,  6}, { -3,  6}, { -2,  6}, 
{ -1,  5}, {  0,  5}, {  1,  5}, {  2,  5}, 

{ 9, 7},                                                /* main body */
{ 8, 5}, { 8, 4}, { 8, 3}, { 8, 2}, { 9, 1}, 
{10, 0}, {11, 0}, {12, 0}, 
{ 3, 5}, { 3, 4}, { 2, 3}, { 2, 2}, { 2, 1}, { 2, 0}, 
{ 3,-1}, { 4,-2}, { 5,-2}, { 6,-2}, 
{-3, 3}, {-4, 2}, {-5, 1}, {-5, 0}, {-5,-1}, {-5,-2}, {-4,-3}, 
{-3,-4}, {-2,-4}, {-1,-4}, { 0,-4}, 

{ 4,-10}, { 5,-11}, { 5,-10}, { 6,-10}, { 6, -9},       /* module A */
{ 6, -8}, { 6, -7}, { 6, -6}, { 6, -5}, { 5, -4}, 
{ 4, -4}, {-3, -5}, {-3, -6}, {-4, -7}, 

{-13,-10}, {-12,-10}, {-11,-10}, {-10,-10},             /* module B */
{ -9,-10}, { -8,-10}, { -8,-11}, 
{-14,-18}, {-14,-17}, {-14,-19}, 
{-13,-17}, {-13,-20}, {-12,-17}, {-12,-20}, 
{-11,-17}, {-11,-20}, {-10,-17}, {-10,-20}, 
{ -9,-17}, { -9,-20}, { -8,-17}, { -8,-18}, { -8,-20}, 
{ -7,-18}, { -7,-19}, 

{-24, 1}, {-24, 0}, {-24,-1}, {-23,-2}, {-22,-2},       /* module C */
{-22,-1}, {-21,-1}, {-21, 0}, {-21, 1}, {-21, 2}, 
{-22, 3}, {-23, 3}, {-23, 2}, 
{-14, 0}, {-14,-1}, {-14,-2}, {-15,-3}, 

{-11,12}, {-11,11}, {-10,12}, { -9,12}, { -8,12},       /* module D */
{ -7,12}, { -6,12}, { -6,11}, { -5,10}, { -5,11}, 
{-11, 4}, {-10, 5}, { -9, 5}, { -8, 5}, { -7, 5}, 
{ -6, 4}, 

{-14,-5}, {-13,-4}, {-13,-5}, {-13,-6},                 /* transfer module */
{-12,-5}, {-12,-6}, 
{-20,-5}, {-21,-5}, {-21,-6}, {-21,-7}, {-21,-8}, 
{-20,-9}, {-19,-9}, {-18,-9} 
};

/******************************************************************************/
/*                                                                            */
/* End of include file mir.h                                                  */
/*                                                                            */
/******************************************************************************/
