/* A Bison parser, made by GNU Bison 3.7.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2020 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30704

/* Bison version string.  */
#define YYBISON_VERSION "3.7.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 1 "grammar.y"

#include "config.h"

#include <errno.h>
#include <fcntl.h>
#include <grp.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <pwd.h>

#ifdef HAVE_RPC_RPC_H
# include <rpc/rpc.h>
#endif
#ifdef HAVE_RPC_PMAP_CLNT_H
# include <rpc/pmap_clnt.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sysexits.h>
#include <syslog.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <regex.h>

#include "installpaths.h"
#include "port/port.h"

#if HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

#ifdef HAVE_NET_BPF_H
# include <net/bpf.h>
#endif

#include "assemble.h"
#include "bytecode.h"
#include "data.h"
#include "db.h"
#include "error.h"
#include "grammar.h"
#include "lex.h"
#include "libdb.h"
#include "parse.h"
#include "rlinetd.h"
#include "signals.h"
#include "util.h"

#define RL_PWARN(x...)			rl_pwarn(curfile_name, curfile_line, x)
#define RL_PFATAL(x,y...)		rl_pfatal(x, curfile_name, curfile_line, y)

struct userdata *userdata;

static struct service *current_service;
extern FILE *yyin;
extern char *rl_config;
char **files = NULL;
static int curfile = -1, numfiles = 0;
char *curfile_name = NULL;  /* name of the current file */
int curfile_line = 1;					 /* line */

static struct service *defaults;
static struct opmetalist *opml_defaults;

static struct logdata *logcur, *logdatas;

static struct numlist *numlist = NULL;
static struct stringlist *stringlist = NULL;

extern void yyerror(const char *c);
extern int yywrap(void);
extern int yylex(void);
static int bind_ports(void);
static int add_user_group(const struct service* current_service, struct opmetalist * l);
static void service_copy(struct service *to, struct service *from);
static void service_free(struct service *s);
static struct service *service_new(void);
#ifndef HAVE_GETADDRINFO
static int getservport(char *str, char *proto);
#endif
static struct logdata *logdata_get(char *name);
static struct logdata *logdata_new(void);
static void pidtab_fixup(void);
static void validate_service(struct service *s);
static void add_directory(char *dir, char *match, char *ignore);
static int chargen_buffer(void);

#line 177 "grammar.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_YY_GRAMMAR_H_INCLUDED
# define YY_YY_GRAMMAR_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    T_SERVICE = 258,               /* T_SERVICE  */
    T_PORT = 259,                  /* T_PORT  */
    T_EXEC = 260,                  /* T_EXEC  */
    T_PROTO = 261,                 /* T_PROTO  */
    T_UDP = 262,                   /* T_UDP  */
    T_TCP = 263,                   /* T_TCP  */
    T_UID = 264,                   /* T_UID  */
    T_GID = 265,                   /* T_GID  */
    T_BACKLOG = 266,               /* T_BACKLOG  */
    T_INSTANCES = 267,             /* T_INSTANCES  */
    T_WAIT = 268,                  /* T_WAIT  */
    T_DEFAULT = 269,               /* T_DEFAULT  */
    T_NICE = 270,                  /* T_NICE  */
    T_INTERFACE = 271,             /* T_INTERFACE  */
    T_ANY = 272,                   /* T_ANY  */
    T_FISH = 273,                  /* T_FISH  */
    T_CHROOT = 274,                /* T_CHROOT  */
    T_SERVER = 275,                /* T_SERVER  */
    T_DIR = 276,                   /* T_DIR  */
    T_RPC = 277,                   /* T_RPC  */
    T_VERSION = 278,               /* T_VERSION  */
    T_NAME = 279,                  /* T_NAME  */
    T_WRAP = 280,                  /* T_WRAP  */
    T_CAPS = 281,                  /* T_CAPS  */
    T_FAMILY = 282,                /* T_FAMILY  */
    T_IPV4 = 283,                  /* T_IPV4  */
    T_IPV6 = 284,                  /* T_IPV6  */
    T_INITGROUPS = 285,            /* T_INITGROUPS  */
    T_BANNER = 286,                /* T_BANNER  */
    T_ECHO = 287,                  /* T_ECHO  */
    T_DISCARD = 288,               /* T_DISCARD  */
    T_FILTER = 289,                /* T_FILTER  */
    T_CHARGEN = 290,               /* T_CHARGEN  */
    T_LOOPBACK = 291,              /* T_LOOPBACK  */
    T_ENABLED = 292,               /* T_ENABLED  */
    T_RLIMIT = 293,                /* T_RLIMIT  */
    T_LIM_CPU = 294,               /* T_LIM_CPU  */
    T_LIM_FSIZE = 295,             /* T_LIM_FSIZE  */
    T_LIM_DATA = 296,              /* T_LIM_DATA  */
    T_LIM_STACK = 297,             /* T_LIM_STACK  */
    T_LIM_CORE = 298,              /* T_LIM_CORE  */
    T_LIM_RSS = 299,               /* T_LIM_RSS  */
    T_LIM_NPROC = 300,             /* T_LIM_NPROC  */
    T_LIM_NOFILE = 301,            /* T_LIM_NOFILE  */
    T_LIM_MEMLOCK = 302,           /* T_LIM_MEMLOCK  */
    T_LIM_INFINITY = 303,          /* T_LIM_INFINITY  */
    T_SOFT = 304,                  /* T_SOFT  */
    T_HARD = 305,                  /* T_HARD  */
    T_YES = 306,                   /* T_YES  */
    T_NO = 307,                    /* T_NO  */
    T_LOG = 308,                   /* T_LOG  */
    T_PIPE = 309,                  /* T_PIPE  */
    T_SYSLOG = 310,                /* T_SYSLOG  */
    T_PATH = 311,                  /* T_PATH  */
    T_MODE = 312,                  /* T_MODE  */
    T_ACCEPT = 313,                /* T_ACCEPT  */
    T_DENY = 314,                  /* T_DENY  */
    T_CLOSE = 315,                 /* T_CLOSE  */
    T_EXIT = 316,                  /* T_EXIT  */
    T_NUMERIC = 317,               /* T_NUMERIC  */
    T_QSTRING = 318,               /* T_QSTRING  */
    T_IPADDR = 319                 /* T_IPADDR  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define T_SERVICE 258
#define T_PORT 259
#define T_EXEC 260
#define T_PROTO 261
#define T_UDP 262
#define T_TCP 263
#define T_UID 264
#define T_GID 265
#define T_BACKLOG 266
#define T_INSTANCES 267
#define T_WAIT 268
#define T_DEFAULT 269
#define T_NICE 270
#define T_INTERFACE 271
#define T_ANY 272
#define T_FISH 273
#define T_CHROOT 274
#define T_SERVER 275
#define T_DIR 276
#define T_RPC 277
#define T_VERSION 278
#define T_NAME 279
#define T_WRAP 280
#define T_CAPS 281
#define T_FAMILY 282
#define T_IPV4 283
#define T_IPV6 284
#define T_INITGROUPS 285
#define T_BANNER 286
#define T_ECHO 287
#define T_DISCARD 288
#define T_FILTER 289
#define T_CHARGEN 290
#define T_LOOPBACK 291
#define T_ENABLED 292
#define T_RLIMIT 293
#define T_LIM_CPU 294
#define T_LIM_FSIZE 295
#define T_LIM_DATA 296
#define T_LIM_STACK 297
#define T_LIM_CORE 298
#define T_LIM_RSS 299
#define T_LIM_NPROC 300
#define T_LIM_NOFILE 301
#define T_LIM_MEMLOCK 302
#define T_LIM_INFINITY 303
#define T_SOFT 304
#define T_HARD 305
#define T_YES 306
#define T_NO 307
#define T_LOG 308
#define T_PIPE 309
#define T_SYSLOG 310
#define T_PATH 311
#define T_MODE 312
#define T_ACCEPT 313
#define T_DENY 314
#define T_CLOSE 315
#define T_EXIT 316
#define T_NUMERIC 317
#define T_QSTRING 318
#define T_IPADDR 319

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 107 "grammar.y"

	long num;
	char *cp;
	struct passwd *uid;
	struct group *gid;
	struct opmetalist *opml;
	struct opmeta *opm;
	rlim_t rl;

#line 368 "grammar.c"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_GRAMMAR_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_T_SERVICE = 3,                  /* T_SERVICE  */
  YYSYMBOL_T_PORT = 4,                     /* T_PORT  */
  YYSYMBOL_T_EXEC = 5,                     /* T_EXEC  */
  YYSYMBOL_T_PROTO = 6,                    /* T_PROTO  */
  YYSYMBOL_T_UDP = 7,                      /* T_UDP  */
  YYSYMBOL_T_TCP = 8,                      /* T_TCP  */
  YYSYMBOL_T_UID = 9,                      /* T_UID  */
  YYSYMBOL_T_GID = 10,                     /* T_GID  */
  YYSYMBOL_T_BACKLOG = 11,                 /* T_BACKLOG  */
  YYSYMBOL_T_INSTANCES = 12,               /* T_INSTANCES  */
  YYSYMBOL_T_WAIT = 13,                    /* T_WAIT  */
  YYSYMBOL_T_DEFAULT = 14,                 /* T_DEFAULT  */
  YYSYMBOL_T_NICE = 15,                    /* T_NICE  */
  YYSYMBOL_T_INTERFACE = 16,               /* T_INTERFACE  */
  YYSYMBOL_T_ANY = 17,                     /* T_ANY  */
  YYSYMBOL_T_FISH = 18,                    /* T_FISH  */
  YYSYMBOL_T_CHROOT = 19,                  /* T_CHROOT  */
  YYSYMBOL_T_SERVER = 20,                  /* T_SERVER  */
  YYSYMBOL_T_DIR = 21,                     /* T_DIR  */
  YYSYMBOL_T_RPC = 22,                     /* T_RPC  */
  YYSYMBOL_T_VERSION = 23,                 /* T_VERSION  */
  YYSYMBOL_T_NAME = 24,                    /* T_NAME  */
  YYSYMBOL_T_WRAP = 25,                    /* T_WRAP  */
  YYSYMBOL_T_CAPS = 26,                    /* T_CAPS  */
  YYSYMBOL_T_FAMILY = 27,                  /* T_FAMILY  */
  YYSYMBOL_T_IPV4 = 28,                    /* T_IPV4  */
  YYSYMBOL_T_IPV6 = 29,                    /* T_IPV6  */
  YYSYMBOL_T_INITGROUPS = 30,              /* T_INITGROUPS  */
  YYSYMBOL_T_BANNER = 31,                  /* T_BANNER  */
  YYSYMBOL_T_ECHO = 32,                    /* T_ECHO  */
  YYSYMBOL_T_DISCARD = 33,                 /* T_DISCARD  */
  YYSYMBOL_T_FILTER = 34,                  /* T_FILTER  */
  YYSYMBOL_T_CHARGEN = 35,                 /* T_CHARGEN  */
  YYSYMBOL_T_LOOPBACK = 36,                /* T_LOOPBACK  */
  YYSYMBOL_T_ENABLED = 37,                 /* T_ENABLED  */
  YYSYMBOL_T_RLIMIT = 38,                  /* T_RLIMIT  */
  YYSYMBOL_T_LIM_CPU = 39,                 /* T_LIM_CPU  */
  YYSYMBOL_T_LIM_FSIZE = 40,               /* T_LIM_FSIZE  */
  YYSYMBOL_T_LIM_DATA = 41,                /* T_LIM_DATA  */
  YYSYMBOL_T_LIM_STACK = 42,               /* T_LIM_STACK  */
  YYSYMBOL_T_LIM_CORE = 43,                /* T_LIM_CORE  */
  YYSYMBOL_T_LIM_RSS = 44,                 /* T_LIM_RSS  */
  YYSYMBOL_T_LIM_NPROC = 45,               /* T_LIM_NPROC  */
  YYSYMBOL_T_LIM_NOFILE = 46,              /* T_LIM_NOFILE  */
  YYSYMBOL_T_LIM_MEMLOCK = 47,             /* T_LIM_MEMLOCK  */
  YYSYMBOL_T_LIM_INFINITY = 48,            /* T_LIM_INFINITY  */
  YYSYMBOL_T_SOFT = 49,                    /* T_SOFT  */
  YYSYMBOL_T_HARD = 50,                    /* T_HARD  */
  YYSYMBOL_T_YES = 51,                     /* T_YES  */
  YYSYMBOL_T_NO = 52,                      /* T_NO  */
  YYSYMBOL_T_LOG = 53,                     /* T_LOG  */
  YYSYMBOL_T_PIPE = 54,                    /* T_PIPE  */
  YYSYMBOL_T_SYSLOG = 55,                  /* T_SYSLOG  */
  YYSYMBOL_T_PATH = 56,                    /* T_PATH  */
  YYSYMBOL_T_MODE = 57,                    /* T_MODE  */
  YYSYMBOL_T_ACCEPT = 58,                  /* T_ACCEPT  */
  YYSYMBOL_T_DENY = 59,                    /* T_DENY  */
  YYSYMBOL_T_CLOSE = 60,                   /* T_CLOSE  */
  YYSYMBOL_T_EXIT = 61,                    /* T_EXIT  */
  YYSYMBOL_T_NUMERIC = 62,                 /* T_NUMERIC  */
  YYSYMBOL_T_QSTRING = 63,                 /* T_QSTRING  */
  YYSYMBOL_T_IPADDR = 64,                  /* T_IPADDR  */
  YYSYMBOL_65_ = 65,                       /* ';'  */
  YYSYMBOL_66_ = 66,                       /* '{'  */
  YYSYMBOL_67_ = 67,                       /* '}'  */
  YYSYMBOL_68_ = 68,                       /* ','  */
  YYSYMBOL_69_ = 69,                       /* '-'  */
  YYSYMBOL_YYACCEPT = 70,                  /* $accept  */
  YYSYMBOL_tles = 71,                      /* tles  */
  YYSYMBOL_tle = 72,                       /* tle  */
  YYSYMBOL_directory = 73,                 /* directory  */
  YYSYMBOL_log = 74,                       /* log  */
  YYSYMBOL_log_element = 75,               /* log_element  */
  YYSYMBOL_file_elements = 76,             /* file_elements  */
  YYSYMBOL_file_element = 77,              /* file_element  */
  YYSYMBOL_default = 78,                   /* default  */
  YYSYMBOL_service = 79,                   /* service  */
  YYSYMBOL_service_elements = 80,          /* service_elements  */
  YYSYMBOL_opcode_block = 81,              /* opcode_block  */
  YYSYMBOL_complex_opcode_element = 82,    /* complex_opcode_element  */
  YYSYMBOL_opcode_element = 83,            /* opcode_element  */
  YYSYMBOL_optionalstring = 84,            /* optionalstring  */
  YYSYMBOL_service_element = 85,           /* service_element  */
  YYSYMBOL_rpcents = 86,                   /* rpcents  */
  YYSYMBOL_rpcent = 87,                    /* rpcent  */
  YYSYMBOL_numrangelist = 88,              /* numrangelist  */
  YYSYMBOL_numrange = 89,                  /* numrange  */
  YYSYMBOL_limitents = 90,                 /* limitents  */
  YYSYMBOL_limitent = 91,                  /* limitent  */
  YYSYMBOL_ipaddrlists = 92,               /* ipaddrlists  */
  YYSYMBOL_ipaddrlist = 93,                /* ipaddrlist  */
  YYSYMBOL_portlists = 94,                 /* portlists  */
  YYSYMBOL_portlist = 95,                  /* portlist  */
  YYSYMBOL_limit = 96,                     /* limit  */
  YYSYMBOL_limitvalue = 97,                /* limitvalue  */
  YYSYMBOL_limittype = 98,                 /* limittype  */
  YYSYMBOL_userid = 99,                    /* userid  */
  YYSYMBOL_groupid = 100,                  /* groupid  */
  YYSYMBOL_protocol = 101,                 /* protocol  */
  YYSYMBOL_family = 102,                   /* family  */
  YYSYMBOL_signed_numeric = 103,           /* signed_numeric  */
  YYSYMBOL_boolean = 104                   /* boolean  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_uint8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  15
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   361

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  70
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  35
/* YYNRULES -- Number of rules.  */
#define YYNRULES  113
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  215

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   319


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    68,    69,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    65,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    66,     2,    67,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   147,   147,   148,   151,   152,   153,   154,   157,   159,
     161,   165,   180,   206,   207,   210,   211,   222,   230,   238,
     249,   267,   396,   400,   404,   415,   423,   431,   437,   441,
     452,   460,   470,   491,   512,   519,   529,   533,   537,   541,
     549,   561,   581,   595,   609,   613,   628,   643,   660,   677,
     696,   700,   704,   708,   718,   728,   729,   732,   733,   740,
     744,   748,   752,   756,   760,   767,   773,   778,   779,   780,
     795,   796,   799,   803,   810,   811,   814,   818,   828,   829,
     832,   836,   842,   843,   846,   852,   853,   856,   860,   870,
     874,   885,   887,   891,   900,   909,   918,   927,   936,   945,
     954,   963,   973,   978,   986,   991,   999,  1005,  1013,  1017,
    1028,  1032,  1038,  1042
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "T_SERVICE", "T_PORT",
  "T_EXEC", "T_PROTO", "T_UDP", "T_TCP", "T_UID", "T_GID", "T_BACKLOG",
  "T_INSTANCES", "T_WAIT", "T_DEFAULT", "T_NICE", "T_INTERFACE", "T_ANY",
  "T_FISH", "T_CHROOT", "T_SERVER", "T_DIR", "T_RPC", "T_VERSION",
  "T_NAME", "T_WRAP", "T_CAPS", "T_FAMILY", "T_IPV4", "T_IPV6",
  "T_INITGROUPS", "T_BANNER", "T_ECHO", "T_DISCARD", "T_FILTER",
  "T_CHARGEN", "T_LOOPBACK", "T_ENABLED", "T_RLIMIT", "T_LIM_CPU",
  "T_LIM_FSIZE", "T_LIM_DATA", "T_LIM_STACK", "T_LIM_CORE", "T_LIM_RSS",
  "T_LIM_NPROC", "T_LIM_NOFILE", "T_LIM_MEMLOCK", "T_LIM_INFINITY",
  "T_SOFT", "T_HARD", "T_YES", "T_NO", "T_LOG", "T_PIPE", "T_SYSLOG",
  "T_PATH", "T_MODE", "T_ACCEPT", "T_DENY", "T_CLOSE", "T_EXIT",
  "T_NUMERIC", "T_QSTRING", "T_IPADDR", "';'", "'{'", "'}'", "','", "'-'",
  "$accept", "tles", "tle", "directory", "log", "log_element",
  "file_elements", "file_element", "default", "service",
  "service_elements", "opcode_block", "complex_opcode_element",
  "opcode_element", "optionalstring", "service_element", "rpcents",
  "rpcent", "numrangelist", "numrange", "limitents", "limitent",
  "ipaddrlists", "ipaddrlist", "portlists", "portlist", "limit",
  "limitvalue", "limittype", "userid", "groupid", "protocol", "family",
  "signed_numeric", "boolean", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,    59,   123,   125,    44,    45
};
#endif

#define YYPACT_NINF (-59)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
      12,   -58,   -23,     3,    14,    60,   -59,   -59,   -59,   -59,
     -59,    37,   263,    20,    55,   -59,   -59,   263,   -41,    51,
      63,    47,    49,    70,    73,    64,   -52,   -16,    77,    97,
      98,    93,    10,    99,    89,   -38,   100,   101,   102,   103,
     105,   104,    64,    48,   -47,   107,   108,   -59,    19,   -59,
     -59,   -59,    39,   -59,     2,   118,   -59,   -59,    31,   -59,
     109,   -59,   -59,   110,   -59,   -59,   112,   -59,   -59,   117,
     119,   122,   -59,   -59,   123,   -59,   129,   127,   128,   -59,
      32,   -59,   -59,   130,   133,    96,    81,   -59,   300,   134,
     -59,   -59,   135,   -59,   140,   143,   145,   -59,   146,   -59,
     147,   -59,   148,   -59,   -59,   -59,   -59,   -59,   -59,   -59,
     -59,   -59,    16,   131,   151,   -59,   -59,   -59,   -59,   -59,
     -59,   152,   -59,    47,    49,   153,   156,   -59,   154,     2,
     -59,   -59,   -59,   -41,   -59,   -59,   -59,   -59,   -59,   -59,
     -59,   -59,   -59,   -59,   -59,   106,   -59,   -59,   160,   163,
     -20,   -59,   -59,   300,   171,   -59,   -59,   -59,   -59,   -59,
     -59,   -59,   -59,   -59,   -59,   -59,   -59,    76,   -59,   158,
     162,   165,   -59,   168,   169,   172,   174,   -59,   -59,   -59,
     -59,   175,    33,   -59,   182,   -59,   -59,   210,   -59,   -59,
     -59,   -42,   -42,   -31,   -59,   -59,   -59,   -59,   -59,   -59,
     -59,   -59,   187,   -59,   160,   -59,   -59,   185,   186,   -59,
     -59,   -59,   -59,   -59,   -59
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       0,     0,     0,     0,     0,     0,     2,     7,     6,     5,
       4,     0,     0,     0,     0,     1,     3,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,     0,     0,     0,     0,     0,     0,    57,     0,    27,
      24,    22,     0,     8,     0,     0,    88,    87,     0,    85,
       0,   107,   106,     0,   102,   103,     0,   104,   105,     0,
       0,     0,   112,   113,     0,   110,     0,     0,     0,    84,
       0,    82,    37,     0,     0,     0,     0,    49,     0,     0,
     108,   109,     0,    34,     0,     0,     0,    54,     0,    56,
       0,    53,     0,    93,    94,    95,    96,    97,    98,    99,
     100,   101,     0,     0,     0,    50,    51,    20,    26,    25,
      23,     0,     9,     0,     0,     0,     0,    15,     0,    12,
      13,    21,    58,     0,    32,    59,    33,    43,    60,    61,
      62,   111,    36,    65,    64,     0,    44,    66,     0,     0,
       0,    70,    48,     0,     0,    28,    29,    45,    68,    35,
      40,    52,    69,    41,    63,    92,    91,     0,    38,     0,
       0,     0,    10,     0,     0,     0,     0,    11,    14,    86,
      83,    76,     0,    74,     0,    67,    71,     0,    47,    31,
      30,     0,     0,     0,    78,    89,    39,    42,    17,    18,
      16,    19,     0,    73,     0,    72,    46,     0,     0,    90,
      79,    77,    75,    80,    81
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
     -59,   -59,   247,   -59,   -59,   -59,   -59,    36,   -59,   -59,
     236,   111,   -48,   -46,   -59,    13,   -59,   115,   -59,    50,
     -59,    62,   -59,   113,   -59,   124,   -59,   -34,   -59,   136,
     132,   -59,   -59,   -59,    27
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     5,     6,     7,     8,   128,   129,   130,     9,    10,
      48,   154,    49,    50,   100,    51,   150,   151,   182,   183,
     193,   194,    80,    81,    58,    59,   168,   169,   112,    66,
      69,    63,    92,    77,    74
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_uint8 yytable[] =
{
     118,    78,   119,   148,   149,    11,   165,   118,   113,   119,
      75,   123,   124,    72,    73,     1,   114,    76,   191,   192,
     166,    56,    57,    18,    19,    20,     2,    93,    21,    22,
      23,    24,    25,     3,    26,    27,   209,    28,    29,    30,
     155,    31,   156,    12,    32,    33,    34,   185,    79,    35,
      36,    37,    38,    39,    40,    41,    42,    43,   125,   126,
      15,   120,    94,     1,   165,     4,    13,   127,   120,   102,
      61,    62,    44,    86,     2,    87,    88,    14,   166,    45,
      46,     3,   167,    52,    47,    53,   117,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   132,   144,   203,   133,
     145,   204,   121,    17,   122,   155,   189,   156,   190,    64,
      65,    67,    68,     4,    60,    72,    73,    90,    91,   148,
     149,    54,    18,    19,    20,   191,   192,    21,    22,    23,
      24,    25,    70,    26,    27,    71,    28,    29,    30,   189,
      31,   190,    82,    32,    33,    34,   152,   153,    35,    36,
      37,    38,    39,    40,    41,    42,    43,   207,   208,    85,
      83,    84,    89,    95,    96,   178,    98,    97,    99,   101,
      79,    44,   115,   116,   134,   135,    19,   136,    45,    46,
      21,    22,   137,    47,   138,   131,    26,   139,   140,    28,
      29,   141,   142,   143,   170,   146,    32,    33,   147,   157,
     158,    35,    36,    37,    38,   159,    40,    41,   160,    43,
     161,   162,   163,   164,   171,    19,   175,   172,   176,    21,
      22,   177,   181,   195,    44,    26,   184,   196,    28,    29,
     197,    45,    46,   198,   199,    32,    33,   200,   188,   201,
      35,    36,    37,    38,   202,    40,    41,   205,    43,   211,
     213,   214,    16,    55,   212,   210,   174,   179,   180,   173,
       0,     0,     0,    44,   187,   186,     0,    18,    19,    20,
      45,    46,    21,    22,    23,    24,    25,   206,    26,    27,
       0,    28,    29,    30,     0,    31,     0,     0,    32,    33,
      34,     0,     0,    35,    36,    37,    38,    39,    40,    41,
      42,    43,     0,     0,     0,    19,     0,     0,     0,    21,
      22,     0,     0,     0,     0,    26,    44,     0,    28,    29,
       0,     0,     0,    45,    46,    32,    33,     0,    47,     0,
      35,    36,    37,    38,     0,    40,    41,     0,    43,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    44,     0,     0,     0,     0,     0,     0,
      45,    46
};

static const yytype_int16 yycheck[] =
{
      48,    17,    48,    23,    24,    63,    48,    55,    55,    55,
      62,     9,    10,    51,    52,     3,    63,    69,    49,    50,
      62,    62,    63,     4,     5,     6,    14,    65,     9,    10,
      11,    12,    13,    21,    15,    16,    67,    18,    19,    20,
      88,    22,    88,    66,    25,    26,    27,    67,    64,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    56,    57,
       0,    48,    35,     3,    48,    53,    63,    65,    55,    42,
       7,     8,    53,    63,    14,    65,    66,    63,    62,    60,
      61,    21,    66,    63,    65,    65,    67,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    65,    65,    65,    68,
      68,    68,    63,    66,    65,   153,   154,   153,   154,    62,
      63,    62,    63,    53,    63,    51,    52,    28,    29,    23,
      24,    66,     4,     5,     6,    49,    50,     9,    10,    11,
      12,    13,    62,    15,    16,    62,    18,    19,    20,   187,
      22,   187,    65,    25,    26,    27,    65,    66,    30,    31,
      32,    33,    34,    35,    36,    37,    38,   191,   192,    66,
      63,    63,    63,    63,    63,   129,    63,    65,    63,    65,
      64,    53,    65,    65,    65,    65,     5,    65,    60,    61,
       9,    10,    65,    65,    65,    67,    15,    65,    65,    18,
      19,    62,    65,    65,    63,    65,    25,    26,    65,    65,
      65,    30,    31,    32,    33,    65,    35,    36,    65,    38,
      65,    65,    65,    65,    63,     5,    63,    65,    62,     9,
      10,    67,    62,    65,    53,    15,    63,    65,    18,    19,
      65,    60,    61,    65,    65,    25,    26,    65,    67,    65,
      30,    31,    32,    33,    69,    35,    36,    65,    38,    62,
      65,    65,     5,    17,   204,   193,   124,   133,   145,   123,
      -1,    -1,    -1,    53,   153,   150,    -1,     4,     5,     6,
      60,    61,     9,    10,    11,    12,    13,    67,    15,    16,
      -1,    18,    19,    20,    -1,    22,    -1,    -1,    25,    26,
      27,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    -1,    -1,    -1,     5,    -1,    -1,    -1,     9,
      10,    -1,    -1,    -1,    -1,    15,    53,    -1,    18,    19,
      -1,    -1,    -1,    60,    61,    25,    26,    -1,    65,    -1,
      30,    31,    32,    33,    -1,    35,    36,    -1,    38,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      60,    61
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     3,    14,    21,    53,    71,    72,    73,    74,    78,
      79,    63,    66,    63,    63,     0,    72,    66,     4,     5,
       6,     9,    10,    11,    12,    13,    15,    16,    18,    19,
      20,    22,    25,    26,    27,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    53,    60,    61,    65,    80,    82,
      83,    85,    63,    65,    66,    80,    62,    63,    94,    95,
      63,     7,     8,   101,    62,    63,    99,    62,    63,   100,
      62,    62,    51,    52,   104,    62,    69,   103,    17,    64,
      92,    93,    65,    63,    63,    66,    63,    65,    66,    63,
      28,    29,   102,    65,   104,    63,    63,    65,    63,    63,
      84,    65,   104,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    98,    55,    63,    65,    65,    67,    82,    83,
      85,    63,    65,     9,    10,    56,    57,    65,    75,    76,
      77,    67,    65,    68,    65,    65,    65,    65,    65,    65,
      65,    62,    65,    65,    65,    68,    65,    65,    23,    24,
      86,    87,    65,    66,    81,    82,    83,    65,    65,    65,
      65,    65,    65,    65,    65,    48,    62,    66,    96,    97,
      63,    63,    65,    99,   100,    63,    62,    67,    77,    95,
      93,    62,    88,    89,    63,    67,    87,    81,    67,    82,
      83,    49,    50,    90,    91,    65,    65,    65,    65,    65,
      65,    65,    69,    65,    68,    65,    67,    97,    97,    67,
      91,    62,    89,    65,    65
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_int8 yyr1[] =
{
       0,    70,    71,    71,    72,    72,    72,    72,    73,    73,
      73,    74,    75,    76,    76,    77,    77,    77,    77,    77,
      78,    79,    80,    80,    80,    80,    80,    80,    81,    81,
      81,    81,    82,    82,    82,    82,    83,    83,    83,    83,
      83,    83,    83,    83,    83,    83,    83,    83,    83,    83,
      83,    83,    83,    83,    83,    84,    84,    85,    85,    85,
      85,    85,    85,    85,    85,    85,    85,    85,    85,    85,
      86,    86,    87,    87,    88,    88,    89,    89,    90,    90,
      91,    91,    92,    92,    93,    94,    94,    95,    95,    96,
      96,    97,    97,    98,    98,    98,    98,    98,    98,    98,
      98,    98,    99,    99,   100,   100,   101,   101,   102,   102,
     103,   103,   104,   104
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     3,     4,
       5,     5,     1,     1,     2,     1,     3,     3,     3,     3,
       4,     5,     1,     2,     1,     2,     2,     1,     1,     1,
       2,     2,     3,     3,     2,     3,     3,     2,     3,     4,
       3,     3,     4,     3,     3,     3,     5,     4,     3,     2,
       2,     2,     3,     2,     2,     0,     1,     1,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     4,     3,     3,
       1,     2,     3,     3,     1,     3,     1,     3,     1,     2,
       3,     3,     1,     3,     1,     1,     3,     1,     1,     2,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
# ifndef YY_LOCATION_PRINT
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YYUSE (yyoutput);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yykind < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yykind], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 8: /* directory: T_DIR T_QSTRING ';'  */
#line 158 "grammar.y"
        {	add_directory((yyvsp[-1].cp), NULL, NULL);	}
#line 1634 "grammar.c"
    break;

  case 9: /* directory: T_DIR T_QSTRING T_QSTRING ';'  */
#line 160 "grammar.y"
        {	add_directory((yyvsp[-2].cp), (yyvsp[-1].cp), NULL);	}
#line 1640 "grammar.c"
    break;

  case 10: /* directory: T_DIR T_QSTRING T_QSTRING T_QSTRING ';'  */
#line 162 "grammar.y"
        {	add_directory((yyvsp[-3].cp), (yyvsp[-2].cp), (yyvsp[-1].cp));	}
#line 1646 "grammar.c"
    break;

  case 11: /* log: T_LOG T_QSTRING '{' log_element '}'  */
#line 166 "grammar.y"
        {
		if(logdata_get((yyvsp[-3].cp))) {
			RL_PWARN("duplicate declaration of log %s, ignoring", (yyvsp[-3].cp));
			free((yyvsp[-3].cp));
		} else {
			logcur->name = (yyvsp[-3].cp);
			logcur->next = logdatas;
			logdatas = logcur;
			logcur = logdata_new();
		}
		clearuserdata(&userdata);
	}
#line 1663 "grammar.c"
    break;

  case 12: /* log_element: file_elements  */
#line 181 "grammar.y"
        {
		if(!logcur->path) {
			RL_PWARN(_("No path defined for log %s"), logcur->name);
		} else {
			if((logcur->index = open(logcur->path, O_CREAT|O_APPEND|O_WRONLY, logcur->mode)) < 0) {
				RL_PWARN(_("open(\"%s\", O_CREAT|O_APPEND|O_WRONLY, 0%o) failed (%s)"),
								logcur->path, logcur->mode, strerror(errno));
			} else {

				if(fchmod(logcur->index, logcur->mode)) {
					RL_PWARN(_("fchmod(\"%s\", 0%o) failed (%s)"),
									logcur->path, logcur->mode,
									strerror(errno));
				}

				if(fchown(logcur->index, logcur->uid, logcur->gid)) {
					RL_PWARN(_("fchown(\"%s\", %d, %d) failed for log %s (%s)"),
									logcur->path, logcur->uid, logcur->gid, logcur->name,
									strerror(errno));
				}
			}
		}
	}
#line 1691 "grammar.c"
    break;

  case 16: /* file_element: T_PATH T_QSTRING ';'  */
#line 212 "grammar.y"
        {
		if(logcur->path) {
			RL_PWARN(_("duplicate path declaration (%s) "
				"in log directive %s, ignoring"), (yyvsp[-1].cp),
				logcur->name);
			free((yyvsp[-1].cp));
		} else {
			logcur->path = (yyvsp[-1].cp);
		}
	}
#line 1706 "grammar.c"
    break;

  case 17: /* file_element: T_UID userid ';'  */
#line 223 "grammar.y"
        {
		if ((yyvsp[-1].uid)) {
			logcur->uid = (yyvsp[-1].uid)->pw_uid;
		} else {
			RL_PWARN("unknown username");
		}
	}
#line 1718 "grammar.c"
    break;

  case 18: /* file_element: T_GID groupid ';'  */
#line 231 "grammar.y"
        {
		if ((yyvsp[-1].gid)) {
			logcur->gid = (yyvsp[-1].gid)->gr_gid;
		} else {
			RL_PWARN("unknown groupname");
		}
	}
#line 1730 "grammar.c"
    break;

  case 19: /* file_element: T_MODE T_NUMERIC ';'  */
#line 239 "grammar.y"
        {
		if ((yyvsp[-1].num) > 07777)  {
			RL_PWARN(_("invalid mode declaration "
				"in log directive %s, ignoring"), logcur->name);
		} else {
			logcur->mode = (yyvsp[-1].num);
		}
	}
#line 1743 "grammar.c"
    break;

  case 20: /* default: T_DEFAULT '{' service_elements '}'  */
#line 250 "grammar.y"
        {
		/* swich pointers to current_service and defaults */
		struct service * saved_defaults = defaults;
		defaults = current_service;
		current_service = saved_defaults;

		/* copy new defaults to current_service */
		service_free(current_service);
		service_copy(current_service, defaults);

		/* save default opmetalist */
		opmetalist_free(opml_defaults);
		free(opml_defaults);
		opml_defaults = (yyvsp[-1].opml);
	}
#line 1763 "grammar.c"
    break;

  case 21: /* service: T_SERVICE T_QSTRING '{' service_elements '}'  */
#line 268 "grammar.y"
        {
		struct opmetalist *parent;
		struct opmetalist *onexit;
		struct oplist *ops;
		int i;
		int fds;
		fd_set *fdst;

		parent = opmetalist_new();
		onexit = opmetalist_new();

		current_service->name = (yyvsp[-3].cp);
		current_service->opfixups[ofp_iname] = stringtab_add((yyvsp[-3].cp));

		do { /* avoid goto */

			if (current_service->disabled)
				break;

			if(current_service->socktype == SOCK_STREAM && !current_service->wait) {
				if(opmetalist_add((yyvsp[-1].opml), opmeta_make(2, OP_ACCEPT, 200))) { /* !200 */
					RL_PWARN(_("opcode resolving problem"));
					current_service->disabled++;
					break;
				}
				opmetalist_add(parent, opmeta_make(1, OP_CLOSE));

				if (current_service->internal)
					opmetalist_add(onexit, opmeta_make(1, OP_CLOSE));
				else
					opmetalist_add(onexit, opmeta_make(1, OP_RET));

			} else {
				opmetalist_add(parent, opmeta_make(1, OP_RET));
				opmetalist_add(onexit, opmeta_make(1, OP_RET));
			}
			validate_service(current_service);


			if (current_service->disabled)
				break;

			if (!add_user_group(current_service, (yyvsp[-1].opml)))
			{
				++current_service->disabled;
			  break;
		  }


			fds = bind_ports();


			if(current_service->limit) {
				struct opmetalist *o;
				struct oplist *l;
				int match, under;

				o = opmetalist_new();
				opmetalist_add(o, opmeta_make(2, OP_LCLR, fds));
				opmetalist_add(o, opmeta_make(1, OP_RET));
				l = opmetalist_resolve(o, current_service->opfixups);
				match = oplisttab_add(l);
				opmetalist_free(o);
				free(o);
				oplist_free(l);
				free(l);

				o = opmetalist_new();
				opmetalist_add(o, opmeta_make(2, OP_LSET, fds));
				opmetalist_add(o, opmeta_make(1, OP_RET));
				l = opmetalist_resolve(o, current_service->opfixups);
				under = oplisttab_add(l);
				opmetalist_free(o);
				free(o);
				oplist_free(l);
				free(l);

				i = semaphore_add(current_service->limit, match, under);
				opmetalist_add((yyvsp[-1].opml), opmeta_make(2, OP_DOWN, i));
				opmetalist_add(onexit, opmeta_make(2, OP_UP, i));
			}
			ops = opmetalist_resolve(onexit, current_service->opfixups);
			current_service->opfixups[ofp_onexit] = oplisttab_add(ops);
			opmetalist_free(onexit);
			free(onexit);
			oplist_free(ops);
			free(ops);

			ops = opmetalist_resolve(parent, current_service->opfixups);
			current_service->opfixups[ofp_parent] = oplisttab_add(ops);
			opmetalist_free(parent);
			free(parent);
			oplist_free(ops);
			free(ops);

			opmetalist_merge((yyvsp[-1].opml), opml_defaults);

			opmetalist_add((yyvsp[-1].opml), opmeta_make(2, OP_JUMP, current_service->opfixups[ofp_onexit]));
			ops = opmetalist_resolve((yyvsp[-1].opml), current_service->opfixups);

			current_service->run = oplisttab_add(ops);
			opmetalist_free((yyvsp[-1].opml));
			free((yyvsp[-1].opml));
			oplist_free(ops);
			free(ops);

			fdst = fdsettab_get(fds);
			for(i = 0; i < FD_SETSIZE; i++)
				if(FD_ISSET(i, fdst))
					read_hook(i, oplisttab_get(current_service->run), NULL);

		} while (0);

		if (current_service->disabled) {
					rl_warn(_("service %s DISABLED"), current_service->name);
		} else {
			rl_note(_("service %s enabled"), current_service->name);
			if (rl_debug > 1)
				rl_note(_("+-> uid=%d, sgid=%d, supgid=%d fl=%d"), current_service->opfixups[ofp_setuid],
					current_service->opfixups[ofp_setgid], current_service->opfixups[ofp_supgid], current_service->sflags);

		}

		service_free(current_service);
		service_copy(current_service, defaults);
	}
#line 1894 "grammar.c"
    break;

  case 22: /* service_elements: service_element  */
#line 397 "grammar.y"
        {
		(yyval.opml) = opmetalist_new();
	}
#line 1902 "grammar.c"
    break;

  case 23: /* service_elements: service_elements service_element  */
#line 401 "grammar.y"
        {
		(yyval.opml) = (yyvsp[-1].opml);
	}
#line 1910 "grammar.c"
    break;

  case 24: /* service_elements: opcode_element  */
#line 405 "grammar.y"
        {
		struct opmetalist *l;

		l = opmetalist_new();
		if(opmetalist_add(l, (yyvsp[0].opm))) {
			RL_PWARN(_("opcode resolving problem"));
			current_service->disabled++;
		}
		(yyval.opml) = l;
	}
#line 1925 "grammar.c"
    break;

  case 25: /* service_elements: service_elements opcode_element  */
#line 416 "grammar.y"
        {
		if(opmetalist_add((yyvsp[-1].opml), (yyvsp[0].opm))) {
			RL_PWARN(_("opcode resolving problem"));
			current_service->disabled++;
		}
		(yyval.opml) = (yyvsp[-1].opml);
	}
#line 1937 "grammar.c"
    break;

  case 26: /* service_elements: service_elements complex_opcode_element  */
#line 424 "grammar.y"
        {
		(yyval.opml) = opmetalist_join((yyvsp[-1].opml), (yyvsp[0].opml));
		if(!(yyval.opml)) {
			RL_PWARN(_("opcode resolving problem"));
			current_service->disabled++;
		}
	}
#line 1949 "grammar.c"
    break;

  case 27: /* service_elements: complex_opcode_element  */
#line 432 "grammar.y"
        {
		(yyval.opml) = (yyvsp[0].opml);
	}
#line 1957 "grammar.c"
    break;

  case 28: /* opcode_block: complex_opcode_element  */
#line 438 "grammar.y"
        {
		(yyval.opml) = (yyvsp[0].opml);
	}
#line 1965 "grammar.c"
    break;

  case 29: /* opcode_block: opcode_element  */
#line 442 "grammar.y"
        {
		struct opmetalist *l;

		l = opmetalist_new();
		if(opmetalist_add(l, (yyvsp[0].opm))) {
			RL_PWARN(_("opcode resolving problem"));
			current_service->disabled++;
		}
		(yyval.opml) = l;
	}
#line 1980 "grammar.c"
    break;

  case 30: /* opcode_block: opcode_block opcode_element  */
#line 453 "grammar.y"
        {
		if(opmetalist_add((yyvsp[-1].opml), (yyvsp[0].opm))) {
			RL_PWARN(_("opcode resolving problem"));
			current_service->disabled++;
		}
		(yyval.opml) = (yyvsp[-1].opml);
	}
#line 1992 "grammar.c"
    break;

  case 31: /* opcode_block: opcode_block complex_opcode_element  */
#line 461 "grammar.y"
        {
		(yyval.opml) = opmetalist_join((yyvsp[-1].opml), (yyvsp[0].opml));
		if(!(yyval.opml)) {
			RL_PWARN(_("opcode resolving problem"));
			current_service->disabled++;
		}
	}
#line 2004 "grammar.c"
    break;

  case 32: /* complex_opcode_element: T_EXEC T_QSTRING ';'  */
#line 471 "grammar.y"
        {
		struct opmetalist *l;
		struct opmeta *o;

		l = opmetalist_new();
		o = opmeta_make(3, OP_EXEC, 666, argvtab_add((yyvsp[-1].cp), 1));
		opmeta_fixup(o, 1, ofp_exec);
		if(opmetalist_add(l, o)) {
			RL_PWARN(_("opcode resolving problem"));
			current_service->disabled++;
		}
		o = opmeta_make(3, OP_FORK, 666, 666);
		opmeta_fixup(o, 1, ofp_parent);
		opmeta_fixup(o, 2, ofp_onexit);
		if(opmetalist_add(l, o)) {
			RL_PWARN(_("opcode resolving problem"));
			current_service->disabled++;
		}
		(yyval.opml) = l;
	}
#line 2029 "grammar.c"
    break;

  case 33: /* complex_opcode_element: T_UID userid ';'  */
#line 492 "grammar.y"
        {
		if((yyvsp[-1].uid)) {

			current_service->opfixups[ofp_iuser] = stringtab_add((yyvsp[-1].uid)->pw_name);
			current_service->opfixups[ofp_setuid] = (yyvsp[-1].uid)->pw_uid;
			current_service->opfixups[ofp_supgid] = (yyvsp[-1].uid)->pw_gid;

			set_flag(current_service, FLAG_USER);

			if(!has_flag(current_service, FLAG_GROUP)) {
				current_service->opfixups[ofp_setgid] = (yyvsp[-1].uid)->pw_gid;
			}

			(yyval.opml) = NULL;
		} else {
			RL_PWARN("unknown username");
			current_service->disabled++;
			(yyval.opml) = NULL;
		}
	}
#line 2054 "grammar.c"
    break;

  case 34: /* complex_opcode_element: T_INITGROUPS ';'  */
#line 513 "grammar.y"
        {
		set_flag(current_service, FLAG_INITGROUPS);

		(yyval.opml) = NULL;

	}
#line 2065 "grammar.c"
    break;

  case 35: /* complex_opcode_element: T_INITGROUPS boolean ';'  */
#line 520 "grammar.y"
        {
		if ((yyvsp[-1].num))
			set_flag(current_service, FLAG_INITGROUPS);
		else
			reset_flag(current_service, FLAG_INITGROUPS);
		(yyval.opml) = NULL;
	}
#line 2077 "grammar.c"
    break;

  case 36: /* opcode_element: T_NICE signed_numeric ';'  */
#line 530 "grammar.y"
        {
		(yyval.opm) = opmeta_make(2, OP_NICE, (yyvsp[-1].num));
	}
#line 2085 "grammar.c"
    break;

  case 37: /* opcode_element: T_FISH ';'  */
#line 534 "grammar.y"
        {
		(yyval.opm) = opmeta_make(1, OP_FISH);
	}
#line 2093 "grammar.c"
    break;

  case 38: /* opcode_element: T_RLIMIT limittype limit  */
#line 538 "grammar.y"
        {
		(yyval.opm) = opmeta_make(3, OP_RLIMIT, (yyvsp[-1].num), (yyvsp[0].num));
	}
#line 2101 "grammar.c"
    break;

  case 39: /* opcode_element: T_LOG T_SYSLOG T_QSTRING ';'  */
#line 542 "grammar.y"
        {
		int i;

		i = logtab_add(-1, (yyvsp[-1].cp));
		(yyval.opm) = opmeta_make(2, OP_LOG, i);
		free((yyvsp[-1].cp));
	}
#line 2113 "grammar.c"
    break;

  case 40: /* opcode_element: T_BANNER T_QSTRING ';'  */
#line 550 "grammar.y"
        {
		int ret;

		ret = buftab_addfile((yyvsp[-1].cp));
		if(ret == -1)
			current_service->disabled++;
		(yyval.opm) = opmeta_make(16, OP_ZERO, OP_BUFCLONE, ret, OP_WHOOK, 0, OP_WUNHOOK,
										 OP_DUP, OP_BUFCOPY, OP_DUP, OP_BZNEG, 3, OP_ADD,
										 OP_WHOOK, -9, OP_POP, OP_BUFFREE);
		free((yyvsp[-1].cp));
	}
#line 2129 "grammar.c"
    break;

  case 41: /* opcode_element: T_CHARGEN optionalstring ';'  */
#line 562 "grammar.y"
        {
		int i;

		if((yyvsp[-1].cp)) {
			i = buftab_addfile((yyvsp[-1].cp));
			if(i < 0)
				current_service->disabled++;
		} else {
			i = chargen_buffer();
		}
		(yyval.opm) = opmeta_make(25, OP_ZERO, OP_DUP, OP_BUFCLONE, i, OP_POP,
										 OP_POP, OP_ZERO, OP_WHOOK, 0, OP_WUNHOOK, OP_DUP,
										 OP_BUFCOPY, OP_DUP, OP_BZ, -11, OP_DUP, OP_BZNEG, 3,
										 OP_ADD, OP_WHOOK, -12, OP_POP, OP_BUFFREE, OP_JUMP, 666);
		opmeta_fixup((yyval.opm), 24, ofp_onexit);
		current_service->internal = 1;
		if((yyvsp[-1].cp))
			free((yyvsp[-1].cp));
	}
#line 2153 "grammar.c"
    break;

  case 42: /* opcode_element: T_LOG T_QSTRING T_QSTRING ';'  */
#line 582 "grammar.y"
        {
		struct logdata *ld = logdata_get((yyvsp[-2].cp));

		if(!ld) {
			RL_PWARN(_("unknown log %s"), (yyvsp[-2].cp));
			current_service->disabled++;
		} else {
			int i = logtab_add(ld->index, (yyvsp[-1].cp));
			(yyval.opm) = opmeta_make(2, OP_LOG, i);
		}
		free((yyvsp[-2].cp));
		free((yyvsp[-1].cp));
	}
#line 2171 "grammar.c"
    break;

  case 43: /* opcode_element: T_GID groupid ';'  */
#line 596 "grammar.y"
        {
		if(!(yyvsp[-1].gid)) {
			RL_PWARN(_("unknown group"));
			current_service->disabled++;
			(yyval.opm) = NULL;
		} else {

			current_service->opfixups[ofp_setgid] = (yyvsp[-1].gid)->gr_gid;
			set_flag(current_service, FLAG_GROUP);

			(yyval.opm) = NULL;
		}
	}
#line 2189 "grammar.c"
    break;

  case 44: /* opcode_element: T_CHROOT T_QSTRING ';'  */
#line 610 "grammar.y"
        {
		(yyval.opm) = opmeta_make(2, OP_CHROOT, argvtab_add((yyvsp[-1].cp), 1));
	}
#line 2197 "grammar.c"
    break;

  case 45: /* opcode_element: T_CAPS T_QSTRING ';'  */
#line 614 "grammar.y"
        {
#ifdef HAVE_CAPABILITIES
		cap_t current_caps = cap_from_text((yyvsp[-1].cp));
		if(current_caps) {
			(yyval.opm) = opmeta_make(2, OP_SETCAP, captab_add(current_caps));
		} else {
			RL_PWARN(_("failed to parse capability string \"%s\"\n"), (yyvsp[-1].cp));
			current_service->disabled++;
		}
		free((yyvsp[-1].cp));
#else
		RL_PFATAL(EX_DATAERR, _("ABORT - support for capabilities not compiled in"));
#endif
	}
#line 2216 "grammar.c"
    break;

  case 46: /* opcode_element: T_WRAP T_QSTRING '{' opcode_block '}'  */
#line 629 "grammar.y"
        {
		int i;
		struct oplist *op;

		opmetalist_add((yyvsp[-1].opml), opmeta_make(1, OP_RET));
		op = opmetalist_resolve((yyvsp[-1].opml),current_service->opfixups);
		i = oplisttab_add(op);
		(yyval.opm) = opmeta_make(3, OP_WRAP, stringtab_add((yyvsp[-3].cp)), i);
		free((yyvsp[-3].cp));
		oplist_free(op);
		free(op);
		opmetalist_free((yyvsp[-1].opml));
		free((yyvsp[-1].opml));
	}
#line 2235 "grammar.c"
    break;

  case 47: /* opcode_element: T_WRAP '{' opcode_block '}'  */
#line 644 "grammar.y"
        {
		struct opmeta *o;
		int i;
		struct oplist *op;

		opmetalist_add((yyvsp[-1].opml), opmeta_make(1, OP_RET));
		op = opmetalist_resolve((yyvsp[-1].opml), current_service->opfixups);
		i = oplisttab_add(op);
		o = opmeta_make(3, OP_WRAP, 666, i);
		opmeta_fixup(o, 1, ofp_iname);
		(yyval.opm) = o;
		oplist_free(op);
		free(op);
		opmetalist_free((yyvsp[-1].opml));
		free((yyvsp[-1].opml));
	}
#line 2256 "grammar.c"
    break;

  case 48: /* opcode_element: T_WRAP T_QSTRING ';'  */
#line 661 "grammar.y"
        {
		struct opmetalist *l;
		int i;
		struct oplist *op;

		l = opmetalist_new();
		opmetalist_add(l, opmeta_make(1, OP_EXIT));
		op = opmetalist_resolve(l, current_service->opfixups);
		i = oplisttab_add(op);
		(yyval.opm) = opmeta_make(3, OP_WRAP, stringtab_add((yyvsp[-1].cp)), i);
		free((yyvsp[-1].cp));
		oplist_free(op);
		free(op);
		opmetalist_free(l);
		free(l);
	}
#line 2277 "grammar.c"
    break;

  case 49: /* opcode_element: T_WRAP ';'  */
#line 678 "grammar.y"
        {
		struct opmetalist *l;
		struct opmeta *o;
		int i;
		struct oplist *op;

		l = opmetalist_new();
		opmetalist_add(l, opmeta_make(1, OP_EXIT));
		op = opmetalist_resolve(l,current_service->opfixups);
		i = oplisttab_add(op);
		o = opmeta_make(3, OP_WRAP, 666, i);
		opmeta_fixup(o, 1, ofp_iname);
		(yyval.opm) = o;
		oplist_free(op);
		free(op);
		opmetalist_free(l);
		free(l);
	}
#line 2300 "grammar.c"
    break;

  case 50: /* opcode_element: T_CLOSE ';'  */
#line 697 "grammar.y"
        {
		(yyval.opm) = opmeta_make(1, OP_CLOSE);
	}
#line 2308 "grammar.c"
    break;

  case 51: /* opcode_element: T_EXIT ';'  */
#line 701 "grammar.y"
        {
		(yyval.opm) = opmeta_make(1, OP_EXIT);
	}
#line 2316 "grammar.c"
    break;

  case 52: /* opcode_element: T_ECHO T_QSTRING ';'  */
#line 705 "grammar.y"
        {
		(yyval.opm) = opmeta_make(2, OP_ECHO, argvtab_add((yyvsp[-1].cp), 0));
	}
#line 2324 "grammar.c"
    break;

  case 53: /* opcode_element: T_LOOPBACK ';'  */
#line 709 "grammar.y"
        {
		(yyval.opm) = opmeta_make(29, OP_ZERO, OP_BUFINIT, 11, OP_RHOOK, 0, OP_BUFREAD,
										 OP_RUNHOOK, OP_DUP, OP_BZNEG, 17, OP_ADD, OP_WHOOK, 0,
										 OP_BUFWRITE, OP_WUNHOOK, OP_DUP, OP_BZ, 6, OP_DUP,
										 OP_BZNEG, 6, OP_SUB, OP_WHOOK, -11, OP_POP, OP_RHOOK, -22,
										 OP_JUMP, 666);
		opmeta_fixup((yyval.opm), 28, ofp_onexit);
		current_service->internal = 1;
	}
#line 2338 "grammar.c"
    break;

  case 54: /* opcode_element: T_DISCARD ';'  */
#line 719 "grammar.y"
        {
		(yyval.opm) = opmeta_make(13, OP_ZERO, OP_RHOOK, 0, OP_RUNHOOK, OP_BUFINIT, 1024,
										 OP_BUFREAD, OP_BZNEG, 2, OP_RHOOK, -8, OP_JUMP, 666);
		opmeta_fixup((yyval.opm), 12, ofp_onexit);
		current_service->internal = 1;
	}
#line 2349 "grammar.c"
    break;

  case 55: /* optionalstring: %empty  */
#line 728 "grammar.y"
        {	(yyval.cp) = NULL;	}
#line 2355 "grammar.c"
    break;

  case 58: /* service_element: T_PORT portlists ';'  */
#line 734 "grammar.y"
        {
		if(current_service->port)
			stringlist_free(current_service->port);
		current_service->port = stringlist;
		stringlist = NULL;
	}
#line 2366 "grammar.c"
    break;

  case 59: /* service_element: T_PROTO protocol ';'  */
#line 741 "grammar.y"
        {
		current_service->socktype = (yyvsp[-1].num);
	}
#line 2374 "grammar.c"
    break;

  case 60: /* service_element: T_BACKLOG T_NUMERIC ';'  */
#line 745 "grammar.y"
        {
		current_service->backlog = (yyvsp[-1].num);
	}
#line 2382 "grammar.c"
    break;

  case 61: /* service_element: T_INSTANCES T_NUMERIC ';'  */
#line 749 "grammar.y"
        {
		current_service->limit = (yyvsp[-1].num);
	}
#line 2390 "grammar.c"
    break;

  case 62: /* service_element: T_WAIT boolean ';'  */
#line 753 "grammar.y"
        {
		current_service->wait  = (yyvsp[-1].num);
	}
#line 2398 "grammar.c"
    break;

  case 63: /* service_element: T_ENABLED boolean ';'  */
#line 757 "grammar.y"
        {
		current_service->disabled  = ! (yyvsp[-1].num);
	}
#line 2406 "grammar.c"
    break;

  case 64: /* service_element: T_INTERFACE ipaddrlists ';'  */
#line 761 "grammar.y"
        {
		if(current_service->interface)
			stringlist_free(current_service->interface);
		current_service->interface = stringlist;
		stringlist = NULL;
	}
#line 2417 "grammar.c"
    break;

  case 65: /* service_element: T_INTERFACE T_ANY ';'  */
#line 768 "grammar.y"
        {
		if(current_service->interface)
			stringlist_free(current_service->interface);
		current_service->interface = NULL;
	}
#line 2427 "grammar.c"
    break;

  case 66: /* service_element: T_SERVER T_QSTRING ';'  */
#line 774 "grammar.y"
        {
		current_service->opfixups[ofp_exec] = stringtab_add((yyvsp[-1].cp));
		free((yyvsp[-1].cp));
	}
#line 2436 "grammar.c"
    break;

  case 69: /* service_element: T_FILTER T_QSTRING ';'  */
#line 781 "grammar.y"
        {
#ifdef HAVE_NET_BPF_H
		if(current_service->filter)
			free(current_service->filter);
		if(rl_readfile((yyvsp[-1].cp), &current_service->filter, &current_service->filterlen))
			current_service->disabled++;
		free((yyvsp[-1].cp));
#else
		RL_PFATAL(EX_DATAERR, _("ABORT - support for socket filter not compiled in"));
#endif
	}
#line 2452 "grammar.c"
    break;

  case 72: /* rpcent: T_NAME T_QSTRING ';'  */
#line 800 "grammar.y"
        {
		current_service->rpcname = (yyvsp[-1].cp);
	}
#line 2460 "grammar.c"
    break;

  case 73: /* rpcent: T_VERSION numrangelist ';'  */
#line 804 "grammar.y"
        {
		current_service->rpcvers = numlist;
		numlist = NULL;
	}
#line 2469 "grammar.c"
    break;

  case 76: /* numrange: T_NUMERIC  */
#line 815 "grammar.y"
        {
		numlist_add(&numlist, (yyvsp[0].num));
	}
#line 2477 "grammar.c"
    break;

  case 77: /* numrange: T_NUMERIC '-' T_NUMERIC  */
#line 819 "grammar.y"
        {
		int i;

		if((yyvsp[0].num) >= (yyvsp[-2].num))
			for(i = (yyvsp[-2].num); i <= (yyvsp[0].num); i++)
				numlist_add(&numlist, i);
	}
#line 2489 "grammar.c"
    break;

  case 80: /* limitent: T_SOFT limitvalue ';'  */
#line 833 "grammar.y"
        {
		current_service->r.rlim_cur = (yyvsp[-1].rl);
	}
#line 2497 "grammar.c"
    break;

  case 81: /* limitent: T_HARD limitvalue ';'  */
#line 837 "grammar.y"
        {
		current_service->r.rlim_max = (yyvsp[-1].rl);
	}
#line 2505 "grammar.c"
    break;

  case 84: /* ipaddrlist: T_IPADDR  */
#line 847 "grammar.y"
        {
		stringlist_add(&stringlist, (yyvsp[0].cp));
	}
#line 2513 "grammar.c"
    break;

  case 87: /* portlist: T_QSTRING  */
#line 857 "grammar.y"
        {
		stringlist_add(&stringlist, (yyvsp[0].cp));
	}
#line 2521 "grammar.c"
    break;

  case 88: /* portlist: T_NUMERIC  */
#line 861 "grammar.y"
        {
		char tmp[20];

		snprintf(tmp, 19, "%ld", (yyvsp[0].num));
		tmp[19] = '\0';
		stringlist_add(&stringlist, strdup(tmp));
	}
#line 2533 "grammar.c"
    break;

  case 89: /* limit: limitvalue ';'  */
#line 871 "grammar.y"
        {
		(yyval.num) = rlimittab_add((yyvsp[-1].rl), (yyvsp[-1].rl));
	}
#line 2541 "grammar.c"
    break;

  case 90: /* limit: '{' limitents '}'  */
#line 875 "grammar.y"
        {
		if((current_service->r.rlim_max != RLIM_INFINITY) &&
			 (current_service->r.rlim_cur > current_service->r.rlim_max)) {
			RL_PWARN(_("invalid resource limit"));
		}
		(yyval.num) = rlimittab_add(current_service->r.rlim_cur, current_service->r.rlim_max);
		current_service->r.rlim_cur = current_service->r.rlim_max = RLIM_INFINITY;
	}
#line 2554 "grammar.c"
    break;

  case 91: /* limitvalue: T_NUMERIC  */
#line 886 "grammar.y"
        { (yyval.rl) = (rlim_t)(yyvsp[0].num); }
#line 2560 "grammar.c"
    break;

  case 92: /* limitvalue: T_LIM_INFINITY  */
#line 888 "grammar.y"
        { (yyval.rl) = RLIM_INFINITY; }
#line 2566 "grammar.c"
    break;

  case 93: /* limittype: T_LIM_CPU  */
#line 892 "grammar.y"
        {
#ifdef RLIMIT_CPU
		(yyval.num) = RLIMIT_CPU;
#else
		RL_PFATAL(EX_DATAERR, _("%s limit not available on this system"), "cpu");
#endif
	}
#line 2578 "grammar.c"
    break;

  case 94: /* limittype: T_LIM_FSIZE  */
#line 901 "grammar.y"
        {
#ifdef RLIMIT_FSIZE
		(yyval.num) = RLIMIT_FSIZE;
#else
		RL_PFATAL(EX_DATAERR, _("%s limit not available on this system"), "fsize");
#endif
	}
#line 2590 "grammar.c"
    break;

  case 95: /* limittype: T_LIM_DATA  */
#line 910 "grammar.y"
        {
#ifdef RLIMIT_DATA
		(yyval.num) = RLIMIT_DATA;
#else
		RL_PFATAL(EX_DATAERR, _("%s limit not available on this system"), "data");
#endif
	}
#line 2602 "grammar.c"
    break;

  case 96: /* limittype: T_LIM_STACK  */
#line 919 "grammar.y"
        {
#ifdef RLIMIT_STACK
		(yyval.num) = RLIMIT_STACK;
#else
		RL_PFATAL(EX_DATAERR, _("%s limit not available on this system"), "stack");
#endif
	}
#line 2614 "grammar.c"
    break;

  case 97: /* limittype: T_LIM_CORE  */
#line 928 "grammar.y"
        {
#ifdef RLIMIT_CORE
		(yyval.num) = RLIMIT_CORE;
#else
		RL_PFATAL(EX_DATAERR, _("%s limit not available on this system"), "core");
#endif
	}
#line 2626 "grammar.c"
    break;

  case 98: /* limittype: T_LIM_RSS  */
#line 937 "grammar.y"
        {
#ifdef RLIMIT_RSS
		(yyval.num) = RLIMIT_RSS;
#else
		RL_PFATAL(EX_DATAERR, _("%s limit not available on this system"), "rss");
#endif
	}
#line 2638 "grammar.c"
    break;

  case 99: /* limittype: T_LIM_NPROC  */
#line 946 "grammar.y"
        {
#ifdef RLIMIT_NPROC
		(yyval.num) = RLIMIT_NPROC;
#else
		RL_PFATAL(EX_DATAERR, _("%s limit not available on this system"), "nproc");
#endif
	}
#line 2650 "grammar.c"
    break;

  case 100: /* limittype: T_LIM_NOFILE  */
#line 955 "grammar.y"
        {
#ifdef RLIMIT_NOFILE
		(yyval.num) = RLIMIT_NOFILE;
#else
		RL_PFATAL(EX_DATAERR, _("%s limit not available on this system"), "nofile");
#endif
	}
#line 2662 "grammar.c"
    break;

  case 101: /* limittype: T_LIM_MEMLOCK  */
#line 964 "grammar.y"
        {
#ifdef RLIMIT_MEMLOCK
		(yyval.num) = RLIMIT_MEMLOCK;
#else
		RL_PFATAL(EX_DATAERR, _("%s limit not available on this system"), "memlock");
#endif
	}
#line 2674 "grammar.c"
    break;

  case 102: /* userid: T_NUMERIC  */
#line 974 "grammar.y"
        {
		(yyval.uid) = getpwuid((yyvsp[0].num));
		endpwent();
	}
#line 2683 "grammar.c"
    break;

  case 103: /* userid: T_QSTRING  */
#line 979 "grammar.y"
        {
		(yyval.uid) = getpwnam((yyvsp[0].cp));
		free((yyvsp[0].cp));
		endpwent();
	}
#line 2693 "grammar.c"
    break;

  case 104: /* groupid: T_NUMERIC  */
#line 987 "grammar.y"
        {
		(yyval.gid) = getgrgid((yyvsp[0].num));
		endgrent();
	}
#line 2702 "grammar.c"
    break;

  case 105: /* groupid: T_QSTRING  */
#line 992 "grammar.y"
        {
		(yyval.gid) = getgrnam((yyvsp[0].cp));
		free((yyvsp[0].cp));
		endgrent();
	}
#line 2712 "grammar.c"
    break;

  case 106: /* protocol: T_TCP  */
#line 1000 "grammar.y"
        {
		(yyval.num) = SOCK_STREAM;
		current_service->protoname = "tcp";
		current_service->proto = IPPROTO_TCP;
	}
#line 2722 "grammar.c"
    break;

  case 107: /* protocol: T_UDP  */
#line 1006 "grammar.y"
        {
		(yyval.num) = SOCK_DGRAM;
		current_service->protoname = "udp";
		current_service->proto = IPPROTO_UDP;
	}
#line 2732 "grammar.c"
    break;

  case 108: /* family: T_IPV4  */
#line 1014 "grammar.y"
        {
		current_service->family = PF_INET;
	}
#line 2740 "grammar.c"
    break;

  case 109: /* family: T_IPV6  */
#line 1018 "grammar.y"
        {
#ifdef HAVE_SOCKADDR_IN6
		current_service->family = PF_INET6;
#else
		RL_PWARN(_("ipv6 support is not compiled in"));
		current_service->family = PF_INET;
#endif
	}
#line 2753 "grammar.c"
    break;

  case 110: /* signed_numeric: T_NUMERIC  */
#line 1029 "grammar.y"
{
		(yyval.num) = (yyvsp[0].num);
	}
#line 2761 "grammar.c"
    break;

  case 111: /* signed_numeric: '-' T_NUMERIC  */
#line 1033 "grammar.y"
        {
		(yyval.num) = (-(yyvsp[0].num));
	}
#line 2769 "grammar.c"
    break;

  case 112: /* boolean: T_YES  */
#line 1039 "grammar.y"
        {
		(yyval.num) = 1;
	}
#line 2777 "grammar.c"
    break;

  case 113: /* boolean: T_NO  */
#line 1043 "grammar.y"
        {
		(yyval.num) = 0;
	}
#line 2785 "grammar.c"
    break;


#line 2789 "grammar.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;


#if !defined yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturn;
#endif


/*-------------------------------------------------------.
| yyreturn -- parsing is finished, clean up and return.  |
`-------------------------------------------------------*/
yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 1047 "grammar.y"


void yyerror(const char *str) {
	RL_PFATAL(EX_DATAERR, _("ABORT - %s"), str);
}

int yywrap(void) {
	fclose(yyin);
	if(numfiles) {
		while(++curfile < numfiles) {
			if((yyin = fopen(files[curfile], "r"))) {
				curfile_name = files[curfile];
				curfile_line = 1;
				return 0;
			} else {
				curfile_name = NULL;
				RL_PWARN(_("cannot open file %s (%s)"), files[curfile],
						strerror(errno));
			}
		}
	}
	return 1;
}

static struct service *service_new() {
	struct service *p = (struct service *)malloc(sizeof(*p));

	if (!p)
		rl_fatal(EX_SOFTWARE, _("ABORT - Can't allocate memory"));
	memset(p, 0, sizeof(*p));
	return p;
}

void services_free() {
	if(rl_cleanups) {
		rlp_cleanup(rl_cleanups);
		rl_cleanups = NULL;
	}
}

static void validate_service(struct service *s) {
	if(!s->name) {
		RL_PWARN(_("service without name"));
		s->disabled++;
		return;
	}

	if (!has_flag(s, FLAG_USER)) {
		RL_PWARN(_("user is not set for service %s"), s->name);
		s->disabled++;
		return;
	}

	if (s->wait && s->limit != 1) {
		if (s->limit != defaults->limit)
			RL_PWARN(_("ignoring `instances %d' directive for service %s, because `wait' was also given"),
										s->limit, s->name);
		s->limit = 1;
	}

	if(s->rpcvers) {
		const char *rpcname = s->name;
		struct rpcent *rep;

		if(s->rpcname)
			rpcname = s->rpcname;
		rep = getrpcbyname(rpcname);
		if(!rep) {
			RL_PWARN(_("can't find rpc service %s for service %s"),
							rpcname, s->name);
			s->disabled++;
		} else {
			s->rpcnum = rep->r_number;
		}
		endrpcent();
	}
}

static in_port_t get_rpc_port(struct service * cur_service)
{
	if (!cur_service->rpcnum)
		return 0;
	const struct numlist *vers = cur_service->rpcvers;
	struct sockaddr_in myaddress;
	get_myaddress(&myaddress);
	in_port_t result = 0;
	do {
		const in_port_t port = pmap_getport(&myaddress, cur_service->rpcnum, vers->num,
																				cur_service->proto);
		if (rl_debug > 1)
			rl_note("++ pmap_getport(?, %d, %d, %d) for service %s returned %d",
												cur_service->rpcnum, vers->num, cur_service->proto,
												cur_service->name, port);
		if (result && port && result != port) {
			RL_PWARN("rpc service %s already registered on different ports: %d and %d",
								cur_service->name, port, result);
			++cur_service->disabled;
		} else if (port) {
			result = port;
		}
	} while((vers = vers->next));

	return result;
}

static int register_rpc_service(int * rpc_registered,
																const struct service * const cur_service,
																const in_port_t rpc_port)
{
	if (*rpc_registered)
		return 1;

	const struct numlist *vers = cur_service->rpcvers;

	do {
		if (rl_debug > 1)
			rl_note("++ calling pmap_set(%d, %d, %d, %d) for service %s",
							cur_service->rpcnum, vers->num, cur_service->proto, rpc_port,
							cur_service->name);

		if(pmap_set(cur_service->rpcnum, vers->num, cur_service->proto, rpc_port))
			++*rpc_registered;
		else
			RL_PWARN(_("pmap_set(%d, %d, %d, %d) failed for service %s"),
				cur_service->rpcnum, vers->num, cur_service->proto, rpc_port,
				cur_service->name);
		} while((vers = vers->next));

		if (*rpc_registered) {
			struct rl_cleanup *p = (struct rl_cleanup *)malloc(sizeof(struct rl_cleanup));
			if (!p)
				rl_fatal(EX_SOFTWARE, _("ABORT - Can't allocate memory"));
			p->next = rl_cleanups;
			p->data =	(struct rlc_unrpc *)malloc(sizeof(struct rlc_unrpc));
			if (!p->data)
				rl_fatal(EX_SOFTWARE, _("ABORT - Can't allocate memory"));
			p->type = RLC_UNRPC;
			((struct rlc_unrpc *)p->data)->vers = NULL;
			numlist_copy(&(((struct rlc_unrpc *)p->data)->vers), cur_service->rpcvers);
			((struct rlc_unrpc *)p->data)->prog =	cur_service->rpcnum;
			rl_cleanups = p;
		}
		else if (rl_debug > 1)
			rl_note("++pmap_set() failed for all versions of service %s", cur_service->name);
		return *rpc_registered;
}

static int bind_ports() {
	int fd;
	long opt = 1;
	struct stringlist *portp;
	struct stringlist *ifp;
#ifdef HAVE_GETADDRINFO
	struct addrinfo hints;
	struct addrinfo *results = NULL, *ai;
	int ret;
#else
	void *addrbuf;
	int portnum;
	char *ctmp;
#endif
	const char *port, *addr;
	const char *lasterror;
	const char *errfunc = NULL;
	int succeeded;
	fd_set fds;
	int n_fds;

	int family, socktype, protocol;
	socklen_t saddrlen;
	struct sockaddr *saddr = NULL;
	int rpc_registered = 0;
	in_port_t rpc_port = get_rpc_port(current_service);

	if (current_service->disabled)
		return 0;

	FD_ZERO(&fds);
	n_fds = 0;
	ifp = current_service->interface;
	do {
		addr = ifp ? ifp->str : NULL;
		portp = current_service->port;
		do {
			lasterror = NULL;
			succeeded = 0;

			port = portp ? portp->str : !current_service->rpcnum ? current_service->name : "0";
#ifdef HAVE_GETADDRINFO
			memset(&hints, 0, sizeof(hints));
			hints.ai_flags = AI_PASSIVE;
			hints.ai_family = current_service->family;
			hints.ai_socktype = current_service->socktype;
			hints.ai_protocol = current_service->proto;
			if(results)
				freeaddrinfo(results);
			results = NULL;
			if((ret = getaddrinfo(addr, port, &hints, &results))) {
#ifdef HAVE_GAI_STRERROR
				RL_PWARN(_("getaddrinfo(%s, %s) failed: %s"), addr, port,
								gai_strerror(ret));
#else
				RL_PWARN(_("getaddrinfo(%s, %s) failed: %s"), addr, port,
								_("for reasons unknown") );
#endif
				continue;
			}
			ai = results;
			do {
				family = ai->ai_family;
				socktype = ai->ai_socktype;
				protocol = ai->ai_protocol;
				saddr = ai->ai_addr;
				saddrlen = ai->ai_addrlen;
#else
				portnum = strtoul(port, &ctmp, 10);
				if(*ctmp) {
					portnum = getservport(port, current_service->protoname);
					if(portnum == -1) {
						RL_PWARN(_("Failed to resolve %s, protocol %s"),
										current_service->proto, port);
						continue;
					}
				}
				family = current_service->family;
				socktype = current_service->socktype;
				protocol = current_service->proto;
				if(saddr) {
					free(saddr);
					saddr = NULL;
				}
				switch(family) {
					struct sockaddr_in *sin;
#ifdef HAVE_SOCKADDR_IN6
					struct sockaddr_in6 *sin6;
#endif

					case PF_INET:
						saddrlen = sizeof(struct sockaddr_in);
						sin = (struct sockaddr_in *)malloc(saddrlen);
						if (!sin)
							rl_fatal(EX_SOFTWARE, _("ABORT - Can't allocate memory"));
						addrbuf = &sin->sin_addr.s_addr;
						sin->sin_family = current_service->family;
						sin->sin_port = htons(portnum);
						sin->sin_addr.s_addr = INADDR_ANY;
						saddr = (struct sockaddr *)sin;
						break;
#ifdef HAVE_SOCKADDR_IN6
					case PF_INET6:
						saddrlen = sizeof(struct sockaddr_in6);
						sin6 = (struct sockaddr_in6 *)malloc(saddrlen);
						if (!sin6)
							rl_fatal(EX_SOFTWARE, _("ABORT - Can't allocate memory"));
						addrbuf = &sin6->sin_addr.s_addr;
						sin6->sin6_family = current_service->family;
						sin6->sin6_port = htons(portnum);
						sin6->sin6_addr = IN6ADDR_ANY_INIT;
						saddr = (struct sockaddr *)sin6;
						break;
#endif
					default:
						RL_PFATAL(EX_SOFTWARE, _("funky family in service"));
				}
				if(addr) {
					if(
#ifdef HAVE_INET_PTON
						 inet_pton(family, addr, addrbuf)
#else
																/* this cast is a pain */
						 (*(unsigned int *)addrbuf = inet_addr(addr)) == -1
#endif
						 ) {
						RL_PWARN(_("bad address %s in service %s"), addr,
										current_service->name);
						free(saddr);
						saddr = NULL;
						continue;
					}
				}
#endif
				if((fd = socket(family, socktype, protocol)) < 0) {
					lasterror = strerror(errno);
					errfunc = "socket()";
					goto out;
				}
				if(setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(opt))) {
					RL_PWARN(_("setsockopt(%d, SOL_SOCKET, SO_REUSEADDR, 1) failed for service %s (%s)"),
									fd, current_service->name, strerror(errno));
				}
#ifdef HAVE_NET_BPF_H
				if(current_service->filter) {
					struct bpf_program bp;

					bp.bf_len = current_service->filterlen / sizeof(struct bpf_insn);
					bp.bf_insns = current_service->filter;
					if(setsockopt(fd, SOL_SOCKET, SO_ATTACH_FILTER, &bp, sizeof(bp))) {
						lasterror = strerror(errno);
						close(fd);
						errfunc = "setsockopt(..., SO_ATTACH_FILTER)";
						goto out;
					}
				}
#endif
				/* For rpc service bind to the same port as it was already registered */
				if(current_service->rpcnum && rpc_port) {
					/* Note: this should be either sockaddr_in or sockaddr_in6, but fortunatelly
							the port is at the same place in both structures. */
					((struct sockaddr_in *)saddr)->sin_port = htons(rpc_port);
				}

				if(bind(fd, saddr, saddrlen) < 0) {
					lasterror = strerror(errno);
					close(fd);
					errfunc = "bind()";
					goto out;
				}

				if(current_service->rpcnum) {

					if (!rpc_port) {
						if (getsockname(fd, saddr, &saddrlen) == -1) {
							lasterror = strerror(errno);
							close(fd);
							errfunc = "getsockname()";
							goto out;
						}
						/* Note: this should be either sockaddr_in or sockaddr_in6, but fortunatelly
								the port is at the same place in both structures. */
						rpc_port = ntohs(((struct sockaddr_in *)saddr)->sin_port);
						if (!rpc_port) { /* shouldn't happen */
								lasterror = "returned port is 0";
								close(fd);
								errfunc = "getsockname()";
								goto out;
						}
					}

					if(!register_rpc_service(&rpc_registered, current_service, rpc_port)) {
						close(fd);
						goto out_all_loops;
					}
				}
				FD_SET(fd, &fds);
				if(socktype == SOCK_STREAM) {
					if(listen(fd, current_service->backlog)) {
						lasterror = strerror(errno);
						close(fd);
						errfunc = "listen(fd)";
						goto out;
					}
				}
				if(fcntl(fd, F_SETFD, 1)) {
					lasterror = strerror(errno);
					errfunc = "fcntl(fd, F_SETFD, 1)";
					close(fd);
					goto out;
				}
				if(fcntl(fd, F_SETFL, O_NDELAY)) {
					lasterror = strerror(errno);
					close(fd);
					errfunc = "fcntl(fd, F_SETFL, O_NDELAY)";
					goto out;
				}
				n_fds++;
				succeeded++;
			out:
#ifdef HAVE_GETADDRINFO
				continue;
			} while((ai = ai->ai_next));
#endif
			if(!succeeded && lasterror)
				RL_PWARN(_("%s failed for service %s: %s"),
								errfunc, current_service->name, lasterror);
		} while(portp && (portp = portp->next));
	} while(ifp && (ifp = ifp->next));
out_all_loops:
	stringlist_free(current_service->port);
	current_service->port = NULL;
	stringlist_free(current_service->interface);
	current_service->interface = NULL;
	numlist_free(current_service->rpcvers);
	current_service->rpcvers = NULL;
#ifdef HAVE_GETADDRINFO
	if(results) {
		freeaddrinfo(results);
		results = NULL;
	}
#else
	if(saddr) {
		free(saddr);
		saddr = NULL;
	}
#endif
	if (!n_fds)
		current_service->disabled++;
	return fdsettab_add(&fds);
}

static int add_user_group(const struct service* s, struct opmetalist * l)
{
	struct opmeta *o = NULL;
	if (has_flag(s, FLAG_USER))
	{
		o = opmeta_make(2, OP_SUID, 666);
		opmeta_fixup(o, 1, ofp_setuid);
		if(opmetalist_add(l, o)) {
				RL_PWARN(_("opcode resolving problem"));
				return 0;
		}
	}

	if (has_flag(s, FLAG_USER) || (has_flag(s, FLAG_GROUP)))
	{
				o = opmeta_make(2, OP_SGID, 666);
				opmeta_fixup(o, 1, ofp_setgid);
				if(opmetalist_add(l, o)) {
					RL_PWARN(_("opcode resolving problem"));
				  return 0;
				}
	}

	if (has_flag(s, FLAG_USER) && has_flag(s, FLAG_INITGROUPS))
	{
			o = opmeta_make(3, OP_INITGR, 666, 666);
			opmeta_fixup(o, 1, ofp_iuser);
			opmeta_fixup(o, 2, ofp_supgid);
			if(opmetalist_add(l, o)) {
				RL_PWARN(_("opcode resolving problem"));
			 return 0;
		}
	}
	return 1;
}

static void service_free(struct service *s) {
	if(s->name) {
		free(s->name);
		s->name = NULL;
	}
	stringlist_free(s->port);
	s->port = NULL;
	stringlist_free(s->interface);
	s->interface = NULL;
	if(s->rpcname) {
		free(s->rpcname);
		s->rpcname = NULL;
	}
	if(s->rpcvers) {
		numlist_free(s->rpcvers);
		s->rpcvers = NULL;
	}
#ifdef HAVE_CAPABILITIES
	if(s->caps) {
		cap_free(&s->caps);
		s->caps = NULL;
	}
#endif
#ifdef HAVE_NET_BPF_H
	if(s->filter) {
		free(s->filter);
		s->filter = NULL;
		s->filterlen = 0;
	}
#endif
}

static void service_copy(struct service *to, struct service *from) {
	memcpy(to, from, sizeof(*to));
	to->name = NULL;
	to->port = NULL;
	to->interface = NULL;
	stringlist_copy(&to->port, from->port);
	stringlist_copy(&to->interface, from->interface);
	to->rpcname = from->rpcname ? strdup(from->rpcname) : NULL;
	to->rpcvers = NULL;
	numlist_copy(&to->rpcvers, from->rpcvers);
#ifdef HAVE_LIBCAP
	to->caps = from->caps ? cap_dup(from->caps) : NULL;
#endif
#ifdef HAVE_NET_BPF_H
	if(from->filter) {
		to->filter = malloc(from->filterlen);
		if (!to->filter)
			rl_fatal(EX_SOFTWARE, _("ABORT - Can't allocate memory"));
		memcpy(to->filter, from->filter, from->filterlen);
	}
#endif
}

static struct logdata *logdata_get(char *name) {
	struct logdata *ptr = logdatas;

	if(!ptr)
		return NULL;
	do {
		if(!strcmp(name, ptr->name))
			return ptr;
	} while((ptr = ptr->next));
	return NULL;
}

static void logdatas_free(void) {
	struct logdata *p, *q;

	p = logdatas;
	while(p) {
		q = p->next;
		if(p->name)
			free(p->name);
		if(p->path)
			free(p->path);
		free(p);
		p = q;
	}
	logdatas = NULL;
}

static struct logdata *logdata_new() {
	struct logdata *ptr = (struct logdata *)malloc(sizeof(*ptr));

	if (!ptr)
		rl_fatal(EX_SOFTWARE, _("ABORT - Can't allocate memory"));

	memset(ptr, 0, sizeof(*ptr));
	ptr->index = -1;
	ptr->mode =
#ifdef S_IRUSR
		S_IRUSR|S_IWUSR|S_IRGRP
#else
		0640
#endif
		;
	ptr->uid = -1;
	ptr->gid = -1;
	return ptr;
}

extern void parse(void);
void parse(void) {

	numlist = NULL;
	userdata = NULL;
	newuserdata(&userdata);
	pidtab_fixup();
	all_unhook();
	logtabs_free();
	argvtabs_free();
	rlimittabs_free();
	services_free();
	stringtabs_free();
	buftabs_free();
	oplisttabs_free();
#ifdef HAVE_CAPABILITIES
	captabs_free();
#endif
	semaphores_free();
	fdsettabs_free();
	if(strcmp(rl_config, "-") || !rl_debug) {
		if(!(yyin = fopen(rl_config, "r"))) {
			RL_PFATAL(EX_NOINPUT, _("fopen(%s) failed, aborting"), rl_config);
		} else {
			curfile_name = rl_config;
			curfile_line = 1;
		}
	}

	logcur = logdata_new();
	current_service = service_new();
	defaults = service_new();
#ifdef HAVE_GETADDRINFO
	defaults->family = PF_UNSPEC;
#else
	defaults->family = PF_INET;
#endif
	defaults->socktype = SOCK_STREAM;
	defaults->protoname = "tcp";
	defaults->proto = IPPROTO_TCP;
	defaults->backlog = 5;
	defaults->limit = 40;
	defaults->r.rlim_cur = RLIM_INFINITY;
	defaults->r.rlim_max = RLIM_INFINITY;
	defaults->wait = 0;


	defaults->opfixups[ofp_exec] = -1;

	defaults->opfixups[ofp_iname] = -1;
	defaults->opfixups[ofp_parent] = -1;
	defaults->opfixups[ofp_iuser]  = -1;
	defaults->sflags =  0;
	defaults->opfixups[ofp_supgid] = -1;
	defaults->opfixups[ofp_setgid] = -1;
	defaults->opfixups[ofp_setuid] = -1;
	service_copy(current_service, defaults);
	 opml_defaults = opmetalist_new();
	yyparse();
	freebufs();
	service_free(defaults);
	free(defaults);
	defaults = NULL;
	logdatas_free();
	free(logcur);
	logcur = NULL;
	service_free(current_service);
	free(current_service);
	current_service = NULL;
	for(curfile = 0; curfile < numfiles; curfile++) {
		free(files[curfile]);
		files[curfile] = NULL;
	}
	free(files);
	files = NULL;
	clearuserdata(&userdata);
	free(userdata);
}

static void pidtab_fixup() {
	struct pidtab *p;
	int i;

	for(i = 0; i < 8; i++) {
		p = pidtabs[i].next;
		while(p) {
			if(p->inst)
				inst_free(p->inst);
			p->inst = NULL;
			p = p->next;
		}
	}
}

#ifndef HAVE_GETADDRINFO
static int getservport(char *str, char *proto) {
	struct servent *foo;
	int ret = -1;

	foo = getservbyname(str, proto);
	if(foo)
		ret = ntohs(foo->s_port);
	endservent();
	return ret;
}
#endif

static void add_directory(char *dir, char *match, char *ignore) {
	DIR *d;
	struct dirent *de;
	regex_t rmatch, rignore;
	char err[128];
	int e;
	struct stat st;
	char *file;

	if(match)
		if((e = regcomp(&rmatch, match, REG_EXTENDED|REG_NOSUB))) {
			regerror(e, &rmatch, err, 127);
			RL_PWARN(_("regexp compile failed for directory %s: %s"),
							dir, err);
		}
	if(ignore)
		if((e = regcomp(&rignore, ignore, REG_EXTENDED|REG_NOSUB))) {
			regerror(e, &rignore, err, 127);
			RL_PWARN(_("regexp compile failed for directory %s: %s"),
							dir, err);
		}

	if((d = opendir(dir))) {
		while((de = readdir(d))) {
			if(match)
				if(regexec(&rmatch, de->d_name, 0, NULL, 0))
					continue;
			if(ignore)
				if(!regexec(&rignore, de->d_name, 0, NULL, 0))
					continue;
			if(de->d_name[0] != '.') {
				file = malloc(strlen(dir) + NAMLEN(de) + 2);
				if (!file)
					rl_fatal(EX_SOFTWARE, _("ABORT - Can't allocate memory"));
				file[0] = '\0';
				strcat(file, dir);
				strcat(file, "/");
				strcat(file, de->d_name);
				if(stat(file, &st) || S_ISDIR(st.st_mode)) {
					RL_PWARN(_("file %s does not exists or"
						 " is a directory"), file);
					free(file);
					continue;
				}
				files = (char **)realloc(files, ++numfiles * sizeof(char *));
				if (!files)
					rl_fatal(EX_SOFTWARE, _("ABORT - Can't allocate memory"));
				files[numfiles - 1] = file;
			}
		}
	} else {
		RL_PFATAL(EX_NOINPUT, _("Directory %s open failed (%s)"), dir,
			strerror(errno));
	}
	closedir(d);
	free(dir);
	if(match) {
		free(match);
		regfree(&rmatch);
	}
	if(ignore) {
		free(ignore);
		regfree(&rignore);
	}
}

int chargen_buffer() {
	static int cb = -1;
	const char * const b = "01234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n";

	if(cb == -1)
		cb = buftab_addbuf(b, strlen(b));
	return cb;
}


/* vim: set ts=2 sts=2 noet: */
