% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{network.initialize}
\alias{network.initialize}
\title{Initialize a Network Class Object}
\usage{
network.initialize(n, directed = TRUE, hyper = FALSE, loops = FALSE,
  multiple = FALSE, bipartite = FALSE)
}
\arguments{
\item{n}{the number of vertices to initialize}

\item{directed}{logical; should edges be interpreted as directed?}

\item{hyper}{logical; are hyperedges allowed?}

\item{loops}{logical; should loops be allowed?}

\item{multiple}{logical; are multiplex edges allowed?}

\item{bipartite}{count; should the network be interpreted as bipartite? If
present (i.e., non-NULL) it is the count of the number of actors in the
first mode of the bipartite network. In this case, the overall number of
vertices is equal to the number of 'actors' (first mode) plus the number of
`events' (second mode), with the vertex.ids of all actors preceeding all
events. The edges are then interpreted as nondirected.}
}
\value{
An object of class \code{network}
}
\description{
Create and initialize a \code{network} object with \code{n} vertices.
}
\details{
Generally, \code{network.initialize} is called by other constructor
functions as part of the process of creating a network.
}
\examples{

g<-network.initialize(5)  #Create an empty graph on 5 vertices

}
\references{
Butts, C. T.  (2008).  \dQuote{network: a Package for Managing
Relational Data in R.} \emph{Journal of Statistical Software}, 24(2).
\url{https://www.jstatsoft.org/v24/i02/}
}
\seealso{
\code{\link{network}}, \code{\link{as.network.matrix}}
}
\author{
Carter T. Butts \email{buttsc@uci.edu}
}
\keyword{classes}
\keyword{graphs}
