% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strtrim.R
\name{strtrim_ctl}
\alias{strtrim_ctl}
\alias{strtrim2_ctl}
\alias{strtrim_sgr}
\alias{strtrim2_sgr}
\title{ANSI Control Sequence Aware Version of strtrim}
\usage{
strtrim_ctl(x, width, warn = getOption("fansi.warn"), ctl = "all")

strtrim2_ctl(
  x,
  width,
  warn = getOption("fansi.warn"),
  tabs.as.spaces = getOption("fansi.tabs.as.spaces"),
  tab.stops = getOption("fansi.tab.stops"),
  ctl = "all"
)

strtrim_sgr(x, width, warn = getOption("fansi.warn"))

strtrim2_sgr(
  x,
  width,
  warn = getOption("fansi.warn"),
  tabs.as.spaces = getOption("fansi.tabs.as.spaces"),
  tab.stops = getOption("fansi.tab.stops")
)
}
\arguments{
\item{x}{a character vector, or an object which can be coerced to a
    character vector by \code{\link[base]{as.character}}.}

\item{width}{Positive integer values: recycled to the length of \code{x}.}

\item{warn}{TRUE (default) or FALSE, whether to warn when potentially
problematic \emph{Control Sequences} are encountered.  These could cause the
assumptions \code{fansi} makes about how strings are rendered on your display
to be incorrect, for example by moving the cursor (see \link{fansi}).}

\item{ctl}{character, which \emph{Control Sequences} should be treated
specially. See the "_ctl vs. _sgr" section for details.
\itemize{
\item "nl": newlines.
\item "c0": all other "C0" control characters (i.e. 0x01-0x1f, 0x7F), except
for newlines and the actual ESC (0x1B) character.
\item "sgr": ANSI CSI SGR sequences.
\item "csi": all non-SGR ANSI CSI sequences.
\item "esc": all other escape sequences.
\item "all": all of the above, except when used in combination with any of the
above, in which case it means "all but".
}}

\item{tabs.as.spaces}{FALSE (default) or TRUE, whether to convert tabs to
spaces.  This can only be set to TRUE if \code{strip.spaces} is FALSE.}

\item{tab.stops}{integer(1:n) indicating position of tab stops to use
when converting tabs to spaces.  If there are more tabs in a line than
defined tab stops the last tab stop is re-used.  For the purposes of
applying tab stops, each input line is considered a line and the character
count begins from the beginning of the input line.}
}
\description{
One difference with \link[base:strtrim]{base::strtrim} is that all C0 control characters such as
newlines, carriage returns, etc., are treated as zero width.
}
\details{
\code{strtrim2_ctl} adds the option of converting tabs to spaces before trimming.
This is the only difference between \code{strtrim_ctl} and \code{strtrim2_ctl}.
}
\note{
Non-ASCII strings are converted to and returned in UTF-8 encoding.
Width calculations will not work correctly with R < 3.2.2.
}
\section{_ctl vs. _sgr}{


The \verb{*_ctl} versions of the functions treat all \emph{Control Sequences} specially
by default.  Special treatment is context dependent, and may include
detecting them and/or computing their display/character width as zero.  For
the SGR subset of the ANSI CSI sequences, \code{fansi} will also parse, interpret,
and reapply the text styles they encode if needed.  You can modify whether a
\emph{Control Sequence} is treated specially with the \code{ctl} parameter.  You can
exclude a type of \emph{Control Sequence} from special treatment by combining
"all" with that type of sequence (e.g. \code{ctl=c("all", "nl")} for special
treatment of all \emph{Control Sequences} \strong{but} newlines).  The \verb{*_sgr} versions
only treat ANSI CSI SGR sequences specially, and are equivalent to the
\verb{*_ctl} versions with the \code{ctl} parameter set to "sgr".
}

\examples{
strtrim_ctl("\033[42mHello world\033[m", 6)
}
\seealso{
\link{fansi} for details on how \emph{Control Sequences} are
interpreted, particularly if you are getting unexpected results.
\link{strwrap_ctl} is used internally by this function.
}
