% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/makeConsensusAnnotations.R
\name{makeConsensusAnnotations}
\alias{makeConsensusAnnotations}
\title{makeConsensusAnnotations Makes a consensus annotation}
\usage{
makeConsensusAnnotations(ar, minGap = 1L, minWidth = 1000L, ...)
}
\arguments{
\item{ar}{GRanges of annotations to be collapsed.}

\item{minGap}{Minimun gap between overlapped annotations after truncated.
Default: 1L}

\item{minWidth}{Minimun width of consensus annotations. Default: 1000L}

\item{...}{Extra argument passed to mclapply.}
}
\value{
Returns GRanges object of annotations.
}
\description{
Makes a non-overlapping consensus annotation.  Gene annotations are often
overalpping due to #' multiple isoforms for a gene.
In consensus annotation, isoforms are first reduced so that only
redundant intervals are used to represent a genomic interval for a gene,
i.e., a gene id.
Remaining unresolved annotations are further reduced by truncating 3'
end of annotations.
}
\details{
Supports parallel processing using mclapply in the 'parallel' package.
To change the number of processors, use the argument 'mc.cores'.
}
\examples{
## Not run:
# library(TxDb.Hsapiens.UCSC.hg19.knownGene)
# txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
# tx <- transcripts(txdb, columns=c("gene_id", "tx_id", "tx_name"),
#                         filter=list(tx_chrom="chr7"))
# tx <- tx[grep("random", as.character(seqnames(tx)), invert=TRUE),]
# ca <- makeConsensusAnnotations(tx)
}
\author{
Minho Chae
}

