/*===================== begin_copyright_notice ==================================

Copyright (c) 2017 Intel Corporation

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


======================= end_copyright_notice ==================================*/

#ifndef __IA32E_COMMON_TRIG_DATA_CL__
#define __IA32E_COMMON_TRIG_DATA_CL__

#include  "../../Math/include/_svml_data_structures.cl"

// Common function to sin, cos, and sincos
int reduce_pio2d (double x, __private double *d);

// Table common to sin, cos, tan, and sincos
__constant _iml_dp_union_t _vmlReductionTab[70] = {
    {{0x00000000u, 0x00000000u}}, {{0x00000000u, 0xbff00000u}}, {{0x00000000u, 0x3ff00000u}},
    {{0x00000000u, 0xbff00000u}}, {{0x00000000u, 0x41980000u}}, {{0x00000000u, 0x41A00000u}},
    {{0x40000000u, 0x3fe921fbu}}, {{0x18469899u, 0x3e64442du}}, {{0x6dc9c883u, 0x3ff45f30u}},
    {{0x00000000u, 0x40b00000u}}, {{0x54000000u, 0x3fe921fbu}}, {{0x12000000u, 0x3e010b46u}},
    {{0x3c000000u, 0xbc267673u}}, {{0x839a2520u, 0x3a61701bu}}, {{0x00000000u, 0x3fe921fau}},
    {{0x00000000u, 0x3ea54443u}}, {{0x00000000u, 0xbd373dcau}}, {{0x00000000u, 0xbbf3b39au}},
    {{0xe0e68948u, 0x3a845c06u}}, {{0xffffffffu, 0xffffffffu}}, {{0x00000000u, 0x00000000u}},
    {{0x60000000u, 0x4c745f30u}}, {{0x00000000u, 0x4aeb9391u}}, {{0x20000000u, 0x494529fcu}},
    {{0xc0000000u, 0x47ad5f47u}}, {{0x00000000u, 0x4624d377u}}, {{0x80000000u, 0x447b6c52u}},
    {{0x20000000u, 0x430993c4u}}, {{0xe0000000u, 0x4189041fu}}, {{0xe0000000u, 0x3fe458eau}},
    {{0x50000000u, 0x3e67aef1u}}, {{0x30000000u, 0x3cd0db92u}}, {{0x80000000u, 0x3b3c7484u}},
    {{0x00000000u, 0x39bba5c0u}}, {{0xa0000000u, 0x382924bbu}}, {{0x90000000u, 0x36904e8cu}},
    {{0x00000000u, 0x34ccfe1du}}, {{0x20000000u, 0x337d6396u}}, {{0x60000000u, 0x31d4d39fu}},
    {{0xf0000000u, 0x3054411au}}, {{0x40000000u, 0x2ec52ebbu}}, {{0x60000000u, 0x2d2213a6u}},
    {{0xd0000000u, 0x2ba1c09au}}, {{0x00000000u, 0x29e7df90u}}, {{0x60000000u, 0x2883991du}},
    {{0x80000000u, 0x26dcc1a9u}}, {{0x40000000u, 0x255cfa4eu}}, {{0x80000000u, 0x23a17e2eu}},
    {{0x30000000u, 0x224df928u}}, {{0x20000000u, 0x20b63ff1u}}, {{0x10000000u, 0x1f2fff78u}},
    {{0xe0000000u, 0x1d8980feu}}, {{0xb0000000u, 0x1c02f118u}}, {{0x40000000u, 0x1a66829bu}},
    {{0x40000000u, 0x18cf6d36u}}, {{0xe0000000u, 0x175f6793u}}, {{0x80000000u, 0x15b6136eu}},
    {{0xc0000000u, 0x143e8c7eu}}, {{0xa0000000u, 0x12aa797fu}}, {{0x30000000u, 0x11116ba9u}},
    {{0xb0000000u, 0x0f8bac7eu}}, {{0x60000000u, 0x0dfcbe2fu}}, {{0xe0000000u, 0x0c5e839cu}},
    {{0x40000000u, 0x0adbc529u}}, {{0xf0000000u, 0x0942ea6bu}}, {{0x30000000u, 0x07b6bf62u}},
    {{0x20000000u, 0x062e3574u}}, {{0x00000000u, 0x046580ccu}}, {{0xc0000000u, 0x02e1bf1eu}},
    {{0x20000000u, 0x016aeafcu}}
};

// Table common to sin, cos, tan, and sincos
typedef struct
{
  VUINT32 _dPtable[2048][3][2];
} dReduction_Table_Type;

__constant dReduction_Table_Type __ocl_svml_dsincostan_reduction_data = {
  {
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000001uLL) >> 0),
     (VUINT32) ((0x0000000000000001uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000002uLL) >> 0),
     (VUINT32) ((0x0000000000000002uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000005uLL) >> 0),
     (VUINT32) ((0x0000000000000005uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000000000AuLL) >> 0),
     (VUINT32) ((0x000000000000000AuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000014uLL) >> 0),
     (VUINT32) ((0x0000000000000014uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000028uLL) >> 0),
     (VUINT32) ((0x0000000000000028uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000051uLL) >> 0),
     (VUINT32) ((0x0000000000000051uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000000000A2uLL) >> 0),
     (VUINT32) ((0x00000000000000A2uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000145uLL) >> 0),
     (VUINT32) ((0x0000000000000145uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000000028BuLL) >> 0),
     (VUINT32) ((0x000000000000028BuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000517uLL) >> 0),
     (VUINT32) ((0x0000000000000517uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000A2FuLL) >> 0),
     (VUINT32) ((0x0000000000000A2FuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000000145FuLL) >> 0),
     (VUINT32) ((0x000000000000145FuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000000028BEuLL) >> 0),
     (VUINT32) ((0x00000000000028BEuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000000517CuLL) >> 0),
     (VUINT32) ((0x000000000000517CuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000000A2F9uLL) >> 0),
     (VUINT32) ((0x000000000000A2F9uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000000145F3uLL) >> 0),
     (VUINT32) ((0x00000000000145F3uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000028BE6uLL) >> 0),
     (VUINT32) ((0x0000000000028BE6uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000000517CCuLL) >> 0),
     (VUINT32) ((0x00000000000517CCuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000000A2F98uLL) >> 0),
     (VUINT32) ((0x00000000000A2F98uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000145F30uLL) >> 0),
     (VUINT32) ((0x0000000000145F30uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000028BE60uLL) >> 0),
     (VUINT32) ((0x000000000028BE60uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000517CC1uLL) >> 0),
     (VUINT32) ((0x0000000000517CC1uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000A2F983uLL) >> 0),
     (VUINT32) ((0x0000000000A2F983uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000145F306uLL) >> 0),
     (VUINT32) ((0x000000000145F306uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000028BE60DuLL) >> 0),
     (VUINT32) ((0x00000000028BE60DuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000517CC1BuLL) >> 0),
     (VUINT32) ((0x000000000517CC1BuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000A2F9836uLL) >> 0),
     (VUINT32) ((0x000000000A2F9836uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000145F306DuLL) >> 0),
     (VUINT32) ((0x00000000145F306DuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000028BE60DBuLL) >> 0),
     (VUINT32) ((0x0000000028BE60DBuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000517CC1B7uLL) >> 0),
     (VUINT32) ((0x00000000517CC1B7uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000A2F9836EuLL) >> 0),
     (VUINT32) ((0x00000000A2F9836EuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000145F306DCuLL) >> 0),
     (VUINT32) ((0x0000000145F306DCuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000028BE60DB9uLL) >> 0),
     (VUINT32) ((0x000000028BE60DB9uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000517CC1B72uLL) >> 0),
     (VUINT32) ((0x0000000517CC1B72uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000A2F9836E4uLL) >> 0),
     (VUINT32) ((0x0000000A2F9836E4uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000145F306DC9uLL) >> 0),
     (VUINT32) ((0x000000145F306DC9uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000028BE60DB93uLL) >> 0),
     (VUINT32) ((0x00000028BE60DB93uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000517CC1B727uLL) >> 0),
     (VUINT32) ((0x000000517CC1B727uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000A2F9836E4EuLL) >> 0),
     (VUINT32) ((0x000000A2F9836E4EuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000145F306DC9CuLL) >> 0),
     (VUINT32) ((0x00000145F306DC9CuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000028BE60DB939uLL) >> 0),
     (VUINT32) ((0x0000028BE60DB939uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000517CC1B7272uLL) >> 0),
     (VUINT32) ((0x00000517CC1B7272uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000A2F9836E4E4uLL) >> 0),
     (VUINT32) ((0x00000A2F9836E4E4uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000145F306DC9C8uLL) >> 0),
     (VUINT32) ((0x0000145F306DC9C8uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000028BE60DB9391uLL) >> 0),
     (VUINT32) ((0x000028BE60DB9391uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000517CC1B72722uLL) >> 0),
     (VUINT32) ((0x0000517CC1B72722uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000A2F9836E4E44uLL) >> 0),
     (VUINT32) ((0x0000A2F9836E4E44uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000145F306DC9C88uLL) >> 0),
     (VUINT32) ((0x000145F306DC9C88uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00028BE60DB93910uLL) >> 0),
     (VUINT32) ((0x00028BE60DB93910uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000517CC1B727220uLL) >> 0),
     (VUINT32) ((0x000517CC1B727220uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000A2F9836E4E441uLL) >> 0),
     (VUINT32) ((0x000A2F9836E4E441uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00145F306DC9C882uLL) >> 0),
     (VUINT32) ((0x00145F306DC9C882uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0028BE60DB939105uLL) >> 0),
     (VUINT32) ((0x0028BE60DB939105uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00517CC1B727220AuLL) >> 0),
     (VUINT32) ((0x00517CC1B727220AuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00A2F9836E4E4415uLL) >> 0),
     (VUINT32) ((0x00A2F9836E4E4415uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0145F306DC9C882AuLL) >> 0),
     (VUINT32) ((0x0145F306DC9C882AuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x028BE60DB9391054uLL) >> 0),
     (VUINT32) ((0x028BE60DB9391054uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0517CC1B727220A9uLL) >> 0),
     (VUINT32) ((0x0517CC1B727220A9uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0A2F9836E4E44152uLL) >> 0),
     (VUINT32) ((0x0A2F9836E4E44152uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x145F306DC9C882A5uLL) >> 0),
     (VUINT32) ((0x145F306DC9C882A5uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x28BE60DB9391054AuLL) >> 0),
     (VUINT32) ((0x28BE60DB9391054AuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x517CC1B727220A94uLL) >> 0),
     (VUINT32) ((0x517CC1B727220A94uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xA2F9836E4E441529uLL) >> 0),
     (VUINT32) ((0xA2F9836E4E441529uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000001uLL) >> 0),
     (VUINT32) ((0x0000000000000001uLL) >> 32)},
    {(VUINT32) ((0x45F306DC9C882A53uLL) >> 0),
     (VUINT32) ((0x45F306DC9C882A53uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000002uLL) >> 0),
     (VUINT32) ((0x0000000000000002uLL) >> 32)},
    {(VUINT32) ((0x8BE60DB9391054A7uLL) >> 0),
     (VUINT32) ((0x8BE60DB9391054A7uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000005uLL) >> 0),
     (VUINT32) ((0x0000000000000005uLL) >> 32)},
    {(VUINT32) ((0x17CC1B727220A94FuLL) >> 0),
     (VUINT32) ((0x17CC1B727220A94FuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000000000AuLL) >> 0),
     (VUINT32) ((0x000000000000000AuLL) >> 32)},
    {(VUINT32) ((0x2F9836E4E441529FuLL) >> 0),
     (VUINT32) ((0x2F9836E4E441529FuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000014uLL) >> 0),
     (VUINT32) ((0x0000000000000014uLL) >> 32)},
    {(VUINT32) ((0x5F306DC9C882A53FuLL) >> 0),
     (VUINT32) ((0x5F306DC9C882A53FuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000028uLL) >> 0),
     (VUINT32) ((0x0000000000000028uLL) >> 32)},
    {(VUINT32) ((0xBE60DB9391054A7FuLL) >> 0),
     (VUINT32) ((0xBE60DB9391054A7FuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000051uLL) >> 0),
     (VUINT32) ((0x0000000000000051uLL) >> 32)},
    {(VUINT32) ((0x7CC1B727220A94FEuLL) >> 0),
     (VUINT32) ((0x7CC1B727220A94FEuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000000000A2uLL) >> 0),
     (VUINT32) ((0x00000000000000A2uLL) >> 32)},
    {(VUINT32) ((0xF9836E4E441529FCuLL) >> 0),
     (VUINT32) ((0xF9836E4E441529FCuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000145uLL) >> 0),
     (VUINT32) ((0x0000000000000145uLL) >> 32)},
    {(VUINT32) ((0xF306DC9C882A53F8uLL) >> 0),
     (VUINT32) ((0xF306DC9C882A53F8uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000000028BuLL) >> 0),
     (VUINT32) ((0x000000000000028BuLL) >> 32)},
    {(VUINT32) ((0xE60DB9391054A7F0uLL) >> 0),
     (VUINT32) ((0xE60DB9391054A7F0uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000517uLL) >> 0),
     (VUINT32) ((0x0000000000000517uLL) >> 32)},
    {(VUINT32) ((0xCC1B727220A94FE1uLL) >> 0),
     (VUINT32) ((0xCC1B727220A94FE1uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000A2FuLL) >> 0),
     (VUINT32) ((0x0000000000000A2FuLL) >> 32)},
    {(VUINT32) ((0x9836E4E441529FC2uLL) >> 0),
     (VUINT32) ((0x9836E4E441529FC2uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000000145FuLL) >> 0),
     (VUINT32) ((0x000000000000145FuLL) >> 32)},
    {(VUINT32) ((0x306DC9C882A53F84uLL) >> 0),
     (VUINT32) ((0x306DC9C882A53F84uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000000028BEuLL) >> 0),
     (VUINT32) ((0x00000000000028BEuLL) >> 32)},
    {(VUINT32) ((0x60DB9391054A7F09uLL) >> 0),
     (VUINT32) ((0x60DB9391054A7F09uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000000517CuLL) >> 0),
     (VUINT32) ((0x000000000000517CuLL) >> 32)},
    {(VUINT32) ((0xC1B727220A94FE13uLL) >> 0),
     (VUINT32) ((0xC1B727220A94FE13uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000000A2F9uLL) >> 0),
     (VUINT32) ((0x000000000000A2F9uLL) >> 32)},
    {(VUINT32) ((0x836E4E441529FC27uLL) >> 0),
     (VUINT32) ((0x836E4E441529FC27uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000000145F3uLL) >> 0),
     (VUINT32) ((0x00000000000145F3uLL) >> 32)},
    {(VUINT32) ((0x06DC9C882A53F84EuLL) >> 0),
     (VUINT32) ((0x06DC9C882A53F84EuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000028BE6uLL) >> 0),
     (VUINT32) ((0x0000000000028BE6uLL) >> 32)},
    {(VUINT32) ((0x0DB9391054A7F09DuLL) >> 0),
     (VUINT32) ((0x0DB9391054A7F09DuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000000517CCuLL) >> 0),
     (VUINT32) ((0x00000000000517CCuLL) >> 32)},
    {(VUINT32) ((0x1B727220A94FE13AuLL) >> 0),
     (VUINT32) ((0x1B727220A94FE13AuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000000A2F98uLL) >> 0),
     (VUINT32) ((0x00000000000A2F98uLL) >> 32)},
    {(VUINT32) ((0x36E4E441529FC275uLL) >> 0),
     (VUINT32) ((0x36E4E441529FC275uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000145F30uLL) >> 0),
     (VUINT32) ((0x0000000000145F30uLL) >> 32)},
    {(VUINT32) ((0x6DC9C882A53F84EAuLL) >> 0),
     (VUINT32) ((0x6DC9C882A53F84EAuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000028BE60uLL) >> 0),
     (VUINT32) ((0x000000000028BE60uLL) >> 32)},
    {(VUINT32) ((0xDB9391054A7F09D5uLL) >> 0),
     (VUINT32) ((0xDB9391054A7F09D5uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000517CC1uLL) >> 0),
     (VUINT32) ((0x0000000000517CC1uLL) >> 32)},
    {(VUINT32) ((0xB727220A94FE13ABuLL) >> 0),
     (VUINT32) ((0xB727220A94FE13ABuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000A2F983uLL) >> 0),
     (VUINT32) ((0x0000000000A2F983uLL) >> 32)},
    {(VUINT32) ((0x6E4E441529FC2757uLL) >> 0),
     (VUINT32) ((0x6E4E441529FC2757uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000145F306uLL) >> 0),
     (VUINT32) ((0x000000000145F306uLL) >> 32)},
    {(VUINT32) ((0xDC9C882A53F84EAFuLL) >> 0),
     (VUINT32) ((0xDC9C882A53F84EAFuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000028BE60DuLL) >> 0),
     (VUINT32) ((0x00000000028BE60DuLL) >> 32)},
    {(VUINT32) ((0xB9391054A7F09D5FuLL) >> 0),
     (VUINT32) ((0xB9391054A7F09D5FuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000517CC1BuLL) >> 0),
     (VUINT32) ((0x000000000517CC1BuLL) >> 32)},
    {(VUINT32) ((0x727220A94FE13ABEuLL) >> 0),
     (VUINT32) ((0x727220A94FE13ABEuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000000A2F9836uLL) >> 0),
     (VUINT32) ((0x000000000A2F9836uLL) >> 32)},
    {(VUINT32) ((0xE4E441529FC2757DuLL) >> 0),
     (VUINT32) ((0xE4E441529FC2757DuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000145F306DuLL) >> 0),
     (VUINT32) ((0x00000000145F306DuLL) >> 32)},
    {(VUINT32) ((0xC9C882A53F84EAFAuLL) >> 0),
     (VUINT32) ((0xC9C882A53F84EAFAuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000028BE60DBuLL) >> 0),
     (VUINT32) ((0x0000000028BE60DBuLL) >> 32)},
    {(VUINT32) ((0x9391054A7F09D5F4uLL) >> 0),
     (VUINT32) ((0x9391054A7F09D5F4uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000517CC1B7uLL) >> 0),
     (VUINT32) ((0x00000000517CC1B7uLL) >> 32)},
    {(VUINT32) ((0x27220A94FE13ABE8uLL) >> 0),
     (VUINT32) ((0x27220A94FE13ABE8uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000000A2F9836EuLL) >> 0),
     (VUINT32) ((0x00000000A2F9836EuLL) >> 32)},
    {(VUINT32) ((0x4E441529FC2757D1uLL) >> 0),
     (VUINT32) ((0x4E441529FC2757D1uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000145F306DCuLL) >> 0),
     (VUINT32) ((0x0000000145F306DCuLL) >> 32)},
    {(VUINT32) ((0x9C882A53F84EAFA3uLL) >> 0),
     (VUINT32) ((0x9C882A53F84EAFA3uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000028BE60DB9uLL) >> 0),
     (VUINT32) ((0x000000028BE60DB9uLL) >> 32)},
    {(VUINT32) ((0x391054A7F09D5F47uLL) >> 0),
     (VUINT32) ((0x391054A7F09D5F47uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000517CC1B72uLL) >> 0),
     (VUINT32) ((0x0000000517CC1B72uLL) >> 32)},
    {(VUINT32) ((0x7220A94FE13ABE8FuLL) >> 0),
     (VUINT32) ((0x7220A94FE13ABE8FuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000A2F9836E4uLL) >> 0),
     (VUINT32) ((0x0000000A2F9836E4uLL) >> 32)},
    {(VUINT32) ((0xE441529FC2757D1FuLL) >> 0),
     (VUINT32) ((0xE441529FC2757D1FuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000145F306DC9uLL) >> 0),
     (VUINT32) ((0x000000145F306DC9uLL) >> 32)},
    {(VUINT32) ((0xC882A53F84EAFA3EuLL) >> 0),
     (VUINT32) ((0xC882A53F84EAFA3EuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000028BE60DB93uLL) >> 0),
     (VUINT32) ((0x00000028BE60DB93uLL) >> 32)},
    {(VUINT32) ((0x91054A7F09D5F47DuLL) >> 0),
     (VUINT32) ((0x91054A7F09D5F47DuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000517CC1B727uLL) >> 0),
     (VUINT32) ((0x000000517CC1B727uLL) >> 32)},
    {(VUINT32) ((0x220A94FE13ABE8FAuLL) >> 0),
     (VUINT32) ((0x220A94FE13ABE8FAuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000000A2F9836E4EuLL) >> 0),
     (VUINT32) ((0x000000A2F9836E4EuLL) >> 32)},
    {(VUINT32) ((0x441529FC2757D1F5uLL) >> 0),
     (VUINT32) ((0x441529FC2757D1F5uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000145F306DC9CuLL) >> 0),
     (VUINT32) ((0x00000145F306DC9CuLL) >> 32)},
    {(VUINT32) ((0x882A53F84EAFA3EAuLL) >> 0),
     (VUINT32) ((0x882A53F84EAFA3EAuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000028BE60DB939uLL) >> 0),
     (VUINT32) ((0x0000028BE60DB939uLL) >> 32)},
    {(VUINT32) ((0x1054A7F09D5F47D4uLL) >> 0),
     (VUINT32) ((0x1054A7F09D5F47D4uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000517CC1B7272uLL) >> 0),
     (VUINT32) ((0x00000517CC1B7272uLL) >> 32)},
    {(VUINT32) ((0x20A94FE13ABE8FA9uLL) >> 0),
     (VUINT32) ((0x20A94FE13ABE8FA9uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00000A2F9836E4E4uLL) >> 0),
     (VUINT32) ((0x00000A2F9836E4E4uLL) >> 32)},
    {(VUINT32) ((0x41529FC2757D1F53uLL) >> 0),
     (VUINT32) ((0x41529FC2757D1F53uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000145F306DC9C8uLL) >> 0),
     (VUINT32) ((0x0000145F306DC9C8uLL) >> 32)},
    {(VUINT32) ((0x82A53F84EAFA3EA6uLL) >> 0),
     (VUINT32) ((0x82A53F84EAFA3EA6uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000028BE60DB9391uLL) >> 0),
     (VUINT32) ((0x000028BE60DB9391uLL) >> 32)},
    {(VUINT32) ((0x054A7F09D5F47D4DuLL) >> 0),
     (VUINT32) ((0x054A7F09D5F47D4DuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000517CC1B72722uLL) >> 0),
     (VUINT32) ((0x0000517CC1B72722uLL) >> 32)},
    {(VUINT32) ((0x0A94FE13ABE8FA9AuLL) >> 0),
     (VUINT32) ((0x0A94FE13ABE8FA9AuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000A2F9836E4E44uLL) >> 0),
     (VUINT32) ((0x0000A2F9836E4E44uLL) >> 32)},
    {(VUINT32) ((0x1529FC2757D1F534uLL) >> 0),
     (VUINT32) ((0x1529FC2757D1F534uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000145F306DC9C88uLL) >> 0),
     (VUINT32) ((0x000145F306DC9C88uLL) >> 32)},
    {(VUINT32) ((0x2A53F84EAFA3EA69uLL) >> 0),
     (VUINT32) ((0x2A53F84EAFA3EA69uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00028BE60DB93910uLL) >> 0),
     (VUINT32) ((0x00028BE60DB93910uLL) >> 32)},
    {(VUINT32) ((0x54A7F09D5F47D4D3uLL) >> 0),
     (VUINT32) ((0x54A7F09D5F47D4D3uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000517CC1B727220uLL) >> 0),
     (VUINT32) ((0x000517CC1B727220uLL) >> 32)},
    {(VUINT32) ((0xA94FE13ABE8FA9A6uLL) >> 0),
     (VUINT32) ((0xA94FE13ABE8FA9A6uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x000A2F9836E4E441uLL) >> 0),
     (VUINT32) ((0x000A2F9836E4E441uLL) >> 32)},
    {(VUINT32) ((0x529FC2757D1F534DuLL) >> 0),
     (VUINT32) ((0x529FC2757D1F534DuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00145F306DC9C882uLL) >> 0),
     (VUINT32) ((0x00145F306DC9C882uLL) >> 32)},
    {(VUINT32) ((0xA53F84EAFA3EA69BuLL) >> 0),
     (VUINT32) ((0xA53F84EAFA3EA69BuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0028BE60DB939105uLL) >> 0),
     (VUINT32) ((0x0028BE60DB939105uLL) >> 32)},
    {(VUINT32) ((0x4A7F09D5F47D4D37uLL) >> 0),
     (VUINT32) ((0x4A7F09D5F47D4D37uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00517CC1B727220AuLL) >> 0),
     (VUINT32) ((0x00517CC1B727220AuLL) >> 32)},
    {(VUINT32) ((0x94FE13ABE8FA9A6EuLL) >> 0),
     (VUINT32) ((0x94FE13ABE8FA9A6EuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x00A2F9836E4E4415uLL) >> 0),
     (VUINT32) ((0x00A2F9836E4E4415uLL) >> 32)},
    {(VUINT32) ((0x29FC2757D1F534DDuLL) >> 0),
     (VUINT32) ((0x29FC2757D1F534DDuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0145F306DC9C882AuLL) >> 0),
     (VUINT32) ((0x0145F306DC9C882AuLL) >> 32)},
    {(VUINT32) ((0x53F84EAFA3EA69BBuLL) >> 0),
     (VUINT32) ((0x53F84EAFA3EA69BBuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x028BE60DB9391054uLL) >> 0),
     (VUINT32) ((0x028BE60DB9391054uLL) >> 32)},
    {(VUINT32) ((0xA7F09D5F47D4D377uLL) >> 0),
     (VUINT32) ((0xA7F09D5F47D4D377uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0517CC1B727220A9uLL) >> 0),
     (VUINT32) ((0x0517CC1B727220A9uLL) >> 32)},
    {(VUINT32) ((0x4FE13ABE8FA9A6EEuLL) >> 0),
     (VUINT32) ((0x4FE13ABE8FA9A6EEuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0A2F9836E4E44152uLL) >> 0),
     (VUINT32) ((0x0A2F9836E4E44152uLL) >> 32)},
    {(VUINT32) ((0x9FC2757D1F534DDCuLL) >> 0),
     (VUINT32) ((0x9FC2757D1F534DDCuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x145F306DC9C882A5uLL) >> 0),
     (VUINT32) ((0x145F306DC9C882A5uLL) >> 32)},
    {(VUINT32) ((0x3F84EAFA3EA69BB8uLL) >> 0),
     (VUINT32) ((0x3F84EAFA3EA69BB8uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x28BE60DB9391054AuLL) >> 0),
     (VUINT32) ((0x28BE60DB9391054AuLL) >> 32)},
    {(VUINT32) ((0x7F09D5F47D4D3770uLL) >> 0),
     (VUINT32) ((0x7F09D5F47D4D3770uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x517CC1B727220A94uLL) >> 0),
     (VUINT32) ((0x517CC1B727220A94uLL) >> 32)},
    {(VUINT32) ((0xFE13ABE8FA9A6EE0uLL) >> 0),
     (VUINT32) ((0xFE13ABE8FA9A6EE0uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xA2F9836E4E441529uLL) >> 0),
     (VUINT32) ((0xA2F9836E4E441529uLL) >> 32)},
    {(VUINT32) ((0xFC2757D1F534DDC0uLL) >> 0),
     (VUINT32) ((0xFC2757D1F534DDC0uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000001uLL) >> 0),
     (VUINT32) ((0x0000000000000001uLL) >> 32)},
    {(VUINT32) ((0x45F306DC9C882A53uLL) >> 0),
     (VUINT32) ((0x45F306DC9C882A53uLL) >> 32)},
    {(VUINT32) ((0xF84EAFA3EA69BB81uLL) >> 0),
     (VUINT32) ((0xF84EAFA3EA69BB81uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000002uLL) >> 0),
     (VUINT32) ((0x0000000000000002uLL) >> 32)},
    {(VUINT32) ((0x8BE60DB9391054A7uLL) >> 0),
     (VUINT32) ((0x8BE60DB9391054A7uLL) >> 32)},
    {(VUINT32) ((0xF09D5F47D4D37703uLL) >> 0),
     (VUINT32) ((0xF09D5F47D4D37703uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000005uLL) >> 0),
     (VUINT32) ((0x0000000000000005uLL) >> 32)},
    {(VUINT32) ((0x17CC1B727220A94FuLL) >> 0),
     (VUINT32) ((0x17CC1B727220A94FuLL) >> 32)},
    {(VUINT32) ((0xE13ABE8FA9A6EE06uLL) >> 0),
     (VUINT32) ((0xE13ABE8FA9A6EE06uLL) >> 32)}},
   {{(VUINT32) ((0x000000000000000AuLL) >> 0),
     (VUINT32) ((0x000000000000000AuLL) >> 32)},
    {(VUINT32) ((0x2F9836E4E441529FuLL) >> 0),
     (VUINT32) ((0x2F9836E4E441529FuLL) >> 32)},
    {(VUINT32) ((0xC2757D1F534DDC0DuLL) >> 0),
     (VUINT32) ((0xC2757D1F534DDC0DuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000014uLL) >> 0),
     (VUINT32) ((0x0000000000000014uLL) >> 32)},
    {(VUINT32) ((0x5F306DC9C882A53FuLL) >> 0),
     (VUINT32) ((0x5F306DC9C882A53FuLL) >> 32)},
    {(VUINT32) ((0x84EAFA3EA69BB81BuLL) >> 0),
     (VUINT32) ((0x84EAFA3EA69BB81BuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000028uLL) >> 0),
     (VUINT32) ((0x0000000000000028uLL) >> 32)},
    {(VUINT32) ((0xBE60DB9391054A7FuLL) >> 0),
     (VUINT32) ((0xBE60DB9391054A7FuLL) >> 32)},
    {(VUINT32) ((0x09D5F47D4D377036uLL) >> 0),
     (VUINT32) ((0x09D5F47D4D377036uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000051uLL) >> 0),
     (VUINT32) ((0x0000000000000051uLL) >> 32)},
    {(VUINT32) ((0x7CC1B727220A94FEuLL) >> 0),
     (VUINT32) ((0x7CC1B727220A94FEuLL) >> 32)},
    {(VUINT32) ((0x13ABE8FA9A6EE06DuLL) >> 0),
     (VUINT32) ((0x13ABE8FA9A6EE06DuLL) >> 32)}},
   {{(VUINT32) ((0x00000000000000A2uLL) >> 0),
     (VUINT32) ((0x00000000000000A2uLL) >> 32)},
    {(VUINT32) ((0xF9836E4E441529FCuLL) >> 0),
     (VUINT32) ((0xF9836E4E441529FCuLL) >> 32)},
    {(VUINT32) ((0x2757D1F534DDC0DBuLL) >> 0),
     (VUINT32) ((0x2757D1F534DDC0DBuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000145uLL) >> 0),
     (VUINT32) ((0x0000000000000145uLL) >> 32)},
    {(VUINT32) ((0xF306DC9C882A53F8uLL) >> 0),
     (VUINT32) ((0xF306DC9C882A53F8uLL) >> 32)},
    {(VUINT32) ((0x4EAFA3EA69BB81B6uLL) >> 0),
     (VUINT32) ((0x4EAFA3EA69BB81B6uLL) >> 32)}},
   {{(VUINT32) ((0x000000000000028BuLL) >> 0),
     (VUINT32) ((0x000000000000028BuLL) >> 32)},
    {(VUINT32) ((0xE60DB9391054A7F0uLL) >> 0),
     (VUINT32) ((0xE60DB9391054A7F0uLL) >> 32)},
    {(VUINT32) ((0x9D5F47D4D377036DuLL) >> 0),
     (VUINT32) ((0x9D5F47D4D377036DuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000517uLL) >> 0),
     (VUINT32) ((0x0000000000000517uLL) >> 32)},
    {(VUINT32) ((0xCC1B727220A94FE1uLL) >> 0),
     (VUINT32) ((0xCC1B727220A94FE1uLL) >> 32)},
    {(VUINT32) ((0x3ABE8FA9A6EE06DBuLL) >> 0),
     (VUINT32) ((0x3ABE8FA9A6EE06DBuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000A2FuLL) >> 0),
     (VUINT32) ((0x0000000000000A2FuLL) >> 32)},
    {(VUINT32) ((0x9836E4E441529FC2uLL) >> 0),
     (VUINT32) ((0x9836E4E441529FC2uLL) >> 32)},
    {(VUINT32) ((0x757D1F534DDC0DB6uLL) >> 0),
     (VUINT32) ((0x757D1F534DDC0DB6uLL) >> 32)}},
   {{(VUINT32) ((0x000000000000145FuLL) >> 0),
     (VUINT32) ((0x000000000000145FuLL) >> 32)},
    {(VUINT32) ((0x306DC9C882A53F84uLL) >> 0),
     (VUINT32) ((0x306DC9C882A53F84uLL) >> 32)},
    {(VUINT32) ((0xEAFA3EA69BB81B6CuLL) >> 0),
     (VUINT32) ((0xEAFA3EA69BB81B6CuLL) >> 32)}},
   {{(VUINT32) ((0x00000000000028BEuLL) >> 0),
     (VUINT32) ((0x00000000000028BEuLL) >> 32)},
    {(VUINT32) ((0x60DB9391054A7F09uLL) >> 0),
     (VUINT32) ((0x60DB9391054A7F09uLL) >> 32)},
    {(VUINT32) ((0xD5F47D4D377036D8uLL) >> 0),
     (VUINT32) ((0xD5F47D4D377036D8uLL) >> 32)}},
   {{(VUINT32) ((0x000000000000517CuLL) >> 0),
     (VUINT32) ((0x000000000000517CuLL) >> 32)},
    {(VUINT32) ((0xC1B727220A94FE13uLL) >> 0),
     (VUINT32) ((0xC1B727220A94FE13uLL) >> 32)},
    {(VUINT32) ((0xABE8FA9A6EE06DB1uLL) >> 0),
     (VUINT32) ((0xABE8FA9A6EE06DB1uLL) >> 32)}},
   {{(VUINT32) ((0x000000000000A2F9uLL) >> 0),
     (VUINT32) ((0x000000000000A2F9uLL) >> 32)},
    {(VUINT32) ((0x836E4E441529FC27uLL) >> 0),
     (VUINT32) ((0x836E4E441529FC27uLL) >> 32)},
    {(VUINT32) ((0x57D1F534DDC0DB62uLL) >> 0),
     (VUINT32) ((0x57D1F534DDC0DB62uLL) >> 32)}},
   {{(VUINT32) ((0x00000000000145F3uLL) >> 0),
     (VUINT32) ((0x00000000000145F3uLL) >> 32)},
    {(VUINT32) ((0x06DC9C882A53F84EuLL) >> 0),
     (VUINT32) ((0x06DC9C882A53F84EuLL) >> 32)},
    {(VUINT32) ((0xAFA3EA69BB81B6C5uLL) >> 0),
     (VUINT32) ((0xAFA3EA69BB81B6C5uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000028BE6uLL) >> 0),
     (VUINT32) ((0x0000000000028BE6uLL) >> 32)},
    {(VUINT32) ((0x0DB9391054A7F09DuLL) >> 0),
     (VUINT32) ((0x0DB9391054A7F09DuLL) >> 32)},
    {(VUINT32) ((0x5F47D4D377036D8AuLL) >> 0),
     (VUINT32) ((0x5F47D4D377036D8AuLL) >> 32)}},
   {{(VUINT32) ((0x00000000000517CCuLL) >> 0),
     (VUINT32) ((0x00000000000517CCuLL) >> 32)},
    {(VUINT32) ((0x1B727220A94FE13AuLL) >> 0),
     (VUINT32) ((0x1B727220A94FE13AuLL) >> 32)},
    {(VUINT32) ((0xBE8FA9A6EE06DB14uLL) >> 0),
     (VUINT32) ((0xBE8FA9A6EE06DB14uLL) >> 32)}},
   {{(VUINT32) ((0x00000000000A2F98uLL) >> 0),
     (VUINT32) ((0x00000000000A2F98uLL) >> 32)},
    {(VUINT32) ((0x36E4E441529FC275uLL) >> 0),
     (VUINT32) ((0x36E4E441529FC275uLL) >> 32)},
    {(VUINT32) ((0x7D1F534DDC0DB629uLL) >> 0),
     (VUINT32) ((0x7D1F534DDC0DB629uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000145F30uLL) >> 0),
     (VUINT32) ((0x0000000000145F30uLL) >> 32)},
    {(VUINT32) ((0x6DC9C882A53F84EAuLL) >> 0),
     (VUINT32) ((0x6DC9C882A53F84EAuLL) >> 32)},
    {(VUINT32) ((0xFA3EA69BB81B6C52uLL) >> 0),
     (VUINT32) ((0xFA3EA69BB81B6C52uLL) >> 32)}},
   {{(VUINT32) ((0x000000000028BE60uLL) >> 0),
     (VUINT32) ((0x000000000028BE60uLL) >> 32)},
    {(VUINT32) ((0xDB9391054A7F09D5uLL) >> 0),
     (VUINT32) ((0xDB9391054A7F09D5uLL) >> 32)},
    {(VUINT32) ((0xF47D4D377036D8A5uLL) >> 0),
     (VUINT32) ((0xF47D4D377036D8A5uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000517CC1uLL) >> 0),
     (VUINT32) ((0x0000000000517CC1uLL) >> 32)},
    {(VUINT32) ((0xB727220A94FE13ABuLL) >> 0),
     (VUINT32) ((0xB727220A94FE13ABuLL) >> 32)},
    {(VUINT32) ((0xE8FA9A6EE06DB14AuLL) >> 0),
     (VUINT32) ((0xE8FA9A6EE06DB14AuLL) >> 32)}},
   {{(VUINT32) ((0x0000000000A2F983uLL) >> 0),
     (VUINT32) ((0x0000000000A2F983uLL) >> 32)},
    {(VUINT32) ((0x6E4E441529FC2757uLL) >> 0),
     (VUINT32) ((0x6E4E441529FC2757uLL) >> 32)},
    {(VUINT32) ((0xD1F534DDC0DB6295uLL) >> 0),
     (VUINT32) ((0xD1F534DDC0DB6295uLL) >> 32)}},
   {{(VUINT32) ((0x000000000145F306uLL) >> 0),
     (VUINT32) ((0x000000000145F306uLL) >> 32)},
    {(VUINT32) ((0xDC9C882A53F84EAFuLL) >> 0),
     (VUINT32) ((0xDC9C882A53F84EAFuLL) >> 32)},
    {(VUINT32) ((0xA3EA69BB81B6C52BuLL) >> 0),
     (VUINT32) ((0xA3EA69BB81B6C52BuLL) >> 32)}},
   {{(VUINT32) ((0x00000000028BE60DuLL) >> 0),
     (VUINT32) ((0x00000000028BE60DuLL) >> 32)},
    {(VUINT32) ((0xB9391054A7F09D5FuLL) >> 0),
     (VUINT32) ((0xB9391054A7F09D5FuLL) >> 32)},
    {(VUINT32) ((0x47D4D377036D8A56uLL) >> 0),
     (VUINT32) ((0x47D4D377036D8A56uLL) >> 32)}},
   {{(VUINT32) ((0x000000000517CC1BuLL) >> 0),
     (VUINT32) ((0x000000000517CC1BuLL) >> 32)},
    {(VUINT32) ((0x727220A94FE13ABEuLL) >> 0),
     (VUINT32) ((0x727220A94FE13ABEuLL) >> 32)},
    {(VUINT32) ((0x8FA9A6EE06DB14ACuLL) >> 0),
     (VUINT32) ((0x8FA9A6EE06DB14ACuLL) >> 32)}},
   {{(VUINT32) ((0x000000000A2F9836uLL) >> 0),
     (VUINT32) ((0x000000000A2F9836uLL) >> 32)},
    {(VUINT32) ((0xE4E441529FC2757DuLL) >> 0),
     (VUINT32) ((0xE4E441529FC2757DuLL) >> 32)},
    {(VUINT32) ((0x1F534DDC0DB62959uLL) >> 0),
     (VUINT32) ((0x1F534DDC0DB62959uLL) >> 32)}},
   {{(VUINT32) ((0x00000000145F306DuLL) >> 0),
     (VUINT32) ((0x00000000145F306DuLL) >> 32)},
    {(VUINT32) ((0xC9C882A53F84EAFAuLL) >> 0),
     (VUINT32) ((0xC9C882A53F84EAFAuLL) >> 32)},
    {(VUINT32) ((0x3EA69BB81B6C52B3uLL) >> 0),
     (VUINT32) ((0x3EA69BB81B6C52B3uLL) >> 32)}},
   {{(VUINT32) ((0x0000000028BE60DBuLL) >> 0),
     (VUINT32) ((0x0000000028BE60DBuLL) >> 32)},
    {(VUINT32) ((0x9391054A7F09D5F4uLL) >> 0),
     (VUINT32) ((0x9391054A7F09D5F4uLL) >> 32)},
    {(VUINT32) ((0x7D4D377036D8A566uLL) >> 0),
     (VUINT32) ((0x7D4D377036D8A566uLL) >> 32)}},
   {{(VUINT32) ((0x00000000517CC1B7uLL) >> 0),
     (VUINT32) ((0x00000000517CC1B7uLL) >> 32)},
    {(VUINT32) ((0x27220A94FE13ABE8uLL) >> 0),
     (VUINT32) ((0x27220A94FE13ABE8uLL) >> 32)},
    {(VUINT32) ((0xFA9A6EE06DB14ACCuLL) >> 0),
     (VUINT32) ((0xFA9A6EE06DB14ACCuLL) >> 32)}},
   {{(VUINT32) ((0x00000000A2F9836EuLL) >> 0),
     (VUINT32) ((0x00000000A2F9836EuLL) >> 32)},
    {(VUINT32) ((0x4E441529FC2757D1uLL) >> 0),
     (VUINT32) ((0x4E441529FC2757D1uLL) >> 32)},
    {(VUINT32) ((0xF534DDC0DB629599uLL) >> 0),
     (VUINT32) ((0xF534DDC0DB629599uLL) >> 32)}},
   {{(VUINT32) ((0x0000000145F306DCuLL) >> 0),
     (VUINT32) ((0x0000000145F306DCuLL) >> 32)},
    {(VUINT32) ((0x9C882A53F84EAFA3uLL) >> 0),
     (VUINT32) ((0x9C882A53F84EAFA3uLL) >> 32)},
    {(VUINT32) ((0xEA69BB81B6C52B32uLL) >> 0),
     (VUINT32) ((0xEA69BB81B6C52B32uLL) >> 32)}},
   {{(VUINT32) ((0x000000028BE60DB9uLL) >> 0),
     (VUINT32) ((0x000000028BE60DB9uLL) >> 32)},
    {(VUINT32) ((0x391054A7F09D5F47uLL) >> 0),
     (VUINT32) ((0x391054A7F09D5F47uLL) >> 32)},
    {(VUINT32) ((0xD4D377036D8A5664uLL) >> 0),
     (VUINT32) ((0xD4D377036D8A5664uLL) >> 32)}},
   {{(VUINT32) ((0x0000000517CC1B72uLL) >> 0),
     (VUINT32) ((0x0000000517CC1B72uLL) >> 32)},
    {(VUINT32) ((0x7220A94FE13ABE8FuLL) >> 0),
     (VUINT32) ((0x7220A94FE13ABE8FuLL) >> 32)},
    {(VUINT32) ((0xA9A6EE06DB14ACC9uLL) >> 0),
     (VUINT32) ((0xA9A6EE06DB14ACC9uLL) >> 32)}},
   {{(VUINT32) ((0x0000000A2F9836E4uLL) >> 0),
     (VUINT32) ((0x0000000A2F9836E4uLL) >> 32)},
    {(VUINT32) ((0xE441529FC2757D1FuLL) >> 0),
     (VUINT32) ((0xE441529FC2757D1FuLL) >> 32)},
    {(VUINT32) ((0x534DDC0DB6295993uLL) >> 0),
     (VUINT32) ((0x534DDC0DB6295993uLL) >> 32)}},
   {{(VUINT32) ((0x000000145F306DC9uLL) >> 0),
     (VUINT32) ((0x000000145F306DC9uLL) >> 32)},
    {(VUINT32) ((0xC882A53F84EAFA3EuLL) >> 0),
     (VUINT32) ((0xC882A53F84EAFA3EuLL) >> 32)},
    {(VUINT32) ((0xA69BB81B6C52B327uLL) >> 0),
     (VUINT32) ((0xA69BB81B6C52B327uLL) >> 32)}},
   {{(VUINT32) ((0x00000028BE60DB93uLL) >> 0),
     (VUINT32) ((0x00000028BE60DB93uLL) >> 32)},
    {(VUINT32) ((0x91054A7F09D5F47DuLL) >> 0),
     (VUINT32) ((0x91054A7F09D5F47DuLL) >> 32)},
    {(VUINT32) ((0x4D377036D8A5664FuLL) >> 0),
     (VUINT32) ((0x4D377036D8A5664FuLL) >> 32)}},
   {{(VUINT32) ((0x000000517CC1B727uLL) >> 0),
     (VUINT32) ((0x000000517CC1B727uLL) >> 32)},
    {(VUINT32) ((0x220A94FE13ABE8FAuLL) >> 0),
     (VUINT32) ((0x220A94FE13ABE8FAuLL) >> 32)},
    {(VUINT32) ((0x9A6EE06DB14ACC9EuLL) >> 0),
     (VUINT32) ((0x9A6EE06DB14ACC9EuLL) >> 32)}},
   {{(VUINT32) ((0x000000A2F9836E4EuLL) >> 0),
     (VUINT32) ((0x000000A2F9836E4EuLL) >> 32)},
    {(VUINT32) ((0x441529FC2757D1F5uLL) >> 0),
     (VUINT32) ((0x441529FC2757D1F5uLL) >> 32)},
    {(VUINT32) ((0x34DDC0DB6295993CuLL) >> 0),
     (VUINT32) ((0x34DDC0DB6295993CuLL) >> 32)}},
   {{(VUINT32) ((0x00000145F306DC9CuLL) >> 0),
     (VUINT32) ((0x00000145F306DC9CuLL) >> 32)},
    {(VUINT32) ((0x882A53F84EAFA3EAuLL) >> 0),
     (VUINT32) ((0x882A53F84EAFA3EAuLL) >> 32)},
    {(VUINT32) ((0x69BB81B6C52B3278uLL) >> 0),
     (VUINT32) ((0x69BB81B6C52B3278uLL) >> 32)}},
   {{(VUINT32) ((0x0000028BE60DB939uLL) >> 0),
     (VUINT32) ((0x0000028BE60DB939uLL) >> 32)},
    {(VUINT32) ((0x1054A7F09D5F47D4uLL) >> 0),
     (VUINT32) ((0x1054A7F09D5F47D4uLL) >> 32)},
    {(VUINT32) ((0xD377036D8A5664F1uLL) >> 0),
     (VUINT32) ((0xD377036D8A5664F1uLL) >> 32)}},
   {{(VUINT32) ((0x00000517CC1B7272uLL) >> 0),
     (VUINT32) ((0x00000517CC1B7272uLL) >> 32)},
    {(VUINT32) ((0x20A94FE13ABE8FA9uLL) >> 0),
     (VUINT32) ((0x20A94FE13ABE8FA9uLL) >> 32)},
    {(VUINT32) ((0xA6EE06DB14ACC9E2uLL) >> 0),
     (VUINT32) ((0xA6EE06DB14ACC9E2uLL) >> 32)}},
   {{(VUINT32) ((0x00000A2F9836E4E4uLL) >> 0),
     (VUINT32) ((0x00000A2F9836E4E4uLL) >> 32)},
    {(VUINT32) ((0x41529FC2757D1F53uLL) >> 0),
     (VUINT32) ((0x41529FC2757D1F53uLL) >> 32)},
    {(VUINT32) ((0x4DDC0DB6295993C4uLL) >> 0),
     (VUINT32) ((0x4DDC0DB6295993C4uLL) >> 32)}},
   {{(VUINT32) ((0x0000145F306DC9C8uLL) >> 0),
     (VUINT32) ((0x0000145F306DC9C8uLL) >> 32)},
    {(VUINT32) ((0x82A53F84EAFA3EA6uLL) >> 0),
     (VUINT32) ((0x82A53F84EAFA3EA6uLL) >> 32)},
    {(VUINT32) ((0x9BB81B6C52B32788uLL) >> 0),
     (VUINT32) ((0x9BB81B6C52B32788uLL) >> 32)}},
   {{(VUINT32) ((0x000028BE60DB9391uLL) >> 0),
     (VUINT32) ((0x000028BE60DB9391uLL) >> 32)},
    {(VUINT32) ((0x054A7F09D5F47D4DuLL) >> 0),
     (VUINT32) ((0x054A7F09D5F47D4DuLL) >> 32)},
    {(VUINT32) ((0x377036D8A5664F10uLL) >> 0),
     (VUINT32) ((0x377036D8A5664F10uLL) >> 32)}},
   {{(VUINT32) ((0x0000517CC1B72722uLL) >> 0),
     (VUINT32) ((0x0000517CC1B72722uLL) >> 32)},
    {(VUINT32) ((0x0A94FE13ABE8FA9AuLL) >> 0),
     (VUINT32) ((0x0A94FE13ABE8FA9AuLL) >> 32)},
    {(VUINT32) ((0x6EE06DB14ACC9E21uLL) >> 0),
     (VUINT32) ((0x6EE06DB14ACC9E21uLL) >> 32)}},
   {{(VUINT32) ((0x0000A2F9836E4E44uLL) >> 0),
     (VUINT32) ((0x0000A2F9836E4E44uLL) >> 32)},
    {(VUINT32) ((0x1529FC2757D1F534uLL) >> 0),
     (VUINT32) ((0x1529FC2757D1F534uLL) >> 32)},
    {(VUINT32) ((0xDDC0DB6295993C43uLL) >> 0),
     (VUINT32) ((0xDDC0DB6295993C43uLL) >> 32)}},
   {{(VUINT32) ((0x000145F306DC9C88uLL) >> 0),
     (VUINT32) ((0x000145F306DC9C88uLL) >> 32)},
    {(VUINT32) ((0x2A53F84EAFA3EA69uLL) >> 0),
     (VUINT32) ((0x2A53F84EAFA3EA69uLL) >> 32)},
    {(VUINT32) ((0xBB81B6C52B327887uLL) >> 0),
     (VUINT32) ((0xBB81B6C52B327887uLL) >> 32)}},
   {{(VUINT32) ((0x00028BE60DB93910uLL) >> 0),
     (VUINT32) ((0x00028BE60DB93910uLL) >> 32)},
    {(VUINT32) ((0x54A7F09D5F47D4D3uLL) >> 0),
     (VUINT32) ((0x54A7F09D5F47D4D3uLL) >> 32)},
    {(VUINT32) ((0x77036D8A5664F10EuLL) >> 0),
     (VUINT32) ((0x77036D8A5664F10EuLL) >> 32)}},
   {{(VUINT32) ((0x000517CC1B727220uLL) >> 0),
     (VUINT32) ((0x000517CC1B727220uLL) >> 32)},
    {(VUINT32) ((0xA94FE13ABE8FA9A6uLL) >> 0),
     (VUINT32) ((0xA94FE13ABE8FA9A6uLL) >> 32)},
    {(VUINT32) ((0xEE06DB14ACC9E21CuLL) >> 0),
     (VUINT32) ((0xEE06DB14ACC9E21CuLL) >> 32)}},
   {{(VUINT32) ((0x000A2F9836E4E441uLL) >> 0),
     (VUINT32) ((0x000A2F9836E4E441uLL) >> 32)},
    {(VUINT32) ((0x529FC2757D1F534DuLL) >> 0),
     (VUINT32) ((0x529FC2757D1F534DuLL) >> 32)},
    {(VUINT32) ((0xDC0DB6295993C439uLL) >> 0),
     (VUINT32) ((0xDC0DB6295993C439uLL) >> 32)}},
   {{(VUINT32) ((0x00145F306DC9C882uLL) >> 0),
     (VUINT32) ((0x00145F306DC9C882uLL) >> 32)},
    {(VUINT32) ((0xA53F84EAFA3EA69BuLL) >> 0),
     (VUINT32) ((0xA53F84EAFA3EA69BuLL) >> 32)},
    {(VUINT32) ((0xB81B6C52B3278872uLL) >> 0),
     (VUINT32) ((0xB81B6C52B3278872uLL) >> 32)}},
   {{(VUINT32) ((0x0028BE60DB939105uLL) >> 0),
     (VUINT32) ((0x0028BE60DB939105uLL) >> 32)},
    {(VUINT32) ((0x4A7F09D5F47D4D37uLL) >> 0),
     (VUINT32) ((0x4A7F09D5F47D4D37uLL) >> 32)},
    {(VUINT32) ((0x7036D8A5664F10E4uLL) >> 0),
     (VUINT32) ((0x7036D8A5664F10E4uLL) >> 32)}},
   {{(VUINT32) ((0x00517CC1B727220AuLL) >> 0),
     (VUINT32) ((0x00517CC1B727220AuLL) >> 32)},
    {(VUINT32) ((0x94FE13ABE8FA9A6EuLL) >> 0),
     (VUINT32) ((0x94FE13ABE8FA9A6EuLL) >> 32)},
    {(VUINT32) ((0xE06DB14ACC9E21C8uLL) >> 0),
     (VUINT32) ((0xE06DB14ACC9E21C8uLL) >> 32)}},
   {{(VUINT32) ((0x00A2F9836E4E4415uLL) >> 0),
     (VUINT32) ((0x00A2F9836E4E4415uLL) >> 32)},
    {(VUINT32) ((0x29FC2757D1F534DDuLL) >> 0),
     (VUINT32) ((0x29FC2757D1F534DDuLL) >> 32)},
    {(VUINT32) ((0xC0DB6295993C4390uLL) >> 0),
     (VUINT32) ((0xC0DB6295993C4390uLL) >> 32)}},
   {{(VUINT32) ((0x0145F306DC9C882AuLL) >> 0),
     (VUINT32) ((0x0145F306DC9C882AuLL) >> 32)},
    {(VUINT32) ((0x53F84EAFA3EA69BBuLL) >> 0),
     (VUINT32) ((0x53F84EAFA3EA69BBuLL) >> 32)},
    {(VUINT32) ((0x81B6C52B32788720uLL) >> 0),
     (VUINT32) ((0x81B6C52B32788720uLL) >> 32)}},
   {{(VUINT32) ((0x028BE60DB9391054uLL) >> 0),
     (VUINT32) ((0x028BE60DB9391054uLL) >> 32)},
    {(VUINT32) ((0xA7F09D5F47D4D377uLL) >> 0),
     (VUINT32) ((0xA7F09D5F47D4D377uLL) >> 32)},
    {(VUINT32) ((0x036D8A5664F10E41uLL) >> 0),
     (VUINT32) ((0x036D8A5664F10E41uLL) >> 32)}},
   {{(VUINT32) ((0x0517CC1B727220A9uLL) >> 0),
     (VUINT32) ((0x0517CC1B727220A9uLL) >> 32)},
    {(VUINT32) ((0x4FE13ABE8FA9A6EEuLL) >> 0),
     (VUINT32) ((0x4FE13ABE8FA9A6EEuLL) >> 32)},
    {(VUINT32) ((0x06DB14ACC9E21C82uLL) >> 0),
     (VUINT32) ((0x06DB14ACC9E21C82uLL) >> 32)}},
   {{(VUINT32) ((0x0A2F9836E4E44152uLL) >> 0),
     (VUINT32) ((0x0A2F9836E4E44152uLL) >> 32)},
    {(VUINT32) ((0x9FC2757D1F534DDCuLL) >> 0),
     (VUINT32) ((0x9FC2757D1F534DDCuLL) >> 32)},
    {(VUINT32) ((0x0DB6295993C43904uLL) >> 0),
     (VUINT32) ((0x0DB6295993C43904uLL) >> 32)}},
   {{(VUINT32) ((0x145F306DC9C882A5uLL) >> 0),
     (VUINT32) ((0x145F306DC9C882A5uLL) >> 32)},
    {(VUINT32) ((0x3F84EAFA3EA69BB8uLL) >> 0),
     (VUINT32) ((0x3F84EAFA3EA69BB8uLL) >> 32)},
    {(VUINT32) ((0x1B6C52B327887208uLL) >> 0),
     (VUINT32) ((0x1B6C52B327887208uLL) >> 32)}},
   {{(VUINT32) ((0x28BE60DB9391054AuLL) >> 0),
     (VUINT32) ((0x28BE60DB9391054AuLL) >> 32)},
    {(VUINT32) ((0x7F09D5F47D4D3770uLL) >> 0),
     (VUINT32) ((0x7F09D5F47D4D3770uLL) >> 32)},
    {(VUINT32) ((0x36D8A5664F10E410uLL) >> 0),
     (VUINT32) ((0x36D8A5664F10E410uLL) >> 32)}},
   {{(VUINT32) ((0x517CC1B727220A94uLL) >> 0),
     (VUINT32) ((0x517CC1B727220A94uLL) >> 32)},
    {(VUINT32) ((0xFE13ABE8FA9A6EE0uLL) >> 0),
     (VUINT32) ((0xFE13ABE8FA9A6EE0uLL) >> 32)},
    {(VUINT32) ((0x6DB14ACC9E21C820uLL) >> 0),
     (VUINT32) ((0x6DB14ACC9E21C820uLL) >> 32)}},
   {{(VUINT32) ((0xA2F9836E4E441529uLL) >> 0),
     (VUINT32) ((0xA2F9836E4E441529uLL) >> 32)},
    {(VUINT32) ((0xFC2757D1F534DDC0uLL) >> 0),
     (VUINT32) ((0xFC2757D1F534DDC0uLL) >> 32)},
    {(VUINT32) ((0xDB6295993C439041uLL) >> 0),
     (VUINT32) ((0xDB6295993C439041uLL) >> 32)}},
   {{(VUINT32) ((0x45F306DC9C882A53uLL) >> 0),
     (VUINT32) ((0x45F306DC9C882A53uLL) >> 32)},
    {(VUINT32) ((0xF84EAFA3EA69BB81uLL) >> 0),
     (VUINT32) ((0xF84EAFA3EA69BB81uLL) >> 32)},
    {(VUINT32) ((0xB6C52B3278872083uLL) >> 0),
     (VUINT32) ((0xB6C52B3278872083uLL) >> 32)}},
   {{(VUINT32) ((0x8BE60DB9391054A7uLL) >> 0),
     (VUINT32) ((0x8BE60DB9391054A7uLL) >> 32)},
    {(VUINT32) ((0xF09D5F47D4D37703uLL) >> 0),
     (VUINT32) ((0xF09D5F47D4D37703uLL) >> 32)},
    {(VUINT32) ((0x6D8A5664F10E4107uLL) >> 0),
     (VUINT32) ((0x6D8A5664F10E4107uLL) >> 32)}},
   {{(VUINT32) ((0x17CC1B727220A94FuLL) >> 0),
     (VUINT32) ((0x17CC1B727220A94FuLL) >> 32)},
    {(VUINT32) ((0xE13ABE8FA9A6EE06uLL) >> 0),
     (VUINT32) ((0xE13ABE8FA9A6EE06uLL) >> 32)},
    {(VUINT32) ((0xDB14ACC9E21C820FuLL) >> 0),
     (VUINT32) ((0xDB14ACC9E21C820FuLL) >> 32)}},
   {{(VUINT32) ((0x2F9836E4E441529FuLL) >> 0),
     (VUINT32) ((0x2F9836E4E441529FuLL) >> 32)},
    {(VUINT32) ((0xC2757D1F534DDC0DuLL) >> 0),
     (VUINT32) ((0xC2757D1F534DDC0DuLL) >> 32)},
    {(VUINT32) ((0xB6295993C439041FuLL) >> 0),
     (VUINT32) ((0xB6295993C439041FuLL) >> 32)}},
   {{(VUINT32) ((0x5F306DC9C882A53FuLL) >> 0),
     (VUINT32) ((0x5F306DC9C882A53FuLL) >> 32)},
    {(VUINT32) ((0x84EAFA3EA69BB81BuLL) >> 0),
     (VUINT32) ((0x84EAFA3EA69BB81BuLL) >> 32)},
    {(VUINT32) ((0x6C52B3278872083FuLL) >> 0),
     (VUINT32) ((0x6C52B3278872083FuLL) >> 32)}},
   {{(VUINT32) ((0xBE60DB9391054A7FuLL) >> 0),
     (VUINT32) ((0xBE60DB9391054A7FuLL) >> 32)},
    {(VUINT32) ((0x09D5F47D4D377036uLL) >> 0),
     (VUINT32) ((0x09D5F47D4D377036uLL) >> 32)},
    {(VUINT32) ((0xD8A5664F10E4107FuLL) >> 0),
     (VUINT32) ((0xD8A5664F10E4107FuLL) >> 32)}},
   {{(VUINT32) ((0x7CC1B727220A94FEuLL) >> 0),
     (VUINT32) ((0x7CC1B727220A94FEuLL) >> 32)},
    {(VUINT32) ((0x13ABE8FA9A6EE06DuLL) >> 0),
     (VUINT32) ((0x13ABE8FA9A6EE06DuLL) >> 32)},
    {(VUINT32) ((0xB14ACC9E21C820FFuLL) >> 0),
     (VUINT32) ((0xB14ACC9E21C820FFuLL) >> 32)}},
   {{(VUINT32) ((0xF9836E4E441529FCuLL) >> 0),
     (VUINT32) ((0xF9836E4E441529FCuLL) >> 32)},
    {(VUINT32) ((0x2757D1F534DDC0DBuLL) >> 0),
     (VUINT32) ((0x2757D1F534DDC0DBuLL) >> 32)},
    {(VUINT32) ((0x6295993C439041FEuLL) >> 0),
     (VUINT32) ((0x6295993C439041FEuLL) >> 32)}},
   {{(VUINT32) ((0xF306DC9C882A53F8uLL) >> 0),
     (VUINT32) ((0xF306DC9C882A53F8uLL) >> 32)},
    {(VUINT32) ((0x4EAFA3EA69BB81B6uLL) >> 0),
     (VUINT32) ((0x4EAFA3EA69BB81B6uLL) >> 32)},
    {(VUINT32) ((0xC52B3278872083FCuLL) >> 0),
     (VUINT32) ((0xC52B3278872083FCuLL) >> 32)}},
   {{(VUINT32) ((0xE60DB9391054A7F0uLL) >> 0),
     (VUINT32) ((0xE60DB9391054A7F0uLL) >> 32)},
    {(VUINT32) ((0x9D5F47D4D377036DuLL) >> 0),
     (VUINT32) ((0x9D5F47D4D377036DuLL) >> 32)},
    {(VUINT32) ((0x8A5664F10E4107F9uLL) >> 0),
     (VUINT32) ((0x8A5664F10E4107F9uLL) >> 32)}},
   {{(VUINT32) ((0xCC1B727220A94FE1uLL) >> 0),
     (VUINT32) ((0xCC1B727220A94FE1uLL) >> 32)},
    {(VUINT32) ((0x3ABE8FA9A6EE06DBuLL) >> 0),
     (VUINT32) ((0x3ABE8FA9A6EE06DBuLL) >> 32)},
    {(VUINT32) ((0x14ACC9E21C820FF2uLL) >> 0),
     (VUINT32) ((0x14ACC9E21C820FF2uLL) >> 32)}},
   {{(VUINT32) ((0x9836E4E441529FC2uLL) >> 0),
     (VUINT32) ((0x9836E4E441529FC2uLL) >> 32)},
    {(VUINT32) ((0x757D1F534DDC0DB6uLL) >> 0),
     (VUINT32) ((0x757D1F534DDC0DB6uLL) >> 32)},
    {(VUINT32) ((0x295993C439041FE5uLL) >> 0),
     (VUINT32) ((0x295993C439041FE5uLL) >> 32)}},
   {{(VUINT32) ((0x306DC9C882A53F84uLL) >> 0),
     (VUINT32) ((0x306DC9C882A53F84uLL) >> 32)},
    {(VUINT32) ((0xEAFA3EA69BB81B6CuLL) >> 0),
     (VUINT32) ((0xEAFA3EA69BB81B6CuLL) >> 32)},
    {(VUINT32) ((0x52B3278872083FCAuLL) >> 0),
     (VUINT32) ((0x52B3278872083FCAuLL) >> 32)}},
   {{(VUINT32) ((0x60DB9391054A7F09uLL) >> 0),
     (VUINT32) ((0x60DB9391054A7F09uLL) >> 32)},
    {(VUINT32) ((0xD5F47D4D377036D8uLL) >> 0),
     (VUINT32) ((0xD5F47D4D377036D8uLL) >> 32)},
    {(VUINT32) ((0xA5664F10E4107F94uLL) >> 0),
     (VUINT32) ((0xA5664F10E4107F94uLL) >> 32)}},
   {{(VUINT32) ((0xC1B727220A94FE13uLL) >> 0),
     (VUINT32) ((0xC1B727220A94FE13uLL) >> 32)},
    {(VUINT32) ((0xABE8FA9A6EE06DB1uLL) >> 0),
     (VUINT32) ((0xABE8FA9A6EE06DB1uLL) >> 32)},
    {(VUINT32) ((0x4ACC9E21C820FF28uLL) >> 0),
     (VUINT32) ((0x4ACC9E21C820FF28uLL) >> 32)}},
   {{(VUINT32) ((0x836E4E441529FC27uLL) >> 0),
     (VUINT32) ((0x836E4E441529FC27uLL) >> 32)},
    {(VUINT32) ((0x57D1F534DDC0DB62uLL) >> 0),
     (VUINT32) ((0x57D1F534DDC0DB62uLL) >> 32)},
    {(VUINT32) ((0x95993C439041FE51uLL) >> 0),
     (VUINT32) ((0x95993C439041FE51uLL) >> 32)}},
   {{(VUINT32) ((0x06DC9C882A53F84EuLL) >> 0),
     (VUINT32) ((0x06DC9C882A53F84EuLL) >> 32)},
    {(VUINT32) ((0xAFA3EA69BB81B6C5uLL) >> 0),
     (VUINT32) ((0xAFA3EA69BB81B6C5uLL) >> 32)},
    {(VUINT32) ((0x2B3278872083FCA2uLL) >> 0),
     (VUINT32) ((0x2B3278872083FCA2uLL) >> 32)}},
   {{(VUINT32) ((0x0DB9391054A7F09DuLL) >> 0),
     (VUINT32) ((0x0DB9391054A7F09DuLL) >> 32)},
    {(VUINT32) ((0x5F47D4D377036D8AuLL) >> 0),
     (VUINT32) ((0x5F47D4D377036D8AuLL) >> 32)},
    {(VUINT32) ((0x5664F10E4107F945uLL) >> 0),
     (VUINT32) ((0x5664F10E4107F945uLL) >> 32)}},
   {{(VUINT32) ((0x1B727220A94FE13AuLL) >> 0),
     (VUINT32) ((0x1B727220A94FE13AuLL) >> 32)},
    {(VUINT32) ((0xBE8FA9A6EE06DB14uLL) >> 0),
     (VUINT32) ((0xBE8FA9A6EE06DB14uLL) >> 32)},
    {(VUINT32) ((0xACC9E21C820FF28BuLL) >> 0),
     (VUINT32) ((0xACC9E21C820FF28BuLL) >> 32)}},
   {{(VUINT32) ((0x36E4E441529FC275uLL) >> 0),
     (VUINT32) ((0x36E4E441529FC275uLL) >> 32)},
    {(VUINT32) ((0x7D1F534DDC0DB629uLL) >> 0),
     (VUINT32) ((0x7D1F534DDC0DB629uLL) >> 32)},
    {(VUINT32) ((0x5993C439041FE516uLL) >> 0),
     (VUINT32) ((0x5993C439041FE516uLL) >> 32)}},
   {{(VUINT32) ((0x6DC9C882A53F84EAuLL) >> 0),
     (VUINT32) ((0x6DC9C882A53F84EAuLL) >> 32)},
    {(VUINT32) ((0xFA3EA69BB81B6C52uLL) >> 0),
     (VUINT32) ((0xFA3EA69BB81B6C52uLL) >> 32)},
    {(VUINT32) ((0xB3278872083FCA2CuLL) >> 0),
     (VUINT32) ((0xB3278872083FCA2CuLL) >> 32)}},
   {{(VUINT32) ((0xDB9391054A7F09D5uLL) >> 0),
     (VUINT32) ((0xDB9391054A7F09D5uLL) >> 32)},
    {(VUINT32) ((0xF47D4D377036D8A5uLL) >> 0),
     (VUINT32) ((0xF47D4D377036D8A5uLL) >> 32)},
    {(VUINT32) ((0x664F10E4107F9458uLL) >> 0),
     (VUINT32) ((0x664F10E4107F9458uLL) >> 32)}},
   {{(VUINT32) ((0xB727220A94FE13ABuLL) >> 0),
     (VUINT32) ((0xB727220A94FE13ABuLL) >> 32)},
    {(VUINT32) ((0xE8FA9A6EE06DB14AuLL) >> 0),
     (VUINT32) ((0xE8FA9A6EE06DB14AuLL) >> 32)},
    {(VUINT32) ((0xCC9E21C820FF28B1uLL) >> 0),
     (VUINT32) ((0xCC9E21C820FF28B1uLL) >> 32)}},
   {{(VUINT32) ((0x6E4E441529FC2757uLL) >> 0),
     (VUINT32) ((0x6E4E441529FC2757uLL) >> 32)},
    {(VUINT32) ((0xD1F534DDC0DB6295uLL) >> 0),
     (VUINT32) ((0xD1F534DDC0DB6295uLL) >> 32)},
    {(VUINT32) ((0x993C439041FE5163uLL) >> 0),
     (VUINT32) ((0x993C439041FE5163uLL) >> 32)}},
   {{(VUINT32) ((0xDC9C882A53F84EAFuLL) >> 0),
     (VUINT32) ((0xDC9C882A53F84EAFuLL) >> 32)},
    {(VUINT32) ((0xA3EA69BB81B6C52BuLL) >> 0),
     (VUINT32) ((0xA3EA69BB81B6C52BuLL) >> 32)},
    {(VUINT32) ((0x3278872083FCA2C7uLL) >> 0),
     (VUINT32) ((0x3278872083FCA2C7uLL) >> 32)}},
   {{(VUINT32) ((0xB9391054A7F09D5FuLL) >> 0),
     (VUINT32) ((0xB9391054A7F09D5FuLL) >> 32)},
    {(VUINT32) ((0x47D4D377036D8A56uLL) >> 0),
     (VUINT32) ((0x47D4D377036D8A56uLL) >> 32)},
    {(VUINT32) ((0x64F10E4107F9458EuLL) >> 0),
     (VUINT32) ((0x64F10E4107F9458EuLL) >> 32)}},
   {{(VUINT32) ((0x727220A94FE13ABEuLL) >> 0),
     (VUINT32) ((0x727220A94FE13ABEuLL) >> 32)},
    {(VUINT32) ((0x8FA9A6EE06DB14ACuLL) >> 0),
     (VUINT32) ((0x8FA9A6EE06DB14ACuLL) >> 32)},
    {(VUINT32) ((0xC9E21C820FF28B1DuLL) >> 0),
     (VUINT32) ((0xC9E21C820FF28B1DuLL) >> 32)}},
   {{(VUINT32) ((0xE4E441529FC2757DuLL) >> 0),
     (VUINT32) ((0xE4E441529FC2757DuLL) >> 32)},
    {(VUINT32) ((0x1F534DDC0DB62959uLL) >> 0),
     (VUINT32) ((0x1F534DDC0DB62959uLL) >> 32)},
    {(VUINT32) ((0x93C439041FE5163AuLL) >> 0),
     (VUINT32) ((0x93C439041FE5163AuLL) >> 32)}},
   {{(VUINT32) ((0xC9C882A53F84EAFAuLL) >> 0),
     (VUINT32) ((0xC9C882A53F84EAFAuLL) >> 32)},
    {(VUINT32) ((0x3EA69BB81B6C52B3uLL) >> 0),
     (VUINT32) ((0x3EA69BB81B6C52B3uLL) >> 32)},
    {(VUINT32) ((0x278872083FCA2C75uLL) >> 0),
     (VUINT32) ((0x278872083FCA2C75uLL) >> 32)}},
   {{(VUINT32) ((0x9391054A7F09D5F4uLL) >> 0),
     (VUINT32) ((0x9391054A7F09D5F4uLL) >> 32)},
    {(VUINT32) ((0x7D4D377036D8A566uLL) >> 0),
     (VUINT32) ((0x7D4D377036D8A566uLL) >> 32)},
    {(VUINT32) ((0x4F10E4107F9458EAuLL) >> 0),
     (VUINT32) ((0x4F10E4107F9458EAuLL) >> 32)}},
   {{(VUINT32) ((0x27220A94FE13ABE8uLL) >> 0),
     (VUINT32) ((0x27220A94FE13ABE8uLL) >> 32)},
    {(VUINT32) ((0xFA9A6EE06DB14ACCuLL) >> 0),
     (VUINT32) ((0xFA9A6EE06DB14ACCuLL) >> 32)},
    {(VUINT32) ((0x9E21C820FF28B1D5uLL) >> 0),
     (VUINT32) ((0x9E21C820FF28B1D5uLL) >> 32)}},
   {{(VUINT32) ((0x4E441529FC2757D1uLL) >> 0),
     (VUINT32) ((0x4E441529FC2757D1uLL) >> 32)},
    {(VUINT32) ((0xF534DDC0DB629599uLL) >> 0),
     (VUINT32) ((0xF534DDC0DB629599uLL) >> 32)},
    {(VUINT32) ((0x3C439041FE5163ABuLL) >> 0),
     (VUINT32) ((0x3C439041FE5163ABuLL) >> 32)}},
   {{(VUINT32) ((0x9C882A53F84EAFA3uLL) >> 0),
     (VUINT32) ((0x9C882A53F84EAFA3uLL) >> 32)},
    {(VUINT32) ((0xEA69BB81B6C52B32uLL) >> 0),
     (VUINT32) ((0xEA69BB81B6C52B32uLL) >> 32)},
    {(VUINT32) ((0x78872083FCA2C757uLL) >> 0),
     (VUINT32) ((0x78872083FCA2C757uLL) >> 32)}},
   {{(VUINT32) ((0x391054A7F09D5F47uLL) >> 0),
     (VUINT32) ((0x391054A7F09D5F47uLL) >> 32)},
    {(VUINT32) ((0xD4D377036D8A5664uLL) >> 0),
     (VUINT32) ((0xD4D377036D8A5664uLL) >> 32)},
    {(VUINT32) ((0xF10E4107F9458EAFuLL) >> 0),
     (VUINT32) ((0xF10E4107F9458EAFuLL) >> 32)}},
   {{(VUINT32) ((0x7220A94FE13ABE8FuLL) >> 0),
     (VUINT32) ((0x7220A94FE13ABE8FuLL) >> 32)},
    {(VUINT32) ((0xA9A6EE06DB14ACC9uLL) >> 0),
     (VUINT32) ((0xA9A6EE06DB14ACC9uLL) >> 32)},
    {(VUINT32) ((0xE21C820FF28B1D5EuLL) >> 0),
     (VUINT32) ((0xE21C820FF28B1D5EuLL) >> 32)}},
   {{(VUINT32) ((0xE441529FC2757D1FuLL) >> 0),
     (VUINT32) ((0xE441529FC2757D1FuLL) >> 32)},
    {(VUINT32) ((0x534DDC0DB6295993uLL) >> 0),
     (VUINT32) ((0x534DDC0DB6295993uLL) >> 32)},
    {(VUINT32) ((0xC439041FE5163ABDuLL) >> 0),
     (VUINT32) ((0xC439041FE5163ABDuLL) >> 32)}},
   {{(VUINT32) ((0xC882A53F84EAFA3EuLL) >> 0),
     (VUINT32) ((0xC882A53F84EAFA3EuLL) >> 32)},
    {(VUINT32) ((0xA69BB81B6C52B327uLL) >> 0),
     (VUINT32) ((0xA69BB81B6C52B327uLL) >> 32)},
    {(VUINT32) ((0x8872083FCA2C757BuLL) >> 0),
     (VUINT32) ((0x8872083FCA2C757BuLL) >> 32)}},
   {{(VUINT32) ((0x91054A7F09D5F47DuLL) >> 0),
     (VUINT32) ((0x91054A7F09D5F47DuLL) >> 32)},
    {(VUINT32) ((0x4D377036D8A5664FuLL) >> 0),
     (VUINT32) ((0x4D377036D8A5664FuLL) >> 32)},
    {(VUINT32) ((0x10E4107F9458EAF7uLL) >> 0),
     (VUINT32) ((0x10E4107F9458EAF7uLL) >> 32)}},
   {{(VUINT32) ((0x220A94FE13ABE8FAuLL) >> 0),
     (VUINT32) ((0x220A94FE13ABE8FAuLL) >> 32)},
    {(VUINT32) ((0x9A6EE06DB14ACC9EuLL) >> 0),
     (VUINT32) ((0x9A6EE06DB14ACC9EuLL) >> 32)},
    {(VUINT32) ((0x21C820FF28B1D5EFuLL) >> 0),
     (VUINT32) ((0x21C820FF28B1D5EFuLL) >> 32)}},
   {{(VUINT32) ((0x441529FC2757D1F5uLL) >> 0),
     (VUINT32) ((0x441529FC2757D1F5uLL) >> 32)},
    {(VUINT32) ((0x34DDC0DB6295993CuLL) >> 0),
     (VUINT32) ((0x34DDC0DB6295993CuLL) >> 32)},
    {(VUINT32) ((0x439041FE5163ABDEuLL) >> 0),
     (VUINT32) ((0x439041FE5163ABDEuLL) >> 32)}},
   {{(VUINT32) ((0x882A53F84EAFA3EAuLL) >> 0),
     (VUINT32) ((0x882A53F84EAFA3EAuLL) >> 32)},
    {(VUINT32) ((0x69BB81B6C52B3278uLL) >> 0),
     (VUINT32) ((0x69BB81B6C52B3278uLL) >> 32)},
    {(VUINT32) ((0x872083FCA2C757BDuLL) >> 0),
     (VUINT32) ((0x872083FCA2C757BDuLL) >> 32)}},
   {{(VUINT32) ((0x1054A7F09D5F47D4uLL) >> 0),
     (VUINT32) ((0x1054A7F09D5F47D4uLL) >> 32)},
    {(VUINT32) ((0xD377036D8A5664F1uLL) >> 0),
     (VUINT32) ((0xD377036D8A5664F1uLL) >> 32)},
    {(VUINT32) ((0x0E4107F9458EAF7AuLL) >> 0),
     (VUINT32) ((0x0E4107F9458EAF7AuLL) >> 32)}},
   {{(VUINT32) ((0x20A94FE13ABE8FA9uLL) >> 0),
     (VUINT32) ((0x20A94FE13ABE8FA9uLL) >> 32)},
    {(VUINT32) ((0xA6EE06DB14ACC9E2uLL) >> 0),
     (VUINT32) ((0xA6EE06DB14ACC9E2uLL) >> 32)},
    {(VUINT32) ((0x1C820FF28B1D5EF5uLL) >> 0),
     (VUINT32) ((0x1C820FF28B1D5EF5uLL) >> 32)}},
   {{(VUINT32) ((0x41529FC2757D1F53uLL) >> 0),
     (VUINT32) ((0x41529FC2757D1F53uLL) >> 32)},
    {(VUINT32) ((0x4DDC0DB6295993C4uLL) >> 0),
     (VUINT32) ((0x4DDC0DB6295993C4uLL) >> 32)},
    {(VUINT32) ((0x39041FE5163ABDEBuLL) >> 0),
     (VUINT32) ((0x39041FE5163ABDEBuLL) >> 32)}},
   {{(VUINT32) ((0x82A53F84EAFA3EA6uLL) >> 0),
     (VUINT32) ((0x82A53F84EAFA3EA6uLL) >> 32)},
    {(VUINT32) ((0x9BB81B6C52B32788uLL) >> 0),
     (VUINT32) ((0x9BB81B6C52B32788uLL) >> 32)},
    {(VUINT32) ((0x72083FCA2C757BD7uLL) >> 0),
     (VUINT32) ((0x72083FCA2C757BD7uLL) >> 32)}},
   {{(VUINT32) ((0x054A7F09D5F47D4DuLL) >> 0),
     (VUINT32) ((0x054A7F09D5F47D4DuLL) >> 32)},
    {(VUINT32) ((0x377036D8A5664F10uLL) >> 0),
     (VUINT32) ((0x377036D8A5664F10uLL) >> 32)},
    {(VUINT32) ((0xE4107F9458EAF7AEuLL) >> 0),
     (VUINT32) ((0xE4107F9458EAF7AEuLL) >> 32)}},
   {{(VUINT32) ((0x0A94FE13ABE8FA9AuLL) >> 0),
     (VUINT32) ((0x0A94FE13ABE8FA9AuLL) >> 32)},
    {(VUINT32) ((0x6EE06DB14ACC9E21uLL) >> 0),
     (VUINT32) ((0x6EE06DB14ACC9E21uLL) >> 32)},
    {(VUINT32) ((0xC820FF28B1D5EF5DuLL) >> 0),
     (VUINT32) ((0xC820FF28B1D5EF5DuLL) >> 32)}},
   {{(VUINT32) ((0x1529FC2757D1F534uLL) >> 0),
     (VUINT32) ((0x1529FC2757D1F534uLL) >> 32)},
    {(VUINT32) ((0xDDC0DB6295993C43uLL) >> 0),
     (VUINT32) ((0xDDC0DB6295993C43uLL) >> 32)},
    {(VUINT32) ((0x9041FE5163ABDEBBuLL) >> 0),
     (VUINT32) ((0x9041FE5163ABDEBBuLL) >> 32)}},
   {{(VUINT32) ((0x2A53F84EAFA3EA69uLL) >> 0),
     (VUINT32) ((0x2A53F84EAFA3EA69uLL) >> 32)},
    {(VUINT32) ((0xBB81B6C52B327887uLL) >> 0),
     (VUINT32) ((0xBB81B6C52B327887uLL) >> 32)},
    {(VUINT32) ((0x2083FCA2C757BD77uLL) >> 0),
     (VUINT32) ((0x2083FCA2C757BD77uLL) >> 32)}},
   {{(VUINT32) ((0x54A7F09D5F47D4D3uLL) >> 0),
     (VUINT32) ((0x54A7F09D5F47D4D3uLL) >> 32)},
    {(VUINT32) ((0x77036D8A5664F10EuLL) >> 0),
     (VUINT32) ((0x77036D8A5664F10EuLL) >> 32)},
    {(VUINT32) ((0x4107F9458EAF7AEFuLL) >> 0),
     (VUINT32) ((0x4107F9458EAF7AEFuLL) >> 32)}},
   {{(VUINT32) ((0xA94FE13ABE8FA9A6uLL) >> 0),
     (VUINT32) ((0xA94FE13ABE8FA9A6uLL) >> 32)},
    {(VUINT32) ((0xEE06DB14ACC9E21CuLL) >> 0),
     (VUINT32) ((0xEE06DB14ACC9E21CuLL) >> 32)},
    {(VUINT32) ((0x820FF28B1D5EF5DEuLL) >> 0),
     (VUINT32) ((0x820FF28B1D5EF5DEuLL) >> 32)}},
   {{(VUINT32) ((0x529FC2757D1F534DuLL) >> 0),
     (VUINT32) ((0x529FC2757D1F534DuLL) >> 32)},
    {(VUINT32) ((0xDC0DB6295993C439uLL) >> 0),
     (VUINT32) ((0xDC0DB6295993C439uLL) >> 32)},
    {(VUINT32) ((0x041FE5163ABDEBBCuLL) >> 0),
     (VUINT32) ((0x041FE5163ABDEBBCuLL) >> 32)}},
   {{(VUINT32) ((0xA53F84EAFA3EA69BuLL) >> 0),
     (VUINT32) ((0xA53F84EAFA3EA69BuLL) >> 32)},
    {(VUINT32) ((0xB81B6C52B3278872uLL) >> 0),
     (VUINT32) ((0xB81B6C52B3278872uLL) >> 32)},
    {(VUINT32) ((0x083FCA2C757BD778uLL) >> 0),
     (VUINT32) ((0x083FCA2C757BD778uLL) >> 32)}},
   {{(VUINT32) ((0x4A7F09D5F47D4D37uLL) >> 0),
     (VUINT32) ((0x4A7F09D5F47D4D37uLL) >> 32)},
    {(VUINT32) ((0x7036D8A5664F10E4uLL) >> 0),
     (VUINT32) ((0x7036D8A5664F10E4uLL) >> 32)},
    {(VUINT32) ((0x107F9458EAF7AEF1uLL) >> 0),
     (VUINT32) ((0x107F9458EAF7AEF1uLL) >> 32)}},
   {{(VUINT32) ((0x94FE13ABE8FA9A6EuLL) >> 0),
     (VUINT32) ((0x94FE13ABE8FA9A6EuLL) >> 32)},
    {(VUINT32) ((0xE06DB14ACC9E21C8uLL) >> 0),
     (VUINT32) ((0xE06DB14ACC9E21C8uLL) >> 32)},
    {(VUINT32) ((0x20FF28B1D5EF5DE2uLL) >> 0),
     (VUINT32) ((0x20FF28B1D5EF5DE2uLL) >> 32)}},
   {{(VUINT32) ((0x29FC2757D1F534DDuLL) >> 0),
     (VUINT32) ((0x29FC2757D1F534DDuLL) >> 32)},
    {(VUINT32) ((0xC0DB6295993C4390uLL) >> 0),
     (VUINT32) ((0xC0DB6295993C4390uLL) >> 32)},
    {(VUINT32) ((0x41FE5163ABDEBBC5uLL) >> 0),
     (VUINT32) ((0x41FE5163ABDEBBC5uLL) >> 32)}},
   {{(VUINT32) ((0x53F84EAFA3EA69BBuLL) >> 0),
     (VUINT32) ((0x53F84EAFA3EA69BBuLL) >> 32)},
    {(VUINT32) ((0x81B6C52B32788720uLL) >> 0),
     (VUINT32) ((0x81B6C52B32788720uLL) >> 32)},
    {(VUINT32) ((0x83FCA2C757BD778AuLL) >> 0),
     (VUINT32) ((0x83FCA2C757BD778AuLL) >> 32)}},
   {{(VUINT32) ((0xA7F09D5F47D4D377uLL) >> 0),
     (VUINT32) ((0xA7F09D5F47D4D377uLL) >> 32)},
    {(VUINT32) ((0x036D8A5664F10E41uLL) >> 0),
     (VUINT32) ((0x036D8A5664F10E41uLL) >> 32)},
    {(VUINT32) ((0x07F9458EAF7AEF15uLL) >> 0),
     (VUINT32) ((0x07F9458EAF7AEF15uLL) >> 32)}},
   {{(VUINT32) ((0x4FE13ABE8FA9A6EEuLL) >> 0),
     (VUINT32) ((0x4FE13ABE8FA9A6EEuLL) >> 32)},
    {(VUINT32) ((0x06DB14ACC9E21C82uLL) >> 0),
     (VUINT32) ((0x06DB14ACC9E21C82uLL) >> 32)},
    {(VUINT32) ((0x0FF28B1D5EF5DE2BuLL) >> 0),
     (VUINT32) ((0x0FF28B1D5EF5DE2BuLL) >> 32)}},
   {{(VUINT32) ((0x9FC2757D1F534DDCuLL) >> 0),
     (VUINT32) ((0x9FC2757D1F534DDCuLL) >> 32)},
    {(VUINT32) ((0x0DB6295993C43904uLL) >> 0),
     (VUINT32) ((0x0DB6295993C43904uLL) >> 32)},
    {(VUINT32) ((0x1FE5163ABDEBBC56uLL) >> 0),
     (VUINT32) ((0x1FE5163ABDEBBC56uLL) >> 32)}},
   {{(VUINT32) ((0x3F84EAFA3EA69BB8uLL) >> 0),
     (VUINT32) ((0x3F84EAFA3EA69BB8uLL) >> 32)},
    {(VUINT32) ((0x1B6C52B327887208uLL) >> 0),
     (VUINT32) ((0x1B6C52B327887208uLL) >> 32)},
    {(VUINT32) ((0x3FCA2C757BD778ACuLL) >> 0),
     (VUINT32) ((0x3FCA2C757BD778ACuLL) >> 32)}},
   {{(VUINT32) ((0x7F09D5F47D4D3770uLL) >> 0),
     (VUINT32) ((0x7F09D5F47D4D3770uLL) >> 32)},
    {(VUINT32) ((0x36D8A5664F10E410uLL) >> 0),
     (VUINT32) ((0x36D8A5664F10E410uLL) >> 32)},
    {(VUINT32) ((0x7F9458EAF7AEF158uLL) >> 0),
     (VUINT32) ((0x7F9458EAF7AEF158uLL) >> 32)}},
   {{(VUINT32) ((0xFE13ABE8FA9A6EE0uLL) >> 0),
     (VUINT32) ((0xFE13ABE8FA9A6EE0uLL) >> 32)},
    {(VUINT32) ((0x6DB14ACC9E21C820uLL) >> 0),
     (VUINT32) ((0x6DB14ACC9E21C820uLL) >> 32)},
    {(VUINT32) ((0xFF28B1D5EF5DE2B0uLL) >> 0),
     (VUINT32) ((0xFF28B1D5EF5DE2B0uLL) >> 32)}},
   {{(VUINT32) ((0xFC2757D1F534DDC0uLL) >> 0),
     (VUINT32) ((0xFC2757D1F534DDC0uLL) >> 32)},
    {(VUINT32) ((0xDB6295993C439041uLL) >> 0),
     (VUINT32) ((0xDB6295993C439041uLL) >> 32)},
    {(VUINT32) ((0xFE5163ABDEBBC561uLL) >> 0),
     (VUINT32) ((0xFE5163ABDEBBC561uLL) >> 32)}},
   {{(VUINT32) ((0xF84EAFA3EA69BB81uLL) >> 0),
     (VUINT32) ((0xF84EAFA3EA69BB81uLL) >> 32)},
    {(VUINT32) ((0xB6C52B3278872083uLL) >> 0),
     (VUINT32) ((0xB6C52B3278872083uLL) >> 32)},
    {(VUINT32) ((0xFCA2C757BD778AC3uLL) >> 0),
     (VUINT32) ((0xFCA2C757BD778AC3uLL) >> 32)}},
   {{(VUINT32) ((0xF09D5F47D4D37703uLL) >> 0),
     (VUINT32) ((0xF09D5F47D4D37703uLL) >> 32)},
    {(VUINT32) ((0x6D8A5664F10E4107uLL) >> 0),
     (VUINT32) ((0x6D8A5664F10E4107uLL) >> 32)},
    {(VUINT32) ((0xF9458EAF7AEF1586uLL) >> 0),
     (VUINT32) ((0xF9458EAF7AEF1586uLL) >> 32)}},
   {{(VUINT32) ((0xE13ABE8FA9A6EE06uLL) >> 0),
     (VUINT32) ((0xE13ABE8FA9A6EE06uLL) >> 32)},
    {(VUINT32) ((0xDB14ACC9E21C820FuLL) >> 0),
     (VUINT32) ((0xDB14ACC9E21C820FuLL) >> 32)},
    {(VUINT32) ((0xF28B1D5EF5DE2B0DuLL) >> 0),
     (VUINT32) ((0xF28B1D5EF5DE2B0DuLL) >> 32)}},
   {{(VUINT32) ((0xC2757D1F534DDC0DuLL) >> 0),
     (VUINT32) ((0xC2757D1F534DDC0DuLL) >> 32)},
    {(VUINT32) ((0xB6295993C439041FuLL) >> 0),
     (VUINT32) ((0xB6295993C439041FuLL) >> 32)},
    {(VUINT32) ((0xE5163ABDEBBC561BuLL) >> 0),
     (VUINT32) ((0xE5163ABDEBBC561BuLL) >> 32)}},
   {{(VUINT32) ((0x84EAFA3EA69BB81BuLL) >> 0),
     (VUINT32) ((0x84EAFA3EA69BB81BuLL) >> 32)},
    {(VUINT32) ((0x6C52B3278872083FuLL) >> 0),
     (VUINT32) ((0x6C52B3278872083FuLL) >> 32)},
    {(VUINT32) ((0xCA2C757BD778AC36uLL) >> 0),
     (VUINT32) ((0xCA2C757BD778AC36uLL) >> 32)}},
   {{(VUINT32) ((0x09D5F47D4D377036uLL) >> 0),
     (VUINT32) ((0x09D5F47D4D377036uLL) >> 32)},
    {(VUINT32) ((0xD8A5664F10E4107FuLL) >> 0),
     (VUINT32) ((0xD8A5664F10E4107FuLL) >> 32)},
    {(VUINT32) ((0x9458EAF7AEF1586DuLL) >> 0),
     (VUINT32) ((0x9458EAF7AEF1586DuLL) >> 32)}},
   {{(VUINT32) ((0x13ABE8FA9A6EE06DuLL) >> 0),
     (VUINT32) ((0x13ABE8FA9A6EE06DuLL) >> 32)},
    {(VUINT32) ((0xB14ACC9E21C820FFuLL) >> 0),
     (VUINT32) ((0xB14ACC9E21C820FFuLL) >> 32)},
    {(VUINT32) ((0x28B1D5EF5DE2B0DBuLL) >> 0),
     (VUINT32) ((0x28B1D5EF5DE2B0DBuLL) >> 32)}},
   {{(VUINT32) ((0x2757D1F534DDC0DBuLL) >> 0),
     (VUINT32) ((0x2757D1F534DDC0DBuLL) >> 32)},
    {(VUINT32) ((0x6295993C439041FEuLL) >> 0),
     (VUINT32) ((0x6295993C439041FEuLL) >> 32)},
    {(VUINT32) ((0x5163ABDEBBC561B7uLL) >> 0),
     (VUINT32) ((0x5163ABDEBBC561B7uLL) >> 32)}},
   {{(VUINT32) ((0x4EAFA3EA69BB81B6uLL) >> 0),
     (VUINT32) ((0x4EAFA3EA69BB81B6uLL) >> 32)},
    {(VUINT32) ((0xC52B3278872083FCuLL) >> 0),
     (VUINT32) ((0xC52B3278872083FCuLL) >> 32)},
    {(VUINT32) ((0xA2C757BD778AC36EuLL) >> 0),
     (VUINT32) ((0xA2C757BD778AC36EuLL) >> 32)}},
   {{(VUINT32) ((0x9D5F47D4D377036DuLL) >> 0),
     (VUINT32) ((0x9D5F47D4D377036DuLL) >> 32)},
    {(VUINT32) ((0x8A5664F10E4107F9uLL) >> 0),
     (VUINT32) ((0x8A5664F10E4107F9uLL) >> 32)},
    {(VUINT32) ((0x458EAF7AEF1586DCuLL) >> 0),
     (VUINT32) ((0x458EAF7AEF1586DCuLL) >> 32)}},
   {{(VUINT32) ((0x3ABE8FA9A6EE06DBuLL) >> 0),
     (VUINT32) ((0x3ABE8FA9A6EE06DBuLL) >> 32)},
    {(VUINT32) ((0x14ACC9E21C820FF2uLL) >> 0),
     (VUINT32) ((0x14ACC9E21C820FF2uLL) >> 32)},
    {(VUINT32) ((0x8B1D5EF5DE2B0DB9uLL) >> 0),
     (VUINT32) ((0x8B1D5EF5DE2B0DB9uLL) >> 32)}},
   {{(VUINT32) ((0x757D1F534DDC0DB6uLL) >> 0),
     (VUINT32) ((0x757D1F534DDC0DB6uLL) >> 32)},
    {(VUINT32) ((0x295993C439041FE5uLL) >> 0),
     (VUINT32) ((0x295993C439041FE5uLL) >> 32)},
    {(VUINT32) ((0x163ABDEBBC561B72uLL) >> 0),
     (VUINT32) ((0x163ABDEBBC561B72uLL) >> 32)}},
   {{(VUINT32) ((0xEAFA3EA69BB81B6CuLL) >> 0),
     (VUINT32) ((0xEAFA3EA69BB81B6CuLL) >> 32)},
    {(VUINT32) ((0x52B3278872083FCAuLL) >> 0),
     (VUINT32) ((0x52B3278872083FCAuLL) >> 32)},
    {(VUINT32) ((0x2C757BD778AC36E4uLL) >> 0),
     (VUINT32) ((0x2C757BD778AC36E4uLL) >> 32)}},
   {{(VUINT32) ((0xD5F47D4D377036D8uLL) >> 0),
     (VUINT32) ((0xD5F47D4D377036D8uLL) >> 32)},
    {(VUINT32) ((0xA5664F10E4107F94uLL) >> 0),
     (VUINT32) ((0xA5664F10E4107F94uLL) >> 32)},
    {(VUINT32) ((0x58EAF7AEF1586DC9uLL) >> 0),
     (VUINT32) ((0x58EAF7AEF1586DC9uLL) >> 32)}},
   {{(VUINT32) ((0xABE8FA9A6EE06DB1uLL) >> 0),
     (VUINT32) ((0xABE8FA9A6EE06DB1uLL) >> 32)},
    {(VUINT32) ((0x4ACC9E21C820FF28uLL) >> 0),
     (VUINT32) ((0x4ACC9E21C820FF28uLL) >> 32)},
    {(VUINT32) ((0xB1D5EF5DE2B0DB92uLL) >> 0),
     (VUINT32) ((0xB1D5EF5DE2B0DB92uLL) >> 32)}},
   {{(VUINT32) ((0x57D1F534DDC0DB62uLL) >> 0),
     (VUINT32) ((0x57D1F534DDC0DB62uLL) >> 32)},
    {(VUINT32) ((0x95993C439041FE51uLL) >> 0),
     (VUINT32) ((0x95993C439041FE51uLL) >> 32)},
    {(VUINT32) ((0x63ABDEBBC561B724uLL) >> 0),
     (VUINT32) ((0x63ABDEBBC561B724uLL) >> 32)}},
   {{(VUINT32) ((0xAFA3EA69BB81B6C5uLL) >> 0),
     (VUINT32) ((0xAFA3EA69BB81B6C5uLL) >> 32)},
    {(VUINT32) ((0x2B3278872083FCA2uLL) >> 0),
     (VUINT32) ((0x2B3278872083FCA2uLL) >> 32)},
    {(VUINT32) ((0xC757BD778AC36E48uLL) >> 0),
     (VUINT32) ((0xC757BD778AC36E48uLL) >> 32)}},
   {{(VUINT32) ((0x5F47D4D377036D8AuLL) >> 0),
     (VUINT32) ((0x5F47D4D377036D8AuLL) >> 32)},
    {(VUINT32) ((0x5664F10E4107F945uLL) >> 0),
     (VUINT32) ((0x5664F10E4107F945uLL) >> 32)},
    {(VUINT32) ((0x8EAF7AEF1586DC91uLL) >> 0),
     (VUINT32) ((0x8EAF7AEF1586DC91uLL) >> 32)}},
   {{(VUINT32) ((0xBE8FA9A6EE06DB14uLL) >> 0),
     (VUINT32) ((0xBE8FA9A6EE06DB14uLL) >> 32)},
    {(VUINT32) ((0xACC9E21C820FF28BuLL) >> 0),
     (VUINT32) ((0xACC9E21C820FF28BuLL) >> 32)},
    {(VUINT32) ((0x1D5EF5DE2B0DB923uLL) >> 0),
     (VUINT32) ((0x1D5EF5DE2B0DB923uLL) >> 32)}},
   {{(VUINT32) ((0x7D1F534DDC0DB629uLL) >> 0),
     (VUINT32) ((0x7D1F534DDC0DB629uLL) >> 32)},
    {(VUINT32) ((0x5993C439041FE516uLL) >> 0),
     (VUINT32) ((0x5993C439041FE516uLL) >> 32)},
    {(VUINT32) ((0x3ABDEBBC561B7246uLL) >> 0),
     (VUINT32) ((0x3ABDEBBC561B7246uLL) >> 32)}},
   {{(VUINT32) ((0xFA3EA69BB81B6C52uLL) >> 0),
     (VUINT32) ((0xFA3EA69BB81B6C52uLL) >> 32)},
    {(VUINT32) ((0xB3278872083FCA2CuLL) >> 0),
     (VUINT32) ((0xB3278872083FCA2CuLL) >> 32)},
    {(VUINT32) ((0x757BD778AC36E48DuLL) >> 0),
     (VUINT32) ((0x757BD778AC36E48DuLL) >> 32)}},
   {{(VUINT32) ((0xF47D4D377036D8A5uLL) >> 0),
     (VUINT32) ((0xF47D4D377036D8A5uLL) >> 32)},
    {(VUINT32) ((0x664F10E4107F9458uLL) >> 0),
     (VUINT32) ((0x664F10E4107F9458uLL) >> 32)},
    {(VUINT32) ((0xEAF7AEF1586DC91BuLL) >> 0),
     (VUINT32) ((0xEAF7AEF1586DC91BuLL) >> 32)}},
   {{(VUINT32) ((0xE8FA9A6EE06DB14AuLL) >> 0),
     (VUINT32) ((0xE8FA9A6EE06DB14AuLL) >> 32)},
    {(VUINT32) ((0xCC9E21C820FF28B1uLL) >> 0),
     (VUINT32) ((0xCC9E21C820FF28B1uLL) >> 32)},
    {(VUINT32) ((0xD5EF5DE2B0DB9237uLL) >> 0),
     (VUINT32) ((0xD5EF5DE2B0DB9237uLL) >> 32)}},
   {{(VUINT32) ((0xD1F534DDC0DB6295uLL) >> 0),
     (VUINT32) ((0xD1F534DDC0DB6295uLL) >> 32)},
    {(VUINT32) ((0x993C439041FE5163uLL) >> 0),
     (VUINT32) ((0x993C439041FE5163uLL) >> 32)},
    {(VUINT32) ((0xABDEBBC561B7246EuLL) >> 0),
     (VUINT32) ((0xABDEBBC561B7246EuLL) >> 32)}},
   {{(VUINT32) ((0xA3EA69BB81B6C52BuLL) >> 0),
     (VUINT32) ((0xA3EA69BB81B6C52BuLL) >> 32)},
    {(VUINT32) ((0x3278872083FCA2C7uLL) >> 0),
     (VUINT32) ((0x3278872083FCA2C7uLL) >> 32)},
    {(VUINT32) ((0x57BD778AC36E48DCuLL) >> 0),
     (VUINT32) ((0x57BD778AC36E48DCuLL) >> 32)}},
   {{(VUINT32) ((0x47D4D377036D8A56uLL) >> 0),
     (VUINT32) ((0x47D4D377036D8A56uLL) >> 32)},
    {(VUINT32) ((0x64F10E4107F9458EuLL) >> 0),
     (VUINT32) ((0x64F10E4107F9458EuLL) >> 32)},
    {(VUINT32) ((0xAF7AEF1586DC91B8uLL) >> 0),
     (VUINT32) ((0xAF7AEF1586DC91B8uLL) >> 32)}},
   {{(VUINT32) ((0x8FA9A6EE06DB14ACuLL) >> 0),
     (VUINT32) ((0x8FA9A6EE06DB14ACuLL) >> 32)},
    {(VUINT32) ((0xC9E21C820FF28B1DuLL) >> 0),
     (VUINT32) ((0xC9E21C820FF28B1DuLL) >> 32)},
    {(VUINT32) ((0x5EF5DE2B0DB92371uLL) >> 0),
     (VUINT32) ((0x5EF5DE2B0DB92371uLL) >> 32)}},
   {{(VUINT32) ((0x1F534DDC0DB62959uLL) >> 0),
     (VUINT32) ((0x1F534DDC0DB62959uLL) >> 32)},
    {(VUINT32) ((0x93C439041FE5163AuLL) >> 0),
     (VUINT32) ((0x93C439041FE5163AuLL) >> 32)},
    {(VUINT32) ((0xBDEBBC561B7246E3uLL) >> 0),
     (VUINT32) ((0xBDEBBC561B7246E3uLL) >> 32)}},
   {{(VUINT32) ((0x3EA69BB81B6C52B3uLL) >> 0),
     (VUINT32) ((0x3EA69BB81B6C52B3uLL) >> 32)},
    {(VUINT32) ((0x278872083FCA2C75uLL) >> 0),
     (VUINT32) ((0x278872083FCA2C75uLL) >> 32)},
    {(VUINT32) ((0x7BD778AC36E48DC7uLL) >> 0),
     (VUINT32) ((0x7BD778AC36E48DC7uLL) >> 32)}},
   {{(VUINT32) ((0x7D4D377036D8A566uLL) >> 0),
     (VUINT32) ((0x7D4D377036D8A566uLL) >> 32)},
    {(VUINT32) ((0x4F10E4107F9458EAuLL) >> 0),
     (VUINT32) ((0x4F10E4107F9458EAuLL) >> 32)},
    {(VUINT32) ((0xF7AEF1586DC91B8EuLL) >> 0),
     (VUINT32) ((0xF7AEF1586DC91B8EuLL) >> 32)}},
   {{(VUINT32) ((0xFA9A6EE06DB14ACCuLL) >> 0),
     (VUINT32) ((0xFA9A6EE06DB14ACCuLL) >> 32)},
    {(VUINT32) ((0x9E21C820FF28B1D5uLL) >> 0),
     (VUINT32) ((0x9E21C820FF28B1D5uLL) >> 32)},
    {(VUINT32) ((0xEF5DE2B0DB92371DuLL) >> 0),
     (VUINT32) ((0xEF5DE2B0DB92371DuLL) >> 32)}},
   {{(VUINT32) ((0xF534DDC0DB629599uLL) >> 0),
     (VUINT32) ((0xF534DDC0DB629599uLL) >> 32)},
    {(VUINT32) ((0x3C439041FE5163ABuLL) >> 0),
     (VUINT32) ((0x3C439041FE5163ABuLL) >> 32)},
    {(VUINT32) ((0xDEBBC561B7246E3AuLL) >> 0),
     (VUINT32) ((0xDEBBC561B7246E3AuLL) >> 32)}},
   {{(VUINT32) ((0xEA69BB81B6C52B32uLL) >> 0),
     (VUINT32) ((0xEA69BB81B6C52B32uLL) >> 32)},
    {(VUINT32) ((0x78872083FCA2C757uLL) >> 0),
     (VUINT32) ((0x78872083FCA2C757uLL) >> 32)},
    {(VUINT32) ((0xBD778AC36E48DC74uLL) >> 0),
     (VUINT32) ((0xBD778AC36E48DC74uLL) >> 32)}},
   {{(VUINT32) ((0xD4D377036D8A5664uLL) >> 0),
     (VUINT32) ((0xD4D377036D8A5664uLL) >> 32)},
    {(VUINT32) ((0xF10E4107F9458EAFuLL) >> 0),
     (VUINT32) ((0xF10E4107F9458EAFuLL) >> 32)},
    {(VUINT32) ((0x7AEF1586DC91B8E9uLL) >> 0),
     (VUINT32) ((0x7AEF1586DC91B8E9uLL) >> 32)}},
   {{(VUINT32) ((0xA9A6EE06DB14ACC9uLL) >> 0),
     (VUINT32) ((0xA9A6EE06DB14ACC9uLL) >> 32)},
    {(VUINT32) ((0xE21C820FF28B1D5EuLL) >> 0),
     (VUINT32) ((0xE21C820FF28B1D5EuLL) >> 32)},
    {(VUINT32) ((0xF5DE2B0DB92371D2uLL) >> 0),
     (VUINT32) ((0xF5DE2B0DB92371D2uLL) >> 32)}},
   {{(VUINT32) ((0x534DDC0DB6295993uLL) >> 0),
     (VUINT32) ((0x534DDC0DB6295993uLL) >> 32)},
    {(VUINT32) ((0xC439041FE5163ABDuLL) >> 0),
     (VUINT32) ((0xC439041FE5163ABDuLL) >> 32)},
    {(VUINT32) ((0xEBBC561B7246E3A4uLL) >> 0),
     (VUINT32) ((0xEBBC561B7246E3A4uLL) >> 32)}},
   {{(VUINT32) ((0xA69BB81B6C52B327uLL) >> 0),
     (VUINT32) ((0xA69BB81B6C52B327uLL) >> 32)},
    {(VUINT32) ((0x8872083FCA2C757BuLL) >> 0),
     (VUINT32) ((0x8872083FCA2C757BuLL) >> 32)},
    {(VUINT32) ((0xD778AC36E48DC748uLL) >> 0),
     (VUINT32) ((0xD778AC36E48DC748uLL) >> 32)}},
   {{(VUINT32) ((0x4D377036D8A5664FuLL) >> 0),
     (VUINT32) ((0x4D377036D8A5664FuLL) >> 32)},
    {(VUINT32) ((0x10E4107F9458EAF7uLL) >> 0),
     (VUINT32) ((0x10E4107F9458EAF7uLL) >> 32)},
    {(VUINT32) ((0xAEF1586DC91B8E90uLL) >> 0),
     (VUINT32) ((0xAEF1586DC91B8E90uLL) >> 32)}},
   {{(VUINT32) ((0x9A6EE06DB14ACC9EuLL) >> 0),
     (VUINT32) ((0x9A6EE06DB14ACC9EuLL) >> 32)},
    {(VUINT32) ((0x21C820FF28B1D5EFuLL) >> 0),
     (VUINT32) ((0x21C820FF28B1D5EFuLL) >> 32)},
    {(VUINT32) ((0x5DE2B0DB92371D21uLL) >> 0),
     (VUINT32) ((0x5DE2B0DB92371D21uLL) >> 32)}},
   {{(VUINT32) ((0x34DDC0DB6295993CuLL) >> 0),
     (VUINT32) ((0x34DDC0DB6295993CuLL) >> 32)},
    {(VUINT32) ((0x439041FE5163ABDEuLL) >> 0),
     (VUINT32) ((0x439041FE5163ABDEuLL) >> 32)},
    {(VUINT32) ((0xBBC561B7246E3A42uLL) >> 0),
     (VUINT32) ((0xBBC561B7246E3A42uLL) >> 32)}},
   {{(VUINT32) ((0x69BB81B6C52B3278uLL) >> 0),
     (VUINT32) ((0x69BB81B6C52B3278uLL) >> 32)},
    {(VUINT32) ((0x872083FCA2C757BDuLL) >> 0),
     (VUINT32) ((0x872083FCA2C757BDuLL) >> 32)},
    {(VUINT32) ((0x778AC36E48DC7484uLL) >> 0),
     (VUINT32) ((0x778AC36E48DC7484uLL) >> 32)}},
   {{(VUINT32) ((0xD377036D8A5664F1uLL) >> 0),
     (VUINT32) ((0xD377036D8A5664F1uLL) >> 32)},
    {(VUINT32) ((0x0E4107F9458EAF7AuLL) >> 0),
     (VUINT32) ((0x0E4107F9458EAF7AuLL) >> 32)},
    {(VUINT32) ((0xEF1586DC91B8E909uLL) >> 0),
     (VUINT32) ((0xEF1586DC91B8E909uLL) >> 32)}},
   {{(VUINT32) ((0xA6EE06DB14ACC9E2uLL) >> 0),
     (VUINT32) ((0xA6EE06DB14ACC9E2uLL) >> 32)},
    {(VUINT32) ((0x1C820FF28B1D5EF5uLL) >> 0),
     (VUINT32) ((0x1C820FF28B1D5EF5uLL) >> 32)},
    {(VUINT32) ((0xDE2B0DB92371D212uLL) >> 0),
     (VUINT32) ((0xDE2B0DB92371D212uLL) >> 32)}},
   {{(VUINT32) ((0x4DDC0DB6295993C4uLL) >> 0),
     (VUINT32) ((0x4DDC0DB6295993C4uLL) >> 32)},
    {(VUINT32) ((0x39041FE5163ABDEBuLL) >> 0),
     (VUINT32) ((0x39041FE5163ABDEBuLL) >> 32)},
    {(VUINT32) ((0xBC561B7246E3A424uLL) >> 0),
     (VUINT32) ((0xBC561B7246E3A424uLL) >> 32)}},
   {{(VUINT32) ((0x9BB81B6C52B32788uLL) >> 0),
     (VUINT32) ((0x9BB81B6C52B32788uLL) >> 32)},
    {(VUINT32) ((0x72083FCA2C757BD7uLL) >> 0),
     (VUINT32) ((0x72083FCA2C757BD7uLL) >> 32)},
    {(VUINT32) ((0x78AC36E48DC74849uLL) >> 0),
     (VUINT32) ((0x78AC36E48DC74849uLL) >> 32)}},
   {{(VUINT32) ((0x377036D8A5664F10uLL) >> 0),
     (VUINT32) ((0x377036D8A5664F10uLL) >> 32)},
    {(VUINT32) ((0xE4107F9458EAF7AEuLL) >> 0),
     (VUINT32) ((0xE4107F9458EAF7AEuLL) >> 32)},
    {(VUINT32) ((0xF1586DC91B8E9093uLL) >> 0),
     (VUINT32) ((0xF1586DC91B8E9093uLL) >> 32)}},
   {{(VUINT32) ((0x6EE06DB14ACC9E21uLL) >> 0),
     (VUINT32) ((0x6EE06DB14ACC9E21uLL) >> 32)},
    {(VUINT32) ((0xC820FF28B1D5EF5DuLL) >> 0),
     (VUINT32) ((0xC820FF28B1D5EF5DuLL) >> 32)},
    {(VUINT32) ((0xE2B0DB92371D2126uLL) >> 0),
     (VUINT32) ((0xE2B0DB92371D2126uLL) >> 32)}},
   {{(VUINT32) ((0xDDC0DB6295993C43uLL) >> 0),
     (VUINT32) ((0xDDC0DB6295993C43uLL) >> 32)},
    {(VUINT32) ((0x9041FE5163ABDEBBuLL) >> 0),
     (VUINT32) ((0x9041FE5163ABDEBBuLL) >> 32)},
    {(VUINT32) ((0xC561B7246E3A424DuLL) >> 0),
     (VUINT32) ((0xC561B7246E3A424DuLL) >> 32)}},
   {{(VUINT32) ((0xBB81B6C52B327887uLL) >> 0),
     (VUINT32) ((0xBB81B6C52B327887uLL) >> 32)},
    {(VUINT32) ((0x2083FCA2C757BD77uLL) >> 0),
     (VUINT32) ((0x2083FCA2C757BD77uLL) >> 32)},
    {(VUINT32) ((0x8AC36E48DC74849BuLL) >> 0),
     (VUINT32) ((0x8AC36E48DC74849BuLL) >> 32)}},
   {{(VUINT32) ((0x77036D8A5664F10EuLL) >> 0),
     (VUINT32) ((0x77036D8A5664F10EuLL) >> 32)},
    {(VUINT32) ((0x4107F9458EAF7AEFuLL) >> 0),
     (VUINT32) ((0x4107F9458EAF7AEFuLL) >> 32)},
    {(VUINT32) ((0x1586DC91B8E90937uLL) >> 0),
     (VUINT32) ((0x1586DC91B8E90937uLL) >> 32)}},
   {{(VUINT32) ((0xEE06DB14ACC9E21CuLL) >> 0),
     (VUINT32) ((0xEE06DB14ACC9E21CuLL) >> 32)},
    {(VUINT32) ((0x820FF28B1D5EF5DEuLL) >> 0),
     (VUINT32) ((0x820FF28B1D5EF5DEuLL) >> 32)},
    {(VUINT32) ((0x2B0DB92371D2126EuLL) >> 0),
     (VUINT32) ((0x2B0DB92371D2126EuLL) >> 32)}},
   {{(VUINT32) ((0xDC0DB6295993C439uLL) >> 0),
     (VUINT32) ((0xDC0DB6295993C439uLL) >> 32)},
    {(VUINT32) ((0x041FE5163ABDEBBCuLL) >> 0),
     (VUINT32) ((0x041FE5163ABDEBBCuLL) >> 32)},
    {(VUINT32) ((0x561B7246E3A424DDuLL) >> 0),
     (VUINT32) ((0x561B7246E3A424DDuLL) >> 32)}},
   {{(VUINT32) ((0xB81B6C52B3278872uLL) >> 0),
     (VUINT32) ((0xB81B6C52B3278872uLL) >> 32)},
    {(VUINT32) ((0x083FCA2C757BD778uLL) >> 0),
     (VUINT32) ((0x083FCA2C757BD778uLL) >> 32)},
    {(VUINT32) ((0xAC36E48DC74849BAuLL) >> 0),
     (VUINT32) ((0xAC36E48DC74849BAuLL) >> 32)}},
   {{(VUINT32) ((0x7036D8A5664F10E4uLL) >> 0),
     (VUINT32) ((0x7036D8A5664F10E4uLL) >> 32)},
    {(VUINT32) ((0x107F9458EAF7AEF1uLL) >> 0),
     (VUINT32) ((0x107F9458EAF7AEF1uLL) >> 32)},
    {(VUINT32) ((0x586DC91B8E909374uLL) >> 0),
     (VUINT32) ((0x586DC91B8E909374uLL) >> 32)}},
   {{(VUINT32) ((0xE06DB14ACC9E21C8uLL) >> 0),
     (VUINT32) ((0xE06DB14ACC9E21C8uLL) >> 32)},
    {(VUINT32) ((0x20FF28B1D5EF5DE2uLL) >> 0),
     (VUINT32) ((0x20FF28B1D5EF5DE2uLL) >> 32)},
    {(VUINT32) ((0xB0DB92371D2126E9uLL) >> 0),
     (VUINT32) ((0xB0DB92371D2126E9uLL) >> 32)}},
   {{(VUINT32) ((0xC0DB6295993C4390uLL) >> 0),
     (VUINT32) ((0xC0DB6295993C4390uLL) >> 32)},
    {(VUINT32) ((0x41FE5163ABDEBBC5uLL) >> 0),
     (VUINT32) ((0x41FE5163ABDEBBC5uLL) >> 32)},
    {(VUINT32) ((0x61B7246E3A424DD2uLL) >> 0),
     (VUINT32) ((0x61B7246E3A424DD2uLL) >> 32)}},
   {{(VUINT32) ((0x81B6C52B32788720uLL) >> 0),
     (VUINT32) ((0x81B6C52B32788720uLL) >> 32)},
    {(VUINT32) ((0x83FCA2C757BD778AuLL) >> 0),
     (VUINT32) ((0x83FCA2C757BD778AuLL) >> 32)},
    {(VUINT32) ((0xC36E48DC74849BA5uLL) >> 0),
     (VUINT32) ((0xC36E48DC74849BA5uLL) >> 32)}},
   {{(VUINT32) ((0x036D8A5664F10E41uLL) >> 0),
     (VUINT32) ((0x036D8A5664F10E41uLL) >> 32)},
    {(VUINT32) ((0x07F9458EAF7AEF15uLL) >> 0),
     (VUINT32) ((0x07F9458EAF7AEF15uLL) >> 32)},
    {(VUINT32) ((0x86DC91B8E909374BuLL) >> 0),
     (VUINT32) ((0x86DC91B8E909374BuLL) >> 32)}},
   {{(VUINT32) ((0x06DB14ACC9E21C82uLL) >> 0),
     (VUINT32) ((0x06DB14ACC9E21C82uLL) >> 32)},
    {(VUINT32) ((0x0FF28B1D5EF5DE2BuLL) >> 0),
     (VUINT32) ((0x0FF28B1D5EF5DE2BuLL) >> 32)},
    {(VUINT32) ((0x0DB92371D2126E97uLL) >> 0),
     (VUINT32) ((0x0DB92371D2126E97uLL) >> 32)}},
   {{(VUINT32) ((0x0DB6295993C43904uLL) >> 0),
     (VUINT32) ((0x0DB6295993C43904uLL) >> 32)},
    {(VUINT32) ((0x1FE5163ABDEBBC56uLL) >> 0),
     (VUINT32) ((0x1FE5163ABDEBBC56uLL) >> 32)},
    {(VUINT32) ((0x1B7246E3A424DD2EuLL) >> 0),
     (VUINT32) ((0x1B7246E3A424DD2EuLL) >> 32)}},
   {{(VUINT32) ((0x1B6C52B327887208uLL) >> 0),
     (VUINT32) ((0x1B6C52B327887208uLL) >> 32)},
    {(VUINT32) ((0x3FCA2C757BD778ACuLL) >> 0),
     (VUINT32) ((0x3FCA2C757BD778ACuLL) >> 32)},
    {(VUINT32) ((0x36E48DC74849BA5CuLL) >> 0),
     (VUINT32) ((0x36E48DC74849BA5CuLL) >> 32)}},
   {{(VUINT32) ((0x36D8A5664F10E410uLL) >> 0),
     (VUINT32) ((0x36D8A5664F10E410uLL) >> 32)},
    {(VUINT32) ((0x7F9458EAF7AEF158uLL) >> 0),
     (VUINT32) ((0x7F9458EAF7AEF158uLL) >> 32)},
    {(VUINT32) ((0x6DC91B8E909374B8uLL) >> 0),
     (VUINT32) ((0x6DC91B8E909374B8uLL) >> 32)}},
   {{(VUINT32) ((0x6DB14ACC9E21C820uLL) >> 0),
     (VUINT32) ((0x6DB14ACC9E21C820uLL) >> 32)},
    {(VUINT32) ((0xFF28B1D5EF5DE2B0uLL) >> 0),
     (VUINT32) ((0xFF28B1D5EF5DE2B0uLL) >> 32)},
    {(VUINT32) ((0xDB92371D2126E970uLL) >> 0),
     (VUINT32) ((0xDB92371D2126E970uLL) >> 32)}},
   {{(VUINT32) ((0xDB6295993C439041uLL) >> 0),
     (VUINT32) ((0xDB6295993C439041uLL) >> 32)},
    {(VUINT32) ((0xFE5163ABDEBBC561uLL) >> 0),
     (VUINT32) ((0xFE5163ABDEBBC561uLL) >> 32)},
    {(VUINT32) ((0xB7246E3A424DD2E0uLL) >> 0),
     (VUINT32) ((0xB7246E3A424DD2E0uLL) >> 32)}},
   {{(VUINT32) ((0xB6C52B3278872083uLL) >> 0),
     (VUINT32) ((0xB6C52B3278872083uLL) >> 32)},
    {(VUINT32) ((0xFCA2C757BD778AC3uLL) >> 0),
     (VUINT32) ((0xFCA2C757BD778AC3uLL) >> 32)},
    {(VUINT32) ((0x6E48DC74849BA5C0uLL) >> 0),
     (VUINT32) ((0x6E48DC74849BA5C0uLL) >> 32)}},
   {{(VUINT32) ((0x6D8A5664F10E4107uLL) >> 0),
     (VUINT32) ((0x6D8A5664F10E4107uLL) >> 32)},
    {(VUINT32) ((0xF9458EAF7AEF1586uLL) >> 0),
     (VUINT32) ((0xF9458EAF7AEF1586uLL) >> 32)},
    {(VUINT32) ((0xDC91B8E909374B80uLL) >> 0),
     (VUINT32) ((0xDC91B8E909374B80uLL) >> 32)}},
   {{(VUINT32) ((0xDB14ACC9E21C820FuLL) >> 0),
     (VUINT32) ((0xDB14ACC9E21C820FuLL) >> 32)},
    {(VUINT32) ((0xF28B1D5EF5DE2B0DuLL) >> 0),
     (VUINT32) ((0xF28B1D5EF5DE2B0DuLL) >> 32)},
    {(VUINT32) ((0xB92371D2126E9700uLL) >> 0),
     (VUINT32) ((0xB92371D2126E9700uLL) >> 32)}},
   {{(VUINT32) ((0xB6295993C439041FuLL) >> 0),
     (VUINT32) ((0xB6295993C439041FuLL) >> 32)},
    {(VUINT32) ((0xE5163ABDEBBC561BuLL) >> 0),
     (VUINT32) ((0xE5163ABDEBBC561BuLL) >> 32)},
    {(VUINT32) ((0x7246E3A424DD2E00uLL) >> 0),
     (VUINT32) ((0x7246E3A424DD2E00uLL) >> 32)}},
   {{(VUINT32) ((0x6C52B3278872083FuLL) >> 0),
     (VUINT32) ((0x6C52B3278872083FuLL) >> 32)},
    {(VUINT32) ((0xCA2C757BD778AC36uLL) >> 0),
     (VUINT32) ((0xCA2C757BD778AC36uLL) >> 32)},
    {(VUINT32) ((0xE48DC74849BA5C00uLL) >> 0),
     (VUINT32) ((0xE48DC74849BA5C00uLL) >> 32)}},
   {{(VUINT32) ((0xD8A5664F10E4107FuLL) >> 0),
     (VUINT32) ((0xD8A5664F10E4107FuLL) >> 32)},
    {(VUINT32) ((0x9458EAF7AEF1586DuLL) >> 0),
     (VUINT32) ((0x9458EAF7AEF1586DuLL) >> 32)},
    {(VUINT32) ((0xC91B8E909374B801uLL) >> 0),
     (VUINT32) ((0xC91B8E909374B801uLL) >> 32)}},
   {{(VUINT32) ((0xB14ACC9E21C820FFuLL) >> 0),
     (VUINT32) ((0xB14ACC9E21C820FFuLL) >> 32)},
    {(VUINT32) ((0x28B1D5EF5DE2B0DBuLL) >> 0),
     (VUINT32) ((0x28B1D5EF5DE2B0DBuLL) >> 32)},
    {(VUINT32) ((0x92371D2126E97003uLL) >> 0),
     (VUINT32) ((0x92371D2126E97003uLL) >> 32)}},
   {{(VUINT32) ((0x6295993C439041FEuLL) >> 0),
     (VUINT32) ((0x6295993C439041FEuLL) >> 32)},
    {(VUINT32) ((0x5163ABDEBBC561B7uLL) >> 0),
     (VUINT32) ((0x5163ABDEBBC561B7uLL) >> 32)},
    {(VUINT32) ((0x246E3A424DD2E006uLL) >> 0),
     (VUINT32) ((0x246E3A424DD2E006uLL) >> 32)}},
   {{(VUINT32) ((0xC52B3278872083FCuLL) >> 0),
     (VUINT32) ((0xC52B3278872083FCuLL) >> 32)},
    {(VUINT32) ((0xA2C757BD778AC36EuLL) >> 0),
     (VUINT32) ((0xA2C757BD778AC36EuLL) >> 32)},
    {(VUINT32) ((0x48DC74849BA5C00CuLL) >> 0),
     (VUINT32) ((0x48DC74849BA5C00CuLL) >> 32)}},
   {{(VUINT32) ((0x8A5664F10E4107F9uLL) >> 0),
     (VUINT32) ((0x8A5664F10E4107F9uLL) >> 32)},
    {(VUINT32) ((0x458EAF7AEF1586DCuLL) >> 0),
     (VUINT32) ((0x458EAF7AEF1586DCuLL) >> 32)},
    {(VUINT32) ((0x91B8E909374B8019uLL) >> 0),
     (VUINT32) ((0x91B8E909374B8019uLL) >> 32)}},
   {{(VUINT32) ((0x14ACC9E21C820FF2uLL) >> 0),
     (VUINT32) ((0x14ACC9E21C820FF2uLL) >> 32)},
    {(VUINT32) ((0x8B1D5EF5DE2B0DB9uLL) >> 0),
     (VUINT32) ((0x8B1D5EF5DE2B0DB9uLL) >> 32)},
    {(VUINT32) ((0x2371D2126E970032uLL) >> 0),
     (VUINT32) ((0x2371D2126E970032uLL) >> 32)}},
   {{(VUINT32) ((0x295993C439041FE5uLL) >> 0),
     (VUINT32) ((0x295993C439041FE5uLL) >> 32)},
    {(VUINT32) ((0x163ABDEBBC561B72uLL) >> 0),
     (VUINT32) ((0x163ABDEBBC561B72uLL) >> 32)},
    {(VUINT32) ((0x46E3A424DD2E0064uLL) >> 0),
     (VUINT32) ((0x46E3A424DD2E0064uLL) >> 32)}},
   {{(VUINT32) ((0x52B3278872083FCAuLL) >> 0),
     (VUINT32) ((0x52B3278872083FCAuLL) >> 32)},
    {(VUINT32) ((0x2C757BD778AC36E4uLL) >> 0),
     (VUINT32) ((0x2C757BD778AC36E4uLL) >> 32)},
    {(VUINT32) ((0x8DC74849BA5C00C9uLL) >> 0),
     (VUINT32) ((0x8DC74849BA5C00C9uLL) >> 32)}},
   {{(VUINT32) ((0xA5664F10E4107F94uLL) >> 0),
     (VUINT32) ((0xA5664F10E4107F94uLL) >> 32)},
    {(VUINT32) ((0x58EAF7AEF1586DC9uLL) >> 0),
     (VUINT32) ((0x58EAF7AEF1586DC9uLL) >> 32)},
    {(VUINT32) ((0x1B8E909374B80192uLL) >> 0),
     (VUINT32) ((0x1B8E909374B80192uLL) >> 32)}},
   {{(VUINT32) ((0x4ACC9E21C820FF28uLL) >> 0),
     (VUINT32) ((0x4ACC9E21C820FF28uLL) >> 32)},
    {(VUINT32) ((0xB1D5EF5DE2B0DB92uLL) >> 0),
     (VUINT32) ((0xB1D5EF5DE2B0DB92uLL) >> 32)},
    {(VUINT32) ((0x371D2126E9700324uLL) >> 0),
     (VUINT32) ((0x371D2126E9700324uLL) >> 32)}},
   {{(VUINT32) ((0x95993C439041FE51uLL) >> 0),
     (VUINT32) ((0x95993C439041FE51uLL) >> 32)},
    {(VUINT32) ((0x63ABDEBBC561B724uLL) >> 0),
     (VUINT32) ((0x63ABDEBBC561B724uLL) >> 32)},
    {(VUINT32) ((0x6E3A424DD2E00649uLL) >> 0),
     (VUINT32) ((0x6E3A424DD2E00649uLL) >> 32)}},
   {{(VUINT32) ((0x2B3278872083FCA2uLL) >> 0),
     (VUINT32) ((0x2B3278872083FCA2uLL) >> 32)},
    {(VUINT32) ((0xC757BD778AC36E48uLL) >> 0),
     (VUINT32) ((0xC757BD778AC36E48uLL) >> 32)},
    {(VUINT32) ((0xDC74849BA5C00C92uLL) >> 0),
     (VUINT32) ((0xDC74849BA5C00C92uLL) >> 32)}},
   {{(VUINT32) ((0x5664F10E4107F945uLL) >> 0),
     (VUINT32) ((0x5664F10E4107F945uLL) >> 32)},
    {(VUINT32) ((0x8EAF7AEF1586DC91uLL) >> 0),
     (VUINT32) ((0x8EAF7AEF1586DC91uLL) >> 32)},
    {(VUINT32) ((0xB8E909374B801924uLL) >> 0),
     (VUINT32) ((0xB8E909374B801924uLL) >> 32)}},
   {{(VUINT32) ((0xACC9E21C820FF28BuLL) >> 0),
     (VUINT32) ((0xACC9E21C820FF28BuLL) >> 32)},
    {(VUINT32) ((0x1D5EF5DE2B0DB923uLL) >> 0),
     (VUINT32) ((0x1D5EF5DE2B0DB923uLL) >> 32)},
    {(VUINT32) ((0x71D2126E97003249uLL) >> 0),
     (VUINT32) ((0x71D2126E97003249uLL) >> 32)}},
   {{(VUINT32) ((0x5993C439041FE516uLL) >> 0),
     (VUINT32) ((0x5993C439041FE516uLL) >> 32)},
    {(VUINT32) ((0x3ABDEBBC561B7246uLL) >> 0),
     (VUINT32) ((0x3ABDEBBC561B7246uLL) >> 32)},
    {(VUINT32) ((0xE3A424DD2E006492uLL) >> 0),
     (VUINT32) ((0xE3A424DD2E006492uLL) >> 32)}},
   {{(VUINT32) ((0xB3278872083FCA2CuLL) >> 0),
     (VUINT32) ((0xB3278872083FCA2CuLL) >> 32)},
    {(VUINT32) ((0x757BD778AC36E48DuLL) >> 0),
     (VUINT32) ((0x757BD778AC36E48DuLL) >> 32)},
    {(VUINT32) ((0xC74849BA5C00C925uLL) >> 0),
     (VUINT32) ((0xC74849BA5C00C925uLL) >> 32)}},
   {{(VUINT32) ((0x664F10E4107F9458uLL) >> 0),
     (VUINT32) ((0x664F10E4107F9458uLL) >> 32)},
    {(VUINT32) ((0xEAF7AEF1586DC91BuLL) >> 0),
     (VUINT32) ((0xEAF7AEF1586DC91BuLL) >> 32)},
    {(VUINT32) ((0x8E909374B801924BuLL) >> 0),
     (VUINT32) ((0x8E909374B801924BuLL) >> 32)}},
   {{(VUINT32) ((0xCC9E21C820FF28B1uLL) >> 0),
     (VUINT32) ((0xCC9E21C820FF28B1uLL) >> 32)},
    {(VUINT32) ((0xD5EF5DE2B0DB9237uLL) >> 0),
     (VUINT32) ((0xD5EF5DE2B0DB9237uLL) >> 32)},
    {(VUINT32) ((0x1D2126E970032497uLL) >> 0),
     (VUINT32) ((0x1D2126E970032497uLL) >> 32)}},
   {{(VUINT32) ((0x993C439041FE5163uLL) >> 0),
     (VUINT32) ((0x993C439041FE5163uLL) >> 32)},
    {(VUINT32) ((0xABDEBBC561B7246EuLL) >> 0),
     (VUINT32) ((0xABDEBBC561B7246EuLL) >> 32)},
    {(VUINT32) ((0x3A424DD2E006492EuLL) >> 0),
     (VUINT32) ((0x3A424DD2E006492EuLL) >> 32)}},
   {{(VUINT32) ((0x3278872083FCA2C7uLL) >> 0),
     (VUINT32) ((0x3278872083FCA2C7uLL) >> 32)},
    {(VUINT32) ((0x57BD778AC36E48DCuLL) >> 0),
     (VUINT32) ((0x57BD778AC36E48DCuLL) >> 32)},
    {(VUINT32) ((0x74849BA5C00C925DuLL) >> 0),
     (VUINT32) ((0x74849BA5C00C925DuLL) >> 32)}},
   {{(VUINT32) ((0x64F10E4107F9458EuLL) >> 0),
     (VUINT32) ((0x64F10E4107F9458EuLL) >> 32)},
    {(VUINT32) ((0xAF7AEF1586DC91B8uLL) >> 0),
     (VUINT32) ((0xAF7AEF1586DC91B8uLL) >> 32)},
    {(VUINT32) ((0xE909374B801924BBuLL) >> 0),
     (VUINT32) ((0xE909374B801924BBuLL) >> 32)}},
   {{(VUINT32) ((0xC9E21C820FF28B1DuLL) >> 0),
     (VUINT32) ((0xC9E21C820FF28B1DuLL) >> 32)},
    {(VUINT32) ((0x5EF5DE2B0DB92371uLL) >> 0),
     (VUINT32) ((0x5EF5DE2B0DB92371uLL) >> 32)},
    {(VUINT32) ((0xD2126E9700324977uLL) >> 0),
     (VUINT32) ((0xD2126E9700324977uLL) >> 32)}},
   {{(VUINT32) ((0x93C439041FE5163AuLL) >> 0),
     (VUINT32) ((0x93C439041FE5163AuLL) >> 32)},
    {(VUINT32) ((0xBDEBBC561B7246E3uLL) >> 0),
     (VUINT32) ((0xBDEBBC561B7246E3uLL) >> 32)},
    {(VUINT32) ((0xA424DD2E006492EEuLL) >> 0),
     (VUINT32) ((0xA424DD2E006492EEuLL) >> 32)}},
   {{(VUINT32) ((0x278872083FCA2C75uLL) >> 0),
     (VUINT32) ((0x278872083FCA2C75uLL) >> 32)},
    {(VUINT32) ((0x7BD778AC36E48DC7uLL) >> 0),
     (VUINT32) ((0x7BD778AC36E48DC7uLL) >> 32)},
    {(VUINT32) ((0x4849BA5C00C925DDuLL) >> 0),
     (VUINT32) ((0x4849BA5C00C925DDuLL) >> 32)}},
   {{(VUINT32) ((0x4F10E4107F9458EAuLL) >> 0),
     (VUINT32) ((0x4F10E4107F9458EAuLL) >> 32)},
    {(VUINT32) ((0xF7AEF1586DC91B8EuLL) >> 0),
     (VUINT32) ((0xF7AEF1586DC91B8EuLL) >> 32)},
    {(VUINT32) ((0x909374B801924BBAuLL) >> 0),
     (VUINT32) ((0x909374B801924BBAuLL) >> 32)}},
   {{(VUINT32) ((0x9E21C820FF28B1D5uLL) >> 0),
     (VUINT32) ((0x9E21C820FF28B1D5uLL) >> 32)},
    {(VUINT32) ((0xEF5DE2B0DB92371DuLL) >> 0),
     (VUINT32) ((0xEF5DE2B0DB92371DuLL) >> 32)},
    {(VUINT32) ((0x2126E97003249775uLL) >> 0),
     (VUINT32) ((0x2126E97003249775uLL) >> 32)}},
   {{(VUINT32) ((0x3C439041FE5163ABuLL) >> 0),
     (VUINT32) ((0x3C439041FE5163ABuLL) >> 32)},
    {(VUINT32) ((0xDEBBC561B7246E3AuLL) >> 0),
     (VUINT32) ((0xDEBBC561B7246E3AuLL) >> 32)},
    {(VUINT32) ((0x424DD2E006492EEAuLL) >> 0),
     (VUINT32) ((0x424DD2E006492EEAuLL) >> 32)}},
   {{(VUINT32) ((0x78872083FCA2C757uLL) >> 0),
     (VUINT32) ((0x78872083FCA2C757uLL) >> 32)},
    {(VUINT32) ((0xBD778AC36E48DC74uLL) >> 0),
     (VUINT32) ((0xBD778AC36E48DC74uLL) >> 32)},
    {(VUINT32) ((0x849BA5C00C925DD4uLL) >> 0),
     (VUINT32) ((0x849BA5C00C925DD4uLL) >> 32)}},
   {{(VUINT32) ((0xF10E4107F9458EAFuLL) >> 0),
     (VUINT32) ((0xF10E4107F9458EAFuLL) >> 32)},
    {(VUINT32) ((0x7AEF1586DC91B8E9uLL) >> 0),
     (VUINT32) ((0x7AEF1586DC91B8E9uLL) >> 32)},
    {(VUINT32) ((0x09374B801924BBA8uLL) >> 0),
     (VUINT32) ((0x09374B801924BBA8uLL) >> 32)}},
   {{(VUINT32) ((0xE21C820FF28B1D5EuLL) >> 0),
     (VUINT32) ((0xE21C820FF28B1D5EuLL) >> 32)},
    {(VUINT32) ((0xF5DE2B0DB92371D2uLL) >> 0),
     (VUINT32) ((0xF5DE2B0DB92371D2uLL) >> 32)},
    {(VUINT32) ((0x126E970032497750uLL) >> 0),
     (VUINT32) ((0x126E970032497750uLL) >> 32)}},
   {{(VUINT32) ((0xC439041FE5163ABDuLL) >> 0),
     (VUINT32) ((0xC439041FE5163ABDuLL) >> 32)},
    {(VUINT32) ((0xEBBC561B7246E3A4uLL) >> 0),
     (VUINT32) ((0xEBBC561B7246E3A4uLL) >> 32)},
    {(VUINT32) ((0x24DD2E006492EEA0uLL) >> 0),
     (VUINT32) ((0x24DD2E006492EEA0uLL) >> 32)}},
   {{(VUINT32) ((0x8872083FCA2C757BuLL) >> 0),
     (VUINT32) ((0x8872083FCA2C757BuLL) >> 32)},
    {(VUINT32) ((0xD778AC36E48DC748uLL) >> 0),
     (VUINT32) ((0xD778AC36E48DC748uLL) >> 32)},
    {(VUINT32) ((0x49BA5C00C925DD41uLL) >> 0),
     (VUINT32) ((0x49BA5C00C925DD41uLL) >> 32)}},
   {{(VUINT32) ((0x10E4107F9458EAF7uLL) >> 0),
     (VUINT32) ((0x10E4107F9458EAF7uLL) >> 32)},
    {(VUINT32) ((0xAEF1586DC91B8E90uLL) >> 0),
     (VUINT32) ((0xAEF1586DC91B8E90uLL) >> 32)},
    {(VUINT32) ((0x9374B801924BBA82uLL) >> 0),
     (VUINT32) ((0x9374B801924BBA82uLL) >> 32)}},
   {{(VUINT32) ((0x21C820FF28B1D5EFuLL) >> 0),
     (VUINT32) ((0x21C820FF28B1D5EFuLL) >> 32)},
    {(VUINT32) ((0x5DE2B0DB92371D21uLL) >> 0),
     (VUINT32) ((0x5DE2B0DB92371D21uLL) >> 32)},
    {(VUINT32) ((0x26E9700324977504uLL) >> 0),
     (VUINT32) ((0x26E9700324977504uLL) >> 32)}},
   {{(VUINT32) ((0x439041FE5163ABDEuLL) >> 0),
     (VUINT32) ((0x439041FE5163ABDEuLL) >> 32)},
    {(VUINT32) ((0xBBC561B7246E3A42uLL) >> 0),
     (VUINT32) ((0xBBC561B7246E3A42uLL) >> 32)},
    {(VUINT32) ((0x4DD2E006492EEA09uLL) >> 0),
     (VUINT32) ((0x4DD2E006492EEA09uLL) >> 32)}},
   {{(VUINT32) ((0x872083FCA2C757BDuLL) >> 0),
     (VUINT32) ((0x872083FCA2C757BDuLL) >> 32)},
    {(VUINT32) ((0x778AC36E48DC7484uLL) >> 0),
     (VUINT32) ((0x778AC36E48DC7484uLL) >> 32)},
    {(VUINT32) ((0x9BA5C00C925DD413uLL) >> 0),
     (VUINT32) ((0x9BA5C00C925DD413uLL) >> 32)}},
   {{(VUINT32) ((0x0E4107F9458EAF7AuLL) >> 0),
     (VUINT32) ((0x0E4107F9458EAF7AuLL) >> 32)},
    {(VUINT32) ((0xEF1586DC91B8E909uLL) >> 0),
     (VUINT32) ((0xEF1586DC91B8E909uLL) >> 32)},
    {(VUINT32) ((0x374B801924BBA827uLL) >> 0),
     (VUINT32) ((0x374B801924BBA827uLL) >> 32)}},
   {{(VUINT32) ((0x1C820FF28B1D5EF5uLL) >> 0),
     (VUINT32) ((0x1C820FF28B1D5EF5uLL) >> 32)},
    {(VUINT32) ((0xDE2B0DB92371D212uLL) >> 0),
     (VUINT32) ((0xDE2B0DB92371D212uLL) >> 32)},
    {(VUINT32) ((0x6E9700324977504EuLL) >> 0),
     (VUINT32) ((0x6E9700324977504EuLL) >> 32)}},
   {{(VUINT32) ((0x39041FE5163ABDEBuLL) >> 0),
     (VUINT32) ((0x39041FE5163ABDEBuLL) >> 32)},
    {(VUINT32) ((0xBC561B7246E3A424uLL) >> 0),
     (VUINT32) ((0xBC561B7246E3A424uLL) >> 32)},
    {(VUINT32) ((0xDD2E006492EEA09DuLL) >> 0),
     (VUINT32) ((0xDD2E006492EEA09DuLL) >> 32)}},
   {{(VUINT32) ((0x72083FCA2C757BD7uLL) >> 0),
     (VUINT32) ((0x72083FCA2C757BD7uLL) >> 32)},
    {(VUINT32) ((0x78AC36E48DC74849uLL) >> 0),
     (VUINT32) ((0x78AC36E48DC74849uLL) >> 32)},
    {(VUINT32) ((0xBA5C00C925DD413AuLL) >> 0),
     (VUINT32) ((0xBA5C00C925DD413AuLL) >> 32)}},
   {{(VUINT32) ((0xE4107F9458EAF7AEuLL) >> 0),
     (VUINT32) ((0xE4107F9458EAF7AEuLL) >> 32)},
    {(VUINT32) ((0xF1586DC91B8E9093uLL) >> 0),
     (VUINT32) ((0xF1586DC91B8E9093uLL) >> 32)},
    {(VUINT32) ((0x74B801924BBA8274uLL) >> 0),
     (VUINT32) ((0x74B801924BBA8274uLL) >> 32)}},
   {{(VUINT32) ((0xC820FF28B1D5EF5DuLL) >> 0),
     (VUINT32) ((0xC820FF28B1D5EF5DuLL) >> 32)},
    {(VUINT32) ((0xE2B0DB92371D2126uLL) >> 0),
     (VUINT32) ((0xE2B0DB92371D2126uLL) >> 32)},
    {(VUINT32) ((0xE9700324977504E8uLL) >> 0),
     (VUINT32) ((0xE9700324977504E8uLL) >> 32)}},
   {{(VUINT32) ((0x9041FE5163ABDEBBuLL) >> 0),
     (VUINT32) ((0x9041FE5163ABDEBBuLL) >> 32)},
    {(VUINT32) ((0xC561B7246E3A424DuLL) >> 0),
     (VUINT32) ((0xC561B7246E3A424DuLL) >> 32)},
    {(VUINT32) ((0xD2E006492EEA09D1uLL) >> 0),
     (VUINT32) ((0xD2E006492EEA09D1uLL) >> 32)}},
   {{(VUINT32) ((0x2083FCA2C757BD77uLL) >> 0),
     (VUINT32) ((0x2083FCA2C757BD77uLL) >> 32)},
    {(VUINT32) ((0x8AC36E48DC74849BuLL) >> 0),
     (VUINT32) ((0x8AC36E48DC74849BuLL) >> 32)},
    {(VUINT32) ((0xA5C00C925DD413A3uLL) >> 0),
     (VUINT32) ((0xA5C00C925DD413A3uLL) >> 32)}},
   {{(VUINT32) ((0x4107F9458EAF7AEFuLL) >> 0),
     (VUINT32) ((0x4107F9458EAF7AEFuLL) >> 32)},
    {(VUINT32) ((0x1586DC91B8E90937uLL) >> 0),
     (VUINT32) ((0x1586DC91B8E90937uLL) >> 32)},
    {(VUINT32) ((0x4B801924BBA82746uLL) >> 0),
     (VUINT32) ((0x4B801924BBA82746uLL) >> 32)}},
   {{(VUINT32) ((0x820FF28B1D5EF5DEuLL) >> 0),
     (VUINT32) ((0x820FF28B1D5EF5DEuLL) >> 32)},
    {(VUINT32) ((0x2B0DB92371D2126EuLL) >> 0),
     (VUINT32) ((0x2B0DB92371D2126EuLL) >> 32)},
    {(VUINT32) ((0x9700324977504E8CuLL) >> 0),
     (VUINT32) ((0x9700324977504E8CuLL) >> 32)}},
   {{(VUINT32) ((0x041FE5163ABDEBBCuLL) >> 0),
     (VUINT32) ((0x041FE5163ABDEBBCuLL) >> 32)},
    {(VUINT32) ((0x561B7246E3A424DDuLL) >> 0),
     (VUINT32) ((0x561B7246E3A424DDuLL) >> 32)},
    {(VUINT32) ((0x2E006492EEA09D19uLL) >> 0),
     (VUINT32) ((0x2E006492EEA09D19uLL) >> 32)}},
   {{(VUINT32) ((0x083FCA2C757BD778uLL) >> 0),
     (VUINT32) ((0x083FCA2C757BD778uLL) >> 32)},
    {(VUINT32) ((0xAC36E48DC74849BAuLL) >> 0),
     (VUINT32) ((0xAC36E48DC74849BAuLL) >> 32)},
    {(VUINT32) ((0x5C00C925DD413A32uLL) >> 0),
     (VUINT32) ((0x5C00C925DD413A32uLL) >> 32)}},
   {{(VUINT32) ((0x107F9458EAF7AEF1uLL) >> 0),
     (VUINT32) ((0x107F9458EAF7AEF1uLL) >> 32)},
    {(VUINT32) ((0x586DC91B8E909374uLL) >> 0),
     (VUINT32) ((0x586DC91B8E909374uLL) >> 32)},
    {(VUINT32) ((0xB801924BBA827464uLL) >> 0),
     (VUINT32) ((0xB801924BBA827464uLL) >> 32)}},
   {{(VUINT32) ((0x20FF28B1D5EF5DE2uLL) >> 0),
     (VUINT32) ((0x20FF28B1D5EF5DE2uLL) >> 32)},
    {(VUINT32) ((0xB0DB92371D2126E9uLL) >> 0),
     (VUINT32) ((0xB0DB92371D2126E9uLL) >> 32)},
    {(VUINT32) ((0x700324977504E8C9uLL) >> 0),
     (VUINT32) ((0x700324977504E8C9uLL) >> 32)}},
   {{(VUINT32) ((0x41FE5163ABDEBBC5uLL) >> 0),
     (VUINT32) ((0x41FE5163ABDEBBC5uLL) >> 32)},
    {(VUINT32) ((0x61B7246E3A424DD2uLL) >> 0),
     (VUINT32) ((0x61B7246E3A424DD2uLL) >> 32)},
    {(VUINT32) ((0xE006492EEA09D192uLL) >> 0),
     (VUINT32) ((0xE006492EEA09D192uLL) >> 32)}},
   {{(VUINT32) ((0x83FCA2C757BD778AuLL) >> 0),
     (VUINT32) ((0x83FCA2C757BD778AuLL) >> 32)},
    {(VUINT32) ((0xC36E48DC74849BA5uLL) >> 0),
     (VUINT32) ((0xC36E48DC74849BA5uLL) >> 32)},
    {(VUINT32) ((0xC00C925DD413A324uLL) >> 0),
     (VUINT32) ((0xC00C925DD413A324uLL) >> 32)}},
   {{(VUINT32) ((0x07F9458EAF7AEF15uLL) >> 0),
     (VUINT32) ((0x07F9458EAF7AEF15uLL) >> 32)},
    {(VUINT32) ((0x86DC91B8E909374BuLL) >> 0),
     (VUINT32) ((0x86DC91B8E909374BuLL) >> 32)},
    {(VUINT32) ((0x801924BBA8274648uLL) >> 0),
     (VUINT32) ((0x801924BBA8274648uLL) >> 32)}},
   {{(VUINT32) ((0x0FF28B1D5EF5DE2BuLL) >> 0),
     (VUINT32) ((0x0FF28B1D5EF5DE2BuLL) >> 32)},
    {(VUINT32) ((0x0DB92371D2126E97uLL) >> 0),
     (VUINT32) ((0x0DB92371D2126E97uLL) >> 32)},
    {(VUINT32) ((0x00324977504E8C90uLL) >> 0),
     (VUINT32) ((0x00324977504E8C90uLL) >> 32)}},
   {{(VUINT32) ((0x1FE5163ABDEBBC56uLL) >> 0),
     (VUINT32) ((0x1FE5163ABDEBBC56uLL) >> 32)},
    {(VUINT32) ((0x1B7246E3A424DD2EuLL) >> 0),
     (VUINT32) ((0x1B7246E3A424DD2EuLL) >> 32)},
    {(VUINT32) ((0x006492EEA09D1921uLL) >> 0),
     (VUINT32) ((0x006492EEA09D1921uLL) >> 32)}},
   {{(VUINT32) ((0x3FCA2C757BD778ACuLL) >> 0),
     (VUINT32) ((0x3FCA2C757BD778ACuLL) >> 32)},
    {(VUINT32) ((0x36E48DC74849BA5CuLL) >> 0),
     (VUINT32) ((0x36E48DC74849BA5CuLL) >> 32)},
    {(VUINT32) ((0x00C925DD413A3243uLL) >> 0),
     (VUINT32) ((0x00C925DD413A3243uLL) >> 32)}},
   {{(VUINT32) ((0x7F9458EAF7AEF158uLL) >> 0),
     (VUINT32) ((0x7F9458EAF7AEF158uLL) >> 32)},
    {(VUINT32) ((0x6DC91B8E909374B8uLL) >> 0),
     (VUINT32) ((0x6DC91B8E909374B8uLL) >> 32)},
    {(VUINT32) ((0x01924BBA82746487uLL) >> 0),
     (VUINT32) ((0x01924BBA82746487uLL) >> 32)}},
   {{(VUINT32) ((0xFF28B1D5EF5DE2B0uLL) >> 0),
     (VUINT32) ((0xFF28B1D5EF5DE2B0uLL) >> 32)},
    {(VUINT32) ((0xDB92371D2126E970uLL) >> 0),
     (VUINT32) ((0xDB92371D2126E970uLL) >> 32)},
    {(VUINT32) ((0x0324977504E8C90EuLL) >> 0),
     (VUINT32) ((0x0324977504E8C90EuLL) >> 32)}},
   {{(VUINT32) ((0xFE5163ABDEBBC561uLL) >> 0),
     (VUINT32) ((0xFE5163ABDEBBC561uLL) >> 32)},
    {(VUINT32) ((0xB7246E3A424DD2E0uLL) >> 0),
     (VUINT32) ((0xB7246E3A424DD2E0uLL) >> 32)},
    {(VUINT32) ((0x06492EEA09D1921CuLL) >> 0),
     (VUINT32) ((0x06492EEA09D1921CuLL) >> 32)}},
   {{(VUINT32) ((0xFCA2C757BD778AC3uLL) >> 0),
     (VUINT32) ((0xFCA2C757BD778AC3uLL) >> 32)},
    {(VUINT32) ((0x6E48DC74849BA5C0uLL) >> 0),
     (VUINT32) ((0x6E48DC74849BA5C0uLL) >> 32)},
    {(VUINT32) ((0x0C925DD413A32439uLL) >> 0),
     (VUINT32) ((0x0C925DD413A32439uLL) >> 32)}},
   {{(VUINT32) ((0xF9458EAF7AEF1586uLL) >> 0),
     (VUINT32) ((0xF9458EAF7AEF1586uLL) >> 32)},
    {(VUINT32) ((0xDC91B8E909374B80uLL) >> 0),
     (VUINT32) ((0xDC91B8E909374B80uLL) >> 32)},
    {(VUINT32) ((0x1924BBA827464873uLL) >> 0),
     (VUINT32) ((0x1924BBA827464873uLL) >> 32)}},
   {{(VUINT32) ((0xF28B1D5EF5DE2B0DuLL) >> 0),
     (VUINT32) ((0xF28B1D5EF5DE2B0DuLL) >> 32)},
    {(VUINT32) ((0xB92371D2126E9700uLL) >> 0),
     (VUINT32) ((0xB92371D2126E9700uLL) >> 32)},
    {(VUINT32) ((0x324977504E8C90E7uLL) >> 0),
     (VUINT32) ((0x324977504E8C90E7uLL) >> 32)}},
   {{(VUINT32) ((0xE5163ABDEBBC561BuLL) >> 0),
     (VUINT32) ((0xE5163ABDEBBC561BuLL) >> 32)},
    {(VUINT32) ((0x7246E3A424DD2E00uLL) >> 0),
     (VUINT32) ((0x7246E3A424DD2E00uLL) >> 32)},
    {(VUINT32) ((0x6492EEA09D1921CFuLL) >> 0),
     (VUINT32) ((0x6492EEA09D1921CFuLL) >> 32)}},
   {{(VUINT32) ((0xCA2C757BD778AC36uLL) >> 0),
     (VUINT32) ((0xCA2C757BD778AC36uLL) >> 32)},
    {(VUINT32) ((0xE48DC74849BA5C00uLL) >> 0),
     (VUINT32) ((0xE48DC74849BA5C00uLL) >> 32)},
    {(VUINT32) ((0xC925DD413A32439FuLL) >> 0),
     (VUINT32) ((0xC925DD413A32439FuLL) >> 32)}},
   {{(VUINT32) ((0x9458EAF7AEF1586DuLL) >> 0),
     (VUINT32) ((0x9458EAF7AEF1586DuLL) >> 32)},
    {(VUINT32) ((0xC91B8E909374B801uLL) >> 0),
     (VUINT32) ((0xC91B8E909374B801uLL) >> 32)},
    {(VUINT32) ((0x924BBA827464873FuLL) >> 0),
     (VUINT32) ((0x924BBA827464873FuLL) >> 32)}},
   {{(VUINT32) ((0x28B1D5EF5DE2B0DBuLL) >> 0),
     (VUINT32) ((0x28B1D5EF5DE2B0DBuLL) >> 32)},
    {(VUINT32) ((0x92371D2126E97003uLL) >> 0),
     (VUINT32) ((0x92371D2126E97003uLL) >> 32)},
    {(VUINT32) ((0x24977504E8C90E7FuLL) >> 0),
     (VUINT32) ((0x24977504E8C90E7FuLL) >> 32)}},
   {{(VUINT32) ((0x5163ABDEBBC561B7uLL) >> 0),
     (VUINT32) ((0x5163ABDEBBC561B7uLL) >> 32)},
    {(VUINT32) ((0x246E3A424DD2E006uLL) >> 0),
     (VUINT32) ((0x246E3A424DD2E006uLL) >> 32)},
    {(VUINT32) ((0x492EEA09D1921CFEuLL) >> 0),
     (VUINT32) ((0x492EEA09D1921CFEuLL) >> 32)}},
   {{(VUINT32) ((0xA2C757BD778AC36EuLL) >> 0),
     (VUINT32) ((0xA2C757BD778AC36EuLL) >> 32)},
    {(VUINT32) ((0x48DC74849BA5C00CuLL) >> 0),
     (VUINT32) ((0x48DC74849BA5C00CuLL) >> 32)},
    {(VUINT32) ((0x925DD413A32439FCuLL) >> 0),
     (VUINT32) ((0x925DD413A32439FCuLL) >> 32)}},
   {{(VUINT32) ((0x458EAF7AEF1586DCuLL) >> 0),
     (VUINT32) ((0x458EAF7AEF1586DCuLL) >> 32)},
    {(VUINT32) ((0x91B8E909374B8019uLL) >> 0),
     (VUINT32) ((0x91B8E909374B8019uLL) >> 32)},
    {(VUINT32) ((0x24BBA827464873F8uLL) >> 0),
     (VUINT32) ((0x24BBA827464873F8uLL) >> 32)}},
   {{(VUINT32) ((0x8B1D5EF5DE2B0DB9uLL) >> 0),
     (VUINT32) ((0x8B1D5EF5DE2B0DB9uLL) >> 32)},
    {(VUINT32) ((0x2371D2126E970032uLL) >> 0),
     (VUINT32) ((0x2371D2126E970032uLL) >> 32)},
    {(VUINT32) ((0x4977504E8C90E7F0uLL) >> 0),
     (VUINT32) ((0x4977504E8C90E7F0uLL) >> 32)}},
   {{(VUINT32) ((0x163ABDEBBC561B72uLL) >> 0),
     (VUINT32) ((0x163ABDEBBC561B72uLL) >> 32)},
    {(VUINT32) ((0x46E3A424DD2E0064uLL) >> 0),
     (VUINT32) ((0x46E3A424DD2E0064uLL) >> 32)},
    {(VUINT32) ((0x92EEA09D1921CFE1uLL) >> 0),
     (VUINT32) ((0x92EEA09D1921CFE1uLL) >> 32)}},
   {{(VUINT32) ((0x2C757BD778AC36E4uLL) >> 0),
     (VUINT32) ((0x2C757BD778AC36E4uLL) >> 32)},
    {(VUINT32) ((0x8DC74849BA5C00C9uLL) >> 0),
     (VUINT32) ((0x8DC74849BA5C00C9uLL) >> 32)},
    {(VUINT32) ((0x25DD413A32439FC3uLL) >> 0),
     (VUINT32) ((0x25DD413A32439FC3uLL) >> 32)}},
   {{(VUINT32) ((0x58EAF7AEF1586DC9uLL) >> 0),
     (VUINT32) ((0x58EAF7AEF1586DC9uLL) >> 32)},
    {(VUINT32) ((0x1B8E909374B80192uLL) >> 0),
     (VUINT32) ((0x1B8E909374B80192uLL) >> 32)},
    {(VUINT32) ((0x4BBA827464873F87uLL) >> 0),
     (VUINT32) ((0x4BBA827464873F87uLL) >> 32)}},
   {{(VUINT32) ((0xB1D5EF5DE2B0DB92uLL) >> 0),
     (VUINT32) ((0xB1D5EF5DE2B0DB92uLL) >> 32)},
    {(VUINT32) ((0x371D2126E9700324uLL) >> 0),
     (VUINT32) ((0x371D2126E9700324uLL) >> 32)},
    {(VUINT32) ((0x977504E8C90E7F0EuLL) >> 0),
     (VUINT32) ((0x977504E8C90E7F0EuLL) >> 32)}},
   {{(VUINT32) ((0x63ABDEBBC561B724uLL) >> 0),
     (VUINT32) ((0x63ABDEBBC561B724uLL) >> 32)},
    {(VUINT32) ((0x6E3A424DD2E00649uLL) >> 0),
     (VUINT32) ((0x6E3A424DD2E00649uLL) >> 32)},
    {(VUINT32) ((0x2EEA09D1921CFE1DuLL) >> 0),
     (VUINT32) ((0x2EEA09D1921CFE1DuLL) >> 32)}},
   {{(VUINT32) ((0xC757BD778AC36E48uLL) >> 0),
     (VUINT32) ((0xC757BD778AC36E48uLL) >> 32)},
    {(VUINT32) ((0xDC74849BA5C00C92uLL) >> 0),
     (VUINT32) ((0xDC74849BA5C00C92uLL) >> 32)},
    {(VUINT32) ((0x5DD413A32439FC3BuLL) >> 0),
     (VUINT32) ((0x5DD413A32439FC3BuLL) >> 32)}},
   {{(VUINT32) ((0x8EAF7AEF1586DC91uLL) >> 0),
     (VUINT32) ((0x8EAF7AEF1586DC91uLL) >> 32)},
    {(VUINT32) ((0xB8E909374B801924uLL) >> 0),
     (VUINT32) ((0xB8E909374B801924uLL) >> 32)},
    {(VUINT32) ((0xBBA827464873F877uLL) >> 0),
     (VUINT32) ((0xBBA827464873F877uLL) >> 32)}},
   {{(VUINT32) ((0x1D5EF5DE2B0DB923uLL) >> 0),
     (VUINT32) ((0x1D5EF5DE2B0DB923uLL) >> 32)},
    {(VUINT32) ((0x71D2126E97003249uLL) >> 0),
     (VUINT32) ((0x71D2126E97003249uLL) >> 32)},
    {(VUINT32) ((0x77504E8C90E7F0EFuLL) >> 0),
     (VUINT32) ((0x77504E8C90E7F0EFuLL) >> 32)}},
   {{(VUINT32) ((0x3ABDEBBC561B7246uLL) >> 0),
     (VUINT32) ((0x3ABDEBBC561B7246uLL) >> 32)},
    {(VUINT32) ((0xE3A424DD2E006492uLL) >> 0),
     (VUINT32) ((0xE3A424DD2E006492uLL) >> 32)},
    {(VUINT32) ((0xEEA09D1921CFE1DEuLL) >> 0),
     (VUINT32) ((0xEEA09D1921CFE1DEuLL) >> 32)}},
   {{(VUINT32) ((0x757BD778AC36E48DuLL) >> 0),
     (VUINT32) ((0x757BD778AC36E48DuLL) >> 32)},
    {(VUINT32) ((0xC74849BA5C00C925uLL) >> 0),
     (VUINT32) ((0xC74849BA5C00C925uLL) >> 32)},
    {(VUINT32) ((0xDD413A32439FC3BDuLL) >> 0),
     (VUINT32) ((0xDD413A32439FC3BDuLL) >> 32)}},
   {{(VUINT32) ((0xEAF7AEF1586DC91BuLL) >> 0),
     (VUINT32) ((0xEAF7AEF1586DC91BuLL) >> 32)},
    {(VUINT32) ((0x8E909374B801924BuLL) >> 0),
     (VUINT32) ((0x8E909374B801924BuLL) >> 32)},
    {(VUINT32) ((0xBA827464873F877AuLL) >> 0),
     (VUINT32) ((0xBA827464873F877AuLL) >> 32)}},
   {{(VUINT32) ((0xD5EF5DE2B0DB9237uLL) >> 0),
     (VUINT32) ((0xD5EF5DE2B0DB9237uLL) >> 32)},
    {(VUINT32) ((0x1D2126E970032497uLL) >> 0),
     (VUINT32) ((0x1D2126E970032497uLL) >> 32)},
    {(VUINT32) ((0x7504E8C90E7F0EF5uLL) >> 0),
     (VUINT32) ((0x7504E8C90E7F0EF5uLL) >> 32)}},
   {{(VUINT32) ((0xABDEBBC561B7246EuLL) >> 0),
     (VUINT32) ((0xABDEBBC561B7246EuLL) >> 32)},
    {(VUINT32) ((0x3A424DD2E006492EuLL) >> 0),
     (VUINT32) ((0x3A424DD2E006492EuLL) >> 32)},
    {(VUINT32) ((0xEA09D1921CFE1DEBuLL) >> 0),
     (VUINT32) ((0xEA09D1921CFE1DEBuLL) >> 32)}},
   {{(VUINT32) ((0x57BD778AC36E48DCuLL) >> 0),
     (VUINT32) ((0x57BD778AC36E48DCuLL) >> 32)},
    {(VUINT32) ((0x74849BA5C00C925DuLL) >> 0),
     (VUINT32) ((0x74849BA5C00C925DuLL) >> 32)},
    {(VUINT32) ((0xD413A32439FC3BD6uLL) >> 0),
     (VUINT32) ((0xD413A32439FC3BD6uLL) >> 32)}},
   {{(VUINT32) ((0xAF7AEF1586DC91B8uLL) >> 0),
     (VUINT32) ((0xAF7AEF1586DC91B8uLL) >> 32)},
    {(VUINT32) ((0xE909374B801924BBuLL) >> 0),
     (VUINT32) ((0xE909374B801924BBuLL) >> 32)},
    {(VUINT32) ((0xA827464873F877ACuLL) >> 0),
     (VUINT32) ((0xA827464873F877ACuLL) >> 32)}},
   {{(VUINT32) ((0x5EF5DE2B0DB92371uLL) >> 0),
     (VUINT32) ((0x5EF5DE2B0DB92371uLL) >> 32)},
    {(VUINT32) ((0xD2126E9700324977uLL) >> 0),
     (VUINT32) ((0xD2126E9700324977uLL) >> 32)},
    {(VUINT32) ((0x504E8C90E7F0EF58uLL) >> 0),
     (VUINT32) ((0x504E8C90E7F0EF58uLL) >> 32)}},
   {{(VUINT32) ((0xBDEBBC561B7246E3uLL) >> 0),
     (VUINT32) ((0xBDEBBC561B7246E3uLL) >> 32)},
    {(VUINT32) ((0xA424DD2E006492EEuLL) >> 0),
     (VUINT32) ((0xA424DD2E006492EEuLL) >> 32)},
    {(VUINT32) ((0xA09D1921CFE1DEB1uLL) >> 0),
     (VUINT32) ((0xA09D1921CFE1DEB1uLL) >> 32)}},
   {{(VUINT32) ((0x7BD778AC36E48DC7uLL) >> 0),
     (VUINT32) ((0x7BD778AC36E48DC7uLL) >> 32)},
    {(VUINT32) ((0x4849BA5C00C925DDuLL) >> 0),
     (VUINT32) ((0x4849BA5C00C925DDuLL) >> 32)},
    {(VUINT32) ((0x413A32439FC3BD63uLL) >> 0),
     (VUINT32) ((0x413A32439FC3BD63uLL) >> 32)}},
   {{(VUINT32) ((0xF7AEF1586DC91B8EuLL) >> 0),
     (VUINT32) ((0xF7AEF1586DC91B8EuLL) >> 32)},
    {(VUINT32) ((0x909374B801924BBAuLL) >> 0),
     (VUINT32) ((0x909374B801924BBAuLL) >> 32)},
    {(VUINT32) ((0x827464873F877AC7uLL) >> 0),
     (VUINT32) ((0x827464873F877AC7uLL) >> 32)}},
   {{(VUINT32) ((0xEF5DE2B0DB92371DuLL) >> 0),
     (VUINT32) ((0xEF5DE2B0DB92371DuLL) >> 32)},
    {(VUINT32) ((0x2126E97003249775uLL) >> 0),
     (VUINT32) ((0x2126E97003249775uLL) >> 32)},
    {(VUINT32) ((0x04E8C90E7F0EF58EuLL) >> 0),
     (VUINT32) ((0x04E8C90E7F0EF58EuLL) >> 32)}},
   {{(VUINT32) ((0xDEBBC561B7246E3AuLL) >> 0),
     (VUINT32) ((0xDEBBC561B7246E3AuLL) >> 32)},
    {(VUINT32) ((0x424DD2E006492EEAuLL) >> 0),
     (VUINT32) ((0x424DD2E006492EEAuLL) >> 32)},
    {(VUINT32) ((0x09D1921CFE1DEB1CuLL) >> 0),
     (VUINT32) ((0x09D1921CFE1DEB1CuLL) >> 32)}},
   {{(VUINT32) ((0xBD778AC36E48DC74uLL) >> 0),
     (VUINT32) ((0xBD778AC36E48DC74uLL) >> 32)},
    {(VUINT32) ((0x849BA5C00C925DD4uLL) >> 0),
     (VUINT32) ((0x849BA5C00C925DD4uLL) >> 32)},
    {(VUINT32) ((0x13A32439FC3BD639uLL) >> 0),
     (VUINT32) ((0x13A32439FC3BD639uLL) >> 32)}},
   {{(VUINT32) ((0x7AEF1586DC91B8E9uLL) >> 0),
     (VUINT32) ((0x7AEF1586DC91B8E9uLL) >> 32)},
    {(VUINT32) ((0x09374B801924BBA8uLL) >> 0),
     (VUINT32) ((0x09374B801924BBA8uLL) >> 32)},
    {(VUINT32) ((0x27464873F877AC72uLL) >> 0),
     (VUINT32) ((0x27464873F877AC72uLL) >> 32)}},
   {{(VUINT32) ((0xF5DE2B0DB92371D2uLL) >> 0),
     (VUINT32) ((0xF5DE2B0DB92371D2uLL) >> 32)},
    {(VUINT32) ((0x126E970032497750uLL) >> 0),
     (VUINT32) ((0x126E970032497750uLL) >> 32)},
    {(VUINT32) ((0x4E8C90E7F0EF58E5uLL) >> 0),
     (VUINT32) ((0x4E8C90E7F0EF58E5uLL) >> 32)}},
   {{(VUINT32) ((0xEBBC561B7246E3A4uLL) >> 0),
     (VUINT32) ((0xEBBC561B7246E3A4uLL) >> 32)},
    {(VUINT32) ((0x24DD2E006492EEA0uLL) >> 0),
     (VUINT32) ((0x24DD2E006492EEA0uLL) >> 32)},
    {(VUINT32) ((0x9D1921CFE1DEB1CBuLL) >> 0),
     (VUINT32) ((0x9D1921CFE1DEB1CBuLL) >> 32)}},
   {{(VUINT32) ((0xD778AC36E48DC748uLL) >> 0),
     (VUINT32) ((0xD778AC36E48DC748uLL) >> 32)},
    {(VUINT32) ((0x49BA5C00C925DD41uLL) >> 0),
     (VUINT32) ((0x49BA5C00C925DD41uLL) >> 32)},
    {(VUINT32) ((0x3A32439FC3BD6396uLL) >> 0),
     (VUINT32) ((0x3A32439FC3BD6396uLL) >> 32)}},
   {{(VUINT32) ((0xAEF1586DC91B8E90uLL) >> 0),
     (VUINT32) ((0xAEF1586DC91B8E90uLL) >> 32)},
    {(VUINT32) ((0x9374B801924BBA82uLL) >> 0),
     (VUINT32) ((0x9374B801924BBA82uLL) >> 32)},
    {(VUINT32) ((0x7464873F877AC72CuLL) >> 0),
     (VUINT32) ((0x7464873F877AC72CuLL) >> 32)}},
   {{(VUINT32) ((0x5DE2B0DB92371D21uLL) >> 0),
     (VUINT32) ((0x5DE2B0DB92371D21uLL) >> 32)},
    {(VUINT32) ((0x26E9700324977504uLL) >> 0),
     (VUINT32) ((0x26E9700324977504uLL) >> 32)},
    {(VUINT32) ((0xE8C90E7F0EF58E58uLL) >> 0),
     (VUINT32) ((0xE8C90E7F0EF58E58uLL) >> 32)}},
   {{(VUINT32) ((0xBBC561B7246E3A42uLL) >> 0),
     (VUINT32) ((0xBBC561B7246E3A42uLL) >> 32)},
    {(VUINT32) ((0x4DD2E006492EEA09uLL) >> 0),
     (VUINT32) ((0x4DD2E006492EEA09uLL) >> 32)},
    {(VUINT32) ((0xD1921CFE1DEB1CB1uLL) >> 0),
     (VUINT32) ((0xD1921CFE1DEB1CB1uLL) >> 32)}},
   {{(VUINT32) ((0x778AC36E48DC7484uLL) >> 0),
     (VUINT32) ((0x778AC36E48DC7484uLL) >> 32)},
    {(VUINT32) ((0x9BA5C00C925DD413uLL) >> 0),
     (VUINT32) ((0x9BA5C00C925DD413uLL) >> 32)},
    {(VUINT32) ((0xA32439FC3BD63962uLL) >> 0),
     (VUINT32) ((0xA32439FC3BD63962uLL) >> 32)}},
   {{(VUINT32) ((0xEF1586DC91B8E909uLL) >> 0),
     (VUINT32) ((0xEF1586DC91B8E909uLL) >> 32)},
    {(VUINT32) ((0x374B801924BBA827uLL) >> 0),
     (VUINT32) ((0x374B801924BBA827uLL) >> 32)},
    {(VUINT32) ((0x464873F877AC72C4uLL) >> 0),
     (VUINT32) ((0x464873F877AC72C4uLL) >> 32)}},
   {{(VUINT32) ((0xDE2B0DB92371D212uLL) >> 0),
     (VUINT32) ((0xDE2B0DB92371D212uLL) >> 32)},
    {(VUINT32) ((0x6E9700324977504EuLL) >> 0),
     (VUINT32) ((0x6E9700324977504EuLL) >> 32)},
    {(VUINT32) ((0x8C90E7F0EF58E589uLL) >> 0),
     (VUINT32) ((0x8C90E7F0EF58E589uLL) >> 32)}},
   {{(VUINT32) ((0xBC561B7246E3A424uLL) >> 0),
     (VUINT32) ((0xBC561B7246E3A424uLL) >> 32)},
    {(VUINT32) ((0xDD2E006492EEA09DuLL) >> 0),
     (VUINT32) ((0xDD2E006492EEA09DuLL) >> 32)},
    {(VUINT32) ((0x1921CFE1DEB1CB12uLL) >> 0),
     (VUINT32) ((0x1921CFE1DEB1CB12uLL) >> 32)}},
   {{(VUINT32) ((0x78AC36E48DC74849uLL) >> 0),
     (VUINT32) ((0x78AC36E48DC74849uLL) >> 32)},
    {(VUINT32) ((0xBA5C00C925DD413AuLL) >> 0),
     (VUINT32) ((0xBA5C00C925DD413AuLL) >> 32)},
    {(VUINT32) ((0x32439FC3BD639625uLL) >> 0),
     (VUINT32) ((0x32439FC3BD639625uLL) >> 32)}},
   {{(VUINT32) ((0xF1586DC91B8E9093uLL) >> 0),
     (VUINT32) ((0xF1586DC91B8E9093uLL) >> 32)},
    {(VUINT32) ((0x74B801924BBA8274uLL) >> 0),
     (VUINT32) ((0x74B801924BBA8274uLL) >> 32)},
    {(VUINT32) ((0x64873F877AC72C4AuLL) >> 0),
     (VUINT32) ((0x64873F877AC72C4AuLL) >> 32)}},
   {{(VUINT32) ((0xE2B0DB92371D2126uLL) >> 0),
     (VUINT32) ((0xE2B0DB92371D2126uLL) >> 32)},
    {(VUINT32) ((0xE9700324977504E8uLL) >> 0),
     (VUINT32) ((0xE9700324977504E8uLL) >> 32)},
    {(VUINT32) ((0xC90E7F0EF58E5894uLL) >> 0),
     (VUINT32) ((0xC90E7F0EF58E5894uLL) >> 32)}},
   {{(VUINT32) ((0xC561B7246E3A424DuLL) >> 0),
     (VUINT32) ((0xC561B7246E3A424DuLL) >> 32)},
    {(VUINT32) ((0xD2E006492EEA09D1uLL) >> 0),
     (VUINT32) ((0xD2E006492EEA09D1uLL) >> 32)},
    {(VUINT32) ((0x921CFE1DEB1CB129uLL) >> 0),
     (VUINT32) ((0x921CFE1DEB1CB129uLL) >> 32)}},
   {{(VUINT32) ((0x8AC36E48DC74849BuLL) >> 0),
     (VUINT32) ((0x8AC36E48DC74849BuLL) >> 32)},
    {(VUINT32) ((0xA5C00C925DD413A3uLL) >> 0),
     (VUINT32) ((0xA5C00C925DD413A3uLL) >> 32)},
    {(VUINT32) ((0x2439FC3BD6396253uLL) >> 0),
     (VUINT32) ((0x2439FC3BD6396253uLL) >> 32)}},
   {{(VUINT32) ((0x1586DC91B8E90937uLL) >> 0),
     (VUINT32) ((0x1586DC91B8E90937uLL) >> 32)},
    {(VUINT32) ((0x4B801924BBA82746uLL) >> 0),
     (VUINT32) ((0x4B801924BBA82746uLL) >> 32)},
    {(VUINT32) ((0x4873F877AC72C4A6uLL) >> 0),
     (VUINT32) ((0x4873F877AC72C4A6uLL) >> 32)}},
   {{(VUINT32) ((0x2B0DB92371D2126EuLL) >> 0),
     (VUINT32) ((0x2B0DB92371D2126EuLL) >> 32)},
    {(VUINT32) ((0x9700324977504E8CuLL) >> 0),
     (VUINT32) ((0x9700324977504E8CuLL) >> 32)},
    {(VUINT32) ((0x90E7F0EF58E5894DuLL) >> 0),
     (VUINT32) ((0x90E7F0EF58E5894DuLL) >> 32)}},
   {{(VUINT32) ((0x561B7246E3A424DDuLL) >> 0),
     (VUINT32) ((0x561B7246E3A424DDuLL) >> 32)},
    {(VUINT32) ((0x2E006492EEA09D19uLL) >> 0),
     (VUINT32) ((0x2E006492EEA09D19uLL) >> 32)},
    {(VUINT32) ((0x21CFE1DEB1CB129AuLL) >> 0),
     (VUINT32) ((0x21CFE1DEB1CB129AuLL) >> 32)}},
   {{(VUINT32) ((0xAC36E48DC74849BAuLL) >> 0),
     (VUINT32) ((0xAC36E48DC74849BAuLL) >> 32)},
    {(VUINT32) ((0x5C00C925DD413A32uLL) >> 0),
     (VUINT32) ((0x5C00C925DD413A32uLL) >> 32)},
    {(VUINT32) ((0x439FC3BD63962534uLL) >> 0),
     (VUINT32) ((0x439FC3BD63962534uLL) >> 32)}},
   {{(VUINT32) ((0x586DC91B8E909374uLL) >> 0),
     (VUINT32) ((0x586DC91B8E909374uLL) >> 32)},
    {(VUINT32) ((0xB801924BBA827464uLL) >> 0),
     (VUINT32) ((0xB801924BBA827464uLL) >> 32)},
    {(VUINT32) ((0x873F877AC72C4A69uLL) >> 0),
     (VUINT32) ((0x873F877AC72C4A69uLL) >> 32)}},
   {{(VUINT32) ((0xB0DB92371D2126E9uLL) >> 0),
     (VUINT32) ((0xB0DB92371D2126E9uLL) >> 32)},
    {(VUINT32) ((0x700324977504E8C9uLL) >> 0),
     (VUINT32) ((0x700324977504E8C9uLL) >> 32)},
    {(VUINT32) ((0x0E7F0EF58E5894D3uLL) >> 0),
     (VUINT32) ((0x0E7F0EF58E5894D3uLL) >> 32)}},
   {{(VUINT32) ((0x61B7246E3A424DD2uLL) >> 0),
     (VUINT32) ((0x61B7246E3A424DD2uLL) >> 32)},
    {(VUINT32) ((0xE006492EEA09D192uLL) >> 0),
     (VUINT32) ((0xE006492EEA09D192uLL) >> 32)},
    {(VUINT32) ((0x1CFE1DEB1CB129A7uLL) >> 0),
     (VUINT32) ((0x1CFE1DEB1CB129A7uLL) >> 32)}},
   {{(VUINT32) ((0xC36E48DC74849BA5uLL) >> 0),
     (VUINT32) ((0xC36E48DC74849BA5uLL) >> 32)},
    {(VUINT32) ((0xC00C925DD413A324uLL) >> 0),
     (VUINT32) ((0xC00C925DD413A324uLL) >> 32)},
    {(VUINT32) ((0x39FC3BD63962534EuLL) >> 0),
     (VUINT32) ((0x39FC3BD63962534EuLL) >> 32)}},
   {{(VUINT32) ((0x86DC91B8E909374BuLL) >> 0),
     (VUINT32) ((0x86DC91B8E909374BuLL) >> 32)},
    {(VUINT32) ((0x801924BBA8274648uLL) >> 0),
     (VUINT32) ((0x801924BBA8274648uLL) >> 32)},
    {(VUINT32) ((0x73F877AC72C4A69CuLL) >> 0),
     (VUINT32) ((0x73F877AC72C4A69CuLL) >> 32)}},
   {{(VUINT32) ((0x0DB92371D2126E97uLL) >> 0),
     (VUINT32) ((0x0DB92371D2126E97uLL) >> 32)},
    {(VUINT32) ((0x00324977504E8C90uLL) >> 0),
     (VUINT32) ((0x00324977504E8C90uLL) >> 32)},
    {(VUINT32) ((0xE7F0EF58E5894D39uLL) >> 0),
     (VUINT32) ((0xE7F0EF58E5894D39uLL) >> 32)}},
   {{(VUINT32) ((0x1B7246E3A424DD2EuLL) >> 0),
     (VUINT32) ((0x1B7246E3A424DD2EuLL) >> 32)},
    {(VUINT32) ((0x006492EEA09D1921uLL) >> 0),
     (VUINT32) ((0x006492EEA09D1921uLL) >> 32)},
    {(VUINT32) ((0xCFE1DEB1CB129A73uLL) >> 0),
     (VUINT32) ((0xCFE1DEB1CB129A73uLL) >> 32)}},
   {{(VUINT32) ((0x36E48DC74849BA5CuLL) >> 0),
     (VUINT32) ((0x36E48DC74849BA5CuLL) >> 32)},
    {(VUINT32) ((0x00C925DD413A3243uLL) >> 0),
     (VUINT32) ((0x00C925DD413A3243uLL) >> 32)},
    {(VUINT32) ((0x9FC3BD63962534E7uLL) >> 0),
     (VUINT32) ((0x9FC3BD63962534E7uLL) >> 32)}},
   {{(VUINT32) ((0x6DC91B8E909374B8uLL) >> 0),
     (VUINT32) ((0x6DC91B8E909374B8uLL) >> 32)},
    {(VUINT32) ((0x01924BBA82746487uLL) >> 0),
     (VUINT32) ((0x01924BBA82746487uLL) >> 32)},
    {(VUINT32) ((0x3F877AC72C4A69CFuLL) >> 0),
     (VUINT32) ((0x3F877AC72C4A69CFuLL) >> 32)}},
   {{(VUINT32) ((0xDB92371D2126E970uLL) >> 0),
     (VUINT32) ((0xDB92371D2126E970uLL) >> 32)},
    {(VUINT32) ((0x0324977504E8C90EuLL) >> 0),
     (VUINT32) ((0x0324977504E8C90EuLL) >> 32)},
    {(VUINT32) ((0x7F0EF58E5894D39FuLL) >> 0),
     (VUINT32) ((0x7F0EF58E5894D39FuLL) >> 32)}},
   {{(VUINT32) ((0xB7246E3A424DD2E0uLL) >> 0),
     (VUINT32) ((0xB7246E3A424DD2E0uLL) >> 32)},
    {(VUINT32) ((0x06492EEA09D1921CuLL) >> 0),
     (VUINT32) ((0x06492EEA09D1921CuLL) >> 32)},
    {(VUINT32) ((0xFE1DEB1CB129A73EuLL) >> 0),
     (VUINT32) ((0xFE1DEB1CB129A73EuLL) >> 32)}},
   {{(VUINT32) ((0x6E48DC74849BA5C0uLL) >> 0),
     (VUINT32) ((0x6E48DC74849BA5C0uLL) >> 32)},
    {(VUINT32) ((0x0C925DD413A32439uLL) >> 0),
     (VUINT32) ((0x0C925DD413A32439uLL) >> 32)},
    {(VUINT32) ((0xFC3BD63962534E7DuLL) >> 0),
     (VUINT32) ((0xFC3BD63962534E7DuLL) >> 32)}},
   {{(VUINT32) ((0xDC91B8E909374B80uLL) >> 0),
     (VUINT32) ((0xDC91B8E909374B80uLL) >> 32)},
    {(VUINT32) ((0x1924BBA827464873uLL) >> 0),
     (VUINT32) ((0x1924BBA827464873uLL) >> 32)},
    {(VUINT32) ((0xF877AC72C4A69CFBuLL) >> 0),
     (VUINT32) ((0xF877AC72C4A69CFBuLL) >> 32)}},
   {{(VUINT32) ((0xB92371D2126E9700uLL) >> 0),
     (VUINT32) ((0xB92371D2126E9700uLL) >> 32)},
    {(VUINT32) ((0x324977504E8C90E7uLL) >> 0),
     (VUINT32) ((0x324977504E8C90E7uLL) >> 32)},
    {(VUINT32) ((0xF0EF58E5894D39F7uLL) >> 0),
     (VUINT32) ((0xF0EF58E5894D39F7uLL) >> 32)}},
   {{(VUINT32) ((0x7246E3A424DD2E00uLL) >> 0),
     (VUINT32) ((0x7246E3A424DD2E00uLL) >> 32)},
    {(VUINT32) ((0x6492EEA09D1921CFuLL) >> 0),
     (VUINT32) ((0x6492EEA09D1921CFuLL) >> 32)},
    {(VUINT32) ((0xE1DEB1CB129A73EEuLL) >> 0),
     (VUINT32) ((0xE1DEB1CB129A73EEuLL) >> 32)}},
   {{(VUINT32) ((0xE48DC74849BA5C00uLL) >> 0),
     (VUINT32) ((0xE48DC74849BA5C00uLL) >> 32)},
    {(VUINT32) ((0xC925DD413A32439FuLL) >> 0),
     (VUINT32) ((0xC925DD413A32439FuLL) >> 32)},
    {(VUINT32) ((0xC3BD63962534E7DDuLL) >> 0),
     (VUINT32) ((0xC3BD63962534E7DDuLL) >> 32)}},
   {{(VUINT32) ((0xC91B8E909374B801uLL) >> 0),
     (VUINT32) ((0xC91B8E909374B801uLL) >> 32)},
    {(VUINT32) ((0x924BBA827464873FuLL) >> 0),
     (VUINT32) ((0x924BBA827464873FuLL) >> 32)},
    {(VUINT32) ((0x877AC72C4A69CFBAuLL) >> 0),
     (VUINT32) ((0x877AC72C4A69CFBAuLL) >> 32)}},
   {{(VUINT32) ((0x92371D2126E97003uLL) >> 0),
     (VUINT32) ((0x92371D2126E97003uLL) >> 32)},
    {(VUINT32) ((0x24977504E8C90E7FuLL) >> 0),
     (VUINT32) ((0x24977504E8C90E7FuLL) >> 32)},
    {(VUINT32) ((0x0EF58E5894D39F74uLL) >> 0),
     (VUINT32) ((0x0EF58E5894D39F74uLL) >> 32)}},
   {{(VUINT32) ((0x246E3A424DD2E006uLL) >> 0),
     (VUINT32) ((0x246E3A424DD2E006uLL) >> 32)},
    {(VUINT32) ((0x492EEA09D1921CFEuLL) >> 0),
     (VUINT32) ((0x492EEA09D1921CFEuLL) >> 32)},
    {(VUINT32) ((0x1DEB1CB129A73EE8uLL) >> 0),
     (VUINT32) ((0x1DEB1CB129A73EE8uLL) >> 32)}},
   {{(VUINT32) ((0x48DC74849BA5C00CuLL) >> 0),
     (VUINT32) ((0x48DC74849BA5C00CuLL) >> 32)},
    {(VUINT32) ((0x925DD413A32439FCuLL) >> 0),
     (VUINT32) ((0x925DD413A32439FCuLL) >> 32)},
    {(VUINT32) ((0x3BD63962534E7DD1uLL) >> 0),
     (VUINT32) ((0x3BD63962534E7DD1uLL) >> 32)}},
   {{(VUINT32) ((0x91B8E909374B8019uLL) >> 0),
     (VUINT32) ((0x91B8E909374B8019uLL) >> 32)},
    {(VUINT32) ((0x24BBA827464873F8uLL) >> 0),
     (VUINT32) ((0x24BBA827464873F8uLL) >> 32)},
    {(VUINT32) ((0x77AC72C4A69CFBA2uLL) >> 0),
     (VUINT32) ((0x77AC72C4A69CFBA2uLL) >> 32)}},
   {{(VUINT32) ((0x2371D2126E970032uLL) >> 0),
     (VUINT32) ((0x2371D2126E970032uLL) >> 32)},
    {(VUINT32) ((0x4977504E8C90E7F0uLL) >> 0),
     (VUINT32) ((0x4977504E8C90E7F0uLL) >> 32)},
    {(VUINT32) ((0xEF58E5894D39F744uLL) >> 0),
     (VUINT32) ((0xEF58E5894D39F744uLL) >> 32)}},
   {{(VUINT32) ((0x46E3A424DD2E0064uLL) >> 0),
     (VUINT32) ((0x46E3A424DD2E0064uLL) >> 32)},
    {(VUINT32) ((0x92EEA09D1921CFE1uLL) >> 0),
     (VUINT32) ((0x92EEA09D1921CFE1uLL) >> 32)},
    {(VUINT32) ((0xDEB1CB129A73EE88uLL) >> 0),
     (VUINT32) ((0xDEB1CB129A73EE88uLL) >> 32)}},
   {{(VUINT32) ((0x8DC74849BA5C00C9uLL) >> 0),
     (VUINT32) ((0x8DC74849BA5C00C9uLL) >> 32)},
    {(VUINT32) ((0x25DD413A32439FC3uLL) >> 0),
     (VUINT32) ((0x25DD413A32439FC3uLL) >> 32)},
    {(VUINT32) ((0xBD63962534E7DD10uLL) >> 0),
     (VUINT32) ((0xBD63962534E7DD10uLL) >> 32)}},
   {{(VUINT32) ((0x1B8E909374B80192uLL) >> 0),
     (VUINT32) ((0x1B8E909374B80192uLL) >> 32)},
    {(VUINT32) ((0x4BBA827464873F87uLL) >> 0),
     (VUINT32) ((0x4BBA827464873F87uLL) >> 32)},
    {(VUINT32) ((0x7AC72C4A69CFBA20uLL) >> 0),
     (VUINT32) ((0x7AC72C4A69CFBA20uLL) >> 32)}},
   {{(VUINT32) ((0x371D2126E9700324uLL) >> 0),
     (VUINT32) ((0x371D2126E9700324uLL) >> 32)},
    {(VUINT32) ((0x977504E8C90E7F0EuLL) >> 0),
     (VUINT32) ((0x977504E8C90E7F0EuLL) >> 32)},
    {(VUINT32) ((0xF58E5894D39F7441uLL) >> 0),
     (VUINT32) ((0xF58E5894D39F7441uLL) >> 32)}},
   {{(VUINT32) ((0x6E3A424DD2E00649uLL) >> 0),
     (VUINT32) ((0x6E3A424DD2E00649uLL) >> 32)},
    {(VUINT32) ((0x2EEA09D1921CFE1DuLL) >> 0),
     (VUINT32) ((0x2EEA09D1921CFE1DuLL) >> 32)},
    {(VUINT32) ((0xEB1CB129A73EE882uLL) >> 0),
     (VUINT32) ((0xEB1CB129A73EE882uLL) >> 32)}},
   {{(VUINT32) ((0xDC74849BA5C00C92uLL) >> 0),
     (VUINT32) ((0xDC74849BA5C00C92uLL) >> 32)},
    {(VUINT32) ((0x5DD413A32439FC3BuLL) >> 0),
     (VUINT32) ((0x5DD413A32439FC3BuLL) >> 32)},
    {(VUINT32) ((0xD63962534E7DD104uLL) >> 0),
     (VUINT32) ((0xD63962534E7DD104uLL) >> 32)}},
   {{(VUINT32) ((0xB8E909374B801924uLL) >> 0),
     (VUINT32) ((0xB8E909374B801924uLL) >> 32)},
    {(VUINT32) ((0xBBA827464873F877uLL) >> 0),
     (VUINT32) ((0xBBA827464873F877uLL) >> 32)},
    {(VUINT32) ((0xAC72C4A69CFBA208uLL) >> 0),
     (VUINT32) ((0xAC72C4A69CFBA208uLL) >> 32)}},
   {{(VUINT32) ((0x71D2126E97003249uLL) >> 0),
     (VUINT32) ((0x71D2126E97003249uLL) >> 32)},
    {(VUINT32) ((0x77504E8C90E7F0EFuLL) >> 0),
     (VUINT32) ((0x77504E8C90E7F0EFuLL) >> 32)},
    {(VUINT32) ((0x58E5894D39F74411uLL) >> 0),
     (VUINT32) ((0x58E5894D39F74411uLL) >> 32)}},
   {{(VUINT32) ((0xE3A424DD2E006492uLL) >> 0),
     (VUINT32) ((0xE3A424DD2E006492uLL) >> 32)},
    {(VUINT32) ((0xEEA09D1921CFE1DEuLL) >> 0),
     (VUINT32) ((0xEEA09D1921CFE1DEuLL) >> 32)},
    {(VUINT32) ((0xB1CB129A73EE8823uLL) >> 0),
     (VUINT32) ((0xB1CB129A73EE8823uLL) >> 32)}},
   {{(VUINT32) ((0xC74849BA5C00C925uLL) >> 0),
     (VUINT32) ((0xC74849BA5C00C925uLL) >> 32)},
    {(VUINT32) ((0xDD413A32439FC3BDuLL) >> 0),
     (VUINT32) ((0xDD413A32439FC3BDuLL) >> 32)},
    {(VUINT32) ((0x63962534E7DD1046uLL) >> 0),
     (VUINT32) ((0x63962534E7DD1046uLL) >> 32)}},
   {{(VUINT32) ((0x8E909374B801924BuLL) >> 0),
     (VUINT32) ((0x8E909374B801924BuLL) >> 32)},
    {(VUINT32) ((0xBA827464873F877AuLL) >> 0),
     (VUINT32) ((0xBA827464873F877AuLL) >> 32)},
    {(VUINT32) ((0xC72C4A69CFBA208DuLL) >> 0),
     (VUINT32) ((0xC72C4A69CFBA208DuLL) >> 32)}},
   {{(VUINT32) ((0x1D2126E970032497uLL) >> 0),
     (VUINT32) ((0x1D2126E970032497uLL) >> 32)},
    {(VUINT32) ((0x7504E8C90E7F0EF5uLL) >> 0),
     (VUINT32) ((0x7504E8C90E7F0EF5uLL) >> 32)},
    {(VUINT32) ((0x8E5894D39F74411AuLL) >> 0),
     (VUINT32) ((0x8E5894D39F74411AuLL) >> 32)}},
   {{(VUINT32) ((0x3A424DD2E006492EuLL) >> 0),
     (VUINT32) ((0x3A424DD2E006492EuLL) >> 32)},
    {(VUINT32) ((0xEA09D1921CFE1DEBuLL) >> 0),
     (VUINT32) ((0xEA09D1921CFE1DEBuLL) >> 32)},
    {(VUINT32) ((0x1CB129A73EE88235uLL) >> 0),
     (VUINT32) ((0x1CB129A73EE88235uLL) >> 32)}},
   {{(VUINT32) ((0x74849BA5C00C925DuLL) >> 0),
     (VUINT32) ((0x74849BA5C00C925DuLL) >> 32)},
    {(VUINT32) ((0xD413A32439FC3BD6uLL) >> 0),
     (VUINT32) ((0xD413A32439FC3BD6uLL) >> 32)},
    {(VUINT32) ((0x3962534E7DD1046BuLL) >> 0),
     (VUINT32) ((0x3962534E7DD1046BuLL) >> 32)}},
   {{(VUINT32) ((0xE909374B801924BBuLL) >> 0),
     (VUINT32) ((0xE909374B801924BBuLL) >> 32)},
    {(VUINT32) ((0xA827464873F877ACuLL) >> 0),
     (VUINT32) ((0xA827464873F877ACuLL) >> 32)},
    {(VUINT32) ((0x72C4A69CFBA208D7uLL) >> 0),
     (VUINT32) ((0x72C4A69CFBA208D7uLL) >> 32)}},
   {{(VUINT32) ((0xD2126E9700324977uLL) >> 0),
     (VUINT32) ((0xD2126E9700324977uLL) >> 32)},
    {(VUINT32) ((0x504E8C90E7F0EF58uLL) >> 0),
     (VUINT32) ((0x504E8C90E7F0EF58uLL) >> 32)},
    {(VUINT32) ((0xE5894D39F74411AFuLL) >> 0),
     (VUINT32) ((0xE5894D39F74411AFuLL) >> 32)}},
   {{(VUINT32) ((0xA424DD2E006492EEuLL) >> 0),
     (VUINT32) ((0xA424DD2E006492EEuLL) >> 32)},
    {(VUINT32) ((0xA09D1921CFE1DEB1uLL) >> 0),
     (VUINT32) ((0xA09D1921CFE1DEB1uLL) >> 32)},
    {(VUINT32) ((0xCB129A73EE88235FuLL) >> 0),
     (VUINT32) ((0xCB129A73EE88235FuLL) >> 32)}},
   {{(VUINT32) ((0x4849BA5C00C925DDuLL) >> 0),
     (VUINT32) ((0x4849BA5C00C925DDuLL) >> 32)},
    {(VUINT32) ((0x413A32439FC3BD63uLL) >> 0),
     (VUINT32) ((0x413A32439FC3BD63uLL) >> 32)},
    {(VUINT32) ((0x962534E7DD1046BEuLL) >> 0),
     (VUINT32) ((0x962534E7DD1046BEuLL) >> 32)}},
   {{(VUINT32) ((0x909374B801924BBAuLL) >> 0),
     (VUINT32) ((0x909374B801924BBAuLL) >> 32)},
    {(VUINT32) ((0x827464873F877AC7uLL) >> 0),
     (VUINT32) ((0x827464873F877AC7uLL) >> 32)},
    {(VUINT32) ((0x2C4A69CFBA208D7DuLL) >> 0),
     (VUINT32) ((0x2C4A69CFBA208D7DuLL) >> 32)}},
   {{(VUINT32) ((0x2126E97003249775uLL) >> 0),
     (VUINT32) ((0x2126E97003249775uLL) >> 32)},
    {(VUINT32) ((0x04E8C90E7F0EF58EuLL) >> 0),
     (VUINT32) ((0x04E8C90E7F0EF58EuLL) >> 32)},
    {(VUINT32) ((0x5894D39F74411AFAuLL) >> 0),
     (VUINT32) ((0x5894D39F74411AFAuLL) >> 32)}},
   {{(VUINT32) ((0x424DD2E006492EEAuLL) >> 0),
     (VUINT32) ((0x424DD2E006492EEAuLL) >> 32)},
    {(VUINT32) ((0x09D1921CFE1DEB1CuLL) >> 0),
     (VUINT32) ((0x09D1921CFE1DEB1CuLL) >> 32)},
    {(VUINT32) ((0xB129A73EE88235F5uLL) >> 0),
     (VUINT32) ((0xB129A73EE88235F5uLL) >> 32)}},
   {{(VUINT32) ((0x849BA5C00C925DD4uLL) >> 0),
     (VUINT32) ((0x849BA5C00C925DD4uLL) >> 32)},
    {(VUINT32) ((0x13A32439FC3BD639uLL) >> 0),
     (VUINT32) ((0x13A32439FC3BD639uLL) >> 32)},
    {(VUINT32) ((0x62534E7DD1046BEAuLL) >> 0),
     (VUINT32) ((0x62534E7DD1046BEAuLL) >> 32)}},
   {{(VUINT32) ((0x09374B801924BBA8uLL) >> 0),
     (VUINT32) ((0x09374B801924BBA8uLL) >> 32)},
    {(VUINT32) ((0x27464873F877AC72uLL) >> 0),
     (VUINT32) ((0x27464873F877AC72uLL) >> 32)},
    {(VUINT32) ((0xC4A69CFBA208D7D4uLL) >> 0),
     (VUINT32) ((0xC4A69CFBA208D7D4uLL) >> 32)}},
   {{(VUINT32) ((0x126E970032497750uLL) >> 0),
     (VUINT32) ((0x126E970032497750uLL) >> 32)},
    {(VUINT32) ((0x4E8C90E7F0EF58E5uLL) >> 0),
     (VUINT32) ((0x4E8C90E7F0EF58E5uLL) >> 32)},
    {(VUINT32) ((0x894D39F74411AFA9uLL) >> 0),
     (VUINT32) ((0x894D39F74411AFA9uLL) >> 32)}},
   {{(VUINT32) ((0x24DD2E006492EEA0uLL) >> 0),
     (VUINT32) ((0x24DD2E006492EEA0uLL) >> 32)},
    {(VUINT32) ((0x9D1921CFE1DEB1CBuLL) >> 0),
     (VUINT32) ((0x9D1921CFE1DEB1CBuLL) >> 32)},
    {(VUINT32) ((0x129A73EE88235F52uLL) >> 0),
     (VUINT32) ((0x129A73EE88235F52uLL) >> 32)}},
   {{(VUINT32) ((0x49BA5C00C925DD41uLL) >> 0),
     (VUINT32) ((0x49BA5C00C925DD41uLL) >> 32)},
    {(VUINT32) ((0x3A32439FC3BD6396uLL) >> 0),
     (VUINT32) ((0x3A32439FC3BD6396uLL) >> 32)},
    {(VUINT32) ((0x2534E7DD1046BEA5uLL) >> 0),
     (VUINT32) ((0x2534E7DD1046BEA5uLL) >> 32)}},
   {{(VUINT32) ((0x9374B801924BBA82uLL) >> 0),
     (VUINT32) ((0x9374B801924BBA82uLL) >> 32)},
    {(VUINT32) ((0x7464873F877AC72CuLL) >> 0),
     (VUINT32) ((0x7464873F877AC72CuLL) >> 32)},
    {(VUINT32) ((0x4A69CFBA208D7D4BuLL) >> 0),
     (VUINT32) ((0x4A69CFBA208D7D4BuLL) >> 32)}},
   {{(VUINT32) ((0x26E9700324977504uLL) >> 0),
     (VUINT32) ((0x26E9700324977504uLL) >> 32)},
    {(VUINT32) ((0xE8C90E7F0EF58E58uLL) >> 0),
     (VUINT32) ((0xE8C90E7F0EF58E58uLL) >> 32)},
    {(VUINT32) ((0x94D39F74411AFA97uLL) >> 0),
     (VUINT32) ((0x94D39F74411AFA97uLL) >> 32)}},
   {{(VUINT32) ((0x4DD2E006492EEA09uLL) >> 0),
     (VUINT32) ((0x4DD2E006492EEA09uLL) >> 32)},
    {(VUINT32) ((0xD1921CFE1DEB1CB1uLL) >> 0),
     (VUINT32) ((0xD1921CFE1DEB1CB1uLL) >> 32)},
    {(VUINT32) ((0x29A73EE88235F52EuLL) >> 0),
     (VUINT32) ((0x29A73EE88235F52EuLL) >> 32)}},
   {{(VUINT32) ((0x9BA5C00C925DD413uLL) >> 0),
     (VUINT32) ((0x9BA5C00C925DD413uLL) >> 32)},
    {(VUINT32) ((0xA32439FC3BD63962uLL) >> 0),
     (VUINT32) ((0xA32439FC3BD63962uLL) >> 32)},
    {(VUINT32) ((0x534E7DD1046BEA5DuLL) >> 0),
     (VUINT32) ((0x534E7DD1046BEA5DuLL) >> 32)}},
   {{(VUINT32) ((0x374B801924BBA827uLL) >> 0),
     (VUINT32) ((0x374B801924BBA827uLL) >> 32)},
    {(VUINT32) ((0x464873F877AC72C4uLL) >> 0),
     (VUINT32) ((0x464873F877AC72C4uLL) >> 32)},
    {(VUINT32) ((0xA69CFBA208D7D4BAuLL) >> 0),
     (VUINT32) ((0xA69CFBA208D7D4BAuLL) >> 32)}},
   {{(VUINT32) ((0x6E9700324977504EuLL) >> 0),
     (VUINT32) ((0x6E9700324977504EuLL) >> 32)},
    {(VUINT32) ((0x8C90E7F0EF58E589uLL) >> 0),
     (VUINT32) ((0x8C90E7F0EF58E589uLL) >> 32)},
    {(VUINT32) ((0x4D39F74411AFA975uLL) >> 0),
     (VUINT32) ((0x4D39F74411AFA975uLL) >> 32)}},
   {{(VUINT32) ((0xDD2E006492EEA09DuLL) >> 0),
     (VUINT32) ((0xDD2E006492EEA09DuLL) >> 32)},
    {(VUINT32) ((0x1921CFE1DEB1CB12uLL) >> 0),
     (VUINT32) ((0x1921CFE1DEB1CB12uLL) >> 32)},
    {(VUINT32) ((0x9A73EE88235F52EBuLL) >> 0),
     (VUINT32) ((0x9A73EE88235F52EBuLL) >> 32)}},
   {{(VUINT32) ((0xBA5C00C925DD413AuLL) >> 0),
     (VUINT32) ((0xBA5C00C925DD413AuLL) >> 32)},
    {(VUINT32) ((0x32439FC3BD639625uLL) >> 0),
     (VUINT32) ((0x32439FC3BD639625uLL) >> 32)},
    {(VUINT32) ((0x34E7DD1046BEA5D7uLL) >> 0),
     (VUINT32) ((0x34E7DD1046BEA5D7uLL) >> 32)}},
   {{(VUINT32) ((0x74B801924BBA8274uLL) >> 0),
     (VUINT32) ((0x74B801924BBA8274uLL) >> 32)},
    {(VUINT32) ((0x64873F877AC72C4AuLL) >> 0),
     (VUINT32) ((0x64873F877AC72C4AuLL) >> 32)},
    {(VUINT32) ((0x69CFBA208D7D4BAEuLL) >> 0),
     (VUINT32) ((0x69CFBA208D7D4BAEuLL) >> 32)}},
   {{(VUINT32) ((0xE9700324977504E8uLL) >> 0),
     (VUINT32) ((0xE9700324977504E8uLL) >> 32)},
    {(VUINT32) ((0xC90E7F0EF58E5894uLL) >> 0),
     (VUINT32) ((0xC90E7F0EF58E5894uLL) >> 32)},
    {(VUINT32) ((0xD39F74411AFA975DuLL) >> 0),
     (VUINT32) ((0xD39F74411AFA975DuLL) >> 32)}},
   {{(VUINT32) ((0xD2E006492EEA09D1uLL) >> 0),
     (VUINT32) ((0xD2E006492EEA09D1uLL) >> 32)},
    {(VUINT32) ((0x921CFE1DEB1CB129uLL) >> 0),
     (VUINT32) ((0x921CFE1DEB1CB129uLL) >> 32)},
    {(VUINT32) ((0xA73EE88235F52EBBuLL) >> 0),
     (VUINT32) ((0xA73EE88235F52EBBuLL) >> 32)}},
   {{(VUINT32) ((0xA5C00C925DD413A3uLL) >> 0),
     (VUINT32) ((0xA5C00C925DD413A3uLL) >> 32)},
    {(VUINT32) ((0x2439FC3BD6396253uLL) >> 0),
     (VUINT32) ((0x2439FC3BD6396253uLL) >> 32)},
    {(VUINT32) ((0x4E7DD1046BEA5D76uLL) >> 0),
     (VUINT32) ((0x4E7DD1046BEA5D76uLL) >> 32)}},
   {{(VUINT32) ((0x4B801924BBA82746uLL) >> 0),
     (VUINT32) ((0x4B801924BBA82746uLL) >> 32)},
    {(VUINT32) ((0x4873F877AC72C4A6uLL) >> 0),
     (VUINT32) ((0x4873F877AC72C4A6uLL) >> 32)},
    {(VUINT32) ((0x9CFBA208D7D4BAEDuLL) >> 0),
     (VUINT32) ((0x9CFBA208D7D4BAEDuLL) >> 32)}},
   {{(VUINT32) ((0x9700324977504E8CuLL) >> 0),
     (VUINT32) ((0x9700324977504E8CuLL) >> 32)},
    {(VUINT32) ((0x90E7F0EF58E5894DuLL) >> 0),
     (VUINT32) ((0x90E7F0EF58E5894DuLL) >> 32)},
    {(VUINT32) ((0x39F74411AFA975DAuLL) >> 0),
     (VUINT32) ((0x39F74411AFA975DAuLL) >> 32)}},
   {{(VUINT32) ((0x2E006492EEA09D19uLL) >> 0),
     (VUINT32) ((0x2E006492EEA09D19uLL) >> 32)},
    {(VUINT32) ((0x21CFE1DEB1CB129AuLL) >> 0),
     (VUINT32) ((0x21CFE1DEB1CB129AuLL) >> 32)},
    {(VUINT32) ((0x73EE88235F52EBB4uLL) >> 0),
     (VUINT32) ((0x73EE88235F52EBB4uLL) >> 32)}},
   {{(VUINT32) ((0x5C00C925DD413A32uLL) >> 0),
     (VUINT32) ((0x5C00C925DD413A32uLL) >> 32)},
    {(VUINT32) ((0x439FC3BD63962534uLL) >> 0),
     (VUINT32) ((0x439FC3BD63962534uLL) >> 32)},
    {(VUINT32) ((0xE7DD1046BEA5D768uLL) >> 0),
     (VUINT32) ((0xE7DD1046BEA5D768uLL) >> 32)}},
   {{(VUINT32) ((0xB801924BBA827464uLL) >> 0),
     (VUINT32) ((0xB801924BBA827464uLL) >> 32)},
    {(VUINT32) ((0x873F877AC72C4A69uLL) >> 0),
     (VUINT32) ((0x873F877AC72C4A69uLL) >> 32)},
    {(VUINT32) ((0xCFBA208D7D4BAED1uLL) >> 0),
     (VUINT32) ((0xCFBA208D7D4BAED1uLL) >> 32)}},
   {{(VUINT32) ((0x700324977504E8C9uLL) >> 0),
     (VUINT32) ((0x700324977504E8C9uLL) >> 32)},
    {(VUINT32) ((0x0E7F0EF58E5894D3uLL) >> 0),
     (VUINT32) ((0x0E7F0EF58E5894D3uLL) >> 32)},
    {(VUINT32) ((0x9F74411AFA975DA2uLL) >> 0),
     (VUINT32) ((0x9F74411AFA975DA2uLL) >> 32)}},
   {{(VUINT32) ((0xE006492EEA09D192uLL) >> 0),
     (VUINT32) ((0xE006492EEA09D192uLL) >> 32)},
    {(VUINT32) ((0x1CFE1DEB1CB129A7uLL) >> 0),
     (VUINT32) ((0x1CFE1DEB1CB129A7uLL) >> 32)},
    {(VUINT32) ((0x3EE88235F52EBB44uLL) >> 0),
     (VUINT32) ((0x3EE88235F52EBB44uLL) >> 32)}},
   {{(VUINT32) ((0xC00C925DD413A324uLL) >> 0),
     (VUINT32) ((0xC00C925DD413A324uLL) >> 32)},
    {(VUINT32) ((0x39FC3BD63962534EuLL) >> 0),
     (VUINT32) ((0x39FC3BD63962534EuLL) >> 32)},
    {(VUINT32) ((0x7DD1046BEA5D7689uLL) >> 0),
     (VUINT32) ((0x7DD1046BEA5D7689uLL) >> 32)}},
   {{(VUINT32) ((0x801924BBA8274648uLL) >> 0),
     (VUINT32) ((0x801924BBA8274648uLL) >> 32)},
    {(VUINT32) ((0x73F877AC72C4A69CuLL) >> 0),
     (VUINT32) ((0x73F877AC72C4A69CuLL) >> 32)},
    {(VUINT32) ((0xFBA208D7D4BAED12uLL) >> 0),
     (VUINT32) ((0xFBA208D7D4BAED12uLL) >> 32)}},
   {{(VUINT32) ((0x00324977504E8C90uLL) >> 0),
     (VUINT32) ((0x00324977504E8C90uLL) >> 32)},
    {(VUINT32) ((0xE7F0EF58E5894D39uLL) >> 0),
     (VUINT32) ((0xE7F0EF58E5894D39uLL) >> 32)},
    {(VUINT32) ((0xF74411AFA975DA24uLL) >> 0),
     (VUINT32) ((0xF74411AFA975DA24uLL) >> 32)}},
   {{(VUINT32) ((0x006492EEA09D1921uLL) >> 0),
     (VUINT32) ((0x006492EEA09D1921uLL) >> 32)},
    {(VUINT32) ((0xCFE1DEB1CB129A73uLL) >> 0),
     (VUINT32) ((0xCFE1DEB1CB129A73uLL) >> 32)},
    {(VUINT32) ((0xEE88235F52EBB448uLL) >> 0),
     (VUINT32) ((0xEE88235F52EBB448uLL) >> 32)}},
   {{(VUINT32) ((0x00C925DD413A3243uLL) >> 0),
     (VUINT32) ((0x00C925DD413A3243uLL) >> 32)},
    {(VUINT32) ((0x9FC3BD63962534E7uLL) >> 0),
     (VUINT32) ((0x9FC3BD63962534E7uLL) >> 32)},
    {(VUINT32) ((0xDD1046BEA5D76890uLL) >> 0),
     (VUINT32) ((0xDD1046BEA5D76890uLL) >> 32)}},
   {{(VUINT32) ((0x01924BBA82746487uLL) >> 0),
     (VUINT32) ((0x01924BBA82746487uLL) >> 32)},
    {(VUINT32) ((0x3F877AC72C4A69CFuLL) >> 0),
     (VUINT32) ((0x3F877AC72C4A69CFuLL) >> 32)},
    {(VUINT32) ((0xBA208D7D4BAED121uLL) >> 0),
     (VUINT32) ((0xBA208D7D4BAED121uLL) >> 32)}},
   {{(VUINT32) ((0x0324977504E8C90EuLL) >> 0),
     (VUINT32) ((0x0324977504E8C90EuLL) >> 32)},
    {(VUINT32) ((0x7F0EF58E5894D39FuLL) >> 0),
     (VUINT32) ((0x7F0EF58E5894D39FuLL) >> 32)},
    {(VUINT32) ((0x74411AFA975DA242uLL) >> 0),
     (VUINT32) ((0x74411AFA975DA242uLL) >> 32)}},
   {{(VUINT32) ((0x06492EEA09D1921CuLL) >> 0),
     (VUINT32) ((0x06492EEA09D1921CuLL) >> 32)},
    {(VUINT32) ((0xFE1DEB1CB129A73EuLL) >> 0),
     (VUINT32) ((0xFE1DEB1CB129A73EuLL) >> 32)},
    {(VUINT32) ((0xE88235F52EBB4484uLL) >> 0),
     (VUINT32) ((0xE88235F52EBB4484uLL) >> 32)}},
   {{(VUINT32) ((0x0C925DD413A32439uLL) >> 0),
     (VUINT32) ((0x0C925DD413A32439uLL) >> 32)},
    {(VUINT32) ((0xFC3BD63962534E7DuLL) >> 0),
     (VUINT32) ((0xFC3BD63962534E7DuLL) >> 32)},
    {(VUINT32) ((0xD1046BEA5D768909uLL) >> 0),
     (VUINT32) ((0xD1046BEA5D768909uLL) >> 32)}},
   {{(VUINT32) ((0x1924BBA827464873uLL) >> 0),
     (VUINT32) ((0x1924BBA827464873uLL) >> 32)},
    {(VUINT32) ((0xF877AC72C4A69CFBuLL) >> 0),
     (VUINT32) ((0xF877AC72C4A69CFBuLL) >> 32)},
    {(VUINT32) ((0xA208D7D4BAED1213uLL) >> 0),
     (VUINT32) ((0xA208D7D4BAED1213uLL) >> 32)}},
   {{(VUINT32) ((0x324977504E8C90E7uLL) >> 0),
     (VUINT32) ((0x324977504E8C90E7uLL) >> 32)},
    {(VUINT32) ((0xF0EF58E5894D39F7uLL) >> 0),
     (VUINT32) ((0xF0EF58E5894D39F7uLL) >> 32)},
    {(VUINT32) ((0x4411AFA975DA2427uLL) >> 0),
     (VUINT32) ((0x4411AFA975DA2427uLL) >> 32)}},
   {{(VUINT32) ((0x6492EEA09D1921CFuLL) >> 0),
     (VUINT32) ((0x6492EEA09D1921CFuLL) >> 32)},
    {(VUINT32) ((0xE1DEB1CB129A73EEuLL) >> 0),
     (VUINT32) ((0xE1DEB1CB129A73EEuLL) >> 32)},
    {(VUINT32) ((0x88235F52EBB4484EuLL) >> 0),
     (VUINT32) ((0x88235F52EBB4484EuLL) >> 32)}},
   {{(VUINT32) ((0xC925DD413A32439FuLL) >> 0),
     (VUINT32) ((0xC925DD413A32439FuLL) >> 32)},
    {(VUINT32) ((0xC3BD63962534E7DDuLL) >> 0),
     (VUINT32) ((0xC3BD63962534E7DDuLL) >> 32)},
    {(VUINT32) ((0x1046BEA5D768909DuLL) >> 0),
     (VUINT32) ((0x1046BEA5D768909DuLL) >> 32)}},
   {{(VUINT32) ((0x924BBA827464873FuLL) >> 0),
     (VUINT32) ((0x924BBA827464873FuLL) >> 32)},
    {(VUINT32) ((0x877AC72C4A69CFBAuLL) >> 0),
     (VUINT32) ((0x877AC72C4A69CFBAuLL) >> 32)},
    {(VUINT32) ((0x208D7D4BAED1213AuLL) >> 0),
     (VUINT32) ((0x208D7D4BAED1213AuLL) >> 32)}},
   {{(VUINT32) ((0x24977504E8C90E7FuLL) >> 0),
     (VUINT32) ((0x24977504E8C90E7FuLL) >> 32)},
    {(VUINT32) ((0x0EF58E5894D39F74uLL) >> 0),
     (VUINT32) ((0x0EF58E5894D39F74uLL) >> 32)},
    {(VUINT32) ((0x411AFA975DA24274uLL) >> 0),
     (VUINT32) ((0x411AFA975DA24274uLL) >> 32)}},
   {{(VUINT32) ((0x492EEA09D1921CFEuLL) >> 0),
     (VUINT32) ((0x492EEA09D1921CFEuLL) >> 32)},
    {(VUINT32) ((0x1DEB1CB129A73EE8uLL) >> 0),
     (VUINT32) ((0x1DEB1CB129A73EE8uLL) >> 32)},
    {(VUINT32) ((0x8235F52EBB4484E9uLL) >> 0),
     (VUINT32) ((0x8235F52EBB4484E9uLL) >> 32)}},
   {{(VUINT32) ((0x925DD413A32439FCuLL) >> 0),
     (VUINT32) ((0x925DD413A32439FCuLL) >> 32)},
    {(VUINT32) ((0x3BD63962534E7DD1uLL) >> 0),
     (VUINT32) ((0x3BD63962534E7DD1uLL) >> 32)},
    {(VUINT32) ((0x046BEA5D768909D3uLL) >> 0),
     (VUINT32) ((0x046BEA5D768909D3uLL) >> 32)}},
   {{(VUINT32) ((0x24BBA827464873F8uLL) >> 0),
     (VUINT32) ((0x24BBA827464873F8uLL) >> 32)},
    {(VUINT32) ((0x77AC72C4A69CFBA2uLL) >> 0),
     (VUINT32) ((0x77AC72C4A69CFBA2uLL) >> 32)},
    {(VUINT32) ((0x08D7D4BAED1213A6uLL) >> 0),
     (VUINT32) ((0x08D7D4BAED1213A6uLL) >> 32)}},
   {{(VUINT32) ((0x4977504E8C90E7F0uLL) >> 0),
     (VUINT32) ((0x4977504E8C90E7F0uLL) >> 32)},
    {(VUINT32) ((0xEF58E5894D39F744uLL) >> 0),
     (VUINT32) ((0xEF58E5894D39F744uLL) >> 32)},
    {(VUINT32) ((0x11AFA975DA24274CuLL) >> 0),
     (VUINT32) ((0x11AFA975DA24274CuLL) >> 32)}},
   {{(VUINT32) ((0x92EEA09D1921CFE1uLL) >> 0),
     (VUINT32) ((0x92EEA09D1921CFE1uLL) >> 32)},
    {(VUINT32) ((0xDEB1CB129A73EE88uLL) >> 0),
     (VUINT32) ((0xDEB1CB129A73EE88uLL) >> 32)},
    {(VUINT32) ((0x235F52EBB4484E99uLL) >> 0),
     (VUINT32) ((0x235F52EBB4484E99uLL) >> 32)}},
   {{(VUINT32) ((0x25DD413A32439FC3uLL) >> 0),
     (VUINT32) ((0x25DD413A32439FC3uLL) >> 32)},
    {(VUINT32) ((0xBD63962534E7DD10uLL) >> 0),
     (VUINT32) ((0xBD63962534E7DD10uLL) >> 32)},
    {(VUINT32) ((0x46BEA5D768909D33uLL) >> 0),
     (VUINT32) ((0x46BEA5D768909D33uLL) >> 32)}},
   {{(VUINT32) ((0x4BBA827464873F87uLL) >> 0),
     (VUINT32) ((0x4BBA827464873F87uLL) >> 32)},
    {(VUINT32) ((0x7AC72C4A69CFBA20uLL) >> 0),
     (VUINT32) ((0x7AC72C4A69CFBA20uLL) >> 32)},
    {(VUINT32) ((0x8D7D4BAED1213A67uLL) >> 0),
     (VUINT32) ((0x8D7D4BAED1213A67uLL) >> 32)}},
   {{(VUINT32) ((0x977504E8C90E7F0EuLL) >> 0),
     (VUINT32) ((0x977504E8C90E7F0EuLL) >> 32)},
    {(VUINT32) ((0xF58E5894D39F7441uLL) >> 0),
     (VUINT32) ((0xF58E5894D39F7441uLL) >> 32)},
    {(VUINT32) ((0x1AFA975DA24274CEuLL) >> 0),
     (VUINT32) ((0x1AFA975DA24274CEuLL) >> 32)}},
   {{(VUINT32) ((0x2EEA09D1921CFE1DuLL) >> 0),
     (VUINT32) ((0x2EEA09D1921CFE1DuLL) >> 32)},
    {(VUINT32) ((0xEB1CB129A73EE882uLL) >> 0),
     (VUINT32) ((0xEB1CB129A73EE882uLL) >> 32)},
    {(VUINT32) ((0x35F52EBB4484E99CuLL) >> 0),
     (VUINT32) ((0x35F52EBB4484E99CuLL) >> 32)}},
   {{(VUINT32) ((0x5DD413A32439FC3BuLL) >> 0),
     (VUINT32) ((0x5DD413A32439FC3BuLL) >> 32)},
    {(VUINT32) ((0xD63962534E7DD104uLL) >> 0),
     (VUINT32) ((0xD63962534E7DD104uLL) >> 32)},
    {(VUINT32) ((0x6BEA5D768909D338uLL) >> 0),
     (VUINT32) ((0x6BEA5D768909D338uLL) >> 32)}},
   {{(VUINT32) ((0xBBA827464873F877uLL) >> 0),
     (VUINT32) ((0xBBA827464873F877uLL) >> 32)},
    {(VUINT32) ((0xAC72C4A69CFBA208uLL) >> 0),
     (VUINT32) ((0xAC72C4A69CFBA208uLL) >> 32)},
    {(VUINT32) ((0xD7D4BAED1213A671uLL) >> 0),
     (VUINT32) ((0xD7D4BAED1213A671uLL) >> 32)}},
   {{(VUINT32) ((0x77504E8C90E7F0EFuLL) >> 0),
     (VUINT32) ((0x77504E8C90E7F0EFuLL) >> 32)},
    {(VUINT32) ((0x58E5894D39F74411uLL) >> 0),
     (VUINT32) ((0x58E5894D39F74411uLL) >> 32)},
    {(VUINT32) ((0xAFA975DA24274CE3uLL) >> 0),
     (VUINT32) ((0xAFA975DA24274CE3uLL) >> 32)}},
   {{(VUINT32) ((0xEEA09D1921CFE1DEuLL) >> 0),
     (VUINT32) ((0xEEA09D1921CFE1DEuLL) >> 32)},
    {(VUINT32) ((0xB1CB129A73EE8823uLL) >> 0),
     (VUINT32) ((0xB1CB129A73EE8823uLL) >> 32)},
    {(VUINT32) ((0x5F52EBB4484E99C7uLL) >> 0),
     (VUINT32) ((0x5F52EBB4484E99C7uLL) >> 32)}},
   {{(VUINT32) ((0xDD413A32439FC3BDuLL) >> 0),
     (VUINT32) ((0xDD413A32439FC3BDuLL) >> 32)},
    {(VUINT32) ((0x63962534E7DD1046uLL) >> 0),
     (VUINT32) ((0x63962534E7DD1046uLL) >> 32)},
    {(VUINT32) ((0xBEA5D768909D338EuLL) >> 0),
     (VUINT32) ((0xBEA5D768909D338EuLL) >> 32)}},
   {{(VUINT32) ((0xBA827464873F877AuLL) >> 0),
     (VUINT32) ((0xBA827464873F877AuLL) >> 32)},
    {(VUINT32) ((0xC72C4A69CFBA208DuLL) >> 0),
     (VUINT32) ((0xC72C4A69CFBA208DuLL) >> 32)},
    {(VUINT32) ((0x7D4BAED1213A671CuLL) >> 0),
     (VUINT32) ((0x7D4BAED1213A671CuLL) >> 32)}},
   {{(VUINT32) ((0x7504E8C90E7F0EF5uLL) >> 0),
     (VUINT32) ((0x7504E8C90E7F0EF5uLL) >> 32)},
    {(VUINT32) ((0x8E5894D39F74411AuLL) >> 0),
     (VUINT32) ((0x8E5894D39F74411AuLL) >> 32)},
    {(VUINT32) ((0xFA975DA24274CE38uLL) >> 0),
     (VUINT32) ((0xFA975DA24274CE38uLL) >> 32)}},
   {{(VUINT32) ((0xEA09D1921CFE1DEBuLL) >> 0),
     (VUINT32) ((0xEA09D1921CFE1DEBuLL) >> 32)},
    {(VUINT32) ((0x1CB129A73EE88235uLL) >> 0),
     (VUINT32) ((0x1CB129A73EE88235uLL) >> 32)},
    {(VUINT32) ((0xF52EBB4484E99C70uLL) >> 0),
     (VUINT32) ((0xF52EBB4484E99C70uLL) >> 32)}},
   {{(VUINT32) ((0xD413A32439FC3BD6uLL) >> 0),
     (VUINT32) ((0xD413A32439FC3BD6uLL) >> 32)},
    {(VUINT32) ((0x3962534E7DD1046BuLL) >> 0),
     (VUINT32) ((0x3962534E7DD1046BuLL) >> 32)},
    {(VUINT32) ((0xEA5D768909D338E0uLL) >> 0),
     (VUINT32) ((0xEA5D768909D338E0uLL) >> 32)}},
   {{(VUINT32) ((0xA827464873F877ACuLL) >> 0),
     (VUINT32) ((0xA827464873F877ACuLL) >> 32)},
    {(VUINT32) ((0x72C4A69CFBA208D7uLL) >> 0),
     (VUINT32) ((0x72C4A69CFBA208D7uLL) >> 32)},
    {(VUINT32) ((0xD4BAED1213A671C0uLL) >> 0),
     (VUINT32) ((0xD4BAED1213A671C0uLL) >> 32)}},
   {{(VUINT32) ((0x504E8C90E7F0EF58uLL) >> 0),
     (VUINT32) ((0x504E8C90E7F0EF58uLL) >> 32)},
    {(VUINT32) ((0xE5894D39F74411AFuLL) >> 0),
     (VUINT32) ((0xE5894D39F74411AFuLL) >> 32)},
    {(VUINT32) ((0xA975DA24274CE381uLL) >> 0),
     (VUINT32) ((0xA975DA24274CE381uLL) >> 32)}},
   {{(VUINT32) ((0xA09D1921CFE1DEB1uLL) >> 0),
     (VUINT32) ((0xA09D1921CFE1DEB1uLL) >> 32)},
    {(VUINT32) ((0xCB129A73EE88235FuLL) >> 0),
     (VUINT32) ((0xCB129A73EE88235FuLL) >> 32)},
    {(VUINT32) ((0x52EBB4484E99C702uLL) >> 0),
     (VUINT32) ((0x52EBB4484E99C702uLL) >> 32)}},
   {{(VUINT32) ((0x413A32439FC3BD63uLL) >> 0),
     (VUINT32) ((0x413A32439FC3BD63uLL) >> 32)},
    {(VUINT32) ((0x962534E7DD1046BEuLL) >> 0),
     (VUINT32) ((0x962534E7DD1046BEuLL) >> 32)},
    {(VUINT32) ((0xA5D768909D338E04uLL) >> 0),
     (VUINT32) ((0xA5D768909D338E04uLL) >> 32)}},
   {{(VUINT32) ((0x827464873F877AC7uLL) >> 0),
     (VUINT32) ((0x827464873F877AC7uLL) >> 32)},
    {(VUINT32) ((0x2C4A69CFBA208D7DuLL) >> 0),
     (VUINT32) ((0x2C4A69CFBA208D7DuLL) >> 32)},
    {(VUINT32) ((0x4BAED1213A671C09uLL) >> 0),
     (VUINT32) ((0x4BAED1213A671C09uLL) >> 32)}},
   {{(VUINT32) ((0x04E8C90E7F0EF58EuLL) >> 0),
     (VUINT32) ((0x04E8C90E7F0EF58EuLL) >> 32)},
    {(VUINT32) ((0x5894D39F74411AFAuLL) >> 0),
     (VUINT32) ((0x5894D39F74411AFAuLL) >> 32)},
    {(VUINT32) ((0x975DA24274CE3813uLL) >> 0),
     (VUINT32) ((0x975DA24274CE3813uLL) >> 32)}},
   {{(VUINT32) ((0x09D1921CFE1DEB1CuLL) >> 0),
     (VUINT32) ((0x09D1921CFE1DEB1CuLL) >> 32)},
    {(VUINT32) ((0xB129A73EE88235F5uLL) >> 0),
     (VUINT32) ((0xB129A73EE88235F5uLL) >> 32)},
    {(VUINT32) ((0x2EBB4484E99C7026uLL) >> 0),
     (VUINT32) ((0x2EBB4484E99C7026uLL) >> 32)}},
   {{(VUINT32) ((0x13A32439FC3BD639uLL) >> 0),
     (VUINT32) ((0x13A32439FC3BD639uLL) >> 32)},
    {(VUINT32) ((0x62534E7DD1046BEAuLL) >> 0),
     (VUINT32) ((0x62534E7DD1046BEAuLL) >> 32)},
    {(VUINT32) ((0x5D768909D338E04DuLL) >> 0),
     (VUINT32) ((0x5D768909D338E04DuLL) >> 32)}},
   {{(VUINT32) ((0x27464873F877AC72uLL) >> 0),
     (VUINT32) ((0x27464873F877AC72uLL) >> 32)},
    {(VUINT32) ((0xC4A69CFBA208D7D4uLL) >> 0),
     (VUINT32) ((0xC4A69CFBA208D7D4uLL) >> 32)},
    {(VUINT32) ((0xBAED1213A671C09AuLL) >> 0),
     (VUINT32) ((0xBAED1213A671C09AuLL) >> 32)}},
   {{(VUINT32) ((0x4E8C90E7F0EF58E5uLL) >> 0),
     (VUINT32) ((0x4E8C90E7F0EF58E5uLL) >> 32)},
    {(VUINT32) ((0x894D39F74411AFA9uLL) >> 0),
     (VUINT32) ((0x894D39F74411AFA9uLL) >> 32)},
    {(VUINT32) ((0x75DA24274CE38135uLL) >> 0),
     (VUINT32) ((0x75DA24274CE38135uLL) >> 32)}},
   {{(VUINT32) ((0x9D1921CFE1DEB1CBuLL) >> 0),
     (VUINT32) ((0x9D1921CFE1DEB1CBuLL) >> 32)},
    {(VUINT32) ((0x129A73EE88235F52uLL) >> 0),
     (VUINT32) ((0x129A73EE88235F52uLL) >> 32)},
    {(VUINT32) ((0xEBB4484E99C7026BuLL) >> 0),
     (VUINT32) ((0xEBB4484E99C7026BuLL) >> 32)}},
   {{(VUINT32) ((0x3A32439FC3BD6396uLL) >> 0),
     (VUINT32) ((0x3A32439FC3BD6396uLL) >> 32)},
    {(VUINT32) ((0x2534E7DD1046BEA5uLL) >> 0),
     (VUINT32) ((0x2534E7DD1046BEA5uLL) >> 32)},
    {(VUINT32) ((0xD768909D338E04D6uLL) >> 0),
     (VUINT32) ((0xD768909D338E04D6uLL) >> 32)}},
   {{(VUINT32) ((0x7464873F877AC72CuLL) >> 0),
     (VUINT32) ((0x7464873F877AC72CuLL) >> 32)},
    {(VUINT32) ((0x4A69CFBA208D7D4BuLL) >> 0),
     (VUINT32) ((0x4A69CFBA208D7D4BuLL) >> 32)},
    {(VUINT32) ((0xAED1213A671C09ADuLL) >> 0),
     (VUINT32) ((0xAED1213A671C09ADuLL) >> 32)}},
   {{(VUINT32) ((0xE8C90E7F0EF58E58uLL) >> 0),
     (VUINT32) ((0xE8C90E7F0EF58E58uLL) >> 32)},
    {(VUINT32) ((0x94D39F74411AFA97uLL) >> 0),
     (VUINT32) ((0x94D39F74411AFA97uLL) >> 32)},
    {(VUINT32) ((0x5DA24274CE38135AuLL) >> 0),
     (VUINT32) ((0x5DA24274CE38135AuLL) >> 32)}},
   {{(VUINT32) ((0xD1921CFE1DEB1CB1uLL) >> 0),
     (VUINT32) ((0xD1921CFE1DEB1CB1uLL) >> 32)},
    {(VUINT32) ((0x29A73EE88235F52EuLL) >> 0),
     (VUINT32) ((0x29A73EE88235F52EuLL) >> 32)},
    {(VUINT32) ((0xBB4484E99C7026B4uLL) >> 0),
     (VUINT32) ((0xBB4484E99C7026B4uLL) >> 32)}},
   {{(VUINT32) ((0xA32439FC3BD63962uLL) >> 0),
     (VUINT32) ((0xA32439FC3BD63962uLL) >> 32)},
    {(VUINT32) ((0x534E7DD1046BEA5DuLL) >> 0),
     (VUINT32) ((0x534E7DD1046BEA5DuLL) >> 32)},
    {(VUINT32) ((0x768909D338E04D68uLL) >> 0),
     (VUINT32) ((0x768909D338E04D68uLL) >> 32)}},
   {{(VUINT32) ((0x464873F877AC72C4uLL) >> 0),
     (VUINT32) ((0x464873F877AC72C4uLL) >> 32)},
    {(VUINT32) ((0xA69CFBA208D7D4BAuLL) >> 0),
     (VUINT32) ((0xA69CFBA208D7D4BAuLL) >> 32)},
    {(VUINT32) ((0xED1213A671C09AD1uLL) >> 0),
     (VUINT32) ((0xED1213A671C09AD1uLL) >> 32)}},
   {{(VUINT32) ((0x8C90E7F0EF58E589uLL) >> 0),
     (VUINT32) ((0x8C90E7F0EF58E589uLL) >> 32)},
    {(VUINT32) ((0x4D39F74411AFA975uLL) >> 0),
     (VUINT32) ((0x4D39F74411AFA975uLL) >> 32)},
    {(VUINT32) ((0xDA24274CE38135A2uLL) >> 0),
     (VUINT32) ((0xDA24274CE38135A2uLL) >> 32)}},
   {{(VUINT32) ((0x1921CFE1DEB1CB12uLL) >> 0),
     (VUINT32) ((0x1921CFE1DEB1CB12uLL) >> 32)},
    {(VUINT32) ((0x9A73EE88235F52EBuLL) >> 0),
     (VUINT32) ((0x9A73EE88235F52EBuLL) >> 32)},
    {(VUINT32) ((0xB4484E99C7026B45uLL) >> 0),
     (VUINT32) ((0xB4484E99C7026B45uLL) >> 32)}},
   {{(VUINT32) ((0x32439FC3BD639625uLL) >> 0),
     (VUINT32) ((0x32439FC3BD639625uLL) >> 32)},
    {(VUINT32) ((0x34E7DD1046BEA5D7uLL) >> 0),
     (VUINT32) ((0x34E7DD1046BEA5D7uLL) >> 32)},
    {(VUINT32) ((0x68909D338E04D68BuLL) >> 0),
     (VUINT32) ((0x68909D338E04D68BuLL) >> 32)}},
   {{(VUINT32) ((0x64873F877AC72C4AuLL) >> 0),
     (VUINT32) ((0x64873F877AC72C4AuLL) >> 32)},
    {(VUINT32) ((0x69CFBA208D7D4BAEuLL) >> 0),
     (VUINT32) ((0x69CFBA208D7D4BAEuLL) >> 32)},
    {(VUINT32) ((0xD1213A671C09AD17uLL) >> 0),
     (VUINT32) ((0xD1213A671C09AD17uLL) >> 32)}},
   {{(VUINT32) ((0xC90E7F0EF58E5894uLL) >> 0),
     (VUINT32) ((0xC90E7F0EF58E5894uLL) >> 32)},
    {(VUINT32) ((0xD39F74411AFA975DuLL) >> 0),
     (VUINT32) ((0xD39F74411AFA975DuLL) >> 32)},
    {(VUINT32) ((0xA24274CE38135A2FuLL) >> 0),
     (VUINT32) ((0xA24274CE38135A2FuLL) >> 32)}},
   {{(VUINT32) ((0x921CFE1DEB1CB129uLL) >> 0),
     (VUINT32) ((0x921CFE1DEB1CB129uLL) >> 32)},
    {(VUINT32) ((0xA73EE88235F52EBBuLL) >> 0),
     (VUINT32) ((0xA73EE88235F52EBBuLL) >> 32)},
    {(VUINT32) ((0x4484E99C7026B45FuLL) >> 0),
     (VUINT32) ((0x4484E99C7026B45FuLL) >> 32)}},
   {{(VUINT32) ((0x2439FC3BD6396253uLL) >> 0),
     (VUINT32) ((0x2439FC3BD6396253uLL) >> 32)},
    {(VUINT32) ((0x4E7DD1046BEA5D76uLL) >> 0),
     (VUINT32) ((0x4E7DD1046BEA5D76uLL) >> 32)},
    {(VUINT32) ((0x8909D338E04D68BEuLL) >> 0),
     (VUINT32) ((0x8909D338E04D68BEuLL) >> 32)}},
   {{(VUINT32) ((0x4873F877AC72C4A6uLL) >> 0),
     (VUINT32) ((0x4873F877AC72C4A6uLL) >> 32)},
    {(VUINT32) ((0x9CFBA208D7D4BAEDuLL) >> 0),
     (VUINT32) ((0x9CFBA208D7D4BAEDuLL) >> 32)},
    {(VUINT32) ((0x1213A671C09AD17DuLL) >> 0),
     (VUINT32) ((0x1213A671C09AD17DuLL) >> 32)}},
   {{(VUINT32) ((0x90E7F0EF58E5894DuLL) >> 0),
     (VUINT32) ((0x90E7F0EF58E5894DuLL) >> 32)},
    {(VUINT32) ((0x39F74411AFA975DAuLL) >> 0),
     (VUINT32) ((0x39F74411AFA975DAuLL) >> 32)},
    {(VUINT32) ((0x24274CE38135A2FBuLL) >> 0),
     (VUINT32) ((0x24274CE38135A2FBuLL) >> 32)}},
   {{(VUINT32) ((0x21CFE1DEB1CB129AuLL) >> 0),
     (VUINT32) ((0x21CFE1DEB1CB129AuLL) >> 32)},
    {(VUINT32) ((0x73EE88235F52EBB4uLL) >> 0),
     (VUINT32) ((0x73EE88235F52EBB4uLL) >> 32)},
    {(VUINT32) ((0x484E99C7026B45F7uLL) >> 0),
     (VUINT32) ((0x484E99C7026B45F7uLL) >> 32)}},
   {{(VUINT32) ((0x439FC3BD63962534uLL) >> 0),
     (VUINT32) ((0x439FC3BD63962534uLL) >> 32)},
    {(VUINT32) ((0xE7DD1046BEA5D768uLL) >> 0),
     (VUINT32) ((0xE7DD1046BEA5D768uLL) >> 32)},
    {(VUINT32) ((0x909D338E04D68BEFuLL) >> 0),
     (VUINT32) ((0x909D338E04D68BEFuLL) >> 32)}},
   {{(VUINT32) ((0x873F877AC72C4A69uLL) >> 0),
     (VUINT32) ((0x873F877AC72C4A69uLL) >> 32)},
    {(VUINT32) ((0xCFBA208D7D4BAED1uLL) >> 0),
     (VUINT32) ((0xCFBA208D7D4BAED1uLL) >> 32)},
    {(VUINT32) ((0x213A671C09AD17DFuLL) >> 0),
     (VUINT32) ((0x213A671C09AD17DFuLL) >> 32)}},
   {{(VUINT32) ((0x0E7F0EF58E5894D3uLL) >> 0),
     (VUINT32) ((0x0E7F0EF58E5894D3uLL) >> 32)},
    {(VUINT32) ((0x9F74411AFA975DA2uLL) >> 0),
     (VUINT32) ((0x9F74411AFA975DA2uLL) >> 32)},
    {(VUINT32) ((0x4274CE38135A2FBFuLL) >> 0),
     (VUINT32) ((0x4274CE38135A2FBFuLL) >> 32)}},
   {{(VUINT32) ((0x1CFE1DEB1CB129A7uLL) >> 0),
     (VUINT32) ((0x1CFE1DEB1CB129A7uLL) >> 32)},
    {(VUINT32) ((0x3EE88235F52EBB44uLL) >> 0),
     (VUINT32) ((0x3EE88235F52EBB44uLL) >> 32)},
    {(VUINT32) ((0x84E99C7026B45F7EuLL) >> 0),
     (VUINT32) ((0x84E99C7026B45F7EuLL) >> 32)}},
   {{(VUINT32) ((0x39FC3BD63962534EuLL) >> 0),
     (VUINT32) ((0x39FC3BD63962534EuLL) >> 32)},
    {(VUINT32) ((0x7DD1046BEA5D7689uLL) >> 0),
     (VUINT32) ((0x7DD1046BEA5D7689uLL) >> 32)},
    {(VUINT32) ((0x09D338E04D68BEFCuLL) >> 0),
     (VUINT32) ((0x09D338E04D68BEFCuLL) >> 32)}},
   {{(VUINT32) ((0x73F877AC72C4A69CuLL) >> 0),
     (VUINT32) ((0x73F877AC72C4A69CuLL) >> 32)},
    {(VUINT32) ((0xFBA208D7D4BAED12uLL) >> 0),
     (VUINT32) ((0xFBA208D7D4BAED12uLL) >> 32)},
    {(VUINT32) ((0x13A671C09AD17DF9uLL) >> 0),
     (VUINT32) ((0x13A671C09AD17DF9uLL) >> 32)}},
   {{(VUINT32) ((0xE7F0EF58E5894D39uLL) >> 0),
     (VUINT32) ((0xE7F0EF58E5894D39uLL) >> 32)},
    {(VUINT32) ((0xF74411AFA975DA24uLL) >> 0),
     (VUINT32) ((0xF74411AFA975DA24uLL) >> 32)},
    {(VUINT32) ((0x274CE38135A2FBF2uLL) >> 0),
     (VUINT32) ((0x274CE38135A2FBF2uLL) >> 32)}},
   {{(VUINT32) ((0xCFE1DEB1CB129A73uLL) >> 0),
     (VUINT32) ((0xCFE1DEB1CB129A73uLL) >> 32)},
    {(VUINT32) ((0xEE88235F52EBB448uLL) >> 0),
     (VUINT32) ((0xEE88235F52EBB448uLL) >> 32)},
    {(VUINT32) ((0x4E99C7026B45F7E4uLL) >> 0),
     (VUINT32) ((0x4E99C7026B45F7E4uLL) >> 32)}},
   {{(VUINT32) ((0x9FC3BD63962534E7uLL) >> 0),
     (VUINT32) ((0x9FC3BD63962534E7uLL) >> 32)},
    {(VUINT32) ((0xDD1046BEA5D76890uLL) >> 0),
     (VUINT32) ((0xDD1046BEA5D76890uLL) >> 32)},
    {(VUINT32) ((0x9D338E04D68BEFC8uLL) >> 0),
     (VUINT32) ((0x9D338E04D68BEFC8uLL) >> 32)}},
   {{(VUINT32) ((0x3F877AC72C4A69CFuLL) >> 0),
     (VUINT32) ((0x3F877AC72C4A69CFuLL) >> 32)},
    {(VUINT32) ((0xBA208D7D4BAED121uLL) >> 0),
     (VUINT32) ((0xBA208D7D4BAED121uLL) >> 32)},
    {(VUINT32) ((0x3A671C09AD17DF90uLL) >> 0),
     (VUINT32) ((0x3A671C09AD17DF90uLL) >> 32)}},
   {{(VUINT32) ((0x7F0EF58E5894D39FuLL) >> 0),
     (VUINT32) ((0x7F0EF58E5894D39FuLL) >> 32)},
    {(VUINT32) ((0x74411AFA975DA242uLL) >> 0),
     (VUINT32) ((0x74411AFA975DA242uLL) >> 32)},
    {(VUINT32) ((0x74CE38135A2FBF20uLL) >> 0),
     (VUINT32) ((0x74CE38135A2FBF20uLL) >> 32)}},
   {{(VUINT32) ((0xFE1DEB1CB129A73EuLL) >> 0),
     (VUINT32) ((0xFE1DEB1CB129A73EuLL) >> 32)},
    {(VUINT32) ((0xE88235F52EBB4484uLL) >> 0),
     (VUINT32) ((0xE88235F52EBB4484uLL) >> 32)},
    {(VUINT32) ((0xE99C7026B45F7E41uLL) >> 0),
     (VUINT32) ((0xE99C7026B45F7E41uLL) >> 32)}},
   {{(VUINT32) ((0xFC3BD63962534E7DuLL) >> 0),
     (VUINT32) ((0xFC3BD63962534E7DuLL) >> 32)},
    {(VUINT32) ((0xD1046BEA5D768909uLL) >> 0),
     (VUINT32) ((0xD1046BEA5D768909uLL) >> 32)},
    {(VUINT32) ((0xD338E04D68BEFC82uLL) >> 0),
     (VUINT32) ((0xD338E04D68BEFC82uLL) >> 32)}},
   {{(VUINT32) ((0xF877AC72C4A69CFBuLL) >> 0),
     (VUINT32) ((0xF877AC72C4A69CFBuLL) >> 32)},
    {(VUINT32) ((0xA208D7D4BAED1213uLL) >> 0),
     (VUINT32) ((0xA208D7D4BAED1213uLL) >> 32)},
    {(VUINT32) ((0xA671C09AD17DF904uLL) >> 0),
     (VUINT32) ((0xA671C09AD17DF904uLL) >> 32)}},
   {{(VUINT32) ((0xF0EF58E5894D39F7uLL) >> 0),
     (VUINT32) ((0xF0EF58E5894D39F7uLL) >> 32)},
    {(VUINT32) ((0x4411AFA975DA2427uLL) >> 0),
     (VUINT32) ((0x4411AFA975DA2427uLL) >> 32)},
    {(VUINT32) ((0x4CE38135A2FBF209uLL) >> 0),
     (VUINT32) ((0x4CE38135A2FBF209uLL) >> 32)}},
   {{(VUINT32) ((0xE1DEB1CB129A73EEuLL) >> 0),
     (VUINT32) ((0xE1DEB1CB129A73EEuLL) >> 32)},
    {(VUINT32) ((0x88235F52EBB4484EuLL) >> 0),
     (VUINT32) ((0x88235F52EBB4484EuLL) >> 32)},
    {(VUINT32) ((0x99C7026B45F7E413uLL) >> 0),
     (VUINT32) ((0x99C7026B45F7E413uLL) >> 32)}},
   {{(VUINT32) ((0xC3BD63962534E7DDuLL) >> 0),
     (VUINT32) ((0xC3BD63962534E7DDuLL) >> 32)},
    {(VUINT32) ((0x1046BEA5D768909DuLL) >> 0),
     (VUINT32) ((0x1046BEA5D768909DuLL) >> 32)},
    {(VUINT32) ((0x338E04D68BEFC827uLL) >> 0),
     (VUINT32) ((0x338E04D68BEFC827uLL) >> 32)}},
   {{(VUINT32) ((0x877AC72C4A69CFBAuLL) >> 0),
     (VUINT32) ((0x877AC72C4A69CFBAuLL) >> 32)},
    {(VUINT32) ((0x208D7D4BAED1213AuLL) >> 0),
     (VUINT32) ((0x208D7D4BAED1213AuLL) >> 32)},
    {(VUINT32) ((0x671C09AD17DF904EuLL) >> 0),
     (VUINT32) ((0x671C09AD17DF904EuLL) >> 32)}},
   {{(VUINT32) ((0x0EF58E5894D39F74uLL) >> 0),
     (VUINT32) ((0x0EF58E5894D39F74uLL) >> 32)},
    {(VUINT32) ((0x411AFA975DA24274uLL) >> 0),
     (VUINT32) ((0x411AFA975DA24274uLL) >> 32)},
    {(VUINT32) ((0xCE38135A2FBF209CuLL) >> 0),
     (VUINT32) ((0xCE38135A2FBF209CuLL) >> 32)}},
   {{(VUINT32) ((0x1DEB1CB129A73EE8uLL) >> 0),
     (VUINT32) ((0x1DEB1CB129A73EE8uLL) >> 32)},
    {(VUINT32) ((0x8235F52EBB4484E9uLL) >> 0),
     (VUINT32) ((0x8235F52EBB4484E9uLL) >> 32)},
    {(VUINT32) ((0x9C7026B45F7E4139uLL) >> 0),
     (VUINT32) ((0x9C7026B45F7E4139uLL) >> 32)}},
   {{(VUINT32) ((0x3BD63962534E7DD1uLL) >> 0),
     (VUINT32) ((0x3BD63962534E7DD1uLL) >> 32)},
    {(VUINT32) ((0x046BEA5D768909D3uLL) >> 0),
     (VUINT32) ((0x046BEA5D768909D3uLL) >> 32)},
    {(VUINT32) ((0x38E04D68BEFC8273uLL) >> 0),
     (VUINT32) ((0x38E04D68BEFC8273uLL) >> 32)}},
   {{(VUINT32) ((0x77AC72C4A69CFBA2uLL) >> 0),
     (VUINT32) ((0x77AC72C4A69CFBA2uLL) >> 32)},
    {(VUINT32) ((0x08D7D4BAED1213A6uLL) >> 0),
     (VUINT32) ((0x08D7D4BAED1213A6uLL) >> 32)},
    {(VUINT32) ((0x71C09AD17DF904E6uLL) >> 0),
     (VUINT32) ((0x71C09AD17DF904E6uLL) >> 32)}},
   {{(VUINT32) ((0xEF58E5894D39F744uLL) >> 0),
     (VUINT32) ((0xEF58E5894D39F744uLL) >> 32)},
    {(VUINT32) ((0x11AFA975DA24274CuLL) >> 0),
     (VUINT32) ((0x11AFA975DA24274CuLL) >> 32)},
    {(VUINT32) ((0xE38135A2FBF209CCuLL) >> 0),
     (VUINT32) ((0xE38135A2FBF209CCuLL) >> 32)}},
   {{(VUINT32) ((0xDEB1CB129A73EE88uLL) >> 0),
     (VUINT32) ((0xDEB1CB129A73EE88uLL) >> 32)},
    {(VUINT32) ((0x235F52EBB4484E99uLL) >> 0),
     (VUINT32) ((0x235F52EBB4484E99uLL) >> 32)},
    {(VUINT32) ((0xC7026B45F7E41399uLL) >> 0),
     (VUINT32) ((0xC7026B45F7E41399uLL) >> 32)}},
   {{(VUINT32) ((0xBD63962534E7DD10uLL) >> 0),
     (VUINT32) ((0xBD63962534E7DD10uLL) >> 32)},
    {(VUINT32) ((0x46BEA5D768909D33uLL) >> 0),
     (VUINT32) ((0x46BEA5D768909D33uLL) >> 32)},
    {(VUINT32) ((0x8E04D68BEFC82732uLL) >> 0),
     (VUINT32) ((0x8E04D68BEFC82732uLL) >> 32)}},
   {{(VUINT32) ((0x7AC72C4A69CFBA20uLL) >> 0),
     (VUINT32) ((0x7AC72C4A69CFBA20uLL) >> 32)},
    {(VUINT32) ((0x8D7D4BAED1213A67uLL) >> 0),
     (VUINT32) ((0x8D7D4BAED1213A67uLL) >> 32)},
    {(VUINT32) ((0x1C09AD17DF904E64uLL) >> 0),
     (VUINT32) ((0x1C09AD17DF904E64uLL) >> 32)}},
   {{(VUINT32) ((0xF58E5894D39F7441uLL) >> 0),
     (VUINT32) ((0xF58E5894D39F7441uLL) >> 32)},
    {(VUINT32) ((0x1AFA975DA24274CEuLL) >> 0),
     (VUINT32) ((0x1AFA975DA24274CEuLL) >> 32)},
    {(VUINT32) ((0x38135A2FBF209CC8uLL) >> 0),
     (VUINT32) ((0x38135A2FBF209CC8uLL) >> 32)}},
   {{(VUINT32) ((0xEB1CB129A73EE882uLL) >> 0),
     (VUINT32) ((0xEB1CB129A73EE882uLL) >> 32)},
    {(VUINT32) ((0x35F52EBB4484E99CuLL) >> 0),
     (VUINT32) ((0x35F52EBB4484E99CuLL) >> 32)},
    {(VUINT32) ((0x7026B45F7E413991uLL) >> 0),
     (VUINT32) ((0x7026B45F7E413991uLL) >> 32)}},
   {{(VUINT32) ((0xD63962534E7DD104uLL) >> 0),
     (VUINT32) ((0xD63962534E7DD104uLL) >> 32)},
    {(VUINT32) ((0x6BEA5D768909D338uLL) >> 0),
     (VUINT32) ((0x6BEA5D768909D338uLL) >> 32)},
    {(VUINT32) ((0xE04D68BEFC827323uLL) >> 0),
     (VUINT32) ((0xE04D68BEFC827323uLL) >> 32)}},
   {{(VUINT32) ((0xAC72C4A69CFBA208uLL) >> 0),
     (VUINT32) ((0xAC72C4A69CFBA208uLL) >> 32)},
    {(VUINT32) ((0xD7D4BAED1213A671uLL) >> 0),
     (VUINT32) ((0xD7D4BAED1213A671uLL) >> 32)},
    {(VUINT32) ((0xC09AD17DF904E647uLL) >> 0),
     (VUINT32) ((0xC09AD17DF904E647uLL) >> 32)}},
   {{(VUINT32) ((0x58E5894D39F74411uLL) >> 0),
     (VUINT32) ((0x58E5894D39F74411uLL) >> 32)},
    {(VUINT32) ((0xAFA975DA24274CE3uLL) >> 0),
     (VUINT32) ((0xAFA975DA24274CE3uLL) >> 32)},
    {(VUINT32) ((0x8135A2FBF209CC8EuLL) >> 0),
     (VUINT32) ((0x8135A2FBF209CC8EuLL) >> 32)}},
   {{(VUINT32) ((0xB1CB129A73EE8823uLL) >> 0),
     (VUINT32) ((0xB1CB129A73EE8823uLL) >> 32)},
    {(VUINT32) ((0x5F52EBB4484E99C7uLL) >> 0),
     (VUINT32) ((0x5F52EBB4484E99C7uLL) >> 32)},
    {(VUINT32) ((0x026B45F7E413991DuLL) >> 0),
     (VUINT32) ((0x026B45F7E413991DuLL) >> 32)}},
   {{(VUINT32) ((0x63962534E7DD1046uLL) >> 0),
     (VUINT32) ((0x63962534E7DD1046uLL) >> 32)},
    {(VUINT32) ((0xBEA5D768909D338EuLL) >> 0),
     (VUINT32) ((0xBEA5D768909D338EuLL) >> 32)},
    {(VUINT32) ((0x04D68BEFC827323AuLL) >> 0),
     (VUINT32) ((0x04D68BEFC827323AuLL) >> 32)}},
   {{(VUINT32) ((0xC72C4A69CFBA208DuLL) >> 0),
     (VUINT32) ((0xC72C4A69CFBA208DuLL) >> 32)},
    {(VUINT32) ((0x7D4BAED1213A671CuLL) >> 0),
     (VUINT32) ((0x7D4BAED1213A671CuLL) >> 32)},
    {(VUINT32) ((0x09AD17DF904E6475uLL) >> 0),
     (VUINT32) ((0x09AD17DF904E6475uLL) >> 32)}},
   {{(VUINT32) ((0x8E5894D39F74411AuLL) >> 0),
     (VUINT32) ((0x8E5894D39F74411AuLL) >> 32)},
    {(VUINT32) ((0xFA975DA24274CE38uLL) >> 0),
     (VUINT32) ((0xFA975DA24274CE38uLL) >> 32)},
    {(VUINT32) ((0x135A2FBF209CC8EBuLL) >> 0),
     (VUINT32) ((0x135A2FBF209CC8EBuLL) >> 32)}},
   {{(VUINT32) ((0x1CB129A73EE88235uLL) >> 0),
     (VUINT32) ((0x1CB129A73EE88235uLL) >> 32)},
    {(VUINT32) ((0xF52EBB4484E99C70uLL) >> 0),
     (VUINT32) ((0xF52EBB4484E99C70uLL) >> 32)},
    {(VUINT32) ((0x26B45F7E413991D6uLL) >> 0),
     (VUINT32) ((0x26B45F7E413991D6uLL) >> 32)}},
   {{(VUINT32) ((0x3962534E7DD1046BuLL) >> 0),
     (VUINT32) ((0x3962534E7DD1046BuLL) >> 32)},
    {(VUINT32) ((0xEA5D768909D338E0uLL) >> 0),
     (VUINT32) ((0xEA5D768909D338E0uLL) >> 32)},
    {(VUINT32) ((0x4D68BEFC827323ACuLL) >> 0),
     (VUINT32) ((0x4D68BEFC827323ACuLL) >> 32)}},
   {{(VUINT32) ((0x72C4A69CFBA208D7uLL) >> 0),
     (VUINT32) ((0x72C4A69CFBA208D7uLL) >> 32)},
    {(VUINT32) ((0xD4BAED1213A671C0uLL) >> 0),
     (VUINT32) ((0xD4BAED1213A671C0uLL) >> 32)},
    {(VUINT32) ((0x9AD17DF904E64758uLL) >> 0),
     (VUINT32) ((0x9AD17DF904E64758uLL) >> 32)}},
   {{(VUINT32) ((0xE5894D39F74411AFuLL) >> 0),
     (VUINT32) ((0xE5894D39F74411AFuLL) >> 32)},
    {(VUINT32) ((0xA975DA24274CE381uLL) >> 0),
     (VUINT32) ((0xA975DA24274CE381uLL) >> 32)},
    {(VUINT32) ((0x35A2FBF209CC8EB1uLL) >> 0),
     (VUINT32) ((0x35A2FBF209CC8EB1uLL) >> 32)}},
   {{(VUINT32) ((0xCB129A73EE88235FuLL) >> 0),
     (VUINT32) ((0xCB129A73EE88235FuLL) >> 32)},
    {(VUINT32) ((0x52EBB4484E99C702uLL) >> 0),
     (VUINT32) ((0x52EBB4484E99C702uLL) >> 32)},
    {(VUINT32) ((0x6B45F7E413991D63uLL) >> 0),
     (VUINT32) ((0x6B45F7E413991D63uLL) >> 32)}},
   {{(VUINT32) ((0x962534E7DD1046BEuLL) >> 0),
     (VUINT32) ((0x962534E7DD1046BEuLL) >> 32)},
    {(VUINT32) ((0xA5D768909D338E04uLL) >> 0),
     (VUINT32) ((0xA5D768909D338E04uLL) >> 32)},
    {(VUINT32) ((0xD68BEFC827323AC7uLL) >> 0),
     (VUINT32) ((0xD68BEFC827323AC7uLL) >> 32)}},
   {{(VUINT32) ((0x2C4A69CFBA208D7DuLL) >> 0),
     (VUINT32) ((0x2C4A69CFBA208D7DuLL) >> 32)},
    {(VUINT32) ((0x4BAED1213A671C09uLL) >> 0),
     (VUINT32) ((0x4BAED1213A671C09uLL) >> 32)},
    {(VUINT32) ((0xAD17DF904E64758EuLL) >> 0),
     (VUINT32) ((0xAD17DF904E64758EuLL) >> 32)}},
   {{(VUINT32) ((0x5894D39F74411AFAuLL) >> 0),
     (VUINT32) ((0x5894D39F74411AFAuLL) >> 32)},
    {(VUINT32) ((0x975DA24274CE3813uLL) >> 0),
     (VUINT32) ((0x975DA24274CE3813uLL) >> 32)},
    {(VUINT32) ((0x5A2FBF209CC8EB1CuLL) >> 0),
     (VUINT32) ((0x5A2FBF209CC8EB1CuLL) >> 32)}},
   {{(VUINT32) ((0xB129A73EE88235F5uLL) >> 0),
     (VUINT32) ((0xB129A73EE88235F5uLL) >> 32)},
    {(VUINT32) ((0x2EBB4484E99C7026uLL) >> 0),
     (VUINT32) ((0x2EBB4484E99C7026uLL) >> 32)},
    {(VUINT32) ((0xB45F7E413991D639uLL) >> 0),
     (VUINT32) ((0xB45F7E413991D639uLL) >> 32)}},
   {{(VUINT32) ((0x62534E7DD1046BEAuLL) >> 0),
     (VUINT32) ((0x62534E7DD1046BEAuLL) >> 32)},
    {(VUINT32) ((0x5D768909D338E04DuLL) >> 0),
     (VUINT32) ((0x5D768909D338E04DuLL) >> 32)},
    {(VUINT32) ((0x68BEFC827323AC73uLL) >> 0),
     (VUINT32) ((0x68BEFC827323AC73uLL) >> 32)}},
   {{(VUINT32) ((0xC4A69CFBA208D7D4uLL) >> 0),
     (VUINT32) ((0xC4A69CFBA208D7D4uLL) >> 32)},
    {(VUINT32) ((0xBAED1213A671C09AuLL) >> 0),
     (VUINT32) ((0xBAED1213A671C09AuLL) >> 32)},
    {(VUINT32) ((0xD17DF904E64758E6uLL) >> 0),
     (VUINT32) ((0xD17DF904E64758E6uLL) >> 32)}},
   {{(VUINT32) ((0x894D39F74411AFA9uLL) >> 0),
     (VUINT32) ((0x894D39F74411AFA9uLL) >> 32)},
    {(VUINT32) ((0x75DA24274CE38135uLL) >> 0),
     (VUINT32) ((0x75DA24274CE38135uLL) >> 32)},
    {(VUINT32) ((0xA2FBF209CC8EB1CCuLL) >> 0),
     (VUINT32) ((0xA2FBF209CC8EB1CCuLL) >> 32)}},
   {{(VUINT32) ((0x129A73EE88235F52uLL) >> 0),
     (VUINT32) ((0x129A73EE88235F52uLL) >> 32)},
    {(VUINT32) ((0xEBB4484E99C7026BuLL) >> 0),
     (VUINT32) ((0xEBB4484E99C7026BuLL) >> 32)},
    {(VUINT32) ((0x45F7E413991D6398uLL) >> 0),
     (VUINT32) ((0x45F7E413991D6398uLL) >> 32)}},
   {{(VUINT32) ((0x2534E7DD1046BEA5uLL) >> 0),
     (VUINT32) ((0x2534E7DD1046BEA5uLL) >> 32)},
    {(VUINT32) ((0xD768909D338E04D6uLL) >> 0),
     (VUINT32) ((0xD768909D338E04D6uLL) >> 32)},
    {(VUINT32) ((0x8BEFC827323AC730uLL) >> 0),
     (VUINT32) ((0x8BEFC827323AC730uLL) >> 32)}},
   {{(VUINT32) ((0x4A69CFBA208D7D4BuLL) >> 0),
     (VUINT32) ((0x4A69CFBA208D7D4BuLL) >> 32)},
    {(VUINT32) ((0xAED1213A671C09ADuLL) >> 0),
     (VUINT32) ((0xAED1213A671C09ADuLL) >> 32)},
    {(VUINT32) ((0x17DF904E64758E60uLL) >> 0),
     (VUINT32) ((0x17DF904E64758E60uLL) >> 32)}},
   {{(VUINT32) ((0x94D39F74411AFA97uLL) >> 0),
     (VUINT32) ((0x94D39F74411AFA97uLL) >> 32)},
    {(VUINT32) ((0x5DA24274CE38135AuLL) >> 0),
     (VUINT32) ((0x5DA24274CE38135AuLL) >> 32)},
    {(VUINT32) ((0x2FBF209CC8EB1CC1uLL) >> 0),
     (VUINT32) ((0x2FBF209CC8EB1CC1uLL) >> 32)}},
   {{(VUINT32) ((0x29A73EE88235F52EuLL) >> 0),
     (VUINT32) ((0x29A73EE88235F52EuLL) >> 32)},
    {(VUINT32) ((0xBB4484E99C7026B4uLL) >> 0),
     (VUINT32) ((0xBB4484E99C7026B4uLL) >> 32)},
    {(VUINT32) ((0x5F7E413991D63983uLL) >> 0),
     (VUINT32) ((0x5F7E413991D63983uLL) >> 32)}},
   {{(VUINT32) ((0x534E7DD1046BEA5DuLL) >> 0),
     (VUINT32) ((0x534E7DD1046BEA5DuLL) >> 32)},
    {(VUINT32) ((0x768909D338E04D68uLL) >> 0),
     (VUINT32) ((0x768909D338E04D68uLL) >> 32)},
    {(VUINT32) ((0xBEFC827323AC7306uLL) >> 0),
     (VUINT32) ((0xBEFC827323AC7306uLL) >> 32)}},
   {{(VUINT32) ((0xA69CFBA208D7D4BAuLL) >> 0),
     (VUINT32) ((0xA69CFBA208D7D4BAuLL) >> 32)},
    {(VUINT32) ((0xED1213A671C09AD1uLL) >> 0),
     (VUINT32) ((0xED1213A671C09AD1uLL) >> 32)},
    {(VUINT32) ((0x7DF904E64758E60DuLL) >> 0),
     (VUINT32) ((0x7DF904E64758E60DuLL) >> 32)}},
   {{(VUINT32) ((0x4D39F74411AFA975uLL) >> 0),
     (VUINT32) ((0x4D39F74411AFA975uLL) >> 32)},
    {(VUINT32) ((0xDA24274CE38135A2uLL) >> 0),
     (VUINT32) ((0xDA24274CE38135A2uLL) >> 32)},
    {(VUINT32) ((0xFBF209CC8EB1CC1AuLL) >> 0),
     (VUINT32) ((0xFBF209CC8EB1CC1AuLL) >> 32)}},
   {{(VUINT32) ((0x9A73EE88235F52EBuLL) >> 0),
     (VUINT32) ((0x9A73EE88235F52EBuLL) >> 32)},
    {(VUINT32) ((0xB4484E99C7026B45uLL) >> 0),
     (VUINT32) ((0xB4484E99C7026B45uLL) >> 32)},
    {(VUINT32) ((0xF7E413991D639835uLL) >> 0),
     (VUINT32) ((0xF7E413991D639835uLL) >> 32)}},
   {{(VUINT32) ((0x34E7DD1046BEA5D7uLL) >> 0),
     (VUINT32) ((0x34E7DD1046BEA5D7uLL) >> 32)},
    {(VUINT32) ((0x68909D338E04D68BuLL) >> 0),
     (VUINT32) ((0x68909D338E04D68BuLL) >> 32)},
    {(VUINT32) ((0xEFC827323AC7306AuLL) >> 0),
     (VUINT32) ((0xEFC827323AC7306AuLL) >> 32)}},
   {{(VUINT32) ((0x69CFBA208D7D4BAEuLL) >> 0),
     (VUINT32) ((0x69CFBA208D7D4BAEuLL) >> 32)},
    {(VUINT32) ((0xD1213A671C09AD17uLL) >> 0),
     (VUINT32) ((0xD1213A671C09AD17uLL) >> 32)},
    {(VUINT32) ((0xDF904E64758E60D4uLL) >> 0),
     (VUINT32) ((0xDF904E64758E60D4uLL) >> 32)}},
   {{(VUINT32) ((0xD39F74411AFA975DuLL) >> 0),
     (VUINT32) ((0xD39F74411AFA975DuLL) >> 32)},
    {(VUINT32) ((0xA24274CE38135A2FuLL) >> 0),
     (VUINT32) ((0xA24274CE38135A2FuLL) >> 32)},
    {(VUINT32) ((0xBF209CC8EB1CC1A9uLL) >> 0),
     (VUINT32) ((0xBF209CC8EB1CC1A9uLL) >> 32)}},
   {{(VUINT32) ((0xA73EE88235F52EBBuLL) >> 0),
     (VUINT32) ((0xA73EE88235F52EBBuLL) >> 32)},
    {(VUINT32) ((0x4484E99C7026B45FuLL) >> 0),
     (VUINT32) ((0x4484E99C7026B45FuLL) >> 32)},
    {(VUINT32) ((0x7E413991D6398353uLL) >> 0),
     (VUINT32) ((0x7E413991D6398353uLL) >> 32)}},
   {{(VUINT32) ((0x4E7DD1046BEA5D76uLL) >> 0),
     (VUINT32) ((0x4E7DD1046BEA5D76uLL) >> 32)},
    {(VUINT32) ((0x8909D338E04D68BEuLL) >> 0),
     (VUINT32) ((0x8909D338E04D68BEuLL) >> 32)},
    {(VUINT32) ((0xFC827323AC7306A6uLL) >> 0),
     (VUINT32) ((0xFC827323AC7306A6uLL) >> 32)}},
   {{(VUINT32) ((0x9CFBA208D7D4BAEDuLL) >> 0),
     (VUINT32) ((0x9CFBA208D7D4BAEDuLL) >> 32)},
    {(VUINT32) ((0x1213A671C09AD17DuLL) >> 0),
     (VUINT32) ((0x1213A671C09AD17DuLL) >> 32)},
    {(VUINT32) ((0xF904E64758E60D4CuLL) >> 0),
     (VUINT32) ((0xF904E64758E60D4CuLL) >> 32)}},
   {{(VUINT32) ((0x39F74411AFA975DAuLL) >> 0),
     (VUINT32) ((0x39F74411AFA975DAuLL) >> 32)},
    {(VUINT32) ((0x24274CE38135A2FBuLL) >> 0),
     (VUINT32) ((0x24274CE38135A2FBuLL) >> 32)},
    {(VUINT32) ((0xF209CC8EB1CC1A99uLL) >> 0),
     (VUINT32) ((0xF209CC8EB1CC1A99uLL) >> 32)}},
   {{(VUINT32) ((0x73EE88235F52EBB4uLL) >> 0),
     (VUINT32) ((0x73EE88235F52EBB4uLL) >> 32)},
    {(VUINT32) ((0x484E99C7026B45F7uLL) >> 0),
     (VUINT32) ((0x484E99C7026B45F7uLL) >> 32)},
    {(VUINT32) ((0xE413991D63983533uLL) >> 0),
     (VUINT32) ((0xE413991D63983533uLL) >> 32)}},
   {{(VUINT32) ((0xE7DD1046BEA5D768uLL) >> 0),
     (VUINT32) ((0xE7DD1046BEA5D768uLL) >> 32)},
    {(VUINT32) ((0x909D338E04D68BEFuLL) >> 0),
     (VUINT32) ((0x909D338E04D68BEFuLL) >> 32)},
    {(VUINT32) ((0xC827323AC7306A67uLL) >> 0),
     (VUINT32) ((0xC827323AC7306A67uLL) >> 32)}},
   {{(VUINT32) ((0xCFBA208D7D4BAED1uLL) >> 0),
     (VUINT32) ((0xCFBA208D7D4BAED1uLL) >> 32)},
    {(VUINT32) ((0x213A671C09AD17DFuLL) >> 0),
     (VUINT32) ((0x213A671C09AD17DFuLL) >> 32)},
    {(VUINT32) ((0x904E64758E60D4CEuLL) >> 0),
     (VUINT32) ((0x904E64758E60D4CEuLL) >> 32)}},
   {{(VUINT32) ((0x9F74411AFA975DA2uLL) >> 0),
     (VUINT32) ((0x9F74411AFA975DA2uLL) >> 32)},
    {(VUINT32) ((0x4274CE38135A2FBFuLL) >> 0),
     (VUINT32) ((0x4274CE38135A2FBFuLL) >> 32)},
    {(VUINT32) ((0x209CC8EB1CC1A99CuLL) >> 0),
     (VUINT32) ((0x209CC8EB1CC1A99CuLL) >> 32)}},
   {{(VUINT32) ((0x3EE88235F52EBB44uLL) >> 0),
     (VUINT32) ((0x3EE88235F52EBB44uLL) >> 32)},
    {(VUINT32) ((0x84E99C7026B45F7EuLL) >> 0),
     (VUINT32) ((0x84E99C7026B45F7EuLL) >> 32)},
    {(VUINT32) ((0x413991D639835339uLL) >> 0),
     (VUINT32) ((0x413991D639835339uLL) >> 32)}},
   {{(VUINT32) ((0x7DD1046BEA5D7689uLL) >> 0),
     (VUINT32) ((0x7DD1046BEA5D7689uLL) >> 32)},
    {(VUINT32) ((0x09D338E04D68BEFCuLL) >> 0),
     (VUINT32) ((0x09D338E04D68BEFCuLL) >> 32)},
    {(VUINT32) ((0x827323AC7306A673uLL) >> 0),
     (VUINT32) ((0x827323AC7306A673uLL) >> 32)}},
   {{(VUINT32) ((0xFBA208D7D4BAED12uLL) >> 0),
     (VUINT32) ((0xFBA208D7D4BAED12uLL) >> 32)},
    {(VUINT32) ((0x13A671C09AD17DF9uLL) >> 0),
     (VUINT32) ((0x13A671C09AD17DF9uLL) >> 32)},
    {(VUINT32) ((0x04E64758E60D4CE7uLL) >> 0),
     (VUINT32) ((0x04E64758E60D4CE7uLL) >> 32)}},
   {{(VUINT32) ((0xF74411AFA975DA24uLL) >> 0),
     (VUINT32) ((0xF74411AFA975DA24uLL) >> 32)},
    {(VUINT32) ((0x274CE38135A2FBF2uLL) >> 0),
     (VUINT32) ((0x274CE38135A2FBF2uLL) >> 32)},
    {(VUINT32) ((0x09CC8EB1CC1A99CFuLL) >> 0),
     (VUINT32) ((0x09CC8EB1CC1A99CFuLL) >> 32)}},
   {{(VUINT32) ((0xEE88235F52EBB448uLL) >> 0),
     (VUINT32) ((0xEE88235F52EBB448uLL) >> 32)},
    {(VUINT32) ((0x4E99C7026B45F7E4uLL) >> 0),
     (VUINT32) ((0x4E99C7026B45F7E4uLL) >> 32)},
    {(VUINT32) ((0x13991D639835339FuLL) >> 0),
     (VUINT32) ((0x13991D639835339FuLL) >> 32)}},
   {{(VUINT32) ((0xDD1046BEA5D76890uLL) >> 0),
     (VUINT32) ((0xDD1046BEA5D76890uLL) >> 32)},
    {(VUINT32) ((0x9D338E04D68BEFC8uLL) >> 0),
     (VUINT32) ((0x9D338E04D68BEFC8uLL) >> 32)},
    {(VUINT32) ((0x27323AC7306A673EuLL) >> 0),
     (VUINT32) ((0x27323AC7306A673EuLL) >> 32)}},
   {{(VUINT32) ((0xBA208D7D4BAED121uLL) >> 0),
     (VUINT32) ((0xBA208D7D4BAED121uLL) >> 32)},
    {(VUINT32) ((0x3A671C09AD17DF90uLL) >> 0),
     (VUINT32) ((0x3A671C09AD17DF90uLL) >> 32)},
    {(VUINT32) ((0x4E64758E60D4CE7DuLL) >> 0),
     (VUINT32) ((0x4E64758E60D4CE7DuLL) >> 32)}},
   {{(VUINT32) ((0x74411AFA975DA242uLL) >> 0),
     (VUINT32) ((0x74411AFA975DA242uLL) >> 32)},
    {(VUINT32) ((0x74CE38135A2FBF20uLL) >> 0),
     (VUINT32) ((0x74CE38135A2FBF20uLL) >> 32)},
    {(VUINT32) ((0x9CC8EB1CC1A99CFAuLL) >> 0),
     (VUINT32) ((0x9CC8EB1CC1A99CFAuLL) >> 32)}},
   {{(VUINT32) ((0xE88235F52EBB4484uLL) >> 0),
     (VUINT32) ((0xE88235F52EBB4484uLL) >> 32)},
    {(VUINT32) ((0xE99C7026B45F7E41uLL) >> 0),
     (VUINT32) ((0xE99C7026B45F7E41uLL) >> 32)},
    {(VUINT32) ((0x3991D639835339F4uLL) >> 0),
     (VUINT32) ((0x3991D639835339F4uLL) >> 32)}},
   {{(VUINT32) ((0xD1046BEA5D768909uLL) >> 0),
     (VUINT32) ((0xD1046BEA5D768909uLL) >> 32)},
    {(VUINT32) ((0xD338E04D68BEFC82uLL) >> 0),
     (VUINT32) ((0xD338E04D68BEFC82uLL) >> 32)},
    {(VUINT32) ((0x7323AC7306A673E9uLL) >> 0),
     (VUINT32) ((0x7323AC7306A673E9uLL) >> 32)}},
   {{(VUINT32) ((0xA208D7D4BAED1213uLL) >> 0),
     (VUINT32) ((0xA208D7D4BAED1213uLL) >> 32)},
    {(VUINT32) ((0xA671C09AD17DF904uLL) >> 0),
     (VUINT32) ((0xA671C09AD17DF904uLL) >> 32)},
    {(VUINT32) ((0xE64758E60D4CE7D2uLL) >> 0),
     (VUINT32) ((0xE64758E60D4CE7D2uLL) >> 32)}},
   {{(VUINT32) ((0x4411AFA975DA2427uLL) >> 0),
     (VUINT32) ((0x4411AFA975DA2427uLL) >> 32)},
    {(VUINT32) ((0x4CE38135A2FBF209uLL) >> 0),
     (VUINT32) ((0x4CE38135A2FBF209uLL) >> 32)},
    {(VUINT32) ((0xCC8EB1CC1A99CFA4uLL) >> 0),
     (VUINT32) ((0xCC8EB1CC1A99CFA4uLL) >> 32)}},
   {{(VUINT32) ((0x88235F52EBB4484EuLL) >> 0),
     (VUINT32) ((0x88235F52EBB4484EuLL) >> 32)},
    {(VUINT32) ((0x99C7026B45F7E413uLL) >> 0),
     (VUINT32) ((0x99C7026B45F7E413uLL) >> 32)},
    {(VUINT32) ((0x991D639835339F49uLL) >> 0),
     (VUINT32) ((0x991D639835339F49uLL) >> 32)}},
   {{(VUINT32) ((0x1046BEA5D768909DuLL) >> 0),
     (VUINT32) ((0x1046BEA5D768909DuLL) >> 32)},
    {(VUINT32) ((0x338E04D68BEFC827uLL) >> 0),
     (VUINT32) ((0x338E04D68BEFC827uLL) >> 32)},
    {(VUINT32) ((0x323AC7306A673E93uLL) >> 0),
     (VUINT32) ((0x323AC7306A673E93uLL) >> 32)}},
   {{(VUINT32) ((0x208D7D4BAED1213AuLL) >> 0),
     (VUINT32) ((0x208D7D4BAED1213AuLL) >> 32)},
    {(VUINT32) ((0x671C09AD17DF904EuLL) >> 0),
     (VUINT32) ((0x671C09AD17DF904EuLL) >> 32)},
    {(VUINT32) ((0x64758E60D4CE7D27uLL) >> 0),
     (VUINT32) ((0x64758E60D4CE7D27uLL) >> 32)}},
   {{(VUINT32) ((0x411AFA975DA24274uLL) >> 0),
     (VUINT32) ((0x411AFA975DA24274uLL) >> 32)},
    {(VUINT32) ((0xCE38135A2FBF209CuLL) >> 0),
     (VUINT32) ((0xCE38135A2FBF209CuLL) >> 32)},
    {(VUINT32) ((0xC8EB1CC1A99CFA4EuLL) >> 0),
     (VUINT32) ((0xC8EB1CC1A99CFA4EuLL) >> 32)}},
   {{(VUINT32) ((0x8235F52EBB4484E9uLL) >> 0),
     (VUINT32) ((0x8235F52EBB4484E9uLL) >> 32)},
    {(VUINT32) ((0x9C7026B45F7E4139uLL) >> 0),
     (VUINT32) ((0x9C7026B45F7E4139uLL) >> 32)},
    {(VUINT32) ((0x91D639835339F49CuLL) >> 0),
     (VUINT32) ((0x91D639835339F49CuLL) >> 32)}},
   {{(VUINT32) ((0x046BEA5D768909D3uLL) >> 0),
     (VUINT32) ((0x046BEA5D768909D3uLL) >> 32)},
    {(VUINT32) ((0x38E04D68BEFC8273uLL) >> 0),
     (VUINT32) ((0x38E04D68BEFC8273uLL) >> 32)},
    {(VUINT32) ((0x23AC7306A673E939uLL) >> 0),
     (VUINT32) ((0x23AC7306A673E939uLL) >> 32)}},
   {{(VUINT32) ((0x08D7D4BAED1213A6uLL) >> 0),
     (VUINT32) ((0x08D7D4BAED1213A6uLL) >> 32)},
    {(VUINT32) ((0x71C09AD17DF904E6uLL) >> 0),
     (VUINT32) ((0x71C09AD17DF904E6uLL) >> 32)},
    {(VUINT32) ((0x4758E60D4CE7D272uLL) >> 0),
     (VUINT32) ((0x4758E60D4CE7D272uLL) >> 32)}},
   {{(VUINT32) ((0x11AFA975DA24274CuLL) >> 0),
     (VUINT32) ((0x11AFA975DA24274CuLL) >> 32)},
    {(VUINT32) ((0xE38135A2FBF209CCuLL) >> 0),
     (VUINT32) ((0xE38135A2FBF209CCuLL) >> 32)},
    {(VUINT32) ((0x8EB1CC1A99CFA4E4uLL) >> 0),
     (VUINT32) ((0x8EB1CC1A99CFA4E4uLL) >> 32)}},
   {{(VUINT32) ((0x235F52EBB4484E99uLL) >> 0),
     (VUINT32) ((0x235F52EBB4484E99uLL) >> 32)},
    {(VUINT32) ((0xC7026B45F7E41399uLL) >> 0),
     (VUINT32) ((0xC7026B45F7E41399uLL) >> 32)},
    {(VUINT32) ((0x1D639835339F49C8uLL) >> 0),
     (VUINT32) ((0x1D639835339F49C8uLL) >> 32)}},
   {{(VUINT32) ((0x46BEA5D768909D33uLL) >> 0),
     (VUINT32) ((0x46BEA5D768909D33uLL) >> 32)},
    {(VUINT32) ((0x8E04D68BEFC82732uLL) >> 0),
     (VUINT32) ((0x8E04D68BEFC82732uLL) >> 32)},
    {(VUINT32) ((0x3AC7306A673E9390uLL) >> 0),
     (VUINT32) ((0x3AC7306A673E9390uLL) >> 32)}},
   {{(VUINT32) ((0x8D7D4BAED1213A67uLL) >> 0),
     (VUINT32) ((0x8D7D4BAED1213A67uLL) >> 32)},
    {(VUINT32) ((0x1C09AD17DF904E64uLL) >> 0),
     (VUINT32) ((0x1C09AD17DF904E64uLL) >> 32)},
    {(VUINT32) ((0x758E60D4CE7D2721uLL) >> 0),
     (VUINT32) ((0x758E60D4CE7D2721uLL) >> 32)}},
   {{(VUINT32) ((0x1AFA975DA24274CEuLL) >> 0),
     (VUINT32) ((0x1AFA975DA24274CEuLL) >> 32)},
    {(VUINT32) ((0x38135A2FBF209CC8uLL) >> 0),
     (VUINT32) ((0x38135A2FBF209CC8uLL) >> 32)},
    {(VUINT32) ((0xEB1CC1A99CFA4E42uLL) >> 0),
     (VUINT32) ((0xEB1CC1A99CFA4E42uLL) >> 32)}},
   {{(VUINT32) ((0x35F52EBB4484E99CuLL) >> 0),
     (VUINT32) ((0x35F52EBB4484E99CuLL) >> 32)},
    {(VUINT32) ((0x7026B45F7E413991uLL) >> 0),
     (VUINT32) ((0x7026B45F7E413991uLL) >> 32)},
    {(VUINT32) ((0xD639835339F49C84uLL) >> 0),
     (VUINT32) ((0xD639835339F49C84uLL) >> 32)}},
   {{(VUINT32) ((0x6BEA5D768909D338uLL) >> 0),
     (VUINT32) ((0x6BEA5D768909D338uLL) >> 32)},
    {(VUINT32) ((0xE04D68BEFC827323uLL) >> 0),
     (VUINT32) ((0xE04D68BEFC827323uLL) >> 32)},
    {(VUINT32) ((0xAC7306A673E93908uLL) >> 0),
     (VUINT32) ((0xAC7306A673E93908uLL) >> 32)}},
   {{(VUINT32) ((0xD7D4BAED1213A671uLL) >> 0),
     (VUINT32) ((0xD7D4BAED1213A671uLL) >> 32)},
    {(VUINT32) ((0xC09AD17DF904E647uLL) >> 0),
     (VUINT32) ((0xC09AD17DF904E647uLL) >> 32)},
    {(VUINT32) ((0x58E60D4CE7D27211uLL) >> 0),
     (VUINT32) ((0x58E60D4CE7D27211uLL) >> 32)}},
   {{(VUINT32) ((0xAFA975DA24274CE3uLL) >> 0),
     (VUINT32) ((0xAFA975DA24274CE3uLL) >> 32)},
    {(VUINT32) ((0x8135A2FBF209CC8EuLL) >> 0),
     (VUINT32) ((0x8135A2FBF209CC8EuLL) >> 32)},
    {(VUINT32) ((0xB1CC1A99CFA4E422uLL) >> 0),
     (VUINT32) ((0xB1CC1A99CFA4E422uLL) >> 32)}},
   {{(VUINT32) ((0x5F52EBB4484E99C7uLL) >> 0),
     (VUINT32) ((0x5F52EBB4484E99C7uLL) >> 32)},
    {(VUINT32) ((0x026B45F7E413991DuLL) >> 0),
     (VUINT32) ((0x026B45F7E413991DuLL) >> 32)},
    {(VUINT32) ((0x639835339F49C845uLL) >> 0),
     (VUINT32) ((0x639835339F49C845uLL) >> 32)}},
   {{(VUINT32) ((0xBEA5D768909D338EuLL) >> 0),
     (VUINT32) ((0xBEA5D768909D338EuLL) >> 32)},
    {(VUINT32) ((0x04D68BEFC827323AuLL) >> 0),
     (VUINT32) ((0x04D68BEFC827323AuLL) >> 32)},
    {(VUINT32) ((0xC7306A673E93908BuLL) >> 0),
     (VUINT32) ((0xC7306A673E93908BuLL) >> 32)}},
   {{(VUINT32) ((0x7D4BAED1213A671CuLL) >> 0),
     (VUINT32) ((0x7D4BAED1213A671CuLL) >> 32)},
    {(VUINT32) ((0x09AD17DF904E6475uLL) >> 0),
     (VUINT32) ((0x09AD17DF904E6475uLL) >> 32)},
    {(VUINT32) ((0x8E60D4CE7D272117uLL) >> 0),
     (VUINT32) ((0x8E60D4CE7D272117uLL) >> 32)}},
   {{(VUINT32) ((0xFA975DA24274CE38uLL) >> 0),
     (VUINT32) ((0xFA975DA24274CE38uLL) >> 32)},
    {(VUINT32) ((0x135A2FBF209CC8EBuLL) >> 0),
     (VUINT32) ((0x135A2FBF209CC8EBuLL) >> 32)},
    {(VUINT32) ((0x1CC1A99CFA4E422FuLL) >> 0),
     (VUINT32) ((0x1CC1A99CFA4E422FuLL) >> 32)}},
   {{(VUINT32) ((0xF52EBB4484E99C70uLL) >> 0),
     (VUINT32) ((0xF52EBB4484E99C70uLL) >> 32)},
    {(VUINT32) ((0x26B45F7E413991D6uLL) >> 0),
     (VUINT32) ((0x26B45F7E413991D6uLL) >> 32)},
    {(VUINT32) ((0x39835339F49C845FuLL) >> 0),
     (VUINT32) ((0x39835339F49C845FuLL) >> 32)}},
   {{(VUINT32) ((0xEA5D768909D338E0uLL) >> 0),
     (VUINT32) ((0xEA5D768909D338E0uLL) >> 32)},
    {(VUINT32) ((0x4D68BEFC827323ACuLL) >> 0),
     (VUINT32) ((0x4D68BEFC827323ACuLL) >> 32)},
    {(VUINT32) ((0x7306A673E93908BFuLL) >> 0),
     (VUINT32) ((0x7306A673E93908BFuLL) >> 32)}},
   {{(VUINT32) ((0xD4BAED1213A671C0uLL) >> 0),
     (VUINT32) ((0xD4BAED1213A671C0uLL) >> 32)},
    {(VUINT32) ((0x9AD17DF904E64758uLL) >> 0),
     (VUINT32) ((0x9AD17DF904E64758uLL) >> 32)},
    {(VUINT32) ((0xE60D4CE7D272117EuLL) >> 0),
     (VUINT32) ((0xE60D4CE7D272117EuLL) >> 32)}},
   {{(VUINT32) ((0xA975DA24274CE381uLL) >> 0),
     (VUINT32) ((0xA975DA24274CE381uLL) >> 32)},
    {(VUINT32) ((0x35A2FBF209CC8EB1uLL) >> 0),
     (VUINT32) ((0x35A2FBF209CC8EB1uLL) >> 32)},
    {(VUINT32) ((0xCC1A99CFA4E422FCuLL) >> 0),
     (VUINT32) ((0xCC1A99CFA4E422FCuLL) >> 32)}},
   {{(VUINT32) ((0x52EBB4484E99C702uLL) >> 0),
     (VUINT32) ((0x52EBB4484E99C702uLL) >> 32)},
    {(VUINT32) ((0x6B45F7E413991D63uLL) >> 0),
     (VUINT32) ((0x6B45F7E413991D63uLL) >> 32)},
    {(VUINT32) ((0x9835339F49C845F8uLL) >> 0),
     (VUINT32) ((0x9835339F49C845F8uLL) >> 32)}},
   {{(VUINT32) ((0xA5D768909D338E04uLL) >> 0),
     (VUINT32) ((0xA5D768909D338E04uLL) >> 32)},
    {(VUINT32) ((0xD68BEFC827323AC7uLL) >> 0),
     (VUINT32) ((0xD68BEFC827323AC7uLL) >> 32)},
    {(VUINT32) ((0x306A673E93908BF1uLL) >> 0),
     (VUINT32) ((0x306A673E93908BF1uLL) >> 32)}},
   {{(VUINT32) ((0x4BAED1213A671C09uLL) >> 0),
     (VUINT32) ((0x4BAED1213A671C09uLL) >> 32)},
    {(VUINT32) ((0xAD17DF904E64758EuLL) >> 0),
     (VUINT32) ((0xAD17DF904E64758EuLL) >> 32)},
    {(VUINT32) ((0x60D4CE7D272117E2uLL) >> 0),
     (VUINT32) ((0x60D4CE7D272117E2uLL) >> 32)}},
   {{(VUINT32) ((0x975DA24274CE3813uLL) >> 0),
     (VUINT32) ((0x975DA24274CE3813uLL) >> 32)},
    {(VUINT32) ((0x5A2FBF209CC8EB1CuLL) >> 0),
     (VUINT32) ((0x5A2FBF209CC8EB1CuLL) >> 32)},
    {(VUINT32) ((0xC1A99CFA4E422FC5uLL) >> 0),
     (VUINT32) ((0xC1A99CFA4E422FC5uLL) >> 32)}},
   {{(VUINT32) ((0x2EBB4484E99C7026uLL) >> 0),
     (VUINT32) ((0x2EBB4484E99C7026uLL) >> 32)},
    {(VUINT32) ((0xB45F7E413991D639uLL) >> 0),
     (VUINT32) ((0xB45F7E413991D639uLL) >> 32)},
    {(VUINT32) ((0x835339F49C845F8BuLL) >> 0),
     (VUINT32) ((0x835339F49C845F8BuLL) >> 32)}},
   {{(VUINT32) ((0x5D768909D338E04DuLL) >> 0),
     (VUINT32) ((0x5D768909D338E04DuLL) >> 32)},
    {(VUINT32) ((0x68BEFC827323AC73uLL) >> 0),
     (VUINT32) ((0x68BEFC827323AC73uLL) >> 32)},
    {(VUINT32) ((0x06A673E93908BF17uLL) >> 0),
     (VUINT32) ((0x06A673E93908BF17uLL) >> 32)}},
   {{(VUINT32) ((0xBAED1213A671C09AuLL) >> 0),
     (VUINT32) ((0xBAED1213A671C09AuLL) >> 32)},
    {(VUINT32) ((0xD17DF904E64758E6uLL) >> 0),
     (VUINT32) ((0xD17DF904E64758E6uLL) >> 32)},
    {(VUINT32) ((0x0D4CE7D272117E2EuLL) >> 0),
     (VUINT32) ((0x0D4CE7D272117E2EuLL) >> 32)}},
   {{(VUINT32) ((0x75DA24274CE38135uLL) >> 0),
     (VUINT32) ((0x75DA24274CE38135uLL) >> 32)},
    {(VUINT32) ((0xA2FBF209CC8EB1CCuLL) >> 0),
     (VUINT32) ((0xA2FBF209CC8EB1CCuLL) >> 32)},
    {(VUINT32) ((0x1A99CFA4E422FC5DuLL) >> 0),
     (VUINT32) ((0x1A99CFA4E422FC5DuLL) >> 32)}},
   {{(VUINT32) ((0xEBB4484E99C7026BuLL) >> 0),
     (VUINT32) ((0xEBB4484E99C7026BuLL) >> 32)},
    {(VUINT32) ((0x45F7E413991D6398uLL) >> 0),
     (VUINT32) ((0x45F7E413991D6398uLL) >> 32)},
    {(VUINT32) ((0x35339F49C845F8BBuLL) >> 0),
     (VUINT32) ((0x35339F49C845F8BBuLL) >> 32)}},
   {{(VUINT32) ((0xD768909D338E04D6uLL) >> 0),
     (VUINT32) ((0xD768909D338E04D6uLL) >> 32)},
    {(VUINT32) ((0x8BEFC827323AC730uLL) >> 0),
     (VUINT32) ((0x8BEFC827323AC730uLL) >> 32)},
    {(VUINT32) ((0x6A673E93908BF177uLL) >> 0),
     (VUINT32) ((0x6A673E93908BF177uLL) >> 32)}},
   {{(VUINT32) ((0xAED1213A671C09ADuLL) >> 0),
     (VUINT32) ((0xAED1213A671C09ADuLL) >> 32)},
    {(VUINT32) ((0x17DF904E64758E60uLL) >> 0),
     (VUINT32) ((0x17DF904E64758E60uLL) >> 32)},
    {(VUINT32) ((0xD4CE7D272117E2EFuLL) >> 0),
     (VUINT32) ((0xD4CE7D272117E2EFuLL) >> 32)}},
   {{(VUINT32) ((0x5DA24274CE38135AuLL) >> 0),
     (VUINT32) ((0x5DA24274CE38135AuLL) >> 32)},
    {(VUINT32) ((0x2FBF209CC8EB1CC1uLL) >> 0),
     (VUINT32) ((0x2FBF209CC8EB1CC1uLL) >> 32)},
    {(VUINT32) ((0xA99CFA4E422FC5DEuLL) >> 0),
     (VUINT32) ((0xA99CFA4E422FC5DEuLL) >> 32)}},
   {{(VUINT32) ((0xBB4484E99C7026B4uLL) >> 0),
     (VUINT32) ((0xBB4484E99C7026B4uLL) >> 32)},
    {(VUINT32) ((0x5F7E413991D63983uLL) >> 0),
     (VUINT32) ((0x5F7E413991D63983uLL) >> 32)},
    {(VUINT32) ((0x5339F49C845F8BBDuLL) >> 0),
     (VUINT32) ((0x5339F49C845F8BBDuLL) >> 32)}},
   {{(VUINT32) ((0x768909D338E04D68uLL) >> 0),
     (VUINT32) ((0x768909D338E04D68uLL) >> 32)},
    {(VUINT32) ((0xBEFC827323AC7306uLL) >> 0),
     (VUINT32) ((0xBEFC827323AC7306uLL) >> 32)},
    {(VUINT32) ((0xA673E93908BF177BuLL) >> 0),
     (VUINT32) ((0xA673E93908BF177BuLL) >> 32)}},
   {{(VUINT32) ((0xED1213A671C09AD1uLL) >> 0),
     (VUINT32) ((0xED1213A671C09AD1uLL) >> 32)},
    {(VUINT32) ((0x7DF904E64758E60DuLL) >> 0),
     (VUINT32) ((0x7DF904E64758E60DuLL) >> 32)},
    {(VUINT32) ((0x4CE7D272117E2EF7uLL) >> 0),
     (VUINT32) ((0x4CE7D272117E2EF7uLL) >> 32)}},
   {{(VUINT32) ((0xDA24274CE38135A2uLL) >> 0),
     (VUINT32) ((0xDA24274CE38135A2uLL) >> 32)},
    {(VUINT32) ((0xFBF209CC8EB1CC1AuLL) >> 0),
     (VUINT32) ((0xFBF209CC8EB1CC1AuLL) >> 32)},
    {(VUINT32) ((0x99CFA4E422FC5DEFuLL) >> 0),
     (VUINT32) ((0x99CFA4E422FC5DEFuLL) >> 32)}},
   {{(VUINT32) ((0xB4484E99C7026B45uLL) >> 0),
     (VUINT32) ((0xB4484E99C7026B45uLL) >> 32)},
    {(VUINT32) ((0xF7E413991D639835uLL) >> 0),
     (VUINT32) ((0xF7E413991D639835uLL) >> 32)},
    {(VUINT32) ((0x339F49C845F8BBDFuLL) >> 0),
     (VUINT32) ((0x339F49C845F8BBDFuLL) >> 32)}},
   {{(VUINT32) ((0x68909D338E04D68BuLL) >> 0),
     (VUINT32) ((0x68909D338E04D68BuLL) >> 32)},
    {(VUINT32) ((0xEFC827323AC7306AuLL) >> 0),
     (VUINT32) ((0xEFC827323AC7306AuLL) >> 32)},
    {(VUINT32) ((0x673E93908BF177BFuLL) >> 0),
     (VUINT32) ((0x673E93908BF177BFuLL) >> 32)}},
   {{(VUINT32) ((0xD1213A671C09AD17uLL) >> 0),
     (VUINT32) ((0xD1213A671C09AD17uLL) >> 32)},
    {(VUINT32) ((0xDF904E64758E60D4uLL) >> 0),
     (VUINT32) ((0xDF904E64758E60D4uLL) >> 32)},
    {(VUINT32) ((0xCE7D272117E2EF7EuLL) >> 0),
     (VUINT32) ((0xCE7D272117E2EF7EuLL) >> 32)}},
   {{(VUINT32) ((0xA24274CE38135A2FuLL) >> 0),
     (VUINT32) ((0xA24274CE38135A2FuLL) >> 32)},
    {(VUINT32) ((0xBF209CC8EB1CC1A9uLL) >> 0),
     (VUINT32) ((0xBF209CC8EB1CC1A9uLL) >> 32)},
    {(VUINT32) ((0x9CFA4E422FC5DEFCuLL) >> 0),
     (VUINT32) ((0x9CFA4E422FC5DEFCuLL) >> 32)}},
   {{(VUINT32) ((0x4484E99C7026B45FuLL) >> 0),
     (VUINT32) ((0x4484E99C7026B45FuLL) >> 32)},
    {(VUINT32) ((0x7E413991D6398353uLL) >> 0),
     (VUINT32) ((0x7E413991D6398353uLL) >> 32)},
    {(VUINT32) ((0x39F49C845F8BBDF9uLL) >> 0),
     (VUINT32) ((0x39F49C845F8BBDF9uLL) >> 32)}},
   {{(VUINT32) ((0x8909D338E04D68BEuLL) >> 0),
     (VUINT32) ((0x8909D338E04D68BEuLL) >> 32)},
    {(VUINT32) ((0xFC827323AC7306A6uLL) >> 0),
     (VUINT32) ((0xFC827323AC7306A6uLL) >> 32)},
    {(VUINT32) ((0x73E93908BF177BF2uLL) >> 0),
     (VUINT32) ((0x73E93908BF177BF2uLL) >> 32)}},
   {{(VUINT32) ((0x1213A671C09AD17DuLL) >> 0),
     (VUINT32) ((0x1213A671C09AD17DuLL) >> 32)},
    {(VUINT32) ((0xF904E64758E60D4CuLL) >> 0),
     (VUINT32) ((0xF904E64758E60D4CuLL) >> 32)},
    {(VUINT32) ((0xE7D272117E2EF7E4uLL) >> 0),
     (VUINT32) ((0xE7D272117E2EF7E4uLL) >> 32)}},
   {{(VUINT32) ((0x24274CE38135A2FBuLL) >> 0),
     (VUINT32) ((0x24274CE38135A2FBuLL) >> 32)},
    {(VUINT32) ((0xF209CC8EB1CC1A99uLL) >> 0),
     (VUINT32) ((0xF209CC8EB1CC1A99uLL) >> 32)},
    {(VUINT32) ((0xCFA4E422FC5DEFC9uLL) >> 0),
     (VUINT32) ((0xCFA4E422FC5DEFC9uLL) >> 32)}},
   {{(VUINT32) ((0x484E99C7026B45F7uLL) >> 0),
     (VUINT32) ((0x484E99C7026B45F7uLL) >> 32)},
    {(VUINT32) ((0xE413991D63983533uLL) >> 0),
     (VUINT32) ((0xE413991D63983533uLL) >> 32)},
    {(VUINT32) ((0x9F49C845F8BBDF92uLL) >> 0),
     (VUINT32) ((0x9F49C845F8BBDF92uLL) >> 32)}},
   {{(VUINT32) ((0x909D338E04D68BEFuLL) >> 0),
     (VUINT32) ((0x909D338E04D68BEFuLL) >> 32)},
    {(VUINT32) ((0xC827323AC7306A67uLL) >> 0),
     (VUINT32) ((0xC827323AC7306A67uLL) >> 32)},
    {(VUINT32) ((0x3E93908BF177BF25uLL) >> 0),
     (VUINT32) ((0x3E93908BF177BF25uLL) >> 32)}},
   {{(VUINT32) ((0x213A671C09AD17DFuLL) >> 0),
     (VUINT32) ((0x213A671C09AD17DFuLL) >> 32)},
    {(VUINT32) ((0x904E64758E60D4CEuLL) >> 0),
     (VUINT32) ((0x904E64758E60D4CEuLL) >> 32)},
    {(VUINT32) ((0x7D272117E2EF7E4AuLL) >> 0),
     (VUINT32) ((0x7D272117E2EF7E4AuLL) >> 32)}},
   {{(VUINT32) ((0x4274CE38135A2FBFuLL) >> 0),
     (VUINT32) ((0x4274CE38135A2FBFuLL) >> 32)},
    {(VUINT32) ((0x209CC8EB1CC1A99CuLL) >> 0),
     (VUINT32) ((0x209CC8EB1CC1A99CuLL) >> 32)},
    {(VUINT32) ((0xFA4E422FC5DEFC94uLL) >> 0),
     (VUINT32) ((0xFA4E422FC5DEFC94uLL) >> 32)}},
   {{(VUINT32) ((0x84E99C7026B45F7EuLL) >> 0),
     (VUINT32) ((0x84E99C7026B45F7EuLL) >> 32)},
    {(VUINT32) ((0x413991D639835339uLL) >> 0),
     (VUINT32) ((0x413991D639835339uLL) >> 32)},
    {(VUINT32) ((0xF49C845F8BBDF928uLL) >> 0),
     (VUINT32) ((0xF49C845F8BBDF928uLL) >> 32)}},
   {{(VUINT32) ((0x09D338E04D68BEFCuLL) >> 0),
     (VUINT32) ((0x09D338E04D68BEFCuLL) >> 32)},
    {(VUINT32) ((0x827323AC7306A673uLL) >> 0),
     (VUINT32) ((0x827323AC7306A673uLL) >> 32)},
    {(VUINT32) ((0xE93908BF177BF250uLL) >> 0),
     (VUINT32) ((0xE93908BF177BF250uLL) >> 32)}},
   {{(VUINT32) ((0x13A671C09AD17DF9uLL) >> 0),
     (VUINT32) ((0x13A671C09AD17DF9uLL) >> 32)},
    {(VUINT32) ((0x04E64758E60D4CE7uLL) >> 0),
     (VUINT32) ((0x04E64758E60D4CE7uLL) >> 32)},
    {(VUINT32) ((0xD272117E2EF7E4A0uLL) >> 0),
     (VUINT32) ((0xD272117E2EF7E4A0uLL) >> 32)}},
   {{(VUINT32) ((0x274CE38135A2FBF2uLL) >> 0),
     (VUINT32) ((0x274CE38135A2FBF2uLL) >> 32)},
    {(VUINT32) ((0x09CC8EB1CC1A99CFuLL) >> 0),
     (VUINT32) ((0x09CC8EB1CC1A99CFuLL) >> 32)},
    {(VUINT32) ((0xA4E422FC5DEFC941uLL) >> 0),
     (VUINT32) ((0xA4E422FC5DEFC941uLL) >> 32)}},
   {{(VUINT32) ((0x4E99C7026B45F7E4uLL) >> 0),
     (VUINT32) ((0x4E99C7026B45F7E4uLL) >> 32)},
    {(VUINT32) ((0x13991D639835339FuLL) >> 0),
     (VUINT32) ((0x13991D639835339FuLL) >> 32)},
    {(VUINT32) ((0x49C845F8BBDF9283uLL) >> 0),
     (VUINT32) ((0x49C845F8BBDF9283uLL) >> 32)}},
   {{(VUINT32) ((0x9D338E04D68BEFC8uLL) >> 0),
     (VUINT32) ((0x9D338E04D68BEFC8uLL) >> 32)},
    {(VUINT32) ((0x27323AC7306A673EuLL) >> 0),
     (VUINT32) ((0x27323AC7306A673EuLL) >> 32)},
    {(VUINT32) ((0x93908BF177BF2507uLL) >> 0),
     (VUINT32) ((0x93908BF177BF2507uLL) >> 32)}},
   {{(VUINT32) ((0x3A671C09AD17DF90uLL) >> 0),
     (VUINT32) ((0x3A671C09AD17DF90uLL) >> 32)},
    {(VUINT32) ((0x4E64758E60D4CE7DuLL) >> 0),
     (VUINT32) ((0x4E64758E60D4CE7DuLL) >> 32)},
    {(VUINT32) ((0x272117E2EF7E4A0EuLL) >> 0),
     (VUINT32) ((0x272117E2EF7E4A0EuLL) >> 32)}},
   {{(VUINT32) ((0x74CE38135A2FBF20uLL) >> 0),
     (VUINT32) ((0x74CE38135A2FBF20uLL) >> 32)},
    {(VUINT32) ((0x9CC8EB1CC1A99CFAuLL) >> 0),
     (VUINT32) ((0x9CC8EB1CC1A99CFAuLL) >> 32)},
    {(VUINT32) ((0x4E422FC5DEFC941DuLL) >> 0),
     (VUINT32) ((0x4E422FC5DEFC941DuLL) >> 32)}},
   {{(VUINT32) ((0xE99C7026B45F7E41uLL) >> 0),
     (VUINT32) ((0xE99C7026B45F7E41uLL) >> 32)},
    {(VUINT32) ((0x3991D639835339F4uLL) >> 0),
     (VUINT32) ((0x3991D639835339F4uLL) >> 32)},
    {(VUINT32) ((0x9C845F8BBDF9283BuLL) >> 0),
     (VUINT32) ((0x9C845F8BBDF9283BuLL) >> 32)}},
   {{(VUINT32) ((0xD338E04D68BEFC82uLL) >> 0),
     (VUINT32) ((0xD338E04D68BEFC82uLL) >> 32)},
    {(VUINT32) ((0x7323AC7306A673E9uLL) >> 0),
     (VUINT32) ((0x7323AC7306A673E9uLL) >> 32)},
    {(VUINT32) ((0x3908BF177BF25076uLL) >> 0),
     (VUINT32) ((0x3908BF177BF25076uLL) >> 32)}},
   {{(VUINT32) ((0xA671C09AD17DF904uLL) >> 0),
     (VUINT32) ((0xA671C09AD17DF904uLL) >> 32)},
    {(VUINT32) ((0xE64758E60D4CE7D2uLL) >> 0),
     (VUINT32) ((0xE64758E60D4CE7D2uLL) >> 32)},
    {(VUINT32) ((0x72117E2EF7E4A0ECuLL) >> 0),
     (VUINT32) ((0x72117E2EF7E4A0ECuLL) >> 32)}},
   {{(VUINT32) ((0x4CE38135A2FBF209uLL) >> 0),
     (VUINT32) ((0x4CE38135A2FBF209uLL) >> 32)},
    {(VUINT32) ((0xCC8EB1CC1A99CFA4uLL) >> 0),
     (VUINT32) ((0xCC8EB1CC1A99CFA4uLL) >> 32)},
    {(VUINT32) ((0xE422FC5DEFC941D8uLL) >> 0),
     (VUINT32) ((0xE422FC5DEFC941D8uLL) >> 32)}},
   {{(VUINT32) ((0x99C7026B45F7E413uLL) >> 0),
     (VUINT32) ((0x99C7026B45F7E413uLL) >> 32)},
    {(VUINT32) ((0x991D639835339F49uLL) >> 0),
     (VUINT32) ((0x991D639835339F49uLL) >> 32)},
    {(VUINT32) ((0xC845F8BBDF9283B1uLL) >> 0),
     (VUINT32) ((0xC845F8BBDF9283B1uLL) >> 32)}},
   {{(VUINT32) ((0x338E04D68BEFC827uLL) >> 0),
     (VUINT32) ((0x338E04D68BEFC827uLL) >> 32)},
    {(VUINT32) ((0x323AC7306A673E93uLL) >> 0),
     (VUINT32) ((0x323AC7306A673E93uLL) >> 32)},
    {(VUINT32) ((0x908BF177BF250763uLL) >> 0),
     (VUINT32) ((0x908BF177BF250763uLL) >> 32)}},
   {{(VUINT32) ((0x671C09AD17DF904EuLL) >> 0),
     (VUINT32) ((0x671C09AD17DF904EuLL) >> 32)},
    {(VUINT32) ((0x64758E60D4CE7D27uLL) >> 0),
     (VUINT32) ((0x64758E60D4CE7D27uLL) >> 32)},
    {(VUINT32) ((0x2117E2EF7E4A0EC7uLL) >> 0),
     (VUINT32) ((0x2117E2EF7E4A0EC7uLL) >> 32)}},
   {{(VUINT32) ((0xCE38135A2FBF209CuLL) >> 0),
     (VUINT32) ((0xCE38135A2FBF209CuLL) >> 32)},
    {(VUINT32) ((0xC8EB1CC1A99CFA4EuLL) >> 0),
     (VUINT32) ((0xC8EB1CC1A99CFA4EuLL) >> 32)},
    {(VUINT32) ((0x422FC5DEFC941D8FuLL) >> 0),
     (VUINT32) ((0x422FC5DEFC941D8FuLL) >> 32)}},
   {{(VUINT32) ((0x9C7026B45F7E4139uLL) >> 0),
     (VUINT32) ((0x9C7026B45F7E4139uLL) >> 32)},
    {(VUINT32) ((0x91D639835339F49CuLL) >> 0),
     (VUINT32) ((0x91D639835339F49CuLL) >> 32)},
    {(VUINT32) ((0x845F8BBDF9283B1FuLL) >> 0),
     (VUINT32) ((0x845F8BBDF9283B1FuLL) >> 32)}},
   {{(VUINT32) ((0x38E04D68BEFC8273uLL) >> 0),
     (VUINT32) ((0x38E04D68BEFC8273uLL) >> 32)},
    {(VUINT32) ((0x23AC7306A673E939uLL) >> 0),
     (VUINT32) ((0x23AC7306A673E939uLL) >> 32)},
    {(VUINT32) ((0x08BF177BF250763FuLL) >> 0),
     (VUINT32) ((0x08BF177BF250763FuLL) >> 32)}},
   {{(VUINT32) ((0x71C09AD17DF904E6uLL) >> 0),
     (VUINT32) ((0x71C09AD17DF904E6uLL) >> 32)},
    {(VUINT32) ((0x4758E60D4CE7D272uLL) >> 0),
     (VUINT32) ((0x4758E60D4CE7D272uLL) >> 32)},
    {(VUINT32) ((0x117E2EF7E4A0EC7FuLL) >> 0),
     (VUINT32) ((0x117E2EF7E4A0EC7FuLL) >> 32)}},
   {{(VUINT32) ((0xE38135A2FBF209CCuLL) >> 0),
     (VUINT32) ((0xE38135A2FBF209CCuLL) >> 32)},
    {(VUINT32) ((0x8EB1CC1A99CFA4E4uLL) >> 0),
     (VUINT32) ((0x8EB1CC1A99CFA4E4uLL) >> 32)},
    {(VUINT32) ((0x22FC5DEFC941D8FFuLL) >> 0),
     (VUINT32) ((0x22FC5DEFC941D8FFuLL) >> 32)}},
   {{(VUINT32) ((0xC7026B45F7E41399uLL) >> 0),
     (VUINT32) ((0xC7026B45F7E41399uLL) >> 32)},
    {(VUINT32) ((0x1D639835339F49C8uLL) >> 0),
     (VUINT32) ((0x1D639835339F49C8uLL) >> 32)},
    {(VUINT32) ((0x45F8BBDF9283B1FFuLL) >> 0),
     (VUINT32) ((0x45F8BBDF9283B1FFuLL) >> 32)}},
   {{(VUINT32) ((0x8E04D68BEFC82732uLL) >> 0),
     (VUINT32) ((0x8E04D68BEFC82732uLL) >> 32)},
    {(VUINT32) ((0x3AC7306A673E9390uLL) >> 0),
     (VUINT32) ((0x3AC7306A673E9390uLL) >> 32)},
    {(VUINT32) ((0x8BF177BF250763FFuLL) >> 0),
     (VUINT32) ((0x8BF177BF250763FFuLL) >> 32)}},
   {{(VUINT32) ((0x1C09AD17DF904E64uLL) >> 0),
     (VUINT32) ((0x1C09AD17DF904E64uLL) >> 32)},
    {(VUINT32) ((0x758E60D4CE7D2721uLL) >> 0),
     (VUINT32) ((0x758E60D4CE7D2721uLL) >> 32)},
    {(VUINT32) ((0x17E2EF7E4A0EC7FEuLL) >> 0),
     (VUINT32) ((0x17E2EF7E4A0EC7FEuLL) >> 32)}},
   {{(VUINT32) ((0x38135A2FBF209CC8uLL) >> 0),
     (VUINT32) ((0x38135A2FBF209CC8uLL) >> 32)},
    {(VUINT32) ((0xEB1CC1A99CFA4E42uLL) >> 0),
     (VUINT32) ((0xEB1CC1A99CFA4E42uLL) >> 32)},
    {(VUINT32) ((0x2FC5DEFC941D8FFCuLL) >> 0),
     (VUINT32) ((0x2FC5DEFC941D8FFCuLL) >> 32)}},
   {{(VUINT32) ((0x7026B45F7E413991uLL) >> 0),
     (VUINT32) ((0x7026B45F7E413991uLL) >> 32)},
    {(VUINT32) ((0xD639835339F49C84uLL) >> 0),
     (VUINT32) ((0xD639835339F49C84uLL) >> 32)},
    {(VUINT32) ((0x5F8BBDF9283B1FF8uLL) >> 0),
     (VUINT32) ((0x5F8BBDF9283B1FF8uLL) >> 32)}},
   {{(VUINT32) ((0xE04D68BEFC827323uLL) >> 0),
     (VUINT32) ((0xE04D68BEFC827323uLL) >> 32)},
    {(VUINT32) ((0xAC7306A673E93908uLL) >> 0),
     (VUINT32) ((0xAC7306A673E93908uLL) >> 32)},
    {(VUINT32) ((0xBF177BF250763FF1uLL) >> 0),
     (VUINT32) ((0xBF177BF250763FF1uLL) >> 32)}},
   {{(VUINT32) ((0xC09AD17DF904E647uLL) >> 0),
     (VUINT32) ((0xC09AD17DF904E647uLL) >> 32)},
    {(VUINT32) ((0x58E60D4CE7D27211uLL) >> 0),
     (VUINT32) ((0x58E60D4CE7D27211uLL) >> 32)},
    {(VUINT32) ((0x7E2EF7E4A0EC7FE2uLL) >> 0),
     (VUINT32) ((0x7E2EF7E4A0EC7FE2uLL) >> 32)}},
   {{(VUINT32) ((0x8135A2FBF209CC8EuLL) >> 0),
     (VUINT32) ((0x8135A2FBF209CC8EuLL) >> 32)},
    {(VUINT32) ((0xB1CC1A99CFA4E422uLL) >> 0),
     (VUINT32) ((0xB1CC1A99CFA4E422uLL) >> 32)},
    {(VUINT32) ((0xFC5DEFC941D8FFC4uLL) >> 0),
     (VUINT32) ((0xFC5DEFC941D8FFC4uLL) >> 32)}},
   {{(VUINT32) ((0x026B45F7E413991DuLL) >> 0),
     (VUINT32) ((0x026B45F7E413991DuLL) >> 32)},
    {(VUINT32) ((0x639835339F49C845uLL) >> 0),
     (VUINT32) ((0x639835339F49C845uLL) >> 32)},
    {(VUINT32) ((0xF8BBDF9283B1FF89uLL) >> 0),
     (VUINT32) ((0xF8BBDF9283B1FF89uLL) >> 32)}},
   {{(VUINT32) ((0x04D68BEFC827323AuLL) >> 0),
     (VUINT32) ((0x04D68BEFC827323AuLL) >> 32)},
    {(VUINT32) ((0xC7306A673E93908BuLL) >> 0),
     (VUINT32) ((0xC7306A673E93908BuLL) >> 32)},
    {(VUINT32) ((0xF177BF250763FF12uLL) >> 0),
     (VUINT32) ((0xF177BF250763FF12uLL) >> 32)}},
   {{(VUINT32) ((0x09AD17DF904E6475uLL) >> 0),
     (VUINT32) ((0x09AD17DF904E6475uLL) >> 32)},
    {(VUINT32) ((0x8E60D4CE7D272117uLL) >> 0),
     (VUINT32) ((0x8E60D4CE7D272117uLL) >> 32)},
    {(VUINT32) ((0xE2EF7E4A0EC7FE25uLL) >> 0),
     (VUINT32) ((0xE2EF7E4A0EC7FE25uLL) >> 32)}},
   {{(VUINT32) ((0x135A2FBF209CC8EBuLL) >> 0),
     (VUINT32) ((0x135A2FBF209CC8EBuLL) >> 32)},
    {(VUINT32) ((0x1CC1A99CFA4E422FuLL) >> 0),
     (VUINT32) ((0x1CC1A99CFA4E422FuLL) >> 32)},
    {(VUINT32) ((0xC5DEFC941D8FFC4BuLL) >> 0),
     (VUINT32) ((0xC5DEFC941D8FFC4BuLL) >> 32)}},
   {{(VUINT32) ((0x26B45F7E413991D6uLL) >> 0),
     (VUINT32) ((0x26B45F7E413991D6uLL) >> 32)},
    {(VUINT32) ((0x39835339F49C845FuLL) >> 0),
     (VUINT32) ((0x39835339F49C845FuLL) >> 32)},
    {(VUINT32) ((0x8BBDF9283B1FF897uLL) >> 0),
     (VUINT32) ((0x8BBDF9283B1FF897uLL) >> 32)}},
   {{(VUINT32) ((0x4D68BEFC827323ACuLL) >> 0),
     (VUINT32) ((0x4D68BEFC827323ACuLL) >> 32)},
    {(VUINT32) ((0x7306A673E93908BFuLL) >> 0),
     (VUINT32) ((0x7306A673E93908BFuLL) >> 32)},
    {(VUINT32) ((0x177BF250763FF12FuLL) >> 0),
     (VUINT32) ((0x177BF250763FF12FuLL) >> 32)}},
   {{(VUINT32) ((0x9AD17DF904E64758uLL) >> 0),
     (VUINT32) ((0x9AD17DF904E64758uLL) >> 32)},
    {(VUINT32) ((0xE60D4CE7D272117EuLL) >> 0),
     (VUINT32) ((0xE60D4CE7D272117EuLL) >> 32)},
    {(VUINT32) ((0x2EF7E4A0EC7FE25FuLL) >> 0),
     (VUINT32) ((0x2EF7E4A0EC7FE25FuLL) >> 32)}},
   {{(VUINT32) ((0x35A2FBF209CC8EB1uLL) >> 0),
     (VUINT32) ((0x35A2FBF209CC8EB1uLL) >> 32)},
    {(VUINT32) ((0xCC1A99CFA4E422FCuLL) >> 0),
     (VUINT32) ((0xCC1A99CFA4E422FCuLL) >> 32)},
    {(VUINT32) ((0x5DEFC941D8FFC4BFuLL) >> 0),
     (VUINT32) ((0x5DEFC941D8FFC4BFuLL) >> 32)}},
   {{(VUINT32) ((0x6B45F7E413991D63uLL) >> 0),
     (VUINT32) ((0x6B45F7E413991D63uLL) >> 32)},
    {(VUINT32) ((0x9835339F49C845F8uLL) >> 0),
     (VUINT32) ((0x9835339F49C845F8uLL) >> 32)},
    {(VUINT32) ((0xBBDF9283B1FF897FuLL) >> 0),
     (VUINT32) ((0xBBDF9283B1FF897FuLL) >> 32)}},
   {{(VUINT32) ((0xD68BEFC827323AC7uLL) >> 0),
     (VUINT32) ((0xD68BEFC827323AC7uLL) >> 32)},
    {(VUINT32) ((0x306A673E93908BF1uLL) >> 0),
     (VUINT32) ((0x306A673E93908BF1uLL) >> 32)},
    {(VUINT32) ((0x77BF250763FF12FFuLL) >> 0),
     (VUINT32) ((0x77BF250763FF12FFuLL) >> 32)}},
   {{(VUINT32) ((0xAD17DF904E64758EuLL) >> 0),
     (VUINT32) ((0xAD17DF904E64758EuLL) >> 32)},
    {(VUINT32) ((0x60D4CE7D272117E2uLL) >> 0),
     (VUINT32) ((0x60D4CE7D272117E2uLL) >> 32)},
    {(VUINT32) ((0xEF7E4A0EC7FE25FFuLL) >> 0),
     (VUINT32) ((0xEF7E4A0EC7FE25FFuLL) >> 32)}},
   {{(VUINT32) ((0x5A2FBF209CC8EB1CuLL) >> 0),
     (VUINT32) ((0x5A2FBF209CC8EB1CuLL) >> 32)},
    {(VUINT32) ((0xC1A99CFA4E422FC5uLL) >> 0),
     (VUINT32) ((0xC1A99CFA4E422FC5uLL) >> 32)},
    {(VUINT32) ((0xDEFC941D8FFC4BFFuLL) >> 0),
     (VUINT32) ((0xDEFC941D8FFC4BFFuLL) >> 32)}},
   {{(VUINT32) ((0xB45F7E413991D639uLL) >> 0),
     (VUINT32) ((0xB45F7E413991D639uLL) >> 32)},
    {(VUINT32) ((0x835339F49C845F8BuLL) >> 0),
     (VUINT32) ((0x835339F49C845F8BuLL) >> 32)},
    {(VUINT32) ((0xBDF9283B1FF897FFuLL) >> 0),
     (VUINT32) ((0xBDF9283B1FF897FFuLL) >> 32)}},
   {{(VUINT32) ((0x68BEFC827323AC73uLL) >> 0),
     (VUINT32) ((0x68BEFC827323AC73uLL) >> 32)},
    {(VUINT32) ((0x06A673E93908BF17uLL) >> 0),
     (VUINT32) ((0x06A673E93908BF17uLL) >> 32)},
    {(VUINT32) ((0x7BF250763FF12FFFuLL) >> 0),
     (VUINT32) ((0x7BF250763FF12FFFuLL) >> 32)}},
   {{(VUINT32) ((0xD17DF904E64758E6uLL) >> 0),
     (VUINT32) ((0xD17DF904E64758E6uLL) >> 32)},
    {(VUINT32) ((0x0D4CE7D272117E2EuLL) >> 0),
     (VUINT32) ((0x0D4CE7D272117E2EuLL) >> 32)},
    {(VUINT32) ((0xF7E4A0EC7FE25FFFuLL) >> 0),
     (VUINT32) ((0xF7E4A0EC7FE25FFFuLL) >> 32)}},
   {{(VUINT32) ((0xA2FBF209CC8EB1CCuLL) >> 0),
     (VUINT32) ((0xA2FBF209CC8EB1CCuLL) >> 32)},
    {(VUINT32) ((0x1A99CFA4E422FC5DuLL) >> 0),
     (VUINT32) ((0x1A99CFA4E422FC5DuLL) >> 32)},
    {(VUINT32) ((0xEFC941D8FFC4BFFEuLL) >> 0),
     (VUINT32) ((0xEFC941D8FFC4BFFEuLL) >> 32)}},
   {{(VUINT32) ((0x45F7E413991D6398uLL) >> 0),
     (VUINT32) ((0x45F7E413991D6398uLL) >> 32)},
    {(VUINT32) ((0x35339F49C845F8BBuLL) >> 0),
     (VUINT32) ((0x35339F49C845F8BBuLL) >> 32)},
    {(VUINT32) ((0xDF9283B1FF897FFDuLL) >> 0),
     (VUINT32) ((0xDF9283B1FF897FFDuLL) >> 32)}},
   {{(VUINT32) ((0x8BEFC827323AC730uLL) >> 0),
     (VUINT32) ((0x8BEFC827323AC730uLL) >> 32)},
    {(VUINT32) ((0x6A673E93908BF177uLL) >> 0),
     (VUINT32) ((0x6A673E93908BF177uLL) >> 32)},
    {(VUINT32) ((0xBF250763FF12FFFBuLL) >> 0),
     (VUINT32) ((0xBF250763FF12FFFBuLL) >> 32)}},
   {{(VUINT32) ((0x17DF904E64758E60uLL) >> 0),
     (VUINT32) ((0x17DF904E64758E60uLL) >> 32)},
    {(VUINT32) ((0xD4CE7D272117E2EFuLL) >> 0),
     (VUINT32) ((0xD4CE7D272117E2EFuLL) >> 32)},
    {(VUINT32) ((0x7E4A0EC7FE25FFF7uLL) >> 0),
     (VUINT32) ((0x7E4A0EC7FE25FFF7uLL) >> 32)}},
   {{(VUINT32) ((0x2FBF209CC8EB1CC1uLL) >> 0),
     (VUINT32) ((0x2FBF209CC8EB1CC1uLL) >> 32)},
    {(VUINT32) ((0xA99CFA4E422FC5DEuLL) >> 0),
     (VUINT32) ((0xA99CFA4E422FC5DEuLL) >> 32)},
    {(VUINT32) ((0xFC941D8FFC4BFFEFuLL) >> 0),
     (VUINT32) ((0xFC941D8FFC4BFFEFuLL) >> 32)}},
   {{(VUINT32) ((0x5F7E413991D63983uLL) >> 0),
     (VUINT32) ((0x5F7E413991D63983uLL) >> 32)},
    {(VUINT32) ((0x5339F49C845F8BBDuLL) >> 0),
     (VUINT32) ((0x5339F49C845F8BBDuLL) >> 32)},
    {(VUINT32) ((0xF9283B1FF897FFDEuLL) >> 0),
     (VUINT32) ((0xF9283B1FF897FFDEuLL) >> 32)}},
   {{(VUINT32) ((0xBEFC827323AC7306uLL) >> 0),
     (VUINT32) ((0xBEFC827323AC7306uLL) >> 32)},
    {(VUINT32) ((0xA673E93908BF177BuLL) >> 0),
     (VUINT32) ((0xA673E93908BF177BuLL) >> 32)},
    {(VUINT32) ((0xF250763FF12FFFBCuLL) >> 0),
     (VUINT32) ((0xF250763FF12FFFBCuLL) >> 32)}},
   {{(VUINT32) ((0x7DF904E64758E60DuLL) >> 0),
     (VUINT32) ((0x7DF904E64758E60DuLL) >> 32)},
    {(VUINT32) ((0x4CE7D272117E2EF7uLL) >> 0),
     (VUINT32) ((0x4CE7D272117E2EF7uLL) >> 32)},
    {(VUINT32) ((0xE4A0EC7FE25FFF78uLL) >> 0),
     (VUINT32) ((0xE4A0EC7FE25FFF78uLL) >> 32)}},
   {{(VUINT32) ((0xFBF209CC8EB1CC1AuLL) >> 0),
     (VUINT32) ((0xFBF209CC8EB1CC1AuLL) >> 32)},
    {(VUINT32) ((0x99CFA4E422FC5DEFuLL) >> 0),
     (VUINT32) ((0x99CFA4E422FC5DEFuLL) >> 32)},
    {(VUINT32) ((0xC941D8FFC4BFFEF0uLL) >> 0),
     (VUINT32) ((0xC941D8FFC4BFFEF0uLL) >> 32)}},
   {{(VUINT32) ((0xF7E413991D639835uLL) >> 0),
     (VUINT32) ((0xF7E413991D639835uLL) >> 32)},
    {(VUINT32) ((0x339F49C845F8BBDFuLL) >> 0),
     (VUINT32) ((0x339F49C845F8BBDFuLL) >> 32)},
    {(VUINT32) ((0x9283B1FF897FFDE0uLL) >> 0),
     (VUINT32) ((0x9283B1FF897FFDE0uLL) >> 32)}},
   {{(VUINT32) ((0xEFC827323AC7306AuLL) >> 0),
     (VUINT32) ((0xEFC827323AC7306AuLL) >> 32)},
    {(VUINT32) ((0x673E93908BF177BFuLL) >> 0),
     (VUINT32) ((0x673E93908BF177BFuLL) >> 32)},
    {(VUINT32) ((0x250763FF12FFFBC0uLL) >> 0),
     (VUINT32) ((0x250763FF12FFFBC0uLL) >> 32)}},
   {{(VUINT32) ((0xDF904E64758E60D4uLL) >> 0),
     (VUINT32) ((0xDF904E64758E60D4uLL) >> 32)},
    {(VUINT32) ((0xCE7D272117E2EF7EuLL) >> 0),
     (VUINT32) ((0xCE7D272117E2EF7EuLL) >> 32)},
    {(VUINT32) ((0x4A0EC7FE25FFF781uLL) >> 0),
     (VUINT32) ((0x4A0EC7FE25FFF781uLL) >> 32)}},
   {{(VUINT32) ((0xBF209CC8EB1CC1A9uLL) >> 0),
     (VUINT32) ((0xBF209CC8EB1CC1A9uLL) >> 32)},
    {(VUINT32) ((0x9CFA4E422FC5DEFCuLL) >> 0),
     (VUINT32) ((0x9CFA4E422FC5DEFCuLL) >> 32)},
    {(VUINT32) ((0x941D8FFC4BFFEF02uLL) >> 0),
     (VUINT32) ((0x941D8FFC4BFFEF02uLL) >> 32)}},
   {{(VUINT32) ((0x7E413991D6398353uLL) >> 0),
     (VUINT32) ((0x7E413991D6398353uLL) >> 32)},
    {(VUINT32) ((0x39F49C845F8BBDF9uLL) >> 0),
     (VUINT32) ((0x39F49C845F8BBDF9uLL) >> 32)},
    {(VUINT32) ((0x283B1FF897FFDE05uLL) >> 0),
     (VUINT32) ((0x283B1FF897FFDE05uLL) >> 32)}},
   {{(VUINT32) ((0xFC827323AC7306A6uLL) >> 0),
     (VUINT32) ((0xFC827323AC7306A6uLL) >> 32)},
    {(VUINT32) ((0x73E93908BF177BF2uLL) >> 0),
     (VUINT32) ((0x73E93908BF177BF2uLL) >> 32)},
    {(VUINT32) ((0x50763FF12FFFBC0BuLL) >> 0),
     (VUINT32) ((0x50763FF12FFFBC0BuLL) >> 32)}},
   {{(VUINT32) ((0xF904E64758E60D4CuLL) >> 0),
     (VUINT32) ((0xF904E64758E60D4CuLL) >> 32)},
    {(VUINT32) ((0xE7D272117E2EF7E4uLL) >> 0),
     (VUINT32) ((0xE7D272117E2EF7E4uLL) >> 32)},
    {(VUINT32) ((0xA0EC7FE25FFF7816uLL) >> 0),
     (VUINT32) ((0xA0EC7FE25FFF7816uLL) >> 32)}},
   {{(VUINT32) ((0xF209CC8EB1CC1A99uLL) >> 0),
     (VUINT32) ((0xF209CC8EB1CC1A99uLL) >> 32)},
    {(VUINT32) ((0xCFA4E422FC5DEFC9uLL) >> 0),
     (VUINT32) ((0xCFA4E422FC5DEFC9uLL) >> 32)},
    {(VUINT32) ((0x41D8FFC4BFFEF02CuLL) >> 0),
     (VUINT32) ((0x41D8FFC4BFFEF02CuLL) >> 32)}},
   {{(VUINT32) ((0xE413991D63983533uLL) >> 0),
     (VUINT32) ((0xE413991D63983533uLL) >> 32)},
    {(VUINT32) ((0x9F49C845F8BBDF92uLL) >> 0),
     (VUINT32) ((0x9F49C845F8BBDF92uLL) >> 32)},
    {(VUINT32) ((0x83B1FF897FFDE059uLL) >> 0),
     (VUINT32) ((0x83B1FF897FFDE059uLL) >> 32)}},
   {{(VUINT32) ((0xC827323AC7306A67uLL) >> 0),
     (VUINT32) ((0xC827323AC7306A67uLL) >> 32)},
    {(VUINT32) ((0x3E93908BF177BF25uLL) >> 0),
     (VUINT32) ((0x3E93908BF177BF25uLL) >> 32)},
    {(VUINT32) ((0x0763FF12FFFBC0B3uLL) >> 0),
     (VUINT32) ((0x0763FF12FFFBC0B3uLL) >> 32)}},
   {{(VUINT32) ((0x904E64758E60D4CEuLL) >> 0),
     (VUINT32) ((0x904E64758E60D4CEuLL) >> 32)},
    {(VUINT32) ((0x7D272117E2EF7E4AuLL) >> 0),
     (VUINT32) ((0x7D272117E2EF7E4AuLL) >> 32)},
    {(VUINT32) ((0x0EC7FE25FFF78166uLL) >> 0),
     (VUINT32) ((0x0EC7FE25FFF78166uLL) >> 32)}},
   {{(VUINT32) ((0x209CC8EB1CC1A99CuLL) >> 0),
     (VUINT32) ((0x209CC8EB1CC1A99CuLL) >> 32)},
    {(VUINT32) ((0xFA4E422FC5DEFC94uLL) >> 0),
     (VUINT32) ((0xFA4E422FC5DEFC94uLL) >> 32)},
    {(VUINT32) ((0x1D8FFC4BFFEF02CCuLL) >> 0),
     (VUINT32) ((0x1D8FFC4BFFEF02CCuLL) >> 32)}},
   {{(VUINT32) ((0x413991D639835339uLL) >> 0),
     (VUINT32) ((0x413991D639835339uLL) >> 32)},
    {(VUINT32) ((0xF49C845F8BBDF928uLL) >> 0),
     (VUINT32) ((0xF49C845F8BBDF928uLL) >> 32)},
    {(VUINT32) ((0x3B1FF897FFDE0598uLL) >> 0),
     (VUINT32) ((0x3B1FF897FFDE0598uLL) >> 32)}},
   {{(VUINT32) ((0x827323AC7306A673uLL) >> 0),
     (VUINT32) ((0x827323AC7306A673uLL) >> 32)},
    {(VUINT32) ((0xE93908BF177BF250uLL) >> 0),
     (VUINT32) ((0xE93908BF177BF250uLL) >> 32)},
    {(VUINT32) ((0x763FF12FFFBC0B30uLL) >> 0),
     (VUINT32) ((0x763FF12FFFBC0B30uLL) >> 32)}},
   {{(VUINT32) ((0x04E64758E60D4CE7uLL) >> 0),
     (VUINT32) ((0x04E64758E60D4CE7uLL) >> 32)},
    {(VUINT32) ((0xD272117E2EF7E4A0uLL) >> 0),
     (VUINT32) ((0xD272117E2EF7E4A0uLL) >> 32)},
    {(VUINT32) ((0xEC7FE25FFF781660uLL) >> 0),
     (VUINT32) ((0xEC7FE25FFF781660uLL) >> 32)}},
   {{(VUINT32) ((0x09CC8EB1CC1A99CFuLL) >> 0),
     (VUINT32) ((0x09CC8EB1CC1A99CFuLL) >> 32)},
    {(VUINT32) ((0xA4E422FC5DEFC941uLL) >> 0),
     (VUINT32) ((0xA4E422FC5DEFC941uLL) >> 32)},
    {(VUINT32) ((0xD8FFC4BFFEF02CC0uLL) >> 0),
     (VUINT32) ((0xD8FFC4BFFEF02CC0uLL) >> 32)}},
   {{(VUINT32) ((0x13991D639835339FuLL) >> 0),
     (VUINT32) ((0x13991D639835339FuLL) >> 32)},
    {(VUINT32) ((0x49C845F8BBDF9283uLL) >> 0),
     (VUINT32) ((0x49C845F8BBDF9283uLL) >> 32)},
    {(VUINT32) ((0xB1FF897FFDE05980uLL) >> 0),
     (VUINT32) ((0xB1FF897FFDE05980uLL) >> 32)}},
   {{(VUINT32) ((0x27323AC7306A673EuLL) >> 0),
     (VUINT32) ((0x27323AC7306A673EuLL) >> 32)},
    {(VUINT32) ((0x93908BF177BF2507uLL) >> 0),
     (VUINT32) ((0x93908BF177BF2507uLL) >> 32)},
    {(VUINT32) ((0x63FF12FFFBC0B301uLL) >> 0),
     (VUINT32) ((0x63FF12FFFBC0B301uLL) >> 32)}},
   {{(VUINT32) ((0x4E64758E60D4CE7DuLL) >> 0),
     (VUINT32) ((0x4E64758E60D4CE7DuLL) >> 32)},
    {(VUINT32) ((0x272117E2EF7E4A0EuLL) >> 0),
     (VUINT32) ((0x272117E2EF7E4A0EuLL) >> 32)},
    {(VUINT32) ((0xC7FE25FFF7816603uLL) >> 0),
     (VUINT32) ((0xC7FE25FFF7816603uLL) >> 32)}},
   {{(VUINT32) ((0x9CC8EB1CC1A99CFAuLL) >> 0),
     (VUINT32) ((0x9CC8EB1CC1A99CFAuLL) >> 32)},
    {(VUINT32) ((0x4E422FC5DEFC941DuLL) >> 0),
     (VUINT32) ((0x4E422FC5DEFC941DuLL) >> 32)},
    {(VUINT32) ((0x8FFC4BFFEF02CC07uLL) >> 0),
     (VUINT32) ((0x8FFC4BFFEF02CC07uLL) >> 32)}},
   {{(VUINT32) ((0x3991D639835339F4uLL) >> 0),
     (VUINT32) ((0x3991D639835339F4uLL) >> 32)},
    {(VUINT32) ((0x9C845F8BBDF9283BuLL) >> 0),
     (VUINT32) ((0x9C845F8BBDF9283BuLL) >> 32)},
    {(VUINT32) ((0x1FF897FFDE05980FuLL) >> 0),
     (VUINT32) ((0x1FF897FFDE05980FuLL) >> 32)}},
   {{(VUINT32) ((0x7323AC7306A673E9uLL) >> 0),
     (VUINT32) ((0x7323AC7306A673E9uLL) >> 32)},
    {(VUINT32) ((0x3908BF177BF25076uLL) >> 0),
     (VUINT32) ((0x3908BF177BF25076uLL) >> 32)},
    {(VUINT32) ((0x3FF12FFFBC0B301FuLL) >> 0),
     (VUINT32) ((0x3FF12FFFBC0B301FuLL) >> 32)}},
   {{(VUINT32) ((0xE64758E60D4CE7D2uLL) >> 0),
     (VUINT32) ((0xE64758E60D4CE7D2uLL) >> 32)},
    {(VUINT32) ((0x72117E2EF7E4A0ECuLL) >> 0),
     (VUINT32) ((0x72117E2EF7E4A0ECuLL) >> 32)},
    {(VUINT32) ((0x7FE25FFF7816603FuLL) >> 0),
     (VUINT32) ((0x7FE25FFF7816603FuLL) >> 32)}},
   {{(VUINT32) ((0xCC8EB1CC1A99CFA4uLL) >> 0),
     (VUINT32) ((0xCC8EB1CC1A99CFA4uLL) >> 32)},
    {(VUINT32) ((0xE422FC5DEFC941D8uLL) >> 0),
     (VUINT32) ((0xE422FC5DEFC941D8uLL) >> 32)},
    {(VUINT32) ((0xFFC4BFFEF02CC07FuLL) >> 0),
     (VUINT32) ((0xFFC4BFFEF02CC07FuLL) >> 32)}},
   {{(VUINT32) ((0x991D639835339F49uLL) >> 0),
     (VUINT32) ((0x991D639835339F49uLL) >> 32)},
    {(VUINT32) ((0xC845F8BBDF9283B1uLL) >> 0),
     (VUINT32) ((0xC845F8BBDF9283B1uLL) >> 32)},
    {(VUINT32) ((0xFF897FFDE05980FEuLL) >> 0),
     (VUINT32) ((0xFF897FFDE05980FEuLL) >> 32)}},
   {{(VUINT32) ((0x323AC7306A673E93uLL) >> 0),
     (VUINT32) ((0x323AC7306A673E93uLL) >> 32)},
    {(VUINT32) ((0x908BF177BF250763uLL) >> 0),
     (VUINT32) ((0x908BF177BF250763uLL) >> 32)},
    {(VUINT32) ((0xFF12FFFBC0B301FDuLL) >> 0),
     (VUINT32) ((0xFF12FFFBC0B301FDuLL) >> 32)}},
   {{(VUINT32) ((0x64758E60D4CE7D27uLL) >> 0),
     (VUINT32) ((0x64758E60D4CE7D27uLL) >> 32)},
    {(VUINT32) ((0x2117E2EF7E4A0EC7uLL) >> 0),
     (VUINT32) ((0x2117E2EF7E4A0EC7uLL) >> 32)},
    {(VUINT32) ((0xFE25FFF7816603FBuLL) >> 0),
     (VUINT32) ((0xFE25FFF7816603FBuLL) >> 32)}},
   {{(VUINT32) ((0xC8EB1CC1A99CFA4EuLL) >> 0),
     (VUINT32) ((0xC8EB1CC1A99CFA4EuLL) >> 32)},
    {(VUINT32) ((0x422FC5DEFC941D8FuLL) >> 0),
     (VUINT32) ((0x422FC5DEFC941D8FuLL) >> 32)},
    {(VUINT32) ((0xFC4BFFEF02CC07F7uLL) >> 0),
     (VUINT32) ((0xFC4BFFEF02CC07F7uLL) >> 32)}},
   {{(VUINT32) ((0x91D639835339F49CuLL) >> 0),
     (VUINT32) ((0x91D639835339F49CuLL) >> 32)},
    {(VUINT32) ((0x845F8BBDF9283B1FuLL) >> 0),
     (VUINT32) ((0x845F8BBDF9283B1FuLL) >> 32)},
    {(VUINT32) ((0xF897FFDE05980FEFuLL) >> 0),
     (VUINT32) ((0xF897FFDE05980FEFuLL) >> 32)}},
   {{(VUINT32) ((0x23AC7306A673E939uLL) >> 0),
     (VUINT32) ((0x23AC7306A673E939uLL) >> 32)},
    {(VUINT32) ((0x08BF177BF250763FuLL) >> 0),
     (VUINT32) ((0x08BF177BF250763FuLL) >> 32)},
    {(VUINT32) ((0xF12FFFBC0B301FDEuLL) >> 0),
     (VUINT32) ((0xF12FFFBC0B301FDEuLL) >> 32)}},
   {{(VUINT32) ((0x4758E60D4CE7D272uLL) >> 0),
     (VUINT32) ((0x4758E60D4CE7D272uLL) >> 32)},
    {(VUINT32) ((0x117E2EF7E4A0EC7FuLL) >> 0),
     (VUINT32) ((0x117E2EF7E4A0EC7FuLL) >> 32)},
    {(VUINT32) ((0xE25FFF7816603FBCuLL) >> 0),
     (VUINT32) ((0xE25FFF7816603FBCuLL) >> 32)}},
   {{(VUINT32) ((0x8EB1CC1A99CFA4E4uLL) >> 0),
     (VUINT32) ((0x8EB1CC1A99CFA4E4uLL) >> 32)},
    {(VUINT32) ((0x22FC5DEFC941D8FFuLL) >> 0),
     (VUINT32) ((0x22FC5DEFC941D8FFuLL) >> 32)},
    {(VUINT32) ((0xC4BFFEF02CC07F79uLL) >> 0),
     (VUINT32) ((0xC4BFFEF02CC07F79uLL) >> 32)}},
   {{(VUINT32) ((0x1D639835339F49C8uLL) >> 0),
     (VUINT32) ((0x1D639835339F49C8uLL) >> 32)},
    {(VUINT32) ((0x45F8BBDF9283B1FFuLL) >> 0),
     (VUINT32) ((0x45F8BBDF9283B1FFuLL) >> 32)},
    {(VUINT32) ((0x897FFDE05980FEF2uLL) >> 0),
     (VUINT32) ((0x897FFDE05980FEF2uLL) >> 32)}},
   {{(VUINT32) ((0x3AC7306A673E9390uLL) >> 0),
     (VUINT32) ((0x3AC7306A673E9390uLL) >> 32)},
    {(VUINT32) ((0x8BF177BF250763FFuLL) >> 0),
     (VUINT32) ((0x8BF177BF250763FFuLL) >> 32)},
    {(VUINT32) ((0x12FFFBC0B301FDE5uLL) >> 0),
     (VUINT32) ((0x12FFFBC0B301FDE5uLL) >> 32)}},
   {{(VUINT32) ((0x758E60D4CE7D2721uLL) >> 0),
     (VUINT32) ((0x758E60D4CE7D2721uLL) >> 32)},
    {(VUINT32) ((0x17E2EF7E4A0EC7FEuLL) >> 0),
     (VUINT32) ((0x17E2EF7E4A0EC7FEuLL) >> 32)},
    {(VUINT32) ((0x25FFF7816603FBCBuLL) >> 0),
     (VUINT32) ((0x25FFF7816603FBCBuLL) >> 32)}},
   {{(VUINT32) ((0xEB1CC1A99CFA4E42uLL) >> 0),
     (VUINT32) ((0xEB1CC1A99CFA4E42uLL) >> 32)},
    {(VUINT32) ((0x2FC5DEFC941D8FFCuLL) >> 0),
     (VUINT32) ((0x2FC5DEFC941D8FFCuLL) >> 32)},
    {(VUINT32) ((0x4BFFEF02CC07F797uLL) >> 0),
     (VUINT32) ((0x4BFFEF02CC07F797uLL) >> 32)}},
   {{(VUINT32) ((0xD639835339F49C84uLL) >> 0),
     (VUINT32) ((0xD639835339F49C84uLL) >> 32)},
    {(VUINT32) ((0x5F8BBDF9283B1FF8uLL) >> 0),
     (VUINT32) ((0x5F8BBDF9283B1FF8uLL) >> 32)},
    {(VUINT32) ((0x97FFDE05980FEF2FuLL) >> 0),
     (VUINT32) ((0x97FFDE05980FEF2FuLL) >> 32)}},
   {{(VUINT32) ((0xAC7306A673E93908uLL) >> 0),
     (VUINT32) ((0xAC7306A673E93908uLL) >> 32)},
    {(VUINT32) ((0xBF177BF250763FF1uLL) >> 0),
     (VUINT32) ((0xBF177BF250763FF1uLL) >> 32)},
    {(VUINT32) ((0x2FFFBC0B301FDE5EuLL) >> 0),
     (VUINT32) ((0x2FFFBC0B301FDE5EuLL) >> 32)}},
   {{(VUINT32) ((0x58E60D4CE7D27211uLL) >> 0),
     (VUINT32) ((0x58E60D4CE7D27211uLL) >> 32)},
    {(VUINT32) ((0x7E2EF7E4A0EC7FE2uLL) >> 0),
     (VUINT32) ((0x7E2EF7E4A0EC7FE2uLL) >> 32)},
    {(VUINT32) ((0x5FFF7816603FBCBCuLL) >> 0),
     (VUINT32) ((0x5FFF7816603FBCBCuLL) >> 32)}},
   {{(VUINT32) ((0xB1CC1A99CFA4E422uLL) >> 0),
     (VUINT32) ((0xB1CC1A99CFA4E422uLL) >> 32)},
    {(VUINT32) ((0xFC5DEFC941D8FFC4uLL) >> 0),
     (VUINT32) ((0xFC5DEFC941D8FFC4uLL) >> 32)},
    {(VUINT32) ((0xBFFEF02CC07F7978uLL) >> 0),
     (VUINT32) ((0xBFFEF02CC07F7978uLL) >> 32)}},
   {{(VUINT32) ((0x639835339F49C845uLL) >> 0),
     (VUINT32) ((0x639835339F49C845uLL) >> 32)},
    {(VUINT32) ((0xF8BBDF9283B1FF89uLL) >> 0),
     (VUINT32) ((0xF8BBDF9283B1FF89uLL) >> 32)},
    {(VUINT32) ((0x7FFDE05980FEF2F1uLL) >> 0),
     (VUINT32) ((0x7FFDE05980FEF2F1uLL) >> 32)}},
   {{(VUINT32) ((0xC7306A673E93908BuLL) >> 0),
     (VUINT32) ((0xC7306A673E93908BuLL) >> 32)},
    {(VUINT32) ((0xF177BF250763FF12uLL) >> 0),
     (VUINT32) ((0xF177BF250763FF12uLL) >> 32)},
    {(VUINT32) ((0xFFFBC0B301FDE5E2uLL) >> 0),
     (VUINT32) ((0xFFFBC0B301FDE5E2uLL) >> 32)}},
   {{(VUINT32) ((0x8E60D4CE7D272117uLL) >> 0),
     (VUINT32) ((0x8E60D4CE7D272117uLL) >> 32)},
    {(VUINT32) ((0xE2EF7E4A0EC7FE25uLL) >> 0),
     (VUINT32) ((0xE2EF7E4A0EC7FE25uLL) >> 32)},
    {(VUINT32) ((0xFFF7816603FBCBC4uLL) >> 0),
     (VUINT32) ((0xFFF7816603FBCBC4uLL) >> 32)}},
   {{(VUINT32) ((0x1CC1A99CFA4E422FuLL) >> 0),
     (VUINT32) ((0x1CC1A99CFA4E422FuLL) >> 32)},
    {(VUINT32) ((0xC5DEFC941D8FFC4BuLL) >> 0),
     (VUINT32) ((0xC5DEFC941D8FFC4BuLL) >> 32)},
    {(VUINT32) ((0xFFEF02CC07F79788uLL) >> 0),
     (VUINT32) ((0xFFEF02CC07F79788uLL) >> 32)}},
   {{(VUINT32) ((0x39835339F49C845FuLL) >> 0),
     (VUINT32) ((0x39835339F49C845FuLL) >> 32)},
    {(VUINT32) ((0x8BBDF9283B1FF897uLL) >> 0),
     (VUINT32) ((0x8BBDF9283B1FF897uLL) >> 32)},
    {(VUINT32) ((0xFFDE05980FEF2F11uLL) >> 0),
     (VUINT32) ((0xFFDE05980FEF2F11uLL) >> 32)}},
   {{(VUINT32) ((0x7306A673E93908BFuLL) >> 0),
     (VUINT32) ((0x7306A673E93908BFuLL) >> 32)},
    {(VUINT32) ((0x177BF250763FF12FuLL) >> 0),
     (VUINT32) ((0x177BF250763FF12FuLL) >> 32)},
    {(VUINT32) ((0xFFBC0B301FDE5E23uLL) >> 0),
     (VUINT32) ((0xFFBC0B301FDE5E23uLL) >> 32)}},
   {{(VUINT32) ((0xE60D4CE7D272117EuLL) >> 0),
     (VUINT32) ((0xE60D4CE7D272117EuLL) >> 32)},
    {(VUINT32) ((0x2EF7E4A0EC7FE25FuLL) >> 0),
     (VUINT32) ((0x2EF7E4A0EC7FE25FuLL) >> 32)},
    {(VUINT32) ((0xFF7816603FBCBC46uLL) >> 0),
     (VUINT32) ((0xFF7816603FBCBC46uLL) >> 32)}},
   {{(VUINT32) ((0xCC1A99CFA4E422FCuLL) >> 0),
     (VUINT32) ((0xCC1A99CFA4E422FCuLL) >> 32)},
    {(VUINT32) ((0x5DEFC941D8FFC4BFuLL) >> 0),
     (VUINT32) ((0x5DEFC941D8FFC4BFuLL) >> 32)},
    {(VUINT32) ((0xFEF02CC07F79788CuLL) >> 0),
     (VUINT32) ((0xFEF02CC07F79788CuLL) >> 32)}},
   {{(VUINT32) ((0x9835339F49C845F8uLL) >> 0),
     (VUINT32) ((0x9835339F49C845F8uLL) >> 32)},
    {(VUINT32) ((0xBBDF9283B1FF897FuLL) >> 0),
     (VUINT32) ((0xBBDF9283B1FF897FuLL) >> 32)},
    {(VUINT32) ((0xFDE05980FEF2F118uLL) >> 0),
     (VUINT32) ((0xFDE05980FEF2F118uLL) >> 32)}},
   {{(VUINT32) ((0x306A673E93908BF1uLL) >> 0),
     (VUINT32) ((0x306A673E93908BF1uLL) >> 32)},
    {(VUINT32) ((0x77BF250763FF12FFuLL) >> 0),
     (VUINT32) ((0x77BF250763FF12FFuLL) >> 32)},
    {(VUINT32) ((0xFBC0B301FDE5E231uLL) >> 0),
     (VUINT32) ((0xFBC0B301FDE5E231uLL) >> 32)}},
   {{(VUINT32) ((0x60D4CE7D272117E2uLL) >> 0),
     (VUINT32) ((0x60D4CE7D272117E2uLL) >> 32)},
    {(VUINT32) ((0xEF7E4A0EC7FE25FFuLL) >> 0),
     (VUINT32) ((0xEF7E4A0EC7FE25FFuLL) >> 32)},
    {(VUINT32) ((0xF7816603FBCBC462uLL) >> 0),
     (VUINT32) ((0xF7816603FBCBC462uLL) >> 32)}},
   {{(VUINT32) ((0xC1A99CFA4E422FC5uLL) >> 0),
     (VUINT32) ((0xC1A99CFA4E422FC5uLL) >> 32)},
    {(VUINT32) ((0xDEFC941D8FFC4BFFuLL) >> 0),
     (VUINT32) ((0xDEFC941D8FFC4BFFuLL) >> 32)},
    {(VUINT32) ((0xEF02CC07F79788C5uLL) >> 0),
     (VUINT32) ((0xEF02CC07F79788C5uLL) >> 32)}},
   {{(VUINT32) ((0x835339F49C845F8BuLL) >> 0),
     (VUINT32) ((0x835339F49C845F8BuLL) >> 32)},
    {(VUINT32) ((0xBDF9283B1FF897FFuLL) >> 0),
     (VUINT32) ((0xBDF9283B1FF897FFuLL) >> 32)},
    {(VUINT32) ((0xDE05980FEF2F118BuLL) >> 0),
     (VUINT32) ((0xDE05980FEF2F118BuLL) >> 32)}},
   {{(VUINT32) ((0x06A673E93908BF17uLL) >> 0),
     (VUINT32) ((0x06A673E93908BF17uLL) >> 32)},
    {(VUINT32) ((0x7BF250763FF12FFFuLL) >> 0),
     (VUINT32) ((0x7BF250763FF12FFFuLL) >> 32)},
    {(VUINT32) ((0xBC0B301FDE5E2316uLL) >> 0),
     (VUINT32) ((0xBC0B301FDE5E2316uLL) >> 32)}},
   {{(VUINT32) ((0x0D4CE7D272117E2EuLL) >> 0),
     (VUINT32) ((0x0D4CE7D272117E2EuLL) >> 32)},
    {(VUINT32) ((0xF7E4A0EC7FE25FFFuLL) >> 0),
     (VUINT32) ((0xF7E4A0EC7FE25FFFuLL) >> 32)},
    {(VUINT32) ((0x7816603FBCBC462DuLL) >> 0),
     (VUINT32) ((0x7816603FBCBC462DuLL) >> 32)}},
   {{(VUINT32) ((0x1A99CFA4E422FC5DuLL) >> 0),
     (VUINT32) ((0x1A99CFA4E422FC5DuLL) >> 32)},
    {(VUINT32) ((0xEFC941D8FFC4BFFEuLL) >> 0),
     (VUINT32) ((0xEFC941D8FFC4BFFEuLL) >> 32)},
    {(VUINT32) ((0xF02CC07F79788C5AuLL) >> 0),
     (VUINT32) ((0xF02CC07F79788C5AuLL) >> 32)}},
   {{(VUINT32) ((0x35339F49C845F8BBuLL) >> 0),
     (VUINT32) ((0x35339F49C845F8BBuLL) >> 32)},
    {(VUINT32) ((0xDF9283B1FF897FFDuLL) >> 0),
     (VUINT32) ((0xDF9283B1FF897FFDuLL) >> 32)},
    {(VUINT32) ((0xE05980FEF2F118B5uLL) >> 0),
     (VUINT32) ((0xE05980FEF2F118B5uLL) >> 32)}},
   {{(VUINT32) ((0x6A673E93908BF177uLL) >> 0),
     (VUINT32) ((0x6A673E93908BF177uLL) >> 32)},
    {(VUINT32) ((0xBF250763FF12FFFBuLL) >> 0),
     (VUINT32) ((0xBF250763FF12FFFBuLL) >> 32)},
    {(VUINT32) ((0xC0B301FDE5E2316BuLL) >> 0),
     (VUINT32) ((0xC0B301FDE5E2316BuLL) >> 32)}},
   {{(VUINT32) ((0xD4CE7D272117E2EFuLL) >> 0),
     (VUINT32) ((0xD4CE7D272117E2EFuLL) >> 32)},
    {(VUINT32) ((0x7E4A0EC7FE25FFF7uLL) >> 0),
     (VUINT32) ((0x7E4A0EC7FE25FFF7uLL) >> 32)},
    {(VUINT32) ((0x816603FBCBC462D6uLL) >> 0),
     (VUINT32) ((0x816603FBCBC462D6uLL) >> 32)}},
   {{(VUINT32) ((0xA99CFA4E422FC5DEuLL) >> 0),
     (VUINT32) ((0xA99CFA4E422FC5DEuLL) >> 32)},
    {(VUINT32) ((0xFC941D8FFC4BFFEFuLL) >> 0),
     (VUINT32) ((0xFC941D8FFC4BFFEFuLL) >> 32)},
    {(VUINT32) ((0x02CC07F79788C5ADuLL) >> 0),
     (VUINT32) ((0x02CC07F79788C5ADuLL) >> 32)}},
   {{(VUINT32) ((0x5339F49C845F8BBDuLL) >> 0),
     (VUINT32) ((0x5339F49C845F8BBDuLL) >> 32)},
    {(VUINT32) ((0xF9283B1FF897FFDEuLL) >> 0),
     (VUINT32) ((0xF9283B1FF897FFDEuLL) >> 32)},
    {(VUINT32) ((0x05980FEF2F118B5AuLL) >> 0),
     (VUINT32) ((0x05980FEF2F118B5AuLL) >> 32)}},
   {{(VUINT32) ((0xA673E93908BF177BuLL) >> 0),
     (VUINT32) ((0xA673E93908BF177BuLL) >> 32)},
    {(VUINT32) ((0xF250763FF12FFFBCuLL) >> 0),
     (VUINT32) ((0xF250763FF12FFFBCuLL) >> 32)},
    {(VUINT32) ((0x0B301FDE5E2316B4uLL) >> 0),
     (VUINT32) ((0x0B301FDE5E2316B4uLL) >> 32)}},
   {{(VUINT32) ((0x4CE7D272117E2EF7uLL) >> 0),
     (VUINT32) ((0x4CE7D272117E2EF7uLL) >> 32)},
    {(VUINT32) ((0xE4A0EC7FE25FFF78uLL) >> 0),
     (VUINT32) ((0xE4A0EC7FE25FFF78uLL) >> 32)},
    {(VUINT32) ((0x16603FBCBC462D68uLL) >> 0),
     (VUINT32) ((0x16603FBCBC462D68uLL) >> 32)}},
   {{(VUINT32) ((0x99CFA4E422FC5DEFuLL) >> 0),
     (VUINT32) ((0x99CFA4E422FC5DEFuLL) >> 32)},
    {(VUINT32) ((0xC941D8FFC4BFFEF0uLL) >> 0),
     (VUINT32) ((0xC941D8FFC4BFFEF0uLL) >> 32)},
    {(VUINT32) ((0x2CC07F79788C5AD0uLL) >> 0),
     (VUINT32) ((0x2CC07F79788C5AD0uLL) >> 32)}},
   {{(VUINT32) ((0x339F49C845F8BBDFuLL) >> 0),
     (VUINT32) ((0x339F49C845F8BBDFuLL) >> 32)},
    {(VUINT32) ((0x9283B1FF897FFDE0uLL) >> 0),
     (VUINT32) ((0x9283B1FF897FFDE0uLL) >> 32)},
    {(VUINT32) ((0x5980FEF2F118B5A0uLL) >> 0),
     (VUINT32) ((0x5980FEF2F118B5A0uLL) >> 32)}},
   {{(VUINT32) ((0x673E93908BF177BFuLL) >> 0),
     (VUINT32) ((0x673E93908BF177BFuLL) >> 32)},
    {(VUINT32) ((0x250763FF12FFFBC0uLL) >> 0),
     (VUINT32) ((0x250763FF12FFFBC0uLL) >> 32)},
    {(VUINT32) ((0xB301FDE5E2316B41uLL) >> 0),
     (VUINT32) ((0xB301FDE5E2316B41uLL) >> 32)}},
   {{(VUINT32) ((0xCE7D272117E2EF7EuLL) >> 0),
     (VUINT32) ((0xCE7D272117E2EF7EuLL) >> 32)},
    {(VUINT32) ((0x4A0EC7FE25FFF781uLL) >> 0),
     (VUINT32) ((0x4A0EC7FE25FFF781uLL) >> 32)},
    {(VUINT32) ((0x6603FBCBC462D682uLL) >> 0),
     (VUINT32) ((0x6603FBCBC462D682uLL) >> 32)}},
   {{(VUINT32) ((0x9CFA4E422FC5DEFCuLL) >> 0),
     (VUINT32) ((0x9CFA4E422FC5DEFCuLL) >> 32)},
    {(VUINT32) ((0x941D8FFC4BFFEF02uLL) >> 0),
     (VUINT32) ((0x941D8FFC4BFFEF02uLL) >> 32)},
    {(VUINT32) ((0xCC07F79788C5AD05uLL) >> 0),
     (VUINT32) ((0xCC07F79788C5AD05uLL) >> 32)}},
   {{(VUINT32) ((0x39F49C845F8BBDF9uLL) >> 0),
     (VUINT32) ((0x39F49C845F8BBDF9uLL) >> 32)},
    {(VUINT32) ((0x283B1FF897FFDE05uLL) >> 0),
     (VUINT32) ((0x283B1FF897FFDE05uLL) >> 32)},
    {(VUINT32) ((0x980FEF2F118B5A0AuLL) >> 0),
     (VUINT32) ((0x980FEF2F118B5A0AuLL) >> 32)}},
   {{(VUINT32) ((0x73E93908BF177BF2uLL) >> 0),
     (VUINT32) ((0x73E93908BF177BF2uLL) >> 32)},
    {(VUINT32) ((0x50763FF12FFFBC0BuLL) >> 0),
     (VUINT32) ((0x50763FF12FFFBC0BuLL) >> 32)},
    {(VUINT32) ((0x301FDE5E2316B414uLL) >> 0),
     (VUINT32) ((0x301FDE5E2316B414uLL) >> 32)}},
   {{(VUINT32) ((0xE7D272117E2EF7E4uLL) >> 0),
     (VUINT32) ((0xE7D272117E2EF7E4uLL) >> 32)},
    {(VUINT32) ((0xA0EC7FE25FFF7816uLL) >> 0),
     (VUINT32) ((0xA0EC7FE25FFF7816uLL) >> 32)},
    {(VUINT32) ((0x603FBCBC462D6829uLL) >> 0),
     (VUINT32) ((0x603FBCBC462D6829uLL) >> 32)}},
   {{(VUINT32) ((0xCFA4E422FC5DEFC9uLL) >> 0),
     (VUINT32) ((0xCFA4E422FC5DEFC9uLL) >> 32)},
    {(VUINT32) ((0x41D8FFC4BFFEF02CuLL) >> 0),
     (VUINT32) ((0x41D8FFC4BFFEF02CuLL) >> 32)},
    {(VUINT32) ((0xC07F79788C5AD053uLL) >> 0),
     (VUINT32) ((0xC07F79788C5AD053uLL) >> 32)}},
   {{(VUINT32) ((0x9F49C845F8BBDF92uLL) >> 0),
     (VUINT32) ((0x9F49C845F8BBDF92uLL) >> 32)},
    {(VUINT32) ((0x83B1FF897FFDE059uLL) >> 0),
     (VUINT32) ((0x83B1FF897FFDE059uLL) >> 32)},
    {(VUINT32) ((0x80FEF2F118B5A0A6uLL) >> 0),
     (VUINT32) ((0x80FEF2F118B5A0A6uLL) >> 32)}},
   {{(VUINT32) ((0x3E93908BF177BF25uLL) >> 0),
     (VUINT32) ((0x3E93908BF177BF25uLL) >> 32)},
    {(VUINT32) ((0x0763FF12FFFBC0B3uLL) >> 0),
     (VUINT32) ((0x0763FF12FFFBC0B3uLL) >> 32)},
    {(VUINT32) ((0x01FDE5E2316B414DuLL) >> 0),
     (VUINT32) ((0x01FDE5E2316B414DuLL) >> 32)}},
   {{(VUINT32) ((0x7D272117E2EF7E4AuLL) >> 0),
     (VUINT32) ((0x7D272117E2EF7E4AuLL) >> 32)},
    {(VUINT32) ((0x0EC7FE25FFF78166uLL) >> 0),
     (VUINT32) ((0x0EC7FE25FFF78166uLL) >> 32)},
    {(VUINT32) ((0x03FBCBC462D6829BuLL) >> 0),
     (VUINT32) ((0x03FBCBC462D6829BuLL) >> 32)}},
   {{(VUINT32) ((0xFA4E422FC5DEFC94uLL) >> 0),
     (VUINT32) ((0xFA4E422FC5DEFC94uLL) >> 32)},
    {(VUINT32) ((0x1D8FFC4BFFEF02CCuLL) >> 0),
     (VUINT32) ((0x1D8FFC4BFFEF02CCuLL) >> 32)},
    {(VUINT32) ((0x07F79788C5AD0536uLL) >> 0),
     (VUINT32) ((0x07F79788C5AD0536uLL) >> 32)}},
   {{(VUINT32) ((0xF49C845F8BBDF928uLL) >> 0),
     (VUINT32) ((0xF49C845F8BBDF928uLL) >> 32)},
    {(VUINT32) ((0x3B1FF897FFDE0598uLL) >> 0),
     (VUINT32) ((0x3B1FF897FFDE0598uLL) >> 32)},
    {(VUINT32) ((0x0FEF2F118B5A0A6DuLL) >> 0),
     (VUINT32) ((0x0FEF2F118B5A0A6DuLL) >> 32)}},
   {{(VUINT32) ((0xE93908BF177BF250uLL) >> 0),
     (VUINT32) ((0xE93908BF177BF250uLL) >> 32)},
    {(VUINT32) ((0x763FF12FFFBC0B30uLL) >> 0),
     (VUINT32) ((0x763FF12FFFBC0B30uLL) >> 32)},
    {(VUINT32) ((0x1FDE5E2316B414DAuLL) >> 0),
     (VUINT32) ((0x1FDE5E2316B414DAuLL) >> 32)}},
   {{(VUINT32) ((0xD272117E2EF7E4A0uLL) >> 0),
     (VUINT32) ((0xD272117E2EF7E4A0uLL) >> 32)},
    {(VUINT32) ((0xEC7FE25FFF781660uLL) >> 0),
     (VUINT32) ((0xEC7FE25FFF781660uLL) >> 32)},
    {(VUINT32) ((0x3FBCBC462D6829B4uLL) >> 0),
     (VUINT32) ((0x3FBCBC462D6829B4uLL) >> 32)}},
   {{(VUINT32) ((0xA4E422FC5DEFC941uLL) >> 0),
     (VUINT32) ((0xA4E422FC5DEFC941uLL) >> 32)},
    {(VUINT32) ((0xD8FFC4BFFEF02CC0uLL) >> 0),
     (VUINT32) ((0xD8FFC4BFFEF02CC0uLL) >> 32)},
    {(VUINT32) ((0x7F79788C5AD05368uLL) >> 0),
     (VUINT32) ((0x7F79788C5AD05368uLL) >> 32)}},
   {{(VUINT32) ((0x49C845F8BBDF9283uLL) >> 0),
     (VUINT32) ((0x49C845F8BBDF9283uLL) >> 32)},
    {(VUINT32) ((0xB1FF897FFDE05980uLL) >> 0),
     (VUINT32) ((0xB1FF897FFDE05980uLL) >> 32)},
    {(VUINT32) ((0xFEF2F118B5A0A6D1uLL) >> 0),
     (VUINT32) ((0xFEF2F118B5A0A6D1uLL) >> 32)}},
   {{(VUINT32) ((0x93908BF177BF2507uLL) >> 0),
     (VUINT32) ((0x93908BF177BF2507uLL) >> 32)},
    {(VUINT32) ((0x63FF12FFFBC0B301uLL) >> 0),
     (VUINT32) ((0x63FF12FFFBC0B301uLL) >> 32)},
    {(VUINT32) ((0xFDE5E2316B414DA3uLL) >> 0),
     (VUINT32) ((0xFDE5E2316B414DA3uLL) >> 32)}},
   {{(VUINT32) ((0x272117E2EF7E4A0EuLL) >> 0),
     (VUINT32) ((0x272117E2EF7E4A0EuLL) >> 32)},
    {(VUINT32) ((0xC7FE25FFF7816603uLL) >> 0),
     (VUINT32) ((0xC7FE25FFF7816603uLL) >> 32)},
    {(VUINT32) ((0xFBCBC462D6829B47uLL) >> 0),
     (VUINT32) ((0xFBCBC462D6829B47uLL) >> 32)}},
   {{(VUINT32) ((0x4E422FC5DEFC941DuLL) >> 0),
     (VUINT32) ((0x4E422FC5DEFC941DuLL) >> 32)},
    {(VUINT32) ((0x8FFC4BFFEF02CC07uLL) >> 0),
     (VUINT32) ((0x8FFC4BFFEF02CC07uLL) >> 32)},
    {(VUINT32) ((0xF79788C5AD05368FuLL) >> 0),
     (VUINT32) ((0xF79788C5AD05368FuLL) >> 32)}},
   {{(VUINT32) ((0x9C845F8BBDF9283BuLL) >> 0),
     (VUINT32) ((0x9C845F8BBDF9283BuLL) >> 32)},
    {(VUINT32) ((0x1FF897FFDE05980FuLL) >> 0),
     (VUINT32) ((0x1FF897FFDE05980FuLL) >> 32)},
    {(VUINT32) ((0xEF2F118B5A0A6D1FuLL) >> 0),
     (VUINT32) ((0xEF2F118B5A0A6D1FuLL) >> 32)}},
   {{(VUINT32) ((0x3908BF177BF25076uLL) >> 0),
     (VUINT32) ((0x3908BF177BF25076uLL) >> 32)},
    {(VUINT32) ((0x3FF12FFFBC0B301FuLL) >> 0),
     (VUINT32) ((0x3FF12FFFBC0B301FuLL) >> 32)},
    {(VUINT32) ((0xDE5E2316B414DA3EuLL) >> 0),
     (VUINT32) ((0xDE5E2316B414DA3EuLL) >> 32)}},
   {{(VUINT32) ((0x72117E2EF7E4A0ECuLL) >> 0),
     (VUINT32) ((0x72117E2EF7E4A0ECuLL) >> 32)},
    {(VUINT32) ((0x7FE25FFF7816603FuLL) >> 0),
     (VUINT32) ((0x7FE25FFF7816603FuLL) >> 32)},
    {(VUINT32) ((0xBCBC462D6829B47DuLL) >> 0),
     (VUINT32) ((0xBCBC462D6829B47DuLL) >> 32)}},
   {{(VUINT32) ((0xE422FC5DEFC941D8uLL) >> 0),
     (VUINT32) ((0xE422FC5DEFC941D8uLL) >> 32)},
    {(VUINT32) ((0xFFC4BFFEF02CC07FuLL) >> 0),
     (VUINT32) ((0xFFC4BFFEF02CC07FuLL) >> 32)},
    {(VUINT32) ((0x79788C5AD05368FBuLL) >> 0),
     (VUINT32) ((0x79788C5AD05368FBuLL) >> 32)}},
   {{(VUINT32) ((0xC845F8BBDF9283B1uLL) >> 0),
     (VUINT32) ((0xC845F8BBDF9283B1uLL) >> 32)},
    {(VUINT32) ((0xFF897FFDE05980FEuLL) >> 0),
     (VUINT32) ((0xFF897FFDE05980FEuLL) >> 32)},
    {(VUINT32) ((0xF2F118B5A0A6D1F6uLL) >> 0),
     (VUINT32) ((0xF2F118B5A0A6D1F6uLL) >> 32)}},
   {{(VUINT32) ((0x908BF177BF250763uLL) >> 0),
     (VUINT32) ((0x908BF177BF250763uLL) >> 32)},
    {(VUINT32) ((0xFF12FFFBC0B301FDuLL) >> 0),
     (VUINT32) ((0xFF12FFFBC0B301FDuLL) >> 32)},
    {(VUINT32) ((0xE5E2316B414DA3EDuLL) >> 0),
     (VUINT32) ((0xE5E2316B414DA3EDuLL) >> 32)}},
   {{(VUINT32) ((0x2117E2EF7E4A0EC7uLL) >> 0),
     (VUINT32) ((0x2117E2EF7E4A0EC7uLL) >> 32)},
    {(VUINT32) ((0xFE25FFF7816603FBuLL) >> 0),
     (VUINT32) ((0xFE25FFF7816603FBuLL) >> 32)},
    {(VUINT32) ((0xCBC462D6829B47DBuLL) >> 0),
     (VUINT32) ((0xCBC462D6829B47DBuLL) >> 32)}},
   {{(VUINT32) ((0x422FC5DEFC941D8FuLL) >> 0),
     (VUINT32) ((0x422FC5DEFC941D8FuLL) >> 32)},
    {(VUINT32) ((0xFC4BFFEF02CC07F7uLL) >> 0),
     (VUINT32) ((0xFC4BFFEF02CC07F7uLL) >> 32)},
    {(VUINT32) ((0x9788C5AD05368FB6uLL) >> 0),
     (VUINT32) ((0x9788C5AD05368FB6uLL) >> 32)}},
   {{(VUINT32) ((0x845F8BBDF9283B1FuLL) >> 0),
     (VUINT32) ((0x845F8BBDF9283B1FuLL) >> 32)},
    {(VUINT32) ((0xF897FFDE05980FEFuLL) >> 0),
     (VUINT32) ((0xF897FFDE05980FEFuLL) >> 32)},
    {(VUINT32) ((0x2F118B5A0A6D1F6DuLL) >> 0),
     (VUINT32) ((0x2F118B5A0A6D1F6DuLL) >> 32)}},
   {{(VUINT32) ((0x08BF177BF250763FuLL) >> 0),
     (VUINT32) ((0x08BF177BF250763FuLL) >> 32)},
    {(VUINT32) ((0xF12FFFBC0B301FDEuLL) >> 0),
     (VUINT32) ((0xF12FFFBC0B301FDEuLL) >> 32)},
    {(VUINT32) ((0x5E2316B414DA3EDAuLL) >> 0),
     (VUINT32) ((0x5E2316B414DA3EDAuLL) >> 32)}},
   {{(VUINT32) ((0x117E2EF7E4A0EC7FuLL) >> 0),
     (VUINT32) ((0x117E2EF7E4A0EC7FuLL) >> 32)},
    {(VUINT32) ((0xE25FFF7816603FBCuLL) >> 0),
     (VUINT32) ((0xE25FFF7816603FBCuLL) >> 32)},
    {(VUINT32) ((0xBC462D6829B47DB4uLL) >> 0),
     (VUINT32) ((0xBC462D6829B47DB4uLL) >> 32)}},
   {{(VUINT32) ((0x22FC5DEFC941D8FFuLL) >> 0),
     (VUINT32) ((0x22FC5DEFC941D8FFuLL) >> 32)},
    {(VUINT32) ((0xC4BFFEF02CC07F79uLL) >> 0),
     (VUINT32) ((0xC4BFFEF02CC07F79uLL) >> 32)},
    {(VUINT32) ((0x788C5AD05368FB69uLL) >> 0),
     (VUINT32) ((0x788C5AD05368FB69uLL) >> 32)}},
   {{(VUINT32) ((0x45F8BBDF9283B1FFuLL) >> 0),
     (VUINT32) ((0x45F8BBDF9283B1FFuLL) >> 32)},
    {(VUINT32) ((0x897FFDE05980FEF2uLL) >> 0),
     (VUINT32) ((0x897FFDE05980FEF2uLL) >> 32)},
    {(VUINT32) ((0xF118B5A0A6D1F6D3uLL) >> 0),
     (VUINT32) ((0xF118B5A0A6D1F6D3uLL) >> 32)}},
   {{(VUINT32) ((0x8BF177BF250763FFuLL) >> 0),
     (VUINT32) ((0x8BF177BF250763FFuLL) >> 32)},
    {(VUINT32) ((0x12FFFBC0B301FDE5uLL) >> 0),
     (VUINT32) ((0x12FFFBC0B301FDE5uLL) >> 32)},
    {(VUINT32) ((0xE2316B414DA3EDA6uLL) >> 0),
     (VUINT32) ((0xE2316B414DA3EDA6uLL) >> 32)}},
   {{(VUINT32) ((0x17E2EF7E4A0EC7FEuLL) >> 0),
     (VUINT32) ((0x17E2EF7E4A0EC7FEuLL) >> 32)},
    {(VUINT32) ((0x25FFF7816603FBCBuLL) >> 0),
     (VUINT32) ((0x25FFF7816603FBCBuLL) >> 32)},
    {(VUINT32) ((0xC462D6829B47DB4DuLL) >> 0),
     (VUINT32) ((0xC462D6829B47DB4DuLL) >> 32)}},
   {{(VUINT32) ((0x2FC5DEFC941D8FFCuLL) >> 0),
     (VUINT32) ((0x2FC5DEFC941D8FFCuLL) >> 32)},
    {(VUINT32) ((0x4BFFEF02CC07F797uLL) >> 0),
     (VUINT32) ((0x4BFFEF02CC07F797uLL) >> 32)},
    {(VUINT32) ((0x88C5AD05368FB69BuLL) >> 0),
     (VUINT32) ((0x88C5AD05368FB69BuLL) >> 32)}},
   {{(VUINT32) ((0x5F8BBDF9283B1FF8uLL) >> 0),
     (VUINT32) ((0x5F8BBDF9283B1FF8uLL) >> 32)},
    {(VUINT32) ((0x97FFDE05980FEF2FuLL) >> 0),
     (VUINT32) ((0x97FFDE05980FEF2FuLL) >> 32)},
    {(VUINT32) ((0x118B5A0A6D1F6D36uLL) >> 0),
     (VUINT32) ((0x118B5A0A6D1F6D36uLL) >> 32)}},
   {{(VUINT32) ((0xBF177BF250763FF1uLL) >> 0),
     (VUINT32) ((0xBF177BF250763FF1uLL) >> 32)},
    {(VUINT32) ((0x2FFFBC0B301FDE5EuLL) >> 0),
     (VUINT32) ((0x2FFFBC0B301FDE5EuLL) >> 32)},
    {(VUINT32) ((0x2316B414DA3EDA6CuLL) >> 0),
     (VUINT32) ((0x2316B414DA3EDA6CuLL) >> 32)}},
   {{(VUINT32) ((0x7E2EF7E4A0EC7FE2uLL) >> 0),
     (VUINT32) ((0x7E2EF7E4A0EC7FE2uLL) >> 32)},
    {(VUINT32) ((0x5FFF7816603FBCBCuLL) >> 0),
     (VUINT32) ((0x5FFF7816603FBCBCuLL) >> 32)},
    {(VUINT32) ((0x462D6829B47DB4D9uLL) >> 0),
     (VUINT32) ((0x462D6829B47DB4D9uLL) >> 32)}},
   {{(VUINT32) ((0xFC5DEFC941D8FFC4uLL) >> 0),
     (VUINT32) ((0xFC5DEFC941D8FFC4uLL) >> 32)},
    {(VUINT32) ((0xBFFEF02CC07F7978uLL) >> 0),
     (VUINT32) ((0xBFFEF02CC07F7978uLL) >> 32)},
    {(VUINT32) ((0x8C5AD05368FB69B3uLL) >> 0),
     (VUINT32) ((0x8C5AD05368FB69B3uLL) >> 32)}},
   {{(VUINT32) ((0xF8BBDF9283B1FF89uLL) >> 0),
     (VUINT32) ((0xF8BBDF9283B1FF89uLL) >> 32)},
    {(VUINT32) ((0x7FFDE05980FEF2F1uLL) >> 0),
     (VUINT32) ((0x7FFDE05980FEF2F1uLL) >> 32)},
    {(VUINT32) ((0x18B5A0A6D1F6D367uLL) >> 0),
     (VUINT32) ((0x18B5A0A6D1F6D367uLL) >> 32)}},
   {{(VUINT32) ((0xF177BF250763FF12uLL) >> 0),
     (VUINT32) ((0xF177BF250763FF12uLL) >> 32)},
    {(VUINT32) ((0xFFFBC0B301FDE5E2uLL) >> 0),
     (VUINT32) ((0xFFFBC0B301FDE5E2uLL) >> 32)},
    {(VUINT32) ((0x316B414DA3EDA6CFuLL) >> 0),
     (VUINT32) ((0x316B414DA3EDA6CFuLL) >> 32)}},
   {{(VUINT32) ((0xE2EF7E4A0EC7FE25uLL) >> 0),
     (VUINT32) ((0xE2EF7E4A0EC7FE25uLL) >> 32)},
    {(VUINT32) ((0xFFF7816603FBCBC4uLL) >> 0),
     (VUINT32) ((0xFFF7816603FBCBC4uLL) >> 32)},
    {(VUINT32) ((0x62D6829B47DB4D9FuLL) >> 0),
     (VUINT32) ((0x62D6829B47DB4D9FuLL) >> 32)}},
   {{(VUINT32) ((0xC5DEFC941D8FFC4BuLL) >> 0),
     (VUINT32) ((0xC5DEFC941D8FFC4BuLL) >> 32)},
    {(VUINT32) ((0xFFEF02CC07F79788uLL) >> 0),
     (VUINT32) ((0xFFEF02CC07F79788uLL) >> 32)},
    {(VUINT32) ((0xC5AD05368FB69B3FuLL) >> 0),
     (VUINT32) ((0xC5AD05368FB69B3FuLL) >> 32)}},
   {{(VUINT32) ((0x8BBDF9283B1FF897uLL) >> 0),
     (VUINT32) ((0x8BBDF9283B1FF897uLL) >> 32)},
    {(VUINT32) ((0xFFDE05980FEF2F11uLL) >> 0),
     (VUINT32) ((0xFFDE05980FEF2F11uLL) >> 32)},
    {(VUINT32) ((0x8B5A0A6D1F6D367EuLL) >> 0),
     (VUINT32) ((0x8B5A0A6D1F6D367EuLL) >> 32)}},
   {{(VUINT32) ((0x177BF250763FF12FuLL) >> 0),
     (VUINT32) ((0x177BF250763FF12FuLL) >> 32)},
    {(VUINT32) ((0xFFBC0B301FDE5E23uLL) >> 0),
     (VUINT32) ((0xFFBC0B301FDE5E23uLL) >> 32)},
    {(VUINT32) ((0x16B414DA3EDA6CFDuLL) >> 0),
     (VUINT32) ((0x16B414DA3EDA6CFDuLL) >> 32)}},
   {{(VUINT32) ((0x2EF7E4A0EC7FE25FuLL) >> 0),
     (VUINT32) ((0x2EF7E4A0EC7FE25FuLL) >> 32)},
    {(VUINT32) ((0xFF7816603FBCBC46uLL) >> 0),
     (VUINT32) ((0xFF7816603FBCBC46uLL) >> 32)},
    {(VUINT32) ((0x2D6829B47DB4D9FBuLL) >> 0),
     (VUINT32) ((0x2D6829B47DB4D9FBuLL) >> 32)}},
   {{(VUINT32) ((0x5DEFC941D8FFC4BFuLL) >> 0),
     (VUINT32) ((0x5DEFC941D8FFC4BFuLL) >> 32)},
    {(VUINT32) ((0xFEF02CC07F79788CuLL) >> 0),
     (VUINT32) ((0xFEF02CC07F79788CuLL) >> 32)},
    {(VUINT32) ((0x5AD05368FB69B3F6uLL) >> 0),
     (VUINT32) ((0x5AD05368FB69B3F6uLL) >> 32)}},
   {{(VUINT32) ((0xBBDF9283B1FF897FuLL) >> 0),
     (VUINT32) ((0xBBDF9283B1FF897FuLL) >> 32)},
    {(VUINT32) ((0xFDE05980FEF2F118uLL) >> 0),
     (VUINT32) ((0xFDE05980FEF2F118uLL) >> 32)},
    {(VUINT32) ((0xB5A0A6D1F6D367ECuLL) >> 0),
     (VUINT32) ((0xB5A0A6D1F6D367ECuLL) >> 32)}},
   {{(VUINT32) ((0x77BF250763FF12FFuLL) >> 0),
     (VUINT32) ((0x77BF250763FF12FFuLL) >> 32)},
    {(VUINT32) ((0xFBC0B301FDE5E231uLL) >> 0),
     (VUINT32) ((0xFBC0B301FDE5E231uLL) >> 32)},
    {(VUINT32) ((0x6B414DA3EDA6CFD9uLL) >> 0),
     (VUINT32) ((0x6B414DA3EDA6CFD9uLL) >> 32)}},
   {{(VUINT32) ((0xEF7E4A0EC7FE25FFuLL) >> 0),
     (VUINT32) ((0xEF7E4A0EC7FE25FFuLL) >> 32)},
    {(VUINT32) ((0xF7816603FBCBC462uLL) >> 0),
     (VUINT32) ((0xF7816603FBCBC462uLL) >> 32)},
    {(VUINT32) ((0xD6829B47DB4D9FB3uLL) >> 0),
     (VUINT32) ((0xD6829B47DB4D9FB3uLL) >> 32)}},
   {{(VUINT32) ((0xDEFC941D8FFC4BFFuLL) >> 0),
     (VUINT32) ((0xDEFC941D8FFC4BFFuLL) >> 32)},
    {(VUINT32) ((0xEF02CC07F79788C5uLL) >> 0),
     (VUINT32) ((0xEF02CC07F79788C5uLL) >> 32)},
    {(VUINT32) ((0xAD05368FB69B3F67uLL) >> 0),
     (VUINT32) ((0xAD05368FB69B3F67uLL) >> 32)}},
   {{(VUINT32) ((0xBDF9283B1FF897FFuLL) >> 0),
     (VUINT32) ((0xBDF9283B1FF897FFuLL) >> 32)},
    {(VUINT32) ((0xDE05980FEF2F118BuLL) >> 0),
     (VUINT32) ((0xDE05980FEF2F118BuLL) >> 32)},
    {(VUINT32) ((0x5A0A6D1F6D367ECFuLL) >> 0),
     (VUINT32) ((0x5A0A6D1F6D367ECFuLL) >> 32)}},
   {{(VUINT32) ((0x7BF250763FF12FFFuLL) >> 0),
     (VUINT32) ((0x7BF250763FF12FFFuLL) >> 32)},
    {(VUINT32) ((0xBC0B301FDE5E2316uLL) >> 0),
     (VUINT32) ((0xBC0B301FDE5E2316uLL) >> 32)},
    {(VUINT32) ((0xB414DA3EDA6CFD9EuLL) >> 0),
     (VUINT32) ((0xB414DA3EDA6CFD9EuLL) >> 32)}},
   {{(VUINT32) ((0xF7E4A0EC7FE25FFFuLL) >> 0),
     (VUINT32) ((0xF7E4A0EC7FE25FFFuLL) >> 32)},
    {(VUINT32) ((0x7816603FBCBC462DuLL) >> 0),
     (VUINT32) ((0x7816603FBCBC462DuLL) >> 32)},
    {(VUINT32) ((0x6829B47DB4D9FB3CuLL) >> 0),
     (VUINT32) ((0x6829B47DB4D9FB3CuLL) >> 32)}},
   {{(VUINT32) ((0xEFC941D8FFC4BFFEuLL) >> 0),
     (VUINT32) ((0xEFC941D8FFC4BFFEuLL) >> 32)},
    {(VUINT32) ((0xF02CC07F79788C5AuLL) >> 0),
     (VUINT32) ((0xF02CC07F79788C5AuLL) >> 32)},
    {(VUINT32) ((0xD05368FB69B3F679uLL) >> 0),
     (VUINT32) ((0xD05368FB69B3F679uLL) >> 32)}},
   {{(VUINT32) ((0xDF9283B1FF897FFDuLL) >> 0),
     (VUINT32) ((0xDF9283B1FF897FFDuLL) >> 32)},
    {(VUINT32) ((0xE05980FEF2F118B5uLL) >> 0),
     (VUINT32) ((0xE05980FEF2F118B5uLL) >> 32)},
    {(VUINT32) ((0xA0A6D1F6D367ECF2uLL) >> 0),
     (VUINT32) ((0xA0A6D1F6D367ECF2uLL) >> 32)}},
   {{(VUINT32) ((0xBF250763FF12FFFBuLL) >> 0),
     (VUINT32) ((0xBF250763FF12FFFBuLL) >> 32)},
    {(VUINT32) ((0xC0B301FDE5E2316BuLL) >> 0),
     (VUINT32) ((0xC0B301FDE5E2316BuLL) >> 32)},
    {(VUINT32) ((0x414DA3EDA6CFD9E4uLL) >> 0),
     (VUINT32) ((0x414DA3EDA6CFD9E4uLL) >> 32)}},
   {{(VUINT32) ((0x7E4A0EC7FE25FFF7uLL) >> 0),
     (VUINT32) ((0x7E4A0EC7FE25FFF7uLL) >> 32)},
    {(VUINT32) ((0x816603FBCBC462D6uLL) >> 0),
     (VUINT32) ((0x816603FBCBC462D6uLL) >> 32)},
    {(VUINT32) ((0x829B47DB4D9FB3C9uLL) >> 0),
     (VUINT32) ((0x829B47DB4D9FB3C9uLL) >> 32)}},
   {{(VUINT32) ((0xFC941D8FFC4BFFEFuLL) >> 0),
     (VUINT32) ((0xFC941D8FFC4BFFEFuLL) >> 32)},
    {(VUINT32) ((0x02CC07F79788C5ADuLL) >> 0),
     (VUINT32) ((0x02CC07F79788C5ADuLL) >> 32)},
    {(VUINT32) ((0x05368FB69B3F6793uLL) >> 0),
     (VUINT32) ((0x05368FB69B3F6793uLL) >> 32)}},
   {{(VUINT32) ((0xF9283B1FF897FFDEuLL) >> 0),
     (VUINT32) ((0xF9283B1FF897FFDEuLL) >> 32)},
    {(VUINT32) ((0x05980FEF2F118B5AuLL) >> 0),
     (VUINT32) ((0x05980FEF2F118B5AuLL) >> 32)},
    {(VUINT32) ((0x0A6D1F6D367ECF27uLL) >> 0),
     (VUINT32) ((0x0A6D1F6D367ECF27uLL) >> 32)}},
   {{(VUINT32) ((0xF250763FF12FFFBCuLL) >> 0),
     (VUINT32) ((0xF250763FF12FFFBCuLL) >> 32)},
    {(VUINT32) ((0x0B301FDE5E2316B4uLL) >> 0),
     (VUINT32) ((0x0B301FDE5E2316B4uLL) >> 32)},
    {(VUINT32) ((0x14DA3EDA6CFD9E4FuLL) >> 0),
     (VUINT32) ((0x14DA3EDA6CFD9E4FuLL) >> 32)}},
   {{(VUINT32) ((0xE4A0EC7FE25FFF78uLL) >> 0),
     (VUINT32) ((0xE4A0EC7FE25FFF78uLL) >> 32)},
    {(VUINT32) ((0x16603FBCBC462D68uLL) >> 0),
     (VUINT32) ((0x16603FBCBC462D68uLL) >> 32)},
    {(VUINT32) ((0x29B47DB4D9FB3C9FuLL) >> 0),
     (VUINT32) ((0x29B47DB4D9FB3C9FuLL) >> 32)}},
   {{(VUINT32) ((0xC941D8FFC4BFFEF0uLL) >> 0),
     (VUINT32) ((0xC941D8FFC4BFFEF0uLL) >> 32)},
    {(VUINT32) ((0x2CC07F79788C5AD0uLL) >> 0),
     (VUINT32) ((0x2CC07F79788C5AD0uLL) >> 32)},
    {(VUINT32) ((0x5368FB69B3F6793EuLL) >> 0),
     (VUINT32) ((0x5368FB69B3F6793EuLL) >> 32)}},
   {{(VUINT32) ((0x9283B1FF897FFDE0uLL) >> 0),
     (VUINT32) ((0x9283B1FF897FFDE0uLL) >> 32)},
    {(VUINT32) ((0x5980FEF2F118B5A0uLL) >> 0),
     (VUINT32) ((0x5980FEF2F118B5A0uLL) >> 32)},
    {(VUINT32) ((0xA6D1F6D367ECF27CuLL) >> 0),
     (VUINT32) ((0xA6D1F6D367ECF27CuLL) >> 32)}},
   {{(VUINT32) ((0x250763FF12FFFBC0uLL) >> 0),
     (VUINT32) ((0x250763FF12FFFBC0uLL) >> 32)},
    {(VUINT32) ((0xB301FDE5E2316B41uLL) >> 0),
     (VUINT32) ((0xB301FDE5E2316B41uLL) >> 32)},
    {(VUINT32) ((0x4DA3EDA6CFD9E4F9uLL) >> 0),
     (VUINT32) ((0x4DA3EDA6CFD9E4F9uLL) >> 32)}},
   {{(VUINT32) ((0x4A0EC7FE25FFF781uLL) >> 0),
     (VUINT32) ((0x4A0EC7FE25FFF781uLL) >> 32)},
    {(VUINT32) ((0x6603FBCBC462D682uLL) >> 0),
     (VUINT32) ((0x6603FBCBC462D682uLL) >> 32)},
    {(VUINT32) ((0x9B47DB4D9FB3C9F2uLL) >> 0),
     (VUINT32) ((0x9B47DB4D9FB3C9F2uLL) >> 32)}},
   {{(VUINT32) ((0x941D8FFC4BFFEF02uLL) >> 0),
     (VUINT32) ((0x941D8FFC4BFFEF02uLL) >> 32)},
    {(VUINT32) ((0xCC07F79788C5AD05uLL) >> 0),
     (VUINT32) ((0xCC07F79788C5AD05uLL) >> 32)},
    {(VUINT32) ((0x368FB69B3F6793E5uLL) >> 0),
     (VUINT32) ((0x368FB69B3F6793E5uLL) >> 32)}},
   {{(VUINT32) ((0x283B1FF897FFDE05uLL) >> 0),
     (VUINT32) ((0x283B1FF897FFDE05uLL) >> 32)},
    {(VUINT32) ((0x980FEF2F118B5A0AuLL) >> 0),
     (VUINT32) ((0x980FEF2F118B5A0AuLL) >> 32)},
    {(VUINT32) ((0x6D1F6D367ECF27CBuLL) >> 0),
     (VUINT32) ((0x6D1F6D367ECF27CBuLL) >> 32)}},
   {{(VUINT32) ((0x50763FF12FFFBC0BuLL) >> 0),
     (VUINT32) ((0x50763FF12FFFBC0BuLL) >> 32)},
    {(VUINT32) ((0x301FDE5E2316B414uLL) >> 0),
     (VUINT32) ((0x301FDE5E2316B414uLL) >> 32)},
    {(VUINT32) ((0xDA3EDA6CFD9E4F96uLL) >> 0),
     (VUINT32) ((0xDA3EDA6CFD9E4F96uLL) >> 32)}},
   {{(VUINT32) ((0xA0EC7FE25FFF7816uLL) >> 0),
     (VUINT32) ((0xA0EC7FE25FFF7816uLL) >> 32)},
    {(VUINT32) ((0x603FBCBC462D6829uLL) >> 0),
     (VUINT32) ((0x603FBCBC462D6829uLL) >> 32)},
    {(VUINT32) ((0xB47DB4D9FB3C9F2CuLL) >> 0),
     (VUINT32) ((0xB47DB4D9FB3C9F2CuLL) >> 32)}},
   {{(VUINT32) ((0x41D8FFC4BFFEF02CuLL) >> 0),
     (VUINT32) ((0x41D8FFC4BFFEF02CuLL) >> 32)},
    {(VUINT32) ((0xC07F79788C5AD053uLL) >> 0),
     (VUINT32) ((0xC07F79788C5AD053uLL) >> 32)},
    {(VUINT32) ((0x68FB69B3F6793E58uLL) >> 0),
     (VUINT32) ((0x68FB69B3F6793E58uLL) >> 32)}},
   {{(VUINT32) ((0x83B1FF897FFDE059uLL) >> 0),
     (VUINT32) ((0x83B1FF897FFDE059uLL) >> 32)},
    {(VUINT32) ((0x80FEF2F118B5A0A6uLL) >> 0),
     (VUINT32) ((0x80FEF2F118B5A0A6uLL) >> 32)},
    {(VUINT32) ((0xD1F6D367ECF27CB0uLL) >> 0),
     (VUINT32) ((0xD1F6D367ECF27CB0uLL) >> 32)}},
   {{(VUINT32) ((0x0763FF12FFFBC0B3uLL) >> 0),
     (VUINT32) ((0x0763FF12FFFBC0B3uLL) >> 32)},
    {(VUINT32) ((0x01FDE5E2316B414DuLL) >> 0),
     (VUINT32) ((0x01FDE5E2316B414DuLL) >> 32)},
    {(VUINT32) ((0xA3EDA6CFD9E4F961uLL) >> 0),
     (VUINT32) ((0xA3EDA6CFD9E4F961uLL) >> 32)}},
   {{(VUINT32) ((0x0EC7FE25FFF78166uLL) >> 0),
     (VUINT32) ((0x0EC7FE25FFF78166uLL) >> 32)},
    {(VUINT32) ((0x03FBCBC462D6829BuLL) >> 0),
     (VUINT32) ((0x03FBCBC462D6829BuLL) >> 32)},
    {(VUINT32) ((0x47DB4D9FB3C9F2C2uLL) >> 0),
     (VUINT32) ((0x47DB4D9FB3C9F2C2uLL) >> 32)}},
   {{(VUINT32) ((0x1D8FFC4BFFEF02CCuLL) >> 0),
     (VUINT32) ((0x1D8FFC4BFFEF02CCuLL) >> 32)},
    {(VUINT32) ((0x07F79788C5AD0536uLL) >> 0),
     (VUINT32) ((0x07F79788C5AD0536uLL) >> 32)},
    {(VUINT32) ((0x8FB69B3F6793E584uLL) >> 0),
     (VUINT32) ((0x8FB69B3F6793E584uLL) >> 32)}},
   {{(VUINT32) ((0x3B1FF897FFDE0598uLL) >> 0),
     (VUINT32) ((0x3B1FF897FFDE0598uLL) >> 32)},
    {(VUINT32) ((0x0FEF2F118B5A0A6DuLL) >> 0),
     (VUINT32) ((0x0FEF2F118B5A0A6DuLL) >> 32)},
    {(VUINT32) ((0x1F6D367ECF27CB09uLL) >> 0),
     (VUINT32) ((0x1F6D367ECF27CB09uLL) >> 32)}},
   {{(VUINT32) ((0x763FF12FFFBC0B30uLL) >> 0),
     (VUINT32) ((0x763FF12FFFBC0B30uLL) >> 32)},
    {(VUINT32) ((0x1FDE5E2316B414DAuLL) >> 0),
     (VUINT32) ((0x1FDE5E2316B414DAuLL) >> 32)},
    {(VUINT32) ((0x3EDA6CFD9E4F9613uLL) >> 0),
     (VUINT32) ((0x3EDA6CFD9E4F9613uLL) >> 32)}},
   {{(VUINT32) ((0xEC7FE25FFF781660uLL) >> 0),
     (VUINT32) ((0xEC7FE25FFF781660uLL) >> 32)},
    {(VUINT32) ((0x3FBCBC462D6829B4uLL) >> 0),
     (VUINT32) ((0x3FBCBC462D6829B4uLL) >> 32)},
    {(VUINT32) ((0x7DB4D9FB3C9F2C26uLL) >> 0),
     (VUINT32) ((0x7DB4D9FB3C9F2C26uLL) >> 32)}},
   {{(VUINT32) ((0xD8FFC4BFFEF02CC0uLL) >> 0),
     (VUINT32) ((0xD8FFC4BFFEF02CC0uLL) >> 32)},
    {(VUINT32) ((0x7F79788C5AD05368uLL) >> 0),
     (VUINT32) ((0x7F79788C5AD05368uLL) >> 32)},
    {(VUINT32) ((0xFB69B3F6793E584DuLL) >> 0),
     (VUINT32) ((0xFB69B3F6793E584DuLL) >> 32)}},
   {{(VUINT32) ((0xB1FF897FFDE05980uLL) >> 0),
     (VUINT32) ((0xB1FF897FFDE05980uLL) >> 32)},
    {(VUINT32) ((0xFEF2F118B5A0A6D1uLL) >> 0),
     (VUINT32) ((0xFEF2F118B5A0A6D1uLL) >> 32)},
    {(VUINT32) ((0xF6D367ECF27CB09BuLL) >> 0),
     (VUINT32) ((0xF6D367ECF27CB09BuLL) >> 32)}},
   {{(VUINT32) ((0x63FF12FFFBC0B301uLL) >> 0),
     (VUINT32) ((0x63FF12FFFBC0B301uLL) >> 32)},
    {(VUINT32) ((0xFDE5E2316B414DA3uLL) >> 0),
     (VUINT32) ((0xFDE5E2316B414DA3uLL) >> 32)},
    {(VUINT32) ((0xEDA6CFD9E4F96136uLL) >> 0),
     (VUINT32) ((0xEDA6CFD9E4F96136uLL) >> 32)}},
   {{(VUINT32) ((0xC7FE25FFF7816603uLL) >> 0),
     (VUINT32) ((0xC7FE25FFF7816603uLL) >> 32)},
    {(VUINT32) ((0xFBCBC462D6829B47uLL) >> 0),
     (VUINT32) ((0xFBCBC462D6829B47uLL) >> 32)},
    {(VUINT32) ((0xDB4D9FB3C9F2C26DuLL) >> 0),
     (VUINT32) ((0xDB4D9FB3C9F2C26DuLL) >> 32)}},
   {{(VUINT32) ((0x8FFC4BFFEF02CC07uLL) >> 0),
     (VUINT32) ((0x8FFC4BFFEF02CC07uLL) >> 32)},
    {(VUINT32) ((0xF79788C5AD05368FuLL) >> 0),
     (VUINT32) ((0xF79788C5AD05368FuLL) >> 32)},
    {(VUINT32) ((0xB69B3F6793E584DBuLL) >> 0),
     (VUINT32) ((0xB69B3F6793E584DBuLL) >> 32)}},
   {{(VUINT32) ((0x1FF897FFDE05980FuLL) >> 0),
     (VUINT32) ((0x1FF897FFDE05980FuLL) >> 32)},
    {(VUINT32) ((0xEF2F118B5A0A6D1FuLL) >> 0),
     (VUINT32) ((0xEF2F118B5A0A6D1FuLL) >> 32)},
    {(VUINT32) ((0x6D367ECF27CB09B7uLL) >> 0),
     (VUINT32) ((0x6D367ECF27CB09B7uLL) >> 32)}},
   {{(VUINT32) ((0x3FF12FFFBC0B301FuLL) >> 0),
     (VUINT32) ((0x3FF12FFFBC0B301FuLL) >> 32)},
    {(VUINT32) ((0xDE5E2316B414DA3EuLL) >> 0),
     (VUINT32) ((0xDE5E2316B414DA3EuLL) >> 32)},
    {(VUINT32) ((0xDA6CFD9E4F96136EuLL) >> 0),
     (VUINT32) ((0xDA6CFD9E4F96136EuLL) >> 32)}},
   {{(VUINT32) ((0x7FE25FFF7816603FuLL) >> 0),
     (VUINT32) ((0x7FE25FFF7816603FuLL) >> 32)},
    {(VUINT32) ((0xBCBC462D6829B47DuLL) >> 0),
     (VUINT32) ((0xBCBC462D6829B47DuLL) >> 32)},
    {(VUINT32) ((0xB4D9FB3C9F2C26DDuLL) >> 0),
     (VUINT32) ((0xB4D9FB3C9F2C26DDuLL) >> 32)}},
   {{(VUINT32) ((0xFFC4BFFEF02CC07FuLL) >> 0),
     (VUINT32) ((0xFFC4BFFEF02CC07FuLL) >> 32)},
    {(VUINT32) ((0x79788C5AD05368FBuLL) >> 0),
     (VUINT32) ((0x79788C5AD05368FBuLL) >> 32)},
    {(VUINT32) ((0x69B3F6793E584DBAuLL) >> 0),
     (VUINT32) ((0x69B3F6793E584DBAuLL) >> 32)}},
   {{(VUINT32) ((0xFF897FFDE05980FEuLL) >> 0),
     (VUINT32) ((0xFF897FFDE05980FEuLL) >> 32)},
    {(VUINT32) ((0xF2F118B5A0A6D1F6uLL) >> 0),
     (VUINT32) ((0xF2F118B5A0A6D1F6uLL) >> 32)},
    {(VUINT32) ((0xD367ECF27CB09B74uLL) >> 0),
     (VUINT32) ((0xD367ECF27CB09B74uLL) >> 32)}},
   {{(VUINT32) ((0xFF12FFFBC0B301FDuLL) >> 0),
     (VUINT32) ((0xFF12FFFBC0B301FDuLL) >> 32)},
    {(VUINT32) ((0xE5E2316B414DA3EDuLL) >> 0),
     (VUINT32) ((0xE5E2316B414DA3EDuLL) >> 32)},
    {(VUINT32) ((0xA6CFD9E4F96136E9uLL) >> 0),
     (VUINT32) ((0xA6CFD9E4F96136E9uLL) >> 32)}},
   {{(VUINT32) ((0xFE25FFF7816603FBuLL) >> 0),
     (VUINT32) ((0xFE25FFF7816603FBuLL) >> 32)},
    {(VUINT32) ((0xCBC462D6829B47DBuLL) >> 0),
     (VUINT32) ((0xCBC462D6829B47DBuLL) >> 32)},
    {(VUINT32) ((0x4D9FB3C9F2C26DD3uLL) >> 0),
     (VUINT32) ((0x4D9FB3C9F2C26DD3uLL) >> 32)}},
   {{(VUINT32) ((0xFC4BFFEF02CC07F7uLL) >> 0),
     (VUINT32) ((0xFC4BFFEF02CC07F7uLL) >> 32)},
    {(VUINT32) ((0x9788C5AD05368FB6uLL) >> 0),
     (VUINT32) ((0x9788C5AD05368FB6uLL) >> 32)},
    {(VUINT32) ((0x9B3F6793E584DBA7uLL) >> 0),
     (VUINT32) ((0x9B3F6793E584DBA7uLL) >> 32)}},
   {{(VUINT32) ((0xF897FFDE05980FEFuLL) >> 0),
     (VUINT32) ((0xF897FFDE05980FEFuLL) >> 32)},
    {(VUINT32) ((0x2F118B5A0A6D1F6DuLL) >> 0),
     (VUINT32) ((0x2F118B5A0A6D1F6DuLL) >> 32)},
    {(VUINT32) ((0x367ECF27CB09B74FuLL) >> 0),
     (VUINT32) ((0x367ECF27CB09B74FuLL) >> 32)}},
   {{(VUINT32) ((0xF12FFFBC0B301FDEuLL) >> 0),
     (VUINT32) ((0xF12FFFBC0B301FDEuLL) >> 32)},
    {(VUINT32) ((0x5E2316B414DA3EDAuLL) >> 0),
     (VUINT32) ((0x5E2316B414DA3EDAuLL) >> 32)},
    {(VUINT32) ((0x6CFD9E4F96136E9EuLL) >> 0),
     (VUINT32) ((0x6CFD9E4F96136E9EuLL) >> 32)}},
   {{(VUINT32) ((0xE25FFF7816603FBCuLL) >> 0),
     (VUINT32) ((0xE25FFF7816603FBCuLL) >> 32)},
    {(VUINT32) ((0xBC462D6829B47DB4uLL) >> 0),
     (VUINT32) ((0xBC462D6829B47DB4uLL) >> 32)},
    {(VUINT32) ((0xD9FB3C9F2C26DD3DuLL) >> 0),
     (VUINT32) ((0xD9FB3C9F2C26DD3DuLL) >> 32)}},
   {{(VUINT32) ((0xC4BFFEF02CC07F79uLL) >> 0),
     (VUINT32) ((0xC4BFFEF02CC07F79uLL) >> 32)},
    {(VUINT32) ((0x788C5AD05368FB69uLL) >> 0),
     (VUINT32) ((0x788C5AD05368FB69uLL) >> 32)},
    {(VUINT32) ((0xB3F6793E584DBA7AuLL) >> 0),
     (VUINT32) ((0xB3F6793E584DBA7AuLL) >> 32)}},
   {{(VUINT32) ((0x897FFDE05980FEF2uLL) >> 0),
     (VUINT32) ((0x897FFDE05980FEF2uLL) >> 32)},
    {(VUINT32) ((0xF118B5A0A6D1F6D3uLL) >> 0),
     (VUINT32) ((0xF118B5A0A6D1F6D3uLL) >> 32)},
    {(VUINT32) ((0x67ECF27CB09B74F4uLL) >> 0),
     (VUINT32) ((0x67ECF27CB09B74F4uLL) >> 32)}},
   {{(VUINT32) ((0x12FFFBC0B301FDE5uLL) >> 0),
     (VUINT32) ((0x12FFFBC0B301FDE5uLL) >> 32)},
    {(VUINT32) ((0xE2316B414DA3EDA6uLL) >> 0),
     (VUINT32) ((0xE2316B414DA3EDA6uLL) >> 32)},
    {(VUINT32) ((0xCFD9E4F96136E9E8uLL) >> 0),
     (VUINT32) ((0xCFD9E4F96136E9E8uLL) >> 32)}},
   {{(VUINT32) ((0x25FFF7816603FBCBuLL) >> 0),
     (VUINT32) ((0x25FFF7816603FBCBuLL) >> 32)},
    {(VUINT32) ((0xC462D6829B47DB4DuLL) >> 0),
     (VUINT32) ((0xC462D6829B47DB4DuLL) >> 32)},
    {(VUINT32) ((0x9FB3C9F2C26DD3D1uLL) >> 0),
     (VUINT32) ((0x9FB3C9F2C26DD3D1uLL) >> 32)}},
   {{(VUINT32) ((0x4BFFEF02CC07F797uLL) >> 0),
     (VUINT32) ((0x4BFFEF02CC07F797uLL) >> 32)},
    {(VUINT32) ((0x88C5AD05368FB69BuLL) >> 0),
     (VUINT32) ((0x88C5AD05368FB69BuLL) >> 32)},
    {(VUINT32) ((0x3F6793E584DBA7A3uLL) >> 0),
     (VUINT32) ((0x3F6793E584DBA7A3uLL) >> 32)}},
   {{(VUINT32) ((0x97FFDE05980FEF2FuLL) >> 0),
     (VUINT32) ((0x97FFDE05980FEF2FuLL) >> 32)},
    {(VUINT32) ((0x118B5A0A6D1F6D36uLL) >> 0),
     (VUINT32) ((0x118B5A0A6D1F6D36uLL) >> 32)},
    {(VUINT32) ((0x7ECF27CB09B74F46uLL) >> 0),
     (VUINT32) ((0x7ECF27CB09B74F46uLL) >> 32)}},
   {{(VUINT32) ((0x2FFFBC0B301FDE5EuLL) >> 0),
     (VUINT32) ((0x2FFFBC0B301FDE5EuLL) >> 32)},
    {(VUINT32) ((0x2316B414DA3EDA6CuLL) >> 0),
     (VUINT32) ((0x2316B414DA3EDA6CuLL) >> 32)},
    {(VUINT32) ((0xFD9E4F96136E9E8CuLL) >> 0),
     (VUINT32) ((0xFD9E4F96136E9E8CuLL) >> 32)}},
   {{(VUINT32) ((0x5FFF7816603FBCBCuLL) >> 0),
     (VUINT32) ((0x5FFF7816603FBCBCuLL) >> 32)},
    {(VUINT32) ((0x462D6829B47DB4D9uLL) >> 0),
     (VUINT32) ((0x462D6829B47DB4D9uLL) >> 32)},
    {(VUINT32) ((0xFB3C9F2C26DD3D18uLL) >> 0),
     (VUINT32) ((0xFB3C9F2C26DD3D18uLL) >> 32)}},
   {{(VUINT32) ((0xBFFEF02CC07F7978uLL) >> 0),
     (VUINT32) ((0xBFFEF02CC07F7978uLL) >> 32)},
    {(VUINT32) ((0x8C5AD05368FB69B3uLL) >> 0),
     (VUINT32) ((0x8C5AD05368FB69B3uLL) >> 32)},
    {(VUINT32) ((0xF6793E584DBA7A31uLL) >> 0),
     (VUINT32) ((0xF6793E584DBA7A31uLL) >> 32)}},
   {{(VUINT32) ((0x7FFDE05980FEF2F1uLL) >> 0),
     (VUINT32) ((0x7FFDE05980FEF2F1uLL) >> 32)},
    {(VUINT32) ((0x18B5A0A6D1F6D367uLL) >> 0),
     (VUINT32) ((0x18B5A0A6D1F6D367uLL) >> 32)},
    {(VUINT32) ((0xECF27CB09B74F463uLL) >> 0),
     (VUINT32) ((0xECF27CB09B74F463uLL) >> 32)}},
   {{(VUINT32) ((0xFFFBC0B301FDE5E2uLL) >> 0),
     (VUINT32) ((0xFFFBC0B301FDE5E2uLL) >> 32)},
    {(VUINT32) ((0x316B414DA3EDA6CFuLL) >> 0),
     (VUINT32) ((0x316B414DA3EDA6CFuLL) >> 32)},
    {(VUINT32) ((0xD9E4F96136E9E8C7uLL) >> 0),
     (VUINT32) ((0xD9E4F96136E9E8C7uLL) >> 32)}},
   {{(VUINT32) ((0xFFF7816603FBCBC4uLL) >> 0),
     (VUINT32) ((0xFFF7816603FBCBC4uLL) >> 32)},
    {(VUINT32) ((0x62D6829B47DB4D9FuLL) >> 0),
     (VUINT32) ((0x62D6829B47DB4D9FuLL) >> 32)},
    {(VUINT32) ((0xB3C9F2C26DD3D18FuLL) >> 0),
     (VUINT32) ((0xB3C9F2C26DD3D18FuLL) >> 32)}},
   {{(VUINT32) ((0xFFEF02CC07F79788uLL) >> 0),
     (VUINT32) ((0xFFEF02CC07F79788uLL) >> 32)},
    {(VUINT32) ((0xC5AD05368FB69B3FuLL) >> 0),
     (VUINT32) ((0xC5AD05368FB69B3FuLL) >> 32)},
    {(VUINT32) ((0x6793E584DBA7A31FuLL) >> 0),
     (VUINT32) ((0x6793E584DBA7A31FuLL) >> 32)}},
   {{(VUINT32) ((0xFFDE05980FEF2F11uLL) >> 0),
     (VUINT32) ((0xFFDE05980FEF2F11uLL) >> 32)},
    {(VUINT32) ((0x8B5A0A6D1F6D367EuLL) >> 0),
     (VUINT32) ((0x8B5A0A6D1F6D367EuLL) >> 32)},
    {(VUINT32) ((0xCF27CB09B74F463FuLL) >> 0),
     (VUINT32) ((0xCF27CB09B74F463FuLL) >> 32)}},
   {{(VUINT32) ((0xFFBC0B301FDE5E23uLL) >> 0),
     (VUINT32) ((0xFFBC0B301FDE5E23uLL) >> 32)},
    {(VUINT32) ((0x16B414DA3EDA6CFDuLL) >> 0),
     (VUINT32) ((0x16B414DA3EDA6CFDuLL) >> 32)},
    {(VUINT32) ((0x9E4F96136E9E8C7EuLL) >> 0),
     (VUINT32) ((0x9E4F96136E9E8C7EuLL) >> 32)}},
   {{(VUINT32) ((0xFF7816603FBCBC46uLL) >> 0),
     (VUINT32) ((0xFF7816603FBCBC46uLL) >> 32)},
    {(VUINT32) ((0x2D6829B47DB4D9FBuLL) >> 0),
     (VUINT32) ((0x2D6829B47DB4D9FBuLL) >> 32)},
    {(VUINT32) ((0x3C9F2C26DD3D18FDuLL) >> 0),
     (VUINT32) ((0x3C9F2C26DD3D18FDuLL) >> 32)}},
   {{(VUINT32) ((0xFEF02CC07F79788CuLL) >> 0),
     (VUINT32) ((0xFEF02CC07F79788CuLL) >> 32)},
    {(VUINT32) ((0x5AD05368FB69B3F6uLL) >> 0),
     (VUINT32) ((0x5AD05368FB69B3F6uLL) >> 32)},
    {(VUINT32) ((0x793E584DBA7A31FBuLL) >> 0),
     (VUINT32) ((0x793E584DBA7A31FBuLL) >> 32)}},
   {{(VUINT32) ((0xFDE05980FEF2F118uLL) >> 0),
     (VUINT32) ((0xFDE05980FEF2F118uLL) >> 32)},
    {(VUINT32) ((0xB5A0A6D1F6D367ECuLL) >> 0),
     (VUINT32) ((0xB5A0A6D1F6D367ECuLL) >> 32)},
    {(VUINT32) ((0xF27CB09B74F463F6uLL) >> 0),
     (VUINT32) ((0xF27CB09B74F463F6uLL) >> 32)}},
   {{(VUINT32) ((0xFBC0B301FDE5E231uLL) >> 0),
     (VUINT32) ((0xFBC0B301FDE5E231uLL) >> 32)},
    {(VUINT32) ((0x6B414DA3EDA6CFD9uLL) >> 0),
     (VUINT32) ((0x6B414DA3EDA6CFD9uLL) >> 32)},
    {(VUINT32) ((0xE4F96136E9E8C7ECuLL) >> 0),
     (VUINT32) ((0xE4F96136E9E8C7ECuLL) >> 32)}},
   {{(VUINT32) ((0xF7816603FBCBC462uLL) >> 0),
     (VUINT32) ((0xF7816603FBCBC462uLL) >> 32)},
    {(VUINT32) ((0xD6829B47DB4D9FB3uLL) >> 0),
     (VUINT32) ((0xD6829B47DB4D9FB3uLL) >> 32)},
    {(VUINT32) ((0xC9F2C26DD3D18FD9uLL) >> 0),
     (VUINT32) ((0xC9F2C26DD3D18FD9uLL) >> 32)}},
   {{(VUINT32) ((0xEF02CC07F79788C5uLL) >> 0),
     (VUINT32) ((0xEF02CC07F79788C5uLL) >> 32)},
    {(VUINT32) ((0xAD05368FB69B3F67uLL) >> 0),
     (VUINT32) ((0xAD05368FB69B3F67uLL) >> 32)},
    {(VUINT32) ((0x93E584DBA7A31FB3uLL) >> 0),
     (VUINT32) ((0x93E584DBA7A31FB3uLL) >> 32)}},
   {{(VUINT32) ((0xDE05980FEF2F118BuLL) >> 0),
     (VUINT32) ((0xDE05980FEF2F118BuLL) >> 32)},
    {(VUINT32) ((0x5A0A6D1F6D367ECFuLL) >> 0),
     (VUINT32) ((0x5A0A6D1F6D367ECFuLL) >> 32)},
    {(VUINT32) ((0x27CB09B74F463F66uLL) >> 0),
     (VUINT32) ((0x27CB09B74F463F66uLL) >> 32)}},
   {{(VUINT32) ((0xBC0B301FDE5E2316uLL) >> 0),
     (VUINT32) ((0xBC0B301FDE5E2316uLL) >> 32)},
    {(VUINT32) ((0xB414DA3EDA6CFD9EuLL) >> 0),
     (VUINT32) ((0xB414DA3EDA6CFD9EuLL) >> 32)},
    {(VUINT32) ((0x4F96136E9E8C7ECDuLL) >> 0),
     (VUINT32) ((0x4F96136E9E8C7ECDuLL) >> 32)}},
   {{(VUINT32) ((0x7816603FBCBC462DuLL) >> 0),
     (VUINT32) ((0x7816603FBCBC462DuLL) >> 32)},
    {(VUINT32) ((0x6829B47DB4D9FB3CuLL) >> 0),
     (VUINT32) ((0x6829B47DB4D9FB3CuLL) >> 32)},
    {(VUINT32) ((0x9F2C26DD3D18FD9AuLL) >> 0),
     (VUINT32) ((0x9F2C26DD3D18FD9AuLL) >> 32)}},
   {{(VUINT32) ((0xF02CC07F79788C5AuLL) >> 0),
     (VUINT32) ((0xF02CC07F79788C5AuLL) >> 32)},
    {(VUINT32) ((0xD05368FB69B3F679uLL) >> 0),
     (VUINT32) ((0xD05368FB69B3F679uLL) >> 32)},
    {(VUINT32) ((0x3E584DBA7A31FB34uLL) >> 0),
     (VUINT32) ((0x3E584DBA7A31FB34uLL) >> 32)}},
   {{(VUINT32) ((0xE05980FEF2F118B5uLL) >> 0),
     (VUINT32) ((0xE05980FEF2F118B5uLL) >> 32)},
    {(VUINT32) ((0xA0A6D1F6D367ECF2uLL) >> 0),
     (VUINT32) ((0xA0A6D1F6D367ECF2uLL) >> 32)},
    {(VUINT32) ((0x7CB09B74F463F669uLL) >> 0),
     (VUINT32) ((0x7CB09B74F463F669uLL) >> 32)}},
   {{(VUINT32) ((0xC0B301FDE5E2316BuLL) >> 0),
     (VUINT32) ((0xC0B301FDE5E2316BuLL) >> 32)},
    {(VUINT32) ((0x414DA3EDA6CFD9E4uLL) >> 0),
     (VUINT32) ((0x414DA3EDA6CFD9E4uLL) >> 32)},
    {(VUINT32) ((0xF96136E9E8C7ECD3uLL) >> 0),
     (VUINT32) ((0xF96136E9E8C7ECD3uLL) >> 32)}},
   {{(VUINT32) ((0x816603FBCBC462D6uLL) >> 0),
     (VUINT32) ((0x816603FBCBC462D6uLL) >> 32)},
    {(VUINT32) ((0x829B47DB4D9FB3C9uLL) >> 0),
     (VUINT32) ((0x829B47DB4D9FB3C9uLL) >> 32)},
    {(VUINT32) ((0xF2C26DD3D18FD9A7uLL) >> 0),
     (VUINT32) ((0xF2C26DD3D18FD9A7uLL) >> 32)}},
   {{(VUINT32) ((0x02CC07F79788C5ADuLL) >> 0),
     (VUINT32) ((0x02CC07F79788C5ADuLL) >> 32)},
    {(VUINT32) ((0x05368FB69B3F6793uLL) >> 0),
     (VUINT32) ((0x05368FB69B3F6793uLL) >> 32)},
    {(VUINT32) ((0xE584DBA7A31FB34FuLL) >> 0),
     (VUINT32) ((0xE584DBA7A31FB34FuLL) >> 32)}},
   {{(VUINT32) ((0x05980FEF2F118B5AuLL) >> 0),
     (VUINT32) ((0x05980FEF2F118B5AuLL) >> 32)},
    {(VUINT32) ((0x0A6D1F6D367ECF27uLL) >> 0),
     (VUINT32) ((0x0A6D1F6D367ECF27uLL) >> 32)},
    {(VUINT32) ((0xCB09B74F463F669EuLL) >> 0),
     (VUINT32) ((0xCB09B74F463F669EuLL) >> 32)}},
   {{(VUINT32) ((0x0B301FDE5E2316B4uLL) >> 0),
     (VUINT32) ((0x0B301FDE5E2316B4uLL) >> 32)},
    {(VUINT32) ((0x14DA3EDA6CFD9E4FuLL) >> 0),
     (VUINT32) ((0x14DA3EDA6CFD9E4FuLL) >> 32)},
    {(VUINT32) ((0x96136E9E8C7ECD3CuLL) >> 0),
     (VUINT32) ((0x96136E9E8C7ECD3CuLL) >> 32)}},
   {{(VUINT32) ((0x16603FBCBC462D68uLL) >> 0),
     (VUINT32) ((0x16603FBCBC462D68uLL) >> 32)},
    {(VUINT32) ((0x29B47DB4D9FB3C9FuLL) >> 0),
     (VUINT32) ((0x29B47DB4D9FB3C9FuLL) >> 32)},
    {(VUINT32) ((0x2C26DD3D18FD9A79uLL) >> 0),
     (VUINT32) ((0x2C26DD3D18FD9A79uLL) >> 32)}},
   {{(VUINT32) ((0x2CC07F79788C5AD0uLL) >> 0),
     (VUINT32) ((0x2CC07F79788C5AD0uLL) >> 32)},
    {(VUINT32) ((0x5368FB69B3F6793EuLL) >> 0),
     (VUINT32) ((0x5368FB69B3F6793EuLL) >> 32)},
    {(VUINT32) ((0x584DBA7A31FB34F2uLL) >> 0),
     (VUINT32) ((0x584DBA7A31FB34F2uLL) >> 32)}},
   {{(VUINT32) ((0x5980FEF2F118B5A0uLL) >> 0),
     (VUINT32) ((0x5980FEF2F118B5A0uLL) >> 32)},
    {(VUINT32) ((0xA6D1F6D367ECF27CuLL) >> 0),
     (VUINT32) ((0xA6D1F6D367ECF27CuLL) >> 32)},
    {(VUINT32) ((0xB09B74F463F669E5uLL) >> 0),
     (VUINT32) ((0xB09B74F463F669E5uLL) >> 32)}},
   {{(VUINT32) ((0xB301FDE5E2316B41uLL) >> 0),
     (VUINT32) ((0xB301FDE5E2316B41uLL) >> 32)},
    {(VUINT32) ((0x4DA3EDA6CFD9E4F9uLL) >> 0),
     (VUINT32) ((0x4DA3EDA6CFD9E4F9uLL) >> 32)},
    {(VUINT32) ((0x6136E9E8C7ECD3CBuLL) >> 0),
     (VUINT32) ((0x6136E9E8C7ECD3CBuLL) >> 32)}},
   {{(VUINT32) ((0x6603FBCBC462D682uLL) >> 0),
     (VUINT32) ((0x6603FBCBC462D682uLL) >> 32)},
    {(VUINT32) ((0x9B47DB4D9FB3C9F2uLL) >> 0),
     (VUINT32) ((0x9B47DB4D9FB3C9F2uLL) >> 32)},
    {(VUINT32) ((0xC26DD3D18FD9A797uLL) >> 0),
     (VUINT32) ((0xC26DD3D18FD9A797uLL) >> 32)}},
   {{(VUINT32) ((0xCC07F79788C5AD05uLL) >> 0),
     (VUINT32) ((0xCC07F79788C5AD05uLL) >> 32)},
    {(VUINT32) ((0x368FB69B3F6793E5uLL) >> 0),
     (VUINT32) ((0x368FB69B3F6793E5uLL) >> 32)},
    {(VUINT32) ((0x84DBA7A31FB34F2FuLL) >> 0),
     (VUINT32) ((0x84DBA7A31FB34F2FuLL) >> 32)}},
   {{(VUINT32) ((0x980FEF2F118B5A0AuLL) >> 0),
     (VUINT32) ((0x980FEF2F118B5A0AuLL) >> 32)},
    {(VUINT32) ((0x6D1F6D367ECF27CBuLL) >> 0),
     (VUINT32) ((0x6D1F6D367ECF27CBuLL) >> 32)},
    {(VUINT32) ((0x09B74F463F669E5FuLL) >> 0),
     (VUINT32) ((0x09B74F463F669E5FuLL) >> 32)}},
   {{(VUINT32) ((0x301FDE5E2316B414uLL) >> 0),
     (VUINT32) ((0x301FDE5E2316B414uLL) >> 32)},
    {(VUINT32) ((0xDA3EDA6CFD9E4F96uLL) >> 0),
     (VUINT32) ((0xDA3EDA6CFD9E4F96uLL) >> 32)},
    {(VUINT32) ((0x136E9E8C7ECD3CBFuLL) >> 0),
     (VUINT32) ((0x136E9E8C7ECD3CBFuLL) >> 32)}},
   {{(VUINT32) ((0x603FBCBC462D6829uLL) >> 0),
     (VUINT32) ((0x603FBCBC462D6829uLL) >> 32)},
    {(VUINT32) ((0xB47DB4D9FB3C9F2CuLL) >> 0),
     (VUINT32) ((0xB47DB4D9FB3C9F2CuLL) >> 32)},
    {(VUINT32) ((0x26DD3D18FD9A797FuLL) >> 0),
     (VUINT32) ((0x26DD3D18FD9A797FuLL) >> 32)}},
   {{(VUINT32) ((0xC07F79788C5AD053uLL) >> 0),
     (VUINT32) ((0xC07F79788C5AD053uLL) >> 32)},
    {(VUINT32) ((0x68FB69B3F6793E58uLL) >> 0),
     (VUINT32) ((0x68FB69B3F6793E58uLL) >> 32)},
    {(VUINT32) ((0x4DBA7A31FB34F2FFuLL) >> 0),
     (VUINT32) ((0x4DBA7A31FB34F2FFuLL) >> 32)}},
   {{(VUINT32) ((0x80FEF2F118B5A0A6uLL) >> 0),
     (VUINT32) ((0x80FEF2F118B5A0A6uLL) >> 32)},
    {(VUINT32) ((0xD1F6D367ECF27CB0uLL) >> 0),
     (VUINT32) ((0xD1F6D367ECF27CB0uLL) >> 32)},
    {(VUINT32) ((0x9B74F463F669E5FEuLL) >> 0),
     (VUINT32) ((0x9B74F463F669E5FEuLL) >> 32)}},
   {{(VUINT32) ((0x01FDE5E2316B414DuLL) >> 0),
     (VUINT32) ((0x01FDE5E2316B414DuLL) >> 32)},
    {(VUINT32) ((0xA3EDA6CFD9E4F961uLL) >> 0),
     (VUINT32) ((0xA3EDA6CFD9E4F961uLL) >> 32)},
    {(VUINT32) ((0x36E9E8C7ECD3CBFDuLL) >> 0),
     (VUINT32) ((0x36E9E8C7ECD3CBFDuLL) >> 32)}},
   {{(VUINT32) ((0x03FBCBC462D6829BuLL) >> 0),
     (VUINT32) ((0x03FBCBC462D6829BuLL) >> 32)},
    {(VUINT32) ((0x47DB4D9FB3C9F2C2uLL) >> 0),
     (VUINT32) ((0x47DB4D9FB3C9F2C2uLL) >> 32)},
    {(VUINT32) ((0x6DD3D18FD9A797FAuLL) >> 0),
     (VUINT32) ((0x6DD3D18FD9A797FAuLL) >> 32)}},
   {{(VUINT32) ((0x07F79788C5AD0536uLL) >> 0),
     (VUINT32) ((0x07F79788C5AD0536uLL) >> 32)},
    {(VUINT32) ((0x8FB69B3F6793E584uLL) >> 0),
     (VUINT32) ((0x8FB69B3F6793E584uLL) >> 32)},
    {(VUINT32) ((0xDBA7A31FB34F2FF5uLL) >> 0),
     (VUINT32) ((0xDBA7A31FB34F2FF5uLL) >> 32)}},
   {{(VUINT32) ((0x0FEF2F118B5A0A6DuLL) >> 0),
     (VUINT32) ((0x0FEF2F118B5A0A6DuLL) >> 32)},
    {(VUINT32) ((0x1F6D367ECF27CB09uLL) >> 0),
     (VUINT32) ((0x1F6D367ECF27CB09uLL) >> 32)},
    {(VUINT32) ((0xB74F463F669E5FEAuLL) >> 0),
     (VUINT32) ((0xB74F463F669E5FEAuLL) >> 32)}},
   {{(VUINT32) ((0x1FDE5E2316B414DAuLL) >> 0),
     (VUINT32) ((0x1FDE5E2316B414DAuLL) >> 32)},
    {(VUINT32) ((0x3EDA6CFD9E4F9613uLL) >> 0),
     (VUINT32) ((0x3EDA6CFD9E4F9613uLL) >> 32)},
    {(VUINT32) ((0x6E9E8C7ECD3CBFD4uLL) >> 0),
     (VUINT32) ((0x6E9E8C7ECD3CBFD4uLL) >> 32)}},
   {{(VUINT32) ((0x3FBCBC462D6829B4uLL) >> 0),
     (VUINT32) ((0x3FBCBC462D6829B4uLL) >> 32)},
    {(VUINT32) ((0x7DB4D9FB3C9F2C26uLL) >> 0),
     (VUINT32) ((0x7DB4D9FB3C9F2C26uLL) >> 32)},
    {(VUINT32) ((0xDD3D18FD9A797FA8uLL) >> 0),
     (VUINT32) ((0xDD3D18FD9A797FA8uLL) >> 32)}},
   {{(VUINT32) ((0x7F79788C5AD05368uLL) >> 0),
     (VUINT32) ((0x7F79788C5AD05368uLL) >> 32)},
    {(VUINT32) ((0xFB69B3F6793E584DuLL) >> 0),
     (VUINT32) ((0xFB69B3F6793E584DuLL) >> 32)},
    {(VUINT32) ((0xBA7A31FB34F2FF51uLL) >> 0),
     (VUINT32) ((0xBA7A31FB34F2FF51uLL) >> 32)}},
   {{(VUINT32) ((0xFEF2F118B5A0A6D1uLL) >> 0),
     (VUINT32) ((0xFEF2F118B5A0A6D1uLL) >> 32)},
    {(VUINT32) ((0xF6D367ECF27CB09BuLL) >> 0),
     (VUINT32) ((0xF6D367ECF27CB09BuLL) >> 32)},
    {(VUINT32) ((0x74F463F669E5FEA2uLL) >> 0),
     (VUINT32) ((0x74F463F669E5FEA2uLL) >> 32)}},
   {{(VUINT32) ((0xFDE5E2316B414DA3uLL) >> 0),
     (VUINT32) ((0xFDE5E2316B414DA3uLL) >> 32)},
    {(VUINT32) ((0xEDA6CFD9E4F96136uLL) >> 0),
     (VUINT32) ((0xEDA6CFD9E4F96136uLL) >> 32)},
    {(VUINT32) ((0xE9E8C7ECD3CBFD45uLL) >> 0),
     (VUINT32) ((0xE9E8C7ECD3CBFD45uLL) >> 32)}},
   {{(VUINT32) ((0xFBCBC462D6829B47uLL) >> 0),
     (VUINT32) ((0xFBCBC462D6829B47uLL) >> 32)},
    {(VUINT32) ((0xDB4D9FB3C9F2C26DuLL) >> 0),
     (VUINT32) ((0xDB4D9FB3C9F2C26DuLL) >> 32)},
    {(VUINT32) ((0xD3D18FD9A797FA8BuLL) >> 0),
     (VUINT32) ((0xD3D18FD9A797FA8BuLL) >> 32)}},
   {{(VUINT32) ((0xF79788C5AD05368FuLL) >> 0),
     (VUINT32) ((0xF79788C5AD05368FuLL) >> 32)},
    {(VUINT32) ((0xB69B3F6793E584DBuLL) >> 0),
     (VUINT32) ((0xB69B3F6793E584DBuLL) >> 32)},
    {(VUINT32) ((0xA7A31FB34F2FF516uLL) >> 0),
     (VUINT32) ((0xA7A31FB34F2FF516uLL) >> 32)}},
   {{(VUINT32) ((0xEF2F118B5A0A6D1FuLL) >> 0),
     (VUINT32) ((0xEF2F118B5A0A6D1FuLL) >> 32)},
    {(VUINT32) ((0x6D367ECF27CB09B7uLL) >> 0),
     (VUINT32) ((0x6D367ECF27CB09B7uLL) >> 32)},
    {(VUINT32) ((0x4F463F669E5FEA2DuLL) >> 0),
     (VUINT32) ((0x4F463F669E5FEA2DuLL) >> 32)}},
   {{(VUINT32) ((0xDE5E2316B414DA3EuLL) >> 0),
     (VUINT32) ((0xDE5E2316B414DA3EuLL) >> 32)},
    {(VUINT32) ((0xDA6CFD9E4F96136EuLL) >> 0),
     (VUINT32) ((0xDA6CFD9E4F96136EuLL) >> 32)},
    {(VUINT32) ((0x9E8C7ECD3CBFD45AuLL) >> 0),
     (VUINT32) ((0x9E8C7ECD3CBFD45AuLL) >> 32)}},
   {{(VUINT32) ((0xBCBC462D6829B47DuLL) >> 0),
     (VUINT32) ((0xBCBC462D6829B47DuLL) >> 32)},
    {(VUINT32) ((0xB4D9FB3C9F2C26DDuLL) >> 0),
     (VUINT32) ((0xB4D9FB3C9F2C26DDuLL) >> 32)},
    {(VUINT32) ((0x3D18FD9A797FA8B5uLL) >> 0),
     (VUINT32) ((0x3D18FD9A797FA8B5uLL) >> 32)}},
   {{(VUINT32) ((0x79788C5AD05368FBuLL) >> 0),
     (VUINT32) ((0x79788C5AD05368FBuLL) >> 32)},
    {(VUINT32) ((0x69B3F6793E584DBAuLL) >> 0),
     (VUINT32) ((0x69B3F6793E584DBAuLL) >> 32)},
    {(VUINT32) ((0x7A31FB34F2FF516BuLL) >> 0),
     (VUINT32) ((0x7A31FB34F2FF516BuLL) >> 32)}},
   {{(VUINT32) ((0xF2F118B5A0A6D1F6uLL) >> 0),
     (VUINT32) ((0xF2F118B5A0A6D1F6uLL) >> 32)},
    {(VUINT32) ((0xD367ECF27CB09B74uLL) >> 0),
     (VUINT32) ((0xD367ECF27CB09B74uLL) >> 32)},
    {(VUINT32) ((0xF463F669E5FEA2D7uLL) >> 0),
     (VUINT32) ((0xF463F669E5FEA2D7uLL) >> 32)}},
   {{(VUINT32) ((0xE5E2316B414DA3EDuLL) >> 0),
     (VUINT32) ((0xE5E2316B414DA3EDuLL) >> 32)},
    {(VUINT32) ((0xA6CFD9E4F96136E9uLL) >> 0),
     (VUINT32) ((0xA6CFD9E4F96136E9uLL) >> 32)},
    {(VUINT32) ((0xE8C7ECD3CBFD45AEuLL) >> 0),
     (VUINT32) ((0xE8C7ECD3CBFD45AEuLL) >> 32)}},
   {{(VUINT32) ((0xCBC462D6829B47DBuLL) >> 0),
     (VUINT32) ((0xCBC462D6829B47DBuLL) >> 32)},
    {(VUINT32) ((0x4D9FB3C9F2C26DD3uLL) >> 0),
     (VUINT32) ((0x4D9FB3C9F2C26DD3uLL) >> 32)},
    {(VUINT32) ((0xD18FD9A797FA8B5DuLL) >> 0),
     (VUINT32) ((0xD18FD9A797FA8B5DuLL) >> 32)}},
   {{(VUINT32) ((0x9788C5AD05368FB6uLL) >> 0),
     (VUINT32) ((0x9788C5AD05368FB6uLL) >> 32)},
    {(VUINT32) ((0x9B3F6793E584DBA7uLL) >> 0),
     (VUINT32) ((0x9B3F6793E584DBA7uLL) >> 32)},
    {(VUINT32) ((0xA31FB34F2FF516BAuLL) >> 0),
     (VUINT32) ((0xA31FB34F2FF516BAuLL) >> 32)}},
   {{(VUINT32) ((0x2F118B5A0A6D1F6DuLL) >> 0),
     (VUINT32) ((0x2F118B5A0A6D1F6DuLL) >> 32)},
    {(VUINT32) ((0x367ECF27CB09B74FuLL) >> 0),
     (VUINT32) ((0x367ECF27CB09B74FuLL) >> 32)},
    {(VUINT32) ((0x463F669E5FEA2D75uLL) >> 0),
     (VUINT32) ((0x463F669E5FEA2D75uLL) >> 32)}},
   {{(VUINT32) ((0x5E2316B414DA3EDAuLL) >> 0),
     (VUINT32) ((0x5E2316B414DA3EDAuLL) >> 32)},
    {(VUINT32) ((0x6CFD9E4F96136E9EuLL) >> 0),
     (VUINT32) ((0x6CFD9E4F96136E9EuLL) >> 32)},
    {(VUINT32) ((0x8C7ECD3CBFD45AEAuLL) >> 0),
     (VUINT32) ((0x8C7ECD3CBFD45AEAuLL) >> 32)}},
   {{(VUINT32) ((0xBC462D6829B47DB4uLL) >> 0),
     (VUINT32) ((0xBC462D6829B47DB4uLL) >> 32)},
    {(VUINT32) ((0xD9FB3C9F2C26DD3DuLL) >> 0),
     (VUINT32) ((0xD9FB3C9F2C26DD3DuLL) >> 32)},
    {(VUINT32) ((0x18FD9A797FA8B5D4uLL) >> 0),
     (VUINT32) ((0x18FD9A797FA8B5D4uLL) >> 32)}},
   {{(VUINT32) ((0x788C5AD05368FB69uLL) >> 0),
     (VUINT32) ((0x788C5AD05368FB69uLL) >> 32)},
    {(VUINT32) ((0xB3F6793E584DBA7AuLL) >> 0),
     (VUINT32) ((0xB3F6793E584DBA7AuLL) >> 32)},
    {(VUINT32) ((0x31FB34F2FF516BA9uLL) >> 0),
     (VUINT32) ((0x31FB34F2FF516BA9uLL) >> 32)}},
   {{(VUINT32) ((0xF118B5A0A6D1F6D3uLL) >> 0),
     (VUINT32) ((0xF118B5A0A6D1F6D3uLL) >> 32)},
    {(VUINT32) ((0x67ECF27CB09B74F4uLL) >> 0),
     (VUINT32) ((0x67ECF27CB09B74F4uLL) >> 32)},
    {(VUINT32) ((0x63F669E5FEA2D752uLL) >> 0),
     (VUINT32) ((0x63F669E5FEA2D752uLL) >> 32)}},
   {{(VUINT32) ((0xE2316B414DA3EDA6uLL) >> 0),
     (VUINT32) ((0xE2316B414DA3EDA6uLL) >> 32)},
    {(VUINT32) ((0xCFD9E4F96136E9E8uLL) >> 0),
     (VUINT32) ((0xCFD9E4F96136E9E8uLL) >> 32)},
    {(VUINT32) ((0xC7ECD3CBFD45AEA4uLL) >> 0),
     (VUINT32) ((0xC7ECD3CBFD45AEA4uLL) >> 32)}},
   {{(VUINT32) ((0xC462D6829B47DB4DuLL) >> 0),
     (VUINT32) ((0xC462D6829B47DB4DuLL) >> 32)},
    {(VUINT32) ((0x9FB3C9F2C26DD3D1uLL) >> 0),
     (VUINT32) ((0x9FB3C9F2C26DD3D1uLL) >> 32)},
    {(VUINT32) ((0x8FD9A797FA8B5D49uLL) >> 0),
     (VUINT32) ((0x8FD9A797FA8B5D49uLL) >> 32)}},
   {{(VUINT32) ((0x88C5AD05368FB69BuLL) >> 0),
     (VUINT32) ((0x88C5AD05368FB69BuLL) >> 32)},
    {(VUINT32) ((0x3F6793E584DBA7A3uLL) >> 0),
     (VUINT32) ((0x3F6793E584DBA7A3uLL) >> 32)},
    {(VUINT32) ((0x1FB34F2FF516BA93uLL) >> 0),
     (VUINT32) ((0x1FB34F2FF516BA93uLL) >> 32)}},
   {{(VUINT32) ((0x118B5A0A6D1F6D36uLL) >> 0),
     (VUINT32) ((0x118B5A0A6D1F6D36uLL) >> 32)},
    {(VUINT32) ((0x7ECF27CB09B74F46uLL) >> 0),
     (VUINT32) ((0x7ECF27CB09B74F46uLL) >> 32)},
    {(VUINT32) ((0x3F669E5FEA2D7527uLL) >> 0),
     (VUINT32) ((0x3F669E5FEA2D7527uLL) >> 32)}},
   {{(VUINT32) ((0x2316B414DA3EDA6CuLL) >> 0),
     (VUINT32) ((0x2316B414DA3EDA6CuLL) >> 32)},
    {(VUINT32) ((0xFD9E4F96136E9E8CuLL) >> 0),
     (VUINT32) ((0xFD9E4F96136E9E8CuLL) >> 32)},
    {(VUINT32) ((0x7ECD3CBFD45AEA4FuLL) >> 0),
     (VUINT32) ((0x7ECD3CBFD45AEA4FuLL) >> 32)}},
   {{(VUINT32) ((0x462D6829B47DB4D9uLL) >> 0),
     (VUINT32) ((0x462D6829B47DB4D9uLL) >> 32)},
    {(VUINT32) ((0xFB3C9F2C26DD3D18uLL) >> 0),
     (VUINT32) ((0xFB3C9F2C26DD3D18uLL) >> 32)},
    {(VUINT32) ((0xFD9A797FA8B5D49EuLL) >> 0),
     (VUINT32) ((0xFD9A797FA8B5D49EuLL) >> 32)}},
   {{(VUINT32) ((0x8C5AD05368FB69B3uLL) >> 0),
     (VUINT32) ((0x8C5AD05368FB69B3uLL) >> 32)},
    {(VUINT32) ((0xF6793E584DBA7A31uLL) >> 0),
     (VUINT32) ((0xF6793E584DBA7A31uLL) >> 32)},
    {(VUINT32) ((0xFB34F2FF516BA93DuLL) >> 0),
     (VUINT32) ((0xFB34F2FF516BA93DuLL) >> 32)}},
   {{(VUINT32) ((0x18B5A0A6D1F6D367uLL) >> 0),
     (VUINT32) ((0x18B5A0A6D1F6D367uLL) >> 32)},
    {(VUINT32) ((0xECF27CB09B74F463uLL) >> 0),
     (VUINT32) ((0xECF27CB09B74F463uLL) >> 32)},
    {(VUINT32) ((0xF669E5FEA2D7527BuLL) >> 0),
     (VUINT32) ((0xF669E5FEA2D7527BuLL) >> 32)}},
   {{(VUINT32) ((0x316B414DA3EDA6CFuLL) >> 0),
     (VUINT32) ((0x316B414DA3EDA6CFuLL) >> 32)},
    {(VUINT32) ((0xD9E4F96136E9E8C7uLL) >> 0),
     (VUINT32) ((0xD9E4F96136E9E8C7uLL) >> 32)},
    {(VUINT32) ((0xECD3CBFD45AEA4F7uLL) >> 0),
     (VUINT32) ((0xECD3CBFD45AEA4F7uLL) >> 32)}},
   {{(VUINT32) ((0x62D6829B47DB4D9FuLL) >> 0),
     (VUINT32) ((0x62D6829B47DB4D9FuLL) >> 32)},
    {(VUINT32) ((0xB3C9F2C26DD3D18FuLL) >> 0),
     (VUINT32) ((0xB3C9F2C26DD3D18FuLL) >> 32)},
    {(VUINT32) ((0xD9A797FA8B5D49EEuLL) >> 0),
     (VUINT32) ((0xD9A797FA8B5D49EEuLL) >> 32)}},
   {{(VUINT32) ((0xC5AD05368FB69B3FuLL) >> 0),
     (VUINT32) ((0xC5AD05368FB69B3FuLL) >> 32)},
    {(VUINT32) ((0x6793E584DBA7A31FuLL) >> 0),
     (VUINT32) ((0x6793E584DBA7A31FuLL) >> 32)},
    {(VUINT32) ((0xB34F2FF516BA93DDuLL) >> 0),
     (VUINT32) ((0xB34F2FF516BA93DDuLL) >> 32)}},
   {{(VUINT32) ((0x8B5A0A6D1F6D367EuLL) >> 0),
     (VUINT32) ((0x8B5A0A6D1F6D367EuLL) >> 32)},
    {(VUINT32) ((0xCF27CB09B74F463FuLL) >> 0),
     (VUINT32) ((0xCF27CB09B74F463FuLL) >> 32)},
    {(VUINT32) ((0x669E5FEA2D7527BAuLL) >> 0),
     (VUINT32) ((0x669E5FEA2D7527BAuLL) >> 32)}},
   {{(VUINT32) ((0x16B414DA3EDA6CFDuLL) >> 0),
     (VUINT32) ((0x16B414DA3EDA6CFDuLL) >> 32)},
    {(VUINT32) ((0x9E4F96136E9E8C7EuLL) >> 0),
     (VUINT32) ((0x9E4F96136E9E8C7EuLL) >> 32)},
    {(VUINT32) ((0xCD3CBFD45AEA4F75uLL) >> 0),
     (VUINT32) ((0xCD3CBFD45AEA4F75uLL) >> 32)}},
   {{(VUINT32) ((0x2D6829B47DB4D9FBuLL) >> 0),
     (VUINT32) ((0x2D6829B47DB4D9FBuLL) >> 32)},
    {(VUINT32) ((0x3C9F2C26DD3D18FDuLL) >> 0),
     (VUINT32) ((0x3C9F2C26DD3D18FDuLL) >> 32)},
    {(VUINT32) ((0x9A797FA8B5D49EEBuLL) >> 0),
     (VUINT32) ((0x9A797FA8B5D49EEBuLL) >> 32)}},
   {{(VUINT32) ((0x5AD05368FB69B3F6uLL) >> 0),
     (VUINT32) ((0x5AD05368FB69B3F6uLL) >> 32)},
    {(VUINT32) ((0x793E584DBA7A31FBuLL) >> 0),
     (VUINT32) ((0x793E584DBA7A31FBuLL) >> 32)},
    {(VUINT32) ((0x34F2FF516BA93DD6uLL) >> 0),
     (VUINT32) ((0x34F2FF516BA93DD6uLL) >> 32)}},
   {{(VUINT32) ((0xB5A0A6D1F6D367ECuLL) >> 0),
     (VUINT32) ((0xB5A0A6D1F6D367ECuLL) >> 32)},
    {(VUINT32) ((0xF27CB09B74F463F6uLL) >> 0),
     (VUINT32) ((0xF27CB09B74F463F6uLL) >> 32)},
    {(VUINT32) ((0x69E5FEA2D7527BACuLL) >> 0),
     (VUINT32) ((0x69E5FEA2D7527BACuLL) >> 32)}},
   {{(VUINT32) ((0x6B414DA3EDA6CFD9uLL) >> 0),
     (VUINT32) ((0x6B414DA3EDA6CFD9uLL) >> 32)},
    {(VUINT32) ((0xE4F96136E9E8C7ECuLL) >> 0),
     (VUINT32) ((0xE4F96136E9E8C7ECuLL) >> 32)},
    {(VUINT32) ((0xD3CBFD45AEA4F758uLL) >> 0),
     (VUINT32) ((0xD3CBFD45AEA4F758uLL) >> 32)}},
   {{(VUINT32) ((0xD6829B47DB4D9FB3uLL) >> 0),
     (VUINT32) ((0xD6829B47DB4D9FB3uLL) >> 32)},
    {(VUINT32) ((0xC9F2C26DD3D18FD9uLL) >> 0),
     (VUINT32) ((0xC9F2C26DD3D18FD9uLL) >> 32)},
    {(VUINT32) ((0xA797FA8B5D49EEB1uLL) >> 0),
     (VUINT32) ((0xA797FA8B5D49EEB1uLL) >> 32)}},
   {{(VUINT32) ((0xAD05368FB69B3F67uLL) >> 0),
     (VUINT32) ((0xAD05368FB69B3F67uLL) >> 32)},
    {(VUINT32) ((0x93E584DBA7A31FB3uLL) >> 0),
     (VUINT32) ((0x93E584DBA7A31FB3uLL) >> 32)},
    {(VUINT32) ((0x4F2FF516BA93DD63uLL) >> 0),
     (VUINT32) ((0x4F2FF516BA93DD63uLL) >> 32)}},
   {{(VUINT32) ((0x5A0A6D1F6D367ECFuLL) >> 0),
     (VUINT32) ((0x5A0A6D1F6D367ECFuLL) >> 32)},
    {(VUINT32) ((0x27CB09B74F463F66uLL) >> 0),
     (VUINT32) ((0x27CB09B74F463F66uLL) >> 32)},
    {(VUINT32) ((0x9E5FEA2D7527BAC7uLL) >> 0),
     (VUINT32) ((0x9E5FEA2D7527BAC7uLL) >> 32)}},
   {{(VUINT32) ((0xB414DA3EDA6CFD9EuLL) >> 0),
     (VUINT32) ((0xB414DA3EDA6CFD9EuLL) >> 32)},
    {(VUINT32) ((0x4F96136E9E8C7ECDuLL) >> 0),
     (VUINT32) ((0x4F96136E9E8C7ECDuLL) >> 32)},
    {(VUINT32) ((0x3CBFD45AEA4F758FuLL) >> 0),
     (VUINT32) ((0x3CBFD45AEA4F758FuLL) >> 32)}},
   {{(VUINT32) ((0x6829B47DB4D9FB3CuLL) >> 0),
     (VUINT32) ((0x6829B47DB4D9FB3CuLL) >> 32)},
    {(VUINT32) ((0x9F2C26DD3D18FD9AuLL) >> 0),
     (VUINT32) ((0x9F2C26DD3D18FD9AuLL) >> 32)},
    {(VUINT32) ((0x797FA8B5D49EEB1FuLL) >> 0),
     (VUINT32) ((0x797FA8B5D49EEB1FuLL) >> 32)}},
   {{(VUINT32) ((0xD05368FB69B3F679uLL) >> 0),
     (VUINT32) ((0xD05368FB69B3F679uLL) >> 32)},
    {(VUINT32) ((0x3E584DBA7A31FB34uLL) >> 0),
     (VUINT32) ((0x3E584DBA7A31FB34uLL) >> 32)},
    {(VUINT32) ((0xF2FF516BA93DD63FuLL) >> 0),
     (VUINT32) ((0xF2FF516BA93DD63FuLL) >> 32)}},
   {{(VUINT32) ((0xA0A6D1F6D367ECF2uLL) >> 0),
     (VUINT32) ((0xA0A6D1F6D367ECF2uLL) >> 32)},
    {(VUINT32) ((0x7CB09B74F463F669uLL) >> 0),
     (VUINT32) ((0x7CB09B74F463F669uLL) >> 32)},
    {(VUINT32) ((0xE5FEA2D7527BAC7EuLL) >> 0),
     (VUINT32) ((0xE5FEA2D7527BAC7EuLL) >> 32)}},
   {{(VUINT32) ((0x414DA3EDA6CFD9E4uLL) >> 0),
     (VUINT32) ((0x414DA3EDA6CFD9E4uLL) >> 32)},
    {(VUINT32) ((0xF96136E9E8C7ECD3uLL) >> 0),
     (VUINT32) ((0xF96136E9E8C7ECD3uLL) >> 32)},
    {(VUINT32) ((0xCBFD45AEA4F758FDuLL) >> 0),
     (VUINT32) ((0xCBFD45AEA4F758FDuLL) >> 32)}},
   {{(VUINT32) ((0x829B47DB4D9FB3C9uLL) >> 0),
     (VUINT32) ((0x829B47DB4D9FB3C9uLL) >> 32)},
    {(VUINT32) ((0xF2C26DD3D18FD9A7uLL) >> 0),
     (VUINT32) ((0xF2C26DD3D18FD9A7uLL) >> 32)},
    {(VUINT32) ((0x97FA8B5D49EEB1FAuLL) >> 0),
     (VUINT32) ((0x97FA8B5D49EEB1FAuLL) >> 32)}},
   {{(VUINT32) ((0x05368FB69B3F6793uLL) >> 0),
     (VUINT32) ((0x05368FB69B3F6793uLL) >> 32)},
    {(VUINT32) ((0xE584DBA7A31FB34FuLL) >> 0),
     (VUINT32) ((0xE584DBA7A31FB34FuLL) >> 32)},
    {(VUINT32) ((0x2FF516BA93DD63F5uLL) >> 0),
     (VUINT32) ((0x2FF516BA93DD63F5uLL) >> 32)}},
   {{(VUINT32) ((0x0A6D1F6D367ECF27uLL) >> 0),
     (VUINT32) ((0x0A6D1F6D367ECF27uLL) >> 32)},
    {(VUINT32) ((0xCB09B74F463F669EuLL) >> 0),
     (VUINT32) ((0xCB09B74F463F669EuLL) >> 32)},
    {(VUINT32) ((0x5FEA2D7527BAC7EBuLL) >> 0),
     (VUINT32) ((0x5FEA2D7527BAC7EBuLL) >> 32)}},
   {{(VUINT32) ((0x14DA3EDA6CFD9E4FuLL) >> 0),
     (VUINT32) ((0x14DA3EDA6CFD9E4FuLL) >> 32)},
    {(VUINT32) ((0x96136E9E8C7ECD3CuLL) >> 0),
     (VUINT32) ((0x96136E9E8C7ECD3CuLL) >> 32)},
    {(VUINT32) ((0xBFD45AEA4F758FD7uLL) >> 0),
     (VUINT32) ((0xBFD45AEA4F758FD7uLL) >> 32)}},
   {{(VUINT32) ((0x29B47DB4D9FB3C9FuLL) >> 0),
     (VUINT32) ((0x29B47DB4D9FB3C9FuLL) >> 32)},
    {(VUINT32) ((0x2C26DD3D18FD9A79uLL) >> 0),
     (VUINT32) ((0x2C26DD3D18FD9A79uLL) >> 32)},
    {(VUINT32) ((0x7FA8B5D49EEB1FAFuLL) >> 0),
     (VUINT32) ((0x7FA8B5D49EEB1FAFuLL) >> 32)}},
   {{(VUINT32) ((0x5368FB69B3F6793EuLL) >> 0),
     (VUINT32) ((0x5368FB69B3F6793EuLL) >> 32)},
    {(VUINT32) ((0x584DBA7A31FB34F2uLL) >> 0),
     (VUINT32) ((0x584DBA7A31FB34F2uLL) >> 32)},
    {(VUINT32) ((0xFF516BA93DD63F5FuLL) >> 0),
     (VUINT32) ((0xFF516BA93DD63F5FuLL) >> 32)}},
   {{(VUINT32) ((0xA6D1F6D367ECF27CuLL) >> 0),
     (VUINT32) ((0xA6D1F6D367ECF27CuLL) >> 32)},
    {(VUINT32) ((0xB09B74F463F669E5uLL) >> 0),
     (VUINT32) ((0xB09B74F463F669E5uLL) >> 32)},
    {(VUINT32) ((0xFEA2D7527BAC7EBEuLL) >> 0),
     (VUINT32) ((0xFEA2D7527BAC7EBEuLL) >> 32)}},
   {{(VUINT32) ((0x4DA3EDA6CFD9E4F9uLL) >> 0),
     (VUINT32) ((0x4DA3EDA6CFD9E4F9uLL) >> 32)},
    {(VUINT32) ((0x6136E9E8C7ECD3CBuLL) >> 0),
     (VUINT32) ((0x6136E9E8C7ECD3CBuLL) >> 32)},
    {(VUINT32) ((0xFD45AEA4F758FD7CuLL) >> 0),
     (VUINT32) ((0xFD45AEA4F758FD7CuLL) >> 32)}},
   {{(VUINT32) ((0x9B47DB4D9FB3C9F2uLL) >> 0),
     (VUINT32) ((0x9B47DB4D9FB3C9F2uLL) >> 32)},
    {(VUINT32) ((0xC26DD3D18FD9A797uLL) >> 0),
     (VUINT32) ((0xC26DD3D18FD9A797uLL) >> 32)},
    {(VUINT32) ((0xFA8B5D49EEB1FAF9uLL) >> 0),
     (VUINT32) ((0xFA8B5D49EEB1FAF9uLL) >> 32)}},
   {{(VUINT32) ((0x368FB69B3F6793E5uLL) >> 0),
     (VUINT32) ((0x368FB69B3F6793E5uLL) >> 32)},
    {(VUINT32) ((0x84DBA7A31FB34F2FuLL) >> 0),
     (VUINT32) ((0x84DBA7A31FB34F2FuLL) >> 32)},
    {(VUINT32) ((0xF516BA93DD63F5F2uLL) >> 0),
     (VUINT32) ((0xF516BA93DD63F5F2uLL) >> 32)}},
   {{(VUINT32) ((0x6D1F6D367ECF27CBuLL) >> 0),
     (VUINT32) ((0x6D1F6D367ECF27CBuLL) >> 32)},
    {(VUINT32) ((0x09B74F463F669E5FuLL) >> 0),
     (VUINT32) ((0x09B74F463F669E5FuLL) >> 32)},
    {(VUINT32) ((0xEA2D7527BAC7EBE5uLL) >> 0),
     (VUINT32) ((0xEA2D7527BAC7EBE5uLL) >> 32)}},
   {{(VUINT32) ((0xDA3EDA6CFD9E4F96uLL) >> 0),
     (VUINT32) ((0xDA3EDA6CFD9E4F96uLL) >> 32)},
    {(VUINT32) ((0x136E9E8C7ECD3CBFuLL) >> 0),
     (VUINT32) ((0x136E9E8C7ECD3CBFuLL) >> 32)},
    {(VUINT32) ((0xD45AEA4F758FD7CBuLL) >> 0),
     (VUINT32) ((0xD45AEA4F758FD7CBuLL) >> 32)}},
   {{(VUINT32) ((0xB47DB4D9FB3C9F2CuLL) >> 0),
     (VUINT32) ((0xB47DB4D9FB3C9F2CuLL) >> 32)},
    {(VUINT32) ((0x26DD3D18FD9A797FuLL) >> 0),
     (VUINT32) ((0x26DD3D18FD9A797FuLL) >> 32)},
    {(VUINT32) ((0xA8B5D49EEB1FAF97uLL) >> 0),
     (VUINT32) ((0xA8B5D49EEB1FAF97uLL) >> 32)}},
   {{(VUINT32) ((0x68FB69B3F6793E58uLL) >> 0),
     (VUINT32) ((0x68FB69B3F6793E58uLL) >> 32)},
    {(VUINT32) ((0x4DBA7A31FB34F2FFuLL) >> 0),
     (VUINT32) ((0x4DBA7A31FB34F2FFuLL) >> 32)},
    {(VUINT32) ((0x516BA93DD63F5F2FuLL) >> 0),
     (VUINT32) ((0x516BA93DD63F5F2FuLL) >> 32)}},
   {{(VUINT32) ((0xD1F6D367ECF27CB0uLL) >> 0),
     (VUINT32) ((0xD1F6D367ECF27CB0uLL) >> 32)},
    {(VUINT32) ((0x9B74F463F669E5FEuLL) >> 0),
     (VUINT32) ((0x9B74F463F669E5FEuLL) >> 32)},
    {(VUINT32) ((0xA2D7527BAC7EBE5FuLL) >> 0),
     (VUINT32) ((0xA2D7527BAC7EBE5FuLL) >> 32)}},
   {{(VUINT32) ((0xA3EDA6CFD9E4F961uLL) >> 0),
     (VUINT32) ((0xA3EDA6CFD9E4F961uLL) >> 32)},
    {(VUINT32) ((0x36E9E8C7ECD3CBFDuLL) >> 0),
     (VUINT32) ((0x36E9E8C7ECD3CBFDuLL) >> 32)},
    {(VUINT32) ((0x45AEA4F758FD7CBEuLL) >> 0),
     (VUINT32) ((0x45AEA4F758FD7CBEuLL) >> 32)}},
   {{(VUINT32) ((0x47DB4D9FB3C9F2C2uLL) >> 0),
     (VUINT32) ((0x47DB4D9FB3C9F2C2uLL) >> 32)},
    {(VUINT32) ((0x6DD3D18FD9A797FAuLL) >> 0),
     (VUINT32) ((0x6DD3D18FD9A797FAuLL) >> 32)},
    {(VUINT32) ((0x8B5D49EEB1FAF97CuLL) >> 0),
     (VUINT32) ((0x8B5D49EEB1FAF97CuLL) >> 32)}},
   {{(VUINT32) ((0x8FB69B3F6793E584uLL) >> 0),
     (VUINT32) ((0x8FB69B3F6793E584uLL) >> 32)},
    {(VUINT32) ((0xDBA7A31FB34F2FF5uLL) >> 0),
     (VUINT32) ((0xDBA7A31FB34F2FF5uLL) >> 32)},
    {(VUINT32) ((0x16BA93DD63F5F2F8uLL) >> 0),
     (VUINT32) ((0x16BA93DD63F5F2F8uLL) >> 32)}},
   {{(VUINT32) ((0x1F6D367ECF27CB09uLL) >> 0),
     (VUINT32) ((0x1F6D367ECF27CB09uLL) >> 32)},
    {(VUINT32) ((0xB74F463F669E5FEAuLL) >> 0),
     (VUINT32) ((0xB74F463F669E5FEAuLL) >> 32)},
    {(VUINT32) ((0x2D7527BAC7EBE5F1uLL) >> 0),
     (VUINT32) ((0x2D7527BAC7EBE5F1uLL) >> 32)}},
   {{(VUINT32) ((0x3EDA6CFD9E4F9613uLL) >> 0),
     (VUINT32) ((0x3EDA6CFD9E4F9613uLL) >> 32)},
    {(VUINT32) ((0x6E9E8C7ECD3CBFD4uLL) >> 0),
     (VUINT32) ((0x6E9E8C7ECD3CBFD4uLL) >> 32)},
    {(VUINT32) ((0x5AEA4F758FD7CBE2uLL) >> 0),
     (VUINT32) ((0x5AEA4F758FD7CBE2uLL) >> 32)}},
   {{(VUINT32) ((0x7DB4D9FB3C9F2C26uLL) >> 0),
     (VUINT32) ((0x7DB4D9FB3C9F2C26uLL) >> 32)},
    {(VUINT32) ((0xDD3D18FD9A797FA8uLL) >> 0),
     (VUINT32) ((0xDD3D18FD9A797FA8uLL) >> 32)},
    {(VUINT32) ((0xB5D49EEB1FAF97C5uLL) >> 0),
     (VUINT32) ((0xB5D49EEB1FAF97C5uLL) >> 32)}},
   {{(VUINT32) ((0xFB69B3F6793E584DuLL) >> 0),
     (VUINT32) ((0xFB69B3F6793E584DuLL) >> 32)},
    {(VUINT32) ((0xBA7A31FB34F2FF51uLL) >> 0),
     (VUINT32) ((0xBA7A31FB34F2FF51uLL) >> 32)},
    {(VUINT32) ((0x6BA93DD63F5F2F8BuLL) >> 0),
     (VUINT32) ((0x6BA93DD63F5F2F8BuLL) >> 32)}},
   {{(VUINT32) ((0xF6D367ECF27CB09BuLL) >> 0),
     (VUINT32) ((0xF6D367ECF27CB09BuLL) >> 32)},
    {(VUINT32) ((0x74F463F669E5FEA2uLL) >> 0),
     (VUINT32) ((0x74F463F669E5FEA2uLL) >> 32)},
    {(VUINT32) ((0xD7527BAC7EBE5F17uLL) >> 0),
     (VUINT32) ((0xD7527BAC7EBE5F17uLL) >> 32)}},
   {{(VUINT32) ((0xEDA6CFD9E4F96136uLL) >> 0),
     (VUINT32) ((0xEDA6CFD9E4F96136uLL) >> 32)},
    {(VUINT32) ((0xE9E8C7ECD3CBFD45uLL) >> 0),
     (VUINT32) ((0xE9E8C7ECD3CBFD45uLL) >> 32)},
    {(VUINT32) ((0xAEA4F758FD7CBE2FuLL) >> 0),
     (VUINT32) ((0xAEA4F758FD7CBE2FuLL) >> 32)}},
   {{(VUINT32) ((0xDB4D9FB3C9F2C26DuLL) >> 0),
     (VUINT32) ((0xDB4D9FB3C9F2C26DuLL) >> 32)},
    {(VUINT32) ((0xD3D18FD9A797FA8BuLL) >> 0),
     (VUINT32) ((0xD3D18FD9A797FA8BuLL) >> 32)},
    {(VUINT32) ((0x5D49EEB1FAF97C5EuLL) >> 0),
     (VUINT32) ((0x5D49EEB1FAF97C5EuLL) >> 32)}},
   {{(VUINT32) ((0xB69B3F6793E584DBuLL) >> 0),
     (VUINT32) ((0xB69B3F6793E584DBuLL) >> 32)},
    {(VUINT32) ((0xA7A31FB34F2FF516uLL) >> 0),
     (VUINT32) ((0xA7A31FB34F2FF516uLL) >> 32)},
    {(VUINT32) ((0xBA93DD63F5F2F8BDuLL) >> 0),
     (VUINT32) ((0xBA93DD63F5F2F8BDuLL) >> 32)}},
   {{(VUINT32) ((0x6D367ECF27CB09B7uLL) >> 0),
     (VUINT32) ((0x6D367ECF27CB09B7uLL) >> 32)},
    {(VUINT32) ((0x4F463F669E5FEA2DuLL) >> 0),
     (VUINT32) ((0x4F463F669E5FEA2DuLL) >> 32)},
    {(VUINT32) ((0x7527BAC7EBE5F17BuLL) >> 0),
     (VUINT32) ((0x7527BAC7EBE5F17BuLL) >> 32)}},
   {{(VUINT32) ((0xDA6CFD9E4F96136EuLL) >> 0),
     (VUINT32) ((0xDA6CFD9E4F96136EuLL) >> 32)},
    {(VUINT32) ((0x9E8C7ECD3CBFD45AuLL) >> 0),
     (VUINT32) ((0x9E8C7ECD3CBFD45AuLL) >> 32)},
    {(VUINT32) ((0xEA4F758FD7CBE2F6uLL) >> 0),
     (VUINT32) ((0xEA4F758FD7CBE2F6uLL) >> 32)}},
   {{(VUINT32) ((0xB4D9FB3C9F2C26DDuLL) >> 0),
     (VUINT32) ((0xB4D9FB3C9F2C26DDuLL) >> 32)},
    {(VUINT32) ((0x3D18FD9A797FA8B5uLL) >> 0),
     (VUINT32) ((0x3D18FD9A797FA8B5uLL) >> 32)},
    {(VUINT32) ((0xD49EEB1FAF97C5ECuLL) >> 0),
     (VUINT32) ((0xD49EEB1FAF97C5ECuLL) >> 32)}},
   {{(VUINT32) ((0x69B3F6793E584DBAuLL) >> 0),
     (VUINT32) ((0x69B3F6793E584DBAuLL) >> 32)},
    {(VUINT32) ((0x7A31FB34F2FF516BuLL) >> 0),
     (VUINT32) ((0x7A31FB34F2FF516BuLL) >> 32)},
    {(VUINT32) ((0xA93DD63F5F2F8BD9uLL) >> 0),
     (VUINT32) ((0xA93DD63F5F2F8BD9uLL) >> 32)}},
   {{(VUINT32) ((0xD367ECF27CB09B74uLL) >> 0),
     (VUINT32) ((0xD367ECF27CB09B74uLL) >> 32)},
    {(VUINT32) ((0xF463F669E5FEA2D7uLL) >> 0),
     (VUINT32) ((0xF463F669E5FEA2D7uLL) >> 32)},
    {(VUINT32) ((0x527BAC7EBE5F17B3uLL) >> 0),
     (VUINT32) ((0x527BAC7EBE5F17B3uLL) >> 32)}},
   {{(VUINT32) ((0xA6CFD9E4F96136E9uLL) >> 0),
     (VUINT32) ((0xA6CFD9E4F96136E9uLL) >> 32)},
    {(VUINT32) ((0xE8C7ECD3CBFD45AEuLL) >> 0),
     (VUINT32) ((0xE8C7ECD3CBFD45AEuLL) >> 32)},
    {(VUINT32) ((0xA4F758FD7CBE2F67uLL) >> 0),
     (VUINT32) ((0xA4F758FD7CBE2F67uLL) >> 32)}},
   {{(VUINT32) ((0x4D9FB3C9F2C26DD3uLL) >> 0),
     (VUINT32) ((0x4D9FB3C9F2C26DD3uLL) >> 32)},
    {(VUINT32) ((0xD18FD9A797FA8B5DuLL) >> 0),
     (VUINT32) ((0xD18FD9A797FA8B5DuLL) >> 32)},
    {(VUINT32) ((0x49EEB1FAF97C5ECFuLL) >> 0),
     (VUINT32) ((0x49EEB1FAF97C5ECFuLL) >> 32)}},
   {{(VUINT32) ((0x9B3F6793E584DBA7uLL) >> 0),
     (VUINT32) ((0x9B3F6793E584DBA7uLL) >> 32)},
    {(VUINT32) ((0xA31FB34F2FF516BAuLL) >> 0),
     (VUINT32) ((0xA31FB34F2FF516BAuLL) >> 32)},
    {(VUINT32) ((0x93DD63F5F2F8BD9EuLL) >> 0),
     (VUINT32) ((0x93DD63F5F2F8BD9EuLL) >> 32)}},
   {{(VUINT32) ((0x367ECF27CB09B74FuLL) >> 0),
     (VUINT32) ((0x367ECF27CB09B74FuLL) >> 32)},
    {(VUINT32) ((0x463F669E5FEA2D75uLL) >> 0),
     (VUINT32) ((0x463F669E5FEA2D75uLL) >> 32)},
    {(VUINT32) ((0x27BAC7EBE5F17B3DuLL) >> 0),
     (VUINT32) ((0x27BAC7EBE5F17B3DuLL) >> 32)}},
   {{(VUINT32) ((0x6CFD9E4F96136E9EuLL) >> 0),
     (VUINT32) ((0x6CFD9E4F96136E9EuLL) >> 32)},
    {(VUINT32) ((0x8C7ECD3CBFD45AEAuLL) >> 0),
     (VUINT32) ((0x8C7ECD3CBFD45AEAuLL) >> 32)},
    {(VUINT32) ((0x4F758FD7CBE2F67AuLL) >> 0),
     (VUINT32) ((0x4F758FD7CBE2F67AuLL) >> 32)}},
   {{(VUINT32) ((0xD9FB3C9F2C26DD3DuLL) >> 0),
     (VUINT32) ((0xD9FB3C9F2C26DD3DuLL) >> 32)},
    {(VUINT32) ((0x18FD9A797FA8B5D4uLL) >> 0),
     (VUINT32) ((0x18FD9A797FA8B5D4uLL) >> 32)},
    {(VUINT32) ((0x9EEB1FAF97C5ECF4uLL) >> 0),
     (VUINT32) ((0x9EEB1FAF97C5ECF4uLL) >> 32)}},
   {{(VUINT32) ((0xB3F6793E584DBA7AuLL) >> 0),
     (VUINT32) ((0xB3F6793E584DBA7AuLL) >> 32)},
    {(VUINT32) ((0x31FB34F2FF516BA9uLL) >> 0),
     (VUINT32) ((0x31FB34F2FF516BA9uLL) >> 32)},
    {(VUINT32) ((0x3DD63F5F2F8BD9E8uLL) >> 0),
     (VUINT32) ((0x3DD63F5F2F8BD9E8uLL) >> 32)}},
   {{(VUINT32) ((0x67ECF27CB09B74F4uLL) >> 0),
     (VUINT32) ((0x67ECF27CB09B74F4uLL) >> 32)},
    {(VUINT32) ((0x63F669E5FEA2D752uLL) >> 0),
     (VUINT32) ((0x63F669E5FEA2D752uLL) >> 32)},
    {(VUINT32) ((0x7BAC7EBE5F17B3D0uLL) >> 0),
     (VUINT32) ((0x7BAC7EBE5F17B3D0uLL) >> 32)}},
   {{(VUINT32) ((0xCFD9E4F96136E9E8uLL) >> 0),
     (VUINT32) ((0xCFD9E4F96136E9E8uLL) >> 32)},
    {(VUINT32) ((0xC7ECD3CBFD45AEA4uLL) >> 0),
     (VUINT32) ((0xC7ECD3CBFD45AEA4uLL) >> 32)},
    {(VUINT32) ((0xF758FD7CBE2F67A0uLL) >> 0),
     (VUINT32) ((0xF758FD7CBE2F67A0uLL) >> 32)}},
   {{(VUINT32) ((0x9FB3C9F2C26DD3D1uLL) >> 0),
     (VUINT32) ((0x9FB3C9F2C26DD3D1uLL) >> 32)},
    {(VUINT32) ((0x8FD9A797FA8B5D49uLL) >> 0),
     (VUINT32) ((0x8FD9A797FA8B5D49uLL) >> 32)},
    {(VUINT32) ((0xEEB1FAF97C5ECF41uLL) >> 0),
     (VUINT32) ((0xEEB1FAF97C5ECF41uLL) >> 32)}},
   {{(VUINT32) ((0x3F6793E584DBA7A3uLL) >> 0),
     (VUINT32) ((0x3F6793E584DBA7A3uLL) >> 32)},
    {(VUINT32) ((0x1FB34F2FF516BA93uLL) >> 0),
     (VUINT32) ((0x1FB34F2FF516BA93uLL) >> 32)},
    {(VUINT32) ((0xDD63F5F2F8BD9E83uLL) >> 0),
     (VUINT32) ((0xDD63F5F2F8BD9E83uLL) >> 32)}},
   {{(VUINT32) ((0x7ECF27CB09B74F46uLL) >> 0),
     (VUINT32) ((0x7ECF27CB09B74F46uLL) >> 32)},
    {(VUINT32) ((0x3F669E5FEA2D7527uLL) >> 0),
     (VUINT32) ((0x3F669E5FEA2D7527uLL) >> 32)},
    {(VUINT32) ((0xBAC7EBE5F17B3D07uLL) >> 0),
     (VUINT32) ((0xBAC7EBE5F17B3D07uLL) >> 32)}},
   {{(VUINT32) ((0xFD9E4F96136E9E8CuLL) >> 0),
     (VUINT32) ((0xFD9E4F96136E9E8CuLL) >> 32)},
    {(VUINT32) ((0x7ECD3CBFD45AEA4FuLL) >> 0),
     (VUINT32) ((0x7ECD3CBFD45AEA4FuLL) >> 32)},
    {(VUINT32) ((0x758FD7CBE2F67A0EuLL) >> 0),
     (VUINT32) ((0x758FD7CBE2F67A0EuLL) >> 32)}},
   {{(VUINT32) ((0xFB3C9F2C26DD3D18uLL) >> 0),
     (VUINT32) ((0xFB3C9F2C26DD3D18uLL) >> 32)},
    {(VUINT32) ((0xFD9A797FA8B5D49EuLL) >> 0),
     (VUINT32) ((0xFD9A797FA8B5D49EuLL) >> 32)},
    {(VUINT32) ((0xEB1FAF97C5ECF41CuLL) >> 0),
     (VUINT32) ((0xEB1FAF97C5ECF41CuLL) >> 32)}},
   {{(VUINT32) ((0xF6793E584DBA7A31uLL) >> 0),
     (VUINT32) ((0xF6793E584DBA7A31uLL) >> 32)},
    {(VUINT32) ((0xFB34F2FF516BA93DuLL) >> 0),
     (VUINT32) ((0xFB34F2FF516BA93DuLL) >> 32)},
    {(VUINT32) ((0xD63F5F2F8BD9E839uLL) >> 0),
     (VUINT32) ((0xD63F5F2F8BD9E839uLL) >> 32)}},
   {{(VUINT32) ((0xECF27CB09B74F463uLL) >> 0),
     (VUINT32) ((0xECF27CB09B74F463uLL) >> 32)},
    {(VUINT32) ((0xF669E5FEA2D7527BuLL) >> 0),
     (VUINT32) ((0xF669E5FEA2D7527BuLL) >> 32)},
    {(VUINT32) ((0xAC7EBE5F17B3D073uLL) >> 0),
     (VUINT32) ((0xAC7EBE5F17B3D073uLL) >> 32)}},
   {{(VUINT32) ((0xD9E4F96136E9E8C7uLL) >> 0),
     (VUINT32) ((0xD9E4F96136E9E8C7uLL) >> 32)},
    {(VUINT32) ((0xECD3CBFD45AEA4F7uLL) >> 0),
     (VUINT32) ((0xECD3CBFD45AEA4F7uLL) >> 32)},
    {(VUINT32) ((0x58FD7CBE2F67A0E7uLL) >> 0),
     (VUINT32) ((0x58FD7CBE2F67A0E7uLL) >> 32)}},
   {{(VUINT32) ((0xB3C9F2C26DD3D18FuLL) >> 0),
     (VUINT32) ((0xB3C9F2C26DD3D18FuLL) >> 32)},
    {(VUINT32) ((0xD9A797FA8B5D49EEuLL) >> 0),
     (VUINT32) ((0xD9A797FA8B5D49EEuLL) >> 32)},
    {(VUINT32) ((0xB1FAF97C5ECF41CEuLL) >> 0),
     (VUINT32) ((0xB1FAF97C5ECF41CEuLL) >> 32)}},
   {{(VUINT32) ((0x6793E584DBA7A31FuLL) >> 0),
     (VUINT32) ((0x6793E584DBA7A31FuLL) >> 32)},
    {(VUINT32) ((0xB34F2FF516BA93DDuLL) >> 0),
     (VUINT32) ((0xB34F2FF516BA93DDuLL) >> 32)},
    {(VUINT32) ((0x63F5F2F8BD9E839CuLL) >> 0),
     (VUINT32) ((0x63F5F2F8BD9E839CuLL) >> 32)}},
   {{(VUINT32) ((0xCF27CB09B74F463FuLL) >> 0),
     (VUINT32) ((0xCF27CB09B74F463FuLL) >> 32)},
    {(VUINT32) ((0x669E5FEA2D7527BAuLL) >> 0),
     (VUINT32) ((0x669E5FEA2D7527BAuLL) >> 32)},
    {(VUINT32) ((0xC7EBE5F17B3D0739uLL) >> 0),
     (VUINT32) ((0xC7EBE5F17B3D0739uLL) >> 32)}},
   {{(VUINT32) ((0x9E4F96136E9E8C7EuLL) >> 0),
     (VUINT32) ((0x9E4F96136E9E8C7EuLL) >> 32)},
    {(VUINT32) ((0xCD3CBFD45AEA4F75uLL) >> 0),
     (VUINT32) ((0xCD3CBFD45AEA4F75uLL) >> 32)},
    {(VUINT32) ((0x8FD7CBE2F67A0E73uLL) >> 0),
     (VUINT32) ((0x8FD7CBE2F67A0E73uLL) >> 32)}},
   {{(VUINT32) ((0x3C9F2C26DD3D18FDuLL) >> 0),
     (VUINT32) ((0x3C9F2C26DD3D18FDuLL) >> 32)},
    {(VUINT32) ((0x9A797FA8B5D49EEBuLL) >> 0),
     (VUINT32) ((0x9A797FA8B5D49EEBuLL) >> 32)},
    {(VUINT32) ((0x1FAF97C5ECF41CE7uLL) >> 0),
     (VUINT32) ((0x1FAF97C5ECF41CE7uLL) >> 32)}},
   {{(VUINT32) ((0x793E584DBA7A31FBuLL) >> 0),
     (VUINT32) ((0x793E584DBA7A31FBuLL) >> 32)},
    {(VUINT32) ((0x34F2FF516BA93DD6uLL) >> 0),
     (VUINT32) ((0x34F2FF516BA93DD6uLL) >> 32)},
    {(VUINT32) ((0x3F5F2F8BD9E839CFuLL) >> 0),
     (VUINT32) ((0x3F5F2F8BD9E839CFuLL) >> 32)}},
   {{(VUINT32) ((0xF27CB09B74F463F6uLL) >> 0),
     (VUINT32) ((0xF27CB09B74F463F6uLL) >> 32)},
    {(VUINT32) ((0x69E5FEA2D7527BACuLL) >> 0),
     (VUINT32) ((0x69E5FEA2D7527BACuLL) >> 32)},
    {(VUINT32) ((0x7EBE5F17B3D0739FuLL) >> 0),
     (VUINT32) ((0x7EBE5F17B3D0739FuLL) >> 32)}},
   {{(VUINT32) ((0xE4F96136E9E8C7ECuLL) >> 0),
     (VUINT32) ((0xE4F96136E9E8C7ECuLL) >> 32)},
    {(VUINT32) ((0xD3CBFD45AEA4F758uLL) >> 0),
     (VUINT32) ((0xD3CBFD45AEA4F758uLL) >> 32)},
    {(VUINT32) ((0xFD7CBE2F67A0E73EuLL) >> 0),
     (VUINT32) ((0xFD7CBE2F67A0E73EuLL) >> 32)}},
   {{(VUINT32) ((0xC9F2C26DD3D18FD9uLL) >> 0),
     (VUINT32) ((0xC9F2C26DD3D18FD9uLL) >> 32)},
    {(VUINT32) ((0xA797FA8B5D49EEB1uLL) >> 0),
     (VUINT32) ((0xA797FA8B5D49EEB1uLL) >> 32)},
    {(VUINT32) ((0xFAF97C5ECF41CE7DuLL) >> 0),
     (VUINT32) ((0xFAF97C5ECF41CE7DuLL) >> 32)}},
   {{(VUINT32) ((0x93E584DBA7A31FB3uLL) >> 0),
     (VUINT32) ((0x93E584DBA7A31FB3uLL) >> 32)},
    {(VUINT32) ((0x4F2FF516BA93DD63uLL) >> 0),
     (VUINT32) ((0x4F2FF516BA93DD63uLL) >> 32)},
    {(VUINT32) ((0xF5F2F8BD9E839CFBuLL) >> 0),
     (VUINT32) ((0xF5F2F8BD9E839CFBuLL) >> 32)}},
   {{(VUINT32) ((0x27CB09B74F463F66uLL) >> 0),
     (VUINT32) ((0x27CB09B74F463F66uLL) >> 32)},
    {(VUINT32) ((0x9E5FEA2D7527BAC7uLL) >> 0),
     (VUINT32) ((0x9E5FEA2D7527BAC7uLL) >> 32)},
    {(VUINT32) ((0xEBE5F17B3D0739F7uLL) >> 0),
     (VUINT32) ((0xEBE5F17B3D0739F7uLL) >> 32)}},
   {{(VUINT32) ((0x4F96136E9E8C7ECDuLL) >> 0),
     (VUINT32) ((0x4F96136E9E8C7ECDuLL) >> 32)},
    {(VUINT32) ((0x3CBFD45AEA4F758FuLL) >> 0),
     (VUINT32) ((0x3CBFD45AEA4F758FuLL) >> 32)},
    {(VUINT32) ((0xD7CBE2F67A0E73EFuLL) >> 0),
     (VUINT32) ((0xD7CBE2F67A0E73EFuLL) >> 32)}},
   {{(VUINT32) ((0x9F2C26DD3D18FD9AuLL) >> 0),
     (VUINT32) ((0x9F2C26DD3D18FD9AuLL) >> 32)},
    {(VUINT32) ((0x797FA8B5D49EEB1FuLL) >> 0),
     (VUINT32) ((0x797FA8B5D49EEB1FuLL) >> 32)},
    {(VUINT32) ((0xAF97C5ECF41CE7DEuLL) >> 0),
     (VUINT32) ((0xAF97C5ECF41CE7DEuLL) >> 32)}},
   {{(VUINT32) ((0x3E584DBA7A31FB34uLL) >> 0),
     (VUINT32) ((0x3E584DBA7A31FB34uLL) >> 32)},
    {(VUINT32) ((0xF2FF516BA93DD63FuLL) >> 0),
     (VUINT32) ((0xF2FF516BA93DD63FuLL) >> 32)},
    {(VUINT32) ((0x5F2F8BD9E839CFBCuLL) >> 0),
     (VUINT32) ((0x5F2F8BD9E839CFBCuLL) >> 32)}},
   {{(VUINT32) ((0x7CB09B74F463F669uLL) >> 0),
     (VUINT32) ((0x7CB09B74F463F669uLL) >> 32)},
    {(VUINT32) ((0xE5FEA2D7527BAC7EuLL) >> 0),
     (VUINT32) ((0xE5FEA2D7527BAC7EuLL) >> 32)},
    {(VUINT32) ((0xBE5F17B3D0739F78uLL) >> 0),
     (VUINT32) ((0xBE5F17B3D0739F78uLL) >> 32)}},
   {{(VUINT32) ((0xF96136E9E8C7ECD3uLL) >> 0),
     (VUINT32) ((0xF96136E9E8C7ECD3uLL) >> 32)},
    {(VUINT32) ((0xCBFD45AEA4F758FDuLL) >> 0),
     (VUINT32) ((0xCBFD45AEA4F758FDuLL) >> 32)},
    {(VUINT32) ((0x7CBE2F67A0E73EF1uLL) >> 0),
     (VUINT32) ((0x7CBE2F67A0E73EF1uLL) >> 32)}},
   {{(VUINT32) ((0xF2C26DD3D18FD9A7uLL) >> 0),
     (VUINT32) ((0xF2C26DD3D18FD9A7uLL) >> 32)},
    {(VUINT32) ((0x97FA8B5D49EEB1FAuLL) >> 0),
     (VUINT32) ((0x97FA8B5D49EEB1FAuLL) >> 32)},
    {(VUINT32) ((0xF97C5ECF41CE7DE2uLL) >> 0),
     (VUINT32) ((0xF97C5ECF41CE7DE2uLL) >> 32)}},
   {{(VUINT32) ((0xE584DBA7A31FB34FuLL) >> 0),
     (VUINT32) ((0xE584DBA7A31FB34FuLL) >> 32)},
    {(VUINT32) ((0x2FF516BA93DD63F5uLL) >> 0),
     (VUINT32) ((0x2FF516BA93DD63F5uLL) >> 32)},
    {(VUINT32) ((0xF2F8BD9E839CFBC5uLL) >> 0),
     (VUINT32) ((0xF2F8BD9E839CFBC5uLL) >> 32)}},
   {{(VUINT32) ((0xCB09B74F463F669EuLL) >> 0),
     (VUINT32) ((0xCB09B74F463F669EuLL) >> 32)},
    {(VUINT32) ((0x5FEA2D7527BAC7EBuLL) >> 0),
     (VUINT32) ((0x5FEA2D7527BAC7EBuLL) >> 32)},
    {(VUINT32) ((0xE5F17B3D0739F78AuLL) >> 0),
     (VUINT32) ((0xE5F17B3D0739F78AuLL) >> 32)}},
   {{(VUINT32) ((0x96136E9E8C7ECD3CuLL) >> 0),
     (VUINT32) ((0x96136E9E8C7ECD3CuLL) >> 32)},
    {(VUINT32) ((0xBFD45AEA4F758FD7uLL) >> 0),
     (VUINT32) ((0xBFD45AEA4F758FD7uLL) >> 32)},
    {(VUINT32) ((0xCBE2F67A0E73EF14uLL) >> 0),
     (VUINT32) ((0xCBE2F67A0E73EF14uLL) >> 32)}},
   {{(VUINT32) ((0x2C26DD3D18FD9A79uLL) >> 0),
     (VUINT32) ((0x2C26DD3D18FD9A79uLL) >> 32)},
    {(VUINT32) ((0x7FA8B5D49EEB1FAFuLL) >> 0),
     (VUINT32) ((0x7FA8B5D49EEB1FAFuLL) >> 32)},
    {(VUINT32) ((0x97C5ECF41CE7DE29uLL) >> 0),
     (VUINT32) ((0x97C5ECF41CE7DE29uLL) >> 32)}},
   {{(VUINT32) ((0x584DBA7A31FB34F2uLL) >> 0),
     (VUINT32) ((0x584DBA7A31FB34F2uLL) >> 32)},
    {(VUINT32) ((0xFF516BA93DD63F5FuLL) >> 0),
     (VUINT32) ((0xFF516BA93DD63F5FuLL) >> 32)},
    {(VUINT32) ((0x2F8BD9E839CFBC52uLL) >> 0),
     (VUINT32) ((0x2F8BD9E839CFBC52uLL) >> 32)}},
   {{(VUINT32) ((0xB09B74F463F669E5uLL) >> 0),
     (VUINT32) ((0xB09B74F463F669E5uLL) >> 32)},
    {(VUINT32) ((0xFEA2D7527BAC7EBEuLL) >> 0),
     (VUINT32) ((0xFEA2D7527BAC7EBEuLL) >> 32)},
    {(VUINT32) ((0x5F17B3D0739F78A5uLL) >> 0),
     (VUINT32) ((0x5F17B3D0739F78A5uLL) >> 32)}},
   {{(VUINT32) ((0x6136E9E8C7ECD3CBuLL) >> 0),
     (VUINT32) ((0x6136E9E8C7ECD3CBuLL) >> 32)},
    {(VUINT32) ((0xFD45AEA4F758FD7CuLL) >> 0),
     (VUINT32) ((0xFD45AEA4F758FD7CuLL) >> 32)},
    {(VUINT32) ((0xBE2F67A0E73EF14AuLL) >> 0),
     (VUINT32) ((0xBE2F67A0E73EF14AuLL) >> 32)}},
   {{(VUINT32) ((0xC26DD3D18FD9A797uLL) >> 0),
     (VUINT32) ((0xC26DD3D18FD9A797uLL) >> 32)},
    {(VUINT32) ((0xFA8B5D49EEB1FAF9uLL) >> 0),
     (VUINT32) ((0xFA8B5D49EEB1FAF9uLL) >> 32)},
    {(VUINT32) ((0x7C5ECF41CE7DE294uLL) >> 0),
     (VUINT32) ((0x7C5ECF41CE7DE294uLL) >> 32)}},
   {{(VUINT32) ((0x84DBA7A31FB34F2FuLL) >> 0),
     (VUINT32) ((0x84DBA7A31FB34F2FuLL) >> 32)},
    {(VUINT32) ((0xF516BA93DD63F5F2uLL) >> 0),
     (VUINT32) ((0xF516BA93DD63F5F2uLL) >> 32)},
    {(VUINT32) ((0xF8BD9E839CFBC529uLL) >> 0),
     (VUINT32) ((0xF8BD9E839CFBC529uLL) >> 32)}},
   {{(VUINT32) ((0x09B74F463F669E5FuLL) >> 0),
     (VUINT32) ((0x09B74F463F669E5FuLL) >> 32)},
    {(VUINT32) ((0xEA2D7527BAC7EBE5uLL) >> 0),
     (VUINT32) ((0xEA2D7527BAC7EBE5uLL) >> 32)},
    {(VUINT32) ((0xF17B3D0739F78A52uLL) >> 0),
     (VUINT32) ((0xF17B3D0739F78A52uLL) >> 32)}},
   {{(VUINT32) ((0x136E9E8C7ECD3CBFuLL) >> 0),
     (VUINT32) ((0x136E9E8C7ECD3CBFuLL) >> 32)},
    {(VUINT32) ((0xD45AEA4F758FD7CBuLL) >> 0),
     (VUINT32) ((0xD45AEA4F758FD7CBuLL) >> 32)},
    {(VUINT32) ((0xE2F67A0E73EF14A5uLL) >> 0),
     (VUINT32) ((0xE2F67A0E73EF14A5uLL) >> 32)}},
   {{(VUINT32) ((0x26DD3D18FD9A797FuLL) >> 0),
     (VUINT32) ((0x26DD3D18FD9A797FuLL) >> 32)},
    {(VUINT32) ((0xA8B5D49EEB1FAF97uLL) >> 0),
     (VUINT32) ((0xA8B5D49EEB1FAF97uLL) >> 32)},
    {(VUINT32) ((0xC5ECF41CE7DE294AuLL) >> 0),
     (VUINT32) ((0xC5ECF41CE7DE294AuLL) >> 32)}},
   {{(VUINT32) ((0x4DBA7A31FB34F2FFuLL) >> 0),
     (VUINT32) ((0x4DBA7A31FB34F2FFuLL) >> 32)},
    {(VUINT32) ((0x516BA93DD63F5F2FuLL) >> 0),
     (VUINT32) ((0x516BA93DD63F5F2FuLL) >> 32)},
    {(VUINT32) ((0x8BD9E839CFBC5294uLL) >> 0),
     (VUINT32) ((0x8BD9E839CFBC5294uLL) >> 32)}},
   {{(VUINT32) ((0x9B74F463F669E5FEuLL) >> 0),
     (VUINT32) ((0x9B74F463F669E5FEuLL) >> 32)},
    {(VUINT32) ((0xA2D7527BAC7EBE5FuLL) >> 0),
     (VUINT32) ((0xA2D7527BAC7EBE5FuLL) >> 32)},
    {(VUINT32) ((0x17B3D0739F78A529uLL) >> 0),
     (VUINT32) ((0x17B3D0739F78A529uLL) >> 32)}},
   {{(VUINT32) ((0x36E9E8C7ECD3CBFDuLL) >> 0),
     (VUINT32) ((0x36E9E8C7ECD3CBFDuLL) >> 32)},
    {(VUINT32) ((0x45AEA4F758FD7CBEuLL) >> 0),
     (VUINT32) ((0x45AEA4F758FD7CBEuLL) >> 32)},
    {(VUINT32) ((0x2F67A0E73EF14A52uLL) >> 0),
     (VUINT32) ((0x2F67A0E73EF14A52uLL) >> 32)}},
   {{(VUINT32) ((0x6DD3D18FD9A797FAuLL) >> 0),
     (VUINT32) ((0x6DD3D18FD9A797FAuLL) >> 32)},
    {(VUINT32) ((0x8B5D49EEB1FAF97CuLL) >> 0),
     (VUINT32) ((0x8B5D49EEB1FAF97CuLL) >> 32)},
    {(VUINT32) ((0x5ECF41CE7DE294A4uLL) >> 0),
     (VUINT32) ((0x5ECF41CE7DE294A4uLL) >> 32)}},
   {{(VUINT32) ((0xDBA7A31FB34F2FF5uLL) >> 0),
     (VUINT32) ((0xDBA7A31FB34F2FF5uLL) >> 32)},
    {(VUINT32) ((0x16BA93DD63F5F2F8uLL) >> 0),
     (VUINT32) ((0x16BA93DD63F5F2F8uLL) >> 32)},
    {(VUINT32) ((0xBD9E839CFBC52949uLL) >> 0),
     (VUINT32) ((0xBD9E839CFBC52949uLL) >> 32)}},
   {{(VUINT32) ((0xB74F463F669E5FEAuLL) >> 0),
     (VUINT32) ((0xB74F463F669E5FEAuLL) >> 32)},
    {(VUINT32) ((0x2D7527BAC7EBE5F1uLL) >> 0),
     (VUINT32) ((0x2D7527BAC7EBE5F1uLL) >> 32)},
    {(VUINT32) ((0x7B3D0739F78A5292uLL) >> 0),
     (VUINT32) ((0x7B3D0739F78A5292uLL) >> 32)}},
   {{(VUINT32) ((0x6E9E8C7ECD3CBFD4uLL) >> 0),
     (VUINT32) ((0x6E9E8C7ECD3CBFD4uLL) >> 32)},
    {(VUINT32) ((0x5AEA4F758FD7CBE2uLL) >> 0),
     (VUINT32) ((0x5AEA4F758FD7CBE2uLL) >> 32)},
    {(VUINT32) ((0xF67A0E73EF14A525uLL) >> 0),
     (VUINT32) ((0xF67A0E73EF14A525uLL) >> 32)}},
   {{(VUINT32) ((0xDD3D18FD9A797FA8uLL) >> 0),
     (VUINT32) ((0xDD3D18FD9A797FA8uLL) >> 32)},
    {(VUINT32) ((0xB5D49EEB1FAF97C5uLL) >> 0),
     (VUINT32) ((0xB5D49EEB1FAF97C5uLL) >> 32)},
    {(VUINT32) ((0xECF41CE7DE294A4BuLL) >> 0),
     (VUINT32) ((0xECF41CE7DE294A4BuLL) >> 32)}},
   {{(VUINT32) ((0xBA7A31FB34F2FF51uLL) >> 0),
     (VUINT32) ((0xBA7A31FB34F2FF51uLL) >> 32)},
    {(VUINT32) ((0x6BA93DD63F5F2F8BuLL) >> 0),
     (VUINT32) ((0x6BA93DD63F5F2F8BuLL) >> 32)},
    {(VUINT32) ((0xD9E839CFBC529497uLL) >> 0),
     (VUINT32) ((0xD9E839CFBC529497uLL) >> 32)}},
   {{(VUINT32) ((0x74F463F669E5FEA2uLL) >> 0),
     (VUINT32) ((0x74F463F669E5FEA2uLL) >> 32)},
    {(VUINT32) ((0xD7527BAC7EBE5F17uLL) >> 0),
     (VUINT32) ((0xD7527BAC7EBE5F17uLL) >> 32)},
    {(VUINT32) ((0xB3D0739F78A5292EuLL) >> 0),
     (VUINT32) ((0xB3D0739F78A5292EuLL) >> 32)}},
   {{(VUINT32) ((0xE9E8C7ECD3CBFD45uLL) >> 0),
     (VUINT32) ((0xE9E8C7ECD3CBFD45uLL) >> 32)},
    {(VUINT32) ((0xAEA4F758FD7CBE2FuLL) >> 0),
     (VUINT32) ((0xAEA4F758FD7CBE2FuLL) >> 32)},
    {(VUINT32) ((0x67A0E73EF14A525DuLL) >> 0),
     (VUINT32) ((0x67A0E73EF14A525DuLL) >> 32)}},
   {{(VUINT32) ((0xD3D18FD9A797FA8BuLL) >> 0),
     (VUINT32) ((0xD3D18FD9A797FA8BuLL) >> 32)},
    {(VUINT32) ((0x5D49EEB1FAF97C5EuLL) >> 0),
     (VUINT32) ((0x5D49EEB1FAF97C5EuLL) >> 32)},
    {(VUINT32) ((0xCF41CE7DE294A4BAuLL) >> 0),
     (VUINT32) ((0xCF41CE7DE294A4BAuLL) >> 32)}},
   {{(VUINT32) ((0xA7A31FB34F2FF516uLL) >> 0),
     (VUINT32) ((0xA7A31FB34F2FF516uLL) >> 32)},
    {(VUINT32) ((0xBA93DD63F5F2F8BDuLL) >> 0),
     (VUINT32) ((0xBA93DD63F5F2F8BDuLL) >> 32)},
    {(VUINT32) ((0x9E839CFBC5294975uLL) >> 0),
     (VUINT32) ((0x9E839CFBC5294975uLL) >> 32)}},
   {{(VUINT32) ((0x4F463F669E5FEA2DuLL) >> 0),
     (VUINT32) ((0x4F463F669E5FEA2DuLL) >> 32)},
    {(VUINT32) ((0x7527BAC7EBE5F17BuLL) >> 0),
     (VUINT32) ((0x7527BAC7EBE5F17BuLL) >> 32)},
    {(VUINT32) ((0x3D0739F78A5292EAuLL) >> 0),
     (VUINT32) ((0x3D0739F78A5292EAuLL) >> 32)}},
   {{(VUINT32) ((0x9E8C7ECD3CBFD45AuLL) >> 0),
     (VUINT32) ((0x9E8C7ECD3CBFD45AuLL) >> 32)},
    {(VUINT32) ((0xEA4F758FD7CBE2F6uLL) >> 0),
     (VUINT32) ((0xEA4F758FD7CBE2F6uLL) >> 32)},
    {(VUINT32) ((0x7A0E73EF14A525D4uLL) >> 0),
     (VUINT32) ((0x7A0E73EF14A525D4uLL) >> 32)}},
   {{(VUINT32) ((0x3D18FD9A797FA8B5uLL) >> 0),
     (VUINT32) ((0x3D18FD9A797FA8B5uLL) >> 32)},
    {(VUINT32) ((0xD49EEB1FAF97C5ECuLL) >> 0),
     (VUINT32) ((0xD49EEB1FAF97C5ECuLL) >> 32)},
    {(VUINT32) ((0xF41CE7DE294A4BA9uLL) >> 0),
     (VUINT32) ((0xF41CE7DE294A4BA9uLL) >> 32)}},
   {{(VUINT32) ((0x7A31FB34F2FF516BuLL) >> 0),
     (VUINT32) ((0x7A31FB34F2FF516BuLL) >> 32)},
    {(VUINT32) ((0xA93DD63F5F2F8BD9uLL) >> 0),
     (VUINT32) ((0xA93DD63F5F2F8BD9uLL) >> 32)},
    {(VUINT32) ((0xE839CFBC52949753uLL) >> 0),
     (VUINT32) ((0xE839CFBC52949753uLL) >> 32)}},
   {{(VUINT32) ((0xF463F669E5FEA2D7uLL) >> 0),
     (VUINT32) ((0xF463F669E5FEA2D7uLL) >> 32)},
    {(VUINT32) ((0x527BAC7EBE5F17B3uLL) >> 0),
     (VUINT32) ((0x527BAC7EBE5F17B3uLL) >> 32)},
    {(VUINT32) ((0xD0739F78A5292EA6uLL) >> 0),
     (VUINT32) ((0xD0739F78A5292EA6uLL) >> 32)}},
   {{(VUINT32) ((0xE8C7ECD3CBFD45AEuLL) >> 0),
     (VUINT32) ((0xE8C7ECD3CBFD45AEuLL) >> 32)},
    {(VUINT32) ((0xA4F758FD7CBE2F67uLL) >> 0),
     (VUINT32) ((0xA4F758FD7CBE2F67uLL) >> 32)},
    {(VUINT32) ((0xA0E73EF14A525D4DuLL) >> 0),
     (VUINT32) ((0xA0E73EF14A525D4DuLL) >> 32)}},
   {{(VUINT32) ((0xD18FD9A797FA8B5DuLL) >> 0),
     (VUINT32) ((0xD18FD9A797FA8B5DuLL) >> 32)},
    {(VUINT32) ((0x49EEB1FAF97C5ECFuLL) >> 0),
     (VUINT32) ((0x49EEB1FAF97C5ECFuLL) >> 32)},
    {(VUINT32) ((0x41CE7DE294A4BA9AuLL) >> 0),
     (VUINT32) ((0x41CE7DE294A4BA9AuLL) >> 32)}},
   {{(VUINT32) ((0xA31FB34F2FF516BAuLL) >> 0),
     (VUINT32) ((0xA31FB34F2FF516BAuLL) >> 32)},
    {(VUINT32) ((0x93DD63F5F2F8BD9EuLL) >> 0),
     (VUINT32) ((0x93DD63F5F2F8BD9EuLL) >> 32)},
    {(VUINT32) ((0x839CFBC529497535uLL) >> 0),
     (VUINT32) ((0x839CFBC529497535uLL) >> 32)}},
   {{(VUINT32) ((0x463F669E5FEA2D75uLL) >> 0),
     (VUINT32) ((0x463F669E5FEA2D75uLL) >> 32)},
    {(VUINT32) ((0x27BAC7EBE5F17B3DuLL) >> 0),
     (VUINT32) ((0x27BAC7EBE5F17B3DuLL) >> 32)},
    {(VUINT32) ((0x0739F78A5292EA6BuLL) >> 0),
     (VUINT32) ((0x0739F78A5292EA6BuLL) >> 32)}},
   {{(VUINT32) ((0x8C7ECD3CBFD45AEAuLL) >> 0),
     (VUINT32) ((0x8C7ECD3CBFD45AEAuLL) >> 32)},
    {(VUINT32) ((0x4F758FD7CBE2F67AuLL) >> 0),
     (VUINT32) ((0x4F758FD7CBE2F67AuLL) >> 32)},
    {(VUINT32) ((0x0E73EF14A525D4D7uLL) >> 0),
     (VUINT32) ((0x0E73EF14A525D4D7uLL) >> 32)}},
   {{(VUINT32) ((0x18FD9A797FA8B5D4uLL) >> 0),
     (VUINT32) ((0x18FD9A797FA8B5D4uLL) >> 32)},
    {(VUINT32) ((0x9EEB1FAF97C5ECF4uLL) >> 0),
     (VUINT32) ((0x9EEB1FAF97C5ECF4uLL) >> 32)},
    {(VUINT32) ((0x1CE7DE294A4BA9AFuLL) >> 0),
     (VUINT32) ((0x1CE7DE294A4BA9AFuLL) >> 32)}},
   {{(VUINT32) ((0x31FB34F2FF516BA9uLL) >> 0),
     (VUINT32) ((0x31FB34F2FF516BA9uLL) >> 32)},
    {(VUINT32) ((0x3DD63F5F2F8BD9E8uLL) >> 0),
     (VUINT32) ((0x3DD63F5F2F8BD9E8uLL) >> 32)},
    {(VUINT32) ((0x39CFBC529497535FuLL) >> 0),
     (VUINT32) ((0x39CFBC529497535FuLL) >> 32)}},
   {{(VUINT32) ((0x63F669E5FEA2D752uLL) >> 0),
     (VUINT32) ((0x63F669E5FEA2D752uLL) >> 32)},
    {(VUINT32) ((0x7BAC7EBE5F17B3D0uLL) >> 0),
     (VUINT32) ((0x7BAC7EBE5F17B3D0uLL) >> 32)},
    {(VUINT32) ((0x739F78A5292EA6BFuLL) >> 0),
     (VUINT32) ((0x739F78A5292EA6BFuLL) >> 32)}},
   {{(VUINT32) ((0xC7ECD3CBFD45AEA4uLL) >> 0),
     (VUINT32) ((0xC7ECD3CBFD45AEA4uLL) >> 32)},
    {(VUINT32) ((0xF758FD7CBE2F67A0uLL) >> 0),
     (VUINT32) ((0xF758FD7CBE2F67A0uLL) >> 32)},
    {(VUINT32) ((0xE73EF14A525D4D7FuLL) >> 0),
     (VUINT32) ((0xE73EF14A525D4D7FuLL) >> 32)}},
   {{(VUINT32) ((0x8FD9A797FA8B5D49uLL) >> 0),
     (VUINT32) ((0x8FD9A797FA8B5D49uLL) >> 32)},
    {(VUINT32) ((0xEEB1FAF97C5ECF41uLL) >> 0),
     (VUINT32) ((0xEEB1FAF97C5ECF41uLL) >> 32)},
    {(VUINT32) ((0xCE7DE294A4BA9AFEuLL) >> 0),
     (VUINT32) ((0xCE7DE294A4BA9AFEuLL) >> 32)}},
   {{(VUINT32) ((0x1FB34F2FF516BA93uLL) >> 0),
     (VUINT32) ((0x1FB34F2FF516BA93uLL) >> 32)},
    {(VUINT32) ((0xDD63F5F2F8BD9E83uLL) >> 0),
     (VUINT32) ((0xDD63F5F2F8BD9E83uLL) >> 32)},
    {(VUINT32) ((0x9CFBC529497535FDuLL) >> 0),
     (VUINT32) ((0x9CFBC529497535FDuLL) >> 32)}},
   {{(VUINT32) ((0x3F669E5FEA2D7527uLL) >> 0),
     (VUINT32) ((0x3F669E5FEA2D7527uLL) >> 32)},
    {(VUINT32) ((0xBAC7EBE5F17B3D07uLL) >> 0),
     (VUINT32) ((0xBAC7EBE5F17B3D07uLL) >> 32)},
    {(VUINT32) ((0x39F78A5292EA6BFBuLL) >> 0),
     (VUINT32) ((0x39F78A5292EA6BFBuLL) >> 32)}},
   {{(VUINT32) ((0x7ECD3CBFD45AEA4FuLL) >> 0),
     (VUINT32) ((0x7ECD3CBFD45AEA4FuLL) >> 32)},
    {(VUINT32) ((0x758FD7CBE2F67A0EuLL) >> 0),
     (VUINT32) ((0x758FD7CBE2F67A0EuLL) >> 32)},
    {(VUINT32) ((0x73EF14A525D4D7F6uLL) >> 0),
     (VUINT32) ((0x73EF14A525D4D7F6uLL) >> 32)}},
   {{(VUINT32) ((0xFD9A797FA8B5D49EuLL) >> 0),
     (VUINT32) ((0xFD9A797FA8B5D49EuLL) >> 32)},
    {(VUINT32) ((0xEB1FAF97C5ECF41CuLL) >> 0),
     (VUINT32) ((0xEB1FAF97C5ECF41CuLL) >> 32)},
    {(VUINT32) ((0xE7DE294A4BA9AFEDuLL) >> 0),
     (VUINT32) ((0xE7DE294A4BA9AFEDuLL) >> 32)}},
   {{(VUINT32) ((0xFB34F2FF516BA93DuLL) >> 0),
     (VUINT32) ((0xFB34F2FF516BA93DuLL) >> 32)},
    {(VUINT32) ((0xD63F5F2F8BD9E839uLL) >> 0),
     (VUINT32) ((0xD63F5F2F8BD9E839uLL) >> 32)},
    {(VUINT32) ((0xCFBC529497535FDAuLL) >> 0),
     (VUINT32) ((0xCFBC529497535FDAuLL) >> 32)}},
   {{(VUINT32) ((0xF669E5FEA2D7527BuLL) >> 0),
     (VUINT32) ((0xF669E5FEA2D7527BuLL) >> 32)},
    {(VUINT32) ((0xAC7EBE5F17B3D073uLL) >> 0),
     (VUINT32) ((0xAC7EBE5F17B3D073uLL) >> 32)},
    {(VUINT32) ((0x9F78A5292EA6BFB5uLL) >> 0),
     (VUINT32) ((0x9F78A5292EA6BFB5uLL) >> 32)}},
   {{(VUINT32) ((0xECD3CBFD45AEA4F7uLL) >> 0),
     (VUINT32) ((0xECD3CBFD45AEA4F7uLL) >> 32)},
    {(VUINT32) ((0x58FD7CBE2F67A0E7uLL) >> 0),
     (VUINT32) ((0x58FD7CBE2F67A0E7uLL) >> 32)},
    {(VUINT32) ((0x3EF14A525D4D7F6BuLL) >> 0),
     (VUINT32) ((0x3EF14A525D4D7F6BuLL) >> 32)}},
   {{(VUINT32) ((0xD9A797FA8B5D49EEuLL) >> 0),
     (VUINT32) ((0xD9A797FA8B5D49EEuLL) >> 32)},
    {(VUINT32) ((0xB1FAF97C5ECF41CEuLL) >> 0),
     (VUINT32) ((0xB1FAF97C5ECF41CEuLL) >> 32)},
    {(VUINT32) ((0x7DE294A4BA9AFED7uLL) >> 0),
     (VUINT32) ((0x7DE294A4BA9AFED7uLL) >> 32)}},
   {{(VUINT32) ((0xB34F2FF516BA93DDuLL) >> 0),
     (VUINT32) ((0xB34F2FF516BA93DDuLL) >> 32)},
    {(VUINT32) ((0x63F5F2F8BD9E839CuLL) >> 0),
     (VUINT32) ((0x63F5F2F8BD9E839CuLL) >> 32)},
    {(VUINT32) ((0xFBC529497535FDAFuLL) >> 0),
     (VUINT32) ((0xFBC529497535FDAFuLL) >> 32)}},
   {{(VUINT32) ((0x669E5FEA2D7527BAuLL) >> 0),
     (VUINT32) ((0x669E5FEA2D7527BAuLL) >> 32)},
    {(VUINT32) ((0xC7EBE5F17B3D0739uLL) >> 0),
     (VUINT32) ((0xC7EBE5F17B3D0739uLL) >> 32)},
    {(VUINT32) ((0xF78A5292EA6BFB5FuLL) >> 0),
     (VUINT32) ((0xF78A5292EA6BFB5FuLL) >> 32)}},
   {{(VUINT32) ((0xCD3CBFD45AEA4F75uLL) >> 0),
     (VUINT32) ((0xCD3CBFD45AEA4F75uLL) >> 32)},
    {(VUINT32) ((0x8FD7CBE2F67A0E73uLL) >> 0),
     (VUINT32) ((0x8FD7CBE2F67A0E73uLL) >> 32)},
    {(VUINT32) ((0xEF14A525D4D7F6BFuLL) >> 0),
     (VUINT32) ((0xEF14A525D4D7F6BFuLL) >> 32)}},
   {{(VUINT32) ((0x9A797FA8B5D49EEBuLL) >> 0),
     (VUINT32) ((0x9A797FA8B5D49EEBuLL) >> 32)},
    {(VUINT32) ((0x1FAF97C5ECF41CE7uLL) >> 0),
     (VUINT32) ((0x1FAF97C5ECF41CE7uLL) >> 32)},
    {(VUINT32) ((0xDE294A4BA9AFED7EuLL) >> 0),
     (VUINT32) ((0xDE294A4BA9AFED7EuLL) >> 32)}},
   {{(VUINT32) ((0x34F2FF516BA93DD6uLL) >> 0),
     (VUINT32) ((0x34F2FF516BA93DD6uLL) >> 32)},
    {(VUINT32) ((0x3F5F2F8BD9E839CFuLL) >> 0),
     (VUINT32) ((0x3F5F2F8BD9E839CFuLL) >> 32)},
    {(VUINT32) ((0xBC529497535FDAFDuLL) >> 0),
     (VUINT32) ((0xBC529497535FDAFDuLL) >> 32)}},
   {{(VUINT32) ((0x69E5FEA2D7527BACuLL) >> 0),
     (VUINT32) ((0x69E5FEA2D7527BACuLL) >> 32)},
    {(VUINT32) ((0x7EBE5F17B3D0739FuLL) >> 0),
     (VUINT32) ((0x7EBE5F17B3D0739FuLL) >> 32)},
    {(VUINT32) ((0x78A5292EA6BFB5FBuLL) >> 0),
     (VUINT32) ((0x78A5292EA6BFB5FBuLL) >> 32)}},
   {{(VUINT32) ((0xD3CBFD45AEA4F758uLL) >> 0),
     (VUINT32) ((0xD3CBFD45AEA4F758uLL) >> 32)},
    {(VUINT32) ((0xFD7CBE2F67A0E73EuLL) >> 0),
     (VUINT32) ((0xFD7CBE2F67A0E73EuLL) >> 32)},
    {(VUINT32) ((0xF14A525D4D7F6BF6uLL) >> 0),
     (VUINT32) ((0xF14A525D4D7F6BF6uLL) >> 32)}},
   {{(VUINT32) ((0xA797FA8B5D49EEB1uLL) >> 0),
     (VUINT32) ((0xA797FA8B5D49EEB1uLL) >> 32)},
    {(VUINT32) ((0xFAF97C5ECF41CE7DuLL) >> 0),
     (VUINT32) ((0xFAF97C5ECF41CE7DuLL) >> 32)},
    {(VUINT32) ((0xE294A4BA9AFED7ECuLL) >> 0),
     (VUINT32) ((0xE294A4BA9AFED7ECuLL) >> 32)}},
   {{(VUINT32) ((0x4F2FF516BA93DD63uLL) >> 0),
     (VUINT32) ((0x4F2FF516BA93DD63uLL) >> 32)},
    {(VUINT32) ((0xF5F2F8BD9E839CFBuLL) >> 0),
     (VUINT32) ((0xF5F2F8BD9E839CFBuLL) >> 32)},
    {(VUINT32) ((0xC529497535FDAFD8uLL) >> 0),
     (VUINT32) ((0xC529497535FDAFD8uLL) >> 32)}},
   {{(VUINT32) ((0x9E5FEA2D7527BAC7uLL) >> 0),
     (VUINT32) ((0x9E5FEA2D7527BAC7uLL) >> 32)},
    {(VUINT32) ((0xEBE5F17B3D0739F7uLL) >> 0),
     (VUINT32) ((0xEBE5F17B3D0739F7uLL) >> 32)},
    {(VUINT32) ((0x8A5292EA6BFB5FB1uLL) >> 0),
     (VUINT32) ((0x8A5292EA6BFB5FB1uLL) >> 32)}},
   {{(VUINT32) ((0x3CBFD45AEA4F758FuLL) >> 0),
     (VUINT32) ((0x3CBFD45AEA4F758FuLL) >> 32)},
    {(VUINT32) ((0xD7CBE2F67A0E73EFuLL) >> 0),
     (VUINT32) ((0xD7CBE2F67A0E73EFuLL) >> 32)},
    {(VUINT32) ((0x14A525D4D7F6BF62uLL) >> 0),
     (VUINT32) ((0x14A525D4D7F6BF62uLL) >> 32)}},
   {{(VUINT32) ((0x797FA8B5D49EEB1FuLL) >> 0),
     (VUINT32) ((0x797FA8B5D49EEB1FuLL) >> 32)},
    {(VUINT32) ((0xAF97C5ECF41CE7DEuLL) >> 0),
     (VUINT32) ((0xAF97C5ECF41CE7DEuLL) >> 32)},
    {(VUINT32) ((0x294A4BA9AFED7EC4uLL) >> 0),
     (VUINT32) ((0x294A4BA9AFED7EC4uLL) >> 32)}},
   {{(VUINT32) ((0xF2FF516BA93DD63FuLL) >> 0),
     (VUINT32) ((0xF2FF516BA93DD63FuLL) >> 32)},
    {(VUINT32) ((0x5F2F8BD9E839CFBCuLL) >> 0),
     (VUINT32) ((0x5F2F8BD9E839CFBCuLL) >> 32)},
    {(VUINT32) ((0x529497535FDAFD88uLL) >> 0),
     (VUINT32) ((0x529497535FDAFD88uLL) >> 32)}},
   {{(VUINT32) ((0xE5FEA2D7527BAC7EuLL) >> 0),
     (VUINT32) ((0xE5FEA2D7527BAC7EuLL) >> 32)},
    {(VUINT32) ((0xBE5F17B3D0739F78uLL) >> 0),
     (VUINT32) ((0xBE5F17B3D0739F78uLL) >> 32)},
    {(VUINT32) ((0xA5292EA6BFB5FB11uLL) >> 0),
     (VUINT32) ((0xA5292EA6BFB5FB11uLL) >> 32)}},
   {{(VUINT32) ((0xCBFD45AEA4F758FDuLL) >> 0),
     (VUINT32) ((0xCBFD45AEA4F758FDuLL) >> 32)},
    {(VUINT32) ((0x7CBE2F67A0E73EF1uLL) >> 0),
     (VUINT32) ((0x7CBE2F67A0E73EF1uLL) >> 32)},
    {(VUINT32) ((0x4A525D4D7F6BF623uLL) >> 0),
     (VUINT32) ((0x4A525D4D7F6BF623uLL) >> 32)}},
   {{(VUINT32) ((0x97FA8B5D49EEB1FAuLL) >> 0),
     (VUINT32) ((0x97FA8B5D49EEB1FAuLL) >> 32)},
    {(VUINT32) ((0xF97C5ECF41CE7DE2uLL) >> 0),
     (VUINT32) ((0xF97C5ECF41CE7DE2uLL) >> 32)},
    {(VUINT32) ((0x94A4BA9AFED7EC47uLL) >> 0),
     (VUINT32) ((0x94A4BA9AFED7EC47uLL) >> 32)}},
   {{(VUINT32) ((0x2FF516BA93DD63F5uLL) >> 0),
     (VUINT32) ((0x2FF516BA93DD63F5uLL) >> 32)},
    {(VUINT32) ((0xF2F8BD9E839CFBC5uLL) >> 0),
     (VUINT32) ((0xF2F8BD9E839CFBC5uLL) >> 32)},
    {(VUINT32) ((0x29497535FDAFD88FuLL) >> 0),
     (VUINT32) ((0x29497535FDAFD88FuLL) >> 32)}},
   {{(VUINT32) ((0x5FEA2D7527BAC7EBuLL) >> 0),
     (VUINT32) ((0x5FEA2D7527BAC7EBuLL) >> 32)},
    {(VUINT32) ((0xE5F17B3D0739F78AuLL) >> 0),
     (VUINT32) ((0xE5F17B3D0739F78AuLL) >> 32)},
    {(VUINT32) ((0x5292EA6BFB5FB11FuLL) >> 0),
     (VUINT32) ((0x5292EA6BFB5FB11FuLL) >> 32)}},
   {{(VUINT32) ((0xBFD45AEA4F758FD7uLL) >> 0),
     (VUINT32) ((0xBFD45AEA4F758FD7uLL) >> 32)},
    {(VUINT32) ((0xCBE2F67A0E73EF14uLL) >> 0),
     (VUINT32) ((0xCBE2F67A0E73EF14uLL) >> 32)},
    {(VUINT32) ((0xA525D4D7F6BF623FuLL) >> 0),
     (VUINT32) ((0xA525D4D7F6BF623FuLL) >> 32)}},
   {{(VUINT32) ((0x7FA8B5D49EEB1FAFuLL) >> 0),
     (VUINT32) ((0x7FA8B5D49EEB1FAFuLL) >> 32)},
    {(VUINT32) ((0x97C5ECF41CE7DE29uLL) >> 0),
     (VUINT32) ((0x97C5ECF41CE7DE29uLL) >> 32)},
    {(VUINT32) ((0x4A4BA9AFED7EC47EuLL) >> 0),
     (VUINT32) ((0x4A4BA9AFED7EC47EuLL) >> 32)}},
   {{(VUINT32) ((0xFF516BA93DD63F5FuLL) >> 0),
     (VUINT32) ((0xFF516BA93DD63F5FuLL) >> 32)},
    {(VUINT32) ((0x2F8BD9E839CFBC52uLL) >> 0),
     (VUINT32) ((0x2F8BD9E839CFBC52uLL) >> 32)},
    {(VUINT32) ((0x9497535FDAFD88FCuLL) >> 0),
     (VUINT32) ((0x9497535FDAFD88FCuLL) >> 32)}},
   {{(VUINT32) ((0xFEA2D7527BAC7EBEuLL) >> 0),
     (VUINT32) ((0xFEA2D7527BAC7EBEuLL) >> 32)},
    {(VUINT32) ((0x5F17B3D0739F78A5uLL) >> 0),
     (VUINT32) ((0x5F17B3D0739F78A5uLL) >> 32)},
    {(VUINT32) ((0x292EA6BFB5FB11F8uLL) >> 0),
     (VUINT32) ((0x292EA6BFB5FB11F8uLL) >> 32)}},
   {{(VUINT32) ((0xFD45AEA4F758FD7CuLL) >> 0),
     (VUINT32) ((0xFD45AEA4F758FD7CuLL) >> 32)},
    {(VUINT32) ((0xBE2F67A0E73EF14AuLL) >> 0),
     (VUINT32) ((0xBE2F67A0E73EF14AuLL) >> 32)},
    {(VUINT32) ((0x525D4D7F6BF623F1uLL) >> 0),
     (VUINT32) ((0x525D4D7F6BF623F1uLL) >> 32)}},
   {{(VUINT32) ((0xFA8B5D49EEB1FAF9uLL) >> 0),
     (VUINT32) ((0xFA8B5D49EEB1FAF9uLL) >> 32)},
    {(VUINT32) ((0x7C5ECF41CE7DE294uLL) >> 0),
     (VUINT32) ((0x7C5ECF41CE7DE294uLL) >> 32)},
    {(VUINT32) ((0xA4BA9AFED7EC47E3uLL) >> 0),
     (VUINT32) ((0xA4BA9AFED7EC47E3uLL) >> 32)}},
   {{(VUINT32) ((0xF516BA93DD63F5F2uLL) >> 0),
     (VUINT32) ((0xF516BA93DD63F5F2uLL) >> 32)},
    {(VUINT32) ((0xF8BD9E839CFBC529uLL) >> 0),
     (VUINT32) ((0xF8BD9E839CFBC529uLL) >> 32)},
    {(VUINT32) ((0x497535FDAFD88FC6uLL) >> 0),
     (VUINT32) ((0x497535FDAFD88FC6uLL) >> 32)}},
   {{(VUINT32) ((0xEA2D7527BAC7EBE5uLL) >> 0),
     (VUINT32) ((0xEA2D7527BAC7EBE5uLL) >> 32)},
    {(VUINT32) ((0xF17B3D0739F78A52uLL) >> 0),
     (VUINT32) ((0xF17B3D0739F78A52uLL) >> 32)},
    {(VUINT32) ((0x92EA6BFB5FB11F8DuLL) >> 0),
     (VUINT32) ((0x92EA6BFB5FB11F8DuLL) >> 32)}},
   {{(VUINT32) ((0xD45AEA4F758FD7CBuLL) >> 0),
     (VUINT32) ((0xD45AEA4F758FD7CBuLL) >> 32)},
    {(VUINT32) ((0xE2F67A0E73EF14A5uLL) >> 0),
     (VUINT32) ((0xE2F67A0E73EF14A5uLL) >> 32)},
    {(VUINT32) ((0x25D4D7F6BF623F1AuLL) >> 0),
     (VUINT32) ((0x25D4D7F6BF623F1AuLL) >> 32)}},
   {{(VUINT32) ((0xA8B5D49EEB1FAF97uLL) >> 0),
     (VUINT32) ((0xA8B5D49EEB1FAF97uLL) >> 32)},
    {(VUINT32) ((0xC5ECF41CE7DE294AuLL) >> 0),
     (VUINT32) ((0xC5ECF41CE7DE294AuLL) >> 32)},
    {(VUINT32) ((0x4BA9AFED7EC47E35uLL) >> 0),
     (VUINT32) ((0x4BA9AFED7EC47E35uLL) >> 32)}},
   {{(VUINT32) ((0x516BA93DD63F5F2FuLL) >> 0),
     (VUINT32) ((0x516BA93DD63F5F2FuLL) >> 32)},
    {(VUINT32) ((0x8BD9E839CFBC5294uLL) >> 0),
     (VUINT32) ((0x8BD9E839CFBC5294uLL) >> 32)},
    {(VUINT32) ((0x97535FDAFD88FC6AuLL) >> 0),
     (VUINT32) ((0x97535FDAFD88FC6AuLL) >> 32)}},
   {{(VUINT32) ((0xA2D7527BAC7EBE5FuLL) >> 0),
     (VUINT32) ((0xA2D7527BAC7EBE5FuLL) >> 32)},
    {(VUINT32) ((0x17B3D0739F78A529uLL) >> 0),
     (VUINT32) ((0x17B3D0739F78A529uLL) >> 32)},
    {(VUINT32) ((0x2EA6BFB5FB11F8D5uLL) >> 0),
     (VUINT32) ((0x2EA6BFB5FB11F8D5uLL) >> 32)}},
   {{(VUINT32) ((0x45AEA4F758FD7CBEuLL) >> 0),
     (VUINT32) ((0x45AEA4F758FD7CBEuLL) >> 32)},
    {(VUINT32) ((0x2F67A0E73EF14A52uLL) >> 0),
     (VUINT32) ((0x2F67A0E73EF14A52uLL) >> 32)},
    {(VUINT32) ((0x5D4D7F6BF623F1ABuLL) >> 0),
     (VUINT32) ((0x5D4D7F6BF623F1ABuLL) >> 32)}},
   {{(VUINT32) ((0x8B5D49EEB1FAF97CuLL) >> 0),
     (VUINT32) ((0x8B5D49EEB1FAF97CuLL) >> 32)},
    {(VUINT32) ((0x5ECF41CE7DE294A4uLL) >> 0),
     (VUINT32) ((0x5ECF41CE7DE294A4uLL) >> 32)},
    {(VUINT32) ((0xBA9AFED7EC47E357uLL) >> 0),
     (VUINT32) ((0xBA9AFED7EC47E357uLL) >> 32)}},
   {{(VUINT32) ((0x16BA93DD63F5F2F8uLL) >> 0),
     (VUINT32) ((0x16BA93DD63F5F2F8uLL) >> 32)},
    {(VUINT32) ((0xBD9E839CFBC52949uLL) >> 0),
     (VUINT32) ((0xBD9E839CFBC52949uLL) >> 32)},
    {(VUINT32) ((0x7535FDAFD88FC6AEuLL) >> 0),
     (VUINT32) ((0x7535FDAFD88FC6AEuLL) >> 32)}},
   {{(VUINT32) ((0x2D7527BAC7EBE5F1uLL) >> 0),
     (VUINT32) ((0x2D7527BAC7EBE5F1uLL) >> 32)},
    {(VUINT32) ((0x7B3D0739F78A5292uLL) >> 0),
     (VUINT32) ((0x7B3D0739F78A5292uLL) >> 32)},
    {(VUINT32) ((0xEA6BFB5FB11F8D5DuLL) >> 0),
     (VUINT32) ((0xEA6BFB5FB11F8D5DuLL) >> 32)}},
   {{(VUINT32) ((0x5AEA4F758FD7CBE2uLL) >> 0),
     (VUINT32) ((0x5AEA4F758FD7CBE2uLL) >> 32)},
    {(VUINT32) ((0xF67A0E73EF14A525uLL) >> 0),
     (VUINT32) ((0xF67A0E73EF14A525uLL) >> 32)},
    {(VUINT32) ((0xD4D7F6BF623F1ABAuLL) >> 0),
     (VUINT32) ((0xD4D7F6BF623F1ABAuLL) >> 32)}},
   {{(VUINT32) ((0xB5D49EEB1FAF97C5uLL) >> 0),
     (VUINT32) ((0xB5D49EEB1FAF97C5uLL) >> 32)},
    {(VUINT32) ((0xECF41CE7DE294A4BuLL) >> 0),
     (VUINT32) ((0xECF41CE7DE294A4BuLL) >> 32)},
    {(VUINT32) ((0xA9AFED7EC47E3574uLL) >> 0),
     (VUINT32) ((0xA9AFED7EC47E3574uLL) >> 32)}},
   {{(VUINT32) ((0x6BA93DD63F5F2F8BuLL) >> 0),
     (VUINT32) ((0x6BA93DD63F5F2F8BuLL) >> 32)},
    {(VUINT32) ((0xD9E839CFBC529497uLL) >> 0),
     (VUINT32) ((0xD9E839CFBC529497uLL) >> 32)},
    {(VUINT32) ((0x535FDAFD88FC6AE8uLL) >> 0),
     (VUINT32) ((0x535FDAFD88FC6AE8uLL) >> 32)}},
   {{(VUINT32) ((0xD7527BAC7EBE5F17uLL) >> 0),
     (VUINT32) ((0xD7527BAC7EBE5F17uLL) >> 32)},
    {(VUINT32) ((0xB3D0739F78A5292EuLL) >> 0),
     (VUINT32) ((0xB3D0739F78A5292EuLL) >> 32)},
    {(VUINT32) ((0xA6BFB5FB11F8D5D0uLL) >> 0),
     (VUINT32) ((0xA6BFB5FB11F8D5D0uLL) >> 32)}},
   {{(VUINT32) ((0xAEA4F758FD7CBE2FuLL) >> 0),
     (VUINT32) ((0xAEA4F758FD7CBE2FuLL) >> 32)},
    {(VUINT32) ((0x67A0E73EF14A525DuLL) >> 0),
     (VUINT32) ((0x67A0E73EF14A525DuLL) >> 32)},
    {(VUINT32) ((0x4D7F6BF623F1ABA1uLL) >> 0),
     (VUINT32) ((0x4D7F6BF623F1ABA1uLL) >> 32)}},
   {{(VUINT32) ((0x5D49EEB1FAF97C5EuLL) >> 0),
     (VUINT32) ((0x5D49EEB1FAF97C5EuLL) >> 32)},
    {(VUINT32) ((0xCF41CE7DE294A4BAuLL) >> 0),
     (VUINT32) ((0xCF41CE7DE294A4BAuLL) >> 32)},
    {(VUINT32) ((0x9AFED7EC47E35742uLL) >> 0),
     (VUINT32) ((0x9AFED7EC47E35742uLL) >> 32)}},
   {{(VUINT32) ((0xBA93DD63F5F2F8BDuLL) >> 0),
     (VUINT32) ((0xBA93DD63F5F2F8BDuLL) >> 32)},
    {(VUINT32) ((0x9E839CFBC5294975uLL) >> 0),
     (VUINT32) ((0x9E839CFBC5294975uLL) >> 32)},
    {(VUINT32) ((0x35FDAFD88FC6AE84uLL) >> 0),
     (VUINT32) ((0x35FDAFD88FC6AE84uLL) >> 32)}},
   {{(VUINT32) ((0x7527BAC7EBE5F17BuLL) >> 0),
     (VUINT32) ((0x7527BAC7EBE5F17BuLL) >> 32)},
    {(VUINT32) ((0x3D0739F78A5292EAuLL) >> 0),
     (VUINT32) ((0x3D0739F78A5292EAuLL) >> 32)},
    {(VUINT32) ((0x6BFB5FB11F8D5D08uLL) >> 0),
     (VUINT32) ((0x6BFB5FB11F8D5D08uLL) >> 32)}},
   {{(VUINT32) ((0xEA4F758FD7CBE2F6uLL) >> 0),
     (VUINT32) ((0xEA4F758FD7CBE2F6uLL) >> 32)},
    {(VUINT32) ((0x7A0E73EF14A525D4uLL) >> 0),
     (VUINT32) ((0x7A0E73EF14A525D4uLL) >> 32)},
    {(VUINT32) ((0xD7F6BF623F1ABA10uLL) >> 0),
     (VUINT32) ((0xD7F6BF623F1ABA10uLL) >> 32)}},
   {{(VUINT32) ((0xD49EEB1FAF97C5ECuLL) >> 0),
     (VUINT32) ((0xD49EEB1FAF97C5ECuLL) >> 32)},
    {(VUINT32) ((0xF41CE7DE294A4BA9uLL) >> 0),
     (VUINT32) ((0xF41CE7DE294A4BA9uLL) >> 32)},
    {(VUINT32) ((0xAFED7EC47E357421uLL) >> 0),
     (VUINT32) ((0xAFED7EC47E357421uLL) >> 32)}},
   {{(VUINT32) ((0xA93DD63F5F2F8BD9uLL) >> 0),
     (VUINT32) ((0xA93DD63F5F2F8BD9uLL) >> 32)},
    {(VUINT32) ((0xE839CFBC52949753uLL) >> 0),
     (VUINT32) ((0xE839CFBC52949753uLL) >> 32)},
    {(VUINT32) ((0x5FDAFD88FC6AE842uLL) >> 0),
     (VUINT32) ((0x5FDAFD88FC6AE842uLL) >> 32)}},
   {{(VUINT32) ((0x527BAC7EBE5F17B3uLL) >> 0),
     (VUINT32) ((0x527BAC7EBE5F17B3uLL) >> 32)},
    {(VUINT32) ((0xD0739F78A5292EA6uLL) >> 0),
     (VUINT32) ((0xD0739F78A5292EA6uLL) >> 32)},
    {(VUINT32) ((0xBFB5FB11F8D5D085uLL) >> 0),
     (VUINT32) ((0xBFB5FB11F8D5D085uLL) >> 32)}},
   {{(VUINT32) ((0xA4F758FD7CBE2F67uLL) >> 0),
     (VUINT32) ((0xA4F758FD7CBE2F67uLL) >> 32)},
    {(VUINT32) ((0xA0E73EF14A525D4DuLL) >> 0),
     (VUINT32) ((0xA0E73EF14A525D4DuLL) >> 32)},
    {(VUINT32) ((0x7F6BF623F1ABA10AuLL) >> 0),
     (VUINT32) ((0x7F6BF623F1ABA10AuLL) >> 32)}},
   {{(VUINT32) ((0x49EEB1FAF97C5ECFuLL) >> 0),
     (VUINT32) ((0x49EEB1FAF97C5ECFuLL) >> 32)},
    {(VUINT32) ((0x41CE7DE294A4BA9AuLL) >> 0),
     (VUINT32) ((0x41CE7DE294A4BA9AuLL) >> 32)},
    {(VUINT32) ((0xFED7EC47E3574215uLL) >> 0),
     (VUINT32) ((0xFED7EC47E3574215uLL) >> 32)}},
   {{(VUINT32) ((0x93DD63F5F2F8BD9EuLL) >> 0),
     (VUINT32) ((0x93DD63F5F2F8BD9EuLL) >> 32)},
    {(VUINT32) ((0x839CFBC529497535uLL) >> 0),
     (VUINT32) ((0x839CFBC529497535uLL) >> 32)},
    {(VUINT32) ((0xFDAFD88FC6AE842BuLL) >> 0),
     (VUINT32) ((0xFDAFD88FC6AE842BuLL) >> 32)}},
   {{(VUINT32) ((0x27BAC7EBE5F17B3DuLL) >> 0),
     (VUINT32) ((0x27BAC7EBE5F17B3DuLL) >> 32)},
    {(VUINT32) ((0x0739F78A5292EA6BuLL) >> 0),
     (VUINT32) ((0x0739F78A5292EA6BuLL) >> 32)},
    {(VUINT32) ((0xFB5FB11F8D5D0856uLL) >> 0),
     (VUINT32) ((0xFB5FB11F8D5D0856uLL) >> 32)}},
   {{(VUINT32) ((0x4F758FD7CBE2F67AuLL) >> 0),
     (VUINT32) ((0x4F758FD7CBE2F67AuLL) >> 32)},
    {(VUINT32) ((0x0E73EF14A525D4D7uLL) >> 0),
     (VUINT32) ((0x0E73EF14A525D4D7uLL) >> 32)},
    {(VUINT32) ((0xF6BF623F1ABA10ACuLL) >> 0),
     (VUINT32) ((0xF6BF623F1ABA10ACuLL) >> 32)}},
   {{(VUINT32) ((0x9EEB1FAF97C5ECF4uLL) >> 0),
     (VUINT32) ((0x9EEB1FAF97C5ECF4uLL) >> 32)},
    {(VUINT32) ((0x1CE7DE294A4BA9AFuLL) >> 0),
     (VUINT32) ((0x1CE7DE294A4BA9AFuLL) >> 32)},
    {(VUINT32) ((0xED7EC47E35742158uLL) >> 0),
     (VUINT32) ((0xED7EC47E35742158uLL) >> 32)}}
   },
};

// Table common to sin, cos, and sincos
__constant _iml_dp_union_t _vmldSinCosHATab[274] = {

  {{0x00000000u, 0x00000000u}}, {{0x00000000u, 0x00000000u}},
  {{0x00000000u, 0x00000000u}}, {{0x00000000u, 0x3FF00000u}},
  {{0x176D6D31u, 0xBF73B92Eu}}, {{0xBC29B42Cu, 0x3FB917A6u}},
  {{0xE0000000u, 0xBC3E2718u}}, {{0x00000000u, 0x3FF00000u}},
  {{0x011469FBu, 0xBF93AD06u}}, {{0x3C69A60Bu, 0x3FC8F8B8u}},
  {{0xC0000000u, 0xBC626D19u}}, {{0x00000000u, 0x3FF00000u}},
  {{0x939D225Au, 0xBFA60BEAu}}, {{0x2ED59F06u, 0x3FD29406u}},
  {{0xA0000000u, 0xBC75D28Du}}, {{0x00000000u, 0x3FF00000u}},
  {{0x866B95CFu, 0xBFB37CA1u}}, {{0xA6AEA963u, 0x3FD87DE2u}},
  {{0xE0000000u, 0xBC672CEDu}}, {{0x00000000u, 0x3FF00000u}},
  {{0x73FA1279u, 0xBFBE3A68u}}, {{0x3806F63Bu, 0x3FDE2B5Du}},
  {{0x20000000u, 0x3C5E0D89u}}, {{0x00000000u, 0x3FF00000u}},
  {{0x5BC57974u, 0xBFC59267u}}, {{0x39AE68C8u, 0x3FE1C73Bu}},
  {{0x20000000u, 0x3C8B25DDu}}, {{0x00000000u, 0x3FF00000u}},
  {{0x53ABA2FDu, 0xBFCD0DFEu}}, {{0x25091DD6u, 0x3FE44CF3u}},
  {{0x20000000u, 0x3C68076Au}}, {{0x00000000u, 0x3FF00000u}},
  {{0x99FCEF32u, 0x3FCA8279u}}, {{0x667F3BCDu, 0x3FE6A09Eu}},
  {{0x20000000u, 0xBC8BDD34u}}, {{0x00000000u, 0x3FE00000u}},
  {{0x94247758u, 0x3FC133CCu}}, {{0x6B151741u, 0x3FE8BC80u}},
  {{0x20000000u, 0xBC82C5E1u}}, {{0x00000000u, 0x3FE00000u}},
  {{0x9AE68C87u, 0x3FAC73B3u}}, {{0x290EA1A3u, 0x3FEA9B66u}},
  {{0xE0000000u, 0x3C39F630u}}, {{0x00000000u, 0x3FE00000u}},
  {{0x7F909C4Eu, 0xBF9D4A2Cu}}, {{0xF180BDB1u, 0x3FEC38B2u}},
  {{0x80000000u, 0xBC76E0B1u}}, {{0x00000000u, 0x3FE00000u}},
  {{0x65455A75u, 0xBFBE0875u}}, {{0xCF328D46u, 0x3FED906Bu}},
  {{0x20000000u, 0x3C7457E6u}}, {{0x00000000u, 0x3FE00000u}},
  {{0x76ACF82Du, 0x3FA4A031u}}, {{0x56C62DDAu, 0x3FEE9F41u}},
  {{0xE0000000u, 0x3C8760B1u}}, {{0x00000000u, 0x3FD00000u}},
  {{0x0E5967D5u, 0xBFAC1D1Fu}}, {{0xCFF75CB0u, 0x3FEF6297u}},
  {{0x20000000u, 0x3C756217u}}, {{0x00000000u, 0x3FD00000u}},
  {{0x0F592F50u, 0xBF9BA165u}}, {{0xA3D12526u, 0x3FEFD88Du}},
  {{0x40000000u, 0xBC887DF6u}}, {{0x00000000u, 0x3FC00000u}},
  {{0x00000000u, 0x00000000u}}, {{0x00000000u, 0x3FF00000u}},
  {{0x00000000u, 0x00000000u}}, {{0x00000000u, 0x80000000u}},
  {{0x0F592F50u, 0x3F9BA165u}}, {{0xA3D12526u, 0x3FEFD88Du}},
  {{0x40000000u, 0xBC887DF6u}}, {{0x00000000u, 0xBFC00000u}},
  {{0x0E5967D5u, 0x3FAC1D1Fu}}, {{0xCFF75CB0u, 0x3FEF6297u}},
  {{0x20000000u, 0x3C756217u}}, {{0x00000000u, 0xBFD00000u}},
  {{0x76ACF82Du, 0xBFA4A031u}}, {{0x56C62DDAu, 0x3FEE9F41u}},
  {{0xE0000000u, 0x3C8760B1u}}, {{0x00000000u, 0xBFD00000u}},
  {{0x65455A75u, 0x3FBE0875u}}, {{0xCF328D46u, 0x3FED906Bu}},
  {{0x20000000u, 0x3C7457E6u}}, {{0x00000000u, 0xBFE00000u}},
  {{0x7F909C4Eu, 0x3F9D4A2Cu}}, {{0xF180BDB1u, 0x3FEC38B2u}},
  {{0x80000000u, 0xBC76E0B1u}}, {{0x00000000u, 0xBFE00000u}},
  {{0x9AE68C87u, 0xBFAC73B3u}}, {{0x290EA1A3u, 0x3FEA9B66u}},
  {{0xE0000000u, 0x3C39F630u}}, {{0x00000000u, 0xBFE00000u}},
  {{0x94247758u, 0xBFC133CCu}}, {{0x6B151741u, 0x3FE8BC80u}},
  {{0x20000000u, 0xBC82C5E1u}}, {{0x00000000u, 0xBFE00000u}},
  {{0x99FCEF32u, 0xBFCA8279u}}, {{0x667F3BCDu, 0x3FE6A09Eu}},
  {{0x20000000u, 0xBC8BDD34u}}, {{0x00000000u, 0xBFE00000u}},
  {{0x53ABA2FDu, 0x3FCD0DFEu}}, {{0x25091DD6u, 0x3FE44CF3u}},
  {{0x20000000u, 0x3C68076Au}}, {{0x00000000u, 0xBFF00000u}},
  {{0x5BC57974u, 0x3FC59267u}}, {{0x39AE68C8u, 0x3FE1C73Bu}},
  {{0x20000000u, 0x3C8B25DDu}}, {{0x00000000u, 0xBFF00000u}},
  {{0x73FA1279u, 0x3FBE3A68u}}, {{0x3806F63Bu, 0x3FDE2B5Du}},
  {{0x20000000u, 0x3C5E0D89u}}, {{0x00000000u, 0xBFF00000u}},
  {{0x866B95CFu, 0x3FB37CA1u}}, {{0xA6AEA963u, 0x3FD87DE2u}},
  {{0xE0000000u, 0xBC672CEDu}}, {{0x00000000u, 0xBFF00000u}},
  {{0x939D225Au, 0x3FA60BEAu}}, {{0x2ED59F06u, 0x3FD29406u}},
  {{0xA0000000u, 0xBC75D28Du}}, {{0x00000000u, 0xBFF00000u}},
  {{0x011469FBu, 0x3F93AD06u}}, {{0x3C69A60Bu, 0x3FC8F8B8u}},
  {{0xC0000000u, 0xBC626D19u}}, {{0x00000000u, 0xBFF00000u}},
  {{0x176D6D31u, 0x3F73B92Eu}}, {{0xBC29B42Cu, 0x3FB917A6u}},
  {{0xE0000000u, 0xBC3E2718u}}, {{0x00000000u, 0xBFF00000u}},
  {{0x00000000u, 0x00000000u}}, {{0x00000000u, 0x00000000u}},
  {{0x00000000u, 0x00000000u}}, {{0x00000000u, 0xBFF00000u}},
  {{0x176D6D31u, 0x3F73B92Eu}}, {{0xBC29B42Cu, 0xBFB917A6u}},
  {{0xE0000000u, 0x3C3E2718u}}, {{0x00000000u, 0xBFF00000u}},
  {{0x011469FBu, 0x3F93AD06u}}, {{0x3C69A60Bu, 0xBFC8F8B8u}},
  {{0xC0000000u, 0x3C626D19u}}, {{0x00000000u, 0xBFF00000u}},
  {{0x939D225Au, 0x3FA60BEAu}}, {{0x2ED59F06u, 0xBFD29406u}},
  {{0xA0000000u, 0x3C75D28Du}}, {{0x00000000u, 0xBFF00000u}},
  {{0x866B95CFu, 0x3FB37CA1u}}, {{0xA6AEA963u, 0xBFD87DE2u}},
  {{0xE0000000u, 0x3C672CEDu}}, {{0x00000000u, 0xBFF00000u}},
  {{0x73FA1279u, 0x3FBE3A68u}}, {{0x3806F63Bu, 0xBFDE2B5Du}},
  {{0x20000000u, 0xBC5E0D89u}}, {{0x00000000u, 0xBFF00000u}},
  {{0x5BC57974u, 0x3FC59267u}}, {{0x39AE68C8u, 0xBFE1C73Bu}},
  {{0x20000000u, 0xBC8B25DDu}}, {{0x00000000u, 0xBFF00000u}},
  {{0x53ABA2FDu, 0x3FCD0DFEu}}, {{0x25091DD6u, 0xBFE44CF3u}},
  {{0x20000000u, 0xBC68076Au}}, {{0x00000000u, 0xBFF00000u}},
  {{0x99FCEF32u, 0xBFCA8279u}}, {{0x667F3BCDu, 0xBFE6A09Eu}},
  {{0x20000000u, 0x3C8BDD34u}}, {{0x00000000u, 0xBFE00000u}},
  {{0x94247758u, 0xBFC133CCu}}, {{0x6B151741u, 0xBFE8BC80u}},
  {{0x20000000u, 0x3C82C5E1u}}, {{0x00000000u, 0xBFE00000u}},
  {{0x9AE68C87u, 0xBFAC73B3u}}, {{0x290EA1A3u, 0xBFEA9B66u}},
  {{0xE0000000u, 0xBC39F630u}}, {{0x00000000u, 0xBFE00000u}},
  {{0x7F909C4Eu, 0x3F9D4A2Cu}}, {{0xF180BDB1u, 0xBFEC38B2u}},
  {{0x80000000u, 0x3C76E0B1u}}, {{0x00000000u, 0xBFE00000u}},
  {{0x65455A75u, 0x3FBE0875u}}, {{0xCF328D46u, 0xBFED906Bu}},
  {{0x20000000u, 0xBC7457E6u}}, {{0x00000000u, 0xBFE00000u}},
  {{0x76ACF82Du, 0xBFA4A031u}}, {{0x56C62DDAu, 0xBFEE9F41u}},
  {{0xE0000000u, 0xBC8760B1u}}, {{0x00000000u, 0xBFD00000u}},
  {{0x0E5967D5u, 0x3FAC1D1Fu}}, {{0xCFF75CB0u, 0xBFEF6297u}},
  {{0x20000000u, 0xBC756217u}}, {{0x00000000u, 0xBFD00000u}},
  {{0x0F592F50u, 0x3F9BA165u}}, {{0xA3D12526u, 0xBFEFD88Du}},
  {{0x40000000u, 0x3C887DF6u}}, {{0x00000000u, 0xBFC00000u}},
  {{0x00000000u, 0x80000000u}}, {{0x00000000u, 0xBFF00000u}},
  {{0x00000000u, 0x00000000u}}, {{0x00000000u, 0x80000000u}},
  {{0x0F592F50u, 0xBF9BA165u}}, {{0xA3D12526u, 0xBFEFD88Du}},
  {{0x40000000u, 0x3C887DF6u}}, {{0x00000000u, 0x3FC00000u}},
  {{0x0E5967D5u, 0xBFAC1D1Fu}}, {{0xCFF75CB0u, 0xBFEF6297u}},
  {{0x20000000u, 0xBC756217u}}, {{0x00000000u, 0x3FD00000u}},
  {{0x76ACF82Du, 0x3FA4A031u}}, {{0x56C62DDAu, 0xBFEE9F41u}},
  {{0xE0000000u, 0xBC8760B1u}}, {{0x00000000u, 0x3FD00000u}},
  {{0x65455A75u, 0xBFBE0875u}}, {{0xCF328D46u, 0xBFED906Bu}},
  {{0x20000000u, 0xBC7457E6u}}, {{0x00000000u, 0x3FE00000u}},
  {{0x7F909C4Eu, 0xBF9D4A2Cu}}, {{0xF180BDB1u, 0xBFEC38B2u}},
  {{0x80000000u, 0x3C76E0B1u}}, {{0x00000000u, 0x3FE00000u}},
  {{0x9AE68C87u, 0x3FAC73B3u}}, {{0x290EA1A3u, 0xBFEA9B66u}},
  {{0xE0000000u, 0xBC39F630u}}, {{0x00000000u, 0x3FE00000u}},
  {{0x94247758u, 0x3FC133CCu}}, {{0x6B151741u, 0xBFE8BC80u}},
  {{0x20000000u, 0x3C82C5E1u}}, {{0x00000000u, 0x3FE00000u}},
  {{0x99FCEF32u, 0x3FCA8279u}}, {{0x667F3BCDu, 0xBFE6A09Eu}},
  {{0x20000000u, 0x3C8BDD34u}}, {{0x00000000u, 0x3FE00000u}},
  {{0x53ABA2FDu, 0xBFCD0DFEu}}, {{0x25091DD6u, 0xBFE44CF3u}},
  {{0x20000000u, 0xBC68076Au}}, {{0x00000000u, 0x3FF00000u}},
  {{0x5BC57974u, 0xBFC59267u}}, {{0x39AE68C8u, 0xBFE1C73Bu}},
  {{0x20000000u, 0xBC8B25DDu}}, {{0x00000000u, 0x3FF00000u}},
  {{0x73FA1279u, 0xBFBE3A68u}}, {{0x3806F63Bu, 0xBFDE2B5Du}},
  {{0x20000000u, 0xBC5E0D89u}}, {{0x00000000u, 0x3FF00000u}},
  {{0x866B95CFu, 0xBFB37CA1u}}, {{0xA6AEA963u, 0xBFD87DE2u}},
  {{0xE0000000u, 0x3C672CEDu}}, {{0x00000000u, 0x3FF00000u}},
  {{0x939D225Au, 0xBFA60BEAu}}, {{0x2ED59F06u, 0xBFD29406u}},
  {{0xA0000000u, 0x3C75D28Du}}, {{0x00000000u, 0x3FF00000u}},
  {{0x011469FBu, 0xBF93AD06u}}, {{0x3C69A60Bu, 0xBFC8F8B8u}},
  {{0xC0000000u, 0x3C626D19u}}, {{0x00000000u, 0x3FF00000u}},
  {{0x176D6D31u, 0xBF73B92Eu}}, {{0xBC29B42Cu, 0xBFB917A6u}},
  {{0xE0000000u, 0x3C3E2718u}}, {{0x00000000u, 0x3FF00000u}},

  {{0x6DC9C883u, 0x40245F30u}},
  {{0x00000000u, 0x43380000u}},

  {{0x54400000u, 0x3FB921FBu}},
  {{0x1A600000u, 0x3D90B461u}},
  {{0x2E037073u, 0x3B63198Au}},

  {{0x55555555u, 0xBFC55555u}},
  {{0x11111111u, 0x3F811111u}},
  {{0x1A01A01Au, 0xBF2A01A0u}},
  {{0xA556C734u, 0x3EC71DE3u}},

  {{0x00000000u, 0xBFE00000u}},
  {{0x55555555u, 0x3FA55555u}},
  {{0x16C16C17u, 0xBF56C16Cu}},
  {{0x1A01A01Au, 0x3EFA01A0u}},   // 268

  {{0x00000000u, 0x43600000u}},   // 269 - not used by cos
  {{0x00000000u, 0x3C800000u}},   // 270 - not used by cos

  {{0x00000000u, 0x3FF00000u}},   // 271
  {{0x00000000u, 0x00000000u}},   // 272
  {{0x00000000u, 0x7FF00000u}}    // 273
};

// Table common to sincos and sin
typedef struct
{
  VUINT32 _dT[512][4][2];
  VUINT32 _dAbsMask[2];
  VUINT32 _dReductionRangeVal[2];
  VUINT32 _dRangeVal[2];
  VUINT32 _dPIu[2];
  VUINT32 _dRShifter[2];
  VUINT32 _lIndexMask[2];
  VUINT32 _l2pK_1[2];             // not used by sin()
  VUINT32 _dPIoHi[2];
  VUINT32 _dPIoLo[2];
  VUINT32 _dPIoTail[2];
  VUINT32 _dS1[2];
  VUINT32 _dS2[2];
  VUINT32 _dC1[2];
  VUINT32 _dC2[2];
  VUINT32 _dC3[2];
} dSinCosHA_Table_Type;

// Note: Has one additional entry compared to __ocl_svml_dsin_data_ha
__constant dSinCosHA_Table_Type __ocl_svml_dsincos_data_ha = {
  {
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF13BD2C8DA49511uLL) >> 0),
    (VUINT32) ((0xBF13BD2C8DA49511uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F8921D1FCDEC784uLL) >> 0),
    (VUINT32) ((0x3F8921D1FCDEC784uLL) >> 32)},
    {(VUINT32) ((0x3C29878EA0000000uLL) >> 0),
    (VUINT32) ((0x3C29878EA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF33BCFBD9979A27uLL) >> 0),
    (VUINT32) ((0xBF33BCFBD9979A27uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F992155F7A3667EuLL) >> 0),
    (VUINT32) ((0x3F992155F7A3667EuLL) >> 32)},
    {(VUINT32) ((0xBBFB1D6300000000uLL) >> 0),
    (VUINT32) ((0xBBFB1D6300000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF46344004228D8BuLL) >> 0),
    (VUINT32) ((0xBF46344004228D8BuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA2D865759455CDuLL) >> 0),
    (VUINT32) ((0x3FA2D865759455CDuLL) >> 32)},
    {(VUINT32) ((0x3C2686F640000000uLL) >> 0),
    (VUINT32) ((0x3C2686F640000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF53BC390D250439uLL) >> 0),
    (VUINT32) ((0xBF53BC390D250439uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA91F65F10DD814uLL) >> 0),
    (VUINT32) ((0x3FA91F65F10DD814uLL) >> 32)},
    {(VUINT32) ((0xBC2912BD00000000uLL) >> 0),
    (VUINT32) ((0xBC2912BD00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF5ED534E31CA57FuLL) >> 0),
    (VUINT32) ((0xBF5ED534E31CA57FuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FAF656E79F820E0uLL) >> 0),
    (VUINT32) ((0x3FAF656E79F820E0uLL) >> 32)},
    {(VUINT32) ((0xBC22E1EBE0000000uLL) >> 0),
    (VUINT32) ((0xBC22E1EBE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF663252FE77C5EBuLL) >> 0),
    (VUINT32) ((0xBF663252FE77C5EBuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB2D52092CE19F6uLL) >> 0),
    (VUINT32) ((0x3FB2D52092CE19F6uLL) >> 32)},
    {(VUINT32) ((0xBC49A088A0000000uLL) >> 0),
    (VUINT32) ((0xBC49A088A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF6E350342A4F6E6uLL) >> 0),
    (VUINT32) ((0xBF6E350342A4F6E6uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5F6D00A9AA419uLL) >> 0),
    (VUINT32) ((0x3FB5F6D00A9AA419uLL) >> 32)},
    {(VUINT32) ((0xBC4F4022C0000000uLL) >> 0),
    (VUINT32) ((0xBC4F4022C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF73B92E176D6D31uLL) >> 0),
    (VUINT32) ((0xBF73B92E176D6D31uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB917A6BC29B42CuLL) >> 0),
    (VUINT32) ((0x3FB917A6BC29B42CuLL) >> 32)},
    {(VUINT32) ((0xBC3E2718C0000000uLL) >> 0),
    (VUINT32) ((0xBC3E2718C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF78F501492CC296uLL) >> 0),
    (VUINT32) ((0xBF78F501492CC296uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBC3785C79EC2D5uLL) >> 0),
    (VUINT32) ((0x3FBC3785C79EC2D5uLL) >> 32)},
    {(VUINT32) ((0xBC24F39DE0000000uLL) >> 0),
    (VUINT32) ((0xBC24F39DE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF7ECDC78F30165CuLL) >> 0),
    (VUINT32) ((0xBF7ECDC78F30165CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBF564E56A9730EuLL) >> 0),
    (VUINT32) ((0x3FBF564E56A9730EuLL) >> 32)},
    {(VUINT32) ((0x3C4A270460000000uLL) >> 0),
    (VUINT32) ((0x3C4A270460000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF82A1A39A8A2FB7uLL) >> 0),
    (VUINT32) ((0xBF82A1A39A8A2FB7uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC139F0CEDAF577uLL) >> 0),
    (VUINT32) ((0x3FC139F0CEDAF577uLL) >> 32)},
    {(VUINT32) ((0xBC65234340000000uLL) >> 0),
    (VUINT32) ((0xBC65234340000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF862AA03DD6BA58uLL) >> 0),
    (VUINT32) ((0xBF862AA03DD6BA58uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC2C8106E8E613AuLL) >> 0),
    (VUINT32) ((0x3FC2C8106E8E613AuLL) >> 32)},
    {(VUINT32) ((0x3C513000A0000000uLL) >> 0),
    (VUINT32) ((0x3C513000A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8A01B6CDBD995EuLL) >> 0),
    (VUINT32) ((0xBF8A01B6CDBD995EuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC45576B1293E5AuLL) >> 0),
    (VUINT32) ((0x3FC45576B1293E5AuLL) >> 32)},
    {(VUINT32) ((0xBC5285A240000000uLL) >> 0),
    (VUINT32) ((0xBC5285A240000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8E26C163AD15B3uLL) >> 0),
    (VUINT32) ((0xBF8E26C163AD15B3uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC5E214448B3FC6uLL) >> 0),
    (VUINT32) ((0x3FC5E214448B3FC6uLL) >> 32)},
    {(VUINT32) ((0x3C6531FF60000000uLL) >> 0),
    (VUINT32) ((0x3C6531FF60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF914CCB8BDBF114uLL) >> 0),
    (VUINT32) ((0xBF914CCB8BDBF114uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC76DD9DE50BF31uLL) >> 0),
    (VUINT32) ((0x3FC76DD9DE50BF31uLL) >> 32)},
    {(VUINT32) ((0x3C61D5EEE0000000uLL) >> 0),
    (VUINT32) ((0x3C61D5EEE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF93AD06011469FBuLL) >> 0),
    (VUINT32) ((0xBF93AD06011469FBuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC8F8B83C69A60BuLL) >> 0),
    (VUINT32) ((0x3FC8F8B83C69A60BuLL) >> 32)},
    {(VUINT32) ((0xBC626D19A0000000uLL) >> 0),
    (VUINT32) ((0xBC626D19A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9633F89E9A1A66uLL) >> 0),
    (VUINT32) ((0xBF9633F89E9A1A66uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCA82A025B00451uLL) >> 0),
    (VUINT32) ((0x3FCA82A025B00451uLL) >> 32)},
    {(VUINT32) ((0xBC687905E0000000uLL) >> 0),
    (VUINT32) ((0xBC687905E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF98E18A73634EE7uLL) >> 0),
    (VUINT32) ((0xBF98E18A73634EE7uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCC0B826A7E4F63uLL) >> 0),
    (VUINT32) ((0x3FCC0B826A7E4F63uLL) >> 32)},
    {(VUINT32) ((0xBC1AF14380000000uLL) >> 0),
    (VUINT32) ((0xBC1AF14380000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9BB5A11138A4C9uLL) >> 0),
    (VUINT32) ((0xBF9BB5A11138A4C9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCD934FE5454311uLL) >> 0),
    (VUINT32) ((0x3FCD934FE5454311uLL) >> 32)},
    {(VUINT32) ((0x3C675B9220000000uLL) >> 0),
    (VUINT32) ((0x3C675B9220000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9EB0208DB9E51BuLL) >> 0),
    (VUINT32) ((0xBF9EB0208DB9E51BuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCF19F97B215F1BuLL) >> 0),
    (VUINT32) ((0x3FCF19F97B215F1BuLL) >> 32)},
    {(VUINT32) ((0xBC642DEEE0000000uLL) >> 0),
    (VUINT32) ((0xBC642DEEE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA0E875C1B8C3DAuLL) >> 0),
    (VUINT32) ((0xBFA0E875C1B8C3DAuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD04FB80E37FDAEuLL) >> 0),
    (VUINT32) ((0x3FD04FB80E37FDAEuLL) >> 32)},
    {(VUINT32) ((0xBC0412CDA0000000uLL) >> 0),
    (VUINT32) ((0xBC0412CDA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA28BF1897B69CCuLL) >> 0),
    (VUINT32) ((0xBFA28BF1897B69CCuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD111D262B1F677uLL) >> 0),
    (VUINT32) ((0x3FD111D262B1F677uLL) >> 32)},
    {(VUINT32) ((0x3C7824C200000000uLL) >> 0),
    (VUINT32) ((0x3C7824C200000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA44273720F48BCuLL) >> 0),
    (VUINT32) ((0xBFA44273720F48BCuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD1D3443F4CDB3EuLL) >> 0),
    (VUINT32) ((0x3FD1D3443F4CDB3EuLL) >> 32)},
    {(VUINT32) ((0xBC6720D400000000uLL) >> 0),
    (VUINT32) ((0xBC6720D400000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA60BEA939D225AuLL) >> 0),
    (VUINT32) ((0xBFA60BEA939D225AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD294062ED59F06uLL) >> 0),
    (VUINT32) ((0x3FD294062ED59F06uLL) >> 32)},
    {(VUINT32) ((0xBC75D28DA0000000uLL) >> 0),
    (VUINT32) ((0xBC75D28DA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA7E8454B32EF34uLL) >> 0),
    (VUINT32) ((0xBFA7E8454B32EF34uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD35410C2E18152uLL) >> 0),
    (VUINT32) ((0x3FD35410C2E18152uLL) >> 32)},
    {(VUINT32) ((0xBC73CB0020000000uLL) >> 0),
    (VUINT32) ((0xBC73CB0020000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA9D7713B71EEE1uLL) >> 0),
    (VUINT32) ((0xBFA9D7713B71EEE1uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD4135C94176601uLL) >> 0),
    (VUINT32) ((0x3FD4135C94176601uLL) >> 32)},
    {(VUINT32) ((0x3C70C97C40000000uLL) >> 0),
    (VUINT32) ((0x3C70C97C40000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFABD95B4D43E819uLL) >> 0),
    (VUINT32) ((0xBFABD95B4D43E819uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD4D1E24278E76AuLL) >> 0),
    (VUINT32) ((0x3FD4D1E24278E76AuLL) >> 32)},
    {(VUINT32) ((0x3C62417200000000uLL) >> 0),
    (VUINT32) ((0x3C62417200000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFADEDEFB09791B4uLL) >> 0),
    (VUINT32) ((0xBFADEDEFB09791B4uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD58F9A75AB1FDDuLL) >> 0),
    (VUINT32) ((0x3FD58F9A75AB1FDDuLL) >> 32)},
    {(VUINT32) ((0xBC1EFDC0C0000000uLL) >> 0),
    (VUINT32) ((0xBC1EFDC0C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB00A8CEE920EABuLL) >> 0),
    (VUINT32) ((0xBFB00A8CEE920EABuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD64C7DDD3F27C6uLL) >> 0),
    (VUINT32) ((0x3FD64C7DDD3F27C6uLL) >> 32)},
    {(VUINT32) ((0x3C510D2B40000000uLL) >> 0),
    (VUINT32) ((0x3C510D2B40000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB127624999EE1DuLL) >> 0),
    (VUINT32) ((0xBFB127624999EE1DuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD7088530FA459FuLL) >> 0),
    (VUINT32) ((0x3FD7088530FA459FuLL) >> 32)},
    {(VUINT32) ((0xBC744B19E0000000uLL) >> 0),
    (VUINT32) ((0xBC744B19E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB24D6CEE3AFB2AuLL) >> 0),
    (VUINT32) ((0xBFB24D6CEE3AFB2AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD7C3A9311DCCE7uLL) >> 0),
    (VUINT32) ((0x3FD7C3A9311DCCE7uLL) >> 32)},
    {(VUINT32) ((0x3C19A3F200000000uLL) >> 0),
    (VUINT32) ((0x3C19A3F200000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB37CA1866B95CFuLL) >> 0),
    (VUINT32) ((0xBFB37CA1866B95CFuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD87DE2A6AEA963uLL) >> 0),
    (VUINT32) ((0x3FD87DE2A6AEA963uLL) >> 32)},
    {(VUINT32) ((0xBC672CEDC0000000uLL) >> 0),
    (VUINT32) ((0xBC672CEDC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB4B4F461B0CBAAuLL) >> 0),
    (VUINT32) ((0xBFB4B4F461B0CBAAuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD9372A63BC93D7uLL) >> 0),
    (VUINT32) ((0x3FD9372A63BC93D7uLL) >> 32)},
    {(VUINT32) ((0x3C66843180000000uLL) >> 0),
    (VUINT32) ((0x3C66843180000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB5F6597591B633uLL) >> 0),
    (VUINT32) ((0xBFB5F6597591B633uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD9EF7943A8ED8AuLL) >> 0),
    (VUINT32) ((0x3FD9EF7943A8ED8AuLL) >> 32)},
    {(VUINT32) ((0x3C66DA8120000000uLL) >> 0),
    (VUINT32) ((0x3C66DA8120000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB740C45E0E5120uLL) >> 0),
    (VUINT32) ((0xBFB740C45E0E5120uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDAA6C82B6D3FCAuLL) >> 0),
    (VUINT32) ((0x3FDAA6C82B6D3FCAuLL) >> 32)},
    {(VUINT32) ((0xBC7D5F1060000000uLL) >> 0),
    (VUINT32) ((0xBC7D5F1060000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB894285E19C468uLL) >> 0),
    (VUINT32) ((0xBFB894285E19C468uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDB5D1009E15CC0uLL) >> 0),
    (VUINT32) ((0x3FDB5D1009E15CC0uLL) >> 32)},
    {(VUINT32) ((0x3C65B362C0000000uLL) >> 0),
    (VUINT32) ((0x3C65B362C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB9F07860181D1EuLL) >> 0),
    (VUINT32) ((0xBFB9F07860181D1EuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDC1249D8011EE7uLL) >> 0),
    (VUINT32) ((0x3FDC1249D8011EE7uLL) >> 32)},
    {(VUINT32) ((0xBC7813AAA0000000uLL) >> 0),
    (VUINT32) ((0xBC7813AAA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBB55A6F65F7058uLL) >> 0),
    (VUINT32) ((0xBFBB55A6F65F7058uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDCC66E9931C45EuLL) >> 0),
    (VUINT32) ((0x3FDCC66E9931C45EuLL) >> 32)},
    {(VUINT32) ((0x3C56850E40000000uLL) >> 0),
    (VUINT32) ((0x3C56850E40000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBCC3A65BBC6327uLL) >> 0),
    (VUINT32) ((0xBFBCC3A65BBC6327uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDD79775B86E389uLL) >> 0),
    (VUINT32) ((0x3FDD79775B86E389uLL) >> 32)},
    {(VUINT32) ((0x3C7550EC80000000uLL) >> 0),
    (VUINT32) ((0x3C7550EC80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBE3A6873FA1279uLL) >> 0),
    (VUINT32) ((0xBFBE3A6873FA1279uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDE2B5D3806F63BuLL) >> 0),
    (VUINT32) ((0x3FDE2B5D3806F63BuLL) >> 32)},
    {(VUINT32) ((0x3C5E0D8900000000uLL) >> 0),
    (VUINT32) ((0x3C5E0D8900000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBFB9DECC6D55B8uLL) >> 0),
    (VUINT32) ((0xBFBFB9DECC6D55B8uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDEDC1952EF78D6uLL) >> 0),
    (VUINT32) ((0x3FDEDC1952EF78D6uLL) >> 32)},
    {(VUINT32) ((0xBC7DD0F7C0000000uLL) >> 0),
    (VUINT32) ((0xBC7DD0F7C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC0A0FD4E41AB5AuLL) >> 0),
    (VUINT32) ((0xBFC0A0FD4E41AB5AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDF8BA4DBF89ABAuLL) >> 0),
    (VUINT32) ((0x3FDF8BA4DBF89ABAuLL) >> 32)},
    {(VUINT32) ((0xBC32EC1FC0000000uLL) >> 0),
    (VUINT32) ((0xBC32EC1FC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC169566329BCB7uLL) >> 0),
    (VUINT32) ((0xBFC169566329BCB7uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE01CFC874C3EB7uLL) >> 0),
    (VUINT32) ((0x3FE01CFC874C3EB7uLL) >> 32)},
    {(VUINT32) ((0xBC734A35E0000000uLL) >> 0),
    (VUINT32) ((0xBC734A35E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC235F2EB9A470AuLL) >> 0),
    (VUINT32) ((0xBFC235F2EB9A470AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE073879922FFEEuLL) >> 0),
    (VUINT32) ((0x3FE073879922FFEEuLL) >> 32)},
    {(VUINT32) ((0xBC8A5A0140000000uLL) >> 0),
    (VUINT32) ((0xBC8A5A0140000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC306CB042AA3BAuLL) >> 0),
    (VUINT32) ((0xBFC306CB042AA3BAuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE0C9704D5D898FuLL) >> 0),
    (VUINT32) ((0x3FE0C9704D5D898FuLL) >> 32)},
    {(VUINT32) ((0xBC88D3D7C0000000uLL) >> 0),
    (VUINT32) ((0xBC88D3D7C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC3DBD69FABF802uLL) >> 0),
    (VUINT32) ((0xBFC3DBD69FABF802uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE11EB3541B4B23uLL) >> 0),
    (VUINT32) ((0x3FE11EB3541B4B23uLL) >> 32)},
    {(VUINT32) ((0xBC8EF23B60000000uLL) >> 0),
    (VUINT32) ((0xBC8EF23B60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC4B50D8778ABBDuLL) >> 0),
    (VUINT32) ((0xBFC4B50D8778ABBDuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE1734D63DEDB49uLL) >> 0),
    (VUINT32) ((0x3FE1734D63DEDB49uLL) >> 32)},
    {(VUINT32) ((0xBC87EEF2C0000000uLL) >> 0),
    (VUINT32) ((0xBC87EEF2C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC592675BC57974uLL) >> 0),
    (VUINT32) ((0xBFC592675BC57974uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE1C73B39AE68C8uLL) >> 0),
    (VUINT32) ((0x3FE1C73B39AE68C8uLL) >> 32)},
    {(VUINT32) ((0x3C8B25DD20000000uLL) >> 0),
    (VUINT32) ((0x3C8B25DD20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC673DB93F41479uLL) >> 0),
    (VUINT32) ((0xBFC673DB93F41479uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE21A799933EB59uLL) >> 0),
    (VUINT32) ((0x3FE21A799933EB59uLL) >> 32)},
    {(VUINT32) ((0xBC83A7B160000000uLL) >> 0),
    (VUINT32) ((0xBC83A7B160000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC759617EE761F9uLL) >> 0),
    (VUINT32) ((0xBFC759617EE761F9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE26D054CDD12DFuLL) >> 0),
    (VUINT32) ((0x3FE26D054CDD12DFuLL) >> 32)},
    {(VUINT32) ((0xBC85DA7420000000uLL) >> 0),
    (VUINT32) ((0xBC85DA7420000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC842F0435941AFuLL) >> 0),
    (VUINT32) ((0xBFC842F0435941AFuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE2BEDB25FAF3EAuLL) >> 0),
    (VUINT32) ((0x3FE2BEDB25FAF3EAuLL) >> 32)},
    {(VUINT32) ((0xBC514981C0000000uLL) >> 0),
    (VUINT32) ((0xBC514981C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC9307EE031E2FDuLL) >> 0),
    (VUINT32) ((0xBFC9307EE031E2FDuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE30FF7FCE17035uLL) >> 0),
    (VUINT32) ((0x3FE30FF7FCE17035uLL) >> 32)},
    {(VUINT32) ((0xBC6EFCC620000000uLL) >> 0),
    (VUINT32) ((0xBC6EFCC620000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCA22042CE0A2F9uLL) >> 0),
    (VUINT32) ((0xBFCA22042CE0A2F9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE36058B10659F3uLL) >> 0),
    (VUINT32) ((0x3FE36058B10659F3uLL) >> 32)},
    {(VUINT32) ((0xBC81FCB3A0000000uLL) >> 0),
    (VUINT32) ((0xBC81FCB3A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCB1776D9B67013uLL) >> 0),
    (VUINT32) ((0xBFCB1776D9B67013uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE3AFFA292050B9uLL) >> 0),
    (VUINT32) ((0x3FE3AFFA292050B9uLL) >> 32)},
    {(VUINT32) ((0x3C7E3E25E0000000uLL) >> 0),
    (VUINT32) ((0x3C7E3E25E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCC10CD7041AFCCuLL) >> 0),
    (VUINT32) ((0xBFCC10CD7041AFCCuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE3FED9534556D4uLL) >> 0),
    (VUINT32) ((0x3FE3FED9534556D4uLL) >> 32)},
    {(VUINT32) ((0x3C83691660000000uLL) >> 0),
    (VUINT32) ((0x3C83691660000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCD0DFE53ABA2FDuLL) >> 0),
    (VUINT32) ((0xBFCD0DFE53ABA2FDuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE44CF325091DD6uLL) >> 0),
    (VUINT32) ((0x3FE44CF325091DD6uLL) >> 32)},
    {(VUINT32) ((0x3C68076A20000000uLL) >> 0),
    (VUINT32) ((0x3C68076A20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCE0EFFC1174505uLL) >> 0),
    (VUINT32) ((0xBFCE0EFFC1174505uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE49A449B9B0939uLL) >> 0),
    (VUINT32) ((0x3FE49A449B9B0939uLL) >> 32)},
    {(VUINT32) ((0xBC827EE160000000uLL) >> 0),
    (VUINT32) ((0xBC827EE160000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCF13C7D001A249uLL) >> 0),
    (VUINT32) ((0xBFCF13C7D001A249uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE4E6CABBE3E5E9uLL) >> 0),
    (VUINT32) ((0x3FE4E6CABBE3E5E9uLL) >> 32)},
    {(VUINT32) ((0x3C63C293E0000000uLL) >> 0),
    (VUINT32) ((0x3C63C293E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCFE3B38D5C5DC2uLL) >> 0),
    (VUINT32) ((0x3FCFE3B38D5C5DC2uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE5328292A35596uLL) >> 0),
    (VUINT32) ((0x3FE5328292A35596uLL) >> 32)},
    {(VUINT32) ((0xBC7A12EB80000000uLL) >> 0),
    (VUINT32) ((0xBC7A12EB80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCED77C89AABEBBuLL) >> 0),
    (VUINT32) ((0x3FCED77C89AABEBBuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE57D69348CECA0uLL) >> 0),
    (VUINT32) ((0x3FE57D69348CECA0uLL) >> 32)},
    {(VUINT32) ((0xBC87572080000000uLL) >> 0),
    (VUINT32) ((0xBC87572080000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCDC79D7C0DC985uLL) >> 0),
    (VUINT32) ((0x3FCDC79D7C0DC985uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE5C77BBE65018CuLL) >> 0),
    (VUINT32) ((0x3FE5C77BBE65018CuLL) >> 32)},
    {(VUINT32) ((0x3C8069EA80000000uLL) >> 0),
    (VUINT32) ((0x3C8069EA80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCCB420DFBFFE59uLL) >> 0),
    (VUINT32) ((0x3FCCB420DFBFFE59uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE610B7551D2CDFuLL) >> 0),
    (VUINT32) ((0x3FE610B7551D2CDFuLL) >> 32)},
    {(VUINT32) ((0xBC7251B340000000uLL) >> 0),
    (VUINT32) ((0xBC7251B340000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCB9D1153AAA2BAuLL) >> 0),
    (VUINT32) ((0x3FCB9D1153AAA2BAuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE6591925F0783DuLL) >> 0),
    (VUINT32) ((0x3FE6591925F0783DuLL) >> 32)},
    {(VUINT32) ((0x3C8C3D64E0000000uLL) >> 0),
    (VUINT32) ((0x3C8C3D64E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCA827999FCEF32uLL) >> 0),
    (VUINT32) ((0x3FCA827999FCEF32uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE6A09E667F3BCDuLL) >> 0),
    (VUINT32) ((0x3FE6A09E667F3BCDuLL) >> 32)},
    {(VUINT32) ((0xBC8BDD3400000000uLL) >> 0),
    (VUINT32) ((0xBC8BDD3400000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC9646497C1E0F6uLL) >> 0),
    (VUINT32) ((0x3FC9646497C1E0F6uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE6E74454EAA8AFuLL) >> 0),
    (VUINT32) ((0x3FE6E74454EAA8AFuLL) >> 32)},
    {(VUINT32) ((0xBC8DBC03C0000000uLL) >> 0),
    (VUINT32) ((0xBC8DBC03C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC842DD5474B37BuLL) >> 0),
    (VUINT32) ((0x3FC842DD5474B37BuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE72D0837EFFF96uLL) >> 0),
    (VUINT32) ((0x3FE72D0837EFFF96uLL) >> 32)},
    {(VUINT32) ((0x3C80D4EF00000000uLL) >> 0),
    (VUINT32) ((0x3C80D4EF00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC71DEEF9940631uLL) >> 0),
    (VUINT32) ((0x3FC71DEEF9940631uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE771E75F037261uLL) >> 0),
    (VUINT32) ((0x3FE771E75F037261uLL) >> 32)},
    {(VUINT32) ((0x3C75CFCE80000000uLL) >> 0),
    (VUINT32) ((0x3C75CFCE80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC5F5A4D233B27FuLL) >> 0),
    (VUINT32) ((0x3FC5F5A4D233B27FuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE7B5DF226AAFAFuLL) >> 0),
    (VUINT32) ((0x3FE7B5DF226AAFAFuLL) >> 32)},
    {(VUINT32) ((0xBC70F537A0000000uLL) >> 0),
    (VUINT32) ((0xBC70F537A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC4CA0A4A8D5657uLL) >> 0),
    (VUINT32) ((0x3FC4CA0A4A8D5657uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE7F8ECE3571771uLL) >> 0),
    (VUINT32) ((0x3FE7F8ECE3571771uLL) >> 32)},
    {(VUINT32) ((0xBC89C8D8C0000000uLL) >> 0),
    (VUINT32) ((0xBC89C8D8C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC39B2AEF8F97A4uLL) >> 0),
    (VUINT32) ((0x3FC39B2AEF8F97A4uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE83B0E0BFF976EuLL) >> 0),
    (VUINT32) ((0x3FE83B0E0BFF976EuLL) >> 32)},
    {(VUINT32) ((0xBC76F420E0000000uLL) >> 0),
    (VUINT32) ((0xBC76F420E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC269126E6C24E3uLL) >> 0),
    (VUINT32) ((0x3FC269126E6C24E3uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE87C400FBA2EBFuLL) >> 0),
    (VUINT32) ((0x3FE87C400FBA2EBFuLL) >> 32)},
    {(VUINT32) ((0xBC82DABC00000000uLL) >> 0),
    (VUINT32) ((0xBC82DABC00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC133CC94247758uLL) >> 0),
    (VUINT32) ((0x3FC133CC94247758uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE8BC806B151741uLL) >> 0),
    (VUINT32) ((0x3FE8BC806B151741uLL) >> 32)},
    {(VUINT32) ((0xBC82C5E120000000uLL) >> 0),
    (VUINT32) ((0xBC82C5E120000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBFF6CA9A2AB6A2uLL) >> 0),
    (VUINT32) ((0x3FBFF6CA9A2AB6A2uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE8FBCCA3EF940DuLL) >> 0),
    (VUINT32) ((0x3FE8FBCCA3EF940DuLL) >> 32)},
    {(VUINT32) ((0xBC66DFA980000000uLL) >> 0),
    (VUINT32) ((0xBC66DFA980000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBD7FD1490285CAuLL) >> 0),
    (VUINT32) ((0x3FBD7FD1490285CAuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE93A22499263FBuLL) >> 0),
    (VUINT32) ((0x3FE93A22499263FBuLL) >> 32)},
    {(VUINT32) ((0x3C83D419A0000000uLL) >> 0),
    (VUINT32) ((0x3C83D419A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBB02C58832CF96uLL) >> 0),
    (VUINT32) ((0x3FBB02C58832CF96uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE9777EF4C7D742uLL) >> 0),
    (VUINT32) ((0x3FE9777EF4C7D742uLL) >> 32)},
    {(VUINT32) ((0xBC815479A0000000uLL) >> 0),
    (VUINT32) ((0xBC815479A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB87FBFE70B81A7uLL) >> 0),
    (VUINT32) ((0x3FB87FBFE70B81A7uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE9B3E047F38741uLL) >> 0),
    (VUINT32) ((0x3FE9B3E047F38741uLL) >> 32)},
    {(VUINT32) ((0xBC830EE280000000uLL) >> 0),
    (VUINT32) ((0xBC830EE280000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB5F6D92FD79F50uLL) >> 0),
    (VUINT32) ((0x3FB5F6D92FD79F50uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE9EF43EF29AF94uLL) >> 0),
    (VUINT32) ((0x3FE9EF43EF29AF94uLL) >> 32)},
    {(VUINT32) ((0x3C7B1DFCA0000000uLL) >> 0),
    (VUINT32) ((0x3C7B1DFCA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB3682A66E896F5uLL) >> 0),
    (VUINT32) ((0x3FB3682A66E896F5uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEA29A7A0462782uLL) >> 0),
    (VUINT32) ((0x3FEA29A7A0462782uLL) >> 32)},
    {(VUINT32) ((0xBC7128BB00000000uLL) >> 0),
    (VUINT32) ((0xBC7128BB00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB0D3CCC99F5AC6uLL) >> 0),
    (VUINT32) ((0x3FB0D3CCC99F5AC6uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEA63091B02FAE2uLL) >> 0),
    (VUINT32) ((0x3FEA63091B02FAE2uLL) >> 32)},
    {(VUINT32) ((0xBC7E911140000000uLL) >> 0),
    (VUINT32) ((0xBC7E911140000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FAC73B39AE68C87uLL) >> 0),
    (VUINT32) ((0x3FAC73B39AE68C87uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEA9B66290EA1A3uLL) >> 0),
    (VUINT32) ((0x3FEA9B66290EA1A3uLL) >> 32)},
    {(VUINT32) ((0x3C39F630E0000000uLL) >> 0),
    (VUINT32) ((0x3C39F630E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA734D63DEDB48AuLL) >> 0),
    (VUINT32) ((0x3FA734D63DEDB48AuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEAD2BC9E21D511uLL) >> 0),
    (VUINT32) ((0x3FEAD2BC9E21D511uLL) >> 32)},
    {(VUINT32) ((0xBC847FBE00000000uLL) >> 0),
    (VUINT32) ((0xBC847FBE00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA1EB3541B4B228uLL) >> 0),
    (VUINT32) ((0x3FA1EB3541B4B228uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEB090A58150200uLL) >> 0),
    (VUINT32) ((0x3FEB090A58150200uLL) >> 32)},
    {(VUINT32) ((0xBC8926DA20000000uLL) >> 0),
    (VUINT32) ((0xBC8926DA20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F992E09ABB131D4uLL) >> 0),
    (VUINT32) ((0x3F992E09ABB131D4uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEB3E4D3EF55712uLL) >> 0),
    (VUINT32) ((0x3FEB3E4D3EF55712uLL) >> 32)},
    {(VUINT32) ((0xBC8EB6B8A0000000uLL) >> 0),
    (VUINT32) ((0xBC8EB6B8A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8CE1E648BFFB66uLL) >> 0),
    (VUINT32) ((0x3F8CE1E648BFFB66uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEB728345196E3EuLL) >> 0),
    (VUINT32) ((0x3FEB728345196E3EuLL) >> 32)},
    {(VUINT32) ((0xBC8BC69F20000000uLL) >> 0),
    (VUINT32) ((0xBC8BC69F20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F6CFC874C3EB6D9uLL) >> 0),
    (VUINT32) ((0x3F6CFC874C3EB6D9uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEBA5AA673590D2uLL) >> 0),
    (VUINT32) ((0x3FEBA5AA673590D2uLL) >> 32)},
    {(VUINT32) ((0x3C87EA4E20000000uLL) >> 0),
    (VUINT32) ((0x3C87EA4E20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF7D16C901D95181uLL) >> 0),
    (VUINT32) ((0xBF7D16C901D95181uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEBD7C0AC6F952AuLL) >> 0),
    (VUINT32) ((0x3FEBD7C0AC6F952AuLL) >> 32)},
    {(VUINT32) ((0xBC8825A720000000uLL) >> 0),
    (VUINT32) ((0xBC8825A720000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF923E6AD10872A7uLL) >> 0),
    (VUINT32) ((0xBF923E6AD10872A7uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC08C426725549uLL) >> 0),
    (VUINT32) ((0x3FEC08C426725549uLL) >> 32)},
    {(VUINT32) ((0x3C5B157FC0000000uLL) >> 0),
    (VUINT32) ((0x3C5B157FC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9D4A2C7F909C4EuLL) >> 0),
    (VUINT32) ((0xBF9D4A2C7F909C4EuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC38B2F180BDB1uLL) >> 0),
    (VUINT32) ((0x3FEC38B2F180BDB1uLL) >> 32)},
    {(VUINT32) ((0xBC76E0B160000000uLL) >> 0),
    (VUINT32) ((0xBC76E0B160000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA4344523C8E3B5uLL) >> 0),
    (VUINT32) ((0xBFA4344523C8E3B5uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC678B3488739BuLL) >> 0),
    (VUINT32) ((0x3FEC678B3488739BuLL) >> 32)},
    {(VUINT32) ((0x3C6D86CAC0000000uLL) >> 0),
    (VUINT32) ((0x3C6D86CAC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA9CC8B3671DD0FuLL) >> 0),
    (VUINT32) ((0xBFA9CC8B3671DD0FuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC954B213411F5uLL) >> 0),
    (VUINT32) ((0x3FEC954B213411F5uLL) >> 32)},
    {(VUINT32) ((0xBC52FB7600000000uLL) >> 0),
    (VUINT32) ((0xBC52FB7600000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFAF6DB13FF708CBuLL) >> 0),
    (VUINT32) ((0xBFAF6DB13FF708CBuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FECC1F0F3FCFC5CuLL) >> 0),
    (VUINT32) ((0x3FECC1F0F3FCFC5CuLL) >> 32)},
    {(VUINT32) ((0x3C7E576120000000uLL) >> 0),
    (VUINT32) ((0x3C7E576120000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB28BBFD87A8CFFuLL) >> 0),
    (VUINT32) ((0xBFB28BBFD87A8CFFuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FECED7AF43CC773uLL) >> 0),
    (VUINT32) ((0x3FECED7AF43CC773uLL) >> 32)},
    {(VUINT32) ((0xBC5E7B6BA0000000uLL) >> 0),
    (VUINT32) ((0xBC5E7B6BA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB564DF524B00DAuLL) >> 0),
    (VUINT32) ((0xBFB564DF524B00DAuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED17E7743E35DCuLL) >> 0),
    (VUINT32) ((0x3FED17E7743E35DCuLL) >> 32)},
    {(VUINT32) ((0xBC5101DA20000000uLL) >> 0),
    (VUINT32) ((0xBC5101DA20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB8421AF15C49D7uLL) >> 0),
    (VUINT32) ((0xBFB8421AF15C49D7uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED4134D14DC93AuLL) >> 0),
    (VUINT32) ((0x3FED4134D14DC93AuLL) >> 32)},
    {(VUINT32) ((0xBC84EF5280000000uLL) >> 0),
    (VUINT32) ((0xBC84EF5280000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBB2356710DB0A3uLL) >> 0),
    (VUINT32) ((0xBFBB2356710DB0A3uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED696173C9E68BuLL) >> 0),
    (VUINT32) ((0x3FED696173C9E68BuLL) >> 32)},
    {(VUINT32) ((0xBC7E8C61C0000000uLL) >> 0),
    (VUINT32) ((0xBC7E8C61C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBE087565455A75uLL) >> 0),
    (VUINT32) ((0xBFBE087565455A75uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED906BCF328D46uLL) >> 0),
    (VUINT32) ((0x3FED906BCF328D46uLL) >> 32)},
    {(VUINT32) ((0x3C7457E600000000uLL) >> 0),
    (VUINT32) ((0x3C7457E600000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBF0EA4C477339CuLL) >> 0),
    (VUINT32) ((0x3FBF0EA4C477339CuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEDB6526238A09BuLL) >> 0),
    (VUINT32) ((0x3FEDB6526238A09BuLL) >> 32)},
    {(VUINT32) ((0xBC7ADEE7E0000000uLL) >> 0),
    (VUINT32) ((0xBC7ADEE7E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBC2214C3E9167BuLL) >> 0),
    (VUINT32) ((0x3FBC2214C3E9167BuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEDDB13B6CCC23CuLL) >> 0),
    (VUINT32) ((0x3FEDDB13B6CCC23CuLL) >> 32)},
    {(VUINT32) ((0x3C883C37C0000000uLL) >> 0),
    (VUINT32) ((0x3C883C37C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB931F774FC9F18uLL) >> 0),
    (VUINT32) ((0x3FB931F774FC9F18uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEDFEAE622DBE2BuLL) >> 0),
    (VUINT32) ((0x3FEDFEAE622DBE2BuLL) >> 32)},
    {(VUINT32) ((0xBC8514EA80000000uLL) >> 0),
    (VUINT32) ((0xBC8514EA80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB63E69D6AC7F74uLL) >> 0),
    (VUINT32) ((0x3FB63E69D6AC7F74uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE212104F686E5uLL) >> 0),
    (VUINT32) ((0x3FEE212104F686E5uLL) >> 32)},
    {(VUINT32) ((0xBC8014C760000000uLL) >> 0),
    (VUINT32) ((0xBC8014C760000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB3478909E39DA9uLL) >> 0),
    (VUINT32) ((0x3FB3478909E39DA9uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE426A4B2BC17EuLL) >> 0),
    (VUINT32) ((0x3FEE426A4B2BC17EuLL) >> 32)},
    {(VUINT32) ((0x3C8A873880000000uLL) >> 0),
    (VUINT32) ((0x3C8A873880000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB04D72505D9805uLL) >> 0),
    (VUINT32) ((0x3FB04D72505D9805uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE6288EC48E112uLL) >> 0),
    (VUINT32) ((0x3FEE6288EC48E112uLL) >> 32)},
    {(VUINT32) ((0xBC616B56E0000000uLL) >> 0),
    (VUINT32) ((0xBC616B56E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FAAA086170C0A8EuLL) >> 0),
    (VUINT32) ((0x3FAAA086170C0A8EuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE817BAB4CD10DuLL) >> 0),
    (VUINT32) ((0x3FEE817BAB4CD10DuLL) >> 32)},
    {(VUINT32) ((0xBC7D0AFE60000000uLL) >> 0),
    (VUINT32) ((0xBC7D0AFE60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA4A03176ACF82DuLL) >> 0),
    (VUINT32) ((0x3FA4A03176ACF82DuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE9F4156C62DDAuLL) >> 0),
    (VUINT32) ((0x3FEE9F4156C62DDAuLL) >> 32)},
    {(VUINT32) ((0x3C8760B1E0000000uLL) >> 0),
    (VUINT32) ((0x3C8760B1E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9D3443F4CDB3DDuLL) >> 0),
    (VUINT32) ((0x3F9D3443F4CDB3DDuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEEBBD8C8DF0B74uLL) >> 0),
    (VUINT32) ((0x3FEEBBD8C8DF0B74uLL) >> 32)},
    {(VUINT32) ((0x3C7C6C8C60000000uLL) >> 0),
    (VUINT32) ((0x3C7C6C8C60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F911D262B1F6776uLL) >> 0),
    (VUINT32) ((0x3F911D262B1F6776uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEED740E7684963uLL) >> 0),
    (VUINT32) ((0x3FEED740E7684963uLL) >> 32)},
    {(VUINT32) ((0x3C7E82C780000000uLL) >> 0),
    (VUINT32) ((0x3C7E82C780000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F73EE038DFF6B80uLL) >> 0),
    (VUINT32) ((0x3F73EE038DFF6B80uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEEF178A3E473C2uLL) >> 0),
    (VUINT32) ((0x3FEEF178A3E473C2uLL) >> 32)},
    {(VUINT32) ((0x3C86310A60000000uLL) >> 0),
    (VUINT32) ((0x3C86310A60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF7CC0D09BD41CAAuLL) >> 0),
    (VUINT32) ((0xBF7CC0D09BD41CAAuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF0A7EFB9230D7uLL) >> 0),
    (VUINT32) ((0x3FEF0A7EFB9230D7uLL) >> 32)},
    {(VUINT32) ((0x3C752C7AC0000000uLL) >> 0),
    (VUINT32) ((0x3C752C7AC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF936580D5D5E775uLL) >> 0),
    (VUINT32) ((0xBF936580D5D5E775uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF2252F7763ADAuLL) >> 0),
    (VUINT32) ((0x3FEF2252F7763ADAuLL) >> 32)},
    {(VUINT32) ((0xBC820CB800000000uLL) >> 0),
    (VUINT32) ((0xBC820CB800000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9FA3ECAC0D84E8uLL) >> 0),
    (VUINT32) ((0xBF9FA3ECAC0D84E8uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF38F3AC64E589uLL) >> 0),
    (VUINT32) ((0x3FEF38F3AC64E589uLL) >> 32)},
    {(VUINT32) ((0xBC7D7BAFA0000000uLL) >> 0),
    (VUINT32) ((0xBC7D7BAFA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA5F57F693FEEBEuLL) >> 0),
    (VUINT32) ((0xBFA5F57F693FEEBEuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF4E603B0B2F2DuLL) >> 0),
    (VUINT32) ((0x3FEF4E603B0B2F2DuLL) >> 32)},
    {(VUINT32) ((0xBC78EE01E0000000uLL) >> 0),
    (VUINT32) ((0xBC78EE01E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFAC1D1F0E5967D5uLL) >> 0),
    (VUINT32) ((0xBFAC1D1F0E5967D5uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF6297CFF75CB0uLL) >> 0),
    (VUINT32) ((0x3FEF6297CFF75CB0uLL) >> 32)},
    {(VUINT32) ((0x3C75621720000000uLL) >> 0),
    (VUINT32) ((0x3C75621720000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FADB7677942FCC5uLL) >> 0),
    (VUINT32) ((0x3FADB7677942FCC5uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
    (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF7599A3A12077uLL) >> 0),
    (VUINT32) ((0x3FEF7599A3A12077uLL) >> 32)},
    {(VUINT32) ((0x3C884F31C0000000uLL) >> 0),
    (VUINT32) ((0x3C884F31C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA78851122CFF19uLL) >> 0),
    (VUINT32) ((0x3FA78851122CFF19uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
    (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF8764FA714BA9uLL) >> 0),
    (VUINT32) ((0x3FEF8764FA714BA9uLL) >> 32)},
    {(VUINT32) ((0x3C7AB25660000000uLL) >> 0),
    (VUINT32) ((0x3C7AB25660000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA155DAC4A4F967uLL) >> 0),
    (VUINT32) ((0x3FA155DAC4A4F967uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
    (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF97F924C9099BuLL) >> 0),
    (VUINT32) ((0x3FEF97F924C9099BuLL) >> 32)},
    {(VUINT32) ((0xBC8E2AE0E0000000uLL) >> 0),
    (VUINT32) ((0xBC8E2AE0E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F964083747309D1uLL) >> 0),
    (VUINT32) ((0x3F964083747309D1uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
    (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFA7557F08A517uLL) >> 0),
    (VUINT32) ((0x3FEFA7557F08A517uLL) >> 32)},
    {(VUINT32) ((0xBC87A0A8C0000000uLL) >> 0),
    (VUINT32) ((0xBC87A0A8C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F839F0CEDAF576BuLL) >> 0),
    (VUINT32) ((0x3F839F0CEDAF576BuLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
    (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFB5797195D741uLL) >> 0),
    (VUINT32) ((0x3FEFB5797195D741uLL) >> 32)},
    {(VUINT32) ((0x3C71BFAC60000000uLL) >> 0),
    (VUINT32) ((0x3C71BFAC60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF6536352AD19E39uLL) >> 0),
    (VUINT32) ((0xBF6536352AD19E39uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
    (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFC26470E19FD3uLL) >> 0),
    (VUINT32) ((0x3FEFC26470E19FD3uLL) >> 32)},
    {(VUINT32) ((0x3C81EC8660000000uLL) >> 0),
    (VUINT32) ((0x3C81EC8660000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8E43D1C309E958uLL) >> 0),
    (VUINT32) ((0xBF8E43D1C309E958uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
    (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFCE15FD6DA67BuLL) >> 0),
    (VUINT32) ((0x3FEFCE15FD6DA67BuLL) >> 32)},
    {(VUINT32) ((0xBC75DD6F80000000uLL) >> 0),
    (VUINT32) ((0xBC75DD6F80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9BA1650F592F50uLL) >> 0),
    (VUINT32) ((0xBF9BA1650F592F50uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
    (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFD88DA3D12526uLL) >> 0),
    (VUINT32) ((0x3FEFD88DA3D12526uLL) >> 32)},
    {(VUINT32) ((0xBC887DF620000000uLL) >> 0),
    (VUINT32) ((0xBC887DF620000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F97DB402A6A9063uLL) >> 0),
    (VUINT32) ((0x3F97DB402A6A9063uLL) >> 32)},
    {(VUINT32) ((0x3FB0000000000000uLL) >> 0),
    (VUINT32) ((0x3FB0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFE1CAFCBD5B09uLL) >> 0),
    (VUINT32) ((0x3FEFE1CAFCBD5B09uLL) >> 32)},
    {(VUINT32) ((0x3C6A23E320000000uLL) >> 0),
    (VUINT32) ((0x3C6A23E320000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F86A9049670CFAEuLL) >> 0),
    (VUINT32) ((0x3F86A9049670CFAEuLL) >> 32)},
    {(VUINT32) ((0x3FB0000000000000uLL) >> 0),
    (VUINT32) ((0x3FB0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFE9CDAD01883AuLL) >> 0),
    (VUINT32) ((0x3FEFE9CDAD01883AuLL) >> 32)},
    {(VUINT32) ((0x3C6521ECC0000000uLL) >> 0),
    (VUINT32) ((0x3C6521ECC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF535230C0FBE402uLL) >> 0),
    (VUINT32) ((0xBF535230C0FBE402uLL) >> 32)},
    {(VUINT32) ((0x3FB0000000000000uLL) >> 0),
    (VUINT32) ((0x3FB0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFF095658E71ADuLL) >> 0),
    (VUINT32) ((0x3FEFF095658E71ADuLL) >> 32)},
    {(VUINT32) ((0x3C801A8CE0000000uLL) >> 0),
    (VUINT32) ((0x3C801A8CE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8B82683BC89FB0uLL) >> 0),
    (VUINT32) ((0xBF8B82683BC89FB0uLL) >> 32)},
    {(VUINT32) ((0x3FB0000000000000uLL) >> 0),
    (VUINT32) ((0x3FB0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFF621E3796D7EuLL) >> 0),
    (VUINT32) ((0x3FEFF621E3796D7EuLL) >> 32)},
    {(VUINT32) ((0xBC6C57BC20000000uLL) >> 0),
    (VUINT32) ((0xBC6C57BC20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F76C32BACA2AE69uLL) >> 0),
    (VUINT32) ((0x3F76C32BACA2AE69uLL) >> 32)},
    {(VUINT32) ((0x3FA0000000000000uLL) >> 0),
    (VUINT32) ((0x3FA0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFFA72EFFEF75DuLL) >> 0),
    (VUINT32) ((0x3FEFFA72EFFEF75DuLL) >> 32)},
    {(VUINT32) ((0xBC88B4CDC0000000uLL) >> 0),
    (VUINT32) ((0xBC88B4CDC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF7B7AA821726608uLL) >> 0),
    (VUINT32) ((0xBF7B7AA821726608uLL) >> 32)},
    {(VUINT32) ((0x3FA0000000000000uLL) >> 0),
    (VUINT32) ((0x3FA0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFFD886084CD0DuLL) >> 0),
    (VUINT32) ((0x3FEFFD886084CD0DuLL) >> 32)},
    {(VUINT32) ((0xBC81354D40000000uLL) >> 0),
    (VUINT32) ((0xBC81354D40000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF6B78B80C84E1EEuLL) >> 0),
    (VUINT32) ((0xBF6B78B80C84E1EEuLL) >> 32)},
    {(VUINT32) ((0x3F90000000000000uLL) >> 0),
    (VUINT32) ((0x3F90000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFFF62169B92DBuLL) >> 0),
    (VUINT32) ((0x3FEFFF62169B92DBuLL) >> 32)},
    {(VUINT32) ((0x3C85DDA3C0000000uLL) >> 0),
    (VUINT32) ((0x3C85DDA3C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F6B78B80C84E1EEuLL) >> 0),
    (VUINT32) ((0x3F6B78B80C84E1EEuLL) >> 32)},
    {(VUINT32) ((0xBF90000000000000uLL) >> 0),
    (VUINT32) ((0xBF90000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFFF62169B92DBuLL) >> 0),
    (VUINT32) ((0x3FEFFF62169B92DBuLL) >> 32)},
    {(VUINT32) ((0x3C85DDA3C0000000uLL) >> 0),
    (VUINT32) ((0x3C85DDA3C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F7B7AA821726608uLL) >> 0),
    (VUINT32) ((0x3F7B7AA821726608uLL) >> 32)},
    {(VUINT32) ((0xBFA0000000000000uLL) >> 0),
    (VUINT32) ((0xBFA0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFFD886084CD0DuLL) >> 0),
    (VUINT32) ((0x3FEFFD886084CD0DuLL) >> 32)},
    {(VUINT32) ((0xBC81354D40000000uLL) >> 0),
    (VUINT32) ((0xBC81354D40000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF76C32BACA2AE69uLL) >> 0),
    (VUINT32) ((0xBF76C32BACA2AE69uLL) >> 32)},
    {(VUINT32) ((0xBFA0000000000000uLL) >> 0),
    (VUINT32) ((0xBFA0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFFA72EFFEF75DuLL) >> 0),
    (VUINT32) ((0x3FEFFA72EFFEF75DuLL) >> 32)},
    {(VUINT32) ((0xBC88B4CDC0000000uLL) >> 0),
    (VUINT32) ((0xBC88B4CDC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8B82683BC89FB0uLL) >> 0),
    (VUINT32) ((0x3F8B82683BC89FB0uLL) >> 32)},
    {(VUINT32) ((0xBFB0000000000000uLL) >> 0),
    (VUINT32) ((0xBFB0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFF621E3796D7EuLL) >> 0),
    (VUINT32) ((0x3FEFF621E3796D7EuLL) >> 32)},
    {(VUINT32) ((0xBC6C57BC20000000uLL) >> 0),
    (VUINT32) ((0xBC6C57BC20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F535230C0FBE402uLL) >> 0),
    (VUINT32) ((0x3F535230C0FBE402uLL) >> 32)},
    {(VUINT32) ((0xBFB0000000000000uLL) >> 0),
    (VUINT32) ((0xBFB0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFF095658E71ADuLL) >> 0),
    (VUINT32) ((0x3FEFF095658E71ADuLL) >> 32)},
    {(VUINT32) ((0x3C801A8CE0000000uLL) >> 0),
    (VUINT32) ((0x3C801A8CE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF86A9049670CFAEuLL) >> 0),
    (VUINT32) ((0xBF86A9049670CFAEuLL) >> 32)},
    {(VUINT32) ((0xBFB0000000000000uLL) >> 0),
    (VUINT32) ((0xBFB0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFE9CDAD01883AuLL) >> 0),
    (VUINT32) ((0x3FEFE9CDAD01883AuLL) >> 32)},
    {(VUINT32) ((0x3C6521ECC0000000uLL) >> 0),
    (VUINT32) ((0x3C6521ECC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF97DB402A6A9063uLL) >> 0),
    (VUINT32) ((0xBF97DB402A6A9063uLL) >> 32)},
    {(VUINT32) ((0xBFB0000000000000uLL) >> 0),
    (VUINT32) ((0xBFB0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFE1CAFCBD5B09uLL) >> 0),
    (VUINT32) ((0x3FEFE1CAFCBD5B09uLL) >> 32)},
    {(VUINT32) ((0x3C6A23E320000000uLL) >> 0),
    (VUINT32) ((0x3C6A23E320000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9BA1650F592F50uLL) >> 0),
    (VUINT32) ((0x3F9BA1650F592F50uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
    (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFD88DA3D12526uLL) >> 0),
    (VUINT32) ((0x3FEFD88DA3D12526uLL) >> 32)},
    {(VUINT32) ((0xBC887DF620000000uLL) >> 0),
    (VUINT32) ((0xBC887DF620000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8E43D1C309E958uLL) >> 0),
    (VUINT32) ((0x3F8E43D1C309E958uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
    (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFCE15FD6DA67BuLL) >> 0),
    (VUINT32) ((0x3FEFCE15FD6DA67BuLL) >> 32)},
    {(VUINT32) ((0xBC75DD6F80000000uLL) >> 0),
    (VUINT32) ((0xBC75DD6F80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F6536352AD19E39uLL) >> 0),
    (VUINT32) ((0x3F6536352AD19E39uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
    (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFC26470E19FD3uLL) >> 0),
    (VUINT32) ((0x3FEFC26470E19FD3uLL) >> 32)},
    {(VUINT32) ((0x3C81EC8660000000uLL) >> 0),
    (VUINT32) ((0x3C81EC8660000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF839F0CEDAF576BuLL) >> 0),
    (VUINT32) ((0xBF839F0CEDAF576BuLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
    (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFB5797195D741uLL) >> 0),
    (VUINT32) ((0x3FEFB5797195D741uLL) >> 32)},
    {(VUINT32) ((0x3C71BFAC60000000uLL) >> 0),
    (VUINT32) ((0x3C71BFAC60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF964083747309D1uLL) >> 0),
    (VUINT32) ((0xBF964083747309D1uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
    (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFA7557F08A517uLL) >> 0),
    (VUINT32) ((0x3FEFA7557F08A517uLL) >> 32)},
    {(VUINT32) ((0xBC87A0A8C0000000uLL) >> 0),
    (VUINT32) ((0xBC87A0A8C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA155DAC4A4F967uLL) >> 0),
    (VUINT32) ((0xBFA155DAC4A4F967uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
    (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF97F924C9099BuLL) >> 0),
    (VUINT32) ((0x3FEF97F924C9099BuLL) >> 32)},
    {(VUINT32) ((0xBC8E2AE0E0000000uLL) >> 0),
    (VUINT32) ((0xBC8E2AE0E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA78851122CFF19uLL) >> 0),
    (VUINT32) ((0xBFA78851122CFF19uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
    (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF8764FA714BA9uLL) >> 0),
    (VUINT32) ((0x3FEF8764FA714BA9uLL) >> 32)},
    {(VUINT32) ((0x3C7AB25660000000uLL) >> 0),
    (VUINT32) ((0x3C7AB25660000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFADB7677942FCC5uLL) >> 0),
    (VUINT32) ((0xBFADB7677942FCC5uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
    (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF7599A3A12077uLL) >> 0),
    (VUINT32) ((0x3FEF7599A3A12077uLL) >> 32)},
    {(VUINT32) ((0x3C884F31C0000000uLL) >> 0),
    (VUINT32) ((0x3C884F31C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FAC1D1F0E5967D5uLL) >> 0),
    (VUINT32) ((0x3FAC1D1F0E5967D5uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF6297CFF75CB0uLL) >> 0),
    (VUINT32) ((0x3FEF6297CFF75CB0uLL) >> 32)},
    {(VUINT32) ((0x3C75621720000000uLL) >> 0),
    (VUINT32) ((0x3C75621720000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA5F57F693FEEBEuLL) >> 0),
    (VUINT32) ((0x3FA5F57F693FEEBEuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF4E603B0B2F2DuLL) >> 0),
    (VUINT32) ((0x3FEF4E603B0B2F2DuLL) >> 32)},
    {(VUINT32) ((0xBC78EE01E0000000uLL) >> 0),
    (VUINT32) ((0xBC78EE01E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9FA3ECAC0D84E8uLL) >> 0),
    (VUINT32) ((0x3F9FA3ECAC0D84E8uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF38F3AC64E589uLL) >> 0),
    (VUINT32) ((0x3FEF38F3AC64E589uLL) >> 32)},
    {(VUINT32) ((0xBC7D7BAFA0000000uLL) >> 0),
    (VUINT32) ((0xBC7D7BAFA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F936580D5D5E775uLL) >> 0),
    (VUINT32) ((0x3F936580D5D5E775uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF2252F7763ADAuLL) >> 0),
    (VUINT32) ((0x3FEF2252F7763ADAuLL) >> 32)},
    {(VUINT32) ((0xBC820CB800000000uLL) >> 0),
    (VUINT32) ((0xBC820CB800000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F7CC0D09BD41CAAuLL) >> 0),
    (VUINT32) ((0x3F7CC0D09BD41CAAuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF0A7EFB9230D7uLL) >> 0),
    (VUINT32) ((0x3FEF0A7EFB9230D7uLL) >> 32)},
    {(VUINT32) ((0x3C752C7AC0000000uLL) >> 0),
    (VUINT32) ((0x3C752C7AC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF73EE038DFF6B80uLL) >> 0),
    (VUINT32) ((0xBF73EE038DFF6B80uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEEF178A3E473C2uLL) >> 0),
    (VUINT32) ((0x3FEEF178A3E473C2uLL) >> 32)},
    {(VUINT32) ((0x3C86310A60000000uLL) >> 0),
    (VUINT32) ((0x3C86310A60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF911D262B1F6776uLL) >> 0),
    (VUINT32) ((0xBF911D262B1F6776uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEED740E7684963uLL) >> 0),
    (VUINT32) ((0x3FEED740E7684963uLL) >> 32)},
    {(VUINT32) ((0x3C7E82C780000000uLL) >> 0),
    (VUINT32) ((0x3C7E82C780000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9D3443F4CDB3DDuLL) >> 0),
    (VUINT32) ((0xBF9D3443F4CDB3DDuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEEBBD8C8DF0B74uLL) >> 0),
    (VUINT32) ((0x3FEEBBD8C8DF0B74uLL) >> 32)},
    {(VUINT32) ((0x3C7C6C8C60000000uLL) >> 0),
    (VUINT32) ((0x3C7C6C8C60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA4A03176ACF82DuLL) >> 0),
    (VUINT32) ((0xBFA4A03176ACF82DuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE9F4156C62DDAuLL) >> 0),
    (VUINT32) ((0x3FEE9F4156C62DDAuLL) >> 32)},
    {(VUINT32) ((0x3C8760B1E0000000uLL) >> 0),
    (VUINT32) ((0x3C8760B1E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFAAA086170C0A8EuLL) >> 0),
    (VUINT32) ((0xBFAAA086170C0A8EuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE817BAB4CD10DuLL) >> 0),
    (VUINT32) ((0x3FEE817BAB4CD10DuLL) >> 32)},
    {(VUINT32) ((0xBC7D0AFE60000000uLL) >> 0),
    (VUINT32) ((0xBC7D0AFE60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB04D72505D9805uLL) >> 0),
    (VUINT32) ((0xBFB04D72505D9805uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE6288EC48E112uLL) >> 0),
    (VUINT32) ((0x3FEE6288EC48E112uLL) >> 32)},
    {(VUINT32) ((0xBC616B56E0000000uLL) >> 0),
    (VUINT32) ((0xBC616B56E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB3478909E39DA9uLL) >> 0),
    (VUINT32) ((0xBFB3478909E39DA9uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE426A4B2BC17EuLL) >> 0),
    (VUINT32) ((0x3FEE426A4B2BC17EuLL) >> 32)},
    {(VUINT32) ((0x3C8A873880000000uLL) >> 0),
    (VUINT32) ((0x3C8A873880000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB63E69D6AC7F74uLL) >> 0),
    (VUINT32) ((0xBFB63E69D6AC7F74uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE212104F686E5uLL) >> 0),
    (VUINT32) ((0x3FEE212104F686E5uLL) >> 32)},
    {(VUINT32) ((0xBC8014C760000000uLL) >> 0),
    (VUINT32) ((0xBC8014C760000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB931F774FC9F18uLL) >> 0),
    (VUINT32) ((0xBFB931F774FC9F18uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEDFEAE622DBE2BuLL) >> 0),
    (VUINT32) ((0x3FEDFEAE622DBE2BuLL) >> 32)},
    {(VUINT32) ((0xBC8514EA80000000uLL) >> 0),
    (VUINT32) ((0xBC8514EA80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBC2214C3E9167BuLL) >> 0),
    (VUINT32) ((0xBFBC2214C3E9167BuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEDDB13B6CCC23CuLL) >> 0),
    (VUINT32) ((0x3FEDDB13B6CCC23CuLL) >> 32)},
    {(VUINT32) ((0x3C883C37C0000000uLL) >> 0),
    (VUINT32) ((0x3C883C37C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBF0EA4C477339CuLL) >> 0),
    (VUINT32) ((0xBFBF0EA4C477339CuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEDB6526238A09BuLL) >> 0),
    (VUINT32) ((0x3FEDB6526238A09BuLL) >> 32)},
    {(VUINT32) ((0xBC7ADEE7E0000000uLL) >> 0),
    (VUINT32) ((0xBC7ADEE7E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBE087565455A75uLL) >> 0),
    (VUINT32) ((0x3FBE087565455A75uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED906BCF328D46uLL) >> 0),
    (VUINT32) ((0x3FED906BCF328D46uLL) >> 32)},
    {(VUINT32) ((0x3C7457E600000000uLL) >> 0),
    (VUINT32) ((0x3C7457E600000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBB2356710DB0A3uLL) >> 0),
    (VUINT32) ((0x3FBB2356710DB0A3uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED696173C9E68BuLL) >> 0),
    (VUINT32) ((0x3FED696173C9E68BuLL) >> 32)},
    {(VUINT32) ((0xBC7E8C61C0000000uLL) >> 0),
    (VUINT32) ((0xBC7E8C61C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB8421AF15C49D7uLL) >> 0),
    (VUINT32) ((0x3FB8421AF15C49D7uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED4134D14DC93AuLL) >> 0),
    (VUINT32) ((0x3FED4134D14DC93AuLL) >> 32)},
    {(VUINT32) ((0xBC84EF5280000000uLL) >> 0),
    (VUINT32) ((0xBC84EF5280000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB564DF524B00DAuLL) >> 0),
    (VUINT32) ((0x3FB564DF524B00DAuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED17E7743E35DCuLL) >> 0),
    (VUINT32) ((0x3FED17E7743E35DCuLL) >> 32)},
    {(VUINT32) ((0xBC5101DA20000000uLL) >> 0),
    (VUINT32) ((0xBC5101DA20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB28BBFD87A8CFFuLL) >> 0),
    (VUINT32) ((0x3FB28BBFD87A8CFFuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FECED7AF43CC773uLL) >> 0),
    (VUINT32) ((0x3FECED7AF43CC773uLL) >> 32)},
    {(VUINT32) ((0xBC5E7B6BA0000000uLL) >> 0),
    (VUINT32) ((0xBC5E7B6BA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FAF6DB13FF708CBuLL) >> 0),
    (VUINT32) ((0x3FAF6DB13FF708CBuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FECC1F0F3FCFC5CuLL) >> 0),
    (VUINT32) ((0x3FECC1F0F3FCFC5CuLL) >> 32)},
    {(VUINT32) ((0x3C7E576120000000uLL) >> 0),
    (VUINT32) ((0x3C7E576120000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA9CC8B3671DD0FuLL) >> 0),
    (VUINT32) ((0x3FA9CC8B3671DD0FuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC954B213411F5uLL) >> 0),
    (VUINT32) ((0x3FEC954B213411F5uLL) >> 32)},
    {(VUINT32) ((0xBC52FB7600000000uLL) >> 0),
    (VUINT32) ((0xBC52FB7600000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA4344523C8E3B5uLL) >> 0),
    (VUINT32) ((0x3FA4344523C8E3B5uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC678B3488739BuLL) >> 0),
    (VUINT32) ((0x3FEC678B3488739BuLL) >> 32)},
    {(VUINT32) ((0x3C6D86CAC0000000uLL) >> 0),
    (VUINT32) ((0x3C6D86CAC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9D4A2C7F909C4EuLL) >> 0),
    (VUINT32) ((0x3F9D4A2C7F909C4EuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC38B2F180BDB1uLL) >> 0),
    (VUINT32) ((0x3FEC38B2F180BDB1uLL) >> 32)},
    {(VUINT32) ((0xBC76E0B160000000uLL) >> 0),
    (VUINT32) ((0xBC76E0B160000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F923E6AD10872A7uLL) >> 0),
    (VUINT32) ((0x3F923E6AD10872A7uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC08C426725549uLL) >> 0),
    (VUINT32) ((0x3FEC08C426725549uLL) >> 32)},
    {(VUINT32) ((0x3C5B157FC0000000uLL) >> 0),
    (VUINT32) ((0x3C5B157FC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F7D16C901D95181uLL) >> 0),
    (VUINT32) ((0x3F7D16C901D95181uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEBD7C0AC6F952AuLL) >> 0),
    (VUINT32) ((0x3FEBD7C0AC6F952AuLL) >> 32)},
    {(VUINT32) ((0xBC8825A720000000uLL) >> 0),
    (VUINT32) ((0xBC8825A720000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF6CFC874C3EB6D9uLL) >> 0),
    (VUINT32) ((0xBF6CFC874C3EB6D9uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEBA5AA673590D2uLL) >> 0),
    (VUINT32) ((0x3FEBA5AA673590D2uLL) >> 32)},
    {(VUINT32) ((0x3C87EA4E20000000uLL) >> 0),
    (VUINT32) ((0x3C87EA4E20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8CE1E648BFFB66uLL) >> 0),
    (VUINT32) ((0xBF8CE1E648BFFB66uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEB728345196E3EuLL) >> 0),
    (VUINT32) ((0x3FEB728345196E3EuLL) >> 32)},
    {(VUINT32) ((0xBC8BC69F20000000uLL) >> 0),
    (VUINT32) ((0xBC8BC69F20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF992E09ABB131D4uLL) >> 0),
    (VUINT32) ((0xBF992E09ABB131D4uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEB3E4D3EF55712uLL) >> 0),
    (VUINT32) ((0x3FEB3E4D3EF55712uLL) >> 32)},
    {(VUINT32) ((0xBC8EB6B8A0000000uLL) >> 0),
    (VUINT32) ((0xBC8EB6B8A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA1EB3541B4B228uLL) >> 0),
    (VUINT32) ((0xBFA1EB3541B4B228uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEB090A58150200uLL) >> 0),
    (VUINT32) ((0x3FEB090A58150200uLL) >> 32)},
    {(VUINT32) ((0xBC8926DA20000000uLL) >> 0),
    (VUINT32) ((0xBC8926DA20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA734D63DEDB48AuLL) >> 0),
    (VUINT32) ((0xBFA734D63DEDB48AuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEAD2BC9E21D511uLL) >> 0),
    (VUINT32) ((0x3FEAD2BC9E21D511uLL) >> 32)},
    {(VUINT32) ((0xBC847FBE00000000uLL) >> 0),
    (VUINT32) ((0xBC847FBE00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFAC73B39AE68C87uLL) >> 0),
    (VUINT32) ((0xBFAC73B39AE68C87uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEA9B66290EA1A3uLL) >> 0),
    (VUINT32) ((0x3FEA9B66290EA1A3uLL) >> 32)},
    {(VUINT32) ((0x3C39F630E0000000uLL) >> 0),
    (VUINT32) ((0x3C39F630E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB0D3CCC99F5AC6uLL) >> 0),
    (VUINT32) ((0xBFB0D3CCC99F5AC6uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEA63091B02FAE2uLL) >> 0),
    (VUINT32) ((0x3FEA63091B02FAE2uLL) >> 32)},
    {(VUINT32) ((0xBC7E911140000000uLL) >> 0),
    (VUINT32) ((0xBC7E911140000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB3682A66E896F5uLL) >> 0),
    (VUINT32) ((0xBFB3682A66E896F5uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEA29A7A0462782uLL) >> 0),
    (VUINT32) ((0x3FEA29A7A0462782uLL) >> 32)},
    {(VUINT32) ((0xBC7128BB00000000uLL) >> 0),
    (VUINT32) ((0xBC7128BB00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB5F6D92FD79F50uLL) >> 0),
    (VUINT32) ((0xBFB5F6D92FD79F50uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE9EF43EF29AF94uLL) >> 0),
    (VUINT32) ((0x3FE9EF43EF29AF94uLL) >> 32)},
    {(VUINT32) ((0x3C7B1DFCA0000000uLL) >> 0),
    (VUINT32) ((0x3C7B1DFCA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB87FBFE70B81A7uLL) >> 0),
    (VUINT32) ((0xBFB87FBFE70B81A7uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE9B3E047F38741uLL) >> 0),
    (VUINT32) ((0x3FE9B3E047F38741uLL) >> 32)},
    {(VUINT32) ((0xBC830EE280000000uLL) >> 0),
    (VUINT32) ((0xBC830EE280000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBB02C58832CF96uLL) >> 0),
    (VUINT32) ((0xBFBB02C58832CF96uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE9777EF4C7D742uLL) >> 0),
    (VUINT32) ((0x3FE9777EF4C7D742uLL) >> 32)},
    {(VUINT32) ((0xBC815479A0000000uLL) >> 0),
    (VUINT32) ((0xBC815479A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBD7FD1490285CAuLL) >> 0),
    (VUINT32) ((0xBFBD7FD1490285CAuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE93A22499263FBuLL) >> 0),
    (VUINT32) ((0x3FE93A22499263FBuLL) >> 32)},
    {(VUINT32) ((0x3C83D419A0000000uLL) >> 0),
    (VUINT32) ((0x3C83D419A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBFF6CA9A2AB6A2uLL) >> 0),
    (VUINT32) ((0xBFBFF6CA9A2AB6A2uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE8FBCCA3EF940DuLL) >> 0),
    (VUINT32) ((0x3FE8FBCCA3EF940DuLL) >> 32)},
    {(VUINT32) ((0xBC66DFA980000000uLL) >> 0),
    (VUINT32) ((0xBC66DFA980000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC133CC94247758uLL) >> 0),
    (VUINT32) ((0xBFC133CC94247758uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE8BC806B151741uLL) >> 0),
    (VUINT32) ((0x3FE8BC806B151741uLL) >> 32)},
    {(VUINT32) ((0xBC82C5E120000000uLL) >> 0),
    (VUINT32) ((0xBC82C5E120000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC269126E6C24E3uLL) >> 0),
    (VUINT32) ((0xBFC269126E6C24E3uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE87C400FBA2EBFuLL) >> 0),
    (VUINT32) ((0x3FE87C400FBA2EBFuLL) >> 32)},
    {(VUINT32) ((0xBC82DABC00000000uLL) >> 0),
    (VUINT32) ((0xBC82DABC00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC39B2AEF8F97A4uLL) >> 0),
    (VUINT32) ((0xBFC39B2AEF8F97A4uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE83B0E0BFF976EuLL) >> 0),
    (VUINT32) ((0x3FE83B0E0BFF976EuLL) >> 32)},
    {(VUINT32) ((0xBC76F420E0000000uLL) >> 0),
    (VUINT32) ((0xBC76F420E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC4CA0A4A8D5657uLL) >> 0),
    (VUINT32) ((0xBFC4CA0A4A8D5657uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE7F8ECE3571771uLL) >> 0),
    (VUINT32) ((0x3FE7F8ECE3571771uLL) >> 32)},
    {(VUINT32) ((0xBC89C8D8C0000000uLL) >> 0),
    (VUINT32) ((0xBC89C8D8C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC5F5A4D233B27FuLL) >> 0),
    (VUINT32) ((0xBFC5F5A4D233B27FuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE7B5DF226AAFAFuLL) >> 0),
    (VUINT32) ((0x3FE7B5DF226AAFAFuLL) >> 32)},
    {(VUINT32) ((0xBC70F537A0000000uLL) >> 0),
    (VUINT32) ((0xBC70F537A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC71DEEF9940631uLL) >> 0),
    (VUINT32) ((0xBFC71DEEF9940631uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE771E75F037261uLL) >> 0),
    (VUINT32) ((0x3FE771E75F037261uLL) >> 32)},
    {(VUINT32) ((0x3C75CFCE80000000uLL) >> 0),
    (VUINT32) ((0x3C75CFCE80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC842DD5474B37BuLL) >> 0),
    (VUINT32) ((0xBFC842DD5474B37BuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE72D0837EFFF96uLL) >> 0),
    (VUINT32) ((0x3FE72D0837EFFF96uLL) >> 32)},
    {(VUINT32) ((0x3C80D4EF00000000uLL) >> 0),
    (VUINT32) ((0x3C80D4EF00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC9646497C1E0F6uLL) >> 0),
    (VUINT32) ((0xBFC9646497C1E0F6uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE6E74454EAA8AFuLL) >> 0),
    (VUINT32) ((0x3FE6E74454EAA8AFuLL) >> 32)},
    {(VUINT32) ((0xBC8DBC03C0000000uLL) >> 0),
    (VUINT32) ((0xBC8DBC03C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCA827999FCEF32uLL) >> 0),
    (VUINT32) ((0xBFCA827999FCEF32uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE6A09E667F3BCDuLL) >> 0),
    (VUINT32) ((0x3FE6A09E667F3BCDuLL) >> 32)},
    {(VUINT32) ((0xBC8BDD3400000000uLL) >> 0),
    (VUINT32) ((0xBC8BDD3400000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCB9D1153AAA2BAuLL) >> 0),
    (VUINT32) ((0xBFCB9D1153AAA2BAuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE6591925F0783DuLL) >> 0),
    (VUINT32) ((0x3FE6591925F0783DuLL) >> 32)},
    {(VUINT32) ((0x3C8C3D64E0000000uLL) >> 0),
    (VUINT32) ((0x3C8C3D64E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCCB420DFBFFE59uLL) >> 0),
    (VUINT32) ((0xBFCCB420DFBFFE59uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE610B7551D2CDFuLL) >> 0),
    (VUINT32) ((0x3FE610B7551D2CDFuLL) >> 32)},
    {(VUINT32) ((0xBC7251B340000000uLL) >> 0),
    (VUINT32) ((0xBC7251B340000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCDC79D7C0DC985uLL) >> 0),
    (VUINT32) ((0xBFCDC79D7C0DC985uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE5C77BBE65018CuLL) >> 0),
    (VUINT32) ((0x3FE5C77BBE65018CuLL) >> 32)},
    {(VUINT32) ((0x3C8069EA80000000uLL) >> 0),
    (VUINT32) ((0x3C8069EA80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCED77C89AABEBBuLL) >> 0),
    (VUINT32) ((0xBFCED77C89AABEBBuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE57D69348CECA0uLL) >> 0),
    (VUINT32) ((0x3FE57D69348CECA0uLL) >> 32)},
    {(VUINT32) ((0xBC87572080000000uLL) >> 0),
    (VUINT32) ((0xBC87572080000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCFE3B38D5C5DC2uLL) >> 0),
    (VUINT32) ((0xBFCFE3B38D5C5DC2uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE5328292A35596uLL) >> 0),
    (VUINT32) ((0x3FE5328292A35596uLL) >> 32)},
    {(VUINT32) ((0xBC7A12EB80000000uLL) >> 0),
    (VUINT32) ((0xBC7A12EB80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCF13C7D001A249uLL) >> 0),
    (VUINT32) ((0x3FCF13C7D001A249uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE4E6CABBE3E5E9uLL) >> 0),
    (VUINT32) ((0x3FE4E6CABBE3E5E9uLL) >> 32)},
    {(VUINT32) ((0x3C63C293E0000000uLL) >> 0),
    (VUINT32) ((0x3C63C293E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCE0EFFC1174505uLL) >> 0),
    (VUINT32) ((0x3FCE0EFFC1174505uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE49A449B9B0939uLL) >> 0),
    (VUINT32) ((0x3FE49A449B9B0939uLL) >> 32)},
    {(VUINT32) ((0xBC827EE160000000uLL) >> 0),
    (VUINT32) ((0xBC827EE160000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCD0DFE53ABA2FDuLL) >> 0),
    (VUINT32) ((0x3FCD0DFE53ABA2FDuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE44CF325091DD6uLL) >> 0),
    (VUINT32) ((0x3FE44CF325091DD6uLL) >> 32)},
    {(VUINT32) ((0x3C68076A20000000uLL) >> 0),
    (VUINT32) ((0x3C68076A20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCC10CD7041AFCCuLL) >> 0),
    (VUINT32) ((0x3FCC10CD7041AFCCuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE3FED9534556D4uLL) >> 0),
    (VUINT32) ((0x3FE3FED9534556D4uLL) >> 32)},
    {(VUINT32) ((0x3C83691660000000uLL) >> 0),
    (VUINT32) ((0x3C83691660000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCB1776D9B67013uLL) >> 0),
    (VUINT32) ((0x3FCB1776D9B67013uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE3AFFA292050B9uLL) >> 0),
    (VUINT32) ((0x3FE3AFFA292050B9uLL) >> 32)},
    {(VUINT32) ((0x3C7E3E25E0000000uLL) >> 0),
    (VUINT32) ((0x3C7E3E25E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCA22042CE0A2F9uLL) >> 0),
    (VUINT32) ((0x3FCA22042CE0A2F9uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE36058B10659F3uLL) >> 0),
    (VUINT32) ((0x3FE36058B10659F3uLL) >> 32)},
    {(VUINT32) ((0xBC81FCB3A0000000uLL) >> 0),
    (VUINT32) ((0xBC81FCB3A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC9307EE031E2FDuLL) >> 0),
    (VUINT32) ((0x3FC9307EE031E2FDuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE30FF7FCE17035uLL) >> 0),
    (VUINT32) ((0x3FE30FF7FCE17035uLL) >> 32)},
    {(VUINT32) ((0xBC6EFCC620000000uLL) >> 0),
    (VUINT32) ((0xBC6EFCC620000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC842F0435941AFuLL) >> 0),
    (VUINT32) ((0x3FC842F0435941AFuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE2BEDB25FAF3EAuLL) >> 0),
    (VUINT32) ((0x3FE2BEDB25FAF3EAuLL) >> 32)},
    {(VUINT32) ((0xBC514981C0000000uLL) >> 0),
    (VUINT32) ((0xBC514981C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC759617EE761F9uLL) >> 0),
    (VUINT32) ((0x3FC759617EE761F9uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE26D054CDD12DFuLL) >> 0),
    (VUINT32) ((0x3FE26D054CDD12DFuLL) >> 32)},
    {(VUINT32) ((0xBC85DA7420000000uLL) >> 0),
    (VUINT32) ((0xBC85DA7420000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC673DB93F41479uLL) >> 0),
    (VUINT32) ((0x3FC673DB93F41479uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE21A799933EB59uLL) >> 0),
    (VUINT32) ((0x3FE21A799933EB59uLL) >> 32)},
    {(VUINT32) ((0xBC83A7B160000000uLL) >> 0),
    (VUINT32) ((0xBC83A7B160000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC592675BC57974uLL) >> 0),
    (VUINT32) ((0x3FC592675BC57974uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE1C73B39AE68C8uLL) >> 0),
    (VUINT32) ((0x3FE1C73B39AE68C8uLL) >> 32)},
    {(VUINT32) ((0x3C8B25DD20000000uLL) >> 0),
    (VUINT32) ((0x3C8B25DD20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC4B50D8778ABBDuLL) >> 0),
    (VUINT32) ((0x3FC4B50D8778ABBDuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE1734D63DEDB49uLL) >> 0),
    (VUINT32) ((0x3FE1734D63DEDB49uLL) >> 32)},
    {(VUINT32) ((0xBC87EEF2C0000000uLL) >> 0),
    (VUINT32) ((0xBC87EEF2C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC3DBD69FABF802uLL) >> 0),
    (VUINT32) ((0x3FC3DBD69FABF802uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE11EB3541B4B23uLL) >> 0),
    (VUINT32) ((0x3FE11EB3541B4B23uLL) >> 32)},
    {(VUINT32) ((0xBC8EF23B60000000uLL) >> 0),
    (VUINT32) ((0xBC8EF23B60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC306CB042AA3BAuLL) >> 0),
    (VUINT32) ((0x3FC306CB042AA3BAuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE0C9704D5D898FuLL) >> 0),
    (VUINT32) ((0x3FE0C9704D5D898FuLL) >> 32)},
    {(VUINT32) ((0xBC88D3D7C0000000uLL) >> 0),
    (VUINT32) ((0xBC88D3D7C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC235F2EB9A470AuLL) >> 0),
    (VUINT32) ((0x3FC235F2EB9A470AuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE073879922FFEEuLL) >> 0),
    (VUINT32) ((0x3FE073879922FFEEuLL) >> 32)},
    {(VUINT32) ((0xBC8A5A0140000000uLL) >> 0),
    (VUINT32) ((0xBC8A5A0140000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC169566329BCB7uLL) >> 0),
    (VUINT32) ((0x3FC169566329BCB7uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE01CFC874C3EB7uLL) >> 0),
    (VUINT32) ((0x3FE01CFC874C3EB7uLL) >> 32)},
    {(VUINT32) ((0xBC734A35E0000000uLL) >> 0),
    (VUINT32) ((0xBC734A35E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC0A0FD4E41AB5AuLL) >> 0),
    (VUINT32) ((0x3FC0A0FD4E41AB5AuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDF8BA4DBF89ABAuLL) >> 0),
    (VUINT32) ((0x3FDF8BA4DBF89ABAuLL) >> 32)},
    {(VUINT32) ((0xBC32EC1FC0000000uLL) >> 0),
    (VUINT32) ((0xBC32EC1FC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBFB9DECC6D55B8uLL) >> 0),
    (VUINT32) ((0x3FBFB9DECC6D55B8uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDEDC1952EF78D6uLL) >> 0),
    (VUINT32) ((0x3FDEDC1952EF78D6uLL) >> 32)},
    {(VUINT32) ((0xBC7DD0F7C0000000uLL) >> 0),
    (VUINT32) ((0xBC7DD0F7C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBE3A6873FA1279uLL) >> 0),
    (VUINT32) ((0x3FBE3A6873FA1279uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDE2B5D3806F63BuLL) >> 0),
    (VUINT32) ((0x3FDE2B5D3806F63BuLL) >> 32)},
    {(VUINT32) ((0x3C5E0D8900000000uLL) >> 0),
    (VUINT32) ((0x3C5E0D8900000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBCC3A65BBC6327uLL) >> 0),
    (VUINT32) ((0x3FBCC3A65BBC6327uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDD79775B86E389uLL) >> 0),
    (VUINT32) ((0x3FDD79775B86E389uLL) >> 32)},
    {(VUINT32) ((0x3C7550EC80000000uLL) >> 0),
    (VUINT32) ((0x3C7550EC80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBB55A6F65F7058uLL) >> 0),
    (VUINT32) ((0x3FBB55A6F65F7058uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDCC66E9931C45EuLL) >> 0),
    (VUINT32) ((0x3FDCC66E9931C45EuLL) >> 32)},
    {(VUINT32) ((0x3C56850E40000000uLL) >> 0),
    (VUINT32) ((0x3C56850E40000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB9F07860181D1EuLL) >> 0),
    (VUINT32) ((0x3FB9F07860181D1EuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDC1249D8011EE7uLL) >> 0),
    (VUINT32) ((0x3FDC1249D8011EE7uLL) >> 32)},
    {(VUINT32) ((0xBC7813AAA0000000uLL) >> 0),
    (VUINT32) ((0xBC7813AAA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB894285E19C468uLL) >> 0),
    (VUINT32) ((0x3FB894285E19C468uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDB5D1009E15CC0uLL) >> 0),
    (VUINT32) ((0x3FDB5D1009E15CC0uLL) >> 32)},
    {(VUINT32) ((0x3C65B362C0000000uLL) >> 0),
    (VUINT32) ((0x3C65B362C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB740C45E0E5120uLL) >> 0),
    (VUINT32) ((0x3FB740C45E0E5120uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDAA6C82B6D3FCAuLL) >> 0),
    (VUINT32) ((0x3FDAA6C82B6D3FCAuLL) >> 32)},
    {(VUINT32) ((0xBC7D5F1060000000uLL) >> 0),
    (VUINT32) ((0xBC7D5F1060000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB5F6597591B633uLL) >> 0),
    (VUINT32) ((0x3FB5F6597591B633uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD9EF7943A8ED8AuLL) >> 0),
    (VUINT32) ((0x3FD9EF7943A8ED8AuLL) >> 32)},
    {(VUINT32) ((0x3C66DA8120000000uLL) >> 0),
    (VUINT32) ((0x3C66DA8120000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB4B4F461B0CBAAuLL) >> 0),
    (VUINT32) ((0x3FB4B4F461B0CBAAuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD9372A63BC93D7uLL) >> 0),
    (VUINT32) ((0x3FD9372A63BC93D7uLL) >> 32)},
    {(VUINT32) ((0x3C66843180000000uLL) >> 0),
    (VUINT32) ((0x3C66843180000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB37CA1866B95CFuLL) >> 0),
    (VUINT32) ((0x3FB37CA1866B95CFuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD87DE2A6AEA963uLL) >> 0),
    (VUINT32) ((0x3FD87DE2A6AEA963uLL) >> 32)},
    {(VUINT32) ((0xBC672CEDC0000000uLL) >> 0),
    (VUINT32) ((0xBC672CEDC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB24D6CEE3AFB2AuLL) >> 0),
    (VUINT32) ((0x3FB24D6CEE3AFB2AuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD7C3A9311DCCE7uLL) >> 0),
    (VUINT32) ((0x3FD7C3A9311DCCE7uLL) >> 32)},
    {(VUINT32) ((0x3C19A3F200000000uLL) >> 0),
    (VUINT32) ((0x3C19A3F200000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB127624999EE1DuLL) >> 0),
    (VUINT32) ((0x3FB127624999EE1DuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD7088530FA459FuLL) >> 0),
    (VUINT32) ((0x3FD7088530FA459FuLL) >> 32)},
    {(VUINT32) ((0xBC744B19E0000000uLL) >> 0),
    (VUINT32) ((0xBC744B19E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB00A8CEE920EABuLL) >> 0),
    (VUINT32) ((0x3FB00A8CEE920EABuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD64C7DDD3F27C6uLL) >> 0),
    (VUINT32) ((0x3FD64C7DDD3F27C6uLL) >> 32)},
    {(VUINT32) ((0x3C510D2B40000000uLL) >> 0),
    (VUINT32) ((0x3C510D2B40000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FADEDEFB09791B4uLL) >> 0),
    (VUINT32) ((0x3FADEDEFB09791B4uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD58F9A75AB1FDDuLL) >> 0),
    (VUINT32) ((0x3FD58F9A75AB1FDDuLL) >> 32)},
    {(VUINT32) ((0xBC1EFDC0C0000000uLL) >> 0),
    (VUINT32) ((0xBC1EFDC0C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FABD95B4D43E819uLL) >> 0),
    (VUINT32) ((0x3FABD95B4D43E819uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD4D1E24278E76AuLL) >> 0),
    (VUINT32) ((0x3FD4D1E24278E76AuLL) >> 32)},
    {(VUINT32) ((0x3C62417200000000uLL) >> 0),
    (VUINT32) ((0x3C62417200000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA9D7713B71EEE1uLL) >> 0),
    (VUINT32) ((0x3FA9D7713B71EEE1uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD4135C94176601uLL) >> 0),
    (VUINT32) ((0x3FD4135C94176601uLL) >> 32)},
    {(VUINT32) ((0x3C70C97C40000000uLL) >> 0),
    (VUINT32) ((0x3C70C97C40000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA7E8454B32EF34uLL) >> 0),
    (VUINT32) ((0x3FA7E8454B32EF34uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD35410C2E18152uLL) >> 0),
    (VUINT32) ((0x3FD35410C2E18152uLL) >> 32)},
    {(VUINT32) ((0xBC73CB0020000000uLL) >> 0),
    (VUINT32) ((0xBC73CB0020000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA60BEA939D225AuLL) >> 0),
    (VUINT32) ((0x3FA60BEA939D225AuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD294062ED59F06uLL) >> 0),
    (VUINT32) ((0x3FD294062ED59F06uLL) >> 32)},
    {(VUINT32) ((0xBC75D28DA0000000uLL) >> 0),
    (VUINT32) ((0xBC75D28DA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA44273720F48BCuLL) >> 0),
    (VUINT32) ((0x3FA44273720F48BCuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD1D3443F4CDB3EuLL) >> 0),
    (VUINT32) ((0x3FD1D3443F4CDB3EuLL) >> 32)},
    {(VUINT32) ((0xBC6720D400000000uLL) >> 0),
    (VUINT32) ((0xBC6720D400000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA28BF1897B69CCuLL) >> 0),
    (VUINT32) ((0x3FA28BF1897B69CCuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD111D262B1F677uLL) >> 0),
    (VUINT32) ((0x3FD111D262B1F677uLL) >> 32)},
    {(VUINT32) ((0x3C7824C200000000uLL) >> 0),
    (VUINT32) ((0x3C7824C200000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA0E875C1B8C3DAuLL) >> 0),
    (VUINT32) ((0x3FA0E875C1B8C3DAuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD04FB80E37FDAEuLL) >> 0),
    (VUINT32) ((0x3FD04FB80E37FDAEuLL) >> 32)},
    {(VUINT32) ((0xBC0412CDA0000000uLL) >> 0),
    (VUINT32) ((0xBC0412CDA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9EB0208DB9E51BuLL) >> 0),
    (VUINT32) ((0x3F9EB0208DB9E51BuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCF19F97B215F1BuLL) >> 0),
    (VUINT32) ((0x3FCF19F97B215F1BuLL) >> 32)},
    {(VUINT32) ((0xBC642DEEE0000000uLL) >> 0),
    (VUINT32) ((0xBC642DEEE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9BB5A11138A4C9uLL) >> 0),
    (VUINT32) ((0x3F9BB5A11138A4C9uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCD934FE5454311uLL) >> 0),
    (VUINT32) ((0x3FCD934FE5454311uLL) >> 32)},
    {(VUINT32) ((0x3C675B9220000000uLL) >> 0),
    (VUINT32) ((0x3C675B9220000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F98E18A73634EE7uLL) >> 0),
    (VUINT32) ((0x3F98E18A73634EE7uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCC0B826A7E4F63uLL) >> 0),
    (VUINT32) ((0x3FCC0B826A7E4F63uLL) >> 32)},
    {(VUINT32) ((0xBC1AF14380000000uLL) >> 0),
    (VUINT32) ((0xBC1AF14380000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9633F89E9A1A66uLL) >> 0),
    (VUINT32) ((0x3F9633F89E9A1A66uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCA82A025B00451uLL) >> 0),
    (VUINT32) ((0x3FCA82A025B00451uLL) >> 32)},
    {(VUINT32) ((0xBC687905E0000000uLL) >> 0),
    (VUINT32) ((0xBC687905E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F93AD06011469FBuLL) >> 0),
    (VUINT32) ((0x3F93AD06011469FBuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC8F8B83C69A60BuLL) >> 0),
    (VUINT32) ((0x3FC8F8B83C69A60BuLL) >> 32)},
    {(VUINT32) ((0xBC626D19A0000000uLL) >> 0),
    (VUINT32) ((0xBC626D19A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F914CCB8BDBF114uLL) >> 0),
    (VUINT32) ((0x3F914CCB8BDBF114uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC76DD9DE50BF31uLL) >> 0),
    (VUINT32) ((0x3FC76DD9DE50BF31uLL) >> 32)},
    {(VUINT32) ((0x3C61D5EEE0000000uLL) >> 0),
    (VUINT32) ((0x3C61D5EEE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8E26C163AD15B3uLL) >> 0),
    (VUINT32) ((0x3F8E26C163AD15B3uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC5E214448B3FC6uLL) >> 0),
    (VUINT32) ((0x3FC5E214448B3FC6uLL) >> 32)},
    {(VUINT32) ((0x3C6531FF60000000uLL) >> 0),
    (VUINT32) ((0x3C6531FF60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8A01B6CDBD995EuLL) >> 0),
    (VUINT32) ((0x3F8A01B6CDBD995EuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC45576B1293E5AuLL) >> 0),
    (VUINT32) ((0x3FC45576B1293E5AuLL) >> 32)},
    {(VUINT32) ((0xBC5285A240000000uLL) >> 0),
    (VUINT32) ((0xBC5285A240000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F862AA03DD6BA58uLL) >> 0),
    (VUINT32) ((0x3F862AA03DD6BA58uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC2C8106E8E613AuLL) >> 0),
    (VUINT32) ((0x3FC2C8106E8E613AuLL) >> 32)},
    {(VUINT32) ((0x3C513000A0000000uLL) >> 0),
    (VUINT32) ((0x3C513000A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F82A1A39A8A2FB7uLL) >> 0),
    (VUINT32) ((0x3F82A1A39A8A2FB7uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC139F0CEDAF577uLL) >> 0),
    (VUINT32) ((0x3FC139F0CEDAF577uLL) >> 32)},
    {(VUINT32) ((0xBC65234340000000uLL) >> 0),
    (VUINT32) ((0xBC65234340000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F7ECDC78F30165CuLL) >> 0),
    (VUINT32) ((0x3F7ECDC78F30165CuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBF564E56A9730EuLL) >> 0),
    (VUINT32) ((0x3FBF564E56A9730EuLL) >> 32)},
    {(VUINT32) ((0x3C4A270460000000uLL) >> 0),
    (VUINT32) ((0x3C4A270460000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F78F501492CC296uLL) >> 0),
    (VUINT32) ((0x3F78F501492CC296uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBC3785C79EC2D5uLL) >> 0),
    (VUINT32) ((0x3FBC3785C79EC2D5uLL) >> 32)},
    {(VUINT32) ((0xBC24F39DE0000000uLL) >> 0),
    (VUINT32) ((0xBC24F39DE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F73B92E176D6D31uLL) >> 0),
    (VUINT32) ((0x3F73B92E176D6D31uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB917A6BC29B42CuLL) >> 0),
    (VUINT32) ((0x3FB917A6BC29B42CuLL) >> 32)},
    {(VUINT32) ((0xBC3E2718C0000000uLL) >> 0),
    (VUINT32) ((0xBC3E2718C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F6E350342A4F6E6uLL) >> 0),
    (VUINT32) ((0x3F6E350342A4F6E6uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5F6D00A9AA419uLL) >> 0),
    (VUINT32) ((0x3FB5F6D00A9AA419uLL) >> 32)},
    {(VUINT32) ((0xBC4F4022C0000000uLL) >> 0),
    (VUINT32) ((0xBC4F4022C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F663252FE77C5EBuLL) >> 0),
    (VUINT32) ((0x3F663252FE77C5EBuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB2D52092CE19F6uLL) >> 0),
    (VUINT32) ((0x3FB2D52092CE19F6uLL) >> 32)},
    {(VUINT32) ((0xBC49A088A0000000uLL) >> 0),
    (VUINT32) ((0xBC49A088A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F5ED534E31CA57FuLL) >> 0),
    (VUINT32) ((0x3F5ED534E31CA57FuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FAF656E79F820E0uLL) >> 0),
    (VUINT32) ((0x3FAF656E79F820E0uLL) >> 32)},
    {(VUINT32) ((0xBC22E1EBE0000000uLL) >> 0),
    (VUINT32) ((0xBC22E1EBE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F53BC390D250439uLL) >> 0),
    (VUINT32) ((0x3F53BC390D250439uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA91F65F10DD814uLL) >> 0),
    (VUINT32) ((0x3FA91F65F10DD814uLL) >> 32)},
    {(VUINT32) ((0xBC2912BD00000000uLL) >> 0),
    (VUINT32) ((0xBC2912BD00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F46344004228D8BuLL) >> 0),
    (VUINT32) ((0x3F46344004228D8BuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA2D865759455CDuLL) >> 0),
    (VUINT32) ((0x3FA2D865759455CDuLL) >> 32)},
    {(VUINT32) ((0x3C2686F640000000uLL) >> 0),
    (VUINT32) ((0x3C2686F640000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F33BCFBD9979A27uLL) >> 0),
    (VUINT32) ((0x3F33BCFBD9979A27uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F992155F7A3667EuLL) >> 0),
    (VUINT32) ((0x3F992155F7A3667EuLL) >> 32)},
    {(VUINT32) ((0xBBFB1D6300000000uLL) >> 0),
    (VUINT32) ((0xBBFB1D6300000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F13BD2C8DA49511uLL) >> 0),
    (VUINT32) ((0x3F13BD2C8DA49511uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F8921D1FCDEC784uLL) >> 0),
    (VUINT32) ((0x3F8921D1FCDEC784uLL) >> 32)},
    {(VUINT32) ((0x3C29878EA0000000uLL) >> 0),
    (VUINT32) ((0x3C29878EA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F13BD2C8DA49511uLL) >> 0),
    (VUINT32) ((0x3F13BD2C8DA49511uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF8921D1FCDEC784uLL) >> 0),
    (VUINT32) ((0xBF8921D1FCDEC784uLL) >> 32)},
    {(VUINT32) ((0xBC29878EA0000000uLL) >> 0),
    (VUINT32) ((0xBC29878EA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F33BCFBD9979A27uLL) >> 0),
    (VUINT32) ((0x3F33BCFBD9979A27uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF992155F7A3667EuLL) >> 0),
    (VUINT32) ((0xBF992155F7A3667EuLL) >> 32)},
    {(VUINT32) ((0x3BFB1D6300000000uLL) >> 0),
    (VUINT32) ((0x3BFB1D6300000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F46344004228D8BuLL) >> 0),
    (VUINT32) ((0x3F46344004228D8BuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA2D865759455CDuLL) >> 0),
    (VUINT32) ((0xBFA2D865759455CDuLL) >> 32)},
    {(VUINT32) ((0xBC2686F640000000uLL) >> 0),
    (VUINT32) ((0xBC2686F640000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F53BC390D250439uLL) >> 0),
    (VUINT32) ((0x3F53BC390D250439uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA91F65F10DD814uLL) >> 0),
    (VUINT32) ((0xBFA91F65F10DD814uLL) >> 32)},
    {(VUINT32) ((0x3C2912BD00000000uLL) >> 0),
    (VUINT32) ((0x3C2912BD00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F5ED534E31CA57FuLL) >> 0),
    (VUINT32) ((0x3F5ED534E31CA57FuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFAF656E79F820E0uLL) >> 0),
    (VUINT32) ((0xBFAF656E79F820E0uLL) >> 32)},
    {(VUINT32) ((0x3C22E1EBE0000000uLL) >> 0),
    (VUINT32) ((0x3C22E1EBE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F663252FE77C5EBuLL) >> 0),
    (VUINT32) ((0x3F663252FE77C5EBuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB2D52092CE19F6uLL) >> 0),
    (VUINT32) ((0xBFB2D52092CE19F6uLL) >> 32)},
    {(VUINT32) ((0x3C49A088A0000000uLL) >> 0),
    (VUINT32) ((0x3C49A088A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F6E350342A4F6E6uLL) >> 0),
    (VUINT32) ((0x3F6E350342A4F6E6uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB5F6D00A9AA419uLL) >> 0),
    (VUINT32) ((0xBFB5F6D00A9AA419uLL) >> 32)},
    {(VUINT32) ((0x3C4F4022C0000000uLL) >> 0),
    (VUINT32) ((0x3C4F4022C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F73B92E176D6D31uLL) >> 0),
    (VUINT32) ((0x3F73B92E176D6D31uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB917A6BC29B42CuLL) >> 0),
    (VUINT32) ((0xBFB917A6BC29B42CuLL) >> 32)},
    {(VUINT32) ((0x3C3E2718C0000000uLL) >> 0),
    (VUINT32) ((0x3C3E2718C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F78F501492CC296uLL) >> 0),
    (VUINT32) ((0x3F78F501492CC296uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBC3785C79EC2D5uLL) >> 0),
    (VUINT32) ((0xBFBC3785C79EC2D5uLL) >> 32)},
    {(VUINT32) ((0x3C24F39DE0000000uLL) >> 0),
    (VUINT32) ((0x3C24F39DE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F7ECDC78F30165CuLL) >> 0),
    (VUINT32) ((0x3F7ECDC78F30165CuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBF564E56A9730EuLL) >> 0),
    (VUINT32) ((0xBFBF564E56A9730EuLL) >> 32)},
    {(VUINT32) ((0xBC4A270460000000uLL) >> 0),
    (VUINT32) ((0xBC4A270460000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F82A1A39A8A2FB7uLL) >> 0),
    (VUINT32) ((0x3F82A1A39A8A2FB7uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC139F0CEDAF577uLL) >> 0),
    (VUINT32) ((0xBFC139F0CEDAF577uLL) >> 32)},
    {(VUINT32) ((0x3C65234340000000uLL) >> 0),
    (VUINT32) ((0x3C65234340000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F862AA03DD6BA58uLL) >> 0),
    (VUINT32) ((0x3F862AA03DD6BA58uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC2C8106E8E613AuLL) >> 0),
    (VUINT32) ((0xBFC2C8106E8E613AuLL) >> 32)},
    {(VUINT32) ((0xBC513000A0000000uLL) >> 0),
    (VUINT32) ((0xBC513000A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8A01B6CDBD995EuLL) >> 0),
    (VUINT32) ((0x3F8A01B6CDBD995EuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC45576B1293E5AuLL) >> 0),
    (VUINT32) ((0xBFC45576B1293E5AuLL) >> 32)},
    {(VUINT32) ((0x3C5285A240000000uLL) >> 0),
    (VUINT32) ((0x3C5285A240000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8E26C163AD15B3uLL) >> 0),
    (VUINT32) ((0x3F8E26C163AD15B3uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC5E214448B3FC6uLL) >> 0),
    (VUINT32) ((0xBFC5E214448B3FC6uLL) >> 32)},
    {(VUINT32) ((0xBC6531FF60000000uLL) >> 0),
    (VUINT32) ((0xBC6531FF60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F914CCB8BDBF114uLL) >> 0),
    (VUINT32) ((0x3F914CCB8BDBF114uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC76DD9DE50BF31uLL) >> 0),
    (VUINT32) ((0xBFC76DD9DE50BF31uLL) >> 32)},
    {(VUINT32) ((0xBC61D5EEE0000000uLL) >> 0),
    (VUINT32) ((0xBC61D5EEE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F93AD06011469FBuLL) >> 0),
    (VUINT32) ((0x3F93AD06011469FBuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC8F8B83C69A60BuLL) >> 0),
    (VUINT32) ((0xBFC8F8B83C69A60BuLL) >> 32)},
    {(VUINT32) ((0x3C626D19A0000000uLL) >> 0),
    (VUINT32) ((0x3C626D19A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9633F89E9A1A66uLL) >> 0),
    (VUINT32) ((0x3F9633F89E9A1A66uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCA82A025B00451uLL) >> 0),
    (VUINT32) ((0xBFCA82A025B00451uLL) >> 32)},
    {(VUINT32) ((0x3C687905E0000000uLL) >> 0),
    (VUINT32) ((0x3C687905E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F98E18A73634EE7uLL) >> 0),
    (VUINT32) ((0x3F98E18A73634EE7uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCC0B826A7E4F63uLL) >> 0),
    (VUINT32) ((0xBFCC0B826A7E4F63uLL) >> 32)},
    {(VUINT32) ((0x3C1AF14380000000uLL) >> 0),
    (VUINT32) ((0x3C1AF14380000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9BB5A11138A4C9uLL) >> 0),
    (VUINT32) ((0x3F9BB5A11138A4C9uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCD934FE5454311uLL) >> 0),
    (VUINT32) ((0xBFCD934FE5454311uLL) >> 32)},
    {(VUINT32) ((0xBC675B9220000000uLL) >> 0),
    (VUINT32) ((0xBC675B9220000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9EB0208DB9E51BuLL) >> 0),
    (VUINT32) ((0x3F9EB0208DB9E51BuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCF19F97B215F1BuLL) >> 0),
    (VUINT32) ((0xBFCF19F97B215F1BuLL) >> 32)},
    {(VUINT32) ((0x3C642DEEE0000000uLL) >> 0),
    (VUINT32) ((0x3C642DEEE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA0E875C1B8C3DAuLL) >> 0),
    (VUINT32) ((0x3FA0E875C1B8C3DAuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD04FB80E37FDAEuLL) >> 0),
    (VUINT32) ((0xBFD04FB80E37FDAEuLL) >> 32)},
    {(VUINT32) ((0x3C0412CDA0000000uLL) >> 0),
    (VUINT32) ((0x3C0412CDA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA28BF1897B69CCuLL) >> 0),
    (VUINT32) ((0x3FA28BF1897B69CCuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD111D262B1F677uLL) >> 0),
    (VUINT32) ((0xBFD111D262B1F677uLL) >> 32)},
    {(VUINT32) ((0xBC7824C200000000uLL) >> 0),
    (VUINT32) ((0xBC7824C200000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA44273720F48BCuLL) >> 0),
    (VUINT32) ((0x3FA44273720F48BCuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD1D3443F4CDB3EuLL) >> 0),
    (VUINT32) ((0xBFD1D3443F4CDB3EuLL) >> 32)},
    {(VUINT32) ((0x3C6720D400000000uLL) >> 0),
    (VUINT32) ((0x3C6720D400000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA60BEA939D225AuLL) >> 0),
    (VUINT32) ((0x3FA60BEA939D225AuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD294062ED59F06uLL) >> 0),
    (VUINT32) ((0xBFD294062ED59F06uLL) >> 32)},
    {(VUINT32) ((0x3C75D28DA0000000uLL) >> 0),
    (VUINT32) ((0x3C75D28DA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA7E8454B32EF34uLL) >> 0),
    (VUINT32) ((0x3FA7E8454B32EF34uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD35410C2E18152uLL) >> 0),
    (VUINT32) ((0xBFD35410C2E18152uLL) >> 32)},
    {(VUINT32) ((0x3C73CB0020000000uLL) >> 0),
    (VUINT32) ((0x3C73CB0020000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA9D7713B71EEE1uLL) >> 0),
    (VUINT32) ((0x3FA9D7713B71EEE1uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD4135C94176601uLL) >> 0),
    (VUINT32) ((0xBFD4135C94176601uLL) >> 32)},
    {(VUINT32) ((0xBC70C97C40000000uLL) >> 0),
    (VUINT32) ((0xBC70C97C40000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FABD95B4D43E819uLL) >> 0),
    (VUINT32) ((0x3FABD95B4D43E819uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD4D1E24278E76AuLL) >> 0),
    (VUINT32) ((0xBFD4D1E24278E76AuLL) >> 32)},
    {(VUINT32) ((0xBC62417200000000uLL) >> 0),
    (VUINT32) ((0xBC62417200000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FADEDEFB09791B4uLL) >> 0),
    (VUINT32) ((0x3FADEDEFB09791B4uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD58F9A75AB1FDDuLL) >> 0),
    (VUINT32) ((0xBFD58F9A75AB1FDDuLL) >> 32)},
    {(VUINT32) ((0x3C1EFDC0C0000000uLL) >> 0),
    (VUINT32) ((0x3C1EFDC0C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB00A8CEE920EABuLL) >> 0),
    (VUINT32) ((0x3FB00A8CEE920EABuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD64C7DDD3F27C6uLL) >> 0),
    (VUINT32) ((0xBFD64C7DDD3F27C6uLL) >> 32)},
    {(VUINT32) ((0xBC510D2B40000000uLL) >> 0),
    (VUINT32) ((0xBC510D2B40000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB127624999EE1DuLL) >> 0),
    (VUINT32) ((0x3FB127624999EE1DuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD7088530FA459FuLL) >> 0),
    (VUINT32) ((0xBFD7088530FA459FuLL) >> 32)},
    {(VUINT32) ((0x3C744B19E0000000uLL) >> 0),
    (VUINT32) ((0x3C744B19E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB24D6CEE3AFB2AuLL) >> 0),
    (VUINT32) ((0x3FB24D6CEE3AFB2AuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD7C3A9311DCCE7uLL) >> 0),
    (VUINT32) ((0xBFD7C3A9311DCCE7uLL) >> 32)},
    {(VUINT32) ((0xBC19A3F200000000uLL) >> 0),
    (VUINT32) ((0xBC19A3F200000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB37CA1866B95CFuLL) >> 0),
    (VUINT32) ((0x3FB37CA1866B95CFuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD87DE2A6AEA963uLL) >> 0),
    (VUINT32) ((0xBFD87DE2A6AEA963uLL) >> 32)},
    {(VUINT32) ((0x3C672CEDC0000000uLL) >> 0),
    (VUINT32) ((0x3C672CEDC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB4B4F461B0CBAAuLL) >> 0),
    (VUINT32) ((0x3FB4B4F461B0CBAAuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD9372A63BC93D7uLL) >> 0),
    (VUINT32) ((0xBFD9372A63BC93D7uLL) >> 32)},
    {(VUINT32) ((0xBC66843180000000uLL) >> 0),
    (VUINT32) ((0xBC66843180000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB5F6597591B633uLL) >> 0),
    (VUINT32) ((0x3FB5F6597591B633uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD9EF7943A8ED8AuLL) >> 0),
    (VUINT32) ((0xBFD9EF7943A8ED8AuLL) >> 32)},
    {(VUINT32) ((0xBC66DA8120000000uLL) >> 0),
    (VUINT32) ((0xBC66DA8120000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB740C45E0E5120uLL) >> 0),
    (VUINT32) ((0x3FB740C45E0E5120uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDAA6C82B6D3FCAuLL) >> 0),
    (VUINT32) ((0xBFDAA6C82B6D3FCAuLL) >> 32)},
    {(VUINT32) ((0x3C7D5F1060000000uLL) >> 0),
    (VUINT32) ((0x3C7D5F1060000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB894285E19C468uLL) >> 0),
    (VUINT32) ((0x3FB894285E19C468uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDB5D1009E15CC0uLL) >> 0),
    (VUINT32) ((0xBFDB5D1009E15CC0uLL) >> 32)},
    {(VUINT32) ((0xBC65B362C0000000uLL) >> 0),
    (VUINT32) ((0xBC65B362C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB9F07860181D1EuLL) >> 0),
    (VUINT32) ((0x3FB9F07860181D1EuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDC1249D8011EE7uLL) >> 0),
    (VUINT32) ((0xBFDC1249D8011EE7uLL) >> 32)},
    {(VUINT32) ((0x3C7813AAA0000000uLL) >> 0),
    (VUINT32) ((0x3C7813AAA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBB55A6F65F7058uLL) >> 0),
    (VUINT32) ((0x3FBB55A6F65F7058uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDCC66E9931C45EuLL) >> 0),
    (VUINT32) ((0xBFDCC66E9931C45EuLL) >> 32)},
    {(VUINT32) ((0xBC56850E40000000uLL) >> 0),
    (VUINT32) ((0xBC56850E40000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBCC3A65BBC6327uLL) >> 0),
    (VUINT32) ((0x3FBCC3A65BBC6327uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDD79775B86E389uLL) >> 0),
    (VUINT32) ((0xBFDD79775B86E389uLL) >> 32)},
    {(VUINT32) ((0xBC7550EC80000000uLL) >> 0),
    (VUINT32) ((0xBC7550EC80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBE3A6873FA1279uLL) >> 0),
    (VUINT32) ((0x3FBE3A6873FA1279uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDE2B5D3806F63BuLL) >> 0),
    (VUINT32) ((0xBFDE2B5D3806F63BuLL) >> 32)},
    {(VUINT32) ((0xBC5E0D8900000000uLL) >> 0),
    (VUINT32) ((0xBC5E0D8900000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBFB9DECC6D55B8uLL) >> 0),
    (VUINT32) ((0x3FBFB9DECC6D55B8uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDEDC1952EF78D6uLL) >> 0),
    (VUINT32) ((0xBFDEDC1952EF78D6uLL) >> 32)},
    {(VUINT32) ((0x3C7DD0F7C0000000uLL) >> 0),
    (VUINT32) ((0x3C7DD0F7C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC0A0FD4E41AB5AuLL) >> 0),
    (VUINT32) ((0x3FC0A0FD4E41AB5AuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDF8BA4DBF89ABAuLL) >> 0),
    (VUINT32) ((0xBFDF8BA4DBF89ABAuLL) >> 32)},
    {(VUINT32) ((0x3C32EC1FC0000000uLL) >> 0),
    (VUINT32) ((0x3C32EC1FC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC169566329BCB7uLL) >> 0),
    (VUINT32) ((0x3FC169566329BCB7uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE01CFC874C3EB7uLL) >> 0),
    (VUINT32) ((0xBFE01CFC874C3EB7uLL) >> 32)},
    {(VUINT32) ((0x3C734A35E0000000uLL) >> 0),
    (VUINT32) ((0x3C734A35E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC235F2EB9A470AuLL) >> 0),
    (VUINT32) ((0x3FC235F2EB9A470AuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE073879922FFEEuLL) >> 0),
    (VUINT32) ((0xBFE073879922FFEEuLL) >> 32)},
    {(VUINT32) ((0x3C8A5A0140000000uLL) >> 0),
    (VUINT32) ((0x3C8A5A0140000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC306CB042AA3BAuLL) >> 0),
    (VUINT32) ((0x3FC306CB042AA3BAuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE0C9704D5D898FuLL) >> 0),
    (VUINT32) ((0xBFE0C9704D5D898FuLL) >> 32)},
    {(VUINT32) ((0x3C88D3D7C0000000uLL) >> 0),
    (VUINT32) ((0x3C88D3D7C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC3DBD69FABF802uLL) >> 0),
    (VUINT32) ((0x3FC3DBD69FABF802uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE11EB3541B4B23uLL) >> 0),
    (VUINT32) ((0xBFE11EB3541B4B23uLL) >> 32)},
    {(VUINT32) ((0x3C8EF23B60000000uLL) >> 0),
    (VUINT32) ((0x3C8EF23B60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC4B50D8778ABBDuLL) >> 0),
    (VUINT32) ((0x3FC4B50D8778ABBDuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE1734D63DEDB49uLL) >> 0),
    (VUINT32) ((0xBFE1734D63DEDB49uLL) >> 32)},
    {(VUINT32) ((0x3C87EEF2C0000000uLL) >> 0),
    (VUINT32) ((0x3C87EEF2C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC592675BC57974uLL) >> 0),
    (VUINT32) ((0x3FC592675BC57974uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE1C73B39AE68C8uLL) >> 0),
    (VUINT32) ((0xBFE1C73B39AE68C8uLL) >> 32)},
    {(VUINT32) ((0xBC8B25DD20000000uLL) >> 0),
    (VUINT32) ((0xBC8B25DD20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC673DB93F41479uLL) >> 0),
    (VUINT32) ((0x3FC673DB93F41479uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE21A799933EB59uLL) >> 0),
    (VUINT32) ((0xBFE21A799933EB59uLL) >> 32)},
    {(VUINT32) ((0x3C83A7B160000000uLL) >> 0),
    (VUINT32) ((0x3C83A7B160000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC759617EE761F9uLL) >> 0),
    (VUINT32) ((0x3FC759617EE761F9uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE26D054CDD12DFuLL) >> 0),
    (VUINT32) ((0xBFE26D054CDD12DFuLL) >> 32)},
    {(VUINT32) ((0x3C85DA7420000000uLL) >> 0),
    (VUINT32) ((0x3C85DA7420000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC842F0435941AFuLL) >> 0),
    (VUINT32) ((0x3FC842F0435941AFuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE2BEDB25FAF3EAuLL) >> 0),
    (VUINT32) ((0xBFE2BEDB25FAF3EAuLL) >> 32)},
    {(VUINT32) ((0x3C514981C0000000uLL) >> 0),
    (VUINT32) ((0x3C514981C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC9307EE031E2FDuLL) >> 0),
    (VUINT32) ((0x3FC9307EE031E2FDuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE30FF7FCE17035uLL) >> 0),
    (VUINT32) ((0xBFE30FF7FCE17035uLL) >> 32)},
    {(VUINT32) ((0x3C6EFCC620000000uLL) >> 0),
    (VUINT32) ((0x3C6EFCC620000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCA22042CE0A2F9uLL) >> 0),
    (VUINT32) ((0x3FCA22042CE0A2F9uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE36058B10659F3uLL) >> 0),
    (VUINT32) ((0xBFE36058B10659F3uLL) >> 32)},
    {(VUINT32) ((0x3C81FCB3A0000000uLL) >> 0),
    (VUINT32) ((0x3C81FCB3A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCB1776D9B67013uLL) >> 0),
    (VUINT32) ((0x3FCB1776D9B67013uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE3AFFA292050B9uLL) >> 0),
    (VUINT32) ((0xBFE3AFFA292050B9uLL) >> 32)},
    {(VUINT32) ((0xBC7E3E25E0000000uLL) >> 0),
    (VUINT32) ((0xBC7E3E25E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCC10CD7041AFCCuLL) >> 0),
    (VUINT32) ((0x3FCC10CD7041AFCCuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE3FED9534556D4uLL) >> 0),
    (VUINT32) ((0xBFE3FED9534556D4uLL) >> 32)},
    {(VUINT32) ((0xBC83691660000000uLL) >> 0),
    (VUINT32) ((0xBC83691660000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCD0DFE53ABA2FDuLL) >> 0),
    (VUINT32) ((0x3FCD0DFE53ABA2FDuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE44CF325091DD6uLL) >> 0),
    (VUINT32) ((0xBFE44CF325091DD6uLL) >> 32)},
    {(VUINT32) ((0xBC68076A20000000uLL) >> 0),
    (VUINT32) ((0xBC68076A20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCE0EFFC1174505uLL) >> 0),
    (VUINT32) ((0x3FCE0EFFC1174505uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE49A449B9B0939uLL) >> 0),
    (VUINT32) ((0xBFE49A449B9B0939uLL) >> 32)},
    {(VUINT32) ((0x3C827EE160000000uLL) >> 0),
    (VUINT32) ((0x3C827EE160000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCF13C7D001A249uLL) >> 0),
    (VUINT32) ((0x3FCF13C7D001A249uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE4E6CABBE3E5E9uLL) >> 0),
    (VUINT32) ((0xBFE4E6CABBE3E5E9uLL) >> 32)},
    {(VUINT32) ((0xBC63C293E0000000uLL) >> 0),
    (VUINT32) ((0xBC63C293E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCFE3B38D5C5DC2uLL) >> 0),
    (VUINT32) ((0xBFCFE3B38D5C5DC2uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE5328292A35596uLL) >> 0),
    (VUINT32) ((0xBFE5328292A35596uLL) >> 32)},
    {(VUINT32) ((0x3C7A12EB80000000uLL) >> 0),
    (VUINT32) ((0x3C7A12EB80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCED77C89AABEBBuLL) >> 0),
    (VUINT32) ((0xBFCED77C89AABEBBuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE57D69348CECA0uLL) >> 0),
    (VUINT32) ((0xBFE57D69348CECA0uLL) >> 32)},
    {(VUINT32) ((0x3C87572080000000uLL) >> 0),
    (VUINT32) ((0x3C87572080000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCDC79D7C0DC985uLL) >> 0),
    (VUINT32) ((0xBFCDC79D7C0DC985uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE5C77BBE65018CuLL) >> 0),
    (VUINT32) ((0xBFE5C77BBE65018CuLL) >> 32)},
    {(VUINT32) ((0xBC8069EA80000000uLL) >> 0),
    (VUINT32) ((0xBC8069EA80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCCB420DFBFFE59uLL) >> 0),
    (VUINT32) ((0xBFCCB420DFBFFE59uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE610B7551D2CDFuLL) >> 0),
    (VUINT32) ((0xBFE610B7551D2CDFuLL) >> 32)},
    {(VUINT32) ((0x3C7251B340000000uLL) >> 0),
    (VUINT32) ((0x3C7251B340000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCB9D1153AAA2BAuLL) >> 0),
    (VUINT32) ((0xBFCB9D1153AAA2BAuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE6591925F0783DuLL) >> 0),
    (VUINT32) ((0xBFE6591925F0783DuLL) >> 32)},
    {(VUINT32) ((0xBC8C3D64E0000000uLL) >> 0),
    (VUINT32) ((0xBC8C3D64E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCA827999FCEF32uLL) >> 0),
    (VUINT32) ((0xBFCA827999FCEF32uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE6A09E667F3BCDuLL) >> 0),
    (VUINT32) ((0xBFE6A09E667F3BCDuLL) >> 32)},
    {(VUINT32) ((0x3C8BDD3400000000uLL) >> 0),
    (VUINT32) ((0x3C8BDD3400000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC9646497C1E0F6uLL) >> 0),
    (VUINT32) ((0xBFC9646497C1E0F6uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE6E74454EAA8AFuLL) >> 0),
    (VUINT32) ((0xBFE6E74454EAA8AFuLL) >> 32)},
    {(VUINT32) ((0x3C8DBC03C0000000uLL) >> 0),
    (VUINT32) ((0x3C8DBC03C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC842DD5474B37BuLL) >> 0),
    (VUINT32) ((0xBFC842DD5474B37BuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE72D0837EFFF96uLL) >> 0),
    (VUINT32) ((0xBFE72D0837EFFF96uLL) >> 32)},
    {(VUINT32) ((0xBC80D4EF00000000uLL) >> 0),
    (VUINT32) ((0xBC80D4EF00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC71DEEF9940631uLL) >> 0),
    (VUINT32) ((0xBFC71DEEF9940631uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE771E75F037261uLL) >> 0),
    (VUINT32) ((0xBFE771E75F037261uLL) >> 32)},
    {(VUINT32) ((0xBC75CFCE80000000uLL) >> 0),
    (VUINT32) ((0xBC75CFCE80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC5F5A4D233B27FuLL) >> 0),
    (VUINT32) ((0xBFC5F5A4D233B27FuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE7B5DF226AAFAFuLL) >> 0),
    (VUINT32) ((0xBFE7B5DF226AAFAFuLL) >> 32)},
    {(VUINT32) ((0x3C70F537A0000000uLL) >> 0),
    (VUINT32) ((0x3C70F537A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC4CA0A4A8D5657uLL) >> 0),
    (VUINT32) ((0xBFC4CA0A4A8D5657uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE7F8ECE3571771uLL) >> 0),
    (VUINT32) ((0xBFE7F8ECE3571771uLL) >> 32)},
    {(VUINT32) ((0x3C89C8D8C0000000uLL) >> 0),
    (VUINT32) ((0x3C89C8D8C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC39B2AEF8F97A4uLL) >> 0),
    (VUINT32) ((0xBFC39B2AEF8F97A4uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE83B0E0BFF976EuLL) >> 0),
    (VUINT32) ((0xBFE83B0E0BFF976EuLL) >> 32)},
    {(VUINT32) ((0x3C76F420E0000000uLL) >> 0),
    (VUINT32) ((0x3C76F420E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC269126E6C24E3uLL) >> 0),
    (VUINT32) ((0xBFC269126E6C24E3uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE87C400FBA2EBFuLL) >> 0),
    (VUINT32) ((0xBFE87C400FBA2EBFuLL) >> 32)},
    {(VUINT32) ((0x3C82DABC00000000uLL) >> 0),
    (VUINT32) ((0x3C82DABC00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC133CC94247758uLL) >> 0),
    (VUINT32) ((0xBFC133CC94247758uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE8BC806B151741uLL) >> 0),
    (VUINT32) ((0xBFE8BC806B151741uLL) >> 32)},
    {(VUINT32) ((0x3C82C5E120000000uLL) >> 0),
    (VUINT32) ((0x3C82C5E120000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBFF6CA9A2AB6A2uLL) >> 0),
    (VUINT32) ((0xBFBFF6CA9A2AB6A2uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE8FBCCA3EF940DuLL) >> 0),
    (VUINT32) ((0xBFE8FBCCA3EF940DuLL) >> 32)},
    {(VUINT32) ((0x3C66DFA980000000uLL) >> 0),
    (VUINT32) ((0x3C66DFA980000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBD7FD1490285CAuLL) >> 0),
    (VUINT32) ((0xBFBD7FD1490285CAuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE93A22499263FBuLL) >> 0),
    (VUINT32) ((0xBFE93A22499263FBuLL) >> 32)},
    {(VUINT32) ((0xBC83D419A0000000uLL) >> 0),
    (VUINT32) ((0xBC83D419A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBB02C58832CF96uLL) >> 0),
    (VUINT32) ((0xBFBB02C58832CF96uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE9777EF4C7D742uLL) >> 0),
    (VUINT32) ((0xBFE9777EF4C7D742uLL) >> 32)},
    {(VUINT32) ((0x3C815479A0000000uLL) >> 0),
    (VUINT32) ((0x3C815479A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB87FBFE70B81A7uLL) >> 0),
    (VUINT32) ((0xBFB87FBFE70B81A7uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE9B3E047F38741uLL) >> 0),
    (VUINT32) ((0xBFE9B3E047F38741uLL) >> 32)},
    {(VUINT32) ((0x3C830EE280000000uLL) >> 0),
    (VUINT32) ((0x3C830EE280000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB5F6D92FD79F50uLL) >> 0),
    (VUINT32) ((0xBFB5F6D92FD79F50uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE9EF43EF29AF94uLL) >> 0),
    (VUINT32) ((0xBFE9EF43EF29AF94uLL) >> 32)},
    {(VUINT32) ((0xBC7B1DFCA0000000uLL) >> 0),
    (VUINT32) ((0xBC7B1DFCA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB3682A66E896F5uLL) >> 0),
    (VUINT32) ((0xBFB3682A66E896F5uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEA29A7A0462782uLL) >> 0),
    (VUINT32) ((0xBFEA29A7A0462782uLL) >> 32)},
    {(VUINT32) ((0x3C7128BB00000000uLL) >> 0),
    (VUINT32) ((0x3C7128BB00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB0D3CCC99F5AC6uLL) >> 0),
    (VUINT32) ((0xBFB0D3CCC99F5AC6uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEA63091B02FAE2uLL) >> 0),
    (VUINT32) ((0xBFEA63091B02FAE2uLL) >> 32)},
    {(VUINT32) ((0x3C7E911140000000uLL) >> 0),
    (VUINT32) ((0x3C7E911140000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFAC73B39AE68C87uLL) >> 0),
    (VUINT32) ((0xBFAC73B39AE68C87uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEA9B66290EA1A3uLL) >> 0),
    (VUINT32) ((0xBFEA9B66290EA1A3uLL) >> 32)},
    {(VUINT32) ((0xBC39F630E0000000uLL) >> 0),
    (VUINT32) ((0xBC39F630E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA734D63DEDB48AuLL) >> 0),
    (VUINT32) ((0xBFA734D63DEDB48AuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEAD2BC9E21D511uLL) >> 0),
    (VUINT32) ((0xBFEAD2BC9E21D511uLL) >> 32)},
    {(VUINT32) ((0x3C847FBE00000000uLL) >> 0),
    (VUINT32) ((0x3C847FBE00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA1EB3541B4B228uLL) >> 0),
    (VUINT32) ((0xBFA1EB3541B4B228uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEB090A58150200uLL) >> 0),
    (VUINT32) ((0xBFEB090A58150200uLL) >> 32)},
    {(VUINT32) ((0x3C8926DA20000000uLL) >> 0),
    (VUINT32) ((0x3C8926DA20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF992E09ABB131D4uLL) >> 0),
    (VUINT32) ((0xBF992E09ABB131D4uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEB3E4D3EF55712uLL) >> 0),
    (VUINT32) ((0xBFEB3E4D3EF55712uLL) >> 32)},
    {(VUINT32) ((0x3C8EB6B8A0000000uLL) >> 0),
    (VUINT32) ((0x3C8EB6B8A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8CE1E648BFFB66uLL) >> 0),
    (VUINT32) ((0xBF8CE1E648BFFB66uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEB728345196E3EuLL) >> 0),
    (VUINT32) ((0xBFEB728345196E3EuLL) >> 32)},
    {(VUINT32) ((0x3C8BC69F20000000uLL) >> 0),
    (VUINT32) ((0x3C8BC69F20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF6CFC874C3EB6D9uLL) >> 0),
    (VUINT32) ((0xBF6CFC874C3EB6D9uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEBA5AA673590D2uLL) >> 0),
    (VUINT32) ((0xBFEBA5AA673590D2uLL) >> 32)},
    {(VUINT32) ((0xBC87EA4E20000000uLL) >> 0),
    (VUINT32) ((0xBC87EA4E20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F7D16C901D95181uLL) >> 0),
    (VUINT32) ((0x3F7D16C901D95181uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEBD7C0AC6F952AuLL) >> 0),
    (VUINT32) ((0xBFEBD7C0AC6F952AuLL) >> 32)},
    {(VUINT32) ((0x3C8825A720000000uLL) >> 0),
    (VUINT32) ((0x3C8825A720000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F923E6AD10872A7uLL) >> 0),
    (VUINT32) ((0x3F923E6AD10872A7uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC08C426725549uLL) >> 0),
    (VUINT32) ((0xBFEC08C426725549uLL) >> 32)},
    {(VUINT32) ((0xBC5B157FC0000000uLL) >> 0),
    (VUINT32) ((0xBC5B157FC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9D4A2C7F909C4EuLL) >> 0),
    (VUINT32) ((0x3F9D4A2C7F909C4EuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC38B2F180BDB1uLL) >> 0),
    (VUINT32) ((0xBFEC38B2F180BDB1uLL) >> 32)},
    {(VUINT32) ((0x3C76E0B160000000uLL) >> 0),
    (VUINT32) ((0x3C76E0B160000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA4344523C8E3B5uLL) >> 0),
    (VUINT32) ((0x3FA4344523C8E3B5uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC678B3488739BuLL) >> 0),
    (VUINT32) ((0xBFEC678B3488739BuLL) >> 32)},
    {(VUINT32) ((0xBC6D86CAC0000000uLL) >> 0),
    (VUINT32) ((0xBC6D86CAC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA9CC8B3671DD0FuLL) >> 0),
    (VUINT32) ((0x3FA9CC8B3671DD0FuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC954B213411F5uLL) >> 0),
    (VUINT32) ((0xBFEC954B213411F5uLL) >> 32)},
    {(VUINT32) ((0x3C52FB7600000000uLL) >> 0),
    (VUINT32) ((0x3C52FB7600000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FAF6DB13FF708CBuLL) >> 0),
    (VUINT32) ((0x3FAF6DB13FF708CBuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFECC1F0F3FCFC5CuLL) >> 0),
    (VUINT32) ((0xBFECC1F0F3FCFC5CuLL) >> 32)},
    {(VUINT32) ((0xBC7E576120000000uLL) >> 0),
    (VUINT32) ((0xBC7E576120000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB28BBFD87A8CFFuLL) >> 0),
    (VUINT32) ((0x3FB28BBFD87A8CFFuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFECED7AF43CC773uLL) >> 0),
    (VUINT32) ((0xBFECED7AF43CC773uLL) >> 32)},
    {(VUINT32) ((0x3C5E7B6BA0000000uLL) >> 0),
    (VUINT32) ((0x3C5E7B6BA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB564DF524B00DAuLL) >> 0),
    (VUINT32) ((0x3FB564DF524B00DAuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED17E7743E35DCuLL) >> 0),
    (VUINT32) ((0xBFED17E7743E35DCuLL) >> 32)},
    {(VUINT32) ((0x3C5101DA20000000uLL) >> 0),
    (VUINT32) ((0x3C5101DA20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB8421AF15C49D7uLL) >> 0),
    (VUINT32) ((0x3FB8421AF15C49D7uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED4134D14DC93AuLL) >> 0),
    (VUINT32) ((0xBFED4134D14DC93AuLL) >> 32)},
    {(VUINT32) ((0x3C84EF5280000000uLL) >> 0),
    (VUINT32) ((0x3C84EF5280000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBB2356710DB0A3uLL) >> 0),
    (VUINT32) ((0x3FBB2356710DB0A3uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED696173C9E68BuLL) >> 0),
    (VUINT32) ((0xBFED696173C9E68BuLL) >> 32)},
    {(VUINT32) ((0x3C7E8C61C0000000uLL) >> 0),
    (VUINT32) ((0x3C7E8C61C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBE087565455A75uLL) >> 0),
    (VUINT32) ((0x3FBE087565455A75uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
    (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED906BCF328D46uLL) >> 0),
    (VUINT32) ((0xBFED906BCF328D46uLL) >> 32)},
    {(VUINT32) ((0xBC7457E600000000uLL) >> 0),
    (VUINT32) ((0xBC7457E600000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBF0EA4C477339CuLL) >> 0),
    (VUINT32) ((0xBFBF0EA4C477339CuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEDB6526238A09BuLL) >> 0),
    (VUINT32) ((0xBFEDB6526238A09BuLL) >> 32)},
    {(VUINT32) ((0x3C7ADEE7E0000000uLL) >> 0),
    (VUINT32) ((0x3C7ADEE7E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBC2214C3E9167BuLL) >> 0),
    (VUINT32) ((0xBFBC2214C3E9167BuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEDDB13B6CCC23CuLL) >> 0),
    (VUINT32) ((0xBFEDDB13B6CCC23CuLL) >> 32)},
    {(VUINT32) ((0xBC883C37C0000000uLL) >> 0),
    (VUINT32) ((0xBC883C37C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB931F774FC9F18uLL) >> 0),
    (VUINT32) ((0xBFB931F774FC9F18uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEDFEAE622DBE2BuLL) >> 0),
    (VUINT32) ((0xBFEDFEAE622DBE2BuLL) >> 32)},
    {(VUINT32) ((0x3C8514EA80000000uLL) >> 0),
    (VUINT32) ((0x3C8514EA80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB63E69D6AC7F74uLL) >> 0),
    (VUINT32) ((0xBFB63E69D6AC7F74uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE212104F686E5uLL) >> 0),
    (VUINT32) ((0xBFEE212104F686E5uLL) >> 32)},
    {(VUINT32) ((0x3C8014C760000000uLL) >> 0),
    (VUINT32) ((0x3C8014C760000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB3478909E39DA9uLL) >> 0),
    (VUINT32) ((0xBFB3478909E39DA9uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE426A4B2BC17EuLL) >> 0),
    (VUINT32) ((0xBFEE426A4B2BC17EuLL) >> 32)},
    {(VUINT32) ((0xBC8A873880000000uLL) >> 0),
    (VUINT32) ((0xBC8A873880000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB04D72505D9805uLL) >> 0),
    (VUINT32) ((0xBFB04D72505D9805uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE6288EC48E112uLL) >> 0),
    (VUINT32) ((0xBFEE6288EC48E112uLL) >> 32)},
    {(VUINT32) ((0x3C616B56E0000000uLL) >> 0),
    (VUINT32) ((0x3C616B56E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFAAA086170C0A8EuLL) >> 0),
    (VUINT32) ((0xBFAAA086170C0A8EuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE817BAB4CD10DuLL) >> 0),
    (VUINT32) ((0xBFEE817BAB4CD10DuLL) >> 32)},
    {(VUINT32) ((0x3C7D0AFE60000000uLL) >> 0),
    (VUINT32) ((0x3C7D0AFE60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA4A03176ACF82DuLL) >> 0),
    (VUINT32) ((0xBFA4A03176ACF82DuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE9F4156C62DDAuLL) >> 0),
    (VUINT32) ((0xBFEE9F4156C62DDAuLL) >> 32)},
    {(VUINT32) ((0xBC8760B1E0000000uLL) >> 0),
    (VUINT32) ((0xBC8760B1E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9D3443F4CDB3DDuLL) >> 0),
    (VUINT32) ((0xBF9D3443F4CDB3DDuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEEBBD8C8DF0B74uLL) >> 0),
    (VUINT32) ((0xBFEEBBD8C8DF0B74uLL) >> 32)},
    {(VUINT32) ((0xBC7C6C8C60000000uLL) >> 0),
    (VUINT32) ((0xBC7C6C8C60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF911D262B1F6776uLL) >> 0),
    (VUINT32) ((0xBF911D262B1F6776uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEED740E7684963uLL) >> 0),
    (VUINT32) ((0xBFEED740E7684963uLL) >> 32)},
    {(VUINT32) ((0xBC7E82C780000000uLL) >> 0),
    (VUINT32) ((0xBC7E82C780000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF73EE038DFF6B80uLL) >> 0),
    (VUINT32) ((0xBF73EE038DFF6B80uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEEF178A3E473C2uLL) >> 0),
    (VUINT32) ((0xBFEEF178A3E473C2uLL) >> 32)},
    {(VUINT32) ((0xBC86310A60000000uLL) >> 0),
    (VUINT32) ((0xBC86310A60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F7CC0D09BD41CAAuLL) >> 0),
    (VUINT32) ((0x3F7CC0D09BD41CAAuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF0A7EFB9230D7uLL) >> 0),
    (VUINT32) ((0xBFEF0A7EFB9230D7uLL) >> 32)},
    {(VUINT32) ((0xBC752C7AC0000000uLL) >> 0),
    (VUINT32) ((0xBC752C7AC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F936580D5D5E775uLL) >> 0),
    (VUINT32) ((0x3F936580D5D5E775uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF2252F7763ADAuLL) >> 0),
    (VUINT32) ((0xBFEF2252F7763ADAuLL) >> 32)},
    {(VUINT32) ((0x3C820CB800000000uLL) >> 0),
    (VUINT32) ((0x3C820CB800000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9FA3ECAC0D84E8uLL) >> 0),
    (VUINT32) ((0x3F9FA3ECAC0D84E8uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF38F3AC64E589uLL) >> 0),
    (VUINT32) ((0xBFEF38F3AC64E589uLL) >> 32)},
    {(VUINT32) ((0x3C7D7BAFA0000000uLL) >> 0),
    (VUINT32) ((0x3C7D7BAFA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA5F57F693FEEBEuLL) >> 0),
    (VUINT32) ((0x3FA5F57F693FEEBEuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF4E603B0B2F2DuLL) >> 0),
    (VUINT32) ((0xBFEF4E603B0B2F2DuLL) >> 32)},
    {(VUINT32) ((0x3C78EE01E0000000uLL) >> 0),
    (VUINT32) ((0x3C78EE01E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FAC1D1F0E5967D5uLL) >> 0),
    (VUINT32) ((0x3FAC1D1F0E5967D5uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
    (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF6297CFF75CB0uLL) >> 0),
    (VUINT32) ((0xBFEF6297CFF75CB0uLL) >> 32)},
    {(VUINT32) ((0xBC75621720000000uLL) >> 0),
    (VUINT32) ((0xBC75621720000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFADB7677942FCC5uLL) >> 0),
    (VUINT32) ((0xBFADB7677942FCC5uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
    (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF7599A3A12077uLL) >> 0),
    (VUINT32) ((0xBFEF7599A3A12077uLL) >> 32)},
    {(VUINT32) ((0xBC884F31C0000000uLL) >> 0),
    (VUINT32) ((0xBC884F31C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA78851122CFF19uLL) >> 0),
    (VUINT32) ((0xBFA78851122CFF19uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
    (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF8764FA714BA9uLL) >> 0),
    (VUINT32) ((0xBFEF8764FA714BA9uLL) >> 32)},
    {(VUINT32) ((0xBC7AB25660000000uLL) >> 0),
    (VUINT32) ((0xBC7AB25660000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA155DAC4A4F967uLL) >> 0),
    (VUINT32) ((0xBFA155DAC4A4F967uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
    (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF97F924C9099BuLL) >> 0),
    (VUINT32) ((0xBFEF97F924C9099BuLL) >> 32)},
    {(VUINT32) ((0x3C8E2AE0E0000000uLL) >> 0),
    (VUINT32) ((0x3C8E2AE0E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF964083747309D1uLL) >> 0),
    (VUINT32) ((0xBF964083747309D1uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
    (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFA7557F08A517uLL) >> 0),
    (VUINT32) ((0xBFEFA7557F08A517uLL) >> 32)},
    {(VUINT32) ((0x3C87A0A8C0000000uLL) >> 0),
    (VUINT32) ((0x3C87A0A8C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF839F0CEDAF576BuLL) >> 0),
    (VUINT32) ((0xBF839F0CEDAF576BuLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
    (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFB5797195D741uLL) >> 0),
    (VUINT32) ((0xBFEFB5797195D741uLL) >> 32)},
    {(VUINT32) ((0xBC71BFAC60000000uLL) >> 0),
    (VUINT32) ((0xBC71BFAC60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F6536352AD19E39uLL) >> 0),
    (VUINT32) ((0x3F6536352AD19E39uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
    (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFC26470E19FD3uLL) >> 0),
    (VUINT32) ((0xBFEFC26470E19FD3uLL) >> 32)},
    {(VUINT32) ((0xBC81EC8660000000uLL) >> 0),
    (VUINT32) ((0xBC81EC8660000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8E43D1C309E958uLL) >> 0),
    (VUINT32) ((0x3F8E43D1C309E958uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
    (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFCE15FD6DA67BuLL) >> 0),
    (VUINT32) ((0xBFEFCE15FD6DA67BuLL) >> 32)},
    {(VUINT32) ((0x3C75DD6F80000000uLL) >> 0),
    (VUINT32) ((0x3C75DD6F80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9BA1650F592F50uLL) >> 0),
    (VUINT32) ((0x3F9BA1650F592F50uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
    (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFD88DA3D12526uLL) >> 0),
    (VUINT32) ((0xBFEFD88DA3D12526uLL) >> 32)},
    {(VUINT32) ((0x3C887DF620000000uLL) >> 0),
    (VUINT32) ((0x3C887DF620000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF97DB402A6A9063uLL) >> 0),
    (VUINT32) ((0xBF97DB402A6A9063uLL) >> 32)},
    {(VUINT32) ((0xBFB0000000000000uLL) >> 0),
    (VUINT32) ((0xBFB0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFE1CAFCBD5B09uLL) >> 0),
    (VUINT32) ((0xBFEFE1CAFCBD5B09uLL) >> 32)},
    {(VUINT32) ((0xBC6A23E320000000uLL) >> 0),
    (VUINT32) ((0xBC6A23E320000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF86A9049670CFAEuLL) >> 0),
    (VUINT32) ((0xBF86A9049670CFAEuLL) >> 32)},
    {(VUINT32) ((0xBFB0000000000000uLL) >> 0),
    (VUINT32) ((0xBFB0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFE9CDAD01883AuLL) >> 0),
    (VUINT32) ((0xBFEFE9CDAD01883AuLL) >> 32)},
    {(VUINT32) ((0xBC6521ECC0000000uLL) >> 0),
    (VUINT32) ((0xBC6521ECC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F535230C0FBE402uLL) >> 0),
    (VUINT32) ((0x3F535230C0FBE402uLL) >> 32)},
    {(VUINT32) ((0xBFB0000000000000uLL) >> 0),
    (VUINT32) ((0xBFB0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFF095658E71ADuLL) >> 0),
    (VUINT32) ((0xBFEFF095658E71ADuLL) >> 32)},
    {(VUINT32) ((0xBC801A8CE0000000uLL) >> 0),
    (VUINT32) ((0xBC801A8CE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8B82683BC89FB0uLL) >> 0),
    (VUINT32) ((0x3F8B82683BC89FB0uLL) >> 32)},
    {(VUINT32) ((0xBFB0000000000000uLL) >> 0),
    (VUINT32) ((0xBFB0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFF621E3796D7EuLL) >> 0),
    (VUINT32) ((0xBFEFF621E3796D7EuLL) >> 32)},
    {(VUINT32) ((0x3C6C57BC20000000uLL) >> 0),
    (VUINT32) ((0x3C6C57BC20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF76C32BACA2AE69uLL) >> 0),
    (VUINT32) ((0xBF76C32BACA2AE69uLL) >> 32)},
    {(VUINT32) ((0xBFA0000000000000uLL) >> 0),
    (VUINT32) ((0xBFA0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFFA72EFFEF75DuLL) >> 0),
    (VUINT32) ((0xBFEFFA72EFFEF75DuLL) >> 32)},
    {(VUINT32) ((0x3C88B4CDC0000000uLL) >> 0),
    (VUINT32) ((0x3C88B4CDC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F7B7AA821726608uLL) >> 0),
    (VUINT32) ((0x3F7B7AA821726608uLL) >> 32)},
    {(VUINT32) ((0xBFA0000000000000uLL) >> 0),
    (VUINT32) ((0xBFA0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFFD886084CD0DuLL) >> 0),
    (VUINT32) ((0xBFEFFD886084CD0DuLL) >> 32)},
    {(VUINT32) ((0x3C81354D40000000uLL) >> 0),
    (VUINT32) ((0x3C81354D40000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F6B78B80C84E1EEuLL) >> 0),
    (VUINT32) ((0x3F6B78B80C84E1EEuLL) >> 32)},
    {(VUINT32) ((0xBF90000000000000uLL) >> 0),
    (VUINT32) ((0xBF90000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFFF62169B92DBuLL) >> 0),
    (VUINT32) ((0xBFEFFF62169B92DBuLL) >> 32)},
    {(VUINT32) ((0xBC85DDA3C0000000uLL) >> 0),
    (VUINT32) ((0xBC85DDA3C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
    (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF6B78B80C84E1EEuLL) >> 0),
    (VUINT32) ((0xBF6B78B80C84E1EEuLL) >> 32)},
    {(VUINT32) ((0x3F90000000000000uLL) >> 0),
    (VUINT32) ((0x3F90000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFFF62169B92DBuLL) >> 0),
    (VUINT32) ((0xBFEFFF62169B92DBuLL) >> 32)},
    {(VUINT32) ((0xBC85DDA3C0000000uLL) >> 0),
    (VUINT32) ((0xBC85DDA3C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF7B7AA821726608uLL) >> 0),
    (VUINT32) ((0xBF7B7AA821726608uLL) >> 32)},
    {(VUINT32) ((0x3FA0000000000000uLL) >> 0),
    (VUINT32) ((0x3FA0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFFD886084CD0DuLL) >> 0),
    (VUINT32) ((0xBFEFFD886084CD0DuLL) >> 32)},
    {(VUINT32) ((0x3C81354D40000000uLL) >> 0),
    (VUINT32) ((0x3C81354D40000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F76C32BACA2AE69uLL) >> 0),
    (VUINT32) ((0x3F76C32BACA2AE69uLL) >> 32)},
    {(VUINT32) ((0x3FA0000000000000uLL) >> 0),
    (VUINT32) ((0x3FA0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFFA72EFFEF75DuLL) >> 0),
    (VUINT32) ((0xBFEFFA72EFFEF75DuLL) >> 32)},
    {(VUINT32) ((0x3C88B4CDC0000000uLL) >> 0),
    (VUINT32) ((0x3C88B4CDC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8B82683BC89FB0uLL) >> 0),
    (VUINT32) ((0xBF8B82683BC89FB0uLL) >> 32)},
    {(VUINT32) ((0x3FB0000000000000uLL) >> 0),
    (VUINT32) ((0x3FB0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFF621E3796D7EuLL) >> 0),
    (VUINT32) ((0xBFEFF621E3796D7EuLL) >> 32)},
    {(VUINT32) ((0x3C6C57BC20000000uLL) >> 0),
    (VUINT32) ((0x3C6C57BC20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF535230C0FBE402uLL) >> 0),
    (VUINT32) ((0xBF535230C0FBE402uLL) >> 32)},
    {(VUINT32) ((0x3FB0000000000000uLL) >> 0),
    (VUINT32) ((0x3FB0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFF095658E71ADuLL) >> 0),
    (VUINT32) ((0xBFEFF095658E71ADuLL) >> 32)},
    {(VUINT32) ((0xBC801A8CE0000000uLL) >> 0),
    (VUINT32) ((0xBC801A8CE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F86A9049670CFAEuLL) >> 0),
    (VUINT32) ((0x3F86A9049670CFAEuLL) >> 32)},
    {(VUINT32) ((0x3FB0000000000000uLL) >> 0),
    (VUINT32) ((0x3FB0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFE9CDAD01883AuLL) >> 0),
    (VUINT32) ((0xBFEFE9CDAD01883AuLL) >> 32)},
    {(VUINT32) ((0xBC6521ECC0000000uLL) >> 0),
    (VUINT32) ((0xBC6521ECC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F97DB402A6A9063uLL) >> 0),
    (VUINT32) ((0x3F97DB402A6A9063uLL) >> 32)},
    {(VUINT32) ((0x3FB0000000000000uLL) >> 0),
    (VUINT32) ((0x3FB0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFE1CAFCBD5B09uLL) >> 0),
    (VUINT32) ((0xBFEFE1CAFCBD5B09uLL) >> 32)},
    {(VUINT32) ((0xBC6A23E320000000uLL) >> 0),
    (VUINT32) ((0xBC6A23E320000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9BA1650F592F50uLL) >> 0),
    (VUINT32) ((0xBF9BA1650F592F50uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
    (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFD88DA3D12526uLL) >> 0),
    (VUINT32) ((0xBFEFD88DA3D12526uLL) >> 32)},
    {(VUINT32) ((0x3C887DF620000000uLL) >> 0),
    (VUINT32) ((0x3C887DF620000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8E43D1C309E958uLL) >> 0),
    (VUINT32) ((0xBF8E43D1C309E958uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
    (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFCE15FD6DA67BuLL) >> 0),
    (VUINT32) ((0xBFEFCE15FD6DA67BuLL) >> 32)},
    {(VUINT32) ((0x3C75DD6F80000000uLL) >> 0),
    (VUINT32) ((0x3C75DD6F80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF6536352AD19E39uLL) >> 0),
    (VUINT32) ((0xBF6536352AD19E39uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
    (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFC26470E19FD3uLL) >> 0),
    (VUINT32) ((0xBFEFC26470E19FD3uLL) >> 32)},
    {(VUINT32) ((0xBC81EC8660000000uLL) >> 0),
    (VUINT32) ((0xBC81EC8660000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F839F0CEDAF576BuLL) >> 0),
    (VUINT32) ((0x3F839F0CEDAF576BuLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
    (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFB5797195D741uLL) >> 0),
    (VUINT32) ((0xBFEFB5797195D741uLL) >> 32)},
    {(VUINT32) ((0xBC71BFAC60000000uLL) >> 0),
    (VUINT32) ((0xBC71BFAC60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F964083747309D1uLL) >> 0),
    (VUINT32) ((0x3F964083747309D1uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
    (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFA7557F08A517uLL) >> 0),
    (VUINT32) ((0xBFEFA7557F08A517uLL) >> 32)},
    {(VUINT32) ((0x3C87A0A8C0000000uLL) >> 0),
    (VUINT32) ((0x3C87A0A8C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA155DAC4A4F967uLL) >> 0),
    (VUINT32) ((0x3FA155DAC4A4F967uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
    (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF97F924C9099BuLL) >> 0),
    (VUINT32) ((0xBFEF97F924C9099BuLL) >> 32)},
    {(VUINT32) ((0x3C8E2AE0E0000000uLL) >> 0),
    (VUINT32) ((0x3C8E2AE0E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA78851122CFF19uLL) >> 0),
    (VUINT32) ((0x3FA78851122CFF19uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
    (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF8764FA714BA9uLL) >> 0),
    (VUINT32) ((0xBFEF8764FA714BA9uLL) >> 32)},
    {(VUINT32) ((0xBC7AB25660000000uLL) >> 0),
    (VUINT32) ((0xBC7AB25660000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FADB7677942FCC5uLL) >> 0),
    (VUINT32) ((0x3FADB7677942FCC5uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
    (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF7599A3A12077uLL) >> 0),
    (VUINT32) ((0xBFEF7599A3A12077uLL) >> 32)},
    {(VUINT32) ((0xBC884F31C0000000uLL) >> 0),
    (VUINT32) ((0xBC884F31C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFAC1D1F0E5967D5uLL) >> 0),
    (VUINT32) ((0xBFAC1D1F0E5967D5uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF6297CFF75CB0uLL) >> 0),
    (VUINT32) ((0xBFEF6297CFF75CB0uLL) >> 32)},
    {(VUINT32) ((0xBC75621720000000uLL) >> 0),
    (VUINT32) ((0xBC75621720000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA5F57F693FEEBEuLL) >> 0),
    (VUINT32) ((0xBFA5F57F693FEEBEuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF4E603B0B2F2DuLL) >> 0),
    (VUINT32) ((0xBFEF4E603B0B2F2DuLL) >> 32)},
    {(VUINT32) ((0x3C78EE01E0000000uLL) >> 0),
    (VUINT32) ((0x3C78EE01E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9FA3ECAC0D84E8uLL) >> 0),
    (VUINT32) ((0xBF9FA3ECAC0D84E8uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF38F3AC64E589uLL) >> 0),
    (VUINT32) ((0xBFEF38F3AC64E589uLL) >> 32)},
    {(VUINT32) ((0x3C7D7BAFA0000000uLL) >> 0),
    (VUINT32) ((0x3C7D7BAFA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF936580D5D5E775uLL) >> 0),
    (VUINT32) ((0xBF936580D5D5E775uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF2252F7763ADAuLL) >> 0),
    (VUINT32) ((0xBFEF2252F7763ADAuLL) >> 32)},
    {(VUINT32) ((0x3C820CB800000000uLL) >> 0),
    (VUINT32) ((0x3C820CB800000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF7CC0D09BD41CAAuLL) >> 0),
    (VUINT32) ((0xBF7CC0D09BD41CAAuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF0A7EFB9230D7uLL) >> 0),
    (VUINT32) ((0xBFEF0A7EFB9230D7uLL) >> 32)},
    {(VUINT32) ((0xBC752C7AC0000000uLL) >> 0),
    (VUINT32) ((0xBC752C7AC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F73EE038DFF6B80uLL) >> 0),
    (VUINT32) ((0x3F73EE038DFF6B80uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEEF178A3E473C2uLL) >> 0),
    (VUINT32) ((0xBFEEF178A3E473C2uLL) >> 32)},
    {(VUINT32) ((0xBC86310A60000000uLL) >> 0),
    (VUINT32) ((0xBC86310A60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F911D262B1F6776uLL) >> 0),
    (VUINT32) ((0x3F911D262B1F6776uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEED740E7684963uLL) >> 0),
    (VUINT32) ((0xBFEED740E7684963uLL) >> 32)},
    {(VUINT32) ((0xBC7E82C780000000uLL) >> 0),
    (VUINT32) ((0xBC7E82C780000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9D3443F4CDB3DDuLL) >> 0),
    (VUINT32) ((0x3F9D3443F4CDB3DDuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEEBBD8C8DF0B74uLL) >> 0),
    (VUINT32) ((0xBFEEBBD8C8DF0B74uLL) >> 32)},
    {(VUINT32) ((0xBC7C6C8C60000000uLL) >> 0),
    (VUINT32) ((0xBC7C6C8C60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA4A03176ACF82DuLL) >> 0),
    (VUINT32) ((0x3FA4A03176ACF82DuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE9F4156C62DDAuLL) >> 0),
    (VUINT32) ((0xBFEE9F4156C62DDAuLL) >> 32)},
    {(VUINT32) ((0xBC8760B1E0000000uLL) >> 0),
    (VUINT32) ((0xBC8760B1E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FAAA086170C0A8EuLL) >> 0),
    (VUINT32) ((0x3FAAA086170C0A8EuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE817BAB4CD10DuLL) >> 0),
    (VUINT32) ((0xBFEE817BAB4CD10DuLL) >> 32)},
    {(VUINT32) ((0x3C7D0AFE60000000uLL) >> 0),
    (VUINT32) ((0x3C7D0AFE60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB04D72505D9805uLL) >> 0),
    (VUINT32) ((0x3FB04D72505D9805uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE6288EC48E112uLL) >> 0),
    (VUINT32) ((0xBFEE6288EC48E112uLL) >> 32)},
    {(VUINT32) ((0x3C616B56E0000000uLL) >> 0),
    (VUINT32) ((0x3C616B56E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB3478909E39DA9uLL) >> 0),
    (VUINT32) ((0x3FB3478909E39DA9uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE426A4B2BC17EuLL) >> 0),
    (VUINT32) ((0xBFEE426A4B2BC17EuLL) >> 32)},
    {(VUINT32) ((0xBC8A873880000000uLL) >> 0),
    (VUINT32) ((0xBC8A873880000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB63E69D6AC7F74uLL) >> 0),
    (VUINT32) ((0x3FB63E69D6AC7F74uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE212104F686E5uLL) >> 0),
    (VUINT32) ((0xBFEE212104F686E5uLL) >> 32)},
    {(VUINT32) ((0x3C8014C760000000uLL) >> 0),
    (VUINT32) ((0x3C8014C760000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB931F774FC9F18uLL) >> 0),
    (VUINT32) ((0x3FB931F774FC9F18uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEDFEAE622DBE2BuLL) >> 0),
    (VUINT32) ((0xBFEDFEAE622DBE2BuLL) >> 32)},
    {(VUINT32) ((0x3C8514EA80000000uLL) >> 0),
    (VUINT32) ((0x3C8514EA80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBC2214C3E9167BuLL) >> 0),
    (VUINT32) ((0x3FBC2214C3E9167BuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEDDB13B6CCC23CuLL) >> 0),
    (VUINT32) ((0xBFEDDB13B6CCC23CuLL) >> 32)},
    {(VUINT32) ((0xBC883C37C0000000uLL) >> 0),
    (VUINT32) ((0xBC883C37C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBF0EA4C477339CuLL) >> 0),
    (VUINT32) ((0x3FBF0EA4C477339CuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
    (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEDB6526238A09BuLL) >> 0),
    (VUINT32) ((0xBFEDB6526238A09BuLL) >> 32)},
    {(VUINT32) ((0x3C7ADEE7E0000000uLL) >> 0),
    (VUINT32) ((0x3C7ADEE7E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBE087565455A75uLL) >> 0),
    (VUINT32) ((0xBFBE087565455A75uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED906BCF328D46uLL) >> 0),
    (VUINT32) ((0xBFED906BCF328D46uLL) >> 32)},
    {(VUINT32) ((0xBC7457E600000000uLL) >> 0),
    (VUINT32) ((0xBC7457E600000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBB2356710DB0A3uLL) >> 0),
    (VUINT32) ((0xBFBB2356710DB0A3uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED696173C9E68BuLL) >> 0),
    (VUINT32) ((0xBFED696173C9E68BuLL) >> 32)},
    {(VUINT32) ((0x3C7E8C61C0000000uLL) >> 0),
    (VUINT32) ((0x3C7E8C61C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB8421AF15C49D7uLL) >> 0),
    (VUINT32) ((0xBFB8421AF15C49D7uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED4134D14DC93AuLL) >> 0),
    (VUINT32) ((0xBFED4134D14DC93AuLL) >> 32)},
    {(VUINT32) ((0x3C84EF5280000000uLL) >> 0),
    (VUINT32) ((0x3C84EF5280000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB564DF524B00DAuLL) >> 0),
    (VUINT32) ((0xBFB564DF524B00DAuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED17E7743E35DCuLL) >> 0),
    (VUINT32) ((0xBFED17E7743E35DCuLL) >> 32)},
    {(VUINT32) ((0x3C5101DA20000000uLL) >> 0),
    (VUINT32) ((0x3C5101DA20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB28BBFD87A8CFFuLL) >> 0),
    (VUINT32) ((0xBFB28BBFD87A8CFFuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFECED7AF43CC773uLL) >> 0),
    (VUINT32) ((0xBFECED7AF43CC773uLL) >> 32)},
    {(VUINT32) ((0x3C5E7B6BA0000000uLL) >> 0),
    (VUINT32) ((0x3C5E7B6BA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFAF6DB13FF708CBuLL) >> 0),
    (VUINT32) ((0xBFAF6DB13FF708CBuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFECC1F0F3FCFC5CuLL) >> 0),
    (VUINT32) ((0xBFECC1F0F3FCFC5CuLL) >> 32)},
    {(VUINT32) ((0xBC7E576120000000uLL) >> 0),
    (VUINT32) ((0xBC7E576120000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA9CC8B3671DD0FuLL) >> 0),
    (VUINT32) ((0xBFA9CC8B3671DD0FuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC954B213411F5uLL) >> 0),
    (VUINT32) ((0xBFEC954B213411F5uLL) >> 32)},
    {(VUINT32) ((0x3C52FB7600000000uLL) >> 0),
    (VUINT32) ((0x3C52FB7600000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA4344523C8E3B5uLL) >> 0),
    (VUINT32) ((0xBFA4344523C8E3B5uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC678B3488739BuLL) >> 0),
    (VUINT32) ((0xBFEC678B3488739BuLL) >> 32)},
    {(VUINT32) ((0xBC6D86CAC0000000uLL) >> 0),
    (VUINT32) ((0xBC6D86CAC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9D4A2C7F909C4EuLL) >> 0),
    (VUINT32) ((0xBF9D4A2C7F909C4EuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC38B2F180BDB1uLL) >> 0),
    (VUINT32) ((0xBFEC38B2F180BDB1uLL) >> 32)},
    {(VUINT32) ((0x3C76E0B160000000uLL) >> 0),
    (VUINT32) ((0x3C76E0B160000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF923E6AD10872A7uLL) >> 0),
    (VUINT32) ((0xBF923E6AD10872A7uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC08C426725549uLL) >> 0),
    (VUINT32) ((0xBFEC08C426725549uLL) >> 32)},
    {(VUINT32) ((0xBC5B157FC0000000uLL) >> 0),
    (VUINT32) ((0xBC5B157FC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF7D16C901D95181uLL) >> 0),
    (VUINT32) ((0xBF7D16C901D95181uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEBD7C0AC6F952AuLL) >> 0),
    (VUINT32) ((0xBFEBD7C0AC6F952AuLL) >> 32)},
    {(VUINT32) ((0x3C8825A720000000uLL) >> 0),
    (VUINT32) ((0x3C8825A720000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F6CFC874C3EB6D9uLL) >> 0),
    (VUINT32) ((0x3F6CFC874C3EB6D9uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEBA5AA673590D2uLL) >> 0),
    (VUINT32) ((0xBFEBA5AA673590D2uLL) >> 32)},
    {(VUINT32) ((0xBC87EA4E20000000uLL) >> 0),
    (VUINT32) ((0xBC87EA4E20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8CE1E648BFFB66uLL) >> 0),
    (VUINT32) ((0x3F8CE1E648BFFB66uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEB728345196E3EuLL) >> 0),
    (VUINT32) ((0xBFEB728345196E3EuLL) >> 32)},
    {(VUINT32) ((0x3C8BC69F20000000uLL) >> 0),
    (VUINT32) ((0x3C8BC69F20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F992E09ABB131D4uLL) >> 0),
    (VUINT32) ((0x3F992E09ABB131D4uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEB3E4D3EF55712uLL) >> 0),
    (VUINT32) ((0xBFEB3E4D3EF55712uLL) >> 32)},
    {(VUINT32) ((0x3C8EB6B8A0000000uLL) >> 0),
    (VUINT32) ((0x3C8EB6B8A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA1EB3541B4B228uLL) >> 0),
    (VUINT32) ((0x3FA1EB3541B4B228uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEB090A58150200uLL) >> 0),
    (VUINT32) ((0xBFEB090A58150200uLL) >> 32)},
    {(VUINT32) ((0x3C8926DA20000000uLL) >> 0),
    (VUINT32) ((0x3C8926DA20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA734D63DEDB48AuLL) >> 0),
    (VUINT32) ((0x3FA734D63DEDB48AuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEAD2BC9E21D511uLL) >> 0),
    (VUINT32) ((0xBFEAD2BC9E21D511uLL) >> 32)},
    {(VUINT32) ((0x3C847FBE00000000uLL) >> 0),
    (VUINT32) ((0x3C847FBE00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FAC73B39AE68C87uLL) >> 0),
    (VUINT32) ((0x3FAC73B39AE68C87uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEA9B66290EA1A3uLL) >> 0),
    (VUINT32) ((0xBFEA9B66290EA1A3uLL) >> 32)},
    {(VUINT32) ((0xBC39F630E0000000uLL) >> 0),
    (VUINT32) ((0xBC39F630E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB0D3CCC99F5AC6uLL) >> 0),
    (VUINT32) ((0x3FB0D3CCC99F5AC6uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEA63091B02FAE2uLL) >> 0),
    (VUINT32) ((0xBFEA63091B02FAE2uLL) >> 32)},
    {(VUINT32) ((0x3C7E911140000000uLL) >> 0),
    (VUINT32) ((0x3C7E911140000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB3682A66E896F5uLL) >> 0),
    (VUINT32) ((0x3FB3682A66E896F5uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEA29A7A0462782uLL) >> 0),
    (VUINT32) ((0xBFEA29A7A0462782uLL) >> 32)},
    {(VUINT32) ((0x3C7128BB00000000uLL) >> 0),
    (VUINT32) ((0x3C7128BB00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB5F6D92FD79F50uLL) >> 0),
    (VUINT32) ((0x3FB5F6D92FD79F50uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE9EF43EF29AF94uLL) >> 0),
    (VUINT32) ((0xBFE9EF43EF29AF94uLL) >> 32)},
    {(VUINT32) ((0xBC7B1DFCA0000000uLL) >> 0),
    (VUINT32) ((0xBC7B1DFCA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB87FBFE70B81A7uLL) >> 0),
    (VUINT32) ((0x3FB87FBFE70B81A7uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE9B3E047F38741uLL) >> 0),
    (VUINT32) ((0xBFE9B3E047F38741uLL) >> 32)},
    {(VUINT32) ((0x3C830EE280000000uLL) >> 0),
    (VUINT32) ((0x3C830EE280000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBB02C58832CF96uLL) >> 0),
    (VUINT32) ((0x3FBB02C58832CF96uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE9777EF4C7D742uLL) >> 0),
    (VUINT32) ((0xBFE9777EF4C7D742uLL) >> 32)},
    {(VUINT32) ((0x3C815479A0000000uLL) >> 0),
    (VUINT32) ((0x3C815479A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBD7FD1490285CAuLL) >> 0),
    (VUINT32) ((0x3FBD7FD1490285CAuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE93A22499263FBuLL) >> 0),
    (VUINT32) ((0xBFE93A22499263FBuLL) >> 32)},
    {(VUINT32) ((0xBC83D419A0000000uLL) >> 0),
    (VUINT32) ((0xBC83D419A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBFF6CA9A2AB6A2uLL) >> 0),
    (VUINT32) ((0x3FBFF6CA9A2AB6A2uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE8FBCCA3EF940DuLL) >> 0),
    (VUINT32) ((0xBFE8FBCCA3EF940DuLL) >> 32)},
    {(VUINT32) ((0x3C66DFA980000000uLL) >> 0),
    (VUINT32) ((0x3C66DFA980000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC133CC94247758uLL) >> 0),
    (VUINT32) ((0x3FC133CC94247758uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE8BC806B151741uLL) >> 0),
    (VUINT32) ((0xBFE8BC806B151741uLL) >> 32)},
    {(VUINT32) ((0x3C82C5E120000000uLL) >> 0),
    (VUINT32) ((0x3C82C5E120000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC269126E6C24E3uLL) >> 0),
    (VUINT32) ((0x3FC269126E6C24E3uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE87C400FBA2EBFuLL) >> 0),
    (VUINT32) ((0xBFE87C400FBA2EBFuLL) >> 32)},
    {(VUINT32) ((0x3C82DABC00000000uLL) >> 0),
    (VUINT32) ((0x3C82DABC00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC39B2AEF8F97A4uLL) >> 0),
    (VUINT32) ((0x3FC39B2AEF8F97A4uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE83B0E0BFF976EuLL) >> 0),
    (VUINT32) ((0xBFE83B0E0BFF976EuLL) >> 32)},
    {(VUINT32) ((0x3C76F420E0000000uLL) >> 0),
    (VUINT32) ((0x3C76F420E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC4CA0A4A8D5657uLL) >> 0),
    (VUINT32) ((0x3FC4CA0A4A8D5657uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE7F8ECE3571771uLL) >> 0),
    (VUINT32) ((0xBFE7F8ECE3571771uLL) >> 32)},
    {(VUINT32) ((0x3C89C8D8C0000000uLL) >> 0),
    (VUINT32) ((0x3C89C8D8C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC5F5A4D233B27FuLL) >> 0),
    (VUINT32) ((0x3FC5F5A4D233B27FuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE7B5DF226AAFAFuLL) >> 0),
    (VUINT32) ((0xBFE7B5DF226AAFAFuLL) >> 32)},
    {(VUINT32) ((0x3C70F537A0000000uLL) >> 0),
    (VUINT32) ((0x3C70F537A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC71DEEF9940631uLL) >> 0),
    (VUINT32) ((0x3FC71DEEF9940631uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE771E75F037261uLL) >> 0),
    (VUINT32) ((0xBFE771E75F037261uLL) >> 32)},
    {(VUINT32) ((0xBC75CFCE80000000uLL) >> 0),
    (VUINT32) ((0xBC75CFCE80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC842DD5474B37BuLL) >> 0),
    (VUINT32) ((0x3FC842DD5474B37BuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE72D0837EFFF96uLL) >> 0),
    (VUINT32) ((0xBFE72D0837EFFF96uLL) >> 32)},
    {(VUINT32) ((0xBC80D4EF00000000uLL) >> 0),
    (VUINT32) ((0xBC80D4EF00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC9646497C1E0F6uLL) >> 0),
    (VUINT32) ((0x3FC9646497C1E0F6uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE6E74454EAA8AFuLL) >> 0),
    (VUINT32) ((0xBFE6E74454EAA8AFuLL) >> 32)},
    {(VUINT32) ((0x3C8DBC03C0000000uLL) >> 0),
    (VUINT32) ((0x3C8DBC03C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCA827999FCEF32uLL) >> 0),
    (VUINT32) ((0x3FCA827999FCEF32uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE6A09E667F3BCDuLL) >> 0),
    (VUINT32) ((0xBFE6A09E667F3BCDuLL) >> 32)},
    {(VUINT32) ((0x3C8BDD3400000000uLL) >> 0),
    (VUINT32) ((0x3C8BDD3400000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCB9D1153AAA2BAuLL) >> 0),
    (VUINT32) ((0x3FCB9D1153AAA2BAuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE6591925F0783DuLL) >> 0),
    (VUINT32) ((0xBFE6591925F0783DuLL) >> 32)},
    {(VUINT32) ((0xBC8C3D64E0000000uLL) >> 0),
    (VUINT32) ((0xBC8C3D64E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCCB420DFBFFE59uLL) >> 0),
    (VUINT32) ((0x3FCCB420DFBFFE59uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE610B7551D2CDFuLL) >> 0),
    (VUINT32) ((0xBFE610B7551D2CDFuLL) >> 32)},
    {(VUINT32) ((0x3C7251B340000000uLL) >> 0),
    (VUINT32) ((0x3C7251B340000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCDC79D7C0DC985uLL) >> 0),
    (VUINT32) ((0x3FCDC79D7C0DC985uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE5C77BBE65018CuLL) >> 0),
    (VUINT32) ((0xBFE5C77BBE65018CuLL) >> 32)},
    {(VUINT32) ((0xBC8069EA80000000uLL) >> 0),
    (VUINT32) ((0xBC8069EA80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCED77C89AABEBBuLL) >> 0),
    (VUINT32) ((0x3FCED77C89AABEBBuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE57D69348CECA0uLL) >> 0),
    (VUINT32) ((0xBFE57D69348CECA0uLL) >> 32)},
    {(VUINT32) ((0x3C87572080000000uLL) >> 0),
    (VUINT32) ((0x3C87572080000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCFE3B38D5C5DC2uLL) >> 0),
    (VUINT32) ((0x3FCFE3B38D5C5DC2uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
    (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE5328292A35596uLL) >> 0),
    (VUINT32) ((0xBFE5328292A35596uLL) >> 32)},
    {(VUINT32) ((0x3C7A12EB80000000uLL) >> 0),
    (VUINT32) ((0x3C7A12EB80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCF13C7D001A249uLL) >> 0),
    (VUINT32) ((0xBFCF13C7D001A249uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE4E6CABBE3E5E9uLL) >> 0),
    (VUINT32) ((0xBFE4E6CABBE3E5E9uLL) >> 32)},
    {(VUINT32) ((0xBC63C293E0000000uLL) >> 0),
    (VUINT32) ((0xBC63C293E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCE0EFFC1174505uLL) >> 0),
    (VUINT32) ((0xBFCE0EFFC1174505uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE49A449B9B0939uLL) >> 0),
    (VUINT32) ((0xBFE49A449B9B0939uLL) >> 32)},
    {(VUINT32) ((0x3C827EE160000000uLL) >> 0),
    (VUINT32) ((0x3C827EE160000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCD0DFE53ABA2FDuLL) >> 0),
    (VUINT32) ((0xBFCD0DFE53ABA2FDuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE44CF325091DD6uLL) >> 0),
    (VUINT32) ((0xBFE44CF325091DD6uLL) >> 32)},
    {(VUINT32) ((0xBC68076A20000000uLL) >> 0),
    (VUINT32) ((0xBC68076A20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCC10CD7041AFCCuLL) >> 0),
    (VUINT32) ((0xBFCC10CD7041AFCCuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE3FED9534556D4uLL) >> 0),
    (VUINT32) ((0xBFE3FED9534556D4uLL) >> 32)},
    {(VUINT32) ((0xBC83691660000000uLL) >> 0),
    (VUINT32) ((0xBC83691660000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCB1776D9B67013uLL) >> 0),
    (VUINT32) ((0xBFCB1776D9B67013uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE3AFFA292050B9uLL) >> 0),
    (VUINT32) ((0xBFE3AFFA292050B9uLL) >> 32)},
    {(VUINT32) ((0xBC7E3E25E0000000uLL) >> 0),
    (VUINT32) ((0xBC7E3E25E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCA22042CE0A2F9uLL) >> 0),
    (VUINT32) ((0xBFCA22042CE0A2F9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE36058B10659F3uLL) >> 0),
    (VUINT32) ((0xBFE36058B10659F3uLL) >> 32)},
    {(VUINT32) ((0x3C81FCB3A0000000uLL) >> 0),
    (VUINT32) ((0x3C81FCB3A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC9307EE031E2FDuLL) >> 0),
    (VUINT32) ((0xBFC9307EE031E2FDuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE30FF7FCE17035uLL) >> 0),
    (VUINT32) ((0xBFE30FF7FCE17035uLL) >> 32)},
    {(VUINT32) ((0x3C6EFCC620000000uLL) >> 0),
    (VUINT32) ((0x3C6EFCC620000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC842F0435941AFuLL) >> 0),
    (VUINT32) ((0xBFC842F0435941AFuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE2BEDB25FAF3EAuLL) >> 0),
    (VUINT32) ((0xBFE2BEDB25FAF3EAuLL) >> 32)},
    {(VUINT32) ((0x3C514981C0000000uLL) >> 0),
    (VUINT32) ((0x3C514981C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC759617EE761F9uLL) >> 0),
    (VUINT32) ((0xBFC759617EE761F9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE26D054CDD12DFuLL) >> 0),
    (VUINT32) ((0xBFE26D054CDD12DFuLL) >> 32)},
    {(VUINT32) ((0x3C85DA7420000000uLL) >> 0),
    (VUINT32) ((0x3C85DA7420000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC673DB93F41479uLL) >> 0),
    (VUINT32) ((0xBFC673DB93F41479uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE21A799933EB59uLL) >> 0),
    (VUINT32) ((0xBFE21A799933EB59uLL) >> 32)},
    {(VUINT32) ((0x3C83A7B160000000uLL) >> 0),
    (VUINT32) ((0x3C83A7B160000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC592675BC57974uLL) >> 0),
    (VUINT32) ((0xBFC592675BC57974uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE1C73B39AE68C8uLL) >> 0),
    (VUINT32) ((0xBFE1C73B39AE68C8uLL) >> 32)},
    {(VUINT32) ((0xBC8B25DD20000000uLL) >> 0),
    (VUINT32) ((0xBC8B25DD20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC4B50D8778ABBDuLL) >> 0),
    (VUINT32) ((0xBFC4B50D8778ABBDuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE1734D63DEDB49uLL) >> 0),
    (VUINT32) ((0xBFE1734D63DEDB49uLL) >> 32)},
    {(VUINT32) ((0x3C87EEF2C0000000uLL) >> 0),
    (VUINT32) ((0x3C87EEF2C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC3DBD69FABF802uLL) >> 0),
    (VUINT32) ((0xBFC3DBD69FABF802uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE11EB3541B4B23uLL) >> 0),
    (VUINT32) ((0xBFE11EB3541B4B23uLL) >> 32)},
    {(VUINT32) ((0x3C8EF23B60000000uLL) >> 0),
    (VUINT32) ((0x3C8EF23B60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC306CB042AA3BAuLL) >> 0),
    (VUINT32) ((0xBFC306CB042AA3BAuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE0C9704D5D898FuLL) >> 0),
    (VUINT32) ((0xBFE0C9704D5D898FuLL) >> 32)},
    {(VUINT32) ((0x3C88D3D7C0000000uLL) >> 0),
    (VUINT32) ((0x3C88D3D7C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC235F2EB9A470AuLL) >> 0),
    (VUINT32) ((0xBFC235F2EB9A470AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE073879922FFEEuLL) >> 0),
    (VUINT32) ((0xBFE073879922FFEEuLL) >> 32)},
    {(VUINT32) ((0x3C8A5A0140000000uLL) >> 0),
    (VUINT32) ((0x3C8A5A0140000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC169566329BCB7uLL) >> 0),
    (VUINT32) ((0xBFC169566329BCB7uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE01CFC874C3EB7uLL) >> 0),
    (VUINT32) ((0xBFE01CFC874C3EB7uLL) >> 32)},
    {(VUINT32) ((0x3C734A35E0000000uLL) >> 0),
    (VUINT32) ((0x3C734A35E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC0A0FD4E41AB5AuLL) >> 0),
    (VUINT32) ((0xBFC0A0FD4E41AB5AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDF8BA4DBF89ABAuLL) >> 0),
    (VUINT32) ((0xBFDF8BA4DBF89ABAuLL) >> 32)},
    {(VUINT32) ((0x3C32EC1FC0000000uLL) >> 0),
    (VUINT32) ((0x3C32EC1FC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBFB9DECC6D55B8uLL) >> 0),
    (VUINT32) ((0xBFBFB9DECC6D55B8uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDEDC1952EF78D6uLL) >> 0),
    (VUINT32) ((0xBFDEDC1952EF78D6uLL) >> 32)},
    {(VUINT32) ((0x3C7DD0F7C0000000uLL) >> 0),
    (VUINT32) ((0x3C7DD0F7C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBE3A6873FA1279uLL) >> 0),
    (VUINT32) ((0xBFBE3A6873FA1279uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDE2B5D3806F63BuLL) >> 0),
    (VUINT32) ((0xBFDE2B5D3806F63BuLL) >> 32)},
    {(VUINT32) ((0xBC5E0D8900000000uLL) >> 0),
    (VUINT32) ((0xBC5E0D8900000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBCC3A65BBC6327uLL) >> 0),
    (VUINT32) ((0xBFBCC3A65BBC6327uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDD79775B86E389uLL) >> 0),
    (VUINT32) ((0xBFDD79775B86E389uLL) >> 32)},
    {(VUINT32) ((0xBC7550EC80000000uLL) >> 0),
    (VUINT32) ((0xBC7550EC80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBB55A6F65F7058uLL) >> 0),
    (VUINT32) ((0xBFBB55A6F65F7058uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDCC66E9931C45EuLL) >> 0),
    (VUINT32) ((0xBFDCC66E9931C45EuLL) >> 32)},
    {(VUINT32) ((0xBC56850E40000000uLL) >> 0),
    (VUINT32) ((0xBC56850E40000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB9F07860181D1EuLL) >> 0),
    (VUINT32) ((0xBFB9F07860181D1EuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDC1249D8011EE7uLL) >> 0),
    (VUINT32) ((0xBFDC1249D8011EE7uLL) >> 32)},
    {(VUINT32) ((0x3C7813AAA0000000uLL) >> 0),
    (VUINT32) ((0x3C7813AAA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB894285E19C468uLL) >> 0),
    (VUINT32) ((0xBFB894285E19C468uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDB5D1009E15CC0uLL) >> 0),
    (VUINT32) ((0xBFDB5D1009E15CC0uLL) >> 32)},
    {(VUINT32) ((0xBC65B362C0000000uLL) >> 0),
    (VUINT32) ((0xBC65B362C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB740C45E0E5120uLL) >> 0),
    (VUINT32) ((0xBFB740C45E0E5120uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDAA6C82B6D3FCAuLL) >> 0),
    (VUINT32) ((0xBFDAA6C82B6D3FCAuLL) >> 32)},
    {(VUINT32) ((0x3C7D5F1060000000uLL) >> 0),
    (VUINT32) ((0x3C7D5F1060000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB5F6597591B633uLL) >> 0),
    (VUINT32) ((0xBFB5F6597591B633uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD9EF7943A8ED8AuLL) >> 0),
    (VUINT32) ((0xBFD9EF7943A8ED8AuLL) >> 32)},
    {(VUINT32) ((0xBC66DA8120000000uLL) >> 0),
    (VUINT32) ((0xBC66DA8120000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB4B4F461B0CBAAuLL) >> 0),
    (VUINT32) ((0xBFB4B4F461B0CBAAuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD9372A63BC93D7uLL) >> 0),
    (VUINT32) ((0xBFD9372A63BC93D7uLL) >> 32)},
    {(VUINT32) ((0xBC66843180000000uLL) >> 0),
    (VUINT32) ((0xBC66843180000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB37CA1866B95CFuLL) >> 0),
    (VUINT32) ((0xBFB37CA1866B95CFuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD87DE2A6AEA963uLL) >> 0),
    (VUINT32) ((0xBFD87DE2A6AEA963uLL) >> 32)},
    {(VUINT32) ((0x3C672CEDC0000000uLL) >> 0),
    (VUINT32) ((0x3C672CEDC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB24D6CEE3AFB2AuLL) >> 0),
    (VUINT32) ((0xBFB24D6CEE3AFB2AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD7C3A9311DCCE7uLL) >> 0),
    (VUINT32) ((0xBFD7C3A9311DCCE7uLL) >> 32)},
    {(VUINT32) ((0xBC19A3F200000000uLL) >> 0),
    (VUINT32) ((0xBC19A3F200000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB127624999EE1DuLL) >> 0),
    (VUINT32) ((0xBFB127624999EE1DuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD7088530FA459FuLL) >> 0),
    (VUINT32) ((0xBFD7088530FA459FuLL) >> 32)},
    {(VUINT32) ((0x3C744B19E0000000uLL) >> 0),
    (VUINT32) ((0x3C744B19E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB00A8CEE920EABuLL) >> 0),
    (VUINT32) ((0xBFB00A8CEE920EABuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD64C7DDD3F27C6uLL) >> 0),
    (VUINT32) ((0xBFD64C7DDD3F27C6uLL) >> 32)},
    {(VUINT32) ((0xBC510D2B40000000uLL) >> 0),
    (VUINT32) ((0xBC510D2B40000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFADEDEFB09791B4uLL) >> 0),
    (VUINT32) ((0xBFADEDEFB09791B4uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD58F9A75AB1FDDuLL) >> 0),
    (VUINT32) ((0xBFD58F9A75AB1FDDuLL) >> 32)},
    {(VUINT32) ((0x3C1EFDC0C0000000uLL) >> 0),
    (VUINT32) ((0x3C1EFDC0C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFABD95B4D43E819uLL) >> 0),
    (VUINT32) ((0xBFABD95B4D43E819uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD4D1E24278E76AuLL) >> 0),
    (VUINT32) ((0xBFD4D1E24278E76AuLL) >> 32)},
    {(VUINT32) ((0xBC62417200000000uLL) >> 0),
    (VUINT32) ((0xBC62417200000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA9D7713B71EEE1uLL) >> 0),
    (VUINT32) ((0xBFA9D7713B71EEE1uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD4135C94176601uLL) >> 0),
    (VUINT32) ((0xBFD4135C94176601uLL) >> 32)},
    {(VUINT32) ((0xBC70C97C40000000uLL) >> 0),
    (VUINT32) ((0xBC70C97C40000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA7E8454B32EF34uLL) >> 0),
    (VUINT32) ((0xBFA7E8454B32EF34uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD35410C2E18152uLL) >> 0),
    (VUINT32) ((0xBFD35410C2E18152uLL) >> 32)},
    {(VUINT32) ((0x3C73CB0020000000uLL) >> 0),
    (VUINT32) ((0x3C73CB0020000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA60BEA939D225AuLL) >> 0),
    (VUINT32) ((0xBFA60BEA939D225AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD294062ED59F06uLL) >> 0),
    (VUINT32) ((0xBFD294062ED59F06uLL) >> 32)},
    {(VUINT32) ((0x3C75D28DA0000000uLL) >> 0),
    (VUINT32) ((0x3C75D28DA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA44273720F48BCuLL) >> 0),
    (VUINT32) ((0xBFA44273720F48BCuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD1D3443F4CDB3EuLL) >> 0),
    (VUINT32) ((0xBFD1D3443F4CDB3EuLL) >> 32)},
    {(VUINT32) ((0x3C6720D400000000uLL) >> 0),
    (VUINT32) ((0x3C6720D400000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA28BF1897B69CCuLL) >> 0),
    (VUINT32) ((0xBFA28BF1897B69CCuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD111D262B1F677uLL) >> 0),
    (VUINT32) ((0xBFD111D262B1F677uLL) >> 32)},
    {(VUINT32) ((0xBC7824C200000000uLL) >> 0),
    (VUINT32) ((0xBC7824C200000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA0E875C1B8C3DAuLL) >> 0),
    (VUINT32) ((0xBFA0E875C1B8C3DAuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD04FB80E37FDAEuLL) >> 0),
    (VUINT32) ((0xBFD04FB80E37FDAEuLL) >> 32)},
    {(VUINT32) ((0x3C0412CDA0000000uLL) >> 0),
    (VUINT32) ((0x3C0412CDA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9EB0208DB9E51BuLL) >> 0),
    (VUINT32) ((0xBF9EB0208DB9E51BuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCF19F97B215F1BuLL) >> 0),
    (VUINT32) ((0xBFCF19F97B215F1BuLL) >> 32)},
    {(VUINT32) ((0x3C642DEEE0000000uLL) >> 0),
    (VUINT32) ((0x3C642DEEE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9BB5A11138A4C9uLL) >> 0),
    (VUINT32) ((0xBF9BB5A11138A4C9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCD934FE5454311uLL) >> 0),
    (VUINT32) ((0xBFCD934FE5454311uLL) >> 32)},
    {(VUINT32) ((0xBC675B9220000000uLL) >> 0),
    (VUINT32) ((0xBC675B9220000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF98E18A73634EE7uLL) >> 0),
    (VUINT32) ((0xBF98E18A73634EE7uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCC0B826A7E4F63uLL) >> 0),
    (VUINT32) ((0xBFCC0B826A7E4F63uLL) >> 32)},
    {(VUINT32) ((0x3C1AF14380000000uLL) >> 0),
    (VUINT32) ((0x3C1AF14380000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9633F89E9A1A66uLL) >> 0),
    (VUINT32) ((0xBF9633F89E9A1A66uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCA82A025B00451uLL) >> 0),
    (VUINT32) ((0xBFCA82A025B00451uLL) >> 32)},
    {(VUINT32) ((0x3C687905E0000000uLL) >> 0),
    (VUINT32) ((0x3C687905E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF93AD06011469FBuLL) >> 0),
    (VUINT32) ((0xBF93AD06011469FBuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC8F8B83C69A60BuLL) >> 0),
    (VUINT32) ((0xBFC8F8B83C69A60BuLL) >> 32)},
    {(VUINT32) ((0x3C626D19A0000000uLL) >> 0),
    (VUINT32) ((0x3C626D19A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF914CCB8BDBF114uLL) >> 0),
    (VUINT32) ((0xBF914CCB8BDBF114uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC76DD9DE50BF31uLL) >> 0),
    (VUINT32) ((0xBFC76DD9DE50BF31uLL) >> 32)},
    {(VUINT32) ((0xBC61D5EEE0000000uLL) >> 0),
    (VUINT32) ((0xBC61D5EEE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8E26C163AD15B3uLL) >> 0),
    (VUINT32) ((0xBF8E26C163AD15B3uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC5E214448B3FC6uLL) >> 0),
    (VUINT32) ((0xBFC5E214448B3FC6uLL) >> 32)},
    {(VUINT32) ((0xBC6531FF60000000uLL) >> 0),
    (VUINT32) ((0xBC6531FF60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8A01B6CDBD995EuLL) >> 0),
    (VUINT32) ((0xBF8A01B6CDBD995EuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC45576B1293E5AuLL) >> 0),
    (VUINT32) ((0xBFC45576B1293E5AuLL) >> 32)},
    {(VUINT32) ((0x3C5285A240000000uLL) >> 0),
    (VUINT32) ((0x3C5285A240000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF862AA03DD6BA58uLL) >> 0),
    (VUINT32) ((0xBF862AA03DD6BA58uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC2C8106E8E613AuLL) >> 0),
    (VUINT32) ((0xBFC2C8106E8E613AuLL) >> 32)},
    {(VUINT32) ((0xBC513000A0000000uLL) >> 0),
    (VUINT32) ((0xBC513000A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF82A1A39A8A2FB7uLL) >> 0),
    (VUINT32) ((0xBF82A1A39A8A2FB7uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC139F0CEDAF577uLL) >> 0),
    (VUINT32) ((0xBFC139F0CEDAF577uLL) >> 32)},
    {(VUINT32) ((0x3C65234340000000uLL) >> 0),
    (VUINT32) ((0x3C65234340000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF7ECDC78F30165CuLL) >> 0),
    (VUINT32) ((0xBF7ECDC78F30165CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBF564E56A9730EuLL) >> 0),
    (VUINT32) ((0xBFBF564E56A9730EuLL) >> 32)},
    {(VUINT32) ((0xBC4A270460000000uLL) >> 0),
    (VUINT32) ((0xBC4A270460000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF78F501492CC296uLL) >> 0),
    (VUINT32) ((0xBF78F501492CC296uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBC3785C79EC2D5uLL) >> 0),
    (VUINT32) ((0xBFBC3785C79EC2D5uLL) >> 32)},
    {(VUINT32) ((0x3C24F39DE0000000uLL) >> 0),
    (VUINT32) ((0x3C24F39DE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF73B92E176D6D31uLL) >> 0),
    (VUINT32) ((0xBF73B92E176D6D31uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB917A6BC29B42CuLL) >> 0),
    (VUINT32) ((0xBFB917A6BC29B42CuLL) >> 32)},
    {(VUINT32) ((0x3C3E2718C0000000uLL) >> 0),
    (VUINT32) ((0x3C3E2718C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF6E350342A4F6E6uLL) >> 0),
    (VUINT32) ((0xBF6E350342A4F6E6uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB5F6D00A9AA419uLL) >> 0),
    (VUINT32) ((0xBFB5F6D00A9AA419uLL) >> 32)},
    {(VUINT32) ((0x3C4F4022C0000000uLL) >> 0),
    (VUINT32) ((0x3C4F4022C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF663252FE77C5EBuLL) >> 0),
    (VUINT32) ((0xBF663252FE77C5EBuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB2D52092CE19F6uLL) >> 0),
    (VUINT32) ((0xBFB2D52092CE19F6uLL) >> 32)},
    {(VUINT32) ((0x3C49A088A0000000uLL) >> 0),
    (VUINT32) ((0x3C49A088A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF5ED534E31CA57FuLL) >> 0),
    (VUINT32) ((0xBF5ED534E31CA57FuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFAF656E79F820E0uLL) >> 0),
    (VUINT32) ((0xBFAF656E79F820E0uLL) >> 32)},
    {(VUINT32) ((0x3C22E1EBE0000000uLL) >> 0),
    (VUINT32) ((0x3C22E1EBE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF53BC390D250439uLL) >> 0),
    (VUINT32) ((0xBF53BC390D250439uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA91F65F10DD814uLL) >> 0),
    (VUINT32) ((0xBFA91F65F10DD814uLL) >> 32)},
    {(VUINT32) ((0x3C2912BD00000000uLL) >> 0),
    (VUINT32) ((0x3C2912BD00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF46344004228D8BuLL) >> 0),
    (VUINT32) ((0xBF46344004228D8BuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA2D865759455CDuLL) >> 0),
    (VUINT32) ((0xBFA2D865759455CDuLL) >> 32)},
    {(VUINT32) ((0xBC2686F640000000uLL) >> 0),
    (VUINT32) ((0xBC2686F640000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF33BCFBD9979A27uLL) >> 0),
    (VUINT32) ((0xBF33BCFBD9979A27uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF992155F7A3667EuLL) >> 0),
    (VUINT32) ((0xBF992155F7A3667EuLL) >> 32)},
    {(VUINT32) ((0x3BFB1D6300000000uLL) >> 0),
    (VUINT32) ((0x3BFB1D6300000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF13BD2C8DA49511uLL) >> 0),
    (VUINT32) ((0xBF13BD2C8DA49511uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
    (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF8921D1FCDEC784uLL) >> 0),
    (VUINT32) ((0xBF8921D1FCDEC784uLL) >> 32)},
    {(VUINT32) ((0xBC29878EA0000000uLL) >> 0),
    (VUINT32) ((0xBC29878EA0000000uLL) >> 32)}},
   },
  {(VUINT32) ((0x7FFFFFFFFFFFFFFFuLL) >> 0),
   (VUINT32) ((0x7FFFFFFFFFFFFFFFuLL) >> 32)},
  {(VUINT32) ((0x40F000000E4DB24CuLL) >> 0),
   (VUINT32) ((0x40F000000E4DB24CuLL) >> 32)},

  {(VUINT32) ((0x7FF0000000000000uLL) >> 0),
   (VUINT32) ((0x7FF0000000000000uLL) >> 32)},
  {(VUINT32) ((0x40545F306DC9C883uLL) >> 0),
   (VUINT32) ((0x40545F306DC9C883uLL) >> 32)},
  {(VUINT32) ((0x4338000000000000uLL) >> 0),
   (VUINT32) ((0x4338000000000000uLL) >> 32)},
  {(VUINT32) ((0x00000000000001FFuLL) >> 0),
   (VUINT32) ((0x00000000000001FFuLL) >> 32)},
  {(VUINT32) ((0x0000000000000080uLL) >> 0),          // VUINT32 _l2pK_1[2];  (sincos only)
   (VUINT32) ((0x0000000000000080uLL) >> 32)},
  {(VUINT32) ((0x3F8921FB54400000uLL) >> 0),
   (VUINT32) ((0x3F8921FB54400000uLL) >> 32)},
  {(VUINT32) ((0x3D60B4611A600000uLL) >> 0),
   (VUINT32) ((0x3D60B4611A600000uLL) >> 32)},
  {(VUINT32) ((0x3B33198A2E037073uLL) >> 0),
   (VUINT32) ((0x3B33198A2E037073uLL) >> 32)},
  {(VUINT32) ((0xBFC5555555554448uLL) >> 0),
   (VUINT32) ((0xBFC5555555554448uLL) >> 32)},
  {(VUINT32) ((0x3F81110FABB3551CuLL) >> 0),
   (VUINT32) ((0x3F81110FABB3551CuLL) >> 32)},
  {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
   (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
  {(VUINT32) ((0x3FA5555555554CCFuLL) >> 0),
   (VUINT32) ((0x3FA5555555554CCFuLL) >> 32)},
  {(VUINT32) ((0xBF56C16AB163B2D7uLL) >> 0),
   (VUINT32) ((0xBF56C16AB163B2D7uLL) >> 32)},
};

// Table common to asinpi and acospi
typedef struct
{
  VUINT32 SgnBit[2];                                    // only acospi
  VUINT32 AbsMask[2];                                   // only asinpi
  VUINT32 One[2];
  VUINT32 OneHalf[2];
  VUINT32 MOne[2];                                      // only acospi
  VUINT32 HalfMask[2];
  VUINT32 Two[2];
  VUINT32 sqrt_coeff[4][2];
  VUINT32 poly_coeff[12][2];
  VUINT32 InvPiH[2];
  VUINT32 InvPiL[2];
  VUINT32 InvPi[2];
  VUINT32 SgnMask[2];
  VUINT32 ep_coeff[6][2];

  VUINT32 dInfs[2][2];
  VUINT32 dOnes[2][2];
  VUINT32 dZeros[2][2];
} dasincospi_Table_Type;

__constant dasincospi_Table_Type __ocl_svml_dasincospi_data = {
  // SgnBit
  {(VUINT32) ((0x8000000000000000uLL) >> 0),
   (VUINT32) ((0x8000000000000000uLL) >> 32)}
  ,

  // AbsMask
  {(VUINT32) ((0x7fffffffffffffffuLL) >> 0),
   (VUINT32) ((0x7fffffffffffffffuLL) >> 32)}

  // One
  , {(VUINT32) ((0x3ff0000000000000uLL) >> 0),
     (VUINT32) ((0x3ff0000000000000uLL) >> 32)}

  // OneHalf
  , {(VUINT32) ((0x3fe0000000000000uLL) >> 0),
     (VUINT32) ((0x3fe0000000000000uLL) >> 32)}

  // MOne
  , {(VUINT32) ((0xbff0000000000000uLL) >> 0),
     (VUINT32) ((0xbff0000000000000uLL) >> 32)}

  // HalfMask
  , {(VUINT32) ((0xfffffffffc000000uLL) >> 0),
     (VUINT32) ((0xfffffffffc000000uLL) >> 32)}

  , {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)}

  , {
     {(VUINT32) ((0xbf918000993B24C3uLL) >> 0),
      (VUINT32) ((0xbf918000993B24C3uLL) >> 32)}
     , {(VUINT32) ((0x3fa400006F70D42DuLL) >> 0),
        (VUINT32) ((0x3fa400006F70D42DuLL) >> 32)}
     , {(VUINT32) ((0xbfb7FFFFFFFFFE97uLL) >> 0),
        (VUINT32) ((0xbfb7FFFFFFFFFE97uLL) >> 32)}
     , {(VUINT32) ((0x3fcFFFFFFFFFFF9DuLL) >> 0),
        (VUINT32) ((0x3fcFFFFFFFFFFF9DuLL) >> 32)}
     }

  , {
     {(VUINT32) ((0x3f84F4523BC020D8uLL) >> 0),
      (VUINT32) ((0x3f84F4523BC020D8uLL) >> 32)}
     , {(VUINT32) ((0xbf759EE439EEE799uLL) >> 0),
        (VUINT32) ((0xbf759EE439EEE799uLL) >> 32)}
     , {(VUINT32) ((0x3f79C78AE09A5457uLL) >> 0),
        (VUINT32) ((0x3f79C78AE09A5457uLL) >> 32)}
     , {(VUINT32) ((0x3f60C57DF579794AuLL) >> 0),
        (VUINT32) ((0x3f60C57DF579794AuLL) >> 32)}
     , {(VUINT32) ((0x3f6FCBA466EA069BuLL) >> 0),
        (VUINT32) ((0x3f6FCBA466EA069BuLL) >> 32)}
     , {(VUINT32) ((0x3f7219262ADC70A8uLL) >> 0),
        (VUINT32) ((0x3f7219262ADC70A8uLL) >> 32)}
     , {(VUINT32) ((0x3f76A256C108AAEduLL) >> 0),
        (VUINT32) ((0x3f76A256C108AAEduLL) >> 32)}
     , {(VUINT32) ((0x3f7D2B0EA1978F74uLL) >> 0),
        (VUINT32) ((0x3f7D2B0EA1978F74uLL) >> 32)}
     , {(VUINT32) ((0x3f83CE53573AD4F4uLL) >> 0),
        (VUINT32) ((0x3f83CE53573AD4F4uLL) >> 32)}
     , {(VUINT32) ((0x3f8D1A452B1C8F4EuLL) >> 0),
        (VUINT32) ((0x3f8D1A452B1C8F4EuLL) >> 32)}
     , {(VUINT32) ((0x3f98723A1D5E7F21uLL) >> 0),
        (VUINT32) ((0x3f98723A1D5E7F21uLL) >> 32)}
     , {(VUINT32) ((0x3faB2995E7B7B28BuLL) >> 0),
        (VUINT32) ((0x3faB2995E7B7B28BuLL) >> 32)}
     }

  , {(VUINT32) ((0x3fd45F3070000000uLL) >> 0),
     (VUINT32) ((0x3fd45F3070000000uLL) >> 32)}

  , {(VUINT32) ((0xbe21B1BBEA2AAEE4uLL) >> 0),
     (VUINT32) ((0xbe21B1BBEA2AAEE4uLL) >> 32)}

  , {(VUINT32) ((0x3fd45F306DC9C883uLL) >> 0),
     (VUINT32) ((0x3fd45F306DC9C883uLL) >> 32)}

  , {(VUINT32) ((0x8000000000000000uLL) >> 0),
     (VUINT32) ((0x8000000000000000uLL) >> 32)}

  , {
     {(VUINT32) ((0x3f88BAFFDA4549F0uLL) >> 0),
      (VUINT32) ((0x3f88BAFFDA4549F0uLL) >> 32)}
     , {(VUINT32) ((0x3f7262B57524FB3BuLL) >> 0),
        (VUINT32) ((0x3f7262B57524FB3BuLL) >> 32)}
     , {(VUINT32) ((0x3f84CD955BDDED9fuLL) >> 0),
        (VUINT32) ((0x3f84CD955BDDED9fuLL) >> 32)}
     , {(VUINT32) ((0x3f8D02B66C2AD236uLL) >> 0),
        (VUINT32) ((0x3f8D02B66C2AD236uLL) >> 32)}
     , {(VUINT32) ((0x3f9872BCE76EFA44uLL) >> 0),
        (VUINT32) ((0x3f9872BCE76EFA44uLL) >> 32)}
     , {(VUINT32) ((0x3faB2994D916CB05uLL) >> 0),
        (VUINT32) ((0x3faB2994D916CB05uLL) >> 32)}
     }

  , {{(VUINT32) ((0x7ff0000000000000uLL) >> 0),
      (VUINT32) ((0x7ff0000000000000uLL) >> 32)},
     {(VUINT32) ((0xfff0000000000000uLL) >> 0),
      (VUINT32) ((0xfff0000000000000uLL) >> 32)}}

  , {{(VUINT32) ((0x3ff0000000000000uLL) >> 0),
      (VUINT32) ((0x3ff0000000000000uLL) >> 32)},
     {(VUINT32) ((0xbff0000000000000uLL) >> 0),
      (VUINT32) ((0xbff0000000000000uLL) >> 32)}}

  , {{(VUINT32) ((0x0000000000000000uLL) >> 0),
      (VUINT32) ((0x0000000000000000uLL) >> 32)},
     {(VUINT32) ((0x8000000000000000uLL) >> 0),
      (VUINT32) ((0x8000000000000000uLL) >> 32)}}

};

// Table common to sinh and cosh

__constant _iml_dp_union_t _vmldSinhCoshHATab[153] = {
  {{0x00000000u, 0x3FF00000u}},
  {{0x00000000u, 0x00000000u}},
  {{0x3E778061u, 0x3FF02C9Au}},
  {{0x535B085Du, 0xBC719083u}},
  {{0xD3158574u, 0x3FF059B0u}},
  {{0xA475B465u, 0x3C8D73E2u}},
  {{0x18759BC8u, 0x3FF08745u}},
  {{0x4BB284FFu, 0x3C6186BEu}},
  {{0x6CF9890Fu, 0x3FF0B558u}},
  {{0x4ADC610Bu, 0x3C98A62Eu}},
  {{0x32D3D1A2u, 0x3FF0E3ECu}},
  {{0x27C57B53u, 0x3C403A17u}},
  {{0xD0125B51u, 0x3FF11301u}},
  {{0x39449B3Au, 0xBC96C510u}},
  {{0xAEA92DE0u, 0x3FF1429Au}},
  {{0x9AF1369Eu, 0xBC932FBFu}},
  {{0x3C7D517Bu, 0x3FF172B8u}},
  {{0xB9D78A76u, 0xBC819041u}},
  {{0xEB6FCB75u, 0x3FF1A35Bu}},
  {{0x7B4968E4u, 0x3C8E5B4Cu}},
  {{0x3168B9AAu, 0x3FF1D487u}},
  {{0x00A2643Cu, 0x3C9E016Eu}},
  {{0x88628CD6u, 0x3FF2063Bu}},
  {{0x814A8495u, 0x3C8DC775u}},
  {{0x6E756238u, 0x3FF2387Au}},
  {{0xB6C70573u, 0x3C99B07Eu}},
  {{0x65E27CDDu, 0x3FF26B45u}},
  {{0x9940E9D9u, 0x3C82BD33u}},
  {{0xF51FDEE1u, 0x3FF29E9Du}},
  {{0xAFAD1255u, 0x3C8612E8u}},
  {{0xA6E4030Bu, 0x3FF2D285u}},
  {{0x54DB41D5u, 0x3C900247u}},
  {{0x0A31B715u, 0x3FF306FEu}},
  {{0xD23182E4u, 0x3C86F46Au}},
  {{0xB26416FFu, 0x3FF33C08u}},
  {{0x843659A6u, 0x3C932721u}},
  {{0x373AA9CBu, 0x3FF371A7u}},
  {{0xBF42EAE2u, 0xBC963AEAu}},
  {{0x34E59FF7u, 0x3FF3A7DBu}},
  {{0xD661F5E3u, 0xBC75E436u}},
  {{0x4C123422u, 0x3FF3DEA6u}},
  {{0x11F09EBCu, 0x3C8ADA09u}},
  {{0x21F72E2Au, 0x3FF4160Au}},
  {{0x1C309278u, 0xBC5EF369u}},
  {{0x6061892Du, 0x3FF44E08u}},
  {{0x04EF80D0u, 0x3C489B7Au}},
  {{0xB5C13CD0u, 0x3FF486A2u}},
  {{0xB69062F0u, 0x3C73C1A3u}},
  {{0xD5362A27u, 0x3FF4BFDAu}},
  {{0xAFEC42E2u, 0x3C7D4397u}},
  {{0x769D2CA7u, 0x3FF4F9B2u}},
  {{0xD25957E3u, 0xBC94B309u}},
  {{0x569D4F82u, 0x3FF5342Bu}},
  {{0x1DB13CADu, 0xBC807ABEu}},
  {{0x36B527DAu, 0x3FF56F47u}},
  {{0x011D93ADu, 0x3C99BB2Cu}},
  {{0xDD485429u, 0x3FF5AB07u}},
  {{0x054647ADu, 0x3C96324Cu}},
  {{0x15AD2148u, 0x3FF5E76Fu}},
  {{0x3080E65Eu, 0x3C9BA6F9u}},
  {{0xB03A5585u, 0x3FF6247Eu}},
  {{0x7E40B497u, 0xBC9383C1u}},
  {{0x82552225u, 0x3FF66238u}},
  {{0x87591C34u, 0xBC9BB609u}},
  {{0x667F3BCDu, 0x3FF6A09Eu}},
  {{0x13B26456u, 0xBC9BDD34u}},
  {{0x3C651A2Fu, 0x3FF6DFB2u}},
  {{0x683C88ABu, 0xBC6BBE3Au}},
  {{0xE8EC5F74u, 0x3FF71F75u}},
  {{0x86887A99u, 0xBC816E47u}},
  {{0x564267C9u, 0x3FF75FEBu}},
  {{0x57316DD3u, 0xBC902459u}},
  {{0x73EB0187u, 0x3FF7A114u}},
  {{0xEE04992Fu, 0xBC841577u}},
  {{0x36CF4E62u, 0x3FF7E2F3u}},
  {{0xBA15797Eu, 0x3C705D02u}},
  {{0x994CCE13u, 0x3FF82589u}},
  {{0xD41532D8u, 0xBC9D4C1Du}},
  {{0x9B4492EDu, 0x3FF868D9u}},
  {{0x9BD4F6BAu, 0xBC9FC6F8u}},
  {{0x422AA0DBu, 0x3FF8ACE5u}},
  {{0x56864B27u, 0x3C96E9F1u}},
  {{0x99157736u, 0x3FF8F1AEu}},
  {{0xA2E3976Cu, 0x3C85CC13u}},
  {{0xB0CDC5E5u, 0x3FF93737u}},
  {{0x81B57EBCu, 0xBC675FC7u}},
  {{0x9FDE4E50u, 0x3FF97D82u}},
  {{0x7C1B85D1u, 0xBC9D185Bu}},
  {{0x82A3F090u, 0x3FF9C491u}},
  {{0xB071F2BEu, 0x3C7C7C46u}},
  {{0x7B5DE565u, 0x3FFA0C66u}},
  {{0x5D1CD533u, 0xBC935949u}},
  {{0xB23E255Du, 0x3FFA5503u}},
  {{0xDB8D41E1u, 0xBC9D2F6Eu}},
  {{0x5579FDBFu, 0x3FFA9E6Bu}},
  {{0x0EF7FD31u, 0x3C90FAC9u}},
  {{0x995AD3ADu, 0x3FFAE89Fu}},
  {{0x345DCC81u, 0x3C97A1CDu}},
  {{0xB84F15FBu, 0x3FFB33A2u}},
  {{0x3084D708u, 0xBC62805Eu}},
  {{0xF2FB5E47u, 0x3FFB7F76u}},
  {{0x7E54AC3Bu, 0xBC75584Fu}},
  {{0x904BC1D2u, 0x3FFBCC1Eu}},
  {{0x7A2D9E84u, 0x3C823DD0u}},
  {{0xDD85529Cu, 0x3FFC199Bu}},
  {{0x895048DDu, 0x3C811065u}},
  {{0x2E57D14Bu, 0x3FFC67F1u}},
  {{0xFF483CADu, 0x3C92884Du}},
  {{0xDCEF9069u, 0x3FFCB720u}},
  {{0xD1E949DBu, 0x3C7503CBu}},
  {{0x4A07897Cu, 0x3FFD072Du}},
  {{0x43797A9Cu, 0xBC9CBC37u}},
  {{0xDCFBA487u, 0x3FFD5818u}},
  {{0xD75B3707u, 0x3C82ED02u}},
  {{0x03DB3285u, 0x3FFDA9E6u}},
  {{0x696DB532u, 0x3C9C2300u}},
  {{0x337B9B5Fu, 0x3FFDFC97u}},
  {{0x4F184B5Cu, 0xBC91A5CDu}},
  {{0xE78B3FF6u, 0x3FFE502Eu}},
  {{0x80A9CC8Fu, 0x3C839E89u}},
  {{0xA2A490DAu, 0x3FFEA4AFu}},
  {{0x179C2893u, 0xBC9E9C23u}},
  {{0xEE615A27u, 0x3FFEFA1Bu}},
  {{0x86A4B6B0u, 0x3C9DC7F4u}},
  {{0x5B6E4540u, 0x3FFF5076u}},
  {{0x2DD8A18Bu, 0x3C99D3E1u}},
  {{0x819E90D8u, 0x3FFFA7C1u}},
  {{0xF3A5931Eu, 0x3C874853u}},
  {{0x00000000u, 0x40000000u}},
  {{0x00000000u, 0x00000000u}},                 // 129=129+0/

  {{0x652B82FEu, 0x40571547u}},                 // 130=      /130+0 - only in cosh
  {{0x00000000u, 0x43380000u}},                 // 131=      /131+0 - only in cosh

  {{0x00000000u, 0x3FE00000u}},                 // 132=130+2/132+0
  {{0x555548F8u, 0x3FC55555u}},                 // 133=131+2/133+0
  {{0x55558FCCu, 0x3FA55555u}},                 // 134=132+2/134+0
  {{0x3AAF20D3u, 0x3F811112u}},                 // 135=133+2/135+0
  {{0x1C2A3FFDu, 0x3F56C16Au}},                 // 136=134+2/136+0

  {{0x55555555u, 0x3FC55555u}},                 // 137=135+2/ - only in sinh
  {{0x11111111u, 0x3F811111u}},                 // 138=136+2/ - only in sinh
  {{0x1A01A01Au, 0x3F2A01A0u}},                 // 139=137+2/ - only in sinh
  {{0xA556C734u, 0x3EC71DE3u}},                 // 140=138+2/ - only in sinh
  {{0x652B82FEu, 0x40571547u}},                 // 141=139+2/ - only in sinh
  {{0x00000000u, 0x43380000u}},                 // 142=140+2/ - only in sinh
  {{0x02000000u, 0x41A00000u}},                 // 143=141+2/ - only in sinh

  {{0x8FB9F87Eu, 0x408633CEu}},                 // 144=142+2/137+7
  {{0xFEFA0000u, 0x3F862E42u}},                 // 145=143+2/138+7
  {{0xBC9E3B3Au, 0x3D1CF79Au}},                 // 146=144+2/139+7

  {{0x00000001u, 0x00100000u}},                 // 147=145+2/ - only in sinh

  {{0xFFFFFFFFu, 0x7FEFFFFFu}},                 // 148=146+2/140+8

  {{0x00000000u, 0x00000000u}},                 // 149=     /141+8 - only in cosh
  {{0x00000000u, 0x3FF00000u}},                 // 150=     /142+8 - only in cosh

  {{0xDADBE120u, 0x3F9BDB8Cu}},                 // 151=147+4/ - only in sinh

  {{0xE7026820u, 0x40357CD0u}}                  // 152=148+4/143+9
};

// Structure and table common to asinh and acosh

typedef struct
{
  VUINT32 Log_HA_table[(1 << 10) + 2][2];
  VUINT32 Log_LA_table[(1 << 9) + 1][2];
  VUINT32 poly_coeff[4][2];
  VUINT32 ExpMask[2];
  VUINT32 Two10[2];
  VUINT32 MinLog1p[2];
  VUINT32 MaxLog1p[2];
  VUINT32 HalfMask[2];
  VUINT32 One[2];
  VUINT32 SgnMask[2];
  VUINT32 XThreshold[2];
  VUINT32 XhMask[2];
  VUINT32 L2H[2];
  VUINT32 L2L[2];
  VUINT32 Threshold[2];
  VUINT32 Bias[2];
  VUINT32 Bias1[2];
  VUINT32 ExpMask0[2];
  VUINT32 ExpMask2[2];
  VUINT32 L2[2];
  VUINT32 dBigThreshold[2];
  VUINT32 dC2[2];
  VUINT32 dC3[2];
  VUINT32 dC4[2];
  VUINT32 dC5[2];
  VUINT32 dHalf[2];
  VUINT32 dLargestFinite[2];
  VUINT32 dLittleThreshold[2];
  VUINT32 dSign[2];
  VUINT32 dThirtyOne[2];
  VUINT32 dTopMask12[2];
  VUINT32 dTopMask26[2];
  VUINT32 dTopMask29[2];
  VUINT32 dTopMask41[2];
  VUINT32 XScale[2];
  VUINT32 TinyRange[2];                         // only for atanh

  VUINT32 dInfs[2][2];
  VUINT32 dOnes[2][2];
  VUINT32 dZeros[2][2];
} dLn_asinhacoshatanh_Table_Type;

__constant dLn_asinhacoshatanh_Table_Type __ocl_svml_dasinh_dacosh_datanh_data = {

  {
   {(VUINT32) ((0xc086232bdd7a8300uLL) >> 0),
    (VUINT32) ((0xc086232bdd7a8300uLL) >> 32)},
   {(VUINT32) ((0xbe1ce91eef3fb100uLL) >> 0),
    (VUINT32) ((0xbe1ce91eef3fb100uLL) >> 32)},
   {(VUINT32) ((0xc086232fdc7ad828uLL) >> 0),
    (VUINT32) ((0xc086232fdc7ad828uLL) >> 32)},
   {(VUINT32) ((0xbe1cefcffda73b6auLL) >> 0),
    (VUINT32) ((0xbe1cefcffda73b6auLL) >> 32)},
   {(VUINT32) ((0xc0862333d97d2ba0uLL) >> 0),
    (VUINT32) ((0xc0862333d97d2ba0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef406748f1ffuLL) >> 0),
    (VUINT32) ((0xbe1cef406748f1ffuLL) >> 32)},
   {(VUINT32) ((0xc0862337d48378e0uLL) >> 0),
    (VUINT32) ((0xc0862337d48378e0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef2a9429925auLL) >> 0),
    (VUINT32) ((0xbe1cef2a9429925auLL) >> 32)},
   {(VUINT32) ((0xc086233bcd8fb878uLL) >> 0),
    (VUINT32) ((0xc086233bcd8fb878uLL) >> 32)},
   {(VUINT32) ((0xbe1cf138d17ebecbuLL) >> 0),
    (VUINT32) ((0xbe1cf138d17ebecbuLL) >> 32)},
   {(VUINT32) ((0xc086233fc4a3e018uLL) >> 0),
    (VUINT32) ((0xc086233fc4a3e018uLL) >> 32)},
   {(VUINT32) ((0xbe1ceff2dbbbb29euLL) >> 0),
    (VUINT32) ((0xbe1ceff2dbbbb29euLL) >> 32)},
   {(VUINT32) ((0xc0862343b9c1e270uLL) >> 0),
    (VUINT32) ((0xc0862343b9c1e270uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1a42aae437buLL) >> 0),
    (VUINT32) ((0xbe1cf1a42aae437buLL) >> 32)},
   {(VUINT32) ((0xc0862347acebaf68uLL) >> 0),
    (VUINT32) ((0xc0862347acebaf68uLL) >> 32)},
   {(VUINT32) ((0xbe1cef3b152048afuLL) >> 0),
    (VUINT32) ((0xbe1cef3b152048afuLL) >> 32)},
   {(VUINT32) ((0xc086234b9e2333f0uLL) >> 0),
    (VUINT32) ((0xc086234b9e2333f0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef20e127805euLL) >> 0),
    (VUINT32) ((0xbe1cef20e127805euLL) >> 32)},
   {(VUINT32) ((0xc086234f8d6a5a30uLL) >> 0),
    (VUINT32) ((0xc086234f8d6a5a30uLL) >> 32)},
   {(VUINT32) ((0xbe1cf00ad6052cf4uLL) >> 0),
    (VUINT32) ((0xbe1cf00ad6052cf4uLL) >> 32)},
   {(VUINT32) ((0xc08623537ac30980uLL) >> 0),
    (VUINT32) ((0xc08623537ac30980uLL) >> 32)},
   {(VUINT32) ((0xbe1cefc4642ee597uLL) >> 0),
    (VUINT32) ((0xbe1cefc4642ee597uLL) >> 32)},
   {(VUINT32) ((0xc0862357662f2660uLL) >> 0),
    (VUINT32) ((0xc0862357662f2660uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1f277d36e16uLL) >> 0),
    (VUINT32) ((0xbe1cf1f277d36e16uLL) >> 32)},
   {(VUINT32) ((0xc086235b4fb092a0uLL) >> 0),
    (VUINT32) ((0xc086235b4fb092a0uLL) >> 32)},
   {(VUINT32) ((0xbe1ceed009e8d8e6uLL) >> 0),
    (VUINT32) ((0xbe1ceed009e8d8e6uLL) >> 32)},
   {(VUINT32) ((0xc086235f37492d28uLL) >> 0),
    (VUINT32) ((0xc086235f37492d28uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1e4038cb362uLL) >> 0),
    (VUINT32) ((0xbe1cf1e4038cb362uLL) >> 32)},
   {(VUINT32) ((0xc08623631cfad250uLL) >> 0),
    (VUINT32) ((0xc08623631cfad250uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0b0873b8557uLL) >> 0),
    (VUINT32) ((0xbe1cf0b0873b8557uLL) >> 32)},
   {(VUINT32) ((0xc086236700c75b98uLL) >> 0),
    (VUINT32) ((0xc086236700c75b98uLL) >> 32)},
   {(VUINT32) ((0xbe1cf15bb3227c0buLL) >> 0),
    (VUINT32) ((0xbe1cf15bb3227c0buLL) >> 32)},
   {(VUINT32) ((0xc086236ae2b09fe0uLL) >> 0),
    (VUINT32) ((0xc086236ae2b09fe0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf151ef8ca9eduLL) >> 0),
    (VUINT32) ((0xbe1cf151ef8ca9eduLL) >> 32)},
   {(VUINT32) ((0xc086236ec2b87358uLL) >> 0),
    (VUINT32) ((0xc086236ec2b87358uLL) >> 32)},
   {(VUINT32) ((0xbe1cefe1dc2cd2eduLL) >> 0),
    (VUINT32) ((0xbe1cefe1dc2cd2eduLL) >> 32)},
   {(VUINT32) ((0xc0862372a0e0a780uLL) >> 0),
    (VUINT32) ((0xc0862372a0e0a780uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0d1eec5454fuLL) >> 0),
    (VUINT32) ((0xbe1cf0d1eec5454fuLL) >> 32)},
   {(VUINT32) ((0xc08623767d2b0b48uLL) >> 0),
    (VUINT32) ((0xc08623767d2b0b48uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeefd570bbceuLL) >> 0),
    (VUINT32) ((0xbe1ceeefd570bbceuLL) >> 32)},
   {(VUINT32) ((0xc086237a57996af0uLL) >> 0),
    (VUINT32) ((0xc086237a57996af0uLL) >> 32)},
   {(VUINT32) ((0xbe1cee99ae91b3a7uLL) >> 0),
    (VUINT32) ((0xbe1cee99ae91b3a7uLL) >> 32)},
   {(VUINT32) ((0xc086237e302d9028uLL) >> 0),
    (VUINT32) ((0xc086237e302d9028uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0412830fbd1uLL) >> 0),
    (VUINT32) ((0xbe1cf0412830fbd1uLL) >> 32)},
   {(VUINT32) ((0xc086238206e94218uLL) >> 0),
    (VUINT32) ((0xc086238206e94218uLL) >> 32)},
   {(VUINT32) ((0xbe1ceee898588610uLL) >> 0),
    (VUINT32) ((0xbe1ceee898588610uLL) >> 32)},
   {(VUINT32) ((0xc0862385dbce4548uLL) >> 0),
    (VUINT32) ((0xc0862385dbce4548uLL) >> 32)},
   {(VUINT32) ((0xbe1cee9a1fbcaaeauLL) >> 0),
    (VUINT32) ((0xbe1cee9a1fbcaaeauLL) >> 32)},
   {(VUINT32) ((0xc0862389aede5bc0uLL) >> 0),
    (VUINT32) ((0xc0862389aede5bc0uLL) >> 32)},
   {(VUINT32) ((0xbe1ceed8e7cc1ad6uLL) >> 0),
    (VUINT32) ((0xbe1ceed8e7cc1ad6uLL) >> 32)},
   {(VUINT32) ((0xc086238d801b4500uLL) >> 0),
    (VUINT32) ((0xc086238d801b4500uLL) >> 32)},
   {(VUINT32) ((0xbe1cf10c8d059da6uLL) >> 0),
    (VUINT32) ((0xbe1cf10c8d059da6uLL) >> 32)},
   {(VUINT32) ((0xc08623914f86be18uLL) >> 0),
    (VUINT32) ((0xc08623914f86be18uLL) >> 32)},
   {(VUINT32) ((0xbe1ceee6c63a8165uLL) >> 0),
    (VUINT32) ((0xbe1ceee6c63a8165uLL) >> 32)},
   {(VUINT32) ((0xc08623951d228180uLL) >> 0),
    (VUINT32) ((0xc08623951d228180uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0c3592d2ff1uLL) >> 0),
    (VUINT32) ((0xbe1cf0c3592d2ff1uLL) >> 32)},
   {(VUINT32) ((0xc0862398e8f04758uLL) >> 0),
    (VUINT32) ((0xc0862398e8f04758uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0026cc4cb1buLL) >> 0),
    (VUINT32) ((0xbe1cf0026cc4cb1buLL) >> 32)},
   {(VUINT32) ((0xc086239cb2f1c538uLL) >> 0),
    (VUINT32) ((0xc086239cb2f1c538uLL) >> 32)},
   {(VUINT32) ((0xbe1cf15d48d8e670uLL) >> 0),
    (VUINT32) ((0xbe1cf15d48d8e670uLL) >> 32)},
   {(VUINT32) ((0xc08623a07b28ae60uLL) >> 0),
    (VUINT32) ((0xc08623a07b28ae60uLL) >> 32)},
   {(VUINT32) ((0xbe1cef359363787cuLL) >> 0),
    (VUINT32) ((0xbe1cef359363787cuLL) >> 32)},
   {(VUINT32) ((0xc08623a44196b390uLL) >> 0),
    (VUINT32) ((0xc08623a44196b390uLL) >> 32)},
   {(VUINT32) ((0xbe1cefdf1ab2e82cuLL) >> 0),
    (VUINT32) ((0xbe1cefdf1ab2e82cuLL) >> 32)},
   {(VUINT32) ((0xc08623a8063d8338uLL) >> 0),
    (VUINT32) ((0xc08623a8063d8338uLL) >> 32)},
   {(VUINT32) ((0xbe1cefe43c02aa84uLL) >> 0),
    (VUINT32) ((0xbe1cefe43c02aa84uLL) >> 32)},
   {(VUINT32) ((0xc08623abc91ec960uLL) >> 0),
    (VUINT32) ((0xc08623abc91ec960uLL) >> 32)},
   {(VUINT32) ((0xbe1cf044f5ae35b7uLL) >> 0),
    (VUINT32) ((0xbe1cf044f5ae35b7uLL) >> 32)},
   {(VUINT32) ((0xc08623af8a3c2fb8uLL) >> 0),
    (VUINT32) ((0xc08623af8a3c2fb8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0b0b4001e1buLL) >> 0),
    (VUINT32) ((0xbe1cf0b0b4001e1buLL) >> 32)},
   {(VUINT32) ((0xc08623b349975d98uLL) >> 0),
    (VUINT32) ((0xc08623b349975d98uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1bae76dfbcfuLL) >> 0),
    (VUINT32) ((0xbe1cf1bae76dfbcfuLL) >> 32)},
   {(VUINT32) ((0xc08623b70731f810uLL) >> 0),
    (VUINT32) ((0xc08623b70731f810uLL) >> 32)},
   {(VUINT32) ((0xbe1cef0a72e13a62uLL) >> 0),
    (VUINT32) ((0xbe1cef0a72e13a62uLL) >> 32)},
   {(VUINT32) ((0xc08623bac30da1c8uLL) >> 0),
    (VUINT32) ((0xc08623bac30da1c8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf184007d2b6buLL) >> 0),
    (VUINT32) ((0xbe1cf184007d2b6buLL) >> 32)},
   {(VUINT32) ((0xc08623be7d2bfb40uLL) >> 0),
    (VUINT32) ((0xc08623be7d2bfb40uLL) >> 32)},
   {(VUINT32) ((0xbe1cf16f4b239e98uLL) >> 0),
    (VUINT32) ((0xbe1cf16f4b239e98uLL) >> 32)},
   {(VUINT32) ((0xc08623c2358ea2a0uLL) >> 0),
    (VUINT32) ((0xc08623c2358ea2a0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0976acada87uLL) >> 0),
    (VUINT32) ((0xbe1cf0976acada87uLL) >> 32)},
   {(VUINT32) ((0xc08623c5ec3733d0uLL) >> 0),
    (VUINT32) ((0xc08623c5ec3733d0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf066318a16ffuLL) >> 0),
    (VUINT32) ((0xbe1cf066318a16ffuLL) >> 32)},
   {(VUINT32) ((0xc08623c9a1274880uLL) >> 0),
    (VUINT32) ((0xc08623c9a1274880uLL) >> 32)},
   {(VUINT32) ((0xbe1ceffaa7148798uLL) >> 0),
    (VUINT32) ((0xbe1ceffaa7148798uLL) >> 32)},
   {(VUINT32) ((0xc08623cd54607820uLL) >> 0),
    (VUINT32) ((0xc08623cd54607820uLL) >> 32)},
   {(VUINT32) ((0xbe1cf23ab02e9b6euLL) >> 0),
    (VUINT32) ((0xbe1cf23ab02e9b6euLL) >> 32)},
   {(VUINT32) ((0xc08623d105e45800uLL) >> 0),
    (VUINT32) ((0xc08623d105e45800uLL) >> 32)},
   {(VUINT32) ((0xbe1cefdfef7d4fdeuLL) >> 0),
    (VUINT32) ((0xbe1cefdfef7d4fdeuLL) >> 32)},
   {(VUINT32) ((0xc08623d4b5b47b20uLL) >> 0),
    (VUINT32) ((0xc08623d4b5b47b20uLL) >> 32)},
   {(VUINT32) ((0xbe1cf17fece44f2buLL) >> 0),
    (VUINT32) ((0xbe1cf17fece44f2buLL) >> 32)},
   {(VUINT32) ((0xc08623d863d27270uLL) >> 0),
    (VUINT32) ((0xc08623d863d27270uLL) >> 32)},
   {(VUINT32) ((0xbe1cf18f907d0d7cuLL) >> 0),
    (VUINT32) ((0xbe1cf18f907d0d7cuLL) >> 32)},
   {(VUINT32) ((0xc08623dc103fccb0uLL) >> 0),
    (VUINT32) ((0xc08623dc103fccb0uLL) >> 32)},
   {(VUINT32) ((0xbe1cee61fe072c98uLL) >> 0),
    (VUINT32) ((0xbe1cee61fe072c98uLL) >> 32)},
   {(VUINT32) ((0xc08623dfbafe1668uLL) >> 0),
    (VUINT32) ((0xc08623dfbafe1668uLL) >> 32)},
   {(VUINT32) ((0xbe1cf022dd891e2fuLL) >> 0),
    (VUINT32) ((0xbe1cf022dd891e2fuLL) >> 32)},
   {(VUINT32) ((0xc08623e3640eda20uLL) >> 0),
    (VUINT32) ((0xc08623e3640eda20uLL) >> 32)},
   {(VUINT32) ((0xbe1ceecc1daf4358uLL) >> 0),
    (VUINT32) ((0xbe1ceecc1daf4358uLL) >> 32)},
   {(VUINT32) ((0xc08623e70b73a028uLL) >> 0),
    (VUINT32) ((0xc08623e70b73a028uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0173c4fa380uLL) >> 0),
    (VUINT32) ((0xbe1cf0173c4fa380uLL) >> 32)},
   {(VUINT32) ((0xc08623eab12deec8uLL) >> 0),
    (VUINT32) ((0xc08623eab12deec8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf16a2150c2f4uLL) >> 0),
    (VUINT32) ((0xbe1cf16a2150c2f4uLL) >> 32)},
   {(VUINT32) ((0xc08623ee553f4a30uLL) >> 0),
    (VUINT32) ((0xc08623ee553f4a30uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1bf980b1f4buLL) >> 0),
    (VUINT32) ((0xbe1cf1bf980b1f4buLL) >> 32)},
   {(VUINT32) ((0xc08623f1f7a93480uLL) >> 0),
    (VUINT32) ((0xc08623f1f7a93480uLL) >> 32)},
   {(VUINT32) ((0xbe1cef8b731663c2uLL) >> 0),
    (VUINT32) ((0xbe1cef8b731663c2uLL) >> 32)},
   {(VUINT32) ((0xc08623f5986d2dc0uLL) >> 0),
    (VUINT32) ((0xc08623f5986d2dc0uLL) >> 32)},
   {(VUINT32) ((0xbe1cee9a664d7ef4uLL) >> 0),
    (VUINT32) ((0xbe1cee9a664d7ef4uLL) >> 32)},
   {(VUINT32) ((0xc08623f9378cb3f0uLL) >> 0),
    (VUINT32) ((0xc08623f9378cb3f0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1eda2af6400uLL) >> 0),
    (VUINT32) ((0xbe1cf1eda2af6400uLL) >> 32)},
   {(VUINT32) ((0xc08623fcd5094320uLL) >> 0),
    (VUINT32) ((0xc08623fcd5094320uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1923f9d68d7uLL) >> 0),
    (VUINT32) ((0xbe1cf1923f9d68d7uLL) >> 32)},
   {(VUINT32) ((0xc086240070e45548uLL) >> 0),
    (VUINT32) ((0xc086240070e45548uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0747cd3e03auLL) >> 0),
    (VUINT32) ((0xbe1cf0747cd3e03auLL) >> 32)},
   {(VUINT32) ((0xc08624040b1f6260uLL) >> 0),
    (VUINT32) ((0xc08624040b1f6260uLL) >> 32)},
   {(VUINT32) ((0xbe1cf22ee855bd6duLL) >> 0),
    (VUINT32) ((0xbe1cf22ee855bd6duLL) >> 32)},
   {(VUINT32) ((0xc0862407a3bbe078uLL) >> 0),
    (VUINT32) ((0xc0862407a3bbe078uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0d57360c00buLL) >> 0),
    (VUINT32) ((0xbe1cf0d57360c00buLL) >> 32)},
   {(VUINT32) ((0xc086240b3abb4398uLL) >> 0),
    (VUINT32) ((0xc086240b3abb4398uLL) >> 32)},
   {(VUINT32) ((0xbe1ceebc815cd575uLL) >> 0),
    (VUINT32) ((0xbe1ceebc815cd575uLL) >> 32)},
   {(VUINT32) ((0xc086240ed01efdd0uLL) >> 0),
    (VUINT32) ((0xc086240ed01efdd0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf03bfb970951uLL) >> 0),
    (VUINT32) ((0xbe1cf03bfb970951uLL) >> 32)},
   {(VUINT32) ((0xc086241263e87f50uLL) >> 0),
    (VUINT32) ((0xc086241263e87f50uLL) >> 32)},
   {(VUINT32) ((0xbe1cf16e74768529uLL) >> 0),
    (VUINT32) ((0xbe1cf16e74768529uLL) >> 32)},
   {(VUINT32) ((0xc0862415f6193658uLL) >> 0),
    (VUINT32) ((0xc0862415f6193658uLL) >> 32)},
   {(VUINT32) ((0xbe1cefec64b8becbuLL) >> 0),
    (VUINT32) ((0xbe1cefec64b8becbuLL) >> 32)},
   {(VUINT32) ((0xc086241986b28f30uLL) >> 0),
    (VUINT32) ((0xc086241986b28f30uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0838d210baauLL) >> 0),
    (VUINT32) ((0xbe1cf0838d210baauLL) >> 32)},
   {(VUINT32) ((0xc086241d15b5f448uLL) >> 0),
    (VUINT32) ((0xc086241d15b5f448uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0ea86e75b11uLL) >> 0),
    (VUINT32) ((0xbe1cf0ea86e75b11uLL) >> 32)},
   {(VUINT32) ((0xc0862420a324ce28uLL) >> 0),
    (VUINT32) ((0xc0862420a324ce28uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1708d11d805uLL) >> 0),
    (VUINT32) ((0xbe1cf1708d11d805uLL) >> 32)},
   {(VUINT32) ((0xc08624242f008380uLL) >> 0),
    (VUINT32) ((0xc08624242f008380uLL) >> 32)},
   {(VUINT32) ((0xbe1ceea988c5a417uLL) >> 0),
    (VUINT32) ((0xbe1ceea988c5a417uLL) >> 32)},
   {(VUINT32) ((0xc0862427b94a7910uLL) >> 0),
    (VUINT32) ((0xc0862427b94a7910uLL) >> 32)},
   {(VUINT32) ((0xbe1cef166a7bbca5uLL) >> 0),
    (VUINT32) ((0xbe1cef166a7bbca5uLL) >> 32)},
   {(VUINT32) ((0xc086242b420411d0uLL) >> 0),
    (VUINT32) ((0xc086242b420411d0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0c9d9e86a38uLL) >> 0),
    (VUINT32) ((0xbe1cf0c9d9e86a38uLL) >> 32)},
   {(VUINT32) ((0xc086242ec92eaee8uLL) >> 0),
    (VUINT32) ((0xc086242ec92eaee8uLL) >> 32)},
   {(VUINT32) ((0xbe1cef0946455411uLL) >> 0),
    (VUINT32) ((0xbe1cef0946455411uLL) >> 32)},
   {(VUINT32) ((0xc08624324ecbaf98uLL) >> 0),
    (VUINT32) ((0xc08624324ecbaf98uLL) >> 32)},
   {(VUINT32) ((0xbe1cefea60907739uLL) >> 0),
    (VUINT32) ((0xbe1cefea60907739uLL) >> 32)},
   {(VUINT32) ((0xc0862435d2dc7160uLL) >> 0),
    (VUINT32) ((0xc0862435d2dc7160uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1ed0934ce42uLL) >> 0),
    (VUINT32) ((0xbe1cf1ed0934ce42uLL) >> 32)},
   {(VUINT32) ((0xc086243955624ff8uLL) >> 0),
    (VUINT32) ((0xc086243955624ff8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf191ba746c7duLL) >> 0),
    (VUINT32) ((0xbe1cf191ba746c7duLL) >> 32)},
   {(VUINT32) ((0xc086243cd65ea548uLL) >> 0),
    (VUINT32) ((0xc086243cd65ea548uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeec78cf2a7euLL) >> 0),
    (VUINT32) ((0xbe1ceeec78cf2a7euLL) >> 32)},
   {(VUINT32) ((0xc086244055d2c968uLL) >> 0),
    (VUINT32) ((0xc086244055d2c968uLL) >> 32)},
   {(VUINT32) ((0xbe1cef345284c119uLL) >> 0),
    (VUINT32) ((0xbe1cef345284c119uLL) >> 32)},
   {(VUINT32) ((0xc0862443d3c012b8uLL) >> 0),
    (VUINT32) ((0xc0862443d3c012b8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf24f77355219uLL) >> 0),
    (VUINT32) ((0xbe1cf24f77355219uLL) >> 32)},
   {(VUINT32) ((0xc08624475027d5e8uLL) >> 0),
    (VUINT32) ((0xc08624475027d5e8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf05bf087e114uLL) >> 0),
    (VUINT32) ((0xbe1cf05bf087e114uLL) >> 32)},
   {(VUINT32) ((0xc086244acb0b65d0uLL) >> 0),
    (VUINT32) ((0xc086244acb0b65d0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef3504a32189uLL) >> 0),
    (VUINT32) ((0xbe1cef3504a32189uLL) >> 32)},
   {(VUINT32) ((0xc086244e446c1398uLL) >> 0),
    (VUINT32) ((0xc086244e446c1398uLL) >> 32)},
   {(VUINT32) ((0xbe1ceff54b2a406fuLL) >> 0),
    (VUINT32) ((0xbe1ceff54b2a406fuLL) >> 32)},
   {(VUINT32) ((0xc0862451bc4b2eb8uLL) >> 0),
    (VUINT32) ((0xc0862451bc4b2eb8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0757d54ed4fuLL) >> 0),
    (VUINT32) ((0xbe1cf0757d54ed4fuLL) >> 32)},
   {(VUINT32) ((0xc086245532aa04f0uLL) >> 0),
    (VUINT32) ((0xc086245532aa04f0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0c8099fdfd5uLL) >> 0),
    (VUINT32) ((0xbe1cf0c8099fdfd5uLL) >> 32)},
   {(VUINT32) ((0xc0862458a789e250uLL) >> 0),
    (VUINT32) ((0xc0862458a789e250uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0b173796a31uLL) >> 0),
    (VUINT32) ((0xbe1cf0b173796a31uLL) >> 32)},
   {(VUINT32) ((0xc086245c1aec1138uLL) >> 0),
    (VUINT32) ((0xc086245c1aec1138uLL) >> 32)},
   {(VUINT32) ((0xbe1cf11d8734540duLL) >> 0),
    (VUINT32) ((0xbe1cf11d8734540duLL) >> 32)},
   {(VUINT32) ((0xc086245f8cd1da60uLL) >> 0),
    (VUINT32) ((0xc086245f8cd1da60uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1916a723cebuLL) >> 0),
    (VUINT32) ((0xbe1cf1916a723cebuLL) >> 32)},
   {(VUINT32) ((0xc0862462fd3c84d8uLL) >> 0),
    (VUINT32) ((0xc0862462fd3c84d8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf19a911e1da7uLL) >> 0),
    (VUINT32) ((0xbe1cf19a911e1da7uLL) >> 32)},
   {(VUINT32) ((0xc08624666c2d5608uLL) >> 0),
    (VUINT32) ((0xc08624666c2d5608uLL) >> 32)},
   {(VUINT32) ((0xbe1cf23a9ef72e4fuLL) >> 0),
    (VUINT32) ((0xbe1cf23a9ef72e4fuLL) >> 32)},
   {(VUINT32) ((0xc0862469d9a591c0uLL) >> 0),
    (VUINT32) ((0xc0862469d9a591c0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef503d947663uLL) >> 0),
    (VUINT32) ((0xbe1cef503d947663uLL) >> 32)},
   {(VUINT32) ((0xc086246d45a67a18uLL) >> 0),
    (VUINT32) ((0xc086246d45a67a18uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0fceeb1a0b2uLL) >> 0),
    (VUINT32) ((0xbe1cf0fceeb1a0b2uLL) >> 32)},
   {(VUINT32) ((0xc0862470b0314fa8uLL) >> 0),
    (VUINT32) ((0xc0862470b0314fa8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf107e27e4fbcuLL) >> 0),
    (VUINT32) ((0xbe1cf107e27e4fbcuLL) >> 32)},
   {(VUINT32) ((0xc086247419475160uLL) >> 0),
    (VUINT32) ((0xc086247419475160uLL) >> 32)},
   {(VUINT32) ((0xbe1cf03dd9922331uLL) >> 0),
    (VUINT32) ((0xbe1cf03dd9922331uLL) >> 32)},
   {(VUINT32) ((0xc086247780e9bc98uLL) >> 0),
    (VUINT32) ((0xc086247780e9bc98uLL) >> 32)},
   {(VUINT32) ((0xbe1cefce1a10e129uLL) >> 0),
    (VUINT32) ((0xbe1cefce1a10e129uLL) >> 32)},
   {(VUINT32) ((0xc086247ae719cd18uLL) >> 0),
    (VUINT32) ((0xc086247ae719cd18uLL) >> 32)},
   {(VUINT32) ((0xbe1ceea47f73c4f6uLL) >> 0),
    (VUINT32) ((0xbe1ceea47f73c4f6uLL) >> 32)},
   {(VUINT32) ((0xc086247e4bd8bd10uLL) >> 0),
    (VUINT32) ((0xc086247e4bd8bd10uLL) >> 32)},
   {(VUINT32) ((0xbe1ceec0ac56d100uLL) >> 0),
    (VUINT32) ((0xbe1ceec0ac56d100uLL) >> 32)},
   {(VUINT32) ((0xc0862481af27c528uLL) >> 0),
    (VUINT32) ((0xc0862481af27c528uLL) >> 32)},
   {(VUINT32) ((0xbe1cee8a6593278auLL) >> 0),
    (VUINT32) ((0xbe1cee8a6593278auLL) >> 32)},
   {(VUINT32) ((0xc086248511081c70uLL) >> 0),
    (VUINT32) ((0xc086248511081c70uLL) >> 32)},
   {(VUINT32) ((0xbe1cf2231dd9dec7uLL) >> 0),
    (VUINT32) ((0xbe1cf2231dd9dec7uLL) >> 32)},
   {(VUINT32) ((0xc0862488717af888uLL) >> 0),
    (VUINT32) ((0xc0862488717af888uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0b4b8ed7da8uLL) >> 0),
    (VUINT32) ((0xbe1cf0b4b8ed7da8uLL) >> 32)},
   {(VUINT32) ((0xc086248bd0818d68uLL) >> 0),
    (VUINT32) ((0xc086248bd0818d68uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1bd8d835002uLL) >> 0),
    (VUINT32) ((0xbe1cf1bd8d835002uLL) >> 32)},
   {(VUINT32) ((0xc086248f2e1d0d98uLL) >> 0),
    (VUINT32) ((0xc086248f2e1d0d98uLL) >> 32)},
   {(VUINT32) ((0xbe1cf259acc107f4uLL) >> 0),
    (VUINT32) ((0xbe1cf259acc107f4uLL) >> 32)},
   {(VUINT32) ((0xc08624928a4eaa20uLL) >> 0),
    (VUINT32) ((0xc08624928a4eaa20uLL) >> 32)},
   {(VUINT32) ((0xbe1cee897636b00cuLL) >> 0),
    (VUINT32) ((0xbe1cee897636b00cuLL) >> 32)},
   {(VUINT32) ((0xc0862495e5179270uLL) >> 0),
    (VUINT32) ((0xc0862495e5179270uLL) >> 32)},
   {(VUINT32) ((0xbe1cee757f20c326uLL) >> 0),
    (VUINT32) ((0xbe1cee757f20c326uLL) >> 32)},
   {(VUINT32) ((0xc08624993e78f490uLL) >> 0),
    (VUINT32) ((0xc08624993e78f490uLL) >> 32)},
   {(VUINT32) ((0xbe1cefafd3aa54a4uLL) >> 0),
    (VUINT32) ((0xbe1cefafd3aa54a4uLL) >> 32)},
   {(VUINT32) ((0xc086249c9673fd10uLL) >> 0),
    (VUINT32) ((0xc086249c9673fd10uLL) >> 32)},
   {(VUINT32) ((0xbe1cee7298d38b97uLL) >> 0),
    (VUINT32) ((0xbe1cee7298d38b97uLL) >> 32)},
   {(VUINT32) ((0xc086249fed09d6f8uLL) >> 0),
    (VUINT32) ((0xc086249fed09d6f8uLL) >> 32)},
   {(VUINT32) ((0xbe1ceedc158d4cebuLL) >> 0),
    (VUINT32) ((0xbe1ceedc158d4cebuLL) >> 32)},
   {(VUINT32) ((0xc08624a3423babe0uLL) >> 0),
    (VUINT32) ((0xc08624a3423babe0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf2282987cb2euLL) >> 0),
    (VUINT32) ((0xbe1cf2282987cb2euLL) >> 32)},
   {(VUINT32) ((0xc08624a6960aa400uLL) >> 0),
    (VUINT32) ((0xc08624a6960aa400uLL) >> 32)},
   {(VUINT32) ((0xbe1cefe7381ecc4buLL) >> 0),
    (VUINT32) ((0xbe1cefe7381ecc4buLL) >> 32)},
   {(VUINT32) ((0xc08624a9e877e600uLL) >> 0),
    (VUINT32) ((0xc08624a9e877e600uLL) >> 32)},
   {(VUINT32) ((0xbe1cef328dbbce80uLL) >> 0),
    (VUINT32) ((0xbe1cef328dbbce80uLL) >> 32)},
   {(VUINT32) ((0xc08624ad39849728uLL) >> 0),
    (VUINT32) ((0xc08624ad39849728uLL) >> 32)},
   {(VUINT32) ((0xbe1cefde45f3cc71uLL) >> 0),
    (VUINT32) ((0xbe1cefde45f3cc71uLL) >> 32)},
   {(VUINT32) ((0xc08624b08931db58uLL) >> 0),
    (VUINT32) ((0xc08624b08931db58uLL) >> 32)},
   {(VUINT32) ((0xbe1cefa8b89433b9uLL) >> 0),
    (VUINT32) ((0xbe1cefa8b89433b9uLL) >> 32)},
   {(VUINT32) ((0xc08624b3d780d500uLL) >> 0),
    (VUINT32) ((0xc08624b3d780d500uLL) >> 32)},
   {(VUINT32) ((0xbe1cef6773c0b139uLL) >> 0),
    (VUINT32) ((0xbe1cef6773c0b139uLL) >> 32)},
   {(VUINT32) ((0xc08624b72472a528uLL) >> 0),
    (VUINT32) ((0xc08624b72472a528uLL) >> 32)},
   {(VUINT32) ((0xbe1cf031c931c11fuLL) >> 0),
    (VUINT32) ((0xbe1cf031c931c11fuLL) >> 32)},
   {(VUINT32) ((0xc08624ba70086b78uLL) >> 0),
    (VUINT32) ((0xc08624ba70086b78uLL) >> 32)},
   {(VUINT32) ((0xbe1cf088f49275e7uLL) >> 0),
    (VUINT32) ((0xbe1cf088f49275e7uLL) >> 32)},
   {(VUINT32) ((0xc08624bdba434630uLL) >> 0),
    (VUINT32) ((0xc08624bdba434630uLL) >> 32)},
   {(VUINT32) ((0xbe1cf17de0eaa86duLL) >> 0),
    (VUINT32) ((0xbe1cf17de0eaa86duLL) >> 32)},
   {(VUINT32) ((0xc08624c103245238uLL) >> 0),
    (VUINT32) ((0xc08624c103245238uLL) >> 32)},
   {(VUINT32) ((0xbe1cefd492f1ba75uLL) >> 0),
    (VUINT32) ((0xbe1cefd492f1ba75uLL) >> 32)},
   {(VUINT32) ((0xc08624c44aacab08uLL) >> 0),
    (VUINT32) ((0xc08624c44aacab08uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1253e154466uLL) >> 0),
    (VUINT32) ((0xbe1cf1253e154466uLL) >> 32)},
   {(VUINT32) ((0xc08624c790dd6ad0uLL) >> 0),
    (VUINT32) ((0xc08624c790dd6ad0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0fb09ee6d55uLL) >> 0),
    (VUINT32) ((0xbe1cf0fb09ee6d55uLL) >> 32)},
   {(VUINT32) ((0xc08624cad5b7aa58uLL) >> 0),
    (VUINT32) ((0xc08624cad5b7aa58uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1f08dd048feuLL) >> 0),
    (VUINT32) ((0xbe1cf1f08dd048feuLL) >> 32)},
   {(VUINT32) ((0xc08624ce193c8120uLL) >> 0),
    (VUINT32) ((0xc08624ce193c8120uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeca0809697fuLL) >> 0),
    (VUINT32) ((0xbe1ceeca0809697fuLL) >> 32)},
   {(VUINT32) ((0xc08624d15b6d0538uLL) >> 0),
    (VUINT32) ((0xc08624d15b6d0538uLL) >> 32)},
   {(VUINT32) ((0xbe1cef8d5662d968uLL) >> 0),
    (VUINT32) ((0xbe1cef8d5662d968uLL) >> 32)},
   {(VUINT32) ((0xc08624d49c4a4b78uLL) >> 0),
    (VUINT32) ((0xc08624d49c4a4b78uLL) >> 32)},
   {(VUINT32) ((0xbe1cee97b556ed78uLL) >> 0),
    (VUINT32) ((0xbe1cee97b556ed78uLL) >> 32)},
   {(VUINT32) ((0xc08624d7dbd56750uLL) >> 0),
    (VUINT32) ((0xc08624d7dbd56750uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1b14b6acb75uLL) >> 0),
    (VUINT32) ((0xbe1cf1b14b6acb75uLL) >> 32)},
   {(VUINT32) ((0xc08624db1a0f6b00uLL) >> 0),
    (VUINT32) ((0xc08624db1a0f6b00uLL) >> 32)},
   {(VUINT32) ((0xbe1cef1e860623f2uLL) >> 0),
    (VUINT32) ((0xbe1cef1e860623f2uLL) >> 32)},
   {(VUINT32) ((0xc08624de56f96758uLL) >> 0),
    (VUINT32) ((0xc08624de56f96758uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeaf4d156f3duLL) >> 0),
    (VUINT32) ((0xbe1ceeaf4d156f3duLL) >> 32)},
   {(VUINT32) ((0xc08624e192946bf0uLL) >> 0),
    (VUINT32) ((0xc08624e192946bf0uLL) >> 32)},
   {(VUINT32) ((0xbe1ceecc12b400eduLL) >> 0),
    (VUINT32) ((0xbe1ceecc12b400eduLL) >> 32)},
   {(VUINT32) ((0xc08624e4cce18710uLL) >> 0),
    (VUINT32) ((0xc08624e4cce18710uLL) >> 32)},
   {(VUINT32) ((0xbe1cf180c40c794fuLL) >> 0),
    (VUINT32) ((0xbe1cf180c40c794fuLL) >> 32)},
   {(VUINT32) ((0xc08624e805e1c5c8uLL) >> 0),
    (VUINT32) ((0xc08624e805e1c5c8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf185a08f7f65uLL) >> 0),
    (VUINT32) ((0xbe1cf185a08f7f65uLL) >> 32)},
   {(VUINT32) ((0xc08624eb3d9633d8uLL) >> 0),
    (VUINT32) ((0xc08624eb3d9633d8uLL) >> 32)},
   {(VUINT32) ((0xbe1cef45fc924078uLL) >> 0),
    (VUINT32) ((0xbe1cef45fc924078uLL) >> 32)},
   {(VUINT32) ((0xc08624ee73ffdbb0uLL) >> 0),
    (VUINT32) ((0xc08624ee73ffdbb0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1e4f457f32auLL) >> 0),
    (VUINT32) ((0xbe1cf1e4f457f32auLL) >> 32)},
   {(VUINT32) ((0xc08624f1a91fc6a0uLL) >> 0),
    (VUINT32) ((0xc08624f1a91fc6a0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf040147b8a5auLL) >> 0),
    (VUINT32) ((0xbe1cf040147b8a5auLL) >> 32)},
   {(VUINT32) ((0xc08624f4dcf6fc98uLL) >> 0),
    (VUINT32) ((0xc08624f4dcf6fc98uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1effca0dfb2uLL) >> 0),
    (VUINT32) ((0xbe1cf1effca0dfb2uLL) >> 32)},
   {(VUINT32) ((0xc08624f80f868468uLL) >> 0),
    (VUINT32) ((0xc08624f80f868468uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0470146e5bcuLL) >> 0),
    (VUINT32) ((0xbe1cf0470146e5bcuLL) >> 32)},
   {(VUINT32) ((0xc08624fb40cf6390uLL) >> 0),
    (VUINT32) ((0xc08624fb40cf6390uLL) >> 32)},
   {(VUINT32) ((0xbe1cef4dd186e501uLL) >> 0),
    (VUINT32) ((0xbe1cef4dd186e501uLL) >> 32)},
   {(VUINT32) ((0xc08624fe70d29e60uLL) >> 0),
    (VUINT32) ((0xc08624fe70d29e60uLL) >> 32)},
   {(VUINT32) ((0xbe1ceebe257f66c7uLL) >> 0),
    (VUINT32) ((0xbe1ceebe257f66c7uLL) >> 32)},
   {(VUINT32) ((0xc08625019f9137f0uLL) >> 0),
    (VUINT32) ((0xc08625019f9137f0uLL) >> 32)},
   {(VUINT32) ((0xbe1ceefb7a1c395cuLL) >> 0),
    (VUINT32) ((0xbe1ceefb7a1c395cuLL) >> 32)},
   {(VUINT32) ((0xc0862504cd0c3220uLL) >> 0),
    (VUINT32) ((0xc0862504cd0c3220uLL) >> 32)},
   {(VUINT32) ((0xbe1cf209dedfed8cuLL) >> 0),
    (VUINT32) ((0xbe1cf209dedfed8cuLL) >> 32)},
   {(VUINT32) ((0xc0862507f9448db0uLL) >> 0),
    (VUINT32) ((0xc0862507f9448db0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf082da464994uLL) >> 0),
    (VUINT32) ((0xbe1cf082da464994uLL) >> 32)},
   {(VUINT32) ((0xc086250b243b4a18uLL) >> 0),
    (VUINT32) ((0xc086250b243b4a18uLL) >> 32)},
   {(VUINT32) ((0xbe1cee88694a73cfuLL) >> 0),
    (VUINT32) ((0xbe1cee88694a73cfuLL) >> 32)},
   {(VUINT32) ((0xc086250e4df165a0uLL) >> 0),
    (VUINT32) ((0xc086250e4df165a0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0b61e8f0531uLL) >> 0),
    (VUINT32) ((0xbe1cf0b61e8f0531uLL) >> 32)},
   {(VUINT32) ((0xc08625117667dd78uLL) >> 0),
    (VUINT32) ((0xc08625117667dd78uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1106599c962uLL) >> 0),
    (VUINT32) ((0xbe1cf1106599c962uLL) >> 32)},
   {(VUINT32) ((0xc08625149d9fad98uLL) >> 0),
    (VUINT32) ((0xc08625149d9fad98uLL) >> 32)},
   {(VUINT32) ((0xbe1ceff1ee88af1fuLL) >> 0),
    (VUINT32) ((0xbe1ceff1ee88af1fuLL) >> 32)},
   {(VUINT32) ((0xc0862517c399d0c8uLL) >> 0),
    (VUINT32) ((0xc0862517c399d0c8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0f746994ef6uLL) >> 0),
    (VUINT32) ((0xbe1cf0f746994ef6uLL) >> 32)},
   {(VUINT32) ((0xc086251ae85740b8uLL) >> 0),
    (VUINT32) ((0xc086251ae85740b8uLL) >> 32)},
   {(VUINT32) ((0xbe1cefe8a1d077e4uLL) >> 0),
    (VUINT32) ((0xbe1cefe8a1d077e4uLL) >> 32)},
   {(VUINT32) ((0xc086251e0bd8f5e0uLL) >> 0),
    (VUINT32) ((0xc086251e0bd8f5e0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1a1da036092uLL) >> 0),
    (VUINT32) ((0xbe1cf1a1da036092uLL) >> 32)},
   {(VUINT32) ((0xc08625212e1fe7a8uLL) >> 0),
    (VUINT32) ((0xc08625212e1fe7a8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0f8a7786fcduLL) >> 0),
    (VUINT32) ((0xbe1cf0f8a7786fcduLL) >> 32)},
   {(VUINT32) ((0xc08625244f2d0c48uLL) >> 0),
    (VUINT32) ((0xc08625244f2d0c48uLL) >> 32)},
   {(VUINT32) ((0xbe1cefa1174a07a7uLL) >> 0),
    (VUINT32) ((0xbe1cefa1174a07a7uLL) >> 32)},
   {(VUINT32) ((0xc08625276f0158d8uLL) >> 0),
    (VUINT32) ((0xc08625276f0158d8uLL) >> 32)},
   {(VUINT32) ((0xbe1cef1043aa5b25uLL) >> 0),
    (VUINT32) ((0xbe1cef1043aa5b25uLL) >> 32)},
   {(VUINT32) ((0xc086252a8d9dc150uLL) >> 0),
    (VUINT32) ((0xc086252a8d9dc150uLL) >> 32)},
   {(VUINT32) ((0xbe1cf15d521c169duLL) >> 0),
    (VUINT32) ((0xbe1cf15d521c169duLL) >> 32)},
   {(VUINT32) ((0xc086252dab033898uLL) >> 0),
    (VUINT32) ((0xc086252dab033898uLL) >> 32)},
   {(VUINT32) ((0xbe1cf220bba8861fuLL) >> 0),
    (VUINT32) ((0xbe1cf220bba8861fuLL) >> 32)},
   {(VUINT32) ((0xc0862530c732b078uLL) >> 0),
    (VUINT32) ((0xc0862530c732b078uLL) >> 32)},
   {(VUINT32) ((0xbe1cef51e310eae2uLL) >> 0),
    (VUINT32) ((0xbe1cef51e310eae2uLL) >> 32)},
   {(VUINT32) ((0xc0862533e22d1988uLL) >> 0),
    (VUINT32) ((0xc0862533e22d1988uLL) >> 32)},
   {(VUINT32) ((0xbe1cf222fcedd8aeuLL) >> 0),
    (VUINT32) ((0xbe1cf222fcedd8aeuLL) >> 32)},
   {(VUINT32) ((0xc0862536fbf36370uLL) >> 0),
    (VUINT32) ((0xc0862536fbf36370uLL) >> 32)},
   {(VUINT32) ((0xbe1cefdb4da4bda8uLL) >> 0),
    (VUINT32) ((0xbe1cefdb4da4bda8uLL) >> 32)},
   {(VUINT32) ((0xc086253a14867ca0uLL) >> 0),
    (VUINT32) ((0xc086253a14867ca0uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeafc1112171uLL) >> 0),
    (VUINT32) ((0xbe1ceeafc1112171uLL) >> 32)},
   {(VUINT32) ((0xc086253d2be75280uLL) >> 0),
    (VUINT32) ((0xc086253d2be75280uLL) >> 32)},
   {(VUINT32) ((0xbe1cee99dfb4b408uLL) >> 0),
    (VUINT32) ((0xbe1cee99dfb4b408uLL) >> 32)},
   {(VUINT32) ((0xc08625404216d160uLL) >> 0),
    (VUINT32) ((0xc08625404216d160uLL) >> 32)},
   {(VUINT32) ((0xbe1cf22d2536f06buLL) >> 0),
    (VUINT32) ((0xbe1cf22d2536f06buLL) >> 32)},
   {(VUINT32) ((0xc08625435715e498uLL) >> 0),
    (VUINT32) ((0xc08625435715e498uLL) >> 32)},
   {(VUINT32) ((0xbe1cef6abbf2e268uLL) >> 0),
    (VUINT32) ((0xbe1cef6abbf2e268uLL) >> 32)},
   {(VUINT32) ((0xc08625466ae57648uLL) >> 0),
    (VUINT32) ((0xc08625466ae57648uLL) >> 32)},
   {(VUINT32) ((0xbe1cf093a14789f5uLL) >> 0),
    (VUINT32) ((0xbe1cf093a14789f5uLL) >> 32)},
   {(VUINT32) ((0xc08625497d866fa0uLL) >> 0),
    (VUINT32) ((0xc08625497d866fa0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0f93655603cuLL) >> 0),
    (VUINT32) ((0xbe1cf0f93655603cuLL) >> 32)},
   {(VUINT32) ((0xc086254c8ef9b8b8uLL) >> 0),
    (VUINT32) ((0xc086254c8ef9b8b8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1cc40c9aafcuLL) >> 0),
    (VUINT32) ((0xbe1cf1cc40c9aafcuLL) >> 32)},
   {(VUINT32) ((0xc086254f9f4038a8uLL) >> 0),
    (VUINT32) ((0xc086254f9f4038a8uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeea5f4e9157uLL) >> 0),
    (VUINT32) ((0xbe1ceeea5f4e9157uLL) >> 32)},
   {(VUINT32) ((0xc0862552ae5ad568uLL) >> 0),
    (VUINT32) ((0xc0862552ae5ad568uLL) >> 32)},
   {(VUINT32) ((0xbe1cefa9f52d4997uLL) >> 0),
    (VUINT32) ((0xbe1cefa9f52d4997uLL) >> 32)},
   {(VUINT32) ((0xc0862555bc4a7400uLL) >> 0),
    (VUINT32) ((0xc0862555bc4a7400uLL) >> 32)},
   {(VUINT32) ((0xbe1cefa490a638ffuLL) >> 0),
    (VUINT32) ((0xbe1cefa490a638ffuLL) >> 32)},
   {(VUINT32) ((0xc0862558c90ff868uLL) >> 0),
    (VUINT32) ((0xc0862558c90ff868uLL) >> 32)},
   {(VUINT32) ((0xbe1cef7fcf797d6fuLL) >> 0),
    (VUINT32) ((0xbe1cef7fcf797d6fuLL) >> 32)},
   {(VUINT32) ((0xc086255bd4ac4590uLL) >> 0),
    (VUINT32) ((0xc086255bd4ac4590uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1b4c51113c9uLL) >> 0),
    (VUINT32) ((0xbe1cf1b4c51113c9uLL) >> 32)},
   {(VUINT32) ((0xc086255edf203d78uLL) >> 0),
    (VUINT32) ((0xc086255edf203d78uLL) >> 32)},
   {(VUINT32) ((0xbe1cef55e5b4a55duLL) >> 0),
    (VUINT32) ((0xbe1cef55e5b4a55duLL) >> 32)},
   {(VUINT32) ((0xc0862561e86cc100uLL) >> 0),
    (VUINT32) ((0xc0862561e86cc100uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0d37a25f9dcuLL) >> 0),
    (VUINT32) ((0xbe1cf0d37a25f9dcuLL) >> 32)},
   {(VUINT32) ((0xc0862564f092b028uLL) >> 0),
    (VUINT32) ((0xc0862564f092b028uLL) >> 32)},
   {(VUINT32) ((0xbe1ceebe9efc19d9uLL) >> 0),
    (VUINT32) ((0xbe1ceebe9efc19d9uLL) >> 32)},
   {(VUINT32) ((0xc0862567f792e9d8uLL) >> 0),
    (VUINT32) ((0xc0862567f792e9d8uLL) >> 32)},
   {(VUINT32) ((0xbe1cee8ad30a57b5uLL) >> 0),
    (VUINT32) ((0xbe1cee8ad30a57b5uLL) >> 32)},
   {(VUINT32) ((0xc086256afd6e4c08uLL) >> 0),
    (VUINT32) ((0xc086256afd6e4c08uLL) >> 32)},
   {(VUINT32) ((0xbe1cef4e1817b90buLL) >> 0),
    (VUINT32) ((0xbe1cef4e1817b90buLL) >> 32)},
   {(VUINT32) ((0xc086256e0225b3b8uLL) >> 0),
    (VUINT32) ((0xc086256e0225b3b8uLL) >> 32)},
   {(VUINT32) ((0xbe1cee7fa9229996uLL) >> 0),
    (VUINT32) ((0xbe1cee7fa9229996uLL) >> 32)},
   {(VUINT32) ((0xc086257105b9fce0uLL) >> 0),
    (VUINT32) ((0xc086257105b9fce0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0b54963d945uLL) >> 0),
    (VUINT32) ((0xbe1cf0b54963d945uLL) >> 32)},
   {(VUINT32) ((0xc0862574082c0298uLL) >> 0),
    (VUINT32) ((0xc0862574082c0298uLL) >> 32)},
   {(VUINT32) ((0xbe1cee5f2f3c7995uLL) >> 0),
    (VUINT32) ((0xbe1cee5f2f3c7995uLL) >> 32)},
   {(VUINT32) ((0xc0862577097c9ee0uLL) >> 0),
    (VUINT32) ((0xc0862577097c9ee0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0828e303a2cuLL) >> 0),
    (VUINT32) ((0xbe1cf0828e303a2cuLL) >> 32)},
   {(VUINT32) ((0xc086257a09acaae0uLL) >> 0),
    (VUINT32) ((0xc086257a09acaae0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf172c3078947uLL) >> 0),
    (VUINT32) ((0xbe1cf172c3078947uLL) >> 32)},
   {(VUINT32) ((0xc086257d08bcfec0uLL) >> 0),
    (VUINT32) ((0xc086257d08bcfec0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf189252afa22uLL) >> 0),
    (VUINT32) ((0xbe1cf189252afa22uLL) >> 32)},
   {(VUINT32) ((0xc086258006ae71b8uLL) >> 0),
    (VUINT32) ((0xc086258006ae71b8uLL) >> 32)},
   {(VUINT32) ((0xbe1cefdb80426923uLL) >> 0),
    (VUINT32) ((0xbe1cefdb80426923uLL) >> 32)},
   {(VUINT32) ((0xc08625830381da08uLL) >> 0),
    (VUINT32) ((0xc08625830381da08uLL) >> 32)},
   {(VUINT32) ((0xbe1ceef1391a0372uLL) >> 0),
    (VUINT32) ((0xbe1ceef1391a0372uLL) >> 32)},
   {(VUINT32) ((0xc0862585ff380d00uLL) >> 0),
    (VUINT32) ((0xc0862585ff380d00uLL) >> 32)},
   {(VUINT32) ((0xbe1cf17720c78d13uLL) >> 0),
    (VUINT32) ((0xbe1cf17720c78d13uLL) >> 32)},
   {(VUINT32) ((0xc0862588f9d1df18uLL) >> 0),
    (VUINT32) ((0xc0862588f9d1df18uLL) >> 32)},
   {(VUINT32) ((0xbe1ceef1f9027d83uLL) >> 0),
    (VUINT32) ((0xbe1ceef1f9027d83uLL) >> 32)},
   {(VUINT32) ((0xc086258bf35023b8uLL) >> 0),
    (VUINT32) ((0xc086258bf35023b8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf06fac99dec9uLL) >> 0),
    (VUINT32) ((0xbe1cf06fac99dec9uLL) >> 32)},
   {(VUINT32) ((0xc086258eebb3ad78uLL) >> 0),
    (VUINT32) ((0xc086258eebb3ad78uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1373eeb45c0uLL) >> 0),
    (VUINT32) ((0xbe1cf1373eeb45c0uLL) >> 32)},
   {(VUINT32) ((0xc0862591e2fd4e00uLL) >> 0),
    (VUINT32) ((0xc0862591e2fd4e00uLL) >> 32)},
   {(VUINT32) ((0xbe1cef777536bb81uLL) >> 0),
    (VUINT32) ((0xbe1cef777536bb81uLL) >> 32)},
   {(VUINT32) ((0xc0862594d92dd600uLL) >> 0),
    (VUINT32) ((0xc0862594d92dd600uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0f43ca40766uLL) >> 0),
    (VUINT32) ((0xbe1cf0f43ca40766uLL) >> 32)},
   {(VUINT32) ((0xc0862597ce461558uLL) >> 0),
    (VUINT32) ((0xc0862597ce461558uLL) >> 32)},
   {(VUINT32) ((0xbe1cefb2cfc6766buLL) >> 0),
    (VUINT32) ((0xbe1cefb2cfc6766buLL) >> 32)},
   {(VUINT32) ((0xc086259ac246daf0uLL) >> 0),
    (VUINT32) ((0xc086259ac246daf0uLL) >> 32)},
   {(VUINT32) ((0xbe1ceea49e64ffa2uLL) >> 0),
    (VUINT32) ((0xbe1ceea49e64ffa2uLL) >> 32)},
   {(VUINT32) ((0xc086259db530f4c8uLL) >> 0),
    (VUINT32) ((0xc086259db530f4c8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf250fa457decuLL) >> 0),
    (VUINT32) ((0xbe1cf250fa457decuLL) >> 32)},
   {(VUINT32) ((0xc08625a0a7053018uLL) >> 0),
    (VUINT32) ((0xc08625a0a7053018uLL) >> 32)},
   {(VUINT32) ((0xbe1cf17d8bb2a44euLL) >> 0),
    (VUINT32) ((0xbe1cf17d8bb2a44euLL) >> 32)},
   {(VUINT32) ((0xc08625a397c45918uLL) >> 0),
    (VUINT32) ((0xc08625a397c45918uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1d5906d54b7uLL) >> 0),
    (VUINT32) ((0xbe1cf1d5906d54b7uLL) >> 32)},
   {(VUINT32) ((0xc08625a6876f3b30uLL) >> 0),
    (VUINT32) ((0xc08625a6876f3b30uLL) >> 32)},
   {(VUINT32) ((0xbe1cf08fe7b31780uLL) >> 0),
    (VUINT32) ((0xbe1cf08fe7b31780uLL) >> 32)},
   {(VUINT32) ((0xc08625a97606a0e0uLL) >> 0),
    (VUINT32) ((0xc08625a97606a0e0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef13edfc9d11uLL) >> 0),
    (VUINT32) ((0xbe1cef13edfc9d11uLL) >> 32)},
   {(VUINT32) ((0xc08625ac638b53c8uLL) >> 0),
    (VUINT32) ((0xc08625ac638b53c8uLL) >> 32)},
   {(VUINT32) ((0xbe1cef9d2b107219uLL) >> 0),
    (VUINT32) ((0xbe1cef9d2b107219uLL) >> 32)},
   {(VUINT32) ((0xc08625af4ffe1cb0uLL) >> 0),
    (VUINT32) ((0xc08625af4ffe1cb0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1ddd4ff6160uLL) >> 0),
    (VUINT32) ((0xbe1cf1ddd4ff6160uLL) >> 32)},
   {(VUINT32) ((0xc08625b23b5fc390uLL) >> 0),
    (VUINT32) ((0xc08625b23b5fc390uLL) >> 32)},
   {(VUINT32) ((0xbe1cefa02a996495uLL) >> 0),
    (VUINT32) ((0xbe1cefa02a996495uLL) >> 32)},
   {(VUINT32) ((0xc08625b525b10f68uLL) >> 0),
    (VUINT32) ((0xc08625b525b10f68uLL) >> 32)},
   {(VUINT32) ((0xbe1cf166a7e37ee5uLL) >> 0),
    (VUINT32) ((0xbe1cf166a7e37ee5uLL) >> 32)},
   {(VUINT32) ((0xc08625b80ef2c680uLL) >> 0),
    (VUINT32) ((0xc08625b80ef2c680uLL) >> 32)},
   {(VUINT32) ((0xbe1cef0b171068a5uLL) >> 0),
    (VUINT32) ((0xbe1cef0b171068a5uLL) >> 32)},
   {(VUINT32) ((0xc08625baf725ae28uLL) >> 0),
    (VUINT32) ((0xc08625baf725ae28uLL) >> 32)},
   {(VUINT32) ((0xbe1cf05c80779283uLL) >> 0),
    (VUINT32) ((0xbe1cf05c80779283uLL) >> 32)},
   {(VUINT32) ((0xc08625bdde4a8af0uLL) >> 0),
    (VUINT32) ((0xc08625bdde4a8af0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1bbfbffb889uLL) >> 0),
    (VUINT32) ((0xbe1cf1bbfbffb889uLL) >> 32)},
   {(VUINT32) ((0xc08625c0c4622090uLL) >> 0),
    (VUINT32) ((0xc08625c0c4622090uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0b8666c0124uLL) >> 0),
    (VUINT32) ((0xbe1cf0b8666c0124uLL) >> 32)},
   {(VUINT32) ((0xc08625c3a96d31e0uLL) >> 0),
    (VUINT32) ((0xc08625c3a96d31e0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0a8fcf47a86uLL) >> 0),
    (VUINT32) ((0xbe1cf0a8fcf47a86uLL) >> 32)},
   {(VUINT32) ((0xc08625c68d6c80f0uLL) >> 0),
    (VUINT32) ((0xc08625c68d6c80f0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef46e18cb092uLL) >> 0),
    (VUINT32) ((0xbe1cef46e18cb092uLL) >> 32)},
   {(VUINT32) ((0xc08625c97060cef0uLL) >> 0),
    (VUINT32) ((0xc08625c97060cef0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1458a350efbuLL) >> 0),
    (VUINT32) ((0xbe1cf1458a350efbuLL) >> 32)},
   {(VUINT32) ((0xc08625cc524adc58uLL) >> 0),
    (VUINT32) ((0xc08625cc524adc58uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeea1dadce12uLL) >> 0),
    (VUINT32) ((0xbe1ceeea1dadce12uLL) >> 32)},
   {(VUINT32) ((0xc08625cf332b68b0uLL) >> 0),
    (VUINT32) ((0xc08625cf332b68b0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0a1bfdc44c7uLL) >> 0),
    (VUINT32) ((0xbe1cf0a1bfdc44c7uLL) >> 32)},
   {(VUINT32) ((0xc08625d2130332d0uLL) >> 0),
    (VUINT32) ((0xc08625d2130332d0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef96d02da73euLL) >> 0),
    (VUINT32) ((0xbe1cef96d02da73euLL) >> 32)},
   {(VUINT32) ((0xc08625d4f1d2f8a8uLL) >> 0),
    (VUINT32) ((0xc08625d4f1d2f8a8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf2451c3c7701uLL) >> 0),
    (VUINT32) ((0xbe1cf2451c3c7701uLL) >> 32)},
   {(VUINT32) ((0xc08625d7cf9b7778uLL) >> 0),
    (VUINT32) ((0xc08625d7cf9b7778uLL) >> 32)},
   {(VUINT32) ((0xbe1cf10d08f83812uLL) >> 0),
    (VUINT32) ((0xbe1cf10d08f83812uLL) >> 32)},
   {(VUINT32) ((0xc08625daac5d6ba0uLL) >> 0),
    (VUINT32) ((0xc08625daac5d6ba0uLL) >> 32)},
   {(VUINT32) ((0xbe1ceec5b4895c5euLL) >> 0),
    (VUINT32) ((0xbe1ceec5b4895c5euLL) >> 32)},
   {(VUINT32) ((0xc08625dd881990b0uLL) >> 0),
    (VUINT32) ((0xc08625dd881990b0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf14e1325c5e4uLL) >> 0),
    (VUINT32) ((0xbe1cf14e1325c5e4uLL) >> 32)},
   {(VUINT32) ((0xc08625e062d0a188uLL) >> 0),
    (VUINT32) ((0xc08625e062d0a188uLL) >> 32)},
   {(VUINT32) ((0xbe1cf21d0904be12uLL) >> 0),
    (VUINT32) ((0xbe1cf21d0904be12uLL) >> 32)},
   {(VUINT32) ((0xc08625e33c835838uLL) >> 0),
    (VUINT32) ((0xc08625e33c835838uLL) >> 32)},
   {(VUINT32) ((0xbe1ceed0839bcf21uLL) >> 0),
    (VUINT32) ((0xbe1ceed0839bcf21uLL) >> 32)},
   {(VUINT32) ((0xc08625e615326df0uLL) >> 0),
    (VUINT32) ((0xc08625e615326df0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1bb944889d2uLL) >> 0),
    (VUINT32) ((0xbe1cf1bb944889d2uLL) >> 32)},
   {(VUINT32) ((0xc08625e8ecde9b48uLL) >> 0),
    (VUINT32) ((0xc08625e8ecde9b48uLL) >> 32)},
   {(VUINT32) ((0xbe1cee738e85eeceuLL) >> 0),
    (VUINT32) ((0xbe1cee738e85eeceuLL) >> 32)},
   {(VUINT32) ((0xc08625ebc38897e0uLL) >> 0),
    (VUINT32) ((0xc08625ebc38897e0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf25c2bc6ef12uLL) >> 0),
    (VUINT32) ((0xbe1cf25c2bc6ef12uLL) >> 32)},
   {(VUINT32) ((0xc08625ee99311ac8uLL) >> 0),
    (VUINT32) ((0xc08625ee99311ac8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf132b70a41aduLL) >> 0),
    (VUINT32) ((0xbe1cf132b70a41aduLL) >> 32)},
   {(VUINT32) ((0xc08625f16dd8da28uLL) >> 0),
    (VUINT32) ((0xc08625f16dd8da28uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1984236a6e3uLL) >> 0),
    (VUINT32) ((0xbe1cf1984236a6e3uLL) >> 32)},
   {(VUINT32) ((0xc08625f441808b78uLL) >> 0),
    (VUINT32) ((0xc08625f441808b78uLL) >> 32)},
   {(VUINT32) ((0xbe1cf19ae74998f9uLL) >> 0),
    (VUINT32) ((0xbe1cf19ae74998f9uLL) >> 32)},
   {(VUINT32) ((0xc08625f71428e370uLL) >> 0),
    (VUINT32) ((0xc08625f71428e370uLL) >> 32)},
   {(VUINT32) ((0xbe1cef3e175d61a1uLL) >> 0),
    (VUINT32) ((0xbe1cef3e175d61a1uLL) >> 32)},
   {(VUINT32) ((0xc08625f9e5d295f8uLL) >> 0),
    (VUINT32) ((0xc08625f9e5d295f8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf101f9868fd9uLL) >> 0),
    (VUINT32) ((0xbe1cf101f9868fd9uLL) >> 32)},
   {(VUINT32) ((0xc08625fcb67e5658uLL) >> 0),
    (VUINT32) ((0xc08625fcb67e5658uLL) >> 32)},
   {(VUINT32) ((0xbe1cee69db83dcd2uLL) >> 0),
    (VUINT32) ((0xbe1cee69db83dcd2uLL) >> 32)},
   {(VUINT32) ((0xc08625ff862cd6f8uLL) >> 0),
    (VUINT32) ((0xc08625ff862cd6f8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf081b636af51uLL) >> 0),
    (VUINT32) ((0xbe1cf081b636af51uLL) >> 32)},
   {(VUINT32) ((0xc086260254dec9a8uLL) >> 0),
    (VUINT32) ((0xc086260254dec9a8uLL) >> 32)},
   {(VUINT32) ((0xbe1cee62c7d59b3euLL) >> 0),
    (VUINT32) ((0xbe1cee62c7d59b3euLL) >> 32)},
   {(VUINT32) ((0xc08626052294df58uLL) >> 0),
    (VUINT32) ((0xc08626052294df58uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1b745c57716uLL) >> 0),
    (VUINT32) ((0xbe1cf1b745c57716uLL) >> 32)},
   {(VUINT32) ((0xc0862607ef4fc868uLL) >> 0),
    (VUINT32) ((0xc0862607ef4fc868uLL) >> 32)},
   {(VUINT32) ((0xbe1cef3d2800ea23uLL) >> 0),
    (VUINT32) ((0xbe1cef3d2800ea23uLL) >> 32)},
   {(VUINT32) ((0xc086260abb103458uLL) >> 0),
    (VUINT32) ((0xc086260abb103458uLL) >> 32)},
   {(VUINT32) ((0xbe1cef480ff1acd2uLL) >> 0),
    (VUINT32) ((0xbe1cef480ff1acd2uLL) >> 32)},
   {(VUINT32) ((0xc086260d85d6d200uLL) >> 0),
    (VUINT32) ((0xc086260d85d6d200uLL) >> 32)},
   {(VUINT32) ((0xbe1cf2424c9a17efuLL) >> 0),
    (VUINT32) ((0xbe1cf2424c9a17efuLL) >> 32)},
   {(VUINT32) ((0xc08626104fa44f90uLL) >> 0),
    (VUINT32) ((0xc08626104fa44f90uLL) >> 32)},
   {(VUINT32) ((0xbe1cf12cfde90fd5uLL) >> 0),
    (VUINT32) ((0xbe1cf12cfde90fd5uLL) >> 32)},
   {(VUINT32) ((0xc086261318795a68uLL) >> 0),
    (VUINT32) ((0xc086261318795a68uLL) >> 32)},
   {(VUINT32) ((0xbe1cf21f590dd5b6uLL) >> 0),
    (VUINT32) ((0xbe1cf21f590dd5b6uLL) >> 32)},
   {(VUINT32) ((0xc0862615e0569f48uLL) >> 0),
    (VUINT32) ((0xc0862615e0569f48uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0c50f9cd28auLL) >> 0),
    (VUINT32) ((0xbe1cf0c50f9cd28auLL) >> 32)},
   {(VUINT32) ((0xc0862618a73cca30uLL) >> 0),
    (VUINT32) ((0xc0862618a73cca30uLL) >> 32)},
   {(VUINT32) ((0xbe1ceedbdb520545uLL) >> 0),
    (VUINT32) ((0xbe1ceedbdb520545uLL) >> 32)},
   {(VUINT32) ((0xc086261b6d2c8668uLL) >> 0),
    (VUINT32) ((0xc086261b6d2c8668uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0b030396011uLL) >> 0),
    (VUINT32) ((0xbe1cf0b030396011uLL) >> 32)},
   {(VUINT32) ((0xc086261e32267e98uLL) >> 0),
    (VUINT32) ((0xc086261e32267e98uLL) >> 32)},
   {(VUINT32) ((0xbe1cf19917010e96uLL) >> 0),
    (VUINT32) ((0xbe1cf19917010e96uLL) >> 32)},
   {(VUINT32) ((0xc0862620f62b5cb0uLL) >> 0),
    (VUINT32) ((0xc0862620f62b5cb0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf07331355985uLL) >> 0),
    (VUINT32) ((0xbe1cf07331355985uLL) >> 32)},
   {(VUINT32) ((0xc0862623b93bc9e8uLL) >> 0),
    (VUINT32) ((0xc0862623b93bc9e8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf01ae921a1c3uLL) >> 0),
    (VUINT32) ((0xbe1cf01ae921a1c3uLL) >> 32)},
   {(VUINT32) ((0xc08626267b586ed0uLL) >> 0),
    (VUINT32) ((0xc08626267b586ed0uLL) >> 32)},
   {(VUINT32) ((0xbe1cefe5cf0dbf0cuLL) >> 0),
    (VUINT32) ((0xbe1cefe5cf0dbf0cuLL) >> 32)},
   {(VUINT32) ((0xc08626293c81f348uLL) >> 0),
    (VUINT32) ((0xc08626293c81f348uLL) >> 32)},
   {(VUINT32) ((0xbe1cf01b258aeb50uLL) >> 0),
    (VUINT32) ((0xbe1cf01b258aeb50uLL) >> 32)},
   {(VUINT32) ((0xc086262bfcb8fe88uLL) >> 0),
    (VUINT32) ((0xc086262bfcb8fe88uLL) >> 32)},
   {(VUINT32) ((0xbe1cee6b9e7f4c68uLL) >> 0),
    (VUINT32) ((0xbe1cee6b9e7f4c68uLL) >> 32)},
   {(VUINT32) ((0xc086262ebbfe3710uLL) >> 0),
    (VUINT32) ((0xc086262ebbfe3710uLL) >> 32)},
   {(VUINT32) ((0xbe1cee684a9b21c9uLL) >> 0),
    (VUINT32) ((0xbe1cee684a9b21c9uLL) >> 32)},
   {(VUINT32) ((0xc08626317a5242b8uLL) >> 0),
    (VUINT32) ((0xc08626317a5242b8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1f8bcde9a8buLL) >> 0),
    (VUINT32) ((0xbe1cf1f8bcde9a8buLL) >> 32)},
   {(VUINT32) ((0xc086263437b5c6c0uLL) >> 0),
    (VUINT32) ((0xc086263437b5c6c0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1d063d36238uLL) >> 0),
    (VUINT32) ((0xbe1cf1d063d36238uLL) >> 32)},
   {(VUINT32) ((0xc0862636f42967a8uLL) >> 0),
    (VUINT32) ((0xc0862636f42967a8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1e31a19075euLL) >> 0),
    (VUINT32) ((0xbe1cf1e31a19075euLL) >> 32)},
   {(VUINT32) ((0xc0862639afadc950uLL) >> 0),
    (VUINT32) ((0xc0862639afadc950uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1d8efdf7e7duLL) >> 0),
    (VUINT32) ((0xbe1cf1d8efdf7e7duLL) >> 32)},
   {(VUINT32) ((0xc086263c6a438ef0uLL) >> 0),
    (VUINT32) ((0xc086263c6a438ef0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1812ee72dbauLL) >> 0),
    (VUINT32) ((0xbe1cf1812ee72dbauLL) >> 32)},
   {(VUINT32) ((0xc086263f23eb5b18uLL) >> 0),
    (VUINT32) ((0xc086263f23eb5b18uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1449a9a2279uLL) >> 0),
    (VUINT32) ((0xbe1cf1449a9a2279uLL) >> 32)},
   {(VUINT32) ((0xc0862641dca5cfb8uLL) >> 0),
    (VUINT32) ((0xc0862641dca5cfb8uLL) >> 32)},
   {(VUINT32) ((0xbe1cee96edce5085uLL) >> 0),
    (VUINT32) ((0xbe1cee96edce5085uLL) >> 32)},
   {(VUINT32) ((0xc086264494738e08uLL) >> 0),
    (VUINT32) ((0xc086264494738e08uLL) >> 32)},
   {(VUINT32) ((0xbe1cf06797bd03b2uLL) >> 0),
    (VUINT32) ((0xbe1cf06797bd03b2uLL) >> 32)},
   {(VUINT32) ((0xc08626474b5536b8uLL) >> 0),
    (VUINT32) ((0xc08626474b5536b8uLL) >> 32)},
   {(VUINT32) ((0xbe1cef91b9b7ffc1uLL) >> 0),
    (VUINT32) ((0xbe1cef91b9b7ffc1uLL) >> 32)},
   {(VUINT32) ((0xc086264a014b69c0uLL) >> 0),
    (VUINT32) ((0xc086264a014b69c0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef4b6721278fuLL) >> 0),
    (VUINT32) ((0xbe1cef4b6721278fuLL) >> 32)},
   {(VUINT32) ((0xc086264cb656c678uLL) >> 0),
    (VUINT32) ((0xc086264cb656c678uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1942925eb4auLL) >> 0),
    (VUINT32) ((0xbe1cf1942925eb4auLL) >> 32)},
   {(VUINT32) ((0xc086264f6a77eba8uLL) >> 0),
    (VUINT32) ((0xc086264f6a77eba8uLL) >> 32)},
   {(VUINT32) ((0xbe1cefa2c7bc2e39uLL) >> 0),
    (VUINT32) ((0xbe1cefa2c7bc2e39uLL) >> 32)},
   {(VUINT32) ((0xc08626521daf7758uLL) >> 0),
    (VUINT32) ((0xc08626521daf7758uLL) >> 32)},
   {(VUINT32) ((0xbe1cf252595aceb3uLL) >> 0),
    (VUINT32) ((0xbe1cf252595aceb3uLL) >> 32)},
   {(VUINT32) ((0xc0862654cffe0718uLL) >> 0),
    (VUINT32) ((0xc0862654cffe0718uLL) >> 32)},
   {(VUINT32) ((0xbe1cee8e9ae47ec2uLL) >> 0),
    (VUINT32) ((0xbe1cee8e9ae47ec2uLL) >> 32)},
   {(VUINT32) ((0xc0862657816437a8uLL) >> 0),
    (VUINT32) ((0xc0862657816437a8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1bf913828fauLL) >> 0),
    (VUINT32) ((0xbe1cf1bf913828fauLL) >> 32)},
   {(VUINT32) ((0xc086265a31e2a558uLL) >> 0),
    (VUINT32) ((0xc086265a31e2a558uLL) >> 32)},
   {(VUINT32) ((0xbe1cf23475d6b366uLL) >> 0),
    (VUINT32) ((0xbe1cf23475d6b366uLL) >> 32)},
   {(VUINT32) ((0xc086265ce179ebc8uLL) >> 0),
    (VUINT32) ((0xc086265ce179ebc8uLL) >> 32)},
   {(VUINT32) ((0xbe1cef8df00a922buLL) >> 0),
    (VUINT32) ((0xbe1cef8df00a922buLL) >> 32)},
   {(VUINT32) ((0xc086265f902aa5f0uLL) >> 0),
    (VUINT32) ((0xc086265f902aa5f0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef279bfa43e0uLL) >> 0),
    (VUINT32) ((0xbe1cef279bfa43e0uLL) >> 32)},
   {(VUINT32) ((0xc08626623df56e38uLL) >> 0),
    (VUINT32) ((0xc08626623df56e38uLL) >> 32)},
   {(VUINT32) ((0xbe1cf080e10b8365uLL) >> 0),
    (VUINT32) ((0xbe1cf080e10b8365uLL) >> 32)},
   {(VUINT32) ((0xc0862664eadade70uLL) >> 0),
    (VUINT32) ((0xc0862664eadade70uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1a518f9b544uLL) >> 0),
    (VUINT32) ((0xbe1cf1a518f9b544uLL) >> 32)},
   {(VUINT32) ((0xc086266796db8fd0uLL) >> 0),
    (VUINT32) ((0xc086266796db8fd0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef9308fed9e9uLL) >> 0),
    (VUINT32) ((0xbe1cef9308fed9e9uLL) >> 32)},
   {(VUINT32) ((0xc086266a41f81ae8uLL) >> 0),
    (VUINT32) ((0xc086266a41f81ae8uLL) >> 32)},
   {(VUINT32) ((0xbe1ceea3ae6b19c9uLL) >> 0),
    (VUINT32) ((0xbe1ceea3ae6b19c9uLL) >> 32)},
   {(VUINT32) ((0xc086266cec3117b8uLL) >> 0),
    (VUINT32) ((0xc086266cec3117b8uLL) >> 32)},
   {(VUINT32) ((0xbe1ceef06003d4c2uLL) >> 0),
    (VUINT32) ((0xbe1ceef06003d4c2uLL) >> 32)},
   {(VUINT32) ((0xc086266f95871da8uLL) >> 0),
    (VUINT32) ((0xc086266f95871da8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0b8457ffb0cuLL) >> 0),
    (VUINT32) ((0xbe1cf0b8457ffb0cuLL) >> 32)},
   {(VUINT32) ((0xc08626723dfac390uLL) >> 0),
    (VUINT32) ((0xc08626723dfac390uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0c526745ad6uLL) >> 0),
    (VUINT32) ((0xbe1cf0c526745ad6uLL) >> 32)},
   {(VUINT32) ((0xc0862674e58c9fa8uLL) >> 0),
    (VUINT32) ((0xc0862674e58c9fa8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0cf91ff7b5duLL) >> 0),
    (VUINT32) ((0xbe1cf0cf91ff7b5duLL) >> 32)},
   {(VUINT32) ((0xc08626778c3d4798uLL) >> 0),
    (VUINT32) ((0xc08626778c3d4798uLL) >> 32)},
   {(VUINT32) ((0xbe1cefe260819380uLL) >> 0),
    (VUINT32) ((0xbe1cefe260819380uLL) >> 32)},
   {(VUINT32) ((0xc086267a320d5070uLL) >> 0),
    (VUINT32) ((0xc086267a320d5070uLL) >> 32)},
   {(VUINT32) ((0xbe1ceebd90aa27a3uLL) >> 0),
    (VUINT32) ((0xbe1ceebd90aa27a3uLL) >> 32)},
   {(VUINT32) ((0xc086267cd6fd4ea8uLL) >> 0),
    (VUINT32) ((0xc086267cd6fd4ea8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0388121dffauLL) >> 0),
    (VUINT32) ((0xbe1cf0388121dffauLL) >> 32)},
   {(VUINT32) ((0xc086267f7b0dd630uLL) >> 0),
    (VUINT32) ((0xc086267f7b0dd630uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1a3881435f1uLL) >> 0),
    (VUINT32) ((0xbe1cf1a3881435f1uLL) >> 32)},
   {(VUINT32) ((0xc08626821e3f7a68uLL) >> 0),
    (VUINT32) ((0xc08626821e3f7a68uLL) >> 32)},
   {(VUINT32) ((0xbe1cef28e9d9ac52uLL) >> 0),
    (VUINT32) ((0xbe1cef28e9d9ac52uLL) >> 32)},
   {(VUINT32) ((0xc0862684c092ce08uLL) >> 0),
    (VUINT32) ((0xc0862684c092ce08uLL) >> 32)},
   {(VUINT32) ((0xbe1cf02d300062dduLL) >> 0),
    (VUINT32) ((0xbe1cf02d300062dduLL) >> 32)},
   {(VUINT32) ((0xc086268762086350uLL) >> 0),
    (VUINT32) ((0xc086268762086350uLL) >> 32)},
   {(VUINT32) ((0xbe1cefaee1edfa35uLL) >> 0),
    (VUINT32) ((0xbe1cefaee1edfa35uLL) >> 32)},
   {(VUINT32) ((0xc086268a02a0cbe0uLL) >> 0),
    (VUINT32) ((0xc086268a02a0cbe0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0a5a052e936uLL) >> 0),
    (VUINT32) ((0xbe1cf0a5a052e936uLL) >> 32)},
   {(VUINT32) ((0xc086268ca25c98d8uLL) >> 0),
    (VUINT32) ((0xc086268ca25c98d8uLL) >> 32)},
   {(VUINT32) ((0xbe1cee60a4a497eduLL) >> 0),
    (VUINT32) ((0xbe1cee60a4a497eduLL) >> 32)},
   {(VUINT32) ((0xc086268f413c5ab0uLL) >> 0),
    (VUINT32) ((0xc086268f413c5ab0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0e4a5d0cf49uLL) >> 0),
    (VUINT32) ((0xbe1cf0e4a5d0cf49uLL) >> 32)},
   {(VUINT32) ((0xc0862691df40a170uLL) >> 0),
    (VUINT32) ((0xc0862691df40a170uLL) >> 32)},
   {(VUINT32) ((0xbe1cf149235a4e6euLL) >> 0),
    (VUINT32) ((0xbe1cf149235a4e6euLL) >> 32)},
   {(VUINT32) ((0xc08626947c69fc80uLL) >> 0),
    (VUINT32) ((0xc08626947c69fc80uLL) >> 32)},
   {(VUINT32) ((0xbe1cf215180b9fccuLL) >> 0),
    (VUINT32) ((0xbe1cf215180b9fccuLL) >> 32)},
   {(VUINT32) ((0xc086269718b8fac8uLL) >> 0),
    (VUINT32) ((0xc086269718b8fac8uLL) >> 32)},
   {(VUINT32) ((0xbe1cef9b156a9840uLL) >> 0),
    (VUINT32) ((0xbe1cef9b156a9840uLL) >> 32)},
   {(VUINT32) ((0xc0862699b42e2a90uLL) >> 0),
    (VUINT32) ((0xc0862699b42e2a90uLL) >> 32)},
   {(VUINT32) ((0xbe1cf054c91441beuLL) >> 0),
    (VUINT32) ((0xbe1cf054c91441beuLL) >> 32)},
   {(VUINT32) ((0xc086269c4eca19a8uLL) >> 0),
    (VUINT32) ((0xc086269c4eca19a8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf13ded26512cuLL) >> 0),
    (VUINT32) ((0xbe1cf13ded26512cuLL) >> 32)},
   {(VUINT32) ((0xc086269ee88d5550uLL) >> 0),
    (VUINT32) ((0xc086269ee88d5550uLL) >> 32)},
   {(VUINT32) ((0xbe1cf22ea4d8ac06uLL) >> 0),
    (VUINT32) ((0xbe1cf22ea4d8ac06uLL) >> 32)},
   {(VUINT32) ((0xc08626a181786a40uLL) >> 0),
    (VUINT32) ((0xc08626a181786a40uLL) >> 32)},
   {(VUINT32) ((0xbe1cf2354666ee2euLL) >> 0),
    (VUINT32) ((0xbe1cf2354666ee2euLL) >> 32)},
   {(VUINT32) ((0xc08626a4198be4a8uLL) >> 0),
    (VUINT32) ((0xc08626a4198be4a8uLL) >> 32)},
   {(VUINT32) ((0xbe1cefef936752b3uLL) >> 0),
    (VUINT32) ((0xbe1cefef936752b3uLL) >> 32)},
   {(VUINT32) ((0xc08626a6b0c85020uLL) >> 0),
    (VUINT32) ((0xc08626a6b0c85020uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1e360a9db68uLL) >> 0),
    (VUINT32) ((0xbe1cf1e360a9db68uLL) >> 32)},
   {(VUINT32) ((0xc08626a9472e37d8uLL) >> 0),
    (VUINT32) ((0xc08626a9472e37d8uLL) >> 32)},
   {(VUINT32) ((0xbe1ceed6aeb812c5uLL) >> 0),
    (VUINT32) ((0xbe1ceed6aeb812c5uLL) >> 32)},
   {(VUINT32) ((0xc08626abdcbe2650uLL) >> 0),
    (VUINT32) ((0xc08626abdcbe2650uLL) >> 32)},
   {(VUINT32) ((0xbe1cf227340b4986uLL) >> 0),
    (VUINT32) ((0xbe1cf227340b4986uLL) >> 32)},
   {(VUINT32) ((0xc08626ae7178a5b0uLL) >> 0),
    (VUINT32) ((0xc08626ae7178a5b0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0215a0cbe0duLL) >> 0),
    (VUINT32) ((0xbe1cf0215a0cbe0duLL) >> 32)},
   {(VUINT32) ((0xc08626b1055e3f70uLL) >> 0),
    (VUINT32) ((0xc08626b1055e3f70uLL) >> 32)},
   {(VUINT32) ((0xbe1cf256adf0ae26uLL) >> 0),
    (VUINT32) ((0xbe1cf256adf0ae26uLL) >> 32)},
   {(VUINT32) ((0xc08626b3986f7ca8uLL) >> 0),
    (VUINT32) ((0xc08626b3986f7ca8uLL) >> 32)},
   {(VUINT32) ((0xbe1ceff3c67aed06uLL) >> 0),
    (VUINT32) ((0xbe1ceff3c67aed06uLL) >> 32)},
   {(VUINT32) ((0xc08626b62aace5c8uLL) >> 0),
    (VUINT32) ((0xc08626b62aace5c8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf2159fb93652uLL) >> 0),
    (VUINT32) ((0xbe1cf2159fb93652uLL) >> 32)},
   {(VUINT32) ((0xc08626b8bc1702e0uLL) >> 0),
    (VUINT32) ((0xc08626b8bc1702e0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf01e6dbd1c7fuLL) >> 0),
    (VUINT32) ((0xbe1cf01e6dbd1c7fuLL) >> 32)},
   {(VUINT32) ((0xc08626bb4cae5b60uLL) >> 0),
    (VUINT32) ((0xc08626bb4cae5b60uLL) >> 32)},
   {(VUINT32) ((0xbe1cf009e75d1c0cuLL) >> 0),
    (VUINT32) ((0xbe1cf009e75d1c0cuLL) >> 32)},
   {(VUINT32) ((0xc08626bddc737648uLL) >> 0),
    (VUINT32) ((0xc08626bddc737648uLL) >> 32)},
   {(VUINT32) ((0xbe1ceec10a020e73uLL) >> 0),
    (VUINT32) ((0xbe1ceec10a020e73uLL) >> 32)},
   {(VUINT32) ((0xc08626c06b66da08uLL) >> 0),
    (VUINT32) ((0xc08626c06b66da08uLL) >> 32)},
   {(VUINT32) ((0xbe1cf06d5783eee7uLL) >> 0),
    (VUINT32) ((0xbe1cf06d5783eee7uLL) >> 32)},
   {(VUINT32) ((0xc08626c2f9890ca0uLL) >> 0),
    (VUINT32) ((0xc08626c2f9890ca0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0cb8f169ffeuLL) >> 0),
    (VUINT32) ((0xbe1cf0cb8f169ffeuLL) >> 32)},
   {(VUINT32) ((0xc08626c586da9388uLL) >> 0),
    (VUINT32) ((0xc08626c586da9388uLL) >> 32)},
   {(VUINT32) ((0xbe1cef7de2452430uLL) >> 0),
    (VUINT32) ((0xbe1cef7de2452430uLL) >> 32)},
   {(VUINT32) ((0xc08626c8135bf3b0uLL) >> 0),
    (VUINT32) ((0xc08626c8135bf3b0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf05da6f783aeuLL) >> 0),
    (VUINT32) ((0xbe1cf05da6f783aeuLL) >> 32)},
   {(VUINT32) ((0xc08626ca9f0db198uLL) >> 0),
    (VUINT32) ((0xc08626ca9f0db198uLL) >> 32)},
   {(VUINT32) ((0xbe1cefcc877d681duLL) >> 0),
    (VUINT32) ((0xbe1cefcc877d681duLL) >> 32)},
   {(VUINT32) ((0xc08626cd29f05138uLL) >> 0),
    (VUINT32) ((0xc08626cd29f05138uLL) >> 32)},
   {(VUINT32) ((0xbe1cef0531954ab3uLL) >> 0),
    (VUINT32) ((0xbe1cef0531954ab3uLL) >> 32)},
   {(VUINT32) ((0xc08626cfb4045608uLL) >> 0),
    (VUINT32) ((0xc08626cfb4045608uLL) >> 32)},
   {(VUINT32) ((0xbe1cf06b8565ea3duLL) >> 0),
    (VUINT32) ((0xbe1cf06b8565ea3duLL) >> 32)},
   {(VUINT32) ((0xc08626d23d4a4310uLL) >> 0),
    (VUINT32) ((0xc08626d23d4a4310uLL) >> 32)},
   {(VUINT32) ((0xbe1cefdc455d9d7euLL) >> 0),
    (VUINT32) ((0xbe1cefdc455d9d7euLL) >> 32)},
   {(VUINT32) ((0xc08626d4c5c29ad0uLL) >> 0),
    (VUINT32) ((0xc08626d4c5c29ad0uLL) >> 32)},
   {(VUINT32) ((0xbe1ceefc47e8fa64uLL) >> 0),
    (VUINT32) ((0xbe1ceefc47e8fa64uLL) >> 32)},
   {(VUINT32) ((0xc08626d74d6ddf48uLL) >> 0),
    (VUINT32) ((0xc08626d74d6ddf48uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1872bf033f2uLL) >> 0),
    (VUINT32) ((0xbe1cf1872bf033f2uLL) >> 32)},
   {(VUINT32) ((0xc08626d9d44c9210uLL) >> 0),
    (VUINT32) ((0xc08626d9d44c9210uLL) >> 32)},
   {(VUINT32) ((0xbe1cf19d91087f9duLL) >> 0),
    (VUINT32) ((0xbe1cf19d91087f9duLL) >> 32)},
   {(VUINT32) ((0xc08626dc5a5f3438uLL) >> 0),
    (VUINT32) ((0xc08626dc5a5f3438uLL) >> 32)},
   {(VUINT32) ((0xbe1cf012d444c6abuLL) >> 0),
    (VUINT32) ((0xbe1cf012d444c6abuLL) >> 32)},
   {(VUINT32) ((0xc08626dedfa64650uLL) >> 0),
    (VUINT32) ((0xc08626dedfa64650uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0ba528ee153uLL) >> 0),
    (VUINT32) ((0xbe1cf0ba528ee153uLL) >> 32)},
   {(VUINT32) ((0xc08626e164224880uLL) >> 0),
    (VUINT32) ((0xc08626e164224880uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeb431709788uLL) >> 0),
    (VUINT32) ((0xbe1ceeb431709788uLL) >> 32)},
   {(VUINT32) ((0xc08626e3e7d3ba60uLL) >> 0),
    (VUINT32) ((0xc08626e3e7d3ba60uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0b9af31a6a5uLL) >> 0),
    (VUINT32) ((0xbe1cf0b9af31a6a5uLL) >> 32)},
   {(VUINT32) ((0xc08626e66abb1b28uLL) >> 0),
    (VUINT32) ((0xc08626e66abb1b28uLL) >> 32)},
   {(VUINT32) ((0xbe1cf168fb2e135buLL) >> 0),
    (VUINT32) ((0xbe1cf168fb2e135buLL) >> 32)},
   {(VUINT32) ((0xc08626e8ecd8e990uLL) >> 0),
    (VUINT32) ((0xc08626e8ecd8e990uLL) >> 32)},
   {(VUINT32) ((0xbe1cef9097461c93uLL) >> 0),
    (VUINT32) ((0xbe1cef9097461c93uLL) >> 32)},
   {(VUINT32) ((0xc08626eb6e2da3d0uLL) >> 0),
    (VUINT32) ((0xc08626eb6e2da3d0uLL) >> 32)},
   {(VUINT32) ((0xbe1cee7a434735d8uLL) >> 0),
    (VUINT32) ((0xbe1cee7a434735d8uLL) >> 32)},
   {(VUINT32) ((0xc08626edeeb9c7a8uLL) >> 0),
    (VUINT32) ((0xc08626edeeb9c7a8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf235732b86f2uLL) >> 0),
    (VUINT32) ((0xbe1cf235732b86f2uLL) >> 32)},
   {(VUINT32) ((0xc08626f06e7dd280uLL) >> 0),
    (VUINT32) ((0xc08626f06e7dd280uLL) >> 32)},
   {(VUINT32) ((0xbe1cefe1510b89e6uLL) >> 0),
    (VUINT32) ((0xbe1cefe1510b89e6uLL) >> 32)},
   {(VUINT32) ((0xc08626f2ed7a4120uLL) >> 0),
    (VUINT32) ((0xc08626f2ed7a4120uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1f64b9b80efuLL) >> 0),
    (VUINT32) ((0xbe1cf1f64b9b80efuLL) >> 32)},
   {(VUINT32) ((0xc08626f56baf9000uLL) >> 0),
    (VUINT32) ((0xc08626f56baf9000uLL) >> 32)},
   {(VUINT32) ((0xbe1cf08f320ca339uLL) >> 0),
    (VUINT32) ((0xbe1cf08f320ca339uLL) >> 32)},
   {(VUINT32) ((0xc08626f7e91e3b08uLL) >> 0),
    (VUINT32) ((0xc08626f7e91e3b08uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1b1de2808a1uLL) >> 0),
    (VUINT32) ((0xbe1cf1b1de2808a1uLL) >> 32)},
   {(VUINT32) ((0xc08626fa65c6bdc0uLL) >> 0),
    (VUINT32) ((0xc08626fa65c6bdc0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1976d778b28uLL) >> 0),
    (VUINT32) ((0xbe1cf1976d778b28uLL) >> 32)},
   {(VUINT32) ((0xc08626fce1a99338uLL) >> 0),
    (VUINT32) ((0xc08626fce1a99338uLL) >> 32)},
   {(VUINT32) ((0xbe1ceef40a4f076fuLL) >> 0),
    (VUINT32) ((0xbe1ceef40a4f076fuLL) >> 32)},
   {(VUINT32) ((0xc08626ff5cc73600uLL) >> 0),
    (VUINT32) ((0xc08626ff5cc73600uLL) >> 32)},
   {(VUINT32) ((0xbe1cef3e45869ce3uLL) >> 0),
    (VUINT32) ((0xbe1cef3e45869ce3uLL) >> 32)},
   {(VUINT32) ((0xc0862701d7202048uLL) >> 0),
    (VUINT32) ((0xc0862701d7202048uLL) >> 32)},
   {(VUINT32) ((0xbe1ceef601b4c9d6uLL) >> 0),
    (VUINT32) ((0xbe1ceef601b4c9d6uLL) >> 32)},
   {(VUINT32) ((0xc086270450b4cbc0uLL) >> 0),
    (VUINT32) ((0xc086270450b4cbc0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1eaf0b57fd6uLL) >> 0),
    (VUINT32) ((0xbe1cf1eaf0b57fd6uLL) >> 32)},
   {(VUINT32) ((0xc0862706c985b1c0uLL) >> 0),
    (VUINT32) ((0xc0862706c985b1c0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef82a44990f3uLL) >> 0),
    (VUINT32) ((0xbe1cef82a44990f3uLL) >> 32)},
   {(VUINT32) ((0xc086270941934b10uLL) >> 0),
    (VUINT32) ((0xc086270941934b10uLL) >> 32)},
   {(VUINT32) ((0xbe1ceefe32981f2cuLL) >> 0),
    (VUINT32) ((0xbe1ceefe32981f2cuLL) >> 32)},
   {(VUINT32) ((0xc086270bb8de1018uLL) >> 0),
    (VUINT32) ((0xc086270bb8de1018uLL) >> 32)},
   {(VUINT32) ((0xbe1cefbf6f5a0445uLL) >> 0),
    (VUINT32) ((0xbe1cefbf6f5a0445uLL) >> 32)},
   {(VUINT32) ((0xc086270e2f6678d0uLL) >> 0),
    (VUINT32) ((0xc086270e2f6678d0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf18dba75792cuLL) >> 0),
    (VUINT32) ((0xbe1cf18dba75792cuLL) >> 32)},
   {(VUINT32) ((0xc0862710a52cfcc8uLL) >> 0),
    (VUINT32) ((0xc0862710a52cfcc8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0da64ce995fuLL) >> 0),
    (VUINT32) ((0xbe1cf0da64ce995fuLL) >> 32)},
   {(VUINT32) ((0xc08627131a321318uLL) >> 0),
    (VUINT32) ((0xc08627131a321318uLL) >> 32)},
   {(VUINT32) ((0xbe1cef04ac0fb802uLL) >> 0),
    (VUINT32) ((0xbe1cef04ac0fb802uLL) >> 32)},
   {(VUINT32) ((0xc08627158e763268uLL) >> 0),
    (VUINT32) ((0xc08627158e763268uLL) >> 32)},
   {(VUINT32) ((0xbe1cee9d4e2ad9bduLL) >> 0),
    (VUINT32) ((0xbe1cee9d4e2ad9bduLL) >> 32)},
   {(VUINT32) ((0xc086271801f9d0f8uLL) >> 0),
    (VUINT32) ((0xc086271801f9d0f8uLL) >> 32)},
   {(VUINT32) ((0xbe1cefa9b55407b5uLL) >> 0),
    (VUINT32) ((0xbe1cefa9b55407b5uLL) >> 32)},
   {(VUINT32) ((0xc086271a74bd64a0uLL) >> 0),
    (VUINT32) ((0xc086271a74bd64a0uLL) >> 32)},
   {(VUINT32) ((0xbe1cefe6bd329570uLL) >> 0),
    (VUINT32) ((0xbe1cefe6bd329570uLL) >> 32)},
   {(VUINT32) ((0xc086271ce6c162c8uLL) >> 0),
    (VUINT32) ((0xc086271ce6c162c8uLL) >> 32)},
   {(VUINT32) ((0xbe1cef0b1205dc85uLL) >> 0),
    (VUINT32) ((0xbe1cef0b1205dc85uLL) >> 32)},
   {(VUINT32) ((0xc086271f58064068uLL) >> 0),
    (VUINT32) ((0xc086271f58064068uLL) >> 32)},
   {(VUINT32) ((0xbe1cef092a785e3fuLL) >> 0),
    (VUINT32) ((0xbe1cef092a785e3fuLL) >> 32)},
   {(VUINT32) ((0xc0862721c88c7210uLL) >> 0),
    (VUINT32) ((0xc0862721c88c7210uLL) >> 32)},
   {(VUINT32) ((0xbe1cf050dcdaac30uLL) >> 0),
    (VUINT32) ((0xbe1cf050dcdaac30uLL) >> 32)},
   {(VUINT32) ((0xc086272438546be8uLL) >> 0),
    (VUINT32) ((0xc086272438546be8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf210907ded8buLL) >> 0),
    (VUINT32) ((0xbe1cf210907ded8buLL) >> 32)},
   {(VUINT32) ((0xc0862726a75ea1b8uLL) >> 0),
    (VUINT32) ((0xc0862726a75ea1b8uLL) >> 32)},
   {(VUINT32) ((0xbe1cee760be44f99uLL) >> 0),
    (VUINT32) ((0xbe1cee760be44f99uLL) >> 32)},
   {(VUINT32) ((0xc086272915ab86c0uLL) >> 0),
    (VUINT32) ((0xc086272915ab86c0uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeeee07c2bccuLL) >> 0),
    (VUINT32) ((0xbe1ceeeee07c2bccuLL) >> 32)},
   {(VUINT32) ((0xc086272b833b8df0uLL) >> 0),
    (VUINT32) ((0xc086272b833b8df0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf06874992df5uLL) >> 0),
    (VUINT32) ((0xbe1cf06874992df5uLL) >> 32)},
   {(VUINT32) ((0xc086272df00f29d0uLL) >> 0),
    (VUINT32) ((0xc086272df00f29d0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef8fac5d4899uLL) >> 0),
    (VUINT32) ((0xbe1cef8fac5d4899uLL) >> 32)},
   {(VUINT32) ((0xc08627305c26cc70uLL) >> 0),
    (VUINT32) ((0xc08627305c26cc70uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1103241cc99uLL) >> 0),
    (VUINT32) ((0xbe1cf1103241cc99uLL) >> 32)},
   {(VUINT32) ((0xc0862732c782e788uLL) >> 0),
    (VUINT32) ((0xc0862732c782e788uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1d35fef83feuLL) >> 0),
    (VUINT32) ((0xbe1cf1d35fef83feuLL) >> 32)},
   {(VUINT32) ((0xc08627353223ec68uLL) >> 0),
    (VUINT32) ((0xc08627353223ec68uLL) >> 32)},
   {(VUINT32) ((0xbe1cef3ec8133e1duLL) >> 0),
    (VUINT32) ((0xbe1cef3ec8133e1duLL) >> 32)},
   {(VUINT32) ((0xc08627379c0a4be8uLL) >> 0),
    (VUINT32) ((0xc08627379c0a4be8uLL) >> 32)},
   {(VUINT32) ((0xbe1cef7261daccd8uLL) >> 0),
    (VUINT32) ((0xbe1cef7261daccd8uLL) >> 32)},
   {(VUINT32) ((0xc086273a05367688uLL) >> 0),
    (VUINT32) ((0xc086273a05367688uLL) >> 32)},
   {(VUINT32) ((0xbe1cf18656c50806uLL) >> 0),
    (VUINT32) ((0xbe1cf18656c50806uLL) >> 32)},
   {(VUINT32) ((0xc086273c6da8dc68uLL) >> 0),
    (VUINT32) ((0xc086273c6da8dc68uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1c8736e049auLL) >> 0),
    (VUINT32) ((0xbe1cf1c8736e049auLL) >> 32)},
   {(VUINT32) ((0xc086273ed561ed38uLL) >> 0),
    (VUINT32) ((0xc086273ed561ed38uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1f93bff4911uLL) >> 0),
    (VUINT32) ((0xbe1cf1f93bff4911uLL) >> 32)},
   {(VUINT32) ((0xc08627413c621848uLL) >> 0),
    (VUINT32) ((0xc08627413c621848uLL) >> 32)},
   {(VUINT32) ((0xbe1cf188a4ea680cuLL) >> 0),
    (VUINT32) ((0xbe1cf188a4ea680cuLL) >> 32)},
   {(VUINT32) ((0xc0862743a2a9cc80uLL) >> 0),
    (VUINT32) ((0xc0862743a2a9cc80uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1d270930c80uLL) >> 0),
    (VUINT32) ((0xbe1cf1d270930c80uLL) >> 32)},
   {(VUINT32) ((0xc086274608397868uLL) >> 0),
    (VUINT32) ((0xc086274608397868uLL) >> 32)},
   {(VUINT32) ((0xbe1cf25a328c28e2uLL) >> 0),
    (VUINT32) ((0xbe1cf25a328c28e2uLL) >> 32)},
   {(VUINT32) ((0xc08627486d118a28uLL) >> 0),
    (VUINT32) ((0xc08627486d118a28uLL) >> 32)},
   {(VUINT32) ((0xbe1cf106f90aa3b8uLL) >> 0),
    (VUINT32) ((0xbe1cf106f90aa3b8uLL) >> 32)},
   {(VUINT32) ((0xc086274ad1326f80uLL) >> 0),
    (VUINT32) ((0xc086274ad1326f80uLL) >> 32)},
   {(VUINT32) ((0xbe1cee5e9d2e885auLL) >> 0),
    (VUINT32) ((0xbe1cee5e9d2e885auLL) >> 32)},
   {(VUINT32) ((0xc086274d349c95c0uLL) >> 0),
    (VUINT32) ((0xc086274d349c95c0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1c0bac27228uLL) >> 0),
    (VUINT32) ((0xbe1cf1c0bac27228uLL) >> 32)},
   {(VUINT32) ((0xc086274f975069f8uLL) >> 0),
    (VUINT32) ((0xc086274f975069f8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1a1500f9b1cuLL) >> 0),
    (VUINT32) ((0xbe1cf1a1500f9b1cuLL) >> 32)},
   {(VUINT32) ((0xc0862751f94e58c0uLL) >> 0),
    (VUINT32) ((0xc0862751f94e58c0uLL) >> 32)},
   {(VUINT32) ((0xbe1cefc30663ac44uLL) >> 0),
    (VUINT32) ((0xbe1cefc30663ac44uLL) >> 32)},
   {(VUINT32) ((0xc08627545a96ce48uLL) >> 0),
    (VUINT32) ((0xc08627545a96ce48uLL) >> 32)},
   {(VUINT32) ((0xbe1cf17123e427a2uLL) >> 0),
    (VUINT32) ((0xbe1cf17123e427a2uLL) >> 32)},
   {(VUINT32) ((0xc0862756bb2a3678uLL) >> 0),
    (VUINT32) ((0xc0862756bb2a3678uLL) >> 32)},
   {(VUINT32) ((0xbe1cefb92749fea4uLL) >> 0),
    (VUINT32) ((0xbe1cefb92749fea4uLL) >> 32)},
   {(VUINT32) ((0xc08627591b08fcc0uLL) >> 0),
    (VUINT32) ((0xc08627591b08fcc0uLL) >> 32)},
   {(VUINT32) ((0xbe1cefa40e1ea74auLL) >> 0),
    (VUINT32) ((0xbe1cefa40e1ea74auLL) >> 32)},
   {(VUINT32) ((0xc086275b7a338c40uLL) >> 0),
    (VUINT32) ((0xc086275b7a338c40uLL) >> 32)},
   {(VUINT32) ((0xbe1cee6f4612c3e9uLL) >> 0),
    (VUINT32) ((0xbe1cee6f4612c3e9uLL) >> 32)},
   {(VUINT32) ((0xc086275dd8aa4fa8uLL) >> 0),
    (VUINT32) ((0xc086275dd8aa4fa8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1c54a053627uLL) >> 0),
    (VUINT32) ((0xbe1cf1c54a053627uLL) >> 32)},
   {(VUINT32) ((0xc0862760366db168uLL) >> 0),
    (VUINT32) ((0xc0862760366db168uLL) >> 32)},
   {(VUINT32) ((0xbe1ceff5eb503d9euLL) >> 0),
    (VUINT32) ((0xbe1ceff5eb503d9euLL) >> 32)},
   {(VUINT32) ((0xc0862762937e1b70uLL) >> 0),
    (VUINT32) ((0xc0862762937e1b70uLL) >> 32)},
   {(VUINT32) ((0xbe1cf02e47f10ceeuLL) >> 0),
    (VUINT32) ((0xbe1cf02e47f10ceeuLL) >> 32)},
   {(VUINT32) ((0xc0862764efdbf768uLL) >> 0),
    (VUINT32) ((0xc0862764efdbf768uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeb06e1d0daduLL) >> 0),
    (VUINT32) ((0xbe1ceeb06e1d0daduLL) >> 32)},
   {(VUINT32) ((0xc08627674b87ae88uLL) >> 0),
    (VUINT32) ((0xc08627674b87ae88uLL) >> 32)},
   {(VUINT32) ((0xbe1cf10aadd6dba5uLL) >> 0),
    (VUINT32) ((0xbe1cf10aadd6dba5uLL) >> 32)},
   {(VUINT32) ((0xc0862769a681a9c0uLL) >> 0),
    (VUINT32) ((0xc0862769a681a9c0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf24e9913d30fuLL) >> 0),
    (VUINT32) ((0xbe1cf24e9913d30fuLL) >> 32)},
   {(VUINT32) ((0xc086276c00ca51a0uLL) >> 0),
    (VUINT32) ((0xc086276c00ca51a0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef47b301e312uLL) >> 0),
    (VUINT32) ((0xbe1cef47b301e312uLL) >> 32)},
   {(VUINT32) ((0xc086276e5a620e48uLL) >> 0),
    (VUINT32) ((0xc086276e5a620e48uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeb1cefc2e85uLL) >> 0),
    (VUINT32) ((0xbe1ceeb1cefc2e85uLL) >> 32)},
   {(VUINT32) ((0xc0862770b3494788uLL) >> 0),
    (VUINT32) ((0xc0862770b3494788uLL) >> 32)},
   {(VUINT32) ((0xbe1cf16f1fbbe011uLL) >> 0),
    (VUINT32) ((0xbe1cf16f1fbbe011uLL) >> 32)},
   {(VUINT32) ((0xc08627730b8064e8uLL) >> 0),
    (VUINT32) ((0xc08627730b8064e8uLL) >> 32)},
   {(VUINT32) ((0xbe1ceebdf75174c7uLL) >> 0),
    (VUINT32) ((0xbe1ceebdf75174c7uLL) >> 32)},
   {(VUINT32) ((0xc08627756307cd70uLL) >> 0),
    (VUINT32) ((0xc08627756307cd70uLL) >> 32)},
   {(VUINT32) ((0xbe1cf06e3871a0dauLL) >> 0),
    (VUINT32) ((0xbe1cf06e3871a0dauLL) >> 32)},
   {(VUINT32) ((0xc0862777b9dfe7f0uLL) >> 0),
    (VUINT32) ((0xc0862777b9dfe7f0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef16799fd554uLL) >> 0),
    (VUINT32) ((0xbe1cef16799fd554uLL) >> 32)},
   {(VUINT32) ((0xc086277a10091ac0uLL) >> 0),
    (VUINT32) ((0xc086277a10091ac0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf248dabf5377uLL) >> 0),
    (VUINT32) ((0xbe1cf248dabf5377uLL) >> 32)},
   {(VUINT32) ((0xc086277c6583cc00uLL) >> 0),
    (VUINT32) ((0xc086277c6583cc00uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0c78d92a2cduLL) >> 0),
    (VUINT32) ((0xbe1cf0c78d92a2cduLL) >> 32)},
   {(VUINT32) ((0xc086277eba506158uLL) >> 0),
    (VUINT32) ((0xc086277eba506158uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0b911b029f0uLL) >> 0),
    (VUINT32) ((0xbe1cf0b911b029f0uLL) >> 32)},
   {(VUINT32) ((0xc08627810e6f4028uLL) >> 0),
    (VUINT32) ((0xc08627810e6f4028uLL) >> 32)},
   {(VUINT32) ((0xbe1cefdc24719766uLL) >> 0),
    (VUINT32) ((0xbe1cefdc24719766uLL) >> 32)},
   {(VUINT32) ((0xc086278361e0cd70uLL) >> 0),
    (VUINT32) ((0xc086278361e0cd70uLL) >> 32)},
   {(VUINT32) ((0xbe1cefbb6562b7e7uLL) >> 0),
    (VUINT32) ((0xbe1cefbb6562b7e7uLL) >> 32)},
   {(VUINT32) ((0xc0862785b4a56dd8uLL) >> 0),
    (VUINT32) ((0xc0862785b4a56dd8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1e0afb349ecuLL) >> 0),
    (VUINT32) ((0xbe1cf1e0afb349ecuLL) >> 32)},
   {(VUINT32) ((0xc086278806bd85c0uLL) >> 0),
    (VUINT32) ((0xc086278806bd85c0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf008292e52fcuLL) >> 0),
    (VUINT32) ((0xbe1cf008292e52fcuLL) >> 32)},
   {(VUINT32) ((0xc086278a58297918uLL) >> 0),
    (VUINT32) ((0xc086278a58297918uLL) >> 32)},
   {(VUINT32) ((0xbe1cf053073872bfuLL) >> 0),
    (VUINT32) ((0xbe1cf053073872bfuLL) >> 32)},
   {(VUINT32) ((0xc086278ca8e9ab88uLL) >> 0),
    (VUINT32) ((0xc086278ca8e9ab88uLL) >> 32)},
   {(VUINT32) ((0xbe1cf17a0a55a947uLL) >> 0),
    (VUINT32) ((0xbe1cf17a0a55a947uLL) >> 32)},
   {(VUINT32) ((0xc086278ef8fe8068uLL) >> 0),
    (VUINT32) ((0xc086278ef8fe8068uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeffb0b60234uLL) >> 0),
    (VUINT32) ((0xbe1ceeffb0b60234uLL) >> 32)},
   {(VUINT32) ((0xc086279148685aa0uLL) >> 0),
    (VUINT32) ((0xc086279148685aa0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf162204794a8uLL) >> 0),
    (VUINT32) ((0xbe1cf162204794a8uLL) >> 32)},
   {(VUINT32) ((0xc086279397279ce0uLL) >> 0),
    (VUINT32) ((0xc086279397279ce0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf24cc8cb48acuLL) >> 0),
    (VUINT32) ((0xbe1cf24cc8cb48acuLL) >> 32)},
   {(VUINT32) ((0xc0862795e53ca978uLL) >> 0),
    (VUINT32) ((0xc0862795e53ca978uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0c9be68d5c3uLL) >> 0),
    (VUINT32) ((0xbe1cf0c9be68d5c3uLL) >> 32)},
   {(VUINT32) ((0xc086279832a7e258uLL) >> 0),
    (VUINT32) ((0xc086279832a7e258uLL) >> 32)},
   {(VUINT32) ((0xbe1cf172cd3d7388uLL) >> 0),
    (VUINT32) ((0xbe1cf172cd3d7388uLL) >> 32)},
   {(VUINT32) ((0xc086279a7f69a930uLL) >> 0),
    (VUINT32) ((0xc086279a7f69a930uLL) >> 32)},
   {(VUINT32) ((0xbe1ceea2465fbce5uLL) >> 0),
    (VUINT32) ((0xbe1ceea2465fbce5uLL) >> 32)},
   {(VUINT32) ((0xc086279ccb825f40uLL) >> 0),
    (VUINT32) ((0xc086279ccb825f40uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0a386d2500fuLL) >> 0),
    (VUINT32) ((0xbe1cf0a386d2500fuLL) >> 32)},
   {(VUINT32) ((0xc086279f16f26590uLL) >> 0),
    (VUINT32) ((0xc086279f16f26590uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1e338ddc18auLL) >> 0),
    (VUINT32) ((0xbe1cf1e338ddc18auLL) >> 32)},
   {(VUINT32) ((0xc08627a161ba1cd0uLL) >> 0),
    (VUINT32) ((0xc08627a161ba1cd0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef1f5049867fuLL) >> 0),
    (VUINT32) ((0xbe1cef1f5049867fuLL) >> 32)},
   {(VUINT32) ((0xc08627a3abd9e548uLL) >> 0),
    (VUINT32) ((0xc08627a3abd9e548uLL) >> 32)},
   {(VUINT32) ((0xbe1cef96c1ea8b1fuLL) >> 0),
    (VUINT32) ((0xbe1cef96c1ea8b1fuLL) >> 32)},
   {(VUINT32) ((0xc08627a5f5521f00uLL) >> 0),
    (VUINT32) ((0xc08627a5f5521f00uLL) >> 32)},
   {(VUINT32) ((0xbe1cf138f6fd3c26uLL) >> 0),
    (VUINT32) ((0xbe1cf138f6fd3c26uLL) >> 32)},
   {(VUINT32) ((0xc08627a83e2329b0uLL) >> 0),
    (VUINT32) ((0xc08627a83e2329b0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0d4fcbfdf3auLL) >> 0),
    (VUINT32) ((0xbe1cf0d4fcbfdf3auLL) >> 32)},
   {(VUINT32) ((0xc08627aa864d64b0uLL) >> 0),
    (VUINT32) ((0xc08627aa864d64b0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf24870c12c81uLL) >> 0),
    (VUINT32) ((0xbe1cf24870c12c81uLL) >> 32)},
   {(VUINT32) ((0xc08627accdd12f18uLL) >> 0),
    (VUINT32) ((0xc08627accdd12f18uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0ae2a56348duLL) >> 0),
    (VUINT32) ((0xbe1cf0ae2a56348duLL) >> 32)},
   {(VUINT32) ((0xc08627af14aee7a0uLL) >> 0),
    (VUINT32) ((0xc08627af14aee7a0uLL) >> 32)},
   {(VUINT32) ((0xbe1cee8ca1a9b893uLL) >> 0),
    (VUINT32) ((0xbe1cee8ca1a9b893uLL) >> 32)},
   {(VUINT32) ((0xc08627b15ae6eca8uLL) >> 0),
    (VUINT32) ((0xc08627b15ae6eca8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf20414d637b0uLL) >> 0),
    (VUINT32) ((0xbe1cf20414d637b0uLL) >> 32)},
   {(VUINT32) ((0xc08627b3a0799c60uLL) >> 0),
    (VUINT32) ((0xc08627b3a0799c60uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0fc6b7b12d8uLL) >> 0),
    (VUINT32) ((0xbe1cf0fc6b7b12d8uLL) >> 32)},
   {(VUINT32) ((0xc08627b5e5675488uLL) >> 0),
    (VUINT32) ((0xc08627b5e5675488uLL) >> 32)},
   {(VUINT32) ((0xbe1cf152d93c4a00uLL) >> 0),
    (VUINT32) ((0xbe1cf152d93c4a00uLL) >> 32)},
   {(VUINT32) ((0xc08627b829b072a0uLL) >> 0),
    (VUINT32) ((0xc08627b829b072a0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1073f9b77c2uLL) >> 0),
    (VUINT32) ((0xbe1cf1073f9b77c2uLL) >> 32)},
   {(VUINT32) ((0xc08627ba6d5553d8uLL) >> 0),
    (VUINT32) ((0xc08627ba6d5553d8uLL) >> 32)},
   {(VUINT32) ((0xbe1cee694f97d5a4uLL) >> 0),
    (VUINT32) ((0xbe1cee694f97d5a4uLL) >> 32)},
   {(VUINT32) ((0xc08627bcb0565500uLL) >> 0),
    (VUINT32) ((0xc08627bcb0565500uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0456b8239d7uLL) >> 0),
    (VUINT32) ((0xbe1cf0456b8239d7uLL) >> 32)},
   {(VUINT32) ((0xc08627bef2b3d2b0uLL) >> 0),
    (VUINT32) ((0xc08627bef2b3d2b0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf211497127e3uLL) >> 0),
    (VUINT32) ((0xbe1cf211497127e3uLL) >> 32)},
   {(VUINT32) ((0xc08627c1346e2930uLL) >> 0),
    (VUINT32) ((0xc08627c1346e2930uLL) >> 32)},
   {(VUINT32) ((0xbe1cf01856c0384duLL) >> 0),
    (VUINT32) ((0xbe1cf01856c0384duLL) >> 32)},
   {(VUINT32) ((0xc08627c37585b468uLL) >> 0),
    (VUINT32) ((0xc08627c37585b468uLL) >> 32)},
   {(VUINT32) ((0xbe1cefa7dd05479euLL) >> 0),
    (VUINT32) ((0xbe1cefa7dd05479euLL) >> 32)},
   {(VUINT32) ((0xc08627c5b5fad000uLL) >> 0),
    (VUINT32) ((0xc08627c5b5fad000uLL) >> 32)},
   {(VUINT32) ((0xbe1cef3ae8e50b93uLL) >> 0),
    (VUINT32) ((0xbe1cef3ae8e50b93uLL) >> 32)},
   {(VUINT32) ((0xc08627c7f5cdd750uLL) >> 0),
    (VUINT32) ((0xc08627c7f5cdd750uLL) >> 32)},
   {(VUINT32) ((0xbe1ceea5f32fdd3auLL) >> 0),
    (VUINT32) ((0xbe1ceea5f32fdd3auLL) >> 32)},
   {(VUINT32) ((0xc08627ca34ff2560uLL) >> 0),
    (VUINT32) ((0xc08627ca34ff2560uLL) >> 32)},
   {(VUINT32) ((0xbe1cef424caeb8d9uLL) >> 0),
    (VUINT32) ((0xbe1cef424caeb8d9uLL) >> 32)},
   {(VUINT32) ((0xc08627cc738f14f0uLL) >> 0),
    (VUINT32) ((0xc08627cc738f14f0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0194d07a81fuLL) >> 0),
    (VUINT32) ((0xbe1cf0194d07a81fuLL) >> 32)},
   {(VUINT32) ((0xc08627ceb17e0070uLL) >> 0),
    (VUINT32) ((0xc08627ceb17e0070uLL) >> 32)},
   {(VUINT32) ((0xbe1cf20f452000c1uLL) >> 0),
    (VUINT32) ((0xbe1cf20f452000c1uLL) >> 32)},
   {(VUINT32) ((0xc08627d0eecc4210uLL) >> 0),
    (VUINT32) ((0xc08627d0eecc4210uLL) >> 32)},
   {(VUINT32) ((0xbe1cf00e356218e4uLL) >> 0),
    (VUINT32) ((0xbe1cf00e356218e4uLL) >> 32)},
   {(VUINT32) ((0xc08627d32b7a33a0uLL) >> 0),
    (VUINT32) ((0xc08627d32b7a33a0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef30484b4bcbuLL) >> 0),
    (VUINT32) ((0xbe1cef30484b4bcbuLL) >> 32)},
   {(VUINT32) ((0xc08627d567882eb0uLL) >> 0),
    (VUINT32) ((0xc08627d567882eb0uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeea11a6641buLL) >> 0),
    (VUINT32) ((0xbe1ceeea11a6641buLL) >> 32)},
   {(VUINT32) ((0xc08627d7a2f68c80uLL) >> 0),
    (VUINT32) ((0xc08627d7a2f68c80uLL) >> 32)},
   {(VUINT32) ((0xbe1cf13492d5bd7buLL) >> 0),
    (VUINT32) ((0xbe1cf13492d5bd7buLL) >> 32)},
   {(VUINT32) ((0xc08627d9ddc5a618uLL) >> 0),
    (VUINT32) ((0xc08627d9ddc5a618uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeb7048fad96uLL) >> 0),
    (VUINT32) ((0xbe1ceeb7048fad96uLL) >> 32)},
   {(VUINT32) ((0xc08627dc17f5d418uLL) >> 0),
    (VUINT32) ((0xc08627dc17f5d418uLL) >> 32)},
   {(VUINT32) ((0xbe1ceef0666f0477uLL) >> 0),
    (VUINT32) ((0xbe1ceef0666f0477uLL) >> 32)},
   {(VUINT32) ((0xc08627de51876ee8uLL) >> 0),
    (VUINT32) ((0xc08627de51876ee8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf060d4b8b5c2uLL) >> 0),
    (VUINT32) ((0xbe1cf060d4b8b5c2uLL) >> 32)},
   {(VUINT32) ((0xc08627e08a7acea8uLL) >> 0),
    (VUINT32) ((0xc08627e08a7acea8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0b2a4b6ff8cuLL) >> 0),
    (VUINT32) ((0xbe1cf0b2a4b6ff8cuLL) >> 32)},
   {(VUINT32) ((0xc08627e2c2d04b28uLL) >> 0),
    (VUINT32) ((0xc08627e2c2d04b28uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0e34809a875uLL) >> 0),
    (VUINT32) ((0xbe1cf0e34809a875uLL) >> 32)},
   {(VUINT32) ((0xc08627e4fa883bf0uLL) >> 0),
    (VUINT32) ((0xc08627e4fa883bf0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf16bf74a3522uLL) >> 0),
    (VUINT32) ((0xbe1cf16bf74a3522uLL) >> 32)},
   {(VUINT32) ((0xc08627e731a2f848uLL) >> 0),
    (VUINT32) ((0xc08627e731a2f848uLL) >> 32)},
   {(VUINT32) ((0xbe1cee6a24623d57uLL) >> 0),
    (VUINT32) ((0xbe1cee6a24623d57uLL) >> 32)},
   {(VUINT32) ((0xc08627e96820d718uLL) >> 0),
    (VUINT32) ((0xc08627e96820d718uLL) >> 32)},
   {(VUINT32) ((0xbe1cefc7b4f1528euLL) >> 0),
    (VUINT32) ((0xbe1cefc7b4f1528euLL) >> 32)},
   {(VUINT32) ((0xc08627eb9e022f18uLL) >> 0),
    (VUINT32) ((0xc08627eb9e022f18uLL) >> 32)},
   {(VUINT32) ((0xbe1cf163051f3548uLL) >> 0),
    (VUINT32) ((0xbe1cf163051f3548uLL) >> 32)},
   {(VUINT32) ((0xc08627edd34756b8uLL) >> 0),
    (VUINT32) ((0xc08627edd34756b8uLL) >> 32)},
   {(VUINT32) ((0xbe1cef36b3366305uLL) >> 0),
    (VUINT32) ((0xbe1cef36b3366305uLL) >> 32)},
   {(VUINT32) ((0xc08627f007f0a408uLL) >> 0),
    (VUINT32) ((0xc08627f007f0a408uLL) >> 32)},
   {(VUINT32) ((0xbe1cf18134625550uLL) >> 0),
    (VUINT32) ((0xbe1cf18134625550uLL) >> 32)},
   {(VUINT32) ((0xc08627f23bfe6cf0uLL) >> 0),
    (VUINT32) ((0xc08627f23bfe6cf0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0ec32ec1a11uLL) >> 0),
    (VUINT32) ((0xbe1cf0ec32ec1a11uLL) >> 32)},
   {(VUINT32) ((0xc08627f46f710700uLL) >> 0),
    (VUINT32) ((0xc08627f46f710700uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeb3b64f3edcuLL) >> 0),
    (VUINT32) ((0xbe1ceeb3b64f3edcuLL) >> 32)},
   {(VUINT32) ((0xc08627f6a248c778uLL) >> 0),
    (VUINT32) ((0xc08627f6a248c778uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0cd15805bc8uLL) >> 0),
    (VUINT32) ((0xbe1cf0cd15805bc8uLL) >> 32)},
   {(VUINT32) ((0xc08627f8d4860368uLL) >> 0),
    (VUINT32) ((0xc08627f8d4860368uLL) >> 32)},
   {(VUINT32) ((0xbe1cf20db3bddebeuLL) >> 0),
    (VUINT32) ((0xbe1cf20db3bddebeuLL) >> 32)},
   {(VUINT32) ((0xc08627fb06290f90uLL) >> 0),
    (VUINT32) ((0xc08627fb06290f90uLL) >> 32)},
   {(VUINT32) ((0xbe1cf25188430e25uLL) >> 0),
    (VUINT32) ((0xbe1cf25188430e25uLL) >> 32)},
   {(VUINT32) ((0xc08627fd37324070uLL) >> 0),
    (VUINT32) ((0xc08627fd37324070uLL) >> 32)},
   {(VUINT32) ((0xbe1ceea1713490f9uLL) >> 0),
    (VUINT32) ((0xbe1ceea1713490f9uLL) >> 32)},
   {(VUINT32) ((0xc08627ff67a1ea28uLL) >> 0),
    (VUINT32) ((0xc08627ff67a1ea28uLL) >> 32)},
   {(VUINT32) ((0xbe1cf159521d234cuLL) >> 0),
    (VUINT32) ((0xbe1cf159521d234cuLL) >> 32)},
   {(VUINT32) ((0xc0862801977860b8uLL) >> 0),
    (VUINT32) ((0xc0862801977860b8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf24dfe50783buLL) >> 0),
    (VUINT32) ((0xbe1cf24dfe50783buLL) >> 32)},
   {(VUINT32) ((0xc0862803c6b5f7d0uLL) >> 0),
    (VUINT32) ((0xc0862803c6b5f7d0uLL) >> 32)},
   {(VUINT32) ((0xbe1ceef2ef89a60buLL) >> 0),
    (VUINT32) ((0xbe1ceef2ef89a60buLL) >> 32)},
   {(VUINT32) ((0xc0862805f55b02c8uLL) >> 0),
    (VUINT32) ((0xc0862805f55b02c8uLL) >> 32)},
   {(VUINT32) ((0xbe1cee7fc919d62cuLL) >> 0),
    (VUINT32) ((0xbe1cee7fc919d62cuLL) >> 32)},
   {(VUINT32) ((0xc08628082367d4c0uLL) >> 0),
    (VUINT32) ((0xc08628082367d4c0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf215a7fb513auLL) >> 0),
    (VUINT32) ((0xbe1cf215a7fb513auLL) >> 32)},
   {(VUINT32) ((0xc086280a50dcc0a8uLL) >> 0),
    (VUINT32) ((0xc086280a50dcc0a8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0e4401c5ed4uLL) >> 0),
    (VUINT32) ((0xbe1cf0e4401c5ed4uLL) >> 32)},
   {(VUINT32) ((0xc086280c7dba1910uLL) >> 0),
    (VUINT32) ((0xc086280c7dba1910uLL) >> 32)},
   {(VUINT32) ((0xbe1cf04ec734d256uLL) >> 0),
    (VUINT32) ((0xbe1cf04ec734d256uLL) >> 32)},
   {(VUINT32) ((0xc086280eaa003050uLL) >> 0),
    (VUINT32) ((0xc086280eaa003050uLL) >> 32)},
   {(VUINT32) ((0xbe1cf010ad787feauLL) >> 0),
    (VUINT32) ((0xbe1cf010ad787feauLL) >> 32)},
   {(VUINT32) ((0xc0862810d5af5880uLL) >> 0),
    (VUINT32) ((0xc0862810d5af5880uLL) >> 32)},
   {(VUINT32) ((0xbe1cee622478393duLL) >> 0),
    (VUINT32) ((0xbe1cee622478393duLL) >> 32)},
   {(VUINT32) ((0xc086281300c7e368uLL) >> 0),
    (VUINT32) ((0xc086281300c7e368uLL) >> 32)},
   {(VUINT32) ((0xbe1cf01c7482564fuLL) >> 0),
    (VUINT32) ((0xbe1cf01c7482564fuLL) >> 32)},
   {(VUINT32) ((0xc08628152b4a22a0uLL) >> 0),
    (VUINT32) ((0xc08628152b4a22a0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0de20d33536uLL) >> 0),
    (VUINT32) ((0xbe1cf0de20d33536uLL) >> 32)},
   {(VUINT32) ((0xc086281755366778uLL) >> 0),
    (VUINT32) ((0xc086281755366778uLL) >> 32)},
   {(VUINT32) ((0xbe1cef2edae5837duLL) >> 0),
    (VUINT32) ((0xbe1cef2edae5837duLL) >> 32)},
   {(VUINT32) ((0xc08628197e8d02f0uLL) >> 0),
    (VUINT32) ((0xc08628197e8d02f0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0a345318cc9uLL) >> 0),
    (VUINT32) ((0xbe1cf0a345318cc9uLL) >> 32)},
   {(VUINT32) ((0xc086281ba74e45d8uLL) >> 0),
    (VUINT32) ((0xc086281ba74e45d8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf20085aa34b8uLL) >> 0),
    (VUINT32) ((0xbe1cf20085aa34b8uLL) >> 32)},
   {(VUINT32) ((0xc086281dcf7a80c0uLL) >> 0),
    (VUINT32) ((0xc086281dcf7a80c0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef5fa845ad83uLL) >> 0),
    (VUINT32) ((0xbe1cef5fa845ad83uLL) >> 32)},
   {(VUINT32) ((0xc086281ff71203e0uLL) >> 0),
    (VUINT32) ((0xc086281ff71203e0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf050d1df69c4uLL) >> 0),
    (VUINT32) ((0xbe1cf050d1df69c4uLL) >> 32)},
   {(VUINT32) ((0xc08628221e151f48uLL) >> 0),
    (VUINT32) ((0xc08628221e151f48uLL) >> 32)},
   {(VUINT32) ((0xbe1ceffe43c035b9uLL) >> 0),
    (VUINT32) ((0xbe1ceffe43c035b9uLL) >> 32)},
   {(VUINT32) ((0xc0862824448422b8uLL) >> 0),
    (VUINT32) ((0xc0862824448422b8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf14f3018d3c2uLL) >> 0),
    (VUINT32) ((0xbe1cf14f3018d3c2uLL) >> 32)},
   {(VUINT32) ((0xc08628266a5f5dc0uLL) >> 0),
    (VUINT32) ((0xc08628266a5f5dc0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef0a5fbae83duLL) >> 0),
    (VUINT32) ((0xbe1cef0a5fbae83duLL) >> 32)},
   {(VUINT32) ((0xc08628288fa71f98uLL) >> 0),
    (VUINT32) ((0xc08628288fa71f98uLL) >> 32)},
   {(VUINT32) ((0xbe1ceff8a95b72a1uLL) >> 0),
    (VUINT32) ((0xbe1ceff8a95b72a1uLL) >> 32)},
   {(VUINT32) ((0xc086282ab45bb750uLL) >> 0),
    (VUINT32) ((0xc086282ab45bb750uLL) >> 32)},
   {(VUINT32) ((0xbe1cef073aa9849buLL) >> 0),
    (VUINT32) ((0xbe1cef073aa9849buLL) >> 32)},
   {(VUINT32) ((0xc086282cd87d73a8uLL) >> 0),
    (VUINT32) ((0xc086282cd87d73a8uLL) >> 32)},
   {(VUINT32) ((0xbe1cef69b3835c02uLL) >> 0),
    (VUINT32) ((0xbe1cef69b3835c02uLL) >> 32)},
   {(VUINT32) ((0xc086282efc0ca328uLL) >> 0),
    (VUINT32) ((0xc086282efc0ca328uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0bc139379a9uLL) >> 0),
    (VUINT32) ((0xbe1cf0bc139379a9uLL) >> 32)},
   {(VUINT32) ((0xc08628311f099420uLL) >> 0),
    (VUINT32) ((0xc08628311f099420uLL) >> 32)},
   {(VUINT32) ((0xbe1cef247a9ec596uLL) >> 0),
    (VUINT32) ((0xbe1cef247a9ec596uLL) >> 32)},
   {(VUINT32) ((0xc086283341749490uLL) >> 0),
    (VUINT32) ((0xc086283341749490uLL) >> 32)},
   {(VUINT32) ((0xbe1cef74bbcc488auLL) >> 0),
    (VUINT32) ((0xbe1cef74bbcc488auLL) >> 32)},
   {(VUINT32) ((0xc0862835634df248uLL) >> 0),
    (VUINT32) ((0xc0862835634df248uLL) >> 32)},
   {(VUINT32) ((0xbe1cef4bc42e7b8euLL) >> 0),
    (VUINT32) ((0xbe1cef4bc42e7b8euLL) >> 32)},
   {(VUINT32) ((0xc08628378495fad0uLL) >> 0),
    (VUINT32) ((0xc08628378495fad0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf136d4d5a810uLL) >> 0),
    (VUINT32) ((0xbe1cf136d4d5a810uLL) >> 32)},
   {(VUINT32) ((0xc0862839a54cfb80uLL) >> 0),
    (VUINT32) ((0xc0862839a54cfb80uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0d290b24dd8uLL) >> 0),
    (VUINT32) ((0xbe1cf0d290b24dd8uLL) >> 32)},
   {(VUINT32) ((0xc086283bc5734168uLL) >> 0),
    (VUINT32) ((0xc086283bc5734168uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeebde8e0065uLL) >> 0),
    (VUINT32) ((0xbe1ceeebde8e0065uLL) >> 32)},
   {(VUINT32) ((0xc086283de5091950uLL) >> 0),
    (VUINT32) ((0xc086283de5091950uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1a09f60aa1euLL) >> 0),
    (VUINT32) ((0xbe1cf1a09f60aa1euLL) >> 32)},
   {(VUINT32) ((0xc0862840040ecfe0uLL) >> 0),
    (VUINT32) ((0xc0862840040ecfe0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0803947a234uLL) >> 0),
    (VUINT32) ((0xbe1cf0803947a234uLL) >> 32)},
   {(VUINT32) ((0xc08628422284b168uLL) >> 0),
    (VUINT32) ((0xc08628422284b168uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0abf7638127uLL) >> 0),
    (VUINT32) ((0xbe1cf0abf7638127uLL) >> 32)},
   {(VUINT32) ((0xc0862844406b0a08uLL) >> 0),
    (VUINT32) ((0xc0862844406b0a08uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0f73ee12058uLL) >> 0),
    (VUINT32) ((0xbe1cf0f73ee12058uLL) >> 32)},
   {(VUINT32) ((0xc08628465dc225a0uLL) >> 0),
    (VUINT32) ((0xc08628465dc225a0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf2079971b26cuLL) >> 0),
    (VUINT32) ((0xbe1cf2079971b26cuLL) >> 32)},
   {(VUINT32) ((0xc08628487a8a4fe0uLL) >> 0),
    (VUINT32) ((0xc08628487a8a4fe0uLL) >> 32)},
   {(VUINT32) ((0xbe1cee74957564b1uLL) >> 0),
    (VUINT32) ((0xbe1cee74957564b1uLL) >> 32)},
   {(VUINT32) ((0xc086284a96c3d420uLL) >> 0),
    (VUINT32) ((0xc086284a96c3d420uLL) >> 32)},
   {(VUINT32) ((0xbe1ceee77c1b7d43uLL) >> 0),
    (VUINT32) ((0xbe1ceee77c1b7d43uLL) >> 32)},
   {(VUINT32) ((0xc086284cb26efd90uLL) >> 0),
    (VUINT32) ((0xc086284cb26efd90uLL) >> 32)},
   {(VUINT32) ((0xbe1cf23addba6e09uLL) >> 0),
    (VUINT32) ((0xbe1cf23addba6e09uLL) >> 32)},
   {(VUINT32) ((0xc086284ecd8c1730uLL) >> 0),
    (VUINT32) ((0xc086284ecd8c1730uLL) >> 32)},
   {(VUINT32) ((0xbe1cf199f4a1da60uLL) >> 0),
    (VUINT32) ((0xbe1cf199f4a1da60uLL) >> 32)},
   {(VUINT32) ((0xc0862850e81b6bb0uLL) >> 0),
    (VUINT32) ((0xc0862850e81b6bb0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf09fdea81393uLL) >> 0),
    (VUINT32) ((0xbe1cf09fdea81393uLL) >> 32)},
   {(VUINT32) ((0xc0862853021d4588uLL) >> 0),
    (VUINT32) ((0xc0862853021d4588uLL) >> 32)},
   {(VUINT32) ((0xbe1cf176adb417f7uLL) >> 0),
    (VUINT32) ((0xbe1cf176adb417f7uLL) >> 32)},
   {(VUINT32) ((0xc08628551b91ef00uLL) >> 0),
    (VUINT32) ((0xc08628551b91ef00uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0f64f84a8dauLL) >> 0),
    (VUINT32) ((0xbe1cf0f64f84a8dauLL) >> 32)},
   {(VUINT32) ((0xc08628573479b220uLL) >> 0),
    (VUINT32) ((0xc08628573479b220uLL) >> 32)},
   {(VUINT32) ((0xbe1ceec34cf49523uLL) >> 0),
    (VUINT32) ((0xbe1ceec34cf49523uLL) >> 32)},
   {(VUINT32) ((0xc08628594cd4d8a8uLL) >> 0),
    (VUINT32) ((0xc08628594cd4d8a8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf16d60fbe0bbuLL) >> 0),
    (VUINT32) ((0xbe1cf16d60fbe0bbuLL) >> 32)},
   {(VUINT32) ((0xc086285b64a3ac40uLL) >> 0),
    (VUINT32) ((0xc086285b64a3ac40uLL) >> 32)},
   {(VUINT32) ((0xbe1cee8de7acfc7buLL) >> 0),
    (VUINT32) ((0xbe1cee8de7acfc7buLL) >> 32)},
   {(VUINT32) ((0xc086285d7be67630uLL) >> 0),
    (VUINT32) ((0xc086285d7be67630uLL) >> 32)},
   {(VUINT32) ((0xbe1ceee6256cce8duLL) >> 0),
    (VUINT32) ((0xbe1ceee6256cce8duLL) >> 32)},
   {(VUINT32) ((0xc086285f929d7fa0uLL) >> 0),
    (VUINT32) ((0xc086285f929d7fa0uLL) >> 32)},
   {(VUINT32) ((0xbe1cee7d66a3d8a5uLL) >> 0),
    (VUINT32) ((0xbe1cee7d66a3d8a5uLL) >> 32)},
   {(VUINT32) ((0xc0862861a8c91170uLL) >> 0),
    (VUINT32) ((0xc0862861a8c91170uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0bef8265792uLL) >> 0),
    (VUINT32) ((0xbe1cf0bef8265792uLL) >> 32)},
   {(VUINT32) ((0xc0862863be697458uLL) >> 0),
    (VUINT32) ((0xc0862863be697458uLL) >> 32)},
   {(VUINT32) ((0xbe1cf097f890c6f8uLL) >> 0),
    (VUINT32) ((0xbe1cf097f890c6f8uLL) >> 32)},
   {(VUINT32) ((0xc0862865d37ef0c8uLL) >> 0),
    (VUINT32) ((0xc0862865d37ef0c8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf09502d5c3fcuLL) >> 0),
    (VUINT32) ((0xbe1cf09502d5c3fcuLL) >> 32)},
   {(VUINT32) ((0xc0862867e809cf00uLL) >> 0),
    (VUINT32) ((0xc0862867e809cf00uLL) >> 32)},
   {(VUINT32) ((0xbe1ceeffb239dac7uLL) >> 0),
    (VUINT32) ((0xbe1ceeffb239dac7uLL) >> 32)},
   {(VUINT32) ((0xc0862869fc0a56f8uLL) >> 0),
    (VUINT32) ((0xc0862869fc0a56f8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1fbfff95c98uLL) >> 0),
    (VUINT32) ((0xbe1cf1fbfff95c98uLL) >> 32)},
   {(VUINT32) ((0xc086286c0f80d090uLL) >> 0),
    (VUINT32) ((0xc086286c0f80d090uLL) >> 32)},
   {(VUINT32) ((0xbe1cefa57ad3eef7uLL) >> 0),
    (VUINT32) ((0xbe1cefa57ad3eef7uLL) >> 32)},
   {(VUINT32) ((0xc086286e226d8348uLL) >> 0),
    (VUINT32) ((0xc086286e226d8348uLL) >> 32)},
   {(VUINT32) ((0xbe1cf22c58b9183duLL) >> 0),
    (VUINT32) ((0xbe1cf22c58b9183duLL) >> 32)},
   {(VUINT32) ((0xc086287034d0b690uLL) >> 0),
    (VUINT32) ((0xc086287034d0b690uLL) >> 32)},
   {(VUINT32) ((0xbe1ceff262d0a248uLL) >> 0),
    (VUINT32) ((0xbe1ceff262d0a248uLL) >> 32)},
   {(VUINT32) ((0xc086287246aab180uLL) >> 0),
    (VUINT32) ((0xc086287246aab180uLL) >> 32)},
   {(VUINT32) ((0xbe1cefa7bc194186uLL) >> 0),
    (VUINT32) ((0xbe1cefa7bc194186uLL) >> 32)},
   {(VUINT32) ((0xc086287457fbbb08uLL) >> 0),
    (VUINT32) ((0xc086287457fbbb08uLL) >> 32)},
   {(VUINT32) ((0xbe1cf06782d784d9uLL) >> 0),
    (VUINT32) ((0xbe1cf06782d784d9uLL) >> 32)},
   {(VUINT32) ((0xc086287668c419e0uLL) >> 0),
    (VUINT32) ((0xc086287668c419e0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1d44d0eaa07uLL) >> 0),
    (VUINT32) ((0xbe1cf1d44d0eaa07uLL) >> 32)},
   {(VUINT32) ((0xc086287879041490uLL) >> 0),
    (VUINT32) ((0xc086287879041490uLL) >> 32)},
   {(VUINT32) ((0xbe1cf034803c8a48uLL) >> 0),
    (VUINT32) ((0xbe1cf034803c8a48uLL) >> 32)},
   {(VUINT32) ((0xc086287a88bbf158uLL) >> 0),
    (VUINT32) ((0xc086287a88bbf158uLL) >> 32)},
   {(VUINT32) ((0xbe1cf08e84916b6fuLL) >> 0),
    (VUINT32) ((0xbe1cf08e84916b6fuLL) >> 32)},
   {(VUINT32) ((0xc086287c97ebf650uLL) >> 0),
    (VUINT32) ((0xc086287c97ebf650uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0c4d3dc1bc7uLL) >> 0),
    (VUINT32) ((0xbe1cf0c4d3dc1bc7uLL) >> 32)},
   {(VUINT32) ((0xc086287ea6946958uLL) >> 0),
    (VUINT32) ((0xc086287ea6946958uLL) >> 32)},
   {(VUINT32) ((0xbe1cefb1e4625943uLL) >> 0),
    (VUINT32) ((0xbe1cefb1e4625943uLL) >> 32)},
   {(VUINT32) ((0xc0862880b4b59010uLL) >> 0),
    (VUINT32) ((0xc0862880b4b59010uLL) >> 32)},
   {(VUINT32) ((0xbe1cf143efdd1fd0uLL) >> 0),
    (VUINT32) ((0xbe1cf143efdd1fd0uLL) >> 32)},
   {(VUINT32) ((0xc0862882c24faff8uLL) >> 0),
    (VUINT32) ((0xc0862882c24faff8uLL) >> 32)},
   {(VUINT32) ((0xbe1cee9896d016dauLL) >> 0),
    (VUINT32) ((0xbe1cee9896d016dauLL) >> 32)},
   {(VUINT32) ((0xc0862884cf630e38uLL) >> 0),
    (VUINT32) ((0xc0862884cf630e38uLL) >> 32)},
   {(VUINT32) ((0xbe1cf2186072f2ccuLL) >> 0),
    (VUINT32) ((0xbe1cf2186072f2ccuLL) >> 32)},
   {(VUINT32) ((0xc0862886dbefeff0uLL) >> 0),
    (VUINT32) ((0xc0862886dbefeff0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef9217633d34uLL) >> 0),
    (VUINT32) ((0xbe1cef9217633d34uLL) >> 32)},
   {(VUINT32) ((0xc0862888e7f699e0uLL) >> 0),
    (VUINT32) ((0xc0862888e7f699e0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf05603549486uLL) >> 0),
    (VUINT32) ((0xbe1cf05603549486uLL) >> 32)},
   {(VUINT32) ((0xc086288af37750b0uLL) >> 0),
    (VUINT32) ((0xc086288af37750b0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef50fff513d3uLL) >> 0),
    (VUINT32) ((0xbe1cef50fff513d3uLL) >> 32)},
   {(VUINT32) ((0xc086288cfe7258c0uLL) >> 0),
    (VUINT32) ((0xc086288cfe7258c0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf127713b32d0uLL) >> 0),
    (VUINT32) ((0xbe1cf127713b32d0uLL) >> 32)},
   {(VUINT32) ((0xc086288f08e7f650uLL) >> 0),
    (VUINT32) ((0xc086288f08e7f650uLL) >> 32)},
   {(VUINT32) ((0xbe1cf05015520f3duLL) >> 0),
    (VUINT32) ((0xbe1cf05015520f3duLL) >> 32)},
   {(VUINT32) ((0xc086289112d86d58uLL) >> 0),
    (VUINT32) ((0xc086289112d86d58uLL) >> 32)},
   {(VUINT32) ((0xbe1cf12eb458b26fuLL) >> 0),
    (VUINT32) ((0xbe1cf12eb458b26fuLL) >> 32)},
   {(VUINT32) ((0xc08628931c4401a8uLL) >> 0),
    (VUINT32) ((0xc08628931c4401a8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf22eae2887eduLL) >> 0),
    (VUINT32) ((0xbe1cf22eae2887eduLL) >> 32)},
   {(VUINT32) ((0xc0862895252af6e0uLL) >> 0),
    (VUINT32) ((0xc0862895252af6e0uLL) >> 32)},
   {(VUINT32) ((0xbe1cefdd6656dd2duLL) >> 0),
    (VUINT32) ((0xbe1cefdd6656dd2duLL) >> 32)},
   {(VUINT32) ((0xc08628972d8d9058uLL) >> 0),
    (VUINT32) ((0xc08628972d8d9058uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1048ea4e646uLL) >> 0),
    (VUINT32) ((0xbe1cf1048ea4e646uLL) >> 32)},
   {(VUINT32) ((0xc0862899356c1150uLL) >> 0),
    (VUINT32) ((0xc0862899356c1150uLL) >> 32)},
   {(VUINT32) ((0xbe1ceec4501167e9uLL) >> 0),
    (VUINT32) ((0xbe1ceec4501167e9uLL) >> 32)},
   {(VUINT32) ((0xc086289b3cc6bcb8uLL) >> 0),
    (VUINT32) ((0xc086289b3cc6bcb8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0ad52becc3fuLL) >> 0),
    (VUINT32) ((0xbe1cf0ad52becc3fuLL) >> 32)},
   {(VUINT32) ((0xc086289d439dd568uLL) >> 0),
    (VUINT32) ((0xc086289d439dd568uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0daa4e00e35uLL) >> 0),
    (VUINT32) ((0xbe1cf0daa4e00e35uLL) >> 32)},
   {(VUINT32) ((0xc086289f49f19df8uLL) >> 0),
    (VUINT32) ((0xc086289f49f19df8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf00b80de8d6auLL) >> 0),
    (VUINT32) ((0xbe1cf00b80de8d6auLL) >> 32)},
   {(VUINT32) ((0xc08628a14fc258c8uLL) >> 0),
    (VUINT32) ((0xc08628a14fc258c8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1bcf2ea8464uLL) >> 0),
    (VUINT32) ((0xbe1cf1bcf2ea8464uLL) >> 32)},
   {(VUINT32) ((0xc08628a355104818uLL) >> 0),
    (VUINT32) ((0xc08628a355104818uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0435e2782b0uLL) >> 0),
    (VUINT32) ((0xbe1cf0435e2782b0uLL) >> 32)},
   {(VUINT32) ((0xc08628a559dbade0uLL) >> 0),
    (VUINT32) ((0xc08628a559dbade0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0e3e1a5f56cuLL) >> 0),
    (VUINT32) ((0xbe1cf0e3e1a5f56cuLL) >> 32)},
   {(VUINT32) ((0xc08628a75e24cbf8uLL) >> 0),
    (VUINT32) ((0xc08628a75e24cbf8uLL) >> 32)},
   {(VUINT32) ((0xbe1cefed9d5a721duLL) >> 0),
    (VUINT32) ((0xbe1cefed9d5a721duLL) >> 32)},
   {(VUINT32) ((0xc08628a961ebe3f8uLL) >> 0),
    (VUINT32) ((0xc08628a961ebe3f8uLL) >> 32)},
   {(VUINT32) ((0xbe1cf0d2d74321e2uLL) >> 0),
    (VUINT32) ((0xbe1cf0d2d74321e2uLL) >> 32)},
   {(VUINT32) ((0xc08628ab65313750uLL) >> 0),
    (VUINT32) ((0xc08628ab65313750uLL) >> 32)},
   {(VUINT32) ((0xbe1cf24200eb55e9uLL) >> 0),
    (VUINT32) ((0xbe1cf24200eb55e9uLL) >> 32)},
   {(VUINT32) ((0xc08628ad67f50740uLL) >> 0),
    (VUINT32) ((0xc08628ad67f50740uLL) >> 32)},
   {(VUINT32) ((0xbe1cf23e9d7cf979uLL) >> 0),
    (VUINT32) ((0xbe1cf23e9d7cf979uLL) >> 32)},
   {(VUINT32) ((0xc08628af6a3794d0uLL) >> 0),
    (VUINT32) ((0xc08628af6a3794d0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf23a088f421cuLL) >> 0),
    (VUINT32) ((0xbe1cf23a088f421cuLL) >> 32)},
   {(VUINT32) ((0xc08628b16bf920e0uLL) >> 0),
    (VUINT32) ((0xc08628b16bf920e0uLL) >> 32)},
   {(VUINT32) ((0xbe1cef2c1de1ab32uLL) >> 0),
    (VUINT32) ((0xbe1cef2c1de1ab32uLL) >> 32)},
   {(VUINT32) ((0xc08628b36d39ec08uLL) >> 0),
    (VUINT32) ((0xc08628b36d39ec08uLL) >> 32)},
   {(VUINT32) ((0xbe1cf1abc231f7b2uLL) >> 0),
    (VUINT32) ((0xbe1cf1abc231f7b2uLL) >> 32)},
   {(VUINT32) ((0xc08628b56dfa36d0uLL) >> 0),
    (VUINT32) ((0xc08628b56dfa36d0uLL) >> 32)},
   {(VUINT32) ((0xbe1cf2074d5ba303uLL) >> 0),
    (VUINT32) ((0xbe1cf2074d5ba303uLL) >> 32)},
   {(VUINT32) ((0xc08628b76e3a4180uLL) >> 0),
    (VUINT32) ((0xc08628b76e3a4180uLL) >> 32)},
   {(VUINT32) ((0xbe1cf05cd5eed880uLL) >> 0),
    (VUINT32) ((0xbe1cf05cd5eed880uLL) >> 32)}}

  , {
     {(VUINT32) ((0x8000000000000000uLL) >> 0),
      (VUINT32) ((0x8000000000000000uLL) >> 32)},
     {(VUINT32) ((0xbf5ff802a9ab10e6uLL) >> 0),
      (VUINT32) ((0xbf5ff802a9ab10e6uLL) >> 32)},
     {(VUINT32) ((0xbf6ff00aa2b10bc0uLL) >> 0),
      (VUINT32) ((0xbf6ff00aa2b10bc0uLL) >> 32)},
     {(VUINT32) ((0xbf77ee11ebd82e94uLL) >> 0),
      (VUINT32) ((0xbf77ee11ebd82e94uLL) >> 32)},
     {(VUINT32) ((0xbf7fe02a6b106789uLL) >> 0),
      (VUINT32) ((0xbf7fe02a6b106789uLL) >> 32)},
     {(VUINT32) ((0xbf83e7295d25a7d9uLL) >> 0),
      (VUINT32) ((0xbf83e7295d25a7d9uLL) >> 32)},
     {(VUINT32) ((0xbf87dc475f810a77uLL) >> 0),
      (VUINT32) ((0xbf87dc475f810a77uLL) >> 32)},
     {(VUINT32) ((0xbf8bcf712c74384cuLL) >> 0),
      (VUINT32) ((0xbf8bcf712c74384cuLL) >> 32)},
     {(VUINT32) ((0xbf8fc0a8b0fc03e4uLL) >> 0),
      (VUINT32) ((0xbf8fc0a8b0fc03e4uLL) >> 32)},
     {(VUINT32) ((0xbf91d7f7eb9eebe7uLL) >> 0),
      (VUINT32) ((0xbf91d7f7eb9eebe7uLL) >> 32)},
     {(VUINT32) ((0xbf93cea44346a575uLL) >> 0),
      (VUINT32) ((0xbf93cea44346a575uLL) >> 32)},
     {(VUINT32) ((0xbf95c45a51b8d389uLL) >> 0),
      (VUINT32) ((0xbf95c45a51b8d389uLL) >> 32)},
     {(VUINT32) ((0xbf97b91b07d5b11buLL) >> 0),
      (VUINT32) ((0xbf97b91b07d5b11buLL) >> 32)},
     {(VUINT32) ((0xbf99ace7551cc514uLL) >> 0),
      (VUINT32) ((0xbf99ace7551cc514uLL) >> 32)},
     {(VUINT32) ((0xbf9b9fc027af9198uLL) >> 0),
      (VUINT32) ((0xbf9b9fc027af9198uLL) >> 32)},
     {(VUINT32) ((0xbf9d91a66c543cc4uLL) >> 0),
      (VUINT32) ((0xbf9d91a66c543cc4uLL) >> 32)},
     {(VUINT32) ((0xbf9f829b0e783300uLL) >> 0),
      (VUINT32) ((0xbf9f829b0e783300uLL) >> 32)},
     {(VUINT32) ((0xbfa0b94f7c196176uLL) >> 0),
      (VUINT32) ((0xbfa0b94f7c196176uLL) >> 32)},
     {(VUINT32) ((0xbfa1b0d98923d980uLL) >> 0),
      (VUINT32) ((0xbfa1b0d98923d980uLL) >> 32)},
     {(VUINT32) ((0xbfa2a7ec2214e873uLL) >> 0),
      (VUINT32) ((0xbfa2a7ec2214e873uLL) >> 32)},
     {(VUINT32) ((0xbfa39e87b9febd60uLL) >> 0),
      (VUINT32) ((0xbfa39e87b9febd60uLL) >> 32)},
     {(VUINT32) ((0xbfa494acc34d911cuLL) >> 0),
      (VUINT32) ((0xbfa494acc34d911cuLL) >> 32)},
     {(VUINT32) ((0xbfa58a5bafc8e4d5uLL) >> 0),
      (VUINT32) ((0xbfa58a5bafc8e4d5uLL) >> 32)},
     {(VUINT32) ((0xbfa67f94f094bd98uLL) >> 0),
      (VUINT32) ((0xbfa67f94f094bd98uLL) >> 32)},
     {(VUINT32) ((0xbfa77458f632dcfcuLL) >> 0),
      (VUINT32) ((0xbfa77458f632dcfcuLL) >> 32)},
     {(VUINT32) ((0xbfa868a83083f6cfuLL) >> 0),
      (VUINT32) ((0xbfa868a83083f6cfuLL) >> 32)},
     {(VUINT32) ((0xbfa95c830ec8e3ebuLL) >> 0),
      (VUINT32) ((0xbfa95c830ec8e3ebuLL) >> 32)},
     {(VUINT32) ((0xbfaa4fe9ffa3d235uLL) >> 0),
      (VUINT32) ((0xbfaa4fe9ffa3d235uLL) >> 32)},
     {(VUINT32) ((0xbfab42dd711971bfuLL) >> 0),
      (VUINT32) ((0xbfab42dd711971bfuLL) >> 32)},
     {(VUINT32) ((0xbfac355dd0921f2duLL) >> 0),
      (VUINT32) ((0xbfac355dd0921f2duLL) >> 32)},
     {(VUINT32) ((0xbfad276b8adb0b52uLL) >> 0),
      (VUINT32) ((0xbfad276b8adb0b52uLL) >> 32)},
     {(VUINT32) ((0xbfae19070c276016uLL) >> 0),
      (VUINT32) ((0xbfae19070c276016uLL) >> 32)},
     {(VUINT32) ((0xbfaf0a30c01162a6uLL) >> 0),
      (VUINT32) ((0xbfaf0a30c01162a6uLL) >> 32)},
     {(VUINT32) ((0xbfaffae9119b9303uLL) >> 0),
      (VUINT32) ((0xbfaffae9119b9303uLL) >> 32)},
     {(VUINT32) ((0xbfb075983598e471uLL) >> 0),
      (VUINT32) ((0xbfb075983598e471uLL) >> 32)},
     {(VUINT32) ((0xbfb0ed839b5526feuLL) >> 0),
      (VUINT32) ((0xbfb0ed839b5526feuLL) >> 32)},
     {(VUINT32) ((0xbfb16536eea37ae1uLL) >> 0),
      (VUINT32) ((0xbfb16536eea37ae1uLL) >> 32)},
     {(VUINT32) ((0xbfb1dcb263db1944uLL) >> 0),
      (VUINT32) ((0xbfb1dcb263db1944uLL) >> 32)},
     {(VUINT32) ((0xbfb253f62f0a1417uLL) >> 0),
      (VUINT32) ((0xbfb253f62f0a1417uLL) >> 32)},
     {(VUINT32) ((0xbfb2cb0283f5de1fuLL) >> 0),
      (VUINT32) ((0xbfb2cb0283f5de1fuLL) >> 32)},
     {(VUINT32) ((0xbfb341d7961bd1d1uLL) >> 0),
      (VUINT32) ((0xbfb341d7961bd1d1uLL) >> 32)},
     {(VUINT32) ((0xbfb3b87598b1b6eeuLL) >> 0),
      (VUINT32) ((0xbfb3b87598b1b6eeuLL) >> 32)},
     {(VUINT32) ((0xbfb42edcbea646f0uLL) >> 0),
      (VUINT32) ((0xbfb42edcbea646f0uLL) >> 32)},
     {(VUINT32) ((0xbfb4a50d3aa1b040uLL) >> 0),
      (VUINT32) ((0xbfb4a50d3aa1b040uLL) >> 32)},
     {(VUINT32) ((0xbfb51b073f06183fuLL) >> 0),
      (VUINT32) ((0xbfb51b073f06183fuLL) >> 32)},
     {(VUINT32) ((0xbfb590cafdf01c28uLL) >> 0),
      (VUINT32) ((0xbfb590cafdf01c28uLL) >> 32)},
     {(VUINT32) ((0xbfb60658a93750c4uLL) >> 0),
      (VUINT32) ((0xbfb60658a93750c4uLL) >> 32)},
     {(VUINT32) ((0xbfb67bb0726ec0fcuLL) >> 0),
      (VUINT32) ((0xbfb67bb0726ec0fcuLL) >> 32)},
     {(VUINT32) ((0xbfb6f0d28ae56b4cuLL) >> 0),
      (VUINT32) ((0xbfb6f0d28ae56b4cuLL) >> 32)},
     {(VUINT32) ((0xbfb765bf23a6be13uLL) >> 0),
      (VUINT32) ((0xbfb765bf23a6be13uLL) >> 32)},
     {(VUINT32) ((0xbfb7da766d7b12cduLL) >> 0),
      (VUINT32) ((0xbfb7da766d7b12cduLL) >> 32)},
     {(VUINT32) ((0xbfb84ef898e8282auLL) >> 0),
      (VUINT32) ((0xbfb84ef898e8282auLL) >> 32)},
     {(VUINT32) ((0xbfb8c345d6319b21uLL) >> 0),
      (VUINT32) ((0xbfb8c345d6319b21uLL) >> 32)},
     {(VUINT32) ((0xbfb9375e55595edeuLL) >> 0),
      (VUINT32) ((0xbfb9375e55595edeuLL) >> 32)},
     {(VUINT32) ((0xbfb9ab42462033aduLL) >> 0),
      (VUINT32) ((0xbfb9ab42462033aduLL) >> 32)},
     {(VUINT32) ((0xbfba1ef1d8061cd4uLL) >> 0),
      (VUINT32) ((0xbfba1ef1d8061cd4uLL) >> 32)},
     {(VUINT32) ((0xbfba926d3a4ad563uLL) >> 0),
      (VUINT32) ((0xbfba926d3a4ad563uLL) >> 32)},
     {(VUINT32) ((0xbfbb05b49bee43feuLL) >> 0),
      (VUINT32) ((0xbfbb05b49bee43feuLL) >> 32)},
     {(VUINT32) ((0xbfbb78c82bb0eda1uLL) >> 0),
      (VUINT32) ((0xbfbb78c82bb0eda1uLL) >> 32)},
     {(VUINT32) ((0xbfbbeba818146765uLL) >> 0),
      (VUINT32) ((0xbfbbeba818146765uLL) >> 32)},
     {(VUINT32) ((0xbfbc5e548f5bc743uLL) >> 0),
      (VUINT32) ((0xbfbc5e548f5bc743uLL) >> 32)},
     {(VUINT32) ((0xbfbcd0cdbf8c13e1uLL) >> 0),
      (VUINT32) ((0xbfbcd0cdbf8c13e1uLL) >> 32)},
     {(VUINT32) ((0xbfbd4313d66cb35duLL) >> 0),
      (VUINT32) ((0xbfbd4313d66cb35duLL) >> 32)},
     {(VUINT32) ((0xbfbdb5270187d927uLL) >> 0),
      (VUINT32) ((0xbfbdb5270187d927uLL) >> 32)},
     {(VUINT32) ((0xbfbe27076e2af2e6uLL) >> 0),
      (VUINT32) ((0xbfbe27076e2af2e6uLL) >> 32)},
     {(VUINT32) ((0xbfbe98b549671467uLL) >> 0),
      (VUINT32) ((0xbfbe98b549671467uLL) >> 32)},
     {(VUINT32) ((0xbfbf0a30c01162a6uLL) >> 0),
      (VUINT32) ((0xbfbf0a30c01162a6uLL) >> 32)},
     {(VUINT32) ((0xbfbf7b79fec37ddfuLL) >> 0),
      (VUINT32) ((0xbfbf7b79fec37ddfuLL) >> 32)},
     {(VUINT32) ((0xbfbfec9131dbeabbuLL) >> 0),
      (VUINT32) ((0xbfbfec9131dbeabbuLL) >> 32)},
     {(VUINT32) ((0xbfc02ebb42bf3d4buLL) >> 0),
      (VUINT32) ((0xbfc02ebb42bf3d4buLL) >> 32)},
     {(VUINT32) ((0xbfc0671512ca596euLL) >> 0),
      (VUINT32) ((0xbfc0671512ca596euLL) >> 32)},
     {(VUINT32) ((0xbfc09f561ee719c3uLL) >> 0),
      (VUINT32) ((0xbfc09f561ee719c3uLL) >> 32)},
     {(VUINT32) ((0xbfc0d77e7cd08e59uLL) >> 0),
      (VUINT32) ((0xbfc0d77e7cd08e59uLL) >> 32)},
     {(VUINT32) ((0xbfc10f8e422539b1uLL) >> 0),
      (VUINT32) ((0xbfc10f8e422539b1uLL) >> 32)},
     {(VUINT32) ((0xbfc14785846742acuLL) >> 0),
      (VUINT32) ((0xbfc14785846742acuLL) >> 32)},
     {(VUINT32) ((0xbfc17f6458fca611uLL) >> 0),
      (VUINT32) ((0xbfc17f6458fca611uLL) >> 32)},
     {(VUINT32) ((0xbfc1b72ad52f67a0uLL) >> 0),
      (VUINT32) ((0xbfc1b72ad52f67a0uLL) >> 32)},
     {(VUINT32) ((0xbfc1eed90e2dc2c3uLL) >> 0),
      (VUINT32) ((0xbfc1eed90e2dc2c3uLL) >> 32)},
     {(VUINT32) ((0xbfc2266f190a5acbuLL) >> 0),
      (VUINT32) ((0xbfc2266f190a5acbuLL) >> 32)},
     {(VUINT32) ((0xbfc25ded0abc6ad2uLL) >> 0),
      (VUINT32) ((0xbfc25ded0abc6ad2uLL) >> 32)},
     {(VUINT32) ((0xbfc29552f81ff523uLL) >> 0),
      (VUINT32) ((0xbfc29552f81ff523uLL) >> 32)},
     {(VUINT32) ((0xbfc2cca0f5f5f251uLL) >> 0),
      (VUINT32) ((0xbfc2cca0f5f5f251uLL) >> 32)},
     {(VUINT32) ((0xbfc303d718e47fd3uLL) >> 0),
      (VUINT32) ((0xbfc303d718e47fd3uLL) >> 32)},
     {(VUINT32) ((0xbfc33af575770e4fuLL) >> 0),
      (VUINT32) ((0xbfc33af575770e4fuLL) >> 32)},
     {(VUINT32) ((0xbfc371fc201e8f74uLL) >> 0),
      (VUINT32) ((0xbfc371fc201e8f74uLL) >> 32)},
     {(VUINT32) ((0xbfc3a8eb2d31a376uLL) >> 0),
      (VUINT32) ((0xbfc3a8eb2d31a376uLL) >> 32)},
     {(VUINT32) ((0xbfc3dfc2b0ecc62auLL) >> 0),
      (VUINT32) ((0xbfc3dfc2b0ecc62auLL) >> 32)},
     {(VUINT32) ((0xbfc41682bf727bc0uLL) >> 0),
      (VUINT32) ((0xbfc41682bf727bc0uLL) >> 32)},
     {(VUINT32) ((0xbfc44d2b6ccb7d1euLL) >> 0),
      (VUINT32) ((0xbfc44d2b6ccb7d1euLL) >> 32)},
     {(VUINT32) ((0xbfc483bccce6e3dduLL) >> 0),
      (VUINT32) ((0xbfc483bccce6e3dduLL) >> 32)},
     {(VUINT32) ((0xbfc4ba36f39a55e5uLL) >> 0),
      (VUINT32) ((0xbfc4ba36f39a55e5uLL) >> 32)},
     {(VUINT32) ((0xbfc4f099f4a230b2uLL) >> 0),
      (VUINT32) ((0xbfc4f099f4a230b2uLL) >> 32)},
     {(VUINT32) ((0xbfc526e5e3a1b438uLL) >> 0),
      (VUINT32) ((0xbfc526e5e3a1b438uLL) >> 32)},
     {(VUINT32) ((0xbfc55d1ad4232d6fuLL) >> 0),
      (VUINT32) ((0xbfc55d1ad4232d6fuLL) >> 32)},
     {(VUINT32) ((0xbfc59338d9982086uLL) >> 0),
      (VUINT32) ((0xbfc59338d9982086uLL) >> 32)},
     {(VUINT32) ((0xbfc5c940075972b9uLL) >> 0),
      (VUINT32) ((0xbfc5c940075972b9uLL) >> 32)},
     {(VUINT32) ((0xbfc5ff3070a793d4uLL) >> 0),
      (VUINT32) ((0xbfc5ff3070a793d4uLL) >> 32)},
     {(VUINT32) ((0xbfc6350a28aaa758uLL) >> 0),
      (VUINT32) ((0xbfc6350a28aaa758uLL) >> 32)},
     {(VUINT32) ((0xbfc66acd4272ad51uLL) >> 0),
      (VUINT32) ((0xbfc66acd4272ad51uLL) >> 32)},
     {(VUINT32) ((0xbfc6a079d0f7aad2uLL) >> 0),
      (VUINT32) ((0xbfc6a079d0f7aad2uLL) >> 32)},
     {(VUINT32) ((0xbfc6d60fe719d21duLL) >> 0),
      (VUINT32) ((0xbfc6d60fe719d21duLL) >> 32)},
     {(VUINT32) ((0xbfc70b8f97a1aa75uLL) >> 0),
      (VUINT32) ((0xbfc70b8f97a1aa75uLL) >> 32)},
     {(VUINT32) ((0xbfc740f8f54037a5uLL) >> 0),
      (VUINT32) ((0xbfc740f8f54037a5uLL) >> 32)},
     {(VUINT32) ((0xbfc7764c128f2127uLL) >> 0),
      (VUINT32) ((0xbfc7764c128f2127uLL) >> 32)},
     {(VUINT32) ((0xbfc7ab890210d909uLL) >> 0),
      (VUINT32) ((0xbfc7ab890210d909uLL) >> 32)},
     {(VUINT32) ((0xbfc7e0afd630c274uLL) >> 0),
      (VUINT32) ((0xbfc7e0afd630c274uLL) >> 32)},
     {(VUINT32) ((0xbfc815c0a14357ebuLL) >> 0),
      (VUINT32) ((0xbfc815c0a14357ebuLL) >> 32)},
     {(VUINT32) ((0xbfc84abb75865139uLL) >> 0),
      (VUINT32) ((0xbfc84abb75865139uLL) >> 32)},
     {(VUINT32) ((0xbfc87fa06520c911uLL) >> 0),
      (VUINT32) ((0xbfc87fa06520c911uLL) >> 32)},
     {(VUINT32) ((0xbfc8b46f8223625buLL) >> 0),
      (VUINT32) ((0xbfc8b46f8223625buLL) >> 32)},
     {(VUINT32) ((0xbfc8e928de886d41uLL) >> 0),
      (VUINT32) ((0xbfc8e928de886d41uLL) >> 32)},
     {(VUINT32) ((0xbfc91dcc8c340bdeuLL) >> 0),
      (VUINT32) ((0xbfc91dcc8c340bdeuLL) >> 32)},
     {(VUINT32) ((0xbfc9525a9cf456b4uLL) >> 0),
      (VUINT32) ((0xbfc9525a9cf456b4uLL) >> 32)},
     {(VUINT32) ((0xbfc986d3228180cauLL) >> 0),
      (VUINT32) ((0xbfc986d3228180cauLL) >> 32)},
     {(VUINT32) ((0xbfc9bb362e7dfb83uLL) >> 0),
      (VUINT32) ((0xbfc9bb362e7dfb83uLL) >> 32)},
     {(VUINT32) ((0xbfc9ef83d2769a34uLL) >> 0),
      (VUINT32) ((0xbfc9ef83d2769a34uLL) >> 32)},
     {(VUINT32) ((0xbfca23bc1fe2b563uLL) >> 0),
      (VUINT32) ((0xbfca23bc1fe2b563uLL) >> 32)},
     {(VUINT32) ((0xbfca57df28244dcduLL) >> 0),
      (VUINT32) ((0xbfca57df28244dcduLL) >> 32)},
     {(VUINT32) ((0xbfca8becfc882f19uLL) >> 0),
      (VUINT32) ((0xbfca8becfc882f19uLL) >> 32)},
     {(VUINT32) ((0xbfcabfe5ae46124cuLL) >> 0),
      (VUINT32) ((0xbfcabfe5ae46124cuLL) >> 32)},
     {(VUINT32) ((0xbfcaf3c94e80bff3uLL) >> 0),
      (VUINT32) ((0xbfcaf3c94e80bff3uLL) >> 32)},
     {(VUINT32) ((0xbfcb2797ee46320cuLL) >> 0),
      (VUINT32) ((0xbfcb2797ee46320cuLL) >> 32)},
     {(VUINT32) ((0xbfcb5b519e8fb5a4uLL) >> 0),
      (VUINT32) ((0xbfcb5b519e8fb5a4uLL) >> 32)},
     {(VUINT32) ((0xbfcb8ef670420c3buLL) >> 0),
      (VUINT32) ((0xbfcb8ef670420c3buLL) >> 32)},
     {(VUINT32) ((0xbfcbc286742d8cd6uLL) >> 0),
      (VUINT32) ((0xbfcbc286742d8cd6uLL) >> 32)},
     {(VUINT32) ((0xbfcbf601bb0e44e2uLL) >> 0),
      (VUINT32) ((0xbfcbf601bb0e44e2uLL) >> 32)},
     {(VUINT32) ((0xbfcc2968558c18c1uLL) >> 0),
      (VUINT32) ((0xbfcc2968558c18c1uLL) >> 32)},
     {(VUINT32) ((0xbfcc5cba543ae425uLL) >> 0),
      (VUINT32) ((0xbfcc5cba543ae425uLL) >> 32)},
     {(VUINT32) ((0xbfcc8ff7c79a9a22uLL) >> 0),
      (VUINT32) ((0xbfcc8ff7c79a9a22uLL) >> 32)},
     {(VUINT32) ((0xbfccc320c0176502uLL) >> 0),
      (VUINT32) ((0xbfccc320c0176502uLL) >> 32)},
     {(VUINT32) ((0xbfccf6354e09c5dcuLL) >> 0),
      (VUINT32) ((0xbfccf6354e09c5dcuLL) >> 32)},
     {(VUINT32) ((0xbfcd293581b6b3e7uLL) >> 0),
      (VUINT32) ((0xbfcd293581b6b3e7uLL) >> 32)},
     {(VUINT32) ((0xbfcd5c216b4fbb91uLL) >> 0),
      (VUINT32) ((0xbfcd5c216b4fbb91uLL) >> 32)},
     {(VUINT32) ((0xbfcd8ef91af31d5euLL) >> 0),
      (VUINT32) ((0xbfcd8ef91af31d5euLL) >> 32)},
     {(VUINT32) ((0xbfcdc1bca0abec7duLL) >> 0),
      (VUINT32) ((0xbfcdc1bca0abec7duLL) >> 32)},
     {(VUINT32) ((0xbfcdf46c0c722d2fuLL) >> 0),
      (VUINT32) ((0xbfcdf46c0c722d2fuLL) >> 32)},
     {(VUINT32) ((0xbfce27076e2af2e6uLL) >> 0),
      (VUINT32) ((0xbfce27076e2af2e6uLL) >> 32)},
     {(VUINT32) ((0xbfce598ed5a87e2fuLL) >> 0),
      (VUINT32) ((0xbfce598ed5a87e2fuLL) >> 32)},
     {(VUINT32) ((0xbfce8c0252aa5a60uLL) >> 0),
      (VUINT32) ((0xbfce8c0252aa5a60uLL) >> 32)},
     {(VUINT32) ((0xbfcebe61f4dd7b0buLL) >> 0),
      (VUINT32) ((0xbfcebe61f4dd7b0buLL) >> 32)},
     {(VUINT32) ((0xbfcef0adcbdc5936uLL) >> 0),
      (VUINT32) ((0xbfcef0adcbdc5936uLL) >> 32)},
     {(VUINT32) ((0xbfcf22e5e72f105duLL) >> 0),
      (VUINT32) ((0xbfcf22e5e72f105duLL) >> 32)},
     {(VUINT32) ((0xbfcf550a564b7b37uLL) >> 0),
      (VUINT32) ((0xbfcf550a564b7b37uLL) >> 32)},
     {(VUINT32) ((0xbfcf871b28955045uLL) >> 0),
      (VUINT32) ((0xbfcf871b28955045uLL) >> 32)},
     {(VUINT32) ((0xbfcfb9186d5e3e2buLL) >> 0),
      (VUINT32) ((0xbfcfb9186d5e3e2buLL) >> 32)},
     {(VUINT32) ((0xbfcfeb0233e607ccuLL) >> 0),
      (VUINT32) ((0xbfcfeb0233e607ccuLL) >> 32)},
     {(VUINT32) ((0xbfd00e6c45ad501duLL) >> 0),
      (VUINT32) ((0xbfd00e6c45ad501duLL) >> 32)},
     {(VUINT32) ((0xbfd0274dc16c232fuLL) >> 0),
      (VUINT32) ((0xbfd0274dc16c232fuLL) >> 32)},
     {(VUINT32) ((0xbfd0402594b4d041uLL) >> 0),
      (VUINT32) ((0xbfd0402594b4d041uLL) >> 32)},
     {(VUINT32) ((0xbfd058f3c703ebc6uLL) >> 0),
      (VUINT32) ((0xbfd058f3c703ebc6uLL) >> 32)},
     {(VUINT32) ((0xbfd071b85fcd590duLL) >> 0),
      (VUINT32) ((0xbfd071b85fcd590duLL) >> 32)},
     {(VUINT32) ((0xbfd08a73667c57afuLL) >> 0),
      (VUINT32) ((0xbfd08a73667c57afuLL) >> 32)},
     {(VUINT32) ((0xbfd0a324e27390e3uLL) >> 0),
      (VUINT32) ((0xbfd0a324e27390e3uLL) >> 32)},
     {(VUINT32) ((0xbfd0bbccdb0d24bduLL) >> 0),
      (VUINT32) ((0xbfd0bbccdb0d24bduLL) >> 32)},
     {(VUINT32) ((0xbfd0d46b579ab74buLL) >> 0),
      (VUINT32) ((0xbfd0d46b579ab74buLL) >> 32)},
     {(VUINT32) ((0xbfd0ed005f657da4uLL) >> 0),
      (VUINT32) ((0xbfd0ed005f657da4uLL) >> 32)},
     {(VUINT32) ((0xbfd1058bf9ae4ad5uLL) >> 0),
      (VUINT32) ((0xbfd1058bf9ae4ad5uLL) >> 32)},
     {(VUINT32) ((0xbfd11e0e2dad9cb7uLL) >> 0),
      (VUINT32) ((0xbfd11e0e2dad9cb7uLL) >> 32)},
     {(VUINT32) ((0xbfd136870293a8b0uLL) >> 0),
      (VUINT32) ((0xbfd136870293a8b0uLL) >> 32)},
     {(VUINT32) ((0xbfd14ef67f88685auLL) >> 0),
      (VUINT32) ((0xbfd14ef67f88685auLL) >> 32)},
     {(VUINT32) ((0xbfd1675cababa60euLL) >> 0),
      (VUINT32) ((0xbfd1675cababa60euLL) >> 32)},
     {(VUINT32) ((0xbfd17fb98e15095duLL) >> 0),
      (VUINT32) ((0xbfd17fb98e15095duLL) >> 32)},
     {(VUINT32) ((0xbfd1980d2dd4236fuLL) >> 0),
      (VUINT32) ((0xbfd1980d2dd4236fuLL) >> 32)},
     {(VUINT32) ((0xbfd1b05791f07b49uLL) >> 0),
      (VUINT32) ((0xbfd1b05791f07b49uLL) >> 32)},
     {(VUINT32) ((0xbfd1c898c16999fbuLL) >> 0),
      (VUINT32) ((0xbfd1c898c16999fbuLL) >> 32)},
     {(VUINT32) ((0xbfd1e0d0c33716beuLL) >> 0),
      (VUINT32) ((0xbfd1e0d0c33716beuLL) >> 32)},
     {(VUINT32) ((0xbfd1f8ff9e48a2f3uLL) >> 0),
      (VUINT32) ((0xbfd1f8ff9e48a2f3uLL) >> 32)},
     {(VUINT32) ((0xbfd211255986160cuLL) >> 0),
      (VUINT32) ((0xbfd211255986160cuLL) >> 32)},
     {(VUINT32) ((0xbfd22941fbcf7966uLL) >> 0),
      (VUINT32) ((0xbfd22941fbcf7966uLL) >> 32)},
     {(VUINT32) ((0xbfd241558bfd1404uLL) >> 0),
      (VUINT32) ((0xbfd241558bfd1404uLL) >> 32)},
     {(VUINT32) ((0xbfd2596010df763auLL) >> 0),
      (VUINT32) ((0xbfd2596010df763auLL) >> 32)},
     {(VUINT32) ((0xbfd27161913f853duLL) >> 0),
      (VUINT32) ((0xbfd27161913f853duLL) >> 32)},
     {(VUINT32) ((0xbfd2895a13de86a3uLL) >> 0),
      (VUINT32) ((0xbfd2895a13de86a3uLL) >> 32)},
     {(VUINT32) ((0xbfd2a1499f762bc9uLL) >> 0),
      (VUINT32) ((0xbfd2a1499f762bc9uLL) >> 32)},
     {(VUINT32) ((0xbfd2b9303ab89d25uLL) >> 0),
      (VUINT32) ((0xbfd2b9303ab89d25uLL) >> 32)},
     {(VUINT32) ((0xbfd2d10dec508583uLL) >> 0),
      (VUINT32) ((0xbfd2d10dec508583uLL) >> 32)},
     {(VUINT32) ((0xbfd2e8e2bae11d31uLL) >> 0),
      (VUINT32) ((0xbfd2e8e2bae11d31uLL) >> 32)},
     {(VUINT32) ((0xbfd300aead06350cuLL) >> 0),
      (VUINT32) ((0xbfd300aead06350cuLL) >> 32)},
     {(VUINT32) ((0xbfd31871c9544185uLL) >> 0),
      (VUINT32) ((0xbfd31871c9544185uLL) >> 32)},
     {(VUINT32) ((0xbfd3302c16586588uLL) >> 0),
      (VUINT32) ((0xbfd3302c16586588uLL) >> 32)},
     {(VUINT32) ((0xbfd347dd9a987d55uLL) >> 0),
      (VUINT32) ((0xbfd347dd9a987d55uLL) >> 32)},
     {(VUINT32) ((0xbfd35f865c93293euLL) >> 0),
      (VUINT32) ((0xbfd35f865c93293euLL) >> 32)},
     {(VUINT32) ((0xbfd3772662bfd85buLL) >> 0),
      (VUINT32) ((0xbfd3772662bfd85buLL) >> 32)},
     {(VUINT32) ((0xbfd38ebdb38ed321uLL) >> 0),
      (VUINT32) ((0xbfd38ebdb38ed321uLL) >> 32)},
     {(VUINT32) ((0xbfd3a64c556945eauLL) >> 0),
      (VUINT32) ((0xbfd3a64c556945eauLL) >> 32)},
     {(VUINT32) ((0xbfd3bdd24eb14b6auLL) >> 0),
      (VUINT32) ((0xbfd3bdd24eb14b6auLL) >> 32)},
     {(VUINT32) ((0xbfd3d54fa5c1f710uLL) >> 0),
      (VUINT32) ((0xbfd3d54fa5c1f710uLL) >> 32)},
     {(VUINT32) ((0xbfd3ecc460ef5f50uLL) >> 0),
      (VUINT32) ((0xbfd3ecc460ef5f50uLL) >> 32)},
     {(VUINT32) ((0xbfd404308686a7e4uLL) >> 0),
      (VUINT32) ((0xbfd404308686a7e4uLL) >> 32)},
     {(VUINT32) ((0xbfd41b941cce0beeuLL) >> 0),
      (VUINT32) ((0xbfd41b941cce0beeuLL) >> 32)},
     {(VUINT32) ((0xbfd432ef2a04e814uLL) >> 0),
      (VUINT32) ((0xbfd432ef2a04e814uLL) >> 32)},
     {(VUINT32) ((0xbfd44a41b463c47cuLL) >> 0),
      (VUINT32) ((0xbfd44a41b463c47cuLL) >> 32)},
     {(VUINT32) ((0xbfd4618bc21c5ec2uLL) >> 0),
      (VUINT32) ((0xbfd4618bc21c5ec2uLL) >> 32)},
     {(VUINT32) ((0xbfd478cd5959b3d9uLL) >> 0),
      (VUINT32) ((0xbfd478cd5959b3d9uLL) >> 32)},
     {(VUINT32) ((0xbfd49006804009d1uLL) >> 0),
      (VUINT32) ((0xbfd49006804009d1uLL) >> 32)},
     {(VUINT32) ((0xbfd4a7373cecf997uLL) >> 0),
      (VUINT32) ((0xbfd4a7373cecf997uLL) >> 32)},
     {(VUINT32) ((0xbfd4be5f957778a1uLL) >> 0),
      (VUINT32) ((0xbfd4be5f957778a1uLL) >> 32)},
     {(VUINT32) ((0xbfd4d57f8fefe27fuLL) >> 0),
      (VUINT32) ((0xbfd4d57f8fefe27fuLL) >> 32)},
     {(VUINT32) ((0xbfd4ec973260026auLL) >> 0),
      (VUINT32) ((0xbfd4ec973260026auLL) >> 32)},
     {(VUINT32) ((0xbfd503a682cb1cb3uLL) >> 0),
      (VUINT32) ((0xbfd503a682cb1cb3uLL) >> 32)},
     {(VUINT32) ((0xbfd51aad872df82duLL) >> 0),
      (VUINT32) ((0xbfd51aad872df82duLL) >> 32)},
     {(VUINT32) ((0xbfd531ac457ee77euLL) >> 0),
      (VUINT32) ((0xbfd531ac457ee77euLL) >> 32)},
     {(VUINT32) ((0xbfd548a2c3add263uLL) >> 0),
      (VUINT32) ((0xbfd548a2c3add263uLL) >> 32)},
     {(VUINT32) ((0xbfd55f9107a43ee2uLL) >> 0),
      (VUINT32) ((0xbfd55f9107a43ee2uLL) >> 32)},
     {(VUINT32) ((0xbfd5767717455a6cuLL) >> 0),
      (VUINT32) ((0xbfd5767717455a6cuLL) >> 32)},
     {(VUINT32) ((0xbfd58d54f86e02f2uLL) >> 0),
      (VUINT32) ((0xbfd58d54f86e02f2uLL) >> 32)},
     {(VUINT32) ((0xbfd5a42ab0f4cfe2uLL) >> 0),
      (VUINT32) ((0xbfd5a42ab0f4cfe2uLL) >> 32)},
     {(VUINT32) ((0xbfd5baf846aa1b19uLL) >> 0),
      (VUINT32) ((0xbfd5baf846aa1b19uLL) >> 32)},
     {(VUINT32) ((0xbfd5d1bdbf5809cauLL) >> 0),
      (VUINT32) ((0xbfd5d1bdbf5809cauLL) >> 32)},
     {(VUINT32) ((0xbfd5e87b20c2954auLL) >> 0),
      (VUINT32) ((0xbfd5e87b20c2954auLL) >> 32)},
     {(VUINT32) ((0xbfd5ff3070a793d4uLL) >> 0),
      (VUINT32) ((0xbfd5ff3070a793d4uLL) >> 32)},
     {(VUINT32) ((0xbfd615ddb4bec13cuLL) >> 0),
      (VUINT32) ((0xbfd615ddb4bec13cuLL) >> 32)},
     {(VUINT32) ((0xbfd62c82f2b9c795uLL) >> 0),
      (VUINT32) ((0xbfd62c82f2b9c795uLL) >> 32)},
     {(VUINT32) ((0x3fd61965cdb02c1fuLL) >> 0),
      (VUINT32) ((0x3fd61965cdb02c1fuLL) >> 32)},
     {(VUINT32) ((0x3fd602d08af091ecuLL) >> 0),
      (VUINT32) ((0x3fd602d08af091ecuLL) >> 32)},
     {(VUINT32) ((0x3fd5ec433d5c35aeuLL) >> 0),
      (VUINT32) ((0x3fd5ec433d5c35aeuLL) >> 32)},
     {(VUINT32) ((0x3fd5d5bddf595f30uLL) >> 0),
      (VUINT32) ((0x3fd5d5bddf595f30uLL) >> 32)},
     {(VUINT32) ((0x3fd5bf406b543db2uLL) >> 0),
      (VUINT32) ((0x3fd5bf406b543db2uLL) >> 32)},
     {(VUINT32) ((0x3fd5a8cadbbedfa1uLL) >> 0),
      (VUINT32) ((0x3fd5a8cadbbedfa1uLL) >> 32)},
     {(VUINT32) ((0x3fd5925d2b112a59uLL) >> 0),
      (VUINT32) ((0x3fd5925d2b112a59uLL) >> 32)},
     {(VUINT32) ((0x3fd57bf753c8d1fbuLL) >> 0),
      (VUINT32) ((0x3fd57bf753c8d1fbuLL) >> 32)},
     {(VUINT32) ((0x3fd565995069514cuLL) >> 0),
      (VUINT32) ((0x3fd565995069514cuLL) >> 32)},
     {(VUINT32) ((0x3fd54f431b7be1a9uLL) >> 0),
      (VUINT32) ((0x3fd54f431b7be1a9uLL) >> 32)},
     {(VUINT32) ((0x3fd538f4af8f72feuLL) >> 0),
      (VUINT32) ((0x3fd538f4af8f72feuLL) >> 32)},
     {(VUINT32) ((0x3fd522ae0738a3d8uLL) >> 0),
      (VUINT32) ((0x3fd522ae0738a3d8uLL) >> 32)},
     {(VUINT32) ((0x3fd50c6f1d11b97cuLL) >> 0),
      (VUINT32) ((0x3fd50c6f1d11b97cuLL) >> 32)},
     {(VUINT32) ((0x3fd4f637ebba9810uLL) >> 0),
      (VUINT32) ((0x3fd4f637ebba9810uLL) >> 32)},
     {(VUINT32) ((0x3fd4e0086dd8bacauLL) >> 0),
      (VUINT32) ((0x3fd4e0086dd8bacauLL) >> 32)},
     {(VUINT32) ((0x3fd4c9e09e172c3cuLL) >> 0),
      (VUINT32) ((0x3fd4c9e09e172c3cuLL) >> 32)},
     {(VUINT32) ((0x3fd4b3c077267e9auLL) >> 0),
      (VUINT32) ((0x3fd4b3c077267e9auLL) >> 32)},
     {(VUINT32) ((0x3fd49da7f3bcc41fuLL) >> 0),
      (VUINT32) ((0x3fd49da7f3bcc41fuLL) >> 32)},
     {(VUINT32) ((0x3fd487970e958770uLL) >> 0),
      (VUINT32) ((0x3fd487970e958770uLL) >> 32)},
     {(VUINT32) ((0x3fd4718dc271c41buLL) >> 0),
      (VUINT32) ((0x3fd4718dc271c41buLL) >> 32)},
     {(VUINT32) ((0x3fd45b8c0a17df13uLL) >> 0),
      (VUINT32) ((0x3fd45b8c0a17df13uLL) >> 32)},
     {(VUINT32) ((0x3fd44591e0539f49uLL) >> 0),
      (VUINT32) ((0x3fd44591e0539f49uLL) >> 32)},
     {(VUINT32) ((0x3fd42f9f3ff62642uLL) >> 0),
      (VUINT32) ((0x3fd42f9f3ff62642uLL) >> 32)},
     {(VUINT32) ((0x3fd419b423d5e8c7uLL) >> 0),
      (VUINT32) ((0x3fd419b423d5e8c7uLL) >> 32)},
     {(VUINT32) ((0x3fd403d086cea79cuLL) >> 0),
      (VUINT32) ((0x3fd403d086cea79cuLL) >> 32)},
     {(VUINT32) ((0x3fd3edf463c1683euLL) >> 0),
      (VUINT32) ((0x3fd3edf463c1683euLL) >> 32)},
     {(VUINT32) ((0x3fd3d81fb5946dbauLL) >> 0),
      (VUINT32) ((0x3fd3d81fb5946dbauLL) >> 32)},
     {(VUINT32) ((0x3fd3c25277333184uLL) >> 0),
      (VUINT32) ((0x3fd3c25277333184uLL) >> 32)},
     {(VUINT32) ((0x3fd3ac8ca38e5c5fuLL) >> 0),
      (VUINT32) ((0x3fd3ac8ca38e5c5fuLL) >> 32)},
     {(VUINT32) ((0x3fd396ce359bbf54uLL) >> 0),
      (VUINT32) ((0x3fd396ce359bbf54uLL) >> 32)},
     {(VUINT32) ((0x3fd3811728564cb2uLL) >> 0),
      (VUINT32) ((0x3fd3811728564cb2uLL) >> 32)},
     {(VUINT32) ((0x3fd36b6776be1117uLL) >> 0),
      (VUINT32) ((0x3fd36b6776be1117uLL) >> 32)},
     {(VUINT32) ((0x3fd355bf1bd82c8buLL) >> 0),
      (VUINT32) ((0x3fd355bf1bd82c8buLL) >> 32)},
     {(VUINT32) ((0x3fd3401e12aecba1uLL) >> 0),
      (VUINT32) ((0x3fd3401e12aecba1uLL) >> 32)},
     {(VUINT32) ((0x3fd32a84565120a8uLL) >> 0),
      (VUINT32) ((0x3fd32a84565120a8uLL) >> 32)},
     {(VUINT32) ((0x3fd314f1e1d35ce4uLL) >> 0),
      (VUINT32) ((0x3fd314f1e1d35ce4uLL) >> 32)},
     {(VUINT32) ((0x3fd2ff66b04ea9d4uLL) >> 0),
      (VUINT32) ((0x3fd2ff66b04ea9d4uLL) >> 32)},
     {(VUINT32) ((0x3fd2e9e2bce12286uLL) >> 0),
      (VUINT32) ((0x3fd2e9e2bce12286uLL) >> 32)},
     {(VUINT32) ((0x3fd2d46602adcceeuLL) >> 0),
      (VUINT32) ((0x3fd2d46602adcceeuLL) >> 32)},
     {(VUINT32) ((0x3fd2bef07cdc9354uLL) >> 0),
      (VUINT32) ((0x3fd2bef07cdc9354uLL) >> 32)},
     {(VUINT32) ((0x3fd2a982269a3dbfuLL) >> 0),
      (VUINT32) ((0x3fd2a982269a3dbfuLL) >> 32)},
     {(VUINT32) ((0x3fd2941afb186b7cuLL) >> 0),
      (VUINT32) ((0x3fd2941afb186b7cuLL) >> 32)},
     {(VUINT32) ((0x3fd27ebaf58d8c9duLL) >> 0),
      (VUINT32) ((0x3fd27ebaf58d8c9duLL) >> 32)},
     {(VUINT32) ((0x3fd269621134db92uLL) >> 0),
      (VUINT32) ((0x3fd269621134db92uLL) >> 32)},
     {(VUINT32) ((0x3fd25410494e56c7uLL) >> 0),
      (VUINT32) ((0x3fd25410494e56c7uLL) >> 32)},
     {(VUINT32) ((0x3fd23ec5991eba49uLL) >> 0),
      (VUINT32) ((0x3fd23ec5991eba49uLL) >> 32)},
     {(VUINT32) ((0x3fd22981fbef797buLL) >> 0),
      (VUINT32) ((0x3fd22981fbef797buLL) >> 32)},
     {(VUINT32) ((0x3fd214456d0eb8d4uLL) >> 0),
      (VUINT32) ((0x3fd214456d0eb8d4uLL) >> 32)},
     {(VUINT32) ((0x3fd1ff0fe7cf47a7uLL) >> 0),
      (VUINT32) ((0x3fd1ff0fe7cf47a7uLL) >> 32)},
     {(VUINT32) ((0x3fd1e9e1678899f4uLL) >> 0),
      (VUINT32) ((0x3fd1e9e1678899f4uLL) >> 32)},
     {(VUINT32) ((0x3fd1d4b9e796c245uLL) >> 0),
      (VUINT32) ((0x3fd1d4b9e796c245uLL) >> 32)},
     {(VUINT32) ((0x3fd1bf99635a6b95uLL) >> 0),
      (VUINT32) ((0x3fd1bf99635a6b95uLL) >> 32)},
     {(VUINT32) ((0x3fd1aa7fd638d33fuLL) >> 0),
      (VUINT32) ((0x3fd1aa7fd638d33fuLL) >> 32)},
     {(VUINT32) ((0x3fd1956d3b9bc2fauLL) >> 0),
      (VUINT32) ((0x3fd1956d3b9bc2fauLL) >> 32)},
     {(VUINT32) ((0x3fd180618ef18adfuLL) >> 0),
      (VUINT32) ((0x3fd180618ef18adfuLL) >> 32)},
     {(VUINT32) ((0x3fd16b5ccbacfb73uLL) >> 0),
      (VUINT32) ((0x3fd16b5ccbacfb73uLL) >> 32)},
     {(VUINT32) ((0x3fd1565eed455fc3uLL) >> 0),
      (VUINT32) ((0x3fd1565eed455fc3uLL) >> 32)},
     {(VUINT32) ((0x3fd14167ef367783uLL) >> 0),
      (VUINT32) ((0x3fd14167ef367783uLL) >> 32)},
     {(VUINT32) ((0x3fd12c77cd00713buLL) >> 0),
      (VUINT32) ((0x3fd12c77cd00713buLL) >> 32)},
     {(VUINT32) ((0x3fd1178e8227e47cuLL) >> 0),
      (VUINT32) ((0x3fd1178e8227e47cuLL) >> 32)},
     {(VUINT32) ((0x3fd102ac0a35cc1cuLL) >> 0),
      (VUINT32) ((0x3fd102ac0a35cc1cuLL) >> 32)},
     {(VUINT32) ((0x3fd0edd060b78081uLL) >> 0),
      (VUINT32) ((0x3fd0edd060b78081uLL) >> 32)},
     {(VUINT32) ((0x3fd0d8fb813eb1efuLL) >> 0),
      (VUINT32) ((0x3fd0d8fb813eb1efuLL) >> 32)},
     {(VUINT32) ((0x3fd0c42d676162e3uLL) >> 0),
      (VUINT32) ((0x3fd0c42d676162e3uLL) >> 32)},
     {(VUINT32) ((0x3fd0af660eb9e279uLL) >> 0),
      (VUINT32) ((0x3fd0af660eb9e279uLL) >> 32)},
     {(VUINT32) ((0x3fd09aa572e6c6d4uLL) >> 0),
      (VUINT32) ((0x3fd09aa572e6c6d4uLL) >> 32)},
     {(VUINT32) ((0x3fd085eb8f8ae797uLL) >> 0),
      (VUINT32) ((0x3fd085eb8f8ae797uLL) >> 32)},
     {(VUINT32) ((0x3fd07138604d5862uLL) >> 0),
      (VUINT32) ((0x3fd07138604d5862uLL) >> 32)},
     {(VUINT32) ((0x3fd05c8be0d9635auLL) >> 0),
      (VUINT32) ((0x3fd05c8be0d9635auLL) >> 32)},
     {(VUINT32) ((0x3fd047e60cde83b8uLL) >> 0),
      (VUINT32) ((0x3fd047e60cde83b8uLL) >> 32)},
     {(VUINT32) ((0x3fd03346e0106062uLL) >> 0),
      (VUINT32) ((0x3fd03346e0106062uLL) >> 32)},
     {(VUINT32) ((0x3fd01eae5626c691uLL) >> 0),
      (VUINT32) ((0x3fd01eae5626c691uLL) >> 32)},
     {(VUINT32) ((0x3fd00a1c6adda473uLL) >> 0),
      (VUINT32) ((0x3fd00a1c6adda473uLL) >> 32)},
     {(VUINT32) ((0x3fcfeb2233ea07cduLL) >> 0),
      (VUINT32) ((0x3fcfeb2233ea07cduLL) >> 32)},
     {(VUINT32) ((0x3fcfc218be620a5euLL) >> 0),
      (VUINT32) ((0x3fcfc218be620a5euLL) >> 32)},
     {(VUINT32) ((0x3fcf991c6cb3b379uLL) >> 0),
      (VUINT32) ((0x3fcf991c6cb3b379uLL) >> 32)},
     {(VUINT32) ((0x3fcf702d36777df0uLL) >> 0),
      (VUINT32) ((0x3fcf702d36777df0uLL) >> 32)},
     {(VUINT32) ((0x3fcf474b134df229uLL) >> 0),
      (VUINT32) ((0x3fcf474b134df229uLL) >> 32)},
     {(VUINT32) ((0x3fcf1e75fadf9bdeuLL) >> 0),
      (VUINT32) ((0x3fcf1e75fadf9bdeuLL) >> 32)},
     {(VUINT32) ((0x3fcef5ade4dcffe6uLL) >> 0),
      (VUINT32) ((0x3fcef5ade4dcffe6uLL) >> 32)},
     {(VUINT32) ((0x3fceccf2c8fe920auLL) >> 0),
      (VUINT32) ((0x3fceccf2c8fe920auLL) >> 32)},
     {(VUINT32) ((0x3fcea4449f04aaf5uLL) >> 0),
      (VUINT32) ((0x3fcea4449f04aaf5uLL) >> 32)},
     {(VUINT32) ((0x3fce7ba35eb77e2auLL) >> 0),
      (VUINT32) ((0x3fce7ba35eb77e2auLL) >> 32)},
     {(VUINT32) ((0x3fce530effe71012uLL) >> 0),
      (VUINT32) ((0x3fce530effe71012uLL) >> 32)},
     {(VUINT32) ((0x3fce2a877a6b2c12uLL) >> 0),
      (VUINT32) ((0x3fce2a877a6b2c12uLL) >> 32)},
     {(VUINT32) ((0x3fce020cc6235ab5uLL) >> 0),
      (VUINT32) ((0x3fce020cc6235ab5uLL) >> 32)},
     {(VUINT32) ((0x3fcdd99edaf6d7e9uLL) >> 0),
      (VUINT32) ((0x3fcdd99edaf6d7e9uLL) >> 32)},
     {(VUINT32) ((0x3fcdb13db0d48940uLL) >> 0),
      (VUINT32) ((0x3fcdb13db0d48940uLL) >> 32)},
     {(VUINT32) ((0x3fcd88e93fb2f450uLL) >> 0),
      (VUINT32) ((0x3fcd88e93fb2f450uLL) >> 32)},
     {(VUINT32) ((0x3fcd60a17f903515uLL) >> 0),
      (VUINT32) ((0x3fcd60a17f903515uLL) >> 32)},
     {(VUINT32) ((0x3fcd38666871f465uLL) >> 0),
      (VUINT32) ((0x3fcd38666871f465uLL) >> 32)},
     {(VUINT32) ((0x3fcd1037f2655e7buLL) >> 0),
      (VUINT32) ((0x3fcd1037f2655e7buLL) >> 32)},
     {(VUINT32) ((0x3fcce816157f1988uLL) >> 0),
      (VUINT32) ((0x3fcce816157f1988uLL) >> 32)},
     {(VUINT32) ((0x3fccc000c9db3c52uLL) >> 0),
      (VUINT32) ((0x3fccc000c9db3c52uLL) >> 32)},
     {(VUINT32) ((0x3fcc97f8079d44ecuLL) >> 0),
      (VUINT32) ((0x3fcc97f8079d44ecuLL) >> 32)},
     {(VUINT32) ((0x3fcc6ffbc6f00f71uLL) >> 0),
      (VUINT32) ((0x3fcc6ffbc6f00f71uLL) >> 32)},
     {(VUINT32) ((0x3fcc480c0005ccd1uLL) >> 0),
      (VUINT32) ((0x3fcc480c0005ccd1uLL) >> 32)},
     {(VUINT32) ((0x3fcc2028ab17f9b4uLL) >> 0),
      (VUINT32) ((0x3fcc2028ab17f9b4uLL) >> 32)},
     {(VUINT32) ((0x3fcbf851c067555fuLL) >> 0),
      (VUINT32) ((0x3fcbf851c067555fuLL) >> 32)},
     {(VUINT32) ((0x3fcbd087383bd8aduLL) >> 0),
      (VUINT32) ((0x3fcbd087383bd8aduLL) >> 32)},
     {(VUINT32) ((0x3fcba8c90ae4ad19uLL) >> 0),
      (VUINT32) ((0x3fcba8c90ae4ad19uLL) >> 32)},
     {(VUINT32) ((0x3fcb811730b823d2uLL) >> 0),
      (VUINT32) ((0x3fcb811730b823d2uLL) >> 32)},
     {(VUINT32) ((0x3fcb5971a213acdbuLL) >> 0),
      (VUINT32) ((0x3fcb5971a213acdbuLL) >> 32)},
     {(VUINT32) ((0x3fcb31d8575bce3duLL) >> 0),
      (VUINT32) ((0x3fcb31d8575bce3duLL) >> 32)},
     {(VUINT32) ((0x3fcb0a4b48fc1b46uLL) >> 0),
      (VUINT32) ((0x3fcb0a4b48fc1b46uLL) >> 32)},
     {(VUINT32) ((0x3fcae2ca6f672bd4uLL) >> 0),
      (VUINT32) ((0x3fcae2ca6f672bd4uLL) >> 32)},
     {(VUINT32) ((0x3fcabb55c31693aduLL) >> 0),
      (VUINT32) ((0x3fcabb55c31693aduLL) >> 32)},
     {(VUINT32) ((0x3fca93ed3c8ad9e3uLL) >> 0),
      (VUINT32) ((0x3fca93ed3c8ad9e3uLL) >> 32)},
     {(VUINT32) ((0x3fca6c90d44b704euLL) >> 0),
      (VUINT32) ((0x3fca6c90d44b704euLL) >> 32)},
     {(VUINT32) ((0x3fca454082e6ab05uLL) >> 0),
      (VUINT32) ((0x3fca454082e6ab05uLL) >> 32)},
     {(VUINT32) ((0x3fca1dfc40f1b7f1uLL) >> 0),
      (VUINT32) ((0x3fca1dfc40f1b7f1uLL) >> 32)},
     {(VUINT32) ((0x3fc9f6c407089664uLL) >> 0),
      (VUINT32) ((0x3fc9f6c407089664uLL) >> 32)},
     {(VUINT32) ((0x3fc9cf97cdce0ec3uLL) >> 0),
      (VUINT32) ((0x3fc9cf97cdce0ec3uLL) >> 32)},
     {(VUINT32) ((0x3fc9a8778debaa38uLL) >> 0),
      (VUINT32) ((0x3fc9a8778debaa38uLL) >> 32)},
     {(VUINT32) ((0x3fc981634011aa75uLL) >> 0),
      (VUINT32) ((0x3fc981634011aa75uLL) >> 32)},
     {(VUINT32) ((0x3fc95a5adcf7017fuLL) >> 0),
      (VUINT32) ((0x3fc95a5adcf7017fuLL) >> 32)},
     {(VUINT32) ((0x3fc9335e5d594989uLL) >> 0),
      (VUINT32) ((0x3fc9335e5d594989uLL) >> 32)},
     {(VUINT32) ((0x3fc90c6db9fcbcd9uLL) >> 0),
      (VUINT32) ((0x3fc90c6db9fcbcd9uLL) >> 32)},
     {(VUINT32) ((0x3fc8e588ebac2dbfuLL) >> 0),
      (VUINT32) ((0x3fc8e588ebac2dbfuLL) >> 32)},
     {(VUINT32) ((0x3fc8beafeb38fe8cuLL) >> 0),
      (VUINT32) ((0x3fc8beafeb38fe8cuLL) >> 32)},
     {(VUINT32) ((0x3fc897e2b17b19a5uLL) >> 0),
      (VUINT32) ((0x3fc897e2b17b19a5uLL) >> 32)},
     {(VUINT32) ((0x3fc871213750e994uLL) >> 0),
      (VUINT32) ((0x3fc871213750e994uLL) >> 32)},
     {(VUINT32) ((0x3fc84a6b759f512fuLL) >> 0),
      (VUINT32) ((0x3fc84a6b759f512fuLL) >> 32)},
     {(VUINT32) ((0x3fc823c16551a3c2uLL) >> 0),
      (VUINT32) ((0x3fc823c16551a3c2uLL) >> 32)},
     {(VUINT32) ((0x3fc7fd22ff599d4fuLL) >> 0),
      (VUINT32) ((0x3fc7fd22ff599d4fuLL) >> 32)},
     {(VUINT32) ((0x3fc7d6903caf5ad0uLL) >> 0),
      (VUINT32) ((0x3fc7d6903caf5ad0uLL) >> 32)},
     {(VUINT32) ((0x3fc7b0091651528cuLL) >> 0),
      (VUINT32) ((0x3fc7b0091651528cuLL) >> 32)},
     {(VUINT32) ((0x3fc7898d85444c73uLL) >> 0),
      (VUINT32) ((0x3fc7898d85444c73uLL) >> 32)},
     {(VUINT32) ((0x3fc7631d82935a86uLL) >> 0),
      (VUINT32) ((0x3fc7631d82935a86uLL) >> 32)},
     {(VUINT32) ((0x3fc73cb9074fd14duLL) >> 0),
      (VUINT32) ((0x3fc73cb9074fd14duLL) >> 32)},
     {(VUINT32) ((0x3fc716600c914054uLL) >> 0),
      (VUINT32) ((0x3fc716600c914054uLL) >> 32)},
     {(VUINT32) ((0x3fc6f0128b756abcuLL) >> 0),
      (VUINT32) ((0x3fc6f0128b756abcuLL) >> 32)},
     {(VUINT32) ((0x3fc6c9d07d203fc7uLL) >> 0),
      (VUINT32) ((0x3fc6c9d07d203fc7uLL) >> 32)},
     {(VUINT32) ((0x3fc6a399dabbd383uLL) >> 0),
      (VUINT32) ((0x3fc6a399dabbd383uLL) >> 32)},
     {(VUINT32) ((0x3fc67d6e9d785771uLL) >> 0),
      (VUINT32) ((0x3fc67d6e9d785771uLL) >> 32)},
     {(VUINT32) ((0x3fc6574ebe8c133auLL) >> 0),
      (VUINT32) ((0x3fc6574ebe8c133auLL) >> 32)},
     {(VUINT32) ((0x3fc6313a37335d76uLL) >> 0),
      (VUINT32) ((0x3fc6313a37335d76uLL) >> 32)},
     {(VUINT32) ((0x3fc60b3100b09476uLL) >> 0),
      (VUINT32) ((0x3fc60b3100b09476uLL) >> 32)},
     {(VUINT32) ((0x3fc5e533144c1719uLL) >> 0),
      (VUINT32) ((0x3fc5e533144c1719uLL) >> 32)},
     {(VUINT32) ((0x3fc5bf406b543db2uLL) >> 0),
      (VUINT32) ((0x3fc5bf406b543db2uLL) >> 32)},
     {(VUINT32) ((0x3fc59958ff1d52f1uLL) >> 0),
      (VUINT32) ((0x3fc59958ff1d52f1uLL) >> 32)},
     {(VUINT32) ((0x3fc5737cc9018cdduLL) >> 0),
      (VUINT32) ((0x3fc5737cc9018cdduLL) >> 32)},
     {(VUINT32) ((0x3fc54dabc26105d2uLL) >> 0),
      (VUINT32) ((0x3fc54dabc26105d2uLL) >> 32)},
     {(VUINT32) ((0x3fc527e5e4a1b58duLL) >> 0),
      (VUINT32) ((0x3fc527e5e4a1b58duLL) >> 32)},
     {(VUINT32) ((0x3fc5022b292f6a45uLL) >> 0),
      (VUINT32) ((0x3fc5022b292f6a45uLL) >> 32)},
     {(VUINT32) ((0x3fc4dc7b897bc1c8uLL) >> 0),
      (VUINT32) ((0x3fc4dc7b897bc1c8uLL) >> 32)},
     {(VUINT32) ((0x3fc4b6d6fefe22a4uLL) >> 0),
      (VUINT32) ((0x3fc4b6d6fefe22a4uLL) >> 32)},
     {(VUINT32) ((0x3fc4913d8333b561uLL) >> 0),
      (VUINT32) ((0x3fc4913d8333b561uLL) >> 32)},
     {(VUINT32) ((0x3fc46baf0f9f5db7uLL) >> 0),
      (VUINT32) ((0x3fc46baf0f9f5db7uLL) >> 32)},
     {(VUINT32) ((0x3fc4462b9dc9b3dcuLL) >> 0),
      (VUINT32) ((0x3fc4462b9dc9b3dcuLL) >> 32)},
     {(VUINT32) ((0x3fc420b32740fdd4uLL) >> 0),
      (VUINT32) ((0x3fc420b32740fdd4uLL) >> 32)},
     {(VUINT32) ((0x3fc3fb45a59928ccuLL) >> 0),
      (VUINT32) ((0x3fc3fb45a59928ccuLL) >> 32)},
     {(VUINT32) ((0x3fc3d5e3126bc27fuLL) >> 0),
      (VUINT32) ((0x3fc3d5e3126bc27fuLL) >> 32)},
     {(VUINT32) ((0x3fc3b08b6757f2a9uLL) >> 0),
      (VUINT32) ((0x3fc3b08b6757f2a9uLL) >> 32)},
     {(VUINT32) ((0x3fc38b3e9e027479uLL) >> 0),
      (VUINT32) ((0x3fc38b3e9e027479uLL) >> 32)},
     {(VUINT32) ((0x3fc365fcb0159016uLL) >> 0),
      (VUINT32) ((0x3fc365fcb0159016uLL) >> 32)},
     {(VUINT32) ((0x3fc340c59741142euLL) >> 0),
      (VUINT32) ((0x3fc340c59741142euLL) >> 32)},
     {(VUINT32) ((0x3fc31b994d3a4f85uLL) >> 0),
      (VUINT32) ((0x3fc31b994d3a4f85uLL) >> 32)},
     {(VUINT32) ((0x3fc2f677cbbc0a96uLL) >> 0),
      (VUINT32) ((0x3fc2f677cbbc0a96uLL) >> 32)},
     {(VUINT32) ((0x3fc2d1610c86813auLL) >> 0),
      (VUINT32) ((0x3fc2d1610c86813auLL) >> 32)},
     {(VUINT32) ((0x3fc2ac55095f5c59uLL) >> 0),
      (VUINT32) ((0x3fc2ac55095f5c59uLL) >> 32)},
     {(VUINT32) ((0x3fc28753bc11aba5uLL) >> 0),
      (VUINT32) ((0x3fc28753bc11aba5uLL) >> 32)},
     {(VUINT32) ((0x3fc2625d1e6ddf57uLL) >> 0),
      (VUINT32) ((0x3fc2625d1e6ddf57uLL) >> 32)},
     {(VUINT32) ((0x3fc23d712a49c202uLL) >> 0),
      (VUINT32) ((0x3fc23d712a49c202uLL) >> 32)},
     {(VUINT32) ((0x3fc2188fd9807263uLL) >> 0),
      (VUINT32) ((0x3fc2188fd9807263uLL) >> 32)},
     {(VUINT32) ((0x3fc1f3b925f25d41uLL) >> 0),
      (VUINT32) ((0x3fc1f3b925f25d41uLL) >> 32)},
     {(VUINT32) ((0x3fc1ceed09853752uLL) >> 0),
      (VUINT32) ((0x3fc1ceed09853752uLL) >> 32)},
     {(VUINT32) ((0x3fc1aa2b7e23f72auLL) >> 0),
      (VUINT32) ((0x3fc1aa2b7e23f72auLL) >> 32)},
     {(VUINT32) ((0x3fc185747dbecf34uLL) >> 0),
      (VUINT32) ((0x3fc185747dbecf34uLL) >> 32)},
     {(VUINT32) ((0x3fc160c8024b27b1uLL) >> 0),
      (VUINT32) ((0x3fc160c8024b27b1uLL) >> 32)},
     {(VUINT32) ((0x3fc13c2605c398c3uLL) >> 0),
      (VUINT32) ((0x3fc13c2605c398c3uLL) >> 32)},
     {(VUINT32) ((0x3fc1178e8227e47cuLL) >> 0),
      (VUINT32) ((0x3fc1178e8227e47cuLL) >> 32)},
     {(VUINT32) ((0x3fc0f301717cf0fbuLL) >> 0),
      (VUINT32) ((0x3fc0f301717cf0fbuLL) >> 32)},
     {(VUINT32) ((0x3fc0ce7ecdccc28duLL) >> 0),
      (VUINT32) ((0x3fc0ce7ecdccc28duLL) >> 32)},
     {(VUINT32) ((0x3fc0aa06912675d5uLL) >> 0),
      (VUINT32) ((0x3fc0aa06912675d5uLL) >> 32)},
     {(VUINT32) ((0x3fc08598b59e3a07uLL) >> 0),
      (VUINT32) ((0x3fc08598b59e3a07uLL) >> 32)},
     {(VUINT32) ((0x3fc06135354d4b18uLL) >> 0),
      (VUINT32) ((0x3fc06135354d4b18uLL) >> 32)},
     {(VUINT32) ((0x3fc03cdc0a51ec0duLL) >> 0),
      (VUINT32) ((0x3fc03cdc0a51ec0duLL) >> 32)},
     {(VUINT32) ((0x3fc0188d2ecf6140uLL) >> 0),
      (VUINT32) ((0x3fc0188d2ecf6140uLL) >> 32)},
     {(VUINT32) ((0x3fbfe89139dbd566uLL) >> 0),
      (VUINT32) ((0x3fbfe89139dbd566uLL) >> 32)},
     {(VUINT32) ((0x3fbfa01c9db57ce2uLL) >> 0),
      (VUINT32) ((0x3fbfa01c9db57ce2uLL) >> 32)},
     {(VUINT32) ((0x3fbf57bc7d9005dbuLL) >> 0),
      (VUINT32) ((0x3fbf57bc7d9005dbuLL) >> 32)},
     {(VUINT32) ((0x3fbf0f70cdd992e3uLL) >> 0),
      (VUINT32) ((0x3fbf0f70cdd992e3uLL) >> 32)},
     {(VUINT32) ((0x3fbec739830a1120uLL) >> 0),
      (VUINT32) ((0x3fbec739830a1120uLL) >> 32)},
     {(VUINT32) ((0x3fbe7f1691a32d3euLL) >> 0),
      (VUINT32) ((0x3fbe7f1691a32d3euLL) >> 32)},
     {(VUINT32) ((0x3fbe3707ee30487buLL) >> 0),
      (VUINT32) ((0x3fbe3707ee30487buLL) >> 32)},
     {(VUINT32) ((0x3fbdef0d8d466db9uLL) >> 0),
      (VUINT32) ((0x3fbdef0d8d466db9uLL) >> 32)},
     {(VUINT32) ((0x3fbda727638446a2uLL) >> 0),
      (VUINT32) ((0x3fbda727638446a2uLL) >> 32)},
     {(VUINT32) ((0x3fbd5f55659210e2uLL) >> 0),
      (VUINT32) ((0x3fbd5f55659210e2uLL) >> 32)},
     {(VUINT32) ((0x3fbd179788219364uLL) >> 0),
      (VUINT32) ((0x3fbd179788219364uLL) >> 32)},
     {(VUINT32) ((0x3fbccfedbfee13a8uLL) >> 0),
      (VUINT32) ((0x3fbccfedbfee13a8uLL) >> 32)},
     {(VUINT32) ((0x3fbc885801bc4b23uLL) >> 0),
      (VUINT32) ((0x3fbc885801bc4b23uLL) >> 32)},
     {(VUINT32) ((0x3fbc40d6425a5cb1uLL) >> 0),
      (VUINT32) ((0x3fbc40d6425a5cb1uLL) >> 32)},
     {(VUINT32) ((0x3fbbf968769fca11uLL) >> 0),
      (VUINT32) ((0x3fbbf968769fca11uLL) >> 32)},
     {(VUINT32) ((0x3fbbb20e936d6974uLL) >> 0),
      (VUINT32) ((0x3fbbb20e936d6974uLL) >> 32)},
     {(VUINT32) ((0x3fbb6ac88dad5b1cuLL) >> 0),
      (VUINT32) ((0x3fbb6ac88dad5b1cuLL) >> 32)},
     {(VUINT32) ((0x3fbb23965a52ff00uLL) >> 0),
      (VUINT32) ((0x3fbb23965a52ff00uLL) >> 32)},
     {(VUINT32) ((0x3fbadc77ee5aea8cuLL) >> 0),
      (VUINT32) ((0x3fbadc77ee5aea8cuLL) >> 32)},
     {(VUINT32) ((0x3fba956d3ecade63uLL) >> 0),
      (VUINT32) ((0x3fba956d3ecade63uLL) >> 32)},
     {(VUINT32) ((0x3fba4e7640b1bc38uLL) >> 0),
      (VUINT32) ((0x3fba4e7640b1bc38uLL) >> 32)},
     {(VUINT32) ((0x3fba0792e9277cacuLL) >> 0),
      (VUINT32) ((0x3fba0792e9277cacuLL) >> 32)},
     {(VUINT32) ((0x3fb9c0c32d4d2548uLL) >> 0),
      (VUINT32) ((0x3fb9c0c32d4d2548uLL) >> 32)},
     {(VUINT32) ((0x3fb97a07024cbe74uLL) >> 0),
      (VUINT32) ((0x3fb97a07024cbe74uLL) >> 32)},
     {(VUINT32) ((0x3fb9335e5d594989uLL) >> 0),
      (VUINT32) ((0x3fb9335e5d594989uLL) >> 32)},
     {(VUINT32) ((0x3fb8ecc933aeb6e8uLL) >> 0),
      (VUINT32) ((0x3fb8ecc933aeb6e8uLL) >> 32)},
     {(VUINT32) ((0x3fb8a6477a91dc29uLL) >> 0),
      (VUINT32) ((0x3fb8a6477a91dc29uLL) >> 32)},
     {(VUINT32) ((0x3fb85fd927506a48uLL) >> 0),
      (VUINT32) ((0x3fb85fd927506a48uLL) >> 32)},
     {(VUINT32) ((0x3fb8197e2f40e3f0uLL) >> 0),
      (VUINT32) ((0x3fb8197e2f40e3f0uLL) >> 32)},
     {(VUINT32) ((0x3fb7d33687c293c9uLL) >> 0),
      (VUINT32) ((0x3fb7d33687c293c9uLL) >> 32)},
     {(VUINT32) ((0x3fb78d02263d82d3uLL) >> 0),
      (VUINT32) ((0x3fb78d02263d82d3uLL) >> 32)},
     {(VUINT32) ((0x3fb746e100226ed9uLL) >> 0),
      (VUINT32) ((0x3fb746e100226ed9uLL) >> 32)},
     {(VUINT32) ((0x3fb700d30aeac0e1uLL) >> 0),
      (VUINT32) ((0x3fb700d30aeac0e1uLL) >> 32)},
     {(VUINT32) ((0x3fb6bad83c1883b6uLL) >> 0),
      (VUINT32) ((0x3fb6bad83c1883b6uLL) >> 32)},
     {(VUINT32) ((0x3fb674f089365a7auLL) >> 0),
      (VUINT32) ((0x3fb674f089365a7auLL) >> 32)},
     {(VUINT32) ((0x3fb62f1be7d77743uLL) >> 0),
      (VUINT32) ((0x3fb62f1be7d77743uLL) >> 32)},
     {(VUINT32) ((0x3fb5e95a4d9791cbuLL) >> 0),
      (VUINT32) ((0x3fb5e95a4d9791cbuLL) >> 32)},
     {(VUINT32) ((0x3fb5a3abb01ade25uLL) >> 0),
      (VUINT32) ((0x3fb5a3abb01ade25uLL) >> 32)},
     {(VUINT32) ((0x3fb55e10050e0384uLL) >> 0),
      (VUINT32) ((0x3fb55e10050e0384uLL) >> 32)},
     {(VUINT32) ((0x3fb518874226130auLL) >> 0),
      (VUINT32) ((0x3fb518874226130auLL) >> 32)},
     {(VUINT32) ((0x3fb4d3115d207eacuLL) >> 0),
      (VUINT32) ((0x3fb4d3115d207eacuLL) >> 32)},
     {(VUINT32) ((0x3fb48dae4bc31018uLL) >> 0),
      (VUINT32) ((0x3fb48dae4bc31018uLL) >> 32)},
     {(VUINT32) ((0x3fb4485e03dbdfaduLL) >> 0),
      (VUINT32) ((0x3fb4485e03dbdfaduLL) >> 32)},
     {(VUINT32) ((0x3fb403207b414b7fuLL) >> 0),
      (VUINT32) ((0x3fb403207b414b7fuLL) >> 32)},
     {(VUINT32) ((0x3fb3bdf5a7d1ee64uLL) >> 0),
      (VUINT32) ((0x3fb3bdf5a7d1ee64uLL) >> 32)},
     {(VUINT32) ((0x3fb378dd7f749714uLL) >> 0),
      (VUINT32) ((0x3fb378dd7f749714uLL) >> 32)},
     {(VUINT32) ((0x3fb333d7f8183f4buLL) >> 0),
      (VUINT32) ((0x3fb333d7f8183f4buLL) >> 32)},
     {(VUINT32) ((0x3fb2eee507b40301uLL) >> 0),
      (VUINT32) ((0x3fb2eee507b40301uLL) >> 32)},
     {(VUINT32) ((0x3fb2aa04a44717a5uLL) >> 0),
      (VUINT32) ((0x3fb2aa04a44717a5uLL) >> 32)},
     {(VUINT32) ((0x3fb26536c3d8c369uLL) >> 0),
      (VUINT32) ((0x3fb26536c3d8c369uLL) >> 32)},
     {(VUINT32) ((0x3fb2207b5c78549euLL) >> 0),
      (VUINT32) ((0x3fb2207b5c78549euLL) >> 32)},
     {(VUINT32) ((0x3fb1dbd2643d190buLL) >> 0),
      (VUINT32) ((0x3fb1dbd2643d190buLL) >> 32)},
     {(VUINT32) ((0x3fb1973bd1465567uLL) >> 0),
      (VUINT32) ((0x3fb1973bd1465567uLL) >> 32)},
     {(VUINT32) ((0x3fb152b799bb3cc9uLL) >> 0),
      (VUINT32) ((0x3fb152b799bb3cc9uLL) >> 32)},
     {(VUINT32) ((0x3fb10e45b3cae831uLL) >> 0),
      (VUINT32) ((0x3fb10e45b3cae831uLL) >> 32)},
     {(VUINT32) ((0x3fb0c9e615ac4e17uLL) >> 0),
      (VUINT32) ((0x3fb0c9e615ac4e17uLL) >> 32)},
     {(VUINT32) ((0x3fb08598b59e3a07uLL) >> 0),
      (VUINT32) ((0x3fb08598b59e3a07uLL) >> 32)},
     {(VUINT32) ((0x3fb0415d89e74444uLL) >> 0),
      (VUINT32) ((0x3fb0415d89e74444uLL) >> 32)},
     {(VUINT32) ((0x3faffa6911ab9301uLL) >> 0),
      (VUINT32) ((0x3faffa6911ab9301uLL) >> 32)},
     {(VUINT32) ((0x3faf723b517fc523uLL) >> 0),
      (VUINT32) ((0x3faf723b517fc523uLL) >> 32)},
     {(VUINT32) ((0x3faeea31c006b87cuLL) >> 0),
      (VUINT32) ((0x3faeea31c006b87cuLL) >> 32)},
     {(VUINT32) ((0x3fae624c4a0b5e1buLL) >> 0),
      (VUINT32) ((0x3fae624c4a0b5e1buLL) >> 32)},
     {(VUINT32) ((0x3fadda8adc67ee4euLL) >> 0),
      (VUINT32) ((0x3fadda8adc67ee4euLL) >> 32)},
     {(VUINT32) ((0x3fad52ed6405d86fuLL) >> 0),
      (VUINT32) ((0x3fad52ed6405d86fuLL) >> 32)},
     {(VUINT32) ((0x3faccb73cdddb2ccuLL) >> 0),
      (VUINT32) ((0x3faccb73cdddb2ccuLL) >> 32)},
     {(VUINT32) ((0x3fac441e06f72a9euLL) >> 0),
      (VUINT32) ((0x3fac441e06f72a9euLL) >> 32)},
     {(VUINT32) ((0x3fabbcebfc68f420uLL) >> 0),
      (VUINT32) ((0x3fabbcebfc68f420uLL) >> 32)},
     {(VUINT32) ((0x3fab35dd9b58baaduLL) >> 0),
      (VUINT32) ((0x3fab35dd9b58baaduLL) >> 32)},
     {(VUINT32) ((0x3faaaef2d0fb10fcuLL) >> 0),
      (VUINT32) ((0x3faaaef2d0fb10fcuLL) >> 32)},
     {(VUINT32) ((0x3faa282b8a936171uLL) >> 0),
      (VUINT32) ((0x3faa282b8a936171uLL) >> 32)},
     {(VUINT32) ((0x3fa9a187b573de7cuLL) >> 0),
      (VUINT32) ((0x3fa9a187b573de7cuLL) >> 32)},
     {(VUINT32) ((0x3fa91b073efd7314uLL) >> 0),
      (VUINT32) ((0x3fa91b073efd7314uLL) >> 32)},
     {(VUINT32) ((0x3fa894aa149fb343uLL) >> 0),
      (VUINT32) ((0x3fa894aa149fb343uLL) >> 32)},
     {(VUINT32) ((0x3fa80e7023d8ccc4uLL) >> 0),
      (VUINT32) ((0x3fa80e7023d8ccc4uLL) >> 32)},
     {(VUINT32) ((0x3fa788595a3577bauLL) >> 0),
      (VUINT32) ((0x3fa788595a3577bauLL) >> 32)},
     {(VUINT32) ((0x3fa70265a550e777uLL) >> 0),
      (VUINT32) ((0x3fa70265a550e777uLL) >> 32)},
     {(VUINT32) ((0x3fa67c94f2d4bb58uLL) >> 0),
      (VUINT32) ((0x3fa67c94f2d4bb58uLL) >> 32)},
     {(VUINT32) ((0x3fa5f6e73078efb8uLL) >> 0),
      (VUINT32) ((0x3fa5f6e73078efb8uLL) >> 32)},
     {(VUINT32) ((0x3fa5715c4c03ceefuLL) >> 0),
      (VUINT32) ((0x3fa5715c4c03ceefuLL) >> 32)},
     {(VUINT32) ((0x3fa4ebf43349e26fuLL) >> 0),
      (VUINT32) ((0x3fa4ebf43349e26fuLL) >> 32)},
     {(VUINT32) ((0x3fa466aed42de3eauLL) >> 0),
      (VUINT32) ((0x3fa466aed42de3eauLL) >> 32)},
     {(VUINT32) ((0x3fa3e18c1ca0ae92uLL) >> 0),
      (VUINT32) ((0x3fa3e18c1ca0ae92uLL) >> 32)},
     {(VUINT32) ((0x3fa35c8bfaa1306buLL) >> 0),
      (VUINT32) ((0x3fa35c8bfaa1306buLL) >> 32)},
     {(VUINT32) ((0x3fa2d7ae5c3c5baeuLL) >> 0),
      (VUINT32) ((0x3fa2d7ae5c3c5baeuLL) >> 32)},
     {(VUINT32) ((0x3fa252f32f8d183fuLL) >> 0),
      (VUINT32) ((0x3fa252f32f8d183fuLL) >> 32)},
     {(VUINT32) ((0x3fa1ce5a62bc353auLL) >> 0),
      (VUINT32) ((0x3fa1ce5a62bc353auLL) >> 32)},
     {(VUINT32) ((0x3fa149e3e4005a8duLL) >> 0),
      (VUINT32) ((0x3fa149e3e4005a8duLL) >> 32)},
     {(VUINT32) ((0x3fa0c58fa19dfaaauLL) >> 0),
      (VUINT32) ((0x3fa0c58fa19dfaaauLL) >> 32)},
     {(VUINT32) ((0x3fa0415d89e74444uLL) >> 0),
      (VUINT32) ((0x3fa0415d89e74444uLL) >> 32)},
     {(VUINT32) ((0x3f9f7a9b16782856uLL) >> 0),
      (VUINT32) ((0x3f9f7a9b16782856uLL) >> 32)},
     {(VUINT32) ((0x3f9e72bf2813ce51uLL) >> 0),
      (VUINT32) ((0x3f9e72bf2813ce51uLL) >> 32)},
     {(VUINT32) ((0x3f9d6b2725979802uLL) >> 0),
      (VUINT32) ((0x3f9d6b2725979802uLL) >> 32)},
     {(VUINT32) ((0x3f9c63d2ec14aaf2uLL) >> 0),
      (VUINT32) ((0x3f9c63d2ec14aaf2uLL) >> 32)},
     {(VUINT32) ((0x3f9b5cc258b718e6uLL) >> 0),
      (VUINT32) ((0x3f9b5cc258b718e6uLL) >> 32)},
     {(VUINT32) ((0x3f9a55f548c5c43fuLL) >> 0),
      (VUINT32) ((0x3f9a55f548c5c43fuLL) >> 32)},
     {(VUINT32) ((0x3f994f6b99a24475uLL) >> 0),
      (VUINT32) ((0x3f994f6b99a24475uLL) >> 32)},
     {(VUINT32) ((0x3f98492528c8cabfuLL) >> 0),
      (VUINT32) ((0x3f98492528c8cabfuLL) >> 32)},
     {(VUINT32) ((0x3f974321d3d006d3uLL) >> 0),
      (VUINT32) ((0x3f974321d3d006d3uLL) >> 32)},
     {(VUINT32) ((0x3f963d6178690bd6uLL) >> 0),
      (VUINT32) ((0x3f963d6178690bd6uLL) >> 32)},
     {(VUINT32) ((0x3f9537e3f45f3565uLL) >> 0),
      (VUINT32) ((0x3f9537e3f45f3565uLL) >> 32)},
     {(VUINT32) ((0x3f9432a925980cc1uLL) >> 0),
      (VUINT32) ((0x3f9432a925980cc1uLL) >> 32)},
     {(VUINT32) ((0x3f932db0ea132e22uLL) >> 0),
      (VUINT32) ((0x3f932db0ea132e22uLL) >> 32)},
     {(VUINT32) ((0x3f9228fb1fea2e28uLL) >> 0),
      (VUINT32) ((0x3f9228fb1fea2e28uLL) >> 32)},
     {(VUINT32) ((0x3f912487a5507f70uLL) >> 0),
      (VUINT32) ((0x3f912487a5507f70uLL) >> 32)},
     {(VUINT32) ((0x3f90205658935847uLL) >> 0),
      (VUINT32) ((0x3f90205658935847uLL) >> 32)},
     {(VUINT32) ((0x3f8e38ce3033310cuLL) >> 0),
      (VUINT32) ((0x3f8e38ce3033310cuLL) >> 32)},
     {(VUINT32) ((0x3f8c317384c75f06uLL) >> 0),
      (VUINT32) ((0x3f8c317384c75f06uLL) >> 32)},
     {(VUINT32) ((0x3f8a2a9c6c170462uLL) >> 0),
      (VUINT32) ((0x3f8a2a9c6c170462uLL) >> 32)},
     {(VUINT32) ((0x3f882448a388a2aauLL) >> 0),
      (VUINT32) ((0x3f882448a388a2aauLL) >> 32)},
     {(VUINT32) ((0x3f861e77e8b53fc6uLL) >> 0),
      (VUINT32) ((0x3f861e77e8b53fc6uLL) >> 32)},
     {(VUINT32) ((0x3f841929f96832f0uLL) >> 0),
      (VUINT32) ((0x3f841929f96832f0uLL) >> 32)},
     {(VUINT32) ((0x3f82145e939ef1e9uLL) >> 0),
      (VUINT32) ((0x3f82145e939ef1e9uLL) >> 32)},
     {(VUINT32) ((0x3f8010157588de71uLL) >> 0),
      (VUINT32) ((0x3f8010157588de71uLL) >> 32)},
     {(VUINT32) ((0x3f7c189cbb0e27fbuLL) >> 0),
      (VUINT32) ((0x3f7c189cbb0e27fbuLL) >> 32)},
     {(VUINT32) ((0x3f78121214586b54uLL) >> 0),
      (VUINT32) ((0x3f78121214586b54uLL) >> 32)},
     {(VUINT32) ((0x3f740c8a747878e2uLL) >> 0),
      (VUINT32) ((0x3f740c8a747878e2uLL) >> 32)},
     {(VUINT32) ((0x3f70080559588b35uLL) >> 0),
      (VUINT32) ((0x3f70080559588b35uLL) >> 32)},
     {(VUINT32) ((0x3f680904828985c0uLL) >> 0),
      (VUINT32) ((0x3f680904828985c0uLL) >> 32)},
     {(VUINT32) ((0x3f60040155d5889euLL) >> 0),
      (VUINT32) ((0x3f60040155d5889euLL) >> 32)},
     {(VUINT32) ((0x3f50020055655889uLL) >> 0),
      (VUINT32) ((0x3f50020055655889uLL) >> 32)},
     {(VUINT32) ((0x0000000000000000uLL) >> 0),
      (VUINT32) ((0x0000000000000000uLL) >> 32)}}

  , {
     {(VUINT32) ((0x3fc9999CACDB4D0AuLL) >> 0),
      (VUINT32) ((0x3fc9999CACDB4D0AuLL) >> 32)}
     , {(VUINT32) ((0xbfd0000148058EE1uLL) >> 0),
        (VUINT32) ((0xbfd0000148058EE1uLL) >> 32)}
     , {(VUINT32) ((0x3fd55555555543C5uLL) >> 0),
        (VUINT32) ((0x3fd55555555543C5uLL) >> 32)}
     , {(VUINT32) ((0xbfdFFFFFFFFFF81FuLL) >> 0),
        (VUINT32) ((0xbfdFFFFFFFFFF81FuLL) >> 32)}
     }

  , {(VUINT32) ((0x000fffffffffffffuLL) >> 0),
     (VUINT32) ((0x000fffffffffffffuLL) >> 32)}

  , {(VUINT32) ((0x3f50000000000000uLL) >> 0),
     (VUINT32) ((0x3f50000000000000uLL) >> 32)}

  , {(VUINT32) ((0xbfefffffffffffffuLL) >> 0),
     (VUINT32) ((0xbfefffffffffffffuLL) >> 32)}

  , {(VUINT32) ((0x7f3ffffffffff000uLL) >> 0),
     (VUINT32) ((0x7f3ffffffffff000uLL) >> 32)}

  , {(VUINT32) ((0xfffffffffc000000uLL) >> 0),
     (VUINT32) ((0xfffffffffc000000uLL) >> 32)}

  , {(VUINT32) ((0x3ff0000000000000uLL) >> 0),
     (VUINT32) ((0x3ff0000000000000uLL) >> 32)}

  , {(VUINT32) ((0x7fffffffffffffffuLL) >> 0),
     (VUINT32) ((0x7fffffffffffffffuLL) >> 32)}

  , {(VUINT32) ((0x3e00000000000000uLL) >> 0),
     (VUINT32) ((0x3e00000000000000uLL) >> 32)}

  , {(VUINT32) ((0xfffffffffffffc00uLL) >> 0),
     (VUINT32) ((0xfffffffffffffc00uLL) >> 32)}

  , {(VUINT32) ((0x3fe62E42FEFA0000uLL) >> 0),
     (VUINT32) ((0x3fe62E42FEFA0000uLL) >> 32)}

  , {(VUINT32) ((0x3d7cf79abc9e0000uLL) >> 0),
     (VUINT32) ((0x3d7cf79abc9e0000uLL) >> 32)}

  , {(VUINT32) ((0x4086a00000000000uLL) >> 0),
     (VUINT32) ((0x4086a00000000000uLL) >> 32)}

  , {(VUINT32) ((0x408ff80000000000uLL) >> 0),
     (VUINT32) ((0x408ff80000000000uLL) >> 32)}

  , {(VUINT32) ((0x408ff00000000000uLL) >> 0),
     (VUINT32) ((0x408ff00000000000uLL) >> 32)}

  , {(VUINT32) ((0x7ff0000000000000uLL) >> 0),
     (VUINT32) ((0x7ff0000000000000uLL) >> 32)}

  , {(VUINT32) ((0x7f40000000000000uLL) >> 0),
     (VUINT32) ((0x7f40000000000000uLL) >> 32)}

  , {(VUINT32) ((0x3fe62E42FEFA39EFuLL) >> 0),
     (VUINT32) ((0x3fe62E42FEFA39EFuLL) >> 32)}

  , {(VUINT32) ((0x41D0000000000000uLL) >> 0),
     (VUINT32) ((0x41D0000000000000uLL) >> 32)}

  , {(VUINT32) ((0x3FD8000000000000uLL) >> 0),
     (VUINT32) ((0x3FD8000000000000uLL) >> 32)}

  , {(VUINT32) ((0x3FD4000000000000uLL) >> 0),
     (VUINT32) ((0x3FD4000000000000uLL) >> 32)}

  , {(VUINT32) ((0x3FD1800000000000uLL) >> 0),
     (VUINT32) ((0x3FD1800000000000uLL) >> 32)}

  , {(VUINT32) ((0x3FCF800000000000uLL) >> 0),
     (VUINT32) ((0x3FCF800000000000uLL) >> 32)}

  , {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)}

  , {(VUINT32) ((0x7FEFFFFFFFFFFFFFuLL) >> 0),
     (VUINT32) ((0x7FEFFFFFFFFFFFFFuLL) >> 32)}

  , {(VUINT32) ((0x3F60000000000000uLL) >> 0),
     (VUINT32) ((0x3F60000000000000uLL) >> 32)}

  , {(VUINT32) ((0x8000000000000000uLL) >> 0),
     (VUINT32) ((0x8000000000000000uLL) >> 32)}

  , {(VUINT32) ((0x403F000000000000uLL) >> 0),
     (VUINT32) ((0x403F000000000000uLL) >> 32)}

  , {(VUINT32) ((0xFFFFFE0000000000uLL) >> 0),
     (VUINT32) ((0xFFFFFE0000000000uLL) >> 32)}

  , {(VUINT32) ((0xFFFFFFFFF8000000uLL) >> 0),
     (VUINT32) ((0xFFFFFFFFF8000000uLL) >> 32)}

  , {(VUINT32) ((0xFFFFFFFFFF000000uLL) >> 0),
     (VUINT32) ((0xFFFFFFFFFF000000uLL) >> 32)}

  , {(VUINT32) ((0xFFFFFFFFFFFFF000uLL) >> 0),
     (VUINT32) ((0xFFFFFFFFFFFFF000uLL) >> 32)}

  , {(VUINT32) ((0x3E10000000000000uLL) >> 0),
     (VUINT32) ((0x3E10000000000000uLL) >> 32)}

  , {(VUINT32) ((0x0350000000000000uLL) >> 0),              // only for atanh
     (VUINT32) ((0x0350000000000000uLL) >> 32)}

  , {{(VUINT32) ((0x7ff0000000000000uLL) >> 0),
      (VUINT32) ((0x7ff0000000000000uLL) >> 32)},
     {(VUINT32) ((0xfff0000000000000uLL) >> 0),
      (VUINT32) ((0xfff0000000000000uLL) >> 32)}}

  , {{(VUINT32) ((0x3ff0000000000000uLL) >> 0),
      (VUINT32) ((0x3ff0000000000000uLL) >> 32)},
     {(VUINT32) ((0xbff0000000000000uLL) >> 0),
      (VUINT32) ((0xbff0000000000000uLL) >> 32)}}

  , {{(VUINT32) ((0x0000000000000000uLL) >> 0),
      (VUINT32) ((0x0000000000000000uLL) >> 32)},
     {(VUINT32) ((0x8000000000000000uLL) >> 0),
      (VUINT32) ((0x8000000000000000uLL) >> 32)}}

};

// Data common to acosh and atanh

__constant _iml_dp_union_t _vmldAcoshAsinhHATab[4] = {
  {{0x00000000u, 0x3FF00000u}},
  {{0x00000000u, 0x00000000u}},
  {{0x00000000u, 0x7FF00000u}},
  {{0x00000000u, 0xFFF00000u}}
};

// Data common to atan, atan2, atanpi

__constant _iml_dp_union_t _vmldAtan2piHATab[255] = {
  {{0xE8000000u, 0x3FC3D6EEu}},
  {{0x8B0D1D86u, 0x3DF8CC4Du}},
  {{0x50000000u, 0x3FCB90D7u}},
  {{0x1022F622u, 0x3E149305u}},
  {{0x38000000u, 0x3FD36277u}},
  {{0x8658E951u, 0xBE0F0286u}},
  {{0xC0000000u, 0x3FDA64EEu}},
  {{0xE5B6427Du, 0x3E2E611Fu}},
  {{0xA8000000u, 0x3FE1E00Bu}},
  {{0x9F9B5C83u, 0x3E3EF7F5u}},
  {{0xC8000000u, 0x3FE700A7u}},
  {{0x618C34D2u, 0xBE343DCEu}},
  {{0x58000000u, 0x3FECAC7Cu}},
  {{0x6F251EC5u, 0xBE0EE418u}},
  {{0x30000000u, 0x3FF0D38Fu}},
  {{0x0B7A1B84u, 0xBE4D22FBu}},
  {{0x78000000u, 0x3FF30B6Du}},
  {{0x8589532Cu, 0x3E36A4DAu}},
  {{0x00000000u, 0x3FF4AE11u}},
  {{0xDA7607D1u, 0xBE4CD3B2u}},
  {{0x18000000u, 0x3FF5F973u}},
  {{0x4931151Au, 0xBE46D5BDu}},
  {{0x78000000u, 0x3FF6DCC5u}},
  {{0xE5AC6F37u, 0x3E4DAB2Fu}},
  {{0x30000000u, 0x3FF789BDu}},
  {{0x63E8AA08u, 0xBE4F4FFDu}},
  {{0x08000000u, 0x3FF7FDE8u}},
  {{0xFFBFDCA2u, 0x3E1C30A7u}},
  {{0x28000000u, 0x3FF8555Au}},
  {{0x3B43DC6Cu, 0xBE1E19F8u}},
  {{0x18000000u, 0x3FF88FC2u}},
  {{0x6FF107D4u, 0x3E259D3Bu}},
  {{0x60000000u, 0x3FF8BB9Au}},
  {{0x27F43144u, 0x3E4B8C7Au}},
  {{0xC0000000u, 0x3FF8D8D8u}},
  {{0x2931C287u, 0xBE2359D2u}},
  {{0xD0000000u, 0x3FF8EEC8u}},
  {{0x607FD6F0u, 0xBE07FCCDu}},
  {{0x48000000u, 0x3FF8FD69u}},
  {{0x8310236Bu, 0x3E4679B5u}},
  {{0xD0000000u, 0x3FF90861u}},
  {{0x9CFF61AFu, 0x3E205B36u}},
  {{0x38000000u, 0x3FF90FB2u}},
  {{0x3F24AB6Au, 0xBE160576u}},
  {{0x88000000u, 0x3FF9152Eu}},
  {{0xBC43465Du, 0x3E419361u}},
  {{0xC0000000u, 0x3FF918D6u}},
  {{0x1114E411u, 0x3E47CE4Fu}},
  {{0xF0000000u, 0x3FF91B94u}},
  {{0x773951DFu, 0xBE3CAD7Bu}},
  {{0x08000000u, 0x3FF91D69u}},
  {{0xFAA44CE6u, 0x3E49FB97u}},
  {{0x20000000u, 0x3FF91EC8u}},
  {{0x8B23FFA5u, 0x3E31BE61u}},
  {{0x30000000u, 0x3FF91FB2u}},
  {{0x87FC4A01u, 0xBE128841u}},
  {{0xB8000000u, 0x3FF92061u}},
  {{0x29392773u, 0x3E455F88u}},
  {{0xC0000000u, 0x3FF920D6u}},
  {{0x6C4176AEu, 0x3E3FB87Eu}},
  {{0x88000000u, 0x3FF9212Eu}},
  {{0x76D7A426u, 0xBE210E80u}},
  {{0x08000000u, 0x3FF92169u}},
  {{0xD9D720C0u, 0x3E48FD55u}},
  {{0xF0000000u, 0x3FF92194u}},
  {{0xC02EEAC5u, 0xBE41119Eu}},
  {{0x30000000u, 0x3FF921B2u}},
  {{0xB22521F8u, 0xBE138683u}},
  {{0x20000000u, 0x3FF921C8u}},
  {{0x3D6A380Du, 0x3E310FA9u}},
  {{0xC0000000u, 0x3FF921D6u}},
  {{0x5ADD7895u, 0x3E3FB08Cu}},
  {{0xB8000000u, 0x3FF921E1u}},
  {{0xA42B3618u, 0x3E45549Cu}},
  {{0x08000000u, 0x3FF921E9u}},
  {{0xB8C09601u, 0x3E48FCD6u}},
  {{0x88000000u, 0x3FF921EEu}},
  {{0x3964E770u, 0xBE2113F6u}},
  {{0x30000000u, 0x3FF921F2u}},
  {{0xD33BBF6Eu, 0xBE138702u}},
  {{0xF0000000u, 0x3FF921F4u}},
  {{0x6E436174u, 0xBE4111CAu}},
  {{0xC0000000u, 0x3FF921F6u}},
  {{0x61D4C384u, 0x3E3FB088u}},
  {{0x20000000u, 0x3FF921F8u}},
  {{0x51E51998u, 0x3E310F9Eu}},
  {{0x08000000u, 0x3FF921F9u}},
  {{0x79300AAFu, 0x3E48FCD6u}},
  {{0xB8000000u, 0x3FF921F9u}},
  {{0xF572E42Du, 0x3E45549Bu}},
  {{0x30000000u, 0x3FF921FAu}},
  {{0x12CC4AC0u, 0xBE138703u}},
  {{0x88000000u, 0x3FF921FAu}},
  {{0x90C11066u, 0xBE2113F6u}},
  {{0xC0000000u, 0x3FF921FAu}},
  {{0x5FD83F2Au, 0x3E3FB088u}},
  {{0xF0000000u, 0x3FF921FAu}},
  {{0x70FE42BCu, 0xBE4111CAu}},
  {{0x08000000u, 0x3FF921FBu}},
  {{0x79104269u, 0x3E48FCD6u}},
  {{0x20000000u, 0x3FF921FBu}},
  {{0x51366146u, 0x3E310F9Eu}},
  {{0x30000000u, 0x3FF921FBu}},
  {{0x12EC1305u, 0xBE138703u}},
  {{0x38000000u, 0x3FF921FBu}},
  {{0xF567F8A8u, 0x3E45549Bu}},
  {{0x40000000u, 0x3FF921FBu}},
  {{0x5FD740E8u, 0x3E3FB088u}},
  {{0x48000000u, 0x3FF921FBu}},
  {{0x90C68629u, 0xBE2113F6u}},
  {{0x48000000u, 0x3FF921FBu}},
  {{0x79103285u, 0x3E48FCD6u}},
  {{0x50000000u, 0x3FF921FBu}},
  {{0x70FE6E6Au, 0xBE4111CAu}},
  {{0x50000000u, 0x3FF921FBu}},
  {{0x12EC22EAu, 0xBE138703u}},
  {{0x50000000u, 0x3FF921FBu}},
  {{0x5136565Au, 0x3E310F9Eu}},
  {{0x50000000u, 0x3FF921FBu}},
  {{0x5FD74068u, 0x3E3FB088u}},
  {{0x50000000u, 0x3FF921FBu}},
  {{0xF567F7FAu, 0x3E45549Bu}},
  {{0x50000000u, 0x3FF921FBu}},
  {{0x7910327Du, 0x3E48FCD6u}},
  {{0x50000000u, 0x3FF921FBu}},
  {{0x5BCE5E60u, 0x3E4BBB02u}},
  {{0x50000000u, 0x3FF921FBu}},
  {{0x9DA27BA2u, 0x3E4D8F1Fu}},
  {{0x50000000u, 0x3FF921FBu}},
  {{0x8F019193u, 0x3E4EEE35u}},
  {{0x50000000u, 0x3FF921FBu}},
  {{0x2FEBA034u, 0x3E4FD844u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0xD764D4D3u, 0xBE4F7830u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x86EFCD83u, 0xBE4F0329u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x0A980806u, 0xBE4EAB64u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x625D845Eu, 0xBE4E70E0u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0xA431A1A0u, 0xBE4E44FDu}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0xD0145FCCu, 0xBE4E27BBu}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x70FE6E6Du, 0xBE4E11CAu}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x86EFCD83u, 0xBE4E0329u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0xD764D4D3u, 0xBE4DF830u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x625D845Eu, 0xBE4DF0E0u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x0A980806u, 0xBE4DEB64u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0xD0145FCCu, 0xBE4DE7BBu}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0xA431A1A0u, 0xBE4DE4FDu}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x86EFCD83u, 0xBE4DE329u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x70FE6E6Du, 0xBE4DE1CAu}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x625D845Eu, 0xBE4DE0E0u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0xD764D4D3u, 0xBE4DE030u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0xD0145FCCu, 0xBE4DDFBBu}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x0A980806u, 0xBE4DDF64u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x86EFCD83u, 0xBE4DDF29u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0xA431A1A0u, 0xBE4DDEFDu}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x625D845Eu, 0xBE4DDEE0u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x70FE6E6Du, 0xBE4DDECAu}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0xD0145FCCu, 0xBE4DDEBBu}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0xD764D4D3u, 0xBE4DDEB0u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x86EFCD83u, 0xBE4DDEA9u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x0A980806u, 0xBE4DDEA4u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x625D845Eu, 0xBE4DDEA0u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0xA431A1A0u, 0xBE4DDE9Du}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0xD0145FCCu, 0xBE4DDE9Bu}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x70FE6E6Du, 0xBE4DDE9Au}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x86EFCD83u, 0xBE4DDE99u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0xD764D4D3u, 0xBE4DDE98u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x625D845Eu, 0xBE4DDE98u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x0A980806u, 0xBE4DDE98u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0xD0145FCCu, 0xBE4DDE97u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0xA431A1A0u, 0xBE4DDE97u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x86EFCD83u, 0xBE4DDE97u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x70FE6E6Du, 0xBE4DDE97u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x625D845Eu, 0xBE4DDE97u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x5764D4D3u, 0xBE4DDE97u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x50145FCCu, 0xBE4DDE97u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x4A980806u, 0xBE4DDE97u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x46EFCD83u, 0xBE4DDE97u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x4431A1A0u, 0xBE4DDE97u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x425D845Eu, 0xBE4DDE97u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x40FE6E6Du, 0xBE4DDE97u}},
  {{0x58000000u, 0x3FF921FBu}},
  {{0x40145FCCu, 0xBE4DDE97u}},

  {{0x55555555u, 0xBFD55555u}},
  {{0x999991BBu, 0x3FC99999u}},
  {{0x92382A27u, 0xBFC24924u}},
  {{0xF9B157D3u, 0x3FBC71C6u}},
  {{0x69CCA475u, 0xBFB745BEu}},
  {{0x1048AFD1u, 0x3FB3AB7Cu}},
                                //         atan         atanpi         atan2
  {{0x34239994u, 0xBFB029BDu}}, // 234     234+0        234+0          234+0

  {{0x00000000u, 0x3CA00000u}}, // 235     235+0        235+0                  - only in atan/atanpi
  {{0x00000000u, 0x3FC00000u}}, // 236     236+0        236+0          235+1
  {{0x00000000u, 0x43500000u}}, // 237     237+0        237+0                  - only in atan/atanpi

  {{0x00000000u, 0x3FF00000u}}, // 238     238+0        238+0          236+2

  {{0x00000000u, 0x40000000u}}, // 239                                 237+2   - only in atan2
  {{0x54442D18u, 0x3FE921FBu}}, // 240                                 238+2   - only in atan2
  {{0x33145C07u, 0x3C81A626u}}, // 241                                 239+2   - only in atan2

  {{0x54442D18u, 0x3FF921FBu}}, // 242     239+3        239+0          240+2
  {{0x33145C07u, 0x3C91A626u}}, // 243     240+3        240+0          241+2

  {{0x54442D18u, 0x400921FBu}}, // 244                                 242+2   - only in atan2
  {{0x33145C07u, 0x3CA1A626u}}, // 245                                 243+2   - only in atan2
  {{0x7F3321D2u, 0x4002D97Cu}}, // 246                                 244+2   - only in atan2
  {{0x4C9E8A0Au, 0x3C9A7939u}}, // 247                                 245+2   - only in atan2
  {{0x00000000u, 0xBFF00000u}}, // 248                                 246+2   - only in atan2
  {{0x00000000u, 0x00000000u}}, // 249                                 247+2   - only in atan2
  {{0x00000000u, 0x7FD00000u}}, // 250                                 248+2   - only in atan2
  {{0x00000000u, 0x00100000u}}, // 251                                 249+2   - only in atan2

  {{0x02000000u, 0x41A00000u}}, // 252     241+11       241+11         250+2
  {{0x6DC9C883u, 0x3FD45F30u}}, // 253                  242+11                 - only in atanpi
  {{0xC5417056u, 0xBC76B01Eu}}  // 254                  243+11                 - only in atanpi
};

#endif
