
/***************************************************************************
 *            ho_recognize_font_2.h
 *
 *  Fri Aug 12 20:13:33 2005
 *  Copyright  2005-2008  Yaacov Zamir
 *  <kzamir@walla.co.il>
 ****************************************************************************/

/*  
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/** @file ho_recognize_font_2.h
    @brief libhocr C language header.
    
    libhocr - LIBrary for Hebrew Optical Character Recognition 
*/

#ifndef HO_RECOGNIZE_FONT_2_H
#define HO_RECOGNIZE_FONT_2_H 1

double ho_recognize_font_2_zero (const double *array_in);

double ho_recognize_font_2_one (const double *array_in);

double ho_recognize_font_2_two (const double *array_in);

double ho_recognize_font_2_three (const double *array_in);

double ho_recognize_font_2_four (const double *array_in);

double ho_recognize_font_2_five (const double *array_in);

double ho_recognize_font_2_six (const double *array_in);

double ho_recognize_font_2_seven (const double *array_in);

double ho_recognize_font_2_eight (const double *array_in);

double ho_recognize_font_2_nine (const double *array_in);

double ho_recognize_font_2_dot (const double *array_in);

double ho_recognize_font_2_comma (const double *array_in);

double ho_recognize_font_2_open (const double *array_in);

double ho_recognize_font_2_close (const double *array_in);

double ho_recognize_font_2_minus (const double *array_in);

double ho_recognize_font_2_plus (const double *array_in);

double ho_recognize_font_2_div (const double *array_in);

double ho_recognize_font_2_tag (const double *array_in);

double ho_recognize_font_2_two_tags (const double *array_in);

double ho_recognize_font_2_question (const double *array_in);

double ho_recognize_font_2_exclem (const double *array_in);

double ho_recognize_font_2_dot_dot (const double *array_in);

double ho_recognize_font_2_dot_comma (const double *array_in);

double ho_recognize_font_2_alef (const double *array_in);

double ho_recognize_font_2_bet (const double *array_in);

double ho_recognize_font_2_gimal (const double *array_in);

double ho_recognize_font_2_dalet (const double *array_in);

double ho_recognize_font_2_hey (const double *array_in);

double ho_recognize_font_2_vav (const double *array_in);

double ho_recognize_font_2_zayin (const double *array_in);

double ho_recognize_font_2_het (const double *array_in);

double ho_recognize_font_2_tet (const double *array_in);

double ho_recognize_font_2_yud (const double *array_in);

double ho_recognize_font_2_caf (const double *array_in);

double ho_recognize_font_2_caf_sofit (const double *array_in);

double ho_recognize_font_2_lamed (const double *array_in);

double ho_recognize_font_2_mem (const double *array_in);

double ho_recognize_font_2_mem_sofit (const double *array_in);

double ho_recognize_font_2_nun (const double *array_in);

double ho_recognize_font_2_nun_sofit (const double *array_in);

double ho_recognize_font_2_samech (const double *array_in);

double ho_recognize_font_2_ayin (const double *array_in);

double ho_recognize_font_2_pey (const double *array_in);

double ho_recognize_font_2_pey_sofit (const double *array_in);

double ho_recognize_font_2_tzadi (const double *array_in);

double ho_recognize_font_2_tzadi_sofit (const double *array_in);

double ho_recognize_font_2_kuf (const double *array_in);

double ho_recognize_font_2_resh (const double *array_in);

double ho_recognize_font_2_shin (const double *array_in);

double ho_recognize_font_2_tav (const double *array_in);

#endif /* HO_RECOGNIZE_FONT_2_H */
