//
// The Fontaine Font Analysis Project 
// 
// Copyright (c) 2009, 2015 by Edward H. Trager
// All Rights Reserved
// 
// Released under the GNU GPL version 2.0 or later.
//     


//
// IPA.h
//

#ifndef ORTHOGRAPHY_DATA
#include "../OrthographyData.h"
#endif

#ifndef IPA
#define IPA

namespace IPA{

//
// Unicode values 
//
UINT32 values[]={
	0x0251,	// OPEN BACK UNROUNDED
	0x0250,	// OPEN-MID SCHWA
	0x0252,	// OPEN BACK ROUNDED
	0x00E6,	// RAISED OPEN FRONT UNROUNDED
	0x0253,	// VD BILABIAL IMPLOSIVE
	0x0299,	// VD BILABIAL TRILL
	0x03B2,	// VD BILABIAL FRICATIVE
	0x0254,	// OPEN-MID BACK ROUNDED
	0x0255,	// VL ALVEOLOPALATAL FRICATIVE
	0x00E7,	// VL PALATAL FRICATIVE
	0x0257,	// VD ALVEOLAR IMPLOSIVE
	0x0256,	// VD RETROFLEX PLOSIVE
	0x00F0,	// VD DENTAL FRICATIVE
	0x02A4,	// VD POSTALVEOLAR AFFRICATE
	0x0259,	// SCHWA
	0x0258,	// CLOSE-MID SCHWA
	0x025A,	// RHOTACIZED SCHWA
	0x025B,	// OPEN-MID FRONT UNROUNDED
	0x025C,	// OPEN-MID CENTRAL
	0x025D,	// RHOTACIZED OPEN-MID CENTRAL
	0x025E,	// OPEN-MID CENTRAL ROUNDED
	0x025F,	// VD PALATAL PLOSIVE
	0x0284,	// VD PALATAL IMPLOSIVE
	0x0261,	// VD VELAR PLOSIVE
	0x0260,	// VD VELAR IMPLOSIVE
	0x0262,	// VD UVULAR PLOSIVE
	0x029B,	// VD UVULAR IMPLOSIVE
	0x0266,	// VD GLOTTAL FRICATIVE
	0x0267,	// VL MULTIPLE-PLACE FRICATIVE
	0x0127,	// VL PHARYNGEAL FRICATIVE
	0x0265,	// LABIAL-PALATAL APPROXIMANT
	0x029C,	// VL EPIGLOTTAL FRICATIVE
	0x0268,	// CLOSE CENTRAL UNROUNDED
	0x026A,	// LAX CLOSE FRONT UNROUNDED
	0x029D,	// VD PALATAL FRICATIVE
	0x026D,	// VD RETROFLEX LATERAL
	0x026C,	// VL ALVEOLAR LATERAL FRICATIVE
	0x026B,	// VELARIZED VD ALVEOLAR LATERAL
	0x026E,	// VD ALVEOLAR LATERAL FRICATIVE
	0x029F,	// VD VELAR LATERAL
	0x0271,	// VD LABIODENTAL NASAL
	0x026F,	// CLOSE BACK UNROUNDED
	0x0270,	// VELAR APPROXIMANT
	0x014B,	// VD VELAR NASAL
	0x0273,	// VD RETROFLEX NASAL
	0x0272,	// VD PALATAL NASAL
	0x0274,	// VD UVULAR NASAL
	0x00F8,	// FRONT CLOSE-MID ROUNDED
	0x0275,	// ROUNDED SCHWA
	0x0278,	// VL BILABIAL FRICATIVE
	0x03B8,	// VL DENTAL FRICATIVE
	0x0153,	// FRONT OPEN-MID ROUNDED
	0x0276,	// FRONT OPEN ROUNDED
	0x0298,	// BILABIAL CLICK
	0x0279,	// VD (POST)ALVEOLAR APPROXIMANT
	0x027A,	// VD ALVEOLAR LATERAL FLAP
	0x027E,	// VD ALVEOLAR TAP
	0x027B,	// VD RETROFLEX APPROXIMANT
	0x0280,	// VD UVULAR TRILL
	0x0281,	// VD UVULAR FRICATIVE
	0x027D,	// VD RETROFLEX FLAP
	0x0282,	// VL RETROFLEX FRICATIVE
	0x0283,	// VL POSTALVEOLAR FRICATIVE
	0x0288,	// VL RETROFLEX PLOSIVE
	0x02A7,	// VL POSTALVEOLAR AFFRICATE
	0x0289,	// CLOSE CENTRAL ROUNDED
	0x028B,	// VD LABIODENTAL APPROXIMANT
	0x028A,	// LAX CLOSE BACK ROUNDED
	0x028C,	// OPEN-MID BACK UNROUNDED
	0x0263,	// VD VELAR FRICATIVE
	0x0264,	// CLOSE-MID BACK UNROUNDED
	0x028D,	// VL LABIAL-VELAR FRICATIVE
	0x03C7,	// VL UVULAR FRICATIVE
	0x028E,	// VD PALATAL LATERAL
	0x028F,	// LAX CLOSE FRONT ROUNDED
	0x0291,	// VD ALVEOLOPALATAL FRICATIVE
	0x0290,	// VD RETROFLEX FRICATIVE
	0x0292,	// VD POSTALVEOLAR FRICATIVE
	0x0294,	// GLOTTAL PLOSIVE
	0x02A1,	// VD EPIGLOTTAL PLOSIVE
	0x0295,	// VD PHARYNGEAL FRICATIVE
	0x02A2,	// VD EPIGLOTTAL FRICATIVE
	0x01C0,	// DENTAL CLICK
	0x01C1,	// ALVEOLAR LATERAL CLICK
	0x01C2,	// ALVEOLAR CLICK
	0x01C3,	// RETROFLEX CLICK
	END_OF_DATA
};

//
// Sample sentences
// 
const char *sentences[]={
	"/bəˈnɑːnəz ɑː ˈjeləʊ wen ðeɪ ɑː raɪp/",
	END_OF_DATA
};


//
// 
//
OrthographyData data={
	"IPA",
	"aɪ pʰiː eɪ",
	0x025B, // OPEN MID-FRONT UNROUNDED
	values,
	"ɑɐɔɗʤɜɵɸʎɤ",
	sentences
};

const OrthographyData *pData = &data;

}; // end of namespace

#endif
