/*
 *      fhist - file history and comparison tools
 *      Copyright (C) 1991-1994, 1998, 2000, 2002, 2008 Peter Miller
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 3 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program. If not, see
 *      <http://www.gnu.org/licenses/>.
 */

#ifndef COMMON_STR_H
#define COMMON_STR_H

#include <ac/stddef.h>
#include <ac/stdarg.h>
#include <attrib_forma.h>
#include <main.h>

typedef unsigned long str_hash_ty;

typedef struct string_ty string_ty;
struct string_ty
{
        str_hash_ty     str_hash;
        string_ty       *str_next;
        long            str_references;
        size_t          str_length;
        char            str_text[1];
};

void str_initialize(void);
string_ty *str_from_c(const char *);
string_ty *str_n_from_c(const char *, size_t);
string_ty *str_copy(string_ty *);
void str_free(string_ty *);
string_ty *str_catenate(string_ty *, string_ty *);
string_ty *str_cat_three(string_ty *, string_ty *, string_ty *);
int str_bool(string_ty *);
string_ty *str_upcase(string_ty *);
string_ty *str_downcase(string_ty *);
void str_dump(void);
string_ty *str_field(string_ty *str, int sep, int fldnum);
void slow_to_fast(char **, string_ty **, size_t);
string_ty *str_format(const char *, ...) ATTRIBUTE_FORMAT_1_2;
string_ty *str_vformat(const char *, va_list);

#define str_equal(s1, s2) ((s1) == (s2))

#endif /* COMMON_STR_H */
