/*
 * MOTIS API
 *
 * This is the MOTIS routing API.
 *
 * The version of the OpenAPI document: v1
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct StepInstruction {
    #[serde(rename = "relativeDirection")]
    pub relative_direction: models::Direction,
    /// The distance in meters that this step takes.
    #[serde(rename = "distance")]
    pub distance: f64,
    /// level where this segment starts, based on OpenStreetMap data
    #[serde(rename = "fromLevel")]
    pub from_level: f64,
    /// level where this segment starts, based on OpenStreetMap data
    #[serde(rename = "toLevel")]
    pub to_level: f64,
    /// OpenStreetMap way index
    #[serde(rename = "osmWay", skip_serializing_if = "Option::is_none")]
    pub osm_way: Option<i32>,
    #[serde(rename = "polyline")]
    pub polyline: Box<models::EncodedPolyline>,
    /// The name of the street.
    #[serde(rename = "streetName")]
    pub street_name: String,
    /// Not implemented! When exiting a highway or traffic circle, the exit name/number. 
    #[serde(rename = "exit")]
    pub exit: String,
    /// Not implemented! Indicates whether or not a street changes direction at an intersection. 
    #[serde(rename = "stayOn")]
    pub stay_on: bool,
    /// Not implemented! This step is on an open area, such as a plaza or train platform, and thus the directions should say something like \"cross\" 
    #[serde(rename = "area")]
    pub area: bool,
}

impl StepInstruction {
    pub fn new(relative_direction: models::Direction, distance: f64, from_level: f64, to_level: f64, polyline: models::EncodedPolyline, street_name: String, exit: String, stay_on: bool, area: bool) -> StepInstruction {
        StepInstruction {
            relative_direction,
            distance,
            from_level,
            to_level,
            osm_way: None,
            polyline: Box::new(polyline),
            street_name,
            exit,
            stay_on,
            area,
        }
    }
}

