/*
RailControl - Model Railway Control Software

Copyright (c) 2017-2025 by Teddy / Dominik Mahrer - www.railcontrol.org

RailControl is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3, or (at your option) any
later version.

RailControl is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with RailControl; see the file LICENCE. If not see
<http://www.gnu.org/licenses/>.
*/

#include "Hardware/DccPpExTcp.h"
#include "Utils/Utils.h"

using std::string;

namespace Hardware
{
	DccPpExTcp::DccPpExTcp(const HardwareParams* params)
	:	DccPpEx(params,
			"DCC-EX TCP / " + params->GetName() + " at IP " + params->GetArg1(),
			params->GetName()),
	 	connection(Network::TcpClient::GetTcpClientConnection(logger, params->GetArg1(), Port))
	{
		logger->Info(Languages::TextStarting, GetFullName());

		if (connection.IsConnected() == false)
		{
			logger->Error(Languages::TextUnableToCreateTcpSocket, params->GetArg1(), Port);
		}
		Init();
	}

	bool DccPpExTcp::Send(const string& buffer)
	{
		const bool ret = connection.Send(buffer) != -1;
		if (!ret)
		{
			logger->Error(Languages::TextUnableToSendDataToControl);
		}
		return ret;
	}

	bool DccPpExTcp::Receive(string& buffer)
	{
		return connection.Receive(buffer);
	}
} // namespace
