% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch.R
\name{batch}
\alias{batch}
\title{Run a function in batch mode}
\usage{
batch(
  items,
  fun,
  ...,
  show.progress = !is_aqua() && !is_jgr(),
  suppress.messages = show.progress,
  verbose = TRUE
)
}
\arguments{
\item{items}{The items (usually, arguments vector of character strings) on
which to apply \code{fun} sequentially.}

\item{fun}{The function to run (must return \code{TRUE} or \code{FALSE} and issue only
warnings or messages to be a good candidate, batchable, function).}

\item{...}{Further arguments to pass the \code{fun}.}

\item{show.progress}{Do we show progression as item x on y... message? This
uses the \code{\link[=progress]{progress()}} function.}

\item{suppress.messages}{Are messages from the batchable function suppressed?
Only warnings will be issued. Recommended if \code{show.progress = TRUE}.}

\item{verbose}{Display start and end messages if \code{TRUE} (default).}
}
\value{
Returns invisibly the number of items that were correctly processed
with attributes \code{items} and \code{ok} giving more details.
}
\description{
A function can be run in batch mode if it never fails (replace
errors by warnings) and returns \code{TRUE} in case of success, or \code{FALSE} otherwise.
}
\examples{
\dontrun{
# Here is a fake batchable process
fake_process <- function(file) {
  message("Processing ", file, "...")
  flush.console()
  Sys.sleep(0.5)
  if (runif(1) > 0.7) { # Fails
    warning("fake_process was unable to process ", file)
    invisible(FALSE)
  } else invisible(TRUE)
}

# Run it in batch mode on five items
files <- paste0("file", 1:5)
batch(files, fake_process)
}
}
\seealso{
\code{\link[=progress]{progress()}}
}
\concept{batch processing}
\keyword{utilities}
