/*
 * Contributed by Stephane Eranian <eranian@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * This file is part of libpfm, a performance monitoring support library for
 * applications on Linux.
 *
 * PMU: icx_unc_upi (IcelakeX Uncore UPI)
 * Based on Intel JSON event table version   : 1.21
 * Based on Intel JSON event table published : 06/06/2023
 */
static const intel_x86_umask_t icx_unc_upi_direct_attempts[]={
  { .uname   = "D2C",
    .udesc   = "D2C (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "D2K",
    .udesc   = "D2K (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_upi_flowq_no_vna_crd[]={
  { .uname   = "AD_VNA_EQ0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_VNA_EQ1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_VNA_EQ2",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_VNA_EQ0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_VNA_EQ1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_VNA_EQ2",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_VNA_EQ3",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_VNA_EQ0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_upi_m3_byp_blocked[]={
  { .uname   = "BGF_CRD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLOWQ_AD_VNA_LE2",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLOWQ_AK_VNA_LE3",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLOWQ_BL_VNA_EQ0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "GV_BLOCK",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_upi_m3_rxq_blocked[]={
  { .uname   = "BGF_CRD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLOWQ_AD_VNA_BTW_2_THRESH",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLOWQ_AD_VNA_LE2",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLOWQ_AK_VNA_LE3",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLOWQ_BL_VNA_BTW_0_THRESH",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLOWQ_BL_VNA_EQ0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "GV_BLOCK",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_upi_req_slot2_from_m3[]={
  { .uname   = "ACK",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VNA",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_upi_rxl_flits[]={
  { .uname   = "ALL_DATA",
    .udesc   = "All Data",
    .ucode   = 0x0f00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ALL_NULL",
    .udesc   = "Null FLITs received from any slot",
    .ucode   = 0x2700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DATA",
    .udesc   = "Data (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IDLE",
    .udesc   = "Null FLITs received from any slot (experimental)",
    .ucode   = 0x4700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLCRD",
    .udesc   = "LLCRD Not Empty (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLCTRL",
    .udesc   = "LLCTRL (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NON_DATA",
    .udesc   = "All Non Data",
    .ucode   = 0x9700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NULL",
    .udesc   = "Slot NULL or LLCRD Empty (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PROTHDR",
    .udesc   = "Protocol Header (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT0",
    .udesc   = "Slot 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT1",
    .udesc   = "Slot 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT2",
    .udesc   = "Slot 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_upi_rxl_inserts[]={
  { .uname   = "SLOT0",
    .udesc   = "Slot 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT1",
    .udesc   = "Slot 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT2",
    .udesc   = "Slot 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_upi_rxl_occupancy[]={
  { .uname   = "SLOT0",
    .udesc   = "Slot 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT1",
    .udesc   = "Slot 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT2",
    .udesc   = "Slot 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_upi_rxl_slot_bypass[]={
  { .uname   = "S0_RXQ1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S0_RXQ2",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S1_RXQ0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S1_RXQ2",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S2_RXQ0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S2_RXQ1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_upi_txl0p_clk_active[]={
  { .uname   = "CFG_CTL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DFX",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RETRY",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RXQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RXQ_BYPASS",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RXQ_CRED",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SPARE",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TXQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_upi_txl_basic_hdr_match[]={
  { .uname   = "NCB",
    .udesc   = "Non-Coherent Bypass (experimental)",
    .ucode   = 0x0e00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCB_OPC",
    .udesc   = "Non-Coherent Bypass, Match Opcode (experimental)",
    .ucode   = 0x100000e00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCS",
    .udesc   = "Non-Coherent Standard (experimental)",
    .ucode   = 0x0f00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCS_OPC",
    .udesc   = "Non-Coherent Standard, Match Opcode (experimental)",
    .ucode   = 0x100000f00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REQ",
    .udesc   = "Request (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REQ_OPC",
    .udesc   = "Request, Match Opcode (experimental)",
    .ucode   = 0x100000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPCNFLT",
    .udesc   = "Response - Conflict (experimental)",
    .ucode   = 0x10000aa00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPI",
    .udesc   = "Response - Invalid (experimental)",
    .ucode   = 0x100002a00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSP_DATA",
    .udesc   = "Response - Data (experimental)",
    .ucode   = 0x0c00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSP_DATA_OPC",
    .udesc   = "Response - Data, Match Opcode (experimental)",
    .ucode   = 0x100000c00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSP_NODATA",
    .udesc   = "Response - No Data (experimental)",
    .ucode   = 0x0a00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSP_NODATA_OPC",
    .udesc   = "Response - No Data, Match Opcode (experimental)",
    .ucode   = 0x100000a00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SNP",
    .udesc   = "Snoop (experimental)",
    .ucode   = 0x0900ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SNP_OPC",
    .udesc   = "Snoop, Match Opcode (experimental)",
    .ucode   = 0x100000900ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WB",
    .udesc   = "Writeback (experimental)",
    .ucode   = 0x0d00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WB_OPC",
    .udesc   = "Writeback, Match Opcode (experimental)",
    .ucode   = 0x100000d00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_upi_txl_flits[]={
  { .uname   = "ALL_DATA",
    .udesc   = "All Data",
    .ucode   = 0x0f00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ALL_NULL",
    .udesc   = "Null FLITs transmitted to any slot",
    .ucode   = 0x2700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DATA",
    .udesc   = "Data (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IDLE",
    .udesc   = "Idle (experimental)",
    .ucode   = 0x4700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLCRD",
    .udesc   = "LLCRD Not Empty (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLCTRL",
    .udesc   = "LLCTRL (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NON_DATA",
    .udesc   = "All Non Data",
    .ucode   = 0x9700ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NULL",
    .udesc   = "Slot NULL or LLCRD Empty (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PROTHDR",
    .udesc   = "Protocol Header (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT0",
    .udesc   = "Slot 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT1",
    .udesc   = "Slot 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOT2",
    .udesc   = "Slot 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_entry_t intel_icx_unc_upi_ll_pe[]={
  { .name   = "UNC_UPI_CLOCKTICKS",
    .desc   = "Number of kfclks",
    .code   = 0x0001,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_DIRECT_ATTEMPTS",
    .desc   = "Direct packet attempts",
    .code   = 0x0012,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_upi_direct_attempts),
    .umasks = icx_unc_upi_direct_attempts,
  },
  { .name   = "UNC_UPI_FLOWQ_NO_VNA_CRD",
    .desc   = "UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ0",
    .code   = 0x0018,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_upi_flowq_no_vna_crd),
    .umasks = icx_unc_upi_flowq_no_vna_crd,
  },
  { .name   = "UNC_UPI_L1_POWER_CYCLES",
    .desc   = "Cycles in L1",
    .code   = 0x0021,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_M3_BYP_BLOCKED",
    .desc   = "UNC_UPI_M3_BYP_BLOCKED.FLOWQ_AD_VNA_LE2",
    .code   = 0x0014,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_upi_m3_byp_blocked),
    .umasks = icx_unc_upi_m3_byp_blocked,
  },
  { .name   = "UNC_UPI_M3_CRD_RETURN_BLOCKED",
    .desc   = "UNC_UPI_M3_CRD_RETURN_BLOCKED (experimental)",
    .code   = 0x0016,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_M3_RXQ_BLOCKED",
    .desc   = "UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AD_VNA_LE2",
    .code   = 0x0015,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_upi_m3_rxq_blocked),
    .umasks = icx_unc_upi_m3_rxq_blocked,
  },
  { .name   = "UNC_UPI_PHY_INIT_CYCLES",
    .desc   = "Cycles where phy is not in L0, L0c, L0p, L1 (experimental)",
    .code   = 0x0020,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_POWER_L1_NACK",
    .desc   = "L1 Req Nack (experimental)",
    .code   = 0x0023,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_POWER_L1_REQ",
    .desc   = "L1 Req (same as L1 Ack). (experimental)",
    .code   = 0x0022,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_REQ_SLOT2_FROM_M3",
    .desc   = "UNC_UPI_REQ_SLOT2_FROM_M3.VNA",
    .code   = 0x0046,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_upi_req_slot2_from_m3),
    .umasks = icx_unc_upi_req_slot2_from_m3,
  },
  { .name   = "UNC_UPI_RxL0P_POWER_CYCLES",
    .desc   = "Cycles in L0p (experimental)",
    .code   = 0x0025,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_RxL0_POWER_CYCLES",
    .desc   = "Cycles in L0 (experimental)",
    .code   = 0x0024,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_RxL_BASIC_HDR_MATCH",
    .desc   = "Matches on Receive path of a UPI Port",
    .code   = 0x0005,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_upi_txl_basic_hdr_match), /* shared */
    .umasks = icx_unc_upi_txl_basic_hdr_match,
  },
  { .name   = "UNC_UPI_RxL_BYPASSED",
    .desc   = "RxQ Flit Buffer Bypassed",
    .code   = 0x0031,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_upi_rxl_inserts), /* shared */
    .umasks = icx_unc_upi_rxl_inserts,
  },
  { .name   = "UNC_UPI_RxL_CRC_ERRORS",
    .desc   = "CRC Errors Detected (experimental)",
    .code   = 0x000b,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_RxL_CRC_LLR_REQ_TRANSMIT",
    .desc   = "LLR Requests Sent (experimental)",
    .code   = 0x0008,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_RxL_CREDITS_CONSUMED_VN0",
    .desc   = "VN0 Credit Consumed (experimental)",
    .code   = 0x0039,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_RxL_CREDITS_CONSUMED_VN1",
    .desc   = "VN1 Credit Consumed (experimental)",
    .code   = 0x003a,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_RxL_CREDITS_CONSUMED_VNA",
    .desc   = "VNA Credit Consumed (experimental)",
    .code   = 0x0038,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_RxL_FLITS",
    .desc   = "Valid Flits Received",
    .code   = 0x0003,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_upi_rxl_flits),
    .umasks = icx_unc_upi_rxl_flits,
  },
  { .name   = "UNC_UPI_RxL_INSERTS",
    .desc   = "RxQ Flit Buffer Allocations",
    .code   = 0x0030,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_upi_rxl_inserts),
    .umasks = icx_unc_upi_rxl_inserts,
  },
  { .name   = "UNC_UPI_RxL_OCCUPANCY",
    .desc   = "RxQ Occupancy - All Packets",
    .code   = 0x0032,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_upi_rxl_occupancy),
    .umasks = icx_unc_upi_rxl_occupancy,
  },
  { .name   = "UNC_UPI_RxL_SLOT_BYPASS",
    .desc   = "UNC_UPI_RxL_SLOT_BYPASS.S0_RXQ1",
    .code   = 0x0033,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_upi_rxl_slot_bypass),
    .umasks = icx_unc_upi_rxl_slot_bypass,
  },
  { .name   = "UNC_UPI_TxL0P_CLK_ACTIVE",
    .desc   = "UNC_UPI_TxL0P_CLK_ACTIVE.CFG_CTL",
    .code   = 0x002a,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_upi_txl0p_clk_active),
    .umasks = icx_unc_upi_txl0p_clk_active,
  },
  { .name   = "UNC_UPI_TxL0P_POWER_CYCLES",
    .desc   = "Cycles in L0p",
    .code   = 0x0027,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_TxL0P_POWER_CYCLES_LL_ENTER",
    .desc   = "UNC_UPI_TxL0P_POWER_CYCLES_LL_ENTER (experimental)",
    .code   = 0x0028,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_TxL0P_POWER_CYCLES_M3_EXIT",
    .desc   = "UNC_UPI_TxL0P_POWER_CYCLES_M3_EXIT (experimental)",
    .code   = 0x0029,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_TxL0_POWER_CYCLES",
    .desc   = "Cycles in L0 (experimental)",
    .code   = 0x0026,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_TxL_BASIC_HDR_MATCH",
    .desc   = "Matches on Transmit path of a UPI Port",
    .code   = 0x0004,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_upi_txl_basic_hdr_match),
    .umasks = icx_unc_upi_txl_basic_hdr_match,
  },
  { .name   = "UNC_UPI_TxL_BYPASSED",
    .desc   = "Tx Flit Buffer Bypassed (experimental)",
    .code   = 0x0041,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_TxL_FLITS",
    .desc   = "Valid Flits Sent",
    .code   = 0x0002,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_upi_txl_flits),
    .umasks = icx_unc_upi_txl_flits,
  },
  { .name   = "UNC_UPI_TxL_INSERTS",
    .desc   = "Tx Flit Buffer Allocations (experimental)",
    .code   = 0x0040,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_TxL_OCCUPANCY",
    .desc   = "Tx Flit Buffer Occupancy (experimental)",
    .code   = 0x0042,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_VNA_CREDIT_RETURN_BLOCKED_VN01",
    .desc   = "UNC_UPI_VNA_CREDIT_RETURN_BLOCKED_VN01 (experimental)",
    .code   = 0x0045,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_UPI_VNA_CREDIT_RETURN_OCCUPANCY",
    .desc   = "VNA Credits Pending Return - Occupancy (experimental)",
    .code   = 0x0044,
    .modmsk = ICX_UNC_UPI_ATTRS,
    .cntmsk = 0xfull,
  },
};
/* 36 events available */
