/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToTurbomoleEcpInput
extends AbstractBasisSetXmlToText {
    protected String mTitle = "";

    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        return this.readECP(data, elementList);
    }

    @Override
    protected void addHeaderECP(StringBuffer output, Element root) {
        this.mTitle = root.getChildText("title", BSEProperties.mDcNs);
        output.append("  $ecp \n");
    }

    @Override
    protected void addFooterECP(StringBuffer output) {
        output.append("*\n");
        output.append("  $end\n");
    }

    @Override
    protected void addElementDescriptionECP(StringBuffer output, Element potentials, String element) {
        String nelec = potentials.getAttributeValue("numElectronsReplaced");
        int size = potentials.getChildren("potential", BSEProperties.mBseNs).size() - 1;
        output.append("*\n");
        output.append(element.toLowerCase() + "  " + this.mTitle + "\n");
        output.append("*\n");
        output.append("   ncore =  " + nelec + "   lmax =    " + size + "\n");
    }

    @Override
    protected void readCmlMatrixECP(StringBuffer output, Matrix matrix, String element, String shell, String potentialType) throws FormatException {
        int rows = matrix.getNumRows();
        int columns = matrix.getNumColumns();
        String[] pTypeArr = potentialType.split(" ");
        output.append(pTypeArr[0] + "\n");
        try {
            for (int i = 0; i < rows; ++i) {
                String value = this.formattedValue(matrix.getValue(i, columns - 1));
                output.append(value);
                output.append(matrix.getValue(i, 0));
                for (int j = 1; j < columns - 1; ++j) {
                    value = this.formattedValue(matrix.getValue(i, j));
                    output.append(value);
                }
                output.append("\n");
            }
        }
        catch (IndexOutOfBoundsException ie) {
            throw new FormatException(ie.getMessage());
        }
    }
}

