//
// Copyright (c) 2020, NVIDIA CORPORATION.  All rights reserved.
//
// NVIDIA CORPORATION and its licensors retain all intellectual property
// and proprietary rights in and to this software, related documentation
// and any modifications thereto.  Any use, reproduction, disclosure or
// distribution of this software and related documentation without an express
// license agreement from NVIDIA CORPORATION is strictly prohibited.
//

#pragma once

#include "cqi.hpp"
#include "nvswitch_dev.hpp"

#include "nscq/types.hpp"

#include <memory>
#include <vector>

namespace nscq::cqi {

struct nvswitch_drv : public cqi {
    using cqi_t = nvswitch_drv;
    using cqi::cqi;
    virtual auto get_ids(type<nvswitch_dev_base>) -> std::vector<nvswitch_dev_base::id_t> = 0;
    virtual auto make_cqi(type<nvswitch_dev_base>, const nvswitch_dev_base::id_t&)
        -> std::shared_ptr<nvswitch_dev_base> = 0;

    struct version_field : public field<nvswitch_drv, readable<std::shared_ptr<nscq::label>>> {};
    virtual auto get(version_field) -> std::shared_ptr<nscq::label> = 0;
};

} // namespace nscq::cqi
