### BibLaTeX Examples from CTAN

- PrismJS version: 1.19.0
- PrismJS theme: okaidia

Source: <http://mirror.ctan.org/macros/latex/contrib/biblatex/bibtex/bib/biblatex/biblatex-examples.bib>

```bib
{% raw %}@string{anch-ie = {Angew.~Chem. Int.~Ed.}}
@string{cup     = {Cambridge University Press}}
@string{dtv     = {Deutscher Taschenbuch-Verlag}}
@string{hup     = {Harvard University Press}}
@string{jams    = {J.~Amer. Math. Soc.}}
@string{jchph   = {J.~Chem. Phys.}}
@string{jomch   = {J.~Organomet. Chem.}}
@string{pup     = {Princeton University Press}}

@incollection{westfahl:space,
  author       = {Westfahl, Gary},
  title        = {The True Frontier},
  subtitle     = {Confronting and Avoiding the Realities of Space in {American}
                  Science Fiction Films},
  pages        = {55-65},
  crossref     = {westfahl:frontier},
  langid       = {english},
  langidopts   = {variant=american},
  indextitle   = {True Frontier, The},
  annotation   = {A cross-referenced article from a \texttt{collection}. This is
                  an \texttt{incollection} entry with a \texttt{crossref}
                  field. Note the \texttt{subtitle} and \texttt{indextitle}
                  fields},
}

@set{set,
  entryset     = {herrmann,aksin,yoon},
  annotation   = {A \texttt{set} with three members. The \texttt{crossref} field
                  in the \texttt{@set} entry and the \texttt{entryset} field in
                  each set member entry is needed only when using BibTeX as the
                  backend},
}

@set{stdmodel,
  entryset     = {glashow,weinberg,salam},
  annotation   = {A \texttt{set} with three members discussing the standard
                  model of particle physics. The \texttt{crossref} field
                  in the \texttt{@set} entry and the \texttt{entryset} field in
                  each set member entry is needed only when using BibTeX as the
                  backend},
}

@article{aksin,
  author       = {Aks{\i}n, {\"O}zge and T{\"u}rkmen, Hayati and Artok, Levent
                  and {\c{C}}etinkaya, Bekir and Ni, Chaoying and
                  B{\"u}y{\"u}kg{\"u}ng{\"o}r, Orhan and {\"O}zkal, Erhan},
  title        = {Effect of immobilization on catalytic characteristics of
                  saturated {Pd-N}-heterocyclic carbenes in {Mizoroki-Heck}
                  reactions},
  journaltitle = jomch,
  date         = 2006,
  volume       = 691,
  number       = 13,
  pages        = {3027-3036},
  indextitle   = {Effect of immobilization on catalytic characteristics},
}

@article{angenendt,
  author       = {Angenendt, Arnold},
  title        = {In Honore Salvatoris~-- Vom Sinn und Unsinn der
                  Patrozinienkunde},
  journaltitle = {Revue d'Histoire Eccl{\'e}siastique},
  date         = 2002,
  volume       = 97,
  pages        = {431--456, 791--823},
  langid       = {german},
  indextitle   = {In Honore Salvatoris},
  shorttitle   = {In Honore Salvatoris},
  annotation   = {A German article in a French journal. Apart from that, a
                  typical \texttt{article} entry. Note the \texttt{indextitle}
                  field},
}

@article{baez/article,
  author       = {Baez, John C. and Lauda, Aaron D.},
  title        = {Higher-Dimensional Algebra {V}: 2-Groups},
  journaltitle = {Theory and Applications of Categories},
  date         = 2004,
  volume       = 12,
  pages        = {423-491},
  version      = 3,
  eprint       = {math/0307200v3},
  eprinttype   = {arxiv},
  langid       = {english},
  langidopts   = {variant=american},
  annotation   = {An \texttt{article} with \texttt{eprint} and
                  \texttt{eprinttype} fields. Note that the arXiv reference is
                  transformed into a clickable link if \texttt{hyperref} support
                  has been enabled.  Compare \texttt{baez\slash online}, which
                  is the same item given as an \texttt{online} entry},
}

@article{bertram,
  author       = {Bertram, Aaron and Wentworth, Richard},
  title        = {Gromov invariants for holomorphic maps on {Riemann} surfaces},
  journaltitle = jams,
  date         = 1996,
  volume       = 9,
  number       = 2,
  pages        = {529-571},
  langid       = {english},
  langidopts   = {variant=american},
  shorttitle   = {Gromov invariants},
  annotation   = {An \texttt{article} entry with a \texttt{volume} and a
                  \texttt{number} field},
}

@article{doody,
  author       = {Doody, Terrence},
  title        = {Hemingway's Style and {Jake's} Narration},
  year         = 1974,
  volume       = 4,
  number       = 3,
  pages        = {212-225},
  langid       = {english},
  langidopts   = {variant=american},
  related      = {matuz:doody},
  relatedstring= {\autocap{e}xcerpt in},
  journal      = {The Journal of Narrative Technique},
  annotation   = {An \texttt{article} entry cited as an excerpt from a
                  \texttt{collection} entry. Note the format of the
                  \texttt{related} and \texttt{relatedstring} fields},
}

@collection{matuz:doody,
  editor       = {Matuz, Roger},
  title        = {Contemporary Literary Criticism},
  year         = 1990,
  volume       = 61,
  publisher    = {Gale},
  location     = {Detroit},
  pages        = {204-208},
  langid       = {english},
  langidopts   = {variant=american},
  annotation   = {A \texttt{collection} entry providing the excerpt information
                  for the \texttt{doody} entry. Note the format of the
                  \texttt{pages} field},
}

@article{gillies,
  author       = {Gillies, Alexander},
  title        = {Herder and the Preparation of {Goethe's} Idea of World
                  Literature},
  journaltitle = {Publications of the English Goethe Society},
  date         = 1933,
  series       = {newseries},
  volume       = 9,
  pages        = {46-67},
  langid       = {english},
  langidopts   = {variant=british},
  annotation   = {An \texttt{article} entry with a \texttt{series} and a
                  \texttt{volume} field. Note that format of the \texttt{series}
                  field in the database file},
}

@article{glashow,
  author       = {Glashow, Sheldon},
  title        = {Partial Symmetries of Weak Interactions},
  journaltitle = {Nucl.~Phys.},
  date         = 1961,
  volume       = 22,
  pages        = {579-588},
}

@article{herrmann,
  author       = {Herrmann, Wolfgang A. and {\"O}fele, Karl and Schneider,
                  Sabine K.  and Herdtweck, Eberhardt and Hoffmann, Stephan D.},
  title        = {A carbocyclic carbene as an efficient catalyst ligand for {C--C}
                  coupling reactions},
  journaltitle = anch-ie,
  date         = 2006,
  volume       = 45,
  number       = 23,
  pages        = {3859-3862},
  indextitle   = {Carbocyclic carbene as an efficient catalyst, A},
}

@article{kastenholz,
  author       = {Kastenholz, M. A. and H{\"u}nenberger, Philippe H.},
  title        = {Computation of methodology\hyphen independent ionic solvation
                  free energies from molecular simulations},
  journaltitle = jchph,
  date         = 2006,
  subtitle     = {{I}. {The} electrostatic potential in molecular liquids},
  volume       = 124,
  eid          = 124106,
  doi          = {10.1063/1.2172593},
  langid       = {english},
  langidopts   = {variant=american},
  indextitle   = {Computation of ionic solvation free energies},
  annotation   = {An \texttt{article} entry with an \texttt{eid} and a
                  \texttt{doi} field. Note that the \textsc{doi} is transformed
                  into a clickable link if \texttt{hyperref} support has been
                  enabled},
  abstract     = {The computation of ionic solvation free energies from
                  atomistic simulations is a surprisingly difficult problem that
                  has found no satisfactory solution for more than 15 years. The
                  reason is that the charging free energies evaluated from such
                  simulations are affected by very large errors. One of these is
                  related to the choice of a specific convention for summing up
                  the contributions of solvent charges to the electrostatic
                  potential in the ionic cavity, namely, on the basis of point
                  charges within entire solvent molecules (M scheme) or on the
                  basis of individual point charges (P scheme). The use of an
                  inappropriate convention may lead to a charge-independent
                  offset in the calculated potential, which depends on the
                  details of the summation scheme, on the quadrupole-moment
                  trace of the solvent molecule, and on the approximate form
                  used to represent electrostatic interactions in the
                  system. However, whether the M or P scheme (if any) represents
                  the appropriate convention is still a matter of on-going
                  debate. The goal of the present article is to settle this
                  long-standing controversy by carefully analyzing (both
                  analytically and numerically) the properties of the
                  electrostatic potential in molecular liquids (and inside
                  cavities within them).},
}

@article{murray,
  author       = {Hostetler, Michael J. and Wingate, Julia E. and Zhong,
                  Chuan-Jian and Harris, Jay E. and Vachet, Richard W. and
                  Clark, Michael R.  and Londono, J. David and Green, Stephen
                  J. and Stokes, Jennifer J.  and Wignall, George D. and Glish,
                  Gary L. and Porter, Marc D.  and Evans, Neal D. and Murray,
                  Royce W.},
  title        = {Alkanethiolate gold cluster molecules with core diameters from
                  1.5 to 5.2~{nm}},
  journaltitle = {Langmuir},
  date         = 1998,
  subtitle     = {Core and monolayer properties as a function of core size},
  volume       = 14,
  number       = 1,
  pages        = {17-30},
  langid       = {english},
  langidopts   = {variant=american},
  indextitle   = {Alkanethiolate gold cluster molecules},
  shorttitle   = {Alkanethiolate gold cluster molecules},
  annotation   = {An \texttt{article} entry with \arabic{author} authors. By
                  default, long author and editor lists are automatically
                  truncated. This is configurable},
}

@article{reese,
  author       = {Reese, Trevor R.},
  title        = {Georgia in {Anglo-Spanish} Diplomacy, 1736--1739},
  journaltitle = {William and Mary Quarterly},
  date         = 1958,
  series       = 3,
  volume       = 15,
  pages        = {168-190},
  langid       = {english},
  langidopts   = {variant=american},
  annotation   = {An \texttt{article} entry with a \texttt{series} and a
                  \texttt{volume} field. Note the format of the series. If the
                  value of the \texttt{series} field is an integer, this number
                  is printed as an ordinal and the string \enquote*{series} is
                  appended automatically},
}

@article{sarfraz,
  author       = {M. Sarfraz and M. F. A. Razzak},
  title        = {Technical section: {An} algorithm for automatic capturing of
                  the font outlines},
  year         = 2002,
  volume       = 26,
  number       = 5,
  pages        = {795-804},
  issn         = {0097-8493},
  journal      = {Computers and Graphics},
  annotation   = {An \texttt{article} entry with an \texttt{issn} field},
}

@article{shore,
  author       = {Shore, Bradd},
  title        = {Twice-Born, Once Conceived},
  journaltitle = {American Anthropologist},
  date         = {1991-03},
  subtitle     = {Meaning Construction and Cultural Cognition},
  series       = {newseries},
  volume       = 93,
  number       = 1,
  pages        = {9-27},
  annotation   = {An \texttt{article} entry with \texttt{series},
                  \texttt{volume}, and \texttt{number} fields. Note the format
                  of the \texttt{series} which is a localization key},
}

@article{sigfridsson,
  author       = {Sigfridsson, Emma and Ryde, Ulf},
  title        = {Comparison of methods for deriving atomic charges from the
                  electrostatic potential and moments},
  journaltitle = {Journal of Computational Chemistry},
  date         = 1998,
  volume       = 19,
  number       = 4,
  pages        = {377-395},
  doi          = {10.1002/(SICI)1096-987X(199803)19:4<377::AID-JCC1>3.0.CO;2-P},
  langid       = {english},
  langidopts   = {variant=american},
  indextitle   = {Methods for deriving atomic charges},
  annotation   = {An \texttt{article} entry with \texttt{volume},
                  \texttt{number}, and \texttt{doi} fields. Note that the
                  \textsc{doi} is transformed into a clickable link if
                  \texttt{hyperref} support has been enabled},
  abstract     = {Four methods for deriving partial atomic charges from the
                  quantum chemical electrostatic potential (CHELP, CHELPG,
                  Merz-Kollman, and RESP) have been compared and critically
                  evaluated. It is shown that charges strongly depend on how and
                  where the potential points are selected. Two alternative
                  methods are suggested to avoid the arbitrariness in the
                  point-selection schemes and van der Waals exclusion radii:
                  CHELP-BOW, which also estimates the charges from the
                  electrostatic potential, but with potential points that are
                  Boltzmann-weighted after their occurrence in actual
                  simulations using the energy function of the program in which
                  the charges will be used, and CHELMO, which estimates the
                  charges directly from the electrostatic multipole
                  moments. Different criteria for the quality of the charges are
                  discussed.},
}

@article{spiegelberg,
  author       = {Spiegelberg, Herbert},
  title        = {\mkbibquote{Intention} und \mkbibquote{Intentionalit{\"a}t} in
                  der Scholastik, bei Brentano und Husserl},
  journaltitle = {Studia Philosophica},
  date         = 1969,
  volume       = 29,
  pages        = {189-216},
  langid       = {german},
  sorttitle    = {Intention und Intentionalitat in der Scholastik, bei Brentano
                  und Husserl},
  indexsorttitle= {Intention und Intentionalitat in der Scholastik, bei Brentano
                  und Husserl},
  shorttitle   = {Intention und Intentionalit{\"a}t},
  annotation   = {An \texttt{article} entry. Note the \texttt{sorttitle} and
                  \texttt{indexsorttitle} fields and the markup of the quotes in
                  the database file},
}

@article{springer,
  author       = {Springer, Otto},
  title        = {Mediaeval Pilgrim Routes from {Scandinavia} to {Rome}},
  journaltitle = {Mediaeval Studies},
  date         = 1950,
  volume       = 12,
  pages        = {92-122},
  langid       = {english},
  langidopts   = {variant=british},
  shorttitle   = {Mediaeval Pilgrim Routes},
  annotation   = {A plain \texttt{article} entry},
}

@article{weinberg,
  author       = {Weinberg, Steven},
  title        = {A Model of Leptons},
  journaltitle = {Phys.~Rev.~Lett.},
  date         = 1967,
  volume       = 19,
  pages        = {1264-1266},
}

@article{yoon,
  author       = {Yoon, Myeong S. and Ryu, Dowook and Kim, Jeongryul and Ahn,
                  Kyo Han},
  title        = {Palladium pincer complexes with reduced bond angle strain:
                  efficient catalysts for the {Heck} reaction},
  journaltitle = {Organometallics},
  date         = 2006,
  volume       = 25,
  number       = 10,
  pages        = {2409-2411},
  indextitle   = {Palladium pincer complexes},
}

@book{aristotle:anima,
  author       = {Aristotle},
  title        = {De Anima},
  date         = 1907,
  editor       = {Hicks, Robert Drew},
  publisher    = cup,
  location     = {Cambridge},
  keywords     = {primary},
  langid       = {english},
  langidopts   = {variant=british},
  annotation   = {A \texttt{book} entry with an \texttt{author} and an
                  \texttt{editor}},
}

@book{aristotle:physics,
  author       = {Aristotle},
  title        = {Physics},
  date         = 1929,
  translator   = {Wicksteed, P. H. and Cornford, F. M.},
  publisher    = {G. P. Putnam},
  location     = {New York},
  keywords     = {primary},
  langid       = {english},
  langidopts   = {variant=american},
  shorttitle   = {Physics},
  annotation   = {A \texttt{book} entry with a \texttt{translator} field},
}

@book{aristotle:poetics,
  author       = {Aristotle},
  title        = {Poetics},
  date         = 1968,
  editor       = {Lucas, D. W.},
  series       = {Clarendon {Aristotle}},
  publisher    = {Clarendon Press},
  location     = {Oxford},
  keywords     = {primary},
  langid       = {english},
  langidopts   = {variant=british},
  shorttitle   = {Poetics},
  annotation   = {A \texttt{book} entry with an \texttt{author} and an
                  \texttt{editor} as well as a \texttt{series} field},
}

@mvbook{aristotle:rhetoric,
  author       = {Aristotle},
  title        = {The Rhetoric of {Aristotle} with a commentary by the late {Edward
                  Meredith Cope}},
  date         = 1877,
  editor       = {Cope, Edward Meredith},
  commentator  = {Cope, Edward Meredith},
  volumes      = 3,
  publisher    = cup,
  keywords     = {primary},
  langid       = {english},
  langidopts   = {variant=british},
  sorttitle    = {Rhetoric of Aristotle},
  indextitle   = {Rhetoric of {Aristotle}, The},
  shorttitle   = {Rhetoric},
  annotation   = {A commented edition. Note the concatenation of the
                  \texttt{editor} and \texttt{commentator} fields as well as the
                  \texttt{volumes}, \texttt{sorttitle}, and \texttt{indextitle}
                  fields},
}

@book{augustine,
  author       = {Augustine, Robert L.},
  title        = {Heterogeneous catalysis for the synthetic chemist},
  date         = 1995,
  publisher    = {Marcel Dekker},
  location     = {New York},
  langid       = {english},
  langidopts   = {variant=american},
  shorttitle   = {Heterogeneous catalysis},
  annotation   = {A plain \texttt{book} entry},
}

@book{averroes/bland,
  author       = {Averroes},
  title        = {The Epistle on the Possibility of Conjunction with the Active
                  Intellect by {Ibn Rushd} with the Commentary of {Moses Narboni}},
  date         = 1982,
  editor       = {Bland, Kalman P.},
  translator   = {Bland, Kalman P.},
  series       = {Moreshet: Studies in {Jewish} History, Literature and Thought},
  number       = 7,
  publisher    = {Jewish Theological Seminary of America},
  location     = {New York},
  keywords     = {primary},
  langid       = {english},
  langidopts   = {variant=american},
  indextitle   = {Epistle on the Possibility of Conjunction, The},
  shorttitle   = {Possibility of Conjunction},
  annotation   = {A \texttt{book} entry with a \texttt{series} and a
                  \texttt{number}. Note the concatenation of the \texttt{editor}
                  and \texttt{translator} fields as well as the
                  \texttt{indextitle} field},
}

@book{averroes/hannes,
  author       = {Averroes},
  title        = {Des Averro{\"e}s Abhandlung: \mkbibquote{{\"U}ber die
                  M{\"o}glichkeit der Conjunktion} oder \mkbibquote{{\"U}ber den
                  materiellen Intellekt}},
  date         = 1892,
  editor       = {Hannes, Ludwig},
  translator   = {Hannes, Ludwig},
  annotator    = {Hannes, Ludwig},
  publisher    = {C.~A. Kaemmerer},
  location     = {Halle an der Saale},
  keywords     = {primary},
  langid       = {german},
  sorttitle    = {Uber die Moglichkeit der Conjunktion},
  indexsorttitle= {Uber die Moglichkeit der Conjunktion},
  indextitle   = {{\"U}ber die M{\"o}glichkeit der Conjunktion},
  shorttitle   = {{\"U}ber die M{\"o}glichkeit der Conjunktion},
  annotation   = {An annotated edition. Note the concatenation of the
                  \texttt{editor}, \texttt{translator}, and \texttt{annotator}
                  fields. Also note the \texttt{shorttitle},
                  \texttt{indextitle}, \texttt{sorttitle}, and
                  \texttt{indexsorttitle} fields},
}

@book{averroes/hercz,
  author       = {Averroes},
  title        = {Drei Abhandlungen {\"u}ber die Conjunction des separaten
                  Intellects mit dem Menschen},
  date         = 1869,
  editor       = {Hercz, J.},
  translator   = {Hercz, J.},
  publisher    = {S.~Hermann},
  location     = {Berlin},
  keywords     = {primary},
  langid       = {german},
  indexsorttitle= {Drei Abhandlungen uber die Conjunction},
  indextitle   = {Drei Abhandlungen {\"u}ber die Conjunction},
  subtitle     = {Von Averroes (Vater und Sohn), aus dem Arabischen
                  {\"u}bersetzt von Samuel Ibn Tibbon},
  shorttitle   = {Drei Abhandlungen},
  annotation   = {A \texttt{book} entry. Note the concatenation of the
                  \texttt{editor} and \texttt{translator} fields as well as the
                  \texttt{indextitle} and \texttt{indexsorttitle} fields},
}

@book{cicero,
  author       = {Cicero, Marcus Tullius},
  title        = {De natura deorum. {\"U}ber das Wesen der G{\"o}tter},
  date         = 1995,
  editor       = {Blank-Sangmeister, Ursula},
  translator   = {Blank-Sangmeister, Ursula},
  afterword    = {Thraede, Klaus},
  language     = {langlatin and langgerman},
  publisher    = {Reclam},
  location     = {Stuttgart},
  langid       = {german},
  indextitle   = {De natura deorum},
  shorttitle   = {De natura deorum},
  annotation   = {A bilingual edition of Cicero's \emph{De natura deorum}, with
                  a German translation. Note the format of the \texttt{language}
                  field in the database file, the concatenation of the
                  \texttt{editor} and \texttt{translator} fields, and the
                  \texttt{afterword} field},
}

@book{coleridge,
  author       = {Coleridge, Samuel Taylor},
  title        = {Biographia literaria, or {Biographical} sketches of my literary
                  life and opinions},
  date         = 1983,
  editor       = {Coburn, Kathleen and Engell, James and Bate, W. Jackson},
  maintitle    = {The collected works of {Samuel Taylor Coleridge}},
  volume       = 7,
  part         = 2,
  series       = {Bollingen Series},
  number       = 75,
  publisher    = {Routledge {and} Kegan Paul},
  location     = {London},
  langid       = {english},
  langidopts   = {variant=british},
  indextitle   = {Biographia literaria},
  shorttitle   = {Biographia literaria},
  annotation   = {One (partial) volume of a multivolume book. This is a
                  \texttt{book} entry with a \texttt{volume} and a \texttt{part}
                  field which explicitly refers to the second (physical) part of
                  the seventh (logical) volume. Also note the \texttt{series}
                  and \texttt{number} fields},
}

@book{companion,
  author       = {Goossens, Michel and Mittelbach, Frank and Samarin, Alexander},
  title        = {The {LaTeX} Companion},
  date         = 1994,
  edition      = 1,
  publisher    = {Addison-Wesley},
  location     = {Reading, Mass.},
  pagetotal    = 528,
  langid       = {english},
  langidopts   = {variant=american},
  sorttitle    = {LaTeX Companion},
  indextitle   = {LaTeX Companion, The},
  shorttitle   = {LaTeX Companion},
  annotation   = {A book with three authors. Note the formatting of the author
                  list. By default, only the first name is reversed in the
                  bibliography},
}

@book{cotton,
  author       = {Cotton, Frank Albert and Wilkinson, Geoffrey and Murillio,
                  Carlos A. and Bochmann, Manfred},
  title        = {Advanced inorganic chemistry},
  date         = 1999,
  edition      = 6,
  publisher    = {Wiley},
  location     = {Chichester},
  langid       = {english},
  langidopts   = {variant=british},
  annotation   = {A \texttt{book} entry with \arabic{author} authors and an
                  \texttt{edition} field. By default, long \texttt{author} and
                  \texttt{editor} lists are automatically truncated. This is
                  configurable},
}

@book{gerhardt,
  author       = {Gerhardt, Michael J.},
  title        = {The Federal Appointments Process},
  date         = 2000,
  publisher    = {Duke University Press},
  location     = {Durham and London},
  langid       = {english},
  langidopts   = {variant=american},
  sorttitle    = {Federal Appointments Process},
  indextitle   = {Federal Appointments Process, The},
  subtitle     = {A Constitutional and Historical Analysis},
  shorttitle   = {Federal Appointments Process},
  annotation   = {This is a \texttt{book} entry. Note the format of the
                  \texttt{location} field as well as the \texttt{sorttitle} and
                  \texttt{indextitle} fields},
}

@book{gonzalez,
  author       = {Gonzalez, Ray},
  title        = {The Ghost of {John Wayne} and Other Stories},
  date         = 2001,
  publisher    = {The University of Arizona Press},
  location     = {Tucson},
  isbn         = {0-816-52066-6},
  langid       = {english},
  langidopts   = {variant=american},
  sorttitle    = {Ghost of John Wayne and Other Stories},
  indextitle   = {Ghost of {John Wayne} and Other Stories, The},
  shorttitle   = {Ghost of {John Wayne}},
  annotation   = {A collection of short stories. This is a \texttt{book} entry.
                  Note the \texttt{sorttitle} and \texttt{indextitle} fields in
                  the database file. There's also an \texttt{isbn} field},
}

@book{hammond,
  author       = {Hammond, Christopher},
  title        = {The basics of crystallography and diffraction},
  date         = 1997,
  publisher    = {International Union of Crystallography and Oxford University
                  Press},
  location     = {Oxford},
  langid       = {english},
  langidopts   = {variant=british},
  sorttitle    = {Basics of crystallography and diffraction},
  indextitle   = {Basics of crystallography and diffraction, The},
  shorttitle   = {Crystallography and diffraction},
  annotation   = {A \texttt{book} entry. Note the \texttt{sorttitle} and
                  \texttt{indextitle} fields as well as the format of the
                  \texttt{publisher} field},
}

@book{iliad,
  author       = {Homer},
  title        = {Die Ilias},
  date         = 2004,
  translator   = {Schadewaldt, Wolfgang},
  introduction = {Latacz, Joachim},
  edition      = 3,
  publisher    = {Artemis \& Winkler},
  location     = {D{\"u}sseldorf and Z{\"u}rich},
  langid       = {german},
  sorttitle    = {Ilias},
  indextitle   = {Ilias, Die},
  shorttitle   = {Ilias},
  annotation   = {A German translation of the \emph{Iliad}. Note the
                  \texttt{translator} and \texttt{introduction} fields and the
                  format of the \texttt{location} field in the database
                  file. Also note the \texttt{sorttitle} and \texttt{indextitle}
                  fields},
}

@mvbook{knuth:ct,
  author       = {Knuth, Donald E.},
  title        = {Computers \& Typesetting},
  date         = {1984/1986},
  volumes      = 5,
  publisher    = {Addison-Wesley},
  location     = {Reading, Mass.},
  langid       = {english},
  langidopts   = {variant=american},
  sorttitle    = {Computers & Typesetting},
  indexsorttitle= {Computers & Typesetting},
  annotation   = {A five-volume book cited as a whole. This is a \texttt{mvbook}
                  entry, note the \texttt{volumes} field},
}

@book{knuth:ct:a,
  author       = {Knuth, Donald E.},
  title        = {The {\TeX book}},
  date         = 1984,
  maintitle    = {Computers \& Typesetting},
  volume       = {A},
  publisher    = {Addison-Wesley},
  location     = {Reading, Mass.},
  langid       = {english},
  langidopts   = {variant=american},
  sorttitle    = {Computers & Typesetting A},
  indexsorttitle= {The TeXbook},
  indextitle   = {\protect\TeX book, The},
  shorttitle   = {\TeX book},
  annotation   = {The first volume of a five-volume book. Note the
                  \texttt{sorttitle} field. We want this
                  volume to be listed after the entry referring to the entire
                  five-volume set. Also note the \texttt{indextitle} and
                  \texttt{indexsorttitle} fields. Indexing packages that don't
                  generate robust index entries require some control sequences
                  to be protected from expansion},
}

@book{knuth:ct:b,
  author       = {Knuth, Donald E.},
  title        = {{\TeX}: The Program},
  date         = 1986,
  maintitle    = {Computers \& Typesetting},
  volume       = {B},
  publisher    = {Addison-Wesley},
  location     = {Reading, Mass.},
  langid       = {english},
  langidopts   = {variant=american},
  sorttitle    = {Computers & Typesetting B},
  indexsorttitle= {TeX: The Program},
  shorttitle   = {\TeX},
  annotation   = {The second volume of a five-volume book. Note the
                  \texttt{sorttitle} field. Also note the
                  \texttt{indexsorttitle} field},
}

@book{knuth:ct:c,
  author       = {Knuth, Donald E.},
  title        = {The {METAFONTbook}},
  date         = 1986,
  maintitle    = {Computers \& Typesetting},
  volume       = {C},
  publisher    = {Addison-Wesley},
  location     = {Reading, Mass.},
  langid       = {english},
  langidopts   = {variant=american},
  sorttitle    = {Computers & Typesetting C},
  indextitle   = {METAFONTbook, The},
  shorttitle   = {METAFONTbook},
  annotation   = {The third volume of a five-volume book. Note the
                  \texttt{sorttitle} field as well as the
                  \texttt{indextitle} field},
}

@book{knuth:ct:d,
  author       = {Knuth, Donald E.},
  title        = {{METAFONT}: The Program},
  date         = 1986,
  maintitle    = {Computers \& Typesetting},
  volume       = {D},
  publisher    = {Addison-Wesley},
  location     = {Reading, Mass.},
  langid       = {english},
  langidopts   = {variant=american},
  sorttitle    = {Computers & Typesetting D},
  shorttitle   = {METAFONT},
  annotation   = {The fourth volume of a five-volume book. Note the
                  \texttt{sorttitle} field},
}

@book{knuth:ct:e,
  author       = {Knuth, Donald E.},
  title        = {{Computer Modern} Typefaces},
  date         = 1986,
  maintitle    = {Computers \& Typesetting},
  volume       = {E},
  publisher    = {Addison-Wesley},
  location     = {Reading, Mass.},
  langid       = {english},
  langidopts   = {variant=american},
  sorttitle    = {Computers & Typesetting E},
  annotation   = {The fifth volume of a five-volume book. Note the
                  \texttt{sorttitle} field},
}

@mvbook{knuth:ct:related,
  author       = {Knuth, Donald E.},
  title        = {Computers \& Typesetting},
  date         = {1984/1986},
  volumes      = 5,
  publisher    = {Addison-Wesley},
  location     = {Reading, Mass.},
  langid       = {english},
  langidopts   = {variant=american},
  sorttitle    = {Computers & Typesetting},
  indexsorttitle= {Computers & Typesetting},
  related      = {knuth:ct:a,knuth:ct:b,knuth:ct:c,knuth:ct:d,knuth:ct:e},
  relatedtype  = {multivolume},
  annotation   = {A five-volume book cited as a whole and related to its
                  individual volumes. Note the \texttt{related} and
                  \texttt{relatedtype} fields},
}

@book{kullback,
  author       = {Kullback, Solomon},
  title        = {Information Theory and Statistics},
  year         = 1959,
  publisher    = {John Wiley \& Sons},
  location     = {New York},
  langid       = {english},
  langidopts   = {variant=american},
}

@book{kullback:reprint,
  author       = {Kullback, Solomon},
  title        = {Information Theory and Statistics},
  year         = 1997,
  publisher    = {Dover Publications},
  location     = {New York},
  origyear     = 1959,
  origpublisher= {John Wiley \& Sons},
  langid       = {english},
  langidopts   = {variant=american},
  annotation   = {A reprint of the \texttt{kullback} entry. Note the format of
                  \texttt{origyear} and \texttt{origpublisher}. These fields are
                  not used by the standard bibliography styles},
}

@book{kullback:related,
  author       = {Kullback, Solomon},
  title        = {Information Theory and Statistics},
  year         = 1997,
  publisher    = {Dover Publications},
  location     = {New York},
  langid       = {english},
  langidopts   = {variant=american},
  related      = {kullback},
  relatedtype  = {origpubin},
  annotation   = {A reprint of the \texttt{kullback} entry. Note the format of
                  the \texttt{related} and \texttt{relatedtype} fields},
}

@book{malinowski,
  author       = {Malinowski, Bronis{\l}aw},
  title        = {Argonauts of the {Western Pacific}},
  date         = 1972,
  edition      = 8,
  publisher    = {Routledge {and} Kegan Paul},
  location     = {London},
  langid       = {english},
  langidopts   = {variant=british},
  subtitle     = {An account of native enterprise and adventure in the
                  Archipelagoes of {Melanesian New Guinea}},
  shorttitle   = {Argonauts},
  annotation   = {This is a \texttt{book} entry. Note the format of the
                  \texttt{publisher} and \texttt{edition} fields as well as the
                  \texttt{subtitle} field},
}

@book{maron,
  author       = {Maron, Monika},
  title        = {Animal Triste},
  date         = 2000,
  translator   = {Brigitte Goldstein},
  origlanguage = {german},
  publisher    = {University of Nebraska Press},
  location     = {Lincoln},
  langid       = {english},
  langidopts   = {variant=american},
  shorttitle   = {Animal Triste},
  annotation   = {An English translation of a German novel with a French title.
                  In other words: a \texttt{book} entry with a
                  \texttt{translator} field.  Note the \texttt{origlanguage}
                  field which is concatenated with the \texttt{translator}},
}

@book{massa,
  author       = {Werner Massa},
  title        = {Crystal structure determination},
  date         = 2004,
  edition      = 2,
  publisher    = {Spinger},
  location     = {Berlin},
  langid       = {english},
  langidopts   = {variant=british},
  annotation   = {A \texttt{book} entry with an \texttt{edition} field},
}

@article{moore,
  author       = {Moore, Gordon E.},
  title        = {Cramming more components onto integrated circuits},
  journaltitle = {Electronics},
  year         = 1965,
  volume       = 38,
  number       = 8,
  pages        = {114-117},
  langid       = {english},
  langidopts   = {variant=american},
}

@article{moore:related,
  author       = {Moore, Gordon E.},
  title        = {Cramming more components onto integrated circuits},
  journaltitle = {Proceedings of the {IEEE}},
  year         = 1998,
  volume       = 86,
  number       = 1,
  pages        = {82-85},
  langid       = {english},
  langidopts   = {variant=american},
  related      = {moore},
  relatedtype  = {reprintfrom},
  annotation   = {A reprint of Moore's law. Note the \texttt{related} and
                  \texttt{relatedtype} fields},
}

@mvbook{nietzsche:ksa,
  author       = {Nietzsche, Friedrich},
  title        = {S{\"a}mtliche Werke},
  date         = 1988,
  editor       = {Colli, Giorgio and Montinari, Mazzino},
  edition      = 2,
  volumes      = 15,
  publisher    = dtv # { and Walter de Gruyter},
  location     = {M{\"u}nchen and Berlin and New York},
  langid       = {german},
  sorttitle    = {Werke-00-000},
  indexsorttitle= {Samtliche Werke},
  subtitle     = {Kritische Studienausgabe},
  annotation   = {The critical edition of Nietzsche's works. This is a
                  \texttt{mvbook} entry referring to a 15-volume work as a
                  whole. Note the \texttt{volumes} field and the format of the
                  \texttt{publisher} and \texttt{location} fields in the
                  database file. Also note the \texttt{sorttitle} and
                  field which is used to fine-tune the
                  sorting order of the bibliography. We want this item listed
                  first in the bibliography},
}

@book{nietzsche:ksa1,
  author       = {Nietzsche, Friedrich},
  title        = {Die Geburt der Trag{\"o}die. Unzeitgem{\"a}{\ss}e
                  Betrachtungen I--IV. Nachgelassene Schriften 1870--1973},
  date         = 1988,
  editor       = {Colli, Giorgio and Montinari, Mazzino},
  maintitle    = {S{\"a}mtliche Werke},
  mainsubtitle = {Kritische Studienausgabe},
  volume       = 1,
  edition      = 2,
  publisher    = dtv # { and Walter de Gruyter},
  location     = {M{\"u}nchen and Berlin and New York},
  langid       = {german},
  sorttitle    = {Werke-01-000},
  indexsorttitle= {Samtliche Werke I},
  bookauthor   = {Nietzsche, Friedrich},
  indextitle   = {S{\"a}mtliche Werke I},
  shorttitle   = {S{\"a}mtliche Werke I},
  annotation   = {A single volume from the critical edition of Nietzsche's
                  works. This \texttt{book} entry explicitly refers to the first
                  volume only. Note the \texttt{title} and \texttt{maintitle}
                  fields. Also note the \texttt{sorttitle} 
                  field. We want this entry to be listed after the entry
                  referring to the entire edition},
}

@book{nussbaum,
  author       = {Nussbaum, Martha},
  title        = {Aristotle's \mkbibquote{De Motu Animalium}},
  date         = 1978,
  publisher    = pup,
  location     = {Princeton},
  keywords     = {secondary},
  langid       = {english},
  langidopts   = {variant=american},
  sorttitle    = {Aristotle's De Motu Animalium},
  indexsorttitle= {Aristotle's De Motu Animalium},
  annotation   = {A \texttt{book} entry. Note the \texttt{sorttitle} and
                  \texttt{indexsorttitle} fields and the markup of the quotes in
                  the database file},
}

@book{piccato,
  author       = {Piccato, Pablo},
  title        = {City of Suspects},
  date         = 2001,
  publisher    = {Duke University Press},
  location     = {Durham and London},
  langid       = {english},
  langidopts   = {variant=american},
  subtitle     = {Crime in {Mexico City}, 1900--1931},
  shorttitle   = {City of Suspects},
  annotation   = {This is a \texttt{book} entry. Note the format of the
                  \texttt{location} field in the database file},
}

@book{vangennep,
  author       = {van Gennep, Arnold},
  title        = {Les rites de passage},
  date         = 1909,
  publisher    = {Nourry},
  location     = {Paris},
  options      = {useprefix},
  langid       = {french},
  sorttitle    = {Rites de passage},
  indextitle   = {Rites de passage, Les},
  shorttitle   = {Rites de passage},
  annotation   = {A \texttt{book} entry. Note the format of the printed name and
                  compare the \texttt{useprefix} option in the \texttt{options}
                  field as well as \texttt{brandt} and \texttt{geer}},
}

@book{vangennep:trans,
  author       = {van Gennep, Arnold},
  title        = {The Rites of Passage},
  year         = 1960,
  translator   = {Vizedom, Monika B. and Caffee, Gabrielle L.},
  language     = {english},
  origlanguage = {french},
  publisher    = {University of Chicago Press},
  options      = {useprefix},
  indextitle   = {Rites of Passage, The},
  sorttitle    = {Rites of Passage},
  shorttitle   = {Rites of Passage},
  langid       = {english},
  langidopts   = {variant=american},
  annotation   = {A translation of the \texttt{vangennep} entry. Note the
                  \texttt{translator} and \texttt{origlanguage} fields. Compare
                  with the \texttt{vangennep:related} entry.},
}

@book{vangennep:related,
  author       = {van Gennep, Arnold},
  title        = {Les rites de passage},
  date         = 1909,
  publisher    = {Nourry},
  location     = {Paris},
  options      = {useprefix},
  langid       = {french},
  related      = {vizedom:related},
  relatedtype  = {bytranslator},
  sorttitle    = {Rites de passage},
  indextitle   = {Rites de passage, Les},
  shorttitle   = {Rites de passage},
  annotation   = {A variant of the \texttt{vangennep} entry related to its
                  translation. Note the format of the \texttt{related} and
                  \texttt{relatedtype} fields},
}

@book{vizedom:related,
  title        = {The Rites of Passage},
  year         = 1960,
  translator   = {Vizedom, Monika B. and Caffee, Gabrielle L.},
  language     = {english},
  publisher    = {University of Chicago Press},
  langid       = {english},
  langidopts   = {variant=american},
  options      = {usetranslator},
  related      = {vangennep},
  relatedtype  = {translationof},
  indextitle   = {Rites of Passage, The},
  sorttitle    = {Rites of Passage},
  shorttitle   = {Rites of Passage},
  annotation   = {A translated work from \texttt{vangennep}. Note the format of
                  the \texttt{related} and \texttt{relatedtype} fields},
}

@mvbook{vazques-de-parga,
  author       = {V{\'a}zques{ de }Parga, Luis and Lacarra, Jos{\'e} Mar{\'i}a
                  and Ur{\'i}a R{\'i}u, Juan},
  title        = {Las Peregrinaciones a Santiago de Compostela},
  date         = 1993,
  volumes      = 3,
  note         = {Ed. facs. de la realizada en 1948--49},
  publisher    = {Iberdrola},
  location     = {Pamplona},
  langid       = {spanish},
  sorttitle    = {Peregrinaciones a Santiago de Compostela},
  indextitle   = {Peregrinaciones a Santiago de Compostela, Las},
  shorttitle   = {Peregrinaciones},
  annotation   = {A multivolume book cited as a whole. This is a \texttt{mvbook}
                  entry with \texttt{volumes}, \texttt{note},
                  \texttt{sorttitle}, and \texttt{indextitle} fields},
}

@book{wilde,
  author       = {Wilde, Oscar},
  title        = {The Importance of Being Earnest: A Trivial Comedy for Serious
                  People},
  year         = 1899,
  series       = {English and {American} drama of the Nineteenth Century},
  publisher    = {Leonard Smithers {and} Company},
  eprint       = {4HIWAAAAYAAJ},
  eprinttype   = {googlebooks},
  annotation   = {A \texttt{book} with \texttt{eprint} and \texttt{eprinttype}
                  fields.},
}

@book{worman,
  author       = {Worman, Nancy},
  title        = {The Cast of Character},
  date         = 2002,
  publisher    = {University of Texas Press},
  location     = {Austin},
  langid       = {english},
  langidopts   = {variant=american},
  sorttitle    = {Cast of Character},
  indextitle   = {Cast of Character, The},
  subtitle     = {Style in {Greek} Literature},
  shorttitle   = {Cast of Character},
  annotation   = {A \texttt{book} entry. Note the \texttt{sorttitle} and
                  \texttt{indextitle} fields},
}

@mvcollection{britannica,
  editor       = {Preece, Warren E.},
  title        = {The {New Encyclop{\ae}dia Britannica}},
  date         = 2003,
  edition      = 15,
  volumes      = 32,
  publisher    = {Encyclop{\ae}dia Britannica},
  location     = {Chicago, Ill.},
  options      = {useeditor=false},
  label        = {EB},
  langid       = {english},
  langidopts   = {variant=british},
  sorttitle    = {Encyclop{\ae}dia Britannica},
  indextitle   = {{Encyclop{\ae}dia Britannica}, The {New}},
  shorttitle   = {{Encyclop{\ae}dia Britannica}},
  annotation   = {This is a \texttt{mvcollection} entry for an encyclopedia. Note
                  the \texttt{useeditor} option in the \texttt{options} field as
                  well as the \texttt{sorttitle} field. We want this entry to be
                  cited and alphabetized by title even though there is an
                  editor. In addition to that, we want the title to be
                  alphabetized under \enquote*{E} rather than \enquote*{T}. Also
                  note the \texttt{label} field which is provided for
                  author-year citation styles},
}

@collection{gaonkar,
  editor       = {Gaonkar, Dilip Parameshwar},
  title        = {Alternative Modernities},
  date         = 2001,
  publisher    = {Duke University Press},
  location     = {Durham and London},
  isbn         = {0-822-32714-7},
  langid       = {english},
  langidopts   = {variant=american},
  annotation   = {This is a \texttt{collection} entry. Note the format of the
                  \texttt{location} field in the database file as well as the
                  \texttt{isbn} field},
}

@InCollection{gaonkar:in,
  author       = {Gaonkar, Dilip Parameshwar},
  editor       = {Gaonkar, Dilip Parameshwar},
  title        = {On Alternative Modernities},
  date         = 2001,
  booktitle    = {Alternative Modernities},
  publisher    = {Duke University Press},
  location     = {Durham and London},
  isbn         = {0-822-32714-7},
  pages        = {1-23},
}

@mvcollection{jaffe,
  editor       = {Jaff{\'e}, Philipp},
  title        = {Regesta Pontificum Romanorum ab condita ecclesia ad annum post
                  Christum natum \textsc{mcxcviii}},
  date         = {1885/1888},
  editora      = {Loewenfeld, Samuel and Kaltenbrunner, Ferdinand and Ewald,
                  Paul},
  edition      = 2,
  volumes      = 2,
  location     = {Leipzig},
  langid       = {latin},
  editoratype  = {redactor},
  indextitle   = {Regesta Pontificum Romanorum},
  shorttitle   = {Regesta Pontificum Romanorum},
  annotation   = {A \texttt{mvcollection} entry with \texttt{edition} and
                  \texttt{volumes} fields. Note the \texttt{editora} and
                  \texttt{editoratype} fields},
}

@collection{westfahl:frontier,
  editor       = {Westfahl, Gary},
  title        = {Space and Beyond},
  date         = 2000,
  subtitle     = {The Frontier Theme in Science Fiction},
  publisher    = {Greenwood},
  location     = {Westport, Conn. and London},
  langid       = {english},
  langidopts   = {variant=american},
  booktitle    = {Space and Beyond},
  booksubtitle = {The Frontier Theme in Science Fiction},
  annotation   = {This is a \texttt{collection} entry. Note the format of the
                  \texttt{location} field as well as the \texttt{subtitle} and
                  \texttt{booksubtitle} fields},
}

@inbook{kant:kpv,
  title        = {Kritik der praktischen Vernunft},
  date         = 1968,
  author       = {Kant, Immanuel},
  booktitle    = {Kritik der praktischen Vernunft. Kritik der Urtheilskraft},
  bookauthor   = {Kant, Immanuel},
  maintitle    = {Kants Werke. Akademie Textausgabe},
  volume       = 5,
  publisher    = {Walter de Gruyter},
  location     = {Berlin},
  pages        = {1-163},
  shorthand    = {KpV},
  langid       = {german},
  shorttitle   = {Kritik der praktischen Vernunft},
  annotation   = {An edition of Kant's \emph{Collected Works}, volume five. This
                  is an \texttt{inbook} entry which explicitly refers to the
                  \emph{Critique of Practical Reason} only, not to the entire
                  fifth volume. Note the \texttt{author} and \texttt{bookauthor}
                  fields in the database file. By default, the
                  \texttt{bookauthor} is omitted if the values of the
                  \texttt{author} and \texttt{bookauthor} fields are identical},
}

@inbook{kant:ku,
  title        = {Kritik der Urtheilskraft},
  date         = 1968,
  author       = {Kant, Immanuel},
  booktitle    = {Kritik der praktischen Vernunft. Kritik der Urtheilskraft},
  bookauthor   = {Kant, Immanuel},
  maintitle    = {Kants Werke. Akademie Textausgabe},
  volume       = 5,
  publisher    = {Walter de Gruyter},
  location     = {Berlin},
  pages        = {165-485},
  shorthand    = {KU},
  langid       = {german},
  annotation   = {An edition of Kant's \emph{Collected Works}, volume five. This
                  is an \texttt{inbook} entry which explicitly refers to the
                  \emph{Critique of Judgment} only, not to the entire fifth
                  volume},
}

@inbook{nietzsche:historie,
  title        = {Unzeitgem{\"a}sse Betrachtungen. Zweites St{\"u}ck},
  date         = 1988,
  author       = {Nietzsche, Friedrich},
  booktitle    = {Die Geburt der Trag{\"o}die. Unzeitgem{\"a}{\ss}e
                  Betrachtungen I--IV. Nachgelassene Schriften 1870--1973},
  bookauthor   = {Nietzsche, Friedrich},
  editor       = {Colli, Giorgio and Montinari, Mazzino},
  subtitle     = {Vom Nutzen und Nachtheil der Historie f{\"u}r das Leben},
  maintitle    = {S{\"a}mtliche Werke},
  mainsubtitle = {Kritische Studienausgabe},
  volume       = 1,
  publisher    = dtv # { and Walter de Gruyter},
  location     = {M{\"u}nchen and Berlin and New York},
  pages        = {243-334},
  langid       = {german},
  sorttitle    = {Werke-01-243},
  indexsorttitle= {Vom Nutzen und Nachtheil der Historie fur das Leben},
  indextitle   = {Vom Nutzen und Nachtheil der Historie f{\"u}r das Leben},
  shorttitle   = {Vom Nutzen und Nachtheil der Historie},
  annotation   = {A single essay from the critical edition of Nietzsche's works.
                  This \texttt{inbook} entry explicitly refers to an essay found
                  in the first volume. Note the \texttt{title},
                  \texttt{booktitle}, and \texttt{maintitle} fields. Also note
                  the \texttt{sorttitle} field. We want
                  this entry to be listed after the entry referring to the
                  entire first volume},
}

@incollection{brandt,
  author       = {von Brandt, Ahasver and Erich Hoffmann},
  editor       = {Ferdinand Seibt},
  title        = {Die nordischen L{\"a}nder von der Mitte des 11.~Jahrhunderts
                  bis 1448},
  date         = 1987,
  booktitle    = {Europa im Hoch- und Sp{\"a}tmittelalter},
  series       = {Handbuch der europ{\"a}ischen Geschichte},
  number       = 2,
  publisher    = {Klett-Cotta},
  location     = {Stuttgart},
  pages        = {884-917},
  options      = {useprefix=false},
  langid       = {german},
  indexsorttitle= {Nordischen Lander von der Mitte des 11. Jahrhunderts bis
                  1448},
  indextitle   = {Nordischen L{\"a}nder von der Mitte des 11.~Jahrhunderts bis
                  1448, Die},
  shorttitle   = {Die nordischen L{\"a}nder},
  annotation   = {An \texttt{incollection} entry with a \texttt{series} and a
                  \texttt{number}. Note the format of the printed name and
                  compare the \texttt{useprefix} option in the \texttt{options}
                  field as well as \texttt{vangennep}. Also note the
                  \texttt{indextitle, and \texttt{indexsorttitle} fields}},
}

@incollection{hyman,
  author       = {Arthur Hyman},
  editor       = {O'Meara, Dominic J.},
  title        = {Aristotle's Theory of the Intellect and its Interpretation by
                  {Averroes}},
  date         = 1981,
  booktitle    = {Studies in {Aristotle}},
  series       = {Studies in Philosophy and the History of Philosophy},
  number       = 9,
  publisher    = {The Catholic University of America Press},
  location     = {Washington, D.C.},
  pages        = {161-191},
  keywords     = {secondary},
  langid       = {english},
  langidopts   = {variant=american},
  indextitle   = {Aristotle's Theory of the Intellect},
  shorttitle   = {Aristotle's Theory of the Intellect},
  annotation   = {An \texttt{incollection} entry with a \texttt{series} and
                  \texttt{number} field},
}

@incollection{pines,
  author       = {Pines, Shlomo},
  editor       = {Twersky, Isadore},
  title        = {The Limitations of Human Knowledge According to {Al-Farabi}, {ibn
                  Bajja}, and {Maimonides}},
  date         = 1979,
  booktitle    = {Studies in Medieval {Jewish} History and Literature},
  publisher    = hup,
  location     = {Cambridge, Mass.},
  pages        = {82-109},
  keywords     = {secondary},
  langid       = {english},
  langidopts   = {variant=american},
  indextitle   = {Limitations of Human Knowledge According to {Al-Farabi}, {ibn
                  Bajja}, and {Maimonides}, The},
  shorttitle   = {Limitations of Human Knowledge},
  annotation   = {A typical \texttt{incollection} entry. Note the
                  \texttt{indextitle} field},
}

@inproceedings{moraux,
  author       = {Moraux, Paul},
  editor       = {Lloyd, G. E. R. and Owen, G. E. L.},
  title        = {Le \emph{De Anima} dans la tradition gr{\`e}cque},
  date         = 1979,
  booktitle    = {Aristotle on Mind and the Senses},
  subtitle     = {Quelques aspects de l'interpretation du trait{\'e}, de
                  Theophraste {\`a} Themistius},
  booktitleaddon= {Proceedings of the Seventh Symposium Aristotelicum},
  eventdate    = 1975,
  publisher    = cup,
  location     = {Cambridge},
  pages        = {281-324},
  keywords     = {secondary},
  langid       = {french},
  indexsorttitle= {De Anima dans la tradition grecque},
  indextitle   = {\emph{De Anima} dans la tradition gr{\`e}cque, Le},
  shorttitle   = {\emph{De Anima} dans la tradition gr{\`e}cque},
  annotation   = {This is a typical \texttt{inproceedings} entry. Note the
                  \texttt{booksubtitle}, \texttt{shorttitle},
                  \texttt{indextitle}, and \texttt{indexsorttitle} fields. Also
                  note the \texttt{eventdate} field.},
}

@inproceedings{salam,
  author       = {Salam, Abdus},
  editor       = {Svartholm, Nils},
  title        = {Weak and Electromagnetic Interactions},
  date         = 1968,
  booktitle    = {Elementary particle theory},
  booksubtitle = {Relativistic groups and analyticity},
  booktitleaddon= {Proceedings of the {Eighth Nobel Symposium}},
  eventdate    = {1968-05-19/1968-05-25},
  venue        = {Aspen{\"a}sgarden, Lerum},
  publisher    = {Almquist \& Wiksell},
  location     = {Stockholm},
  pages        = {367-377},
}

@manual{cms,
  title        = {The {Chicago} Manual of Style},
  date         = 2003,
  subtitle     = {The Essential Guide for Writers, Editors, and Publishers},
  edition      = 15,
  publisher    = {University of Chicago Press},
  location     = {Chicago, Ill.},
  isbn         = {0-226-10403-6},
  label        = {CMS},
  langid       = {english},
  langidopts   = {variant=american},
  sorttitle    = {Chicago Manual of Style},
  indextitle   = {Chicago Manual of Style, The},
  shorttitle   = {Chicago Manual of Style},
  annotation   = {This is a \texttt{manual} entry without an \texttt{author} or
                  \texttt{editor}. Note the \texttt{label} field in the database
                  file which is provided for author-year citation styles. Also
                  note the \texttt{sorttitle} and \texttt{indextitle} fields. By
                  default, all entries without an \texttt{author} or
                  \texttt{editor} are alphabetized by \texttt{title} but we want
                  this entry to be alphabetized under \enquote*{C} rather than
                  \enquote*{T}. There's also an \texttt{isbn} field},
}

@online{baez/online,
  author       = {Baez, John C. and Lauda, Aaron D.},
  title        = {Higher-Dimensional Algebra {V}: 2-Groups},
  date         = {2004-10-27},
  version      = 3,
  langid       = {english},
  langidopts   = {variant=american},
  eprinttype   = {arxiv},
  eprint       = {math/0307200v3},
  annotation   = {An \texttt{online} reference from arXiv. Note the
                  \texttt{eprint} and \texttt{eprinttype} fields. Compare
                  \texttt{baez\slash article} which is the same item given as an
                  \texttt{article} entry with eprint information},
}

@online{ctan,
  title        = {CTAN},
  date         = 2006,
  url          = {http://www.ctan.org},
  subtitle     = {The {Comprehensive TeX Archive Network}},
  urldate      = {2006-10-01},
  label        = {CTAN},
  langid       = {english},
  langidopts   = {variant=american},
  annotation   = {This is an \texttt{online} entry. The \textsc{url}, which is
                  given in the \texttt{url} field, is transformed into a
                  clickable link if \texttt{hyperref} support has been
                  enabled. Note the format of the \texttt{urldate} field
                  (\texttt{yyyy-mm-dd}) in the database file. Also note the
                  \texttt{label} field which may be used as a fallback by
                  citation styles which need an \texttt{author} and\slash or a
                  \texttt{year}},
}

@online{itzhaki,
  author       = {Itzhaki, Nissan},
  title        = {Some remarks on {'t Hooft's} {S}-matrix for black holes},
  date         = {1996-03-11},
  version      = 1,
  langid       = {english},
  langidopts   = {variant=american},
  eprinttype   = {arxiv},
  eprint       = {hep-th/9603067},
  annotation   = {An \texttt{online} reference from arXiv. Note the
                  \texttt{eprint} and \texttt{eprinttype} fields. Also note that
                  the arXiv reference is transformed into a clickable link if
                  \texttt{hyperref} support has been enabled},
  abstract     = {We discuss the limitations of 't Hooft's proposal for the
                  black hole S-matrix. We find that the validity of the S-matrix
                  implies violation of the semi-classical approximation at
                  scales large compared to the Planck scale. We also show that
                  the effect of the centrifugal barrier on the S-matrix is
                  crucial even for large transverse distances.},
}

@online{markey,
  author       = {Markey, Nicolas},
  title        = {Tame the {BeaST}},
  date         = {2005-10-16},
  url          = {http://mirror.ctan.org/info/bibtex/tamethebeast/ttb_en.pdf},
  subtitle     = {The {B} to {X} of {BibTeX}},
  version      = {1.3},
  urldate      = {2006-10-01},
  langid       = {english},
  langidopts   = {variant=american},
  sorttitle    = {Tame the Beast},
  annotation   = {An \texttt{online} entry for a tutorial. Note the format of
                  the \texttt{date} field (\texttt{yyyy-mm-dd}) in the database
                  file.},
}

@online{wassenberg,
  author       = {Wassenberg, Jan and Sanders, Peter},
  title        = {Faster Radix Sort via Virtual Memory and Write-Combining},
  date         = {2010-08-17},
  version      = 1,
  langid       = {english},
  langidopts   = {variant=american},
  eprinttype   = {arxiv},
  eprintclass  = {cs.DS},
  eprint       = {1008.2849v1},
  annotation   = {A recent \texttt{online} reference from arXiv using the new
                  (April 2007 onward) identifier format. Note the
                  \texttt{eprint}, \texttt{eprinttype}, and \texttt{eprintclass}
                  fields. Also note that the arXiv reference is transformed into
                  a clickable link if \texttt{hyperref} support has been
                  enabled},
  abstract     = {Sorting algorithms are the deciding factor for the performance
                  of common operations such as removal of duplicates or database
                  sort-merge joins. This work focuses on 32-bit integer keys,
                  optionally paired with a 32-bit value. We present a fast radix
                  sorting algorithm that builds upon a microarchitecture-aware
                  variant of counting sort},
}

@patent{almendro,
  author       = {Almendro, Jos{\'e} L. and Mart{\'i}n, Jacinto and S{\'a}nchez,
                  Alberto and Nozal, Fernando},
  title        = {Elektromagnetisches Signalhorn},
  number       = {EU-29702195U},
  date         = 1998,
  location     = {countryfr and countryuk and countryde},
  langid       = {german},
  annotation   = {This is a \texttt{patent} entry with a \texttt{location}
                  field. The number is given in the \texttt{number} field. Note
                  the format of the \texttt{location} field in the database
                  file. Compare \texttt{laufenberg}, \texttt{sorace}, and
                  \texttt{kowalik}},
}

@patent{kowalik,
  author       = {Kowalik, F. and Isard, M.},
  title        = {Estimateur d'un d{\'e}faut de fonctionnement d'un modulateur
                  en quadrature et {\'e}tage de modulation l'utilisant},
  number       = 9500261,
  date         = {1995-01-11},
  type         = {patreqfr},
  langid       = {french},
  indextitle   = {Estimateur d'un d{\'e}faut de fonctionnement},
  annotation   = {This is a \texttt{patent} entry for a French patent request
                  with a full date. The number is given in the \texttt{number}
                  field. Note the format of the \texttt{type} and \texttt{date}
                  fields in the database file. Compare \texttt{almendro},
                  \texttt{laufenberg}, and \texttt{sorace}},
}

@patent{laufenberg,
  author       = {Laufenberg, Xaver and Eynius, Dominique and Suelzle, Helmut
                  and Usbeck, Stephan and Spaeth, Matthias and Neuser-Hoffmann,
                  Miriam and Myrzik, Christian and Schmid, Manfred and Nietfeld,
                  Franz and Thiel, Alexander and Braun, Harald and Ebner,
                  Norbert},
  title        = {Elektrische Einrichtung und Betriebsverfahren},
  number       = 1700367,
  date         = {2006-09-13},
  holder       = {{Robert Bosch GmbH} and {Daimler Chrysler AG} and {Bayerische
                  Motoren Werke AG}},
  type         = {patenteu},
  langid       = {german},
  annotation   = {This is a \texttt{patent} entry with a \texttt{holder} field.
                  Note the format of the \texttt{type} and \texttt{location}
                  fields in the database file. Compare \texttt{almendro},
                  \texttt{sorace}, and \texttt{kowalik}},
  abstract     = {The invention relates to an electric device comprising a
                  generator, in particular for use in the vehicle electric
                  system of a motor vehicle and a controller for controlling the
                  generator voltage. The device is equipped with a control zone,
                  in which the voltage is controlled and zones, in which the
                  torque is controlled. The invention also relates to methods
                  for operating a device of this type.},
  file         = {http://v3.espacenet.com/textdoc?IDX=EP1700367},
}

@patent{sorace,
  author       = {Sorace, Ronald E. and Reinhardt, Victor S. and Vaughn, Steven
                  A.},
  title        = {High-Speed Digital-to-{RF} Converter},
  number       = 5668842,
  date         = {1997-09-16},
  holder       = {{Hughes Aircraft Company}},
  type         = {patentus},
  langid       = {english},
  langidopts   = {variant=american},
  annotation   = {This is a \texttt{patent} entry with a \texttt{holder} field.
                  Note the format of the \texttt{type} and \texttt{date} fields
                  in the database file. Compare \texttt{almendro},
                  \texttt{laufenberg}, and \texttt{kowalik}},
}

@periodical{jcg,
  title        = {Computers and Graphics},
  year         = 2011,
  issuetitle   = {Semantic {3D} Media and Content},
  volume       = 35,
  number       = 4,
  issn         = {0097-8493},
  annotation   = {This is a \texttt{periodical} entry with an \texttt{issn}
                  field.},
}

@report{chiu,
  author       = {Chiu, Willy W. and Chow, We Min},
  title        = {A Hybrid Hierarchical Model of a {Multiple Virtual Storage}
                  ({MVS}) Operating System},
  type         = {resreport},
  institution  = {IBM},
  date         = 1978,
  number       = {RC-6947},
  langid       = {english},
  langidopts   = {variant=american},
  sorttitle    = {Hybrid Hierarchical Model of a Multiple Virtual Storage (MVS)
                  Operating System},
  indextitle   = {Hybrid Hierarchical Model, A},
  annotation   = {This is a \texttt{report} entry for a research report. Note
                  the format of the \texttt{type} field in the database file
                  which uses a localization key. The number of the report is
                  given in the \texttt{number} field. Also note the
                  \texttt{sorttitle} and \texttt{indextitle} fields},
}

@report{padhye,
  author       = {Padhye, Jitendra and Firoiu, Victor and Towsley, Don},
  title        = {A Stochastic Model of {TCP Reno} Congestion Avoidance and
                  Control},
  type         = {techreport},
  institution  = {University of Massachusetts},
  date         = 1999,
  number       = {99-02},
  location     = {Amherst, Mass.},
  langid       = {english},
  langidopts   = {variant=american},
  sorttitle    = {A Stochastic Model of TCP Reno Congestion Avoidance and
                  Control},
  indextitle   = {Stochastic Model of {TCP Reno} Congestion Avoidance and Control,
                  A},
  annotation   = {This is a \texttt{report} entry for a technical report. Note
                  the format of the \texttt{type} field in the database file
                  which uses a localization key. The number of the report is
                  given in the \texttt{number} field. Also note the
                  \texttt{sorttitle} and \texttt{indextitle} fields},
  abstract     = {The steady state performance of a bulk transfer TCP flow
                  (i.e. a flow with a large amount of data to send, such as FTP
                  transfers) may be characterized by three quantities. The first
                  is the send rate, which is the amount of data sent by the
                  sender in unit time. The second is the throughput, which is
                  the amount of data received by the receiver in unit time. Note
                  that the throughput will always be less than or equal to the
                  send rate due to losses. Finally, the number of non-duplicate
                  packets received by the receiver in unit time gives us the
                  goodput of the connection. The goodput is always less than or
                  equal to the throughput, since the receiver may receive two
                  copies of the same packet due to retransmissions by the
                  sender. In a previous paper, we presented a simple model for
                  predicting the steady state send rate of a bulk transfer TCP
                  flow as a function of loss rate and round trip time. In this
                  paper, we extend that work in two ways. First, we analyze the
                  performance of bulk transfer TCP flows using more precise,
                  stochastic analysis. Second, we build upon the previous
                  analysis to provide both an approximate formula as well as a
                  more accurate stochastic model for the steady state throughput
                  of a bulk transfer TCP flow.},
  file         = {ftp://gaia.cs.umass.edu/pub/Padhey99-markov.ps},
}

@thesis{geer,
  author       = {de Geer, Ingrid},
  title        = {Earl, Saint, Bishop, Skald~-- and Music},
  type         = {phdthesis},
  institution  = {Uppsala Universitet},
  date         = 1985,
  subtitle     = {The {Orkney Earldom} of the Twelfth Century. {A} Musicological
                  Study},
  location     = {Uppsala},
  options      = {useprefix=false},
  langid       = {english},
  langidopts   = {variant=british},
  annotation   = {This is a typical \texttt{thesis} entry for a PhD thesis. Note
                  the \texttt{type} field in the database file which uses a
                  localization key. Also note the format of the printed name and
                  compare the \texttt{useprefix} option in the \texttt{options}
                  field as well as \texttt{vangennep}},
}

@thesis{loh,
  author       = {Loh, Nin C.},
  title        = {High-Resolution Micromachined Interferometric Accelerometer},
  type         = {mathesis},
  institution  = {Massachusetts Institute of Technology},
  date         = 1992,
  location     = {Cambridge, Mass.},
  langid       = {english},
  langidopts   = {variant=american},
  annotation   = {This is a typical \texttt{thesis} entry for an MA thesis. Note
                  the \texttt{type} field in the database file which uses a
                  localization key},
}{% endraw %}
```

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/prism/1.19.0/themes/prism-okaidia.min.css"
      integrity="sha512-pGi87NmT0VeSbmZBK40y3wF4H2DlpCYc5lrO/3F/RPhnwn262NReW3jFtG2iZWhbpoWT5MDzBzawpOri+jcUTw==" crossorigin="anonymous" />

<script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.19.0/prism.min.js"
        integrity="sha512-9ndS8HgVHWQq2A/kpIxygbIZQ7oljc9/AvoEv8SQDy192nAuCGSdk7OdAfCZLDkbRJLZMsrV0NXycMSLLNTWCw==" crossorigin="anonymous">
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.19.0/plugins/autolinker/prism-autolinker.min.js"
        integrity="sha512-/uypNVmpEQdCQLYz3mq7J2HPBpHkkg23FV4i7/WSUyEuTJrWJ2uZ3gXx1IBPUyB3qbIAY+AODbanXLkIar0NBQ==" crossorigin="anonymous">
</script>

<script src="https://cdn.jsdelivr.net/npm/prismjs-bibtex@2.1.0/prism-bibtex.js"
        integrity="sha256-A5GMUmGHpY8mVpfcaRLQFeHtmdjZLumKBOMpf81FXX0="
        crossorigin="anonymous" referrerpolicy="no-referrer">
</script>
